<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");

if ($output_participation['participation_permission'] & $library_config['resource']['user']['manage_participants']) {
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
	$user->file = $file;
	
	
	if (isset($_POST['update_user_participation'])) {
	
		if (isset($_POST['permission']['user'])) {
			$permission_count = "0";
					
			foreach ($_POST['permission']['user'] as $key => $i):
				$permission_count = $permission_count+$i;
			endforeach;
					
			$_POST['participation_permission'] = $permission_count;
		}
		
		$participation->user_id = $_POST['user_id'];
		
		$participation->updateParticipant($_POST);
		
		unset($_REQUEST['status_id'], $_REQUEST['role_id']);
		
	}
	elseif (isset($_REQUEST['set_default_user_permission'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_library_set 
			WHERE 
			set_id=" . $output_set['set_id']
		;
		
		$result = $db->Execute($query);
			
		if (isset($result->fields)) {
			$rec = array();
			if (isset($_POST['permission']['user'])) {
				$permission_count = "0";
					
				foreach ($_POST['permission']['user'] as $key => $i):
					$permission_count = $permission_count+$i;
				endforeach;
					
				$rec['default_user_permission'] = $permission_count;
				
				$output_set['default_user_permission'] = $permission_count;
				$body->set('set', $output_set);
			}
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}
	elseif (isset($_POST['sub_set_hold'])) {
		$participation->setUserStatus($_POST['identity_ids'], $library_config['user']['status']['hold']);
		$_REQUEST['status_id'] = $library_config['user']['status']['hold'];
	}
	elseif (isset($_POST['sub_set_barred'])) {
		$participation->setUserStatus($_POST['identity_ids'], $library_config['user']['status']['barred']);
		$_REQUEST['status_id'] = $library_config['user']['status']['barred'];
	}
	elseif (isset($_POST['sub_set_active'])) {
		$participation->setUserStatus($_POST['identity_ids'], $library_config['user']['status']['active']);
		$_REQUEST['status_id'] = $library_config['user']['status']['active'];
	}
	
	if (isset($_REQUEST['status_id'])) {
		$output_participants = $participation->selParticipants($_REQUEST['status_id']);
	}
	elseif (isset($_REQUEST['role_id'])) {
		$output_participants = $participation->selParticipants(null, $_REQUEST['role_id']);
	}
	elseif (isset($_REQUEST['resource'])) {
		// selecting using bitflags is poor, so we select all and use PHP to filter
		$tmp_participants = $participation->selParticipants();
		
		if (!empty($tmp_participants)) {
			$output_participants = array();
			
			foreach ($tmp_participants as $key => $i):
				if ($_REQUEST['resource'] & intval($i['participation_permission'])) {
					array_push($output_participants, $i);
				}
			endforeach;
			
			$body->set('participants', $output_participants);
		}
		
	}
	elseif (isset($_REQUEST['identity_id'])) {
		$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
		
		if (!empty($output_participant)) {
			
			$output_participant['identity'] = $user->selUserIdentity(null, $output_participant['identity_id']);
			
			$body->set('participant', $output_participant);
			
			// if we are the wiki-set owner we select editors 
			if (($output_participant['user_id'] == $output_set['user_id']) && ($_SESSION['user_id'] == $output_set['user_id'])) { // set owner only
				
				$output_editors = $participation->selParticipants(null, $library_config['role']['editor']);
				
				if (!empty($output_editors)) {
					foreach ($output_editors as $key => $i):
						$user->identity_ids[] = $i['identity_id'];
					endforeach;
					
					$user->identity_ids = array_unique($user->identity_ids);
					
					if (!empty($user->identity_ids)) {
						$output_identities = $user->selUserIdentities();
						
						// we place the identities against the participants
						if (!empty($output_identities)) {
							foreach ($output_editors as $keyp => $p):
								foreach ($output_identities as $keyi => $i):
									if ($p['identity_id'] == $i['identity_id']) {
										$output_editors[$keyp]['identity'] = $i;
										break;
									}
								endforeach;
							endforeach;
						}
						
						$body->set('editors', $output_editors);
					}
				}
			}
			
		}
	}
	
	
	// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
	if (!empty($output_participants)) {
		// get their ids
		if (!empty($output_participants)) {
			foreach ($output_participants as $key => $i):
				$user->identity_ids[] = $i['identity_id'];
			endforeach;
			
			$user->identity_ids = array_unique($user->identity_ids);
			
			if (!empty($user->identity_ids)) {
				$output_identities = $user->selUserIdentities();
				
				// we place the identities against the participants
				if (!empty($output_identities)) {
					foreach ($output_participants as $keyp => $p):
						foreach ($output_identities as $keyi => $i):
							if ($p['identity_id'] == $i['identity_id']) {
								$output_participants[$keyp]['identity'] = $i;
								break;
							}
						endforeach;
					endforeach;
				}
				
				$body->set('participants', $output_participants);
			}
		}
	}
}
else { // we do not have permissions to be here
	header("Location: index.php?amn=lbr_page&page_id=" . $output_set['set_id'] . "&" . strip_tags(SID));
	exit;
}
	
	




/*
// OLD OLD --------------------------------------------

if (isset($_POST['my_participation_update'])) {
	// update my identity
	$query = "
		SELECT user_id, identity_id 
		FROM " . $db->prefix . "_participation 
		WHERE 
		item_id=" . $output_item['item_id'] . " AND 
		module_id=" . $output_item['module_id'] . " AND 
		user_id=" . $_SESSION['user_id']
	;
	
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$rec = array();
		
		if (!empty($_POST['identity_id'])) {
			$rec['identity_id'] = $_POST['identity_id'];
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$output_participation['identity_id'] = $_POST['identity_id'];
	}
}
elseif (isset($_POST['my_participation_withdraw'])) {
	// set my status to withdrawn

}
elseif (isset($_POST['update_user_participation'])) {
	
	$query = "
		SELECT user_id, status_id, identity_id, participation_permission, 
		participation_create_datetime, role_id 
		FROM " . $db->prefix . "_participation 
		WHERE 
		item_id=" . $output_item['item_id'] . " AND 
		module_id=" . $output_item['module_id'] . " AND 
		user_id=" . $_POST['user_id']
	;
	
	$result = $db->Execute($query);
		
	if (isset($result->fields)) {
		$rec = array();
		
		if (!empty($_POST['status_id'])) {
			$rec['status_id'] = $_POST['status_id'];
		}
		
		if ($_SESSION['user_id'] == $output_item['user_id']) {
			$rec['role_id'] = "null";
			
			if (!empty($_POST['editor'])) {
				$rec['role_id'] = $core_config['module_user']['role']['editor'];
			}
			
			if (isset($_POST['permission']['item_user'])) {
				$permission_count = "0";
				
				foreach ($_POST['permission']['item_user'] as $key => $i):
					$permission_count = $permission_count+$i;
				endforeach;
				
				$rec['participation_permission'] = $permission_count;
			}
		}
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);	
		
		$_REQUEST['identity_id'] = $_POST['user_identity_id'];
	
	}
}
elseif (isset($_POST['delete_relations'])) {
	$participation->deleteRelations($_POST['identity_ids'], $output_participation['identity_id']);
}
elseif (isset($_POST['sub_set_hold'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['hold']);
	unset($_REQUEST['identity_id']);
}
elseif (isset($_POST['sub_set_barred'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['barred']);
	unset($_REQUEST['identity_id']);
}
elseif (isset($_POST['sub_set_active'])) {
	$participation->setUserStatus($_POST['identity_ids'], $core_config['module_user']['status']['active']);
	unset($_REQUEST['identity_id']);
}



// CREATE SUMMARY --------------------------------------------------------
// if we can edit status we create a set of items per status, otherwise we summarise
if (isset($output_set['allow_user_manage'])) {
	foreach($library_config['user']['status'] as $key => $i):
		$tmp = $participation->countParticipants($i);
		$output_summary['status'][$i] = $tmp;
	endforeach;
}
else {
	$output_summary['status'][$library_config['user']['status']['active']] = $participation->countParticipants($library_config['user']['status']['active']);
}

// relations within item
$output_summary['relations'] = $participation->countRelations($output_participation['identity_id']);
$output_summary['editors'] = $participation->countParticipants(null, $library_config['role']['editor']);

$body->set('summary', $output_summary);



// SELECT PARTICIPANTS --------------------------------------------------------
$output_participants = $participation->selParticipants($library_config['user']['status']['active']);



// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
if (!empty($output_participants)) {
	// get their ids
	if (!empty($output_participants)) {
		foreach ($output_participants as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_participants as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_participants[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('participants', $output_participants);
		}
	}
}



// get user identities
$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
$body->set('identities', $output_identities);



// SELECT USER
if (isset($_REQUEST['identity_id']) && !empty($output_set['allow_user_manage'])) {
	$output_participant = $participation->selParticipation(null, $_REQUEST['identity_id']);
	
	if (!empty($output_participant)) {
		
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->user_id = $_SESSION['user_id'];
		$file->module_id = 0; // core
		$file->directory = "core";
		$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
		$user->file = $file;
		
		$output_participant['identity'] = $user->selUserIdentity(null, $output_participant['identity_id']);
		
		$body->set('participant', $output_participant);
		
		// if we are the group owner we select editors 
		if (($output_participant['user_id'] == $output_set['user_id']) && ($_SESSION['user_id'] == $output_set['user_id'])) { // set owner only
			
			$output_editors = $participation->selParticipants(null, $library_config['role']['editor']);
			
			if (!empty($output_editors)) {
				foreach ($output_editors as $key => $i):
					$user->identity_ids[] = $i['identity_id'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_editors as $keyp => $p):
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id'] == $i['identity_id']) {
									$output_editors[$keyp]['identity'] = $i;
									break;
								}
							endforeach;
						endforeach;
					}
					
					$body->set('editors', $output_editors);
				}
			}
		}
		
	}
}





// move to templates
$body->set('participation', $output_participation);
$body->set('set', $output_set);

$body->set("library_config", $library_config);
$body->set("module_prefix", $core_config['module'][4]['prefix']);

*/
?>
