<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['library'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];
$library->file = $file;

// get the latest revisions
$library->limit = 16;
$output_revisions = $library->selRevisions(null, 1);

if (!empty($output_revisions)) {
	$body->set('revisions', $output_revisions);
}

// get latest sets
$library->limit = 4;
$library->order_by = "set_create_datetime desc";
$output_sets = $library->selSets();

if (!empty($output_sets)) {
	$body->set('sets', $output_sets);
}

unset ($library->order_by, $library->limit);


// participation in wiki sets
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['library'];
	$participation->status_id = $library_config['user']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$library->set_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($library->set_ids)) {
			$output_my_sets = $library->selSets();
		}
		
		$body->set('my_sets', $output_my_sets);
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['library']);
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$library->page_ids[] = $i['inner_item_id'];
		endforeach;
		
		unset ($library->file);
		
		if (!empty($library->page_ids)) {
			$output_my_bookmarks = $library->selPages(null, 1);
		}
		
		$body->set('my_bookmarks', $output_my_bookmarks);
	}
	
	// REVISIONS FROM RESPECTED NETWORK
	unset($participation->item_id);
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	$output_respected_network = $participation->selRelations();
	
	if (!empty($output_respected_network)) {
		// add their identities
		foreach ($output_respected_network as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_respected_network as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						
						if ($p['identity_id'] == $i['identity_id']) {
							$output_respected_network[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
		}
		
		
		// get their latest revision
		foreach ($output_respected_network as $key => $i):
		
			$query = "
				SELECT r.revision_id, r.revision_id, lp.page_title, 
				r. revision_create_datetime, lp.page_id 
				FROM " . $db->prefix . "_library_revision r, " . $db->prefix . "_participation p, " . $db->prefix . "_library_page lp  
				WHERE 
				r.user_id=" . $i['identity']['user_id'] . " AND 
				p.module_id=4 AND
				p.identity_id=" . $i['identity']['identity_id'] . " AND 
				p.user_id=r.user_id AND
				lp.current_revision_id=r.revision_id 
				order by revision_create_datetime desc"
			;
			
			$result = $db->SelectLimit($query, 1);
	
			if (isset($result->fields)) {
				$output_respected_network[$key]['revision'] = $result->fields;
			}
		endforeach;
		
		$body->set('tied_revisions', $output_respected_network);
		
		// get latest comments from respected network
		require_once('components/core/class/Comment.class.php');
		$comment = new Comment($db, $core_config['module_id']['library']);
		$comment->module_id = $core_config['module_id']['library'];
		
		foreach ($output_respected_network as $key => $i):
			$comment->user_ids[] = $i['identity']['user_id'];
		endforeach;
		
		$comment->user_ids = array_unique($comment->user_ids);
		
		if (!empty($comment->user_ids)) {
			$comment->order_by = "c.comment_create_datetime desc";
			$comment->limit = 10;
			
			$output_tied_comments = $comment->selComments();
			
			// cut down comment body and apply identities
			if (!empty($output_identities)) {
				foreach ($output_tied_comments as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_tied_comments[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('tied_comments', $output_tied_comments);
		}
	}
}

?>
