<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="<?php echo $language_arr[0];?>" />
<meta name="keywords" content="<?php echo $lang['meta_keywords'];?>" />
<meta name="OriginalPublicationDate" content="<?php echo $lang['meta_OriginalPublicationDate'];?>" />
<meta name="Description" content="<?php echo $lang['meta_Description'];?>" />

<title><?php echo $lang['txt_page_title'];?></title>
<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_default.css);
-->
</style>
<!--[if IE]>
<style type="text/css">
@import url(<?php echo $template_path_core;?>css/aroundme_default-IE.css);
</style>
<![endif]-->

<?php
if (!empty($group['group_css'])) {
?>
<style type="text/css">
<!--
<?php echo $group['group_css'];?>


#wrapper {
		margin-right:auto; 
		margin-left:auto; 
		margin-top:0px;
		padding:0px;
		text-align:left;
		width:760px;
		height: 100%;
	}
	
	#layout {
		vertical-align:middle;
		position:relative;
		display:block;
		float:left;
		padding:6px;
	}
	
-->
</style>
<?php }?>

<?php
//we reload an image in this template just before the session times out to
//make sure that the session does not time out
$session_maxlifetime = ini_get('session.gc_maxlifetime'); // in seconds

// we need to warn 2 minutes before
$session_warning_time = 120; // seconds
if ($session_maxlifetime > $session_warning_time) {
	$session_maxlifetime = $session_maxlifetime-$session_warning_time;
}
$session_maxlifetime_ms = $session_maxlifetime*1000; // in milliseconds
?>


<script type="text/javascript" src="<?php echo $template_path_core;?>js/functions.js"></script>
<script type="text/javascript">
	var baseImgURL = '<?php echo $template_path_core;?>img/';
</script>


<script type="text/javascript">
var session_maxlifetime_ms = <?php echo $session_maxlifetime_ms;?>;

function ShowTimeoutWarning () {
	// we append the time to the string to avoid caching
	var urldate = new Date()
	var urltime = urldate.getTime()
	document.session_reload_image.src = 'get_file.php?file=session_reload_image.png&reloadsession=start&now=' + urltime;
	setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
}

</script>

</head>


<body onLoad="setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );">

	<div id="wrapper">
		<div id="layout">
			<div id="content">
				<?php echo $content;?>
			</div>
			
			<div id="footer">
				<p align="center">
					<a href="index.php?amn=core_structure"><?php echo $lang['href_policy'];?></a>
					&nbsp;
					<a href="core_contact&abuse_report=1"><?php echo $lang['href_report_abuse'];?></a>
					&nbsp;
					<a href="index.php?amn=grp_item&amp;group_id=<?php echo $group['group_id'];?>&amp;exit_fullscreen"><?php echo $lang['href_exit_fullscreen'];?></a>
					
					
					<br />	
				</p>
				<!-- under our free license policy you are allowed to remove this, however we would like it if you chose 
				to promote us through including the following text and link  -->
				<?php echo $lang['txt_footer'];?><br />
			</div>
				
			<img name="session_reload_image" src="get_file.php?file=0-session_reload_image.png" alt="" />
		</div>
	</div>
</body>
</html>