<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

require_once($language_path_core . 'inc/html_edit.lang.inc.php');

if (isset($_POST['mark_subjects'])) {
	// we mark the items and go to home page (where they are listed)
	
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['group'], $output_group['group_id']);
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$bookmark->user_id = $_SESSION['user_id'];
	
	if (!empty($_POST['subject_ids'])) {
		foreach ($_POST['subject_ids'] as $key => $i):
			$bookmark->inner_item_id = $i;
			$bookmark->insertBookmark();
		endforeach;
	}
	
	header("Location: index.php?amn=grp_item&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_subject'])) {
	if (empty($_POST['subject_title'])) {	
		$GLOBALS['am_error_log'][] = array('no_title');	
	}
	
	if (empty($_POST['subject_synopsis'])) {	
		$GLOBALS['am_error_log'][] = array('no_synopsis');	
	}
	
	if (empty($GLOBALS['am_error_log'])) {

		require_once('components/core/class/Kses/kses.php');
		
		$_POST['subject_body'] = kses_parse($_POST['subject_body'], 'max');

		$_POST['subject_title'] = trim(strip_tags($_POST['subject_title']));
		$_POST['subject_synopsis'] = trim(strip_tags($_POST['subject_synopsis']));
		
		if (empty($_POST['subject_title'])) {
			$GLOBALS['am_error_log'][] = $lang['error']['no_title'];
		}

		if (empty($_POST['subject_synopsis'])) {
			$GLOBALS['am_error_log'][] = $lang['error']['no_synopsis'];
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$rec = array();
			$rec['group_id'] = $_POST['group_id'];
			$rec['topic_id'] = $_POST['topic_id'];
			$rec['subject_title'] = $_POST['subject_title'];
			$rec['subject_synopsis'] = $_POST['subject_synopsis'];
			$rec['subject_body'] = $_POST['subject_body'];
			
			if (!empty($_POST['subject_locked'])) {
				$rec['subject_locked'] = 1;
			}
			else {
				$rec['subject_locked'] = "null";
			}
			
			if (!empty($_POST['subject_sticky'])) {
				$rec['subject_sticky'] = 1;
			}
			else {
				$rec['subject_sticky'] = "null";
			}
			
			if (!empty($_POST['poll_id'])) {
				$rec['poll_id'] = $_POST['poll_id'];
			}
			
			if (!empty($_POST['file_id'])) {
				$rec['file_id'] = $_POST['file_id'];
			}
		
			if (!empty($_POST['subject_id'])) {
				$query = "
					SELECT * 
					FROM " . $db->prefix . "_group_subject 
					WHERE 
					group_id=" . $_POST['group_id'] . " AND 
					subject_id=" . $_POST['subject_id']
				;
				
				$result = $db->Execute($query);
				
				if (isset($result->fields)) {
					$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				}
			}
			else { // insert
				$rec['subject_create_datetime'] = time();
				$rec['user_id'] = $_SESSION['user_id'];
				
				$table = $db->prefix . "_group_subject";
				$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $db->Execute($query);
				
				if (isset($result)) {
					$_POST['subject_id'] = $db->Insert_ID();
				}
			}
			
			if (isset($_FILES['frm_file']) && !empty($_FILES['frm_file'])) {
				include_once('components/core/class/File.class.php');
				
				$group_id = $_POST['group_id'];
				$subject_id = $_POST['subject_id'];
				
				$file = new File($db, $core_config['file']);
				$file->max_height = $core_config['file']['image']['max_height'];
				$file->max_width = $core_config['file']['image']['max_width'];
				$file->module_id = $core_config['module_id']['group'];
				$file->core_config_module = $core_config['module'];
				$file->item_id   = $group_id;
				$file->setFile($_FILES['frm_file']);
					
				if (isset($_POST['frm_file_name']) && !empty($_POST['frm_file_name'])) {
					$file->setSaveName($_POST['frm_file_name']);
				}
			
				if ($file->checkAllocation()) {
					if ($file->checkMimeType()) {
						$file->moveFile();
						$file->createThumbNails();
						$file->insertRecord();
						
						if (isset($file->file_id)) {
							unset ($rec);
							$rec['file_id'] = $file->file_id;
			
							$query = "
								SELECT *
								FROM " . $db->prefix . "_group_subject
								WHERE group_id=" . $group_id ." AND
								subject_id=" . $subject_id
							;
							
							$group_result = $db->Execute($query);
						
							if (isset($group_result->fields)) {
								$query = $db->GetUpdateSQL($group_result, $rec, false, get_magic_quotes_gpc());
								$result = $db->Execute($query);
							}
						}
					}
				}
			}
			
			header("Location: index.php?amn=grp_forum_subject&group_id=" . $_POST['group_id'] . "&subject_id=" . $_POST['subject_id'] . "&" . strip_tags(SID));
			exit;
		}
		else { // there was an error
			$output_subject = $_POST;
		}
	}
	else { // there was an error in HTML parsing
		$output_subject = $_POST;

		$output_subject['subject_body'] = stripslashes($output_subject['subject_body']);
	}
	
}
elseif (isset($_POST['edit_subject'])) {
	if (!empty($_POST['subject_title'])) {
		$output_subject['subject_title'] = $_POST['subject_title'];
		$body->set('subject', $output_subject);
	}
	
	$body->set('display', 'edit_subject');
}
elseif (isset($_POST['preview_subject'])) {
	$output_subject = $_POST;
	
	require_once('components/core/class/Kses/kses.php');
	
	$output_subject['display_subject_body'] = kses_parse($output_subject['subject_body'], 'max');

	$output_subject['subject_body'] = stripslashes($output_subject['subject_body']);
	$output_subject['display_subject_body'] = stripslashes($output_subject['display_subject_body']);
	
	if ($core_config['xhtml_markup']['format']['nl2br'] == 1) {
		$output_subject['display_subject_body'] = nl2br($output_subject['display_subject_body']);
	}
	
	$body->set('subject', $output_subject);

	$body->set('display', 'edit_subject');
}
elseif (isset($_POST['search_title'])) {
	// we check the title against other subjects
	if (!empty($_POST['subject_title'])) {
		$conjunctions = array("for", "and", "nor", "but", "or", "yet", "so");
		
		// we strip out words and remove conjunctions
		$search_values = trim($_POST['subject_title']);
		
		// strip double spaces
		$search_values = preg_replace('/\s\s+/', ' ', $search_values);
		
		$search_values = explode(" ", $search_values);
		
		if (!empty($search_values)) {
			foreach($search_values as $key => $i):
				$tmp_search_item = trim($i);
				
				if (in_array($tmp_search_item, $conjunctions)) {
					unset($search_values[$key]);
				}
				else {
					$group->search_items[] = $tmp_search_item;
				}
			endforeach;
			
			$output_subjects = $group->selSubjects($_POST['topic_id']);
			
		}
		
		if (!empty($output_subjects)) {
			$body->set('display', 'select_subject');
		
			$output_subject['subject_title'] = $_POST['subject_title'];
			$body->set('subject', $output_subject);
		}
		else {
			$output_subject['subject_title'] = $_POST['subject_title'];
			$body->set('display', 'edit_subject');
			$body->set('subject', $output_subject);
		}
	}
}

if (!empty($_REQUEST['topic_id'])) {
	$output_topic = $group->selTopic($_REQUEST['topic_id']);
}
elseif (!empty($_REQUEST['subject_id'])) {
	$output_subject = $group->selSubject($_REQUEST['subject_id']);
	
	if (isset($output_subject)) {
		$body->set('display', 'edit_subject');
		$body->set('subject', $output_subject);
		
		$output_topic = $group->selTopic($output_subject['topic_id']);
	}

}


if (!empty($output_topic)) {
	$body->set('topic', $output_topic);
}



// file setup --------------------------------------------------
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->module_id = $core_config['module_id']['group'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];

$images = $file->selFiles("images", "t2");
$body->set("images", $images);

// we select any polls 
$query = "
	SELECT poll_id, poll_question 
	FROM " . $db->prefix . "_group_poll 
	WHERE
	group_id=" . $output_group['group_id']
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	
	$output_polls = array();
	
	while (!$result->EOF) {
		array_push ($output_polls, $result->fields);
		
		$result->MoveNext();
	}
	
	if (!empty($output_polls)) {
		$body->set('polls', $output_polls);
	}
}

// move group to templates
$tpl->set('group', $output_group);
$body->set('group', $output_group);


if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

?>
