<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Group {
	// Group --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Group($db, $group_config) {
		$this->db = $db;
		$this->group_config = $group_config;
	}//EO Group
	
	
	
	// selGroup --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function selGroup() {
		$query = "
			SELECT g.group_id, g.group_title, g.group_unix_title, g.group_synopsis, 
			g.group_body, g.group_css, g.group_policy, g.language_id, g.location_id, 
			g.group_create_datetime, g.group_type, g.group_from_age, g.group_to_age, 
			g.level_id, g.user_id, g.file_id, g.status_id, g.default_user_permission 
  			FROM " . $this->db->prefix . "_group g 
			WHERE 
			g.group_id=" . $this->group_id
		;
		
		if (isset($this->status_id)) {
			$query .= " AND g.status_id=" . $this->status_id;
		}
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selGroup class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selGroup
	
	
	
	// selGroups --------------------------------------------------------------------
	// returns multiple group records
	// tom calthrop - 30th October 2006
	//
	function selGroups() {
		$query = "
			SELECT g.group_id, g.group_title, g.group_unix_title, g.group_synopsis, 
			g.location_id, 
			g.group_create_datetime, g.group_type, g.group_from_age, g.group_to_age, 
			g.level_id, g.user_id, g.file_id, g.status_id, l.location_name 
  			FROM "
  		;

		if (isset($this->search_tag)) {
			$query .= $this->db->prefix . "_tag t, ";
		}
		
  		$query .=
  			$this->db->prefix . "_group g
  			LEFT JOIN " . $this->db->prefix . "_user_location l ON g.location_id=l.location_id 
  			LEFT JOIN " . $this->db->prefix . "_mem_type_access mt ON g.group_id=mt.item_id and mt.module_id=" . $this->group_config['module_id'] . "
  			WHERE "
		;
		
		if (isset($this->search_tag)) {
			$query .= "
				g.group_id=t.item_id AND
				t.module_id=" . $this->group_config['module_id'] . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->search_tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->status_id)) {
			$query .= "g.status_id=" . $this->status_id . " AND ";
		}
		
		if (isset($this->location_id)) {
			$query .= "g.location_id=" . $this->location_id . " AND ";
		}
		
		if (isset($this->level_id)) {
		    $query .= "g.level_id=" . $this->level_id . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "g.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->search_text)) {
		    $query .= " 
				(g.group_title like " . $this->db->qstr("%" . $this->search_text . "%", get_magic_quotes_gpc()) . " OR 
				g.group_synopsis like " . $this->db->qstr("%" . $this->search_text . "%", get_magic_quotes_gpc()) . ") AND ";
		}
		
		if (isset($this->group_ids)) {
			$query .="g.group_id in (" . implode(",", $this->group_ids) . ") AND ";
		}
		
		$query .= "(g.group_type!=" . $this->group_config['type']['membership_type'] . " OR ";
		$query .= "(g.group_type=" . $this->group_config['type']['membership_type'] . " AND mt.membership_type_id=". $this->membership_type_id . ")) AND ";
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= " order by " . $this->order_by;
		}
		else {
			$query .= " order by g.group_title";
		}
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
						
	 					$temp1['image'] = $this->file->selFile($temp1['file_id'], $this->file->thumb);
	 				}
	 				else {
	 					$temp1['image']['file_title'] = "";
	 					$temp1['image']['file_md5_name_view'] = "0-" . $this->file->no_image;
	 				}
				}
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			
			return $temp;
		}
		else {
			$error_info = "method=selGroups class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selGroups
	
	
	
	// selTopics --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function selTopics($inc_topic_count = null) {
		$query = "
			SELECT t.topic_id, t.group_id, t.topic_title, t.topic_synopsis, t.topic_hidden, 
			t.topic_order, t.topic_create_datetime, t.user_id 
  			FROM " . $this->db->prefix . "_group_topic t  
			WHERE 
			t.group_id=" . $this->group_id
		;
		
		if (isset($this->order_by)) {
		    $query .= " order by " . $this->order_by;
		}
		else {
			$query .= " order by t.topic_order, t.topic_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
	
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($inc_topic_count)) {
					$temp1['subject_count'] = $this->countSubjects($temp1['topic_id']);
				}
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selTopics class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selTopics
	
	
	// selSubjects --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function selSubjects($topic_id = null) {
		$query = "
			SELECT s.subject_id, s.group_id, s.topic_id, s.subject_title, s.file_id, 
			s.user_id, s.subject_synopsis, s.subject_body, s.subject_create_datetime, 
			s.subject_edit_datetime, s.subject_locked, s.subject_sticky, s.poll_id "
		;

		if (isset($this->level_id)) {
			$query .= "
				FROM " . $this->db->prefix . "_group_subject s, " . $this->db->prefix . "_group g
				WHERE 
				s.group_id=g.group_id AND "
			;
		}
		else {
			$query .= "
				FROM " . $this->db->prefix . "_group_subject s 
				WHERE "
			;
		}
		
		if (isset($this->group_id)) {
		    $query .= "s.group_id=" . $this->group_id . " AND ";
		}
		
		if (isset($topic_id)) {
		    $query .= "s.topic_id=" . $topic_id . " AND ";
		}
		
		if (isset($this->subject_ids)) {
		    $query .= "s.subject_id in (" . implode(",", $this->subject_ids) . ") AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->level_id)) {
		    $query .= "g.level_id=" . $this->level_id . " AND ";
		}
		
		if (isset($this->search_items)) {
			$search_items = "";
			$query .= " (";
			
			foreach($this->search_items as $key => $i):
				 $query .= " 
					(s.subject_title like " . $this->db->qstr("%" . $i . "%", get_magic_quotes_gpc()) . " OR 
					s.subject_synopsis like " . $this->db->qstr("%" . $i . "%", get_magic_quotes_gpc()) . ") "
				;
					
				if (count($this->search_items) > $key+1) {
				    $query .= " OR ";
				}
			endforeach;
			$query .= ") AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by s.subject_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
	
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
	 					$temp1['image'] = $this->file->selFile($temp1['file_id'], $this->file->thumb);
	 				}
	 				else {
	 					$temp1['image']['file_title'] = "";
	 					$temp1['image']['file_md5_name_view'] = "0-" . $this->file->no_image;
	 				}
				}
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selSubjects class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selSubjects
	
	
	// selSubject --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function selSubject($subject_id = null) {
		$query = "
			SELECT s.subject_id, s.group_id, s.topic_id, s.subject_title, s.file_id, 
			s.user_id, s.subject_synopsis, s.subject_body, s.subject_create_datetime, 
			s.subject_edit_datetime, s.subject_locked, s.subject_sticky, s.poll_id 
			FROM " . $this->db->prefix . "_group_subject s  
			WHERE 
			s.group_id=" . $this->group_id . " AND 
			s.subject_id=" . $subject_id
		;
		
		$result = $this->db->SelectLimit($query, 1);
	
		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selSubject class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selSubject
	
	
	// countTopics --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function countTopics() {
		$query = "
			SELECT count(topic_id) as total 
  			FROM " . $this->db->prefix . "_group_topic 
			WHERE 
			group_id=" . $this->group_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
		}
		else {
			$error_info = "method=countTopics class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO countTopics
	
	
	// countSubjects --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function countSubjects($topic_id = null) {
		$query = "
			SELECT count(subject_id) as total 
			FROM " . $this->db->prefix . "_group_subject 
			WHERE 
			group_id=" . $this->group_id . " AND "
		;
		
		if (isset($topic_id)) {
			$query .= "topic_id=" . $topic_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total'];
		}
		else {
			$error_info = "method=countSubjects class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} //EO countSubjects
	
	
	// selTopics --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 24th October 2006
	//
	function selTopic($topic_id) {
		$query = "
			SELECT t.topic_id, t.group_id, t.topic_title, t.topic_synopsis, t.topic_hidden, 
			t.topic_order, t.topic_create_datetime, t.user_id 
  			FROM " . $this->db->prefix . "_group_topic t  
			WHERE 
			t.group_id=" . $this->group_id . " AND 
			t.topic_id=" . $topic_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selTopic class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selTopic




	// selPoll --------------------------------------------------------------------
	// returns a single record from the DB
	// tom calthrop - 24th Feb 2004
	//
	function selPoll($poll_id) {

		$query = "
			SELECT poll_id, poll_question, poll_anon, 
			user_id, poll_create_datetime 
			FROM " . $this->db->prefix . "_group_poll 
			WHERE
			poll_id=" . $poll_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;

			$temp['options'] = $this->_selOptions($temp['poll_id']);
			$temp['total_votes'] = $this->total_votes;


			//get percentages
			foreach($temp['options'] as $key => $i):
				$temp['options'][$key]['percent'] = 0;

				if ($i['votes'] > 0) {
				    $percent = round((100/$this->total_votes)* $i['votes']);
					$temp['options'][$key]['percent'] = $percent;
				}
			endforeach;

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selPoll class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selPoll



	// _selOptions --------------------------------------------------------------------
	// get the options for the poll
	// tom calthrop - 24th Feb 2004
	//
	function _selOptions($poll_id) {
		$total_votes = 0;

		$query = "
			SELECT option_id, option_body, option_order 
			FROM " . $this->db->prefix . "_group_poll_option
			WHERE
			poll_id=" . $poll_id . " 
			ORDER BY option_order"
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				$temp1['votes'] = $this->_answerSummary($temp1['option_id']);
				$total_votes = $total_votes + $temp1['votes'];
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			$this->total_votes = $total_votes;
			return $temp;
		}
		else {
			$error_info = "method=_selOptions class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selOptions



	// answerSummary --------------------------------------------------------------------
	// returns count of the ansers received per poll option given
	// tom calthrop - 24th Feb 2004
	//
	function _answerSummary($option_id) {
		$query = "
			SELECT count(answer_id) as total
			FROM " . $this->db->prefix . "_group_poll_answer
			WHERE 
			current_answer=1 AND 
			option_id=" . $option_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			return $temp['total'];
		}
		else {
			$error_info = "method=_answerSummary class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO answerSummary



	// selRecommendations --------------------------------------------------------------------
	// get the recommendations to the group
	// tom calthrop - 13th December 2006
	//
	function selRecommendations($subject_id = null) {
		$query = "
			SELECT gr.module_id, gr.item_id, gr.inner_item_id, p.identity_id, 
			gr.recommend_note, gr.recommend_create_datetime, gr.subject_id, 
			i.identity_nic, gr.user_id 
			FROM " . $this->db->prefix . "_group_recommend gr, " . $this->db->prefix . "_participation p, " . $this->db->prefix . "_user_identity i  
			WHERE 
			p.identity_id=i.identity_id AND 
			gr.user_id=p.user_id AND
			p.module_id=" . $this->group_config['module_id'] . " AND 
			p.item_id=gr.group_id AND 
			gr.group_id=" . $this->group_id . " AND "
		;
		
		if (isset($subject_id)) {
			$query .= "gr.subject_id=" . $subject_id . " AND ";
		}
		
		$query .= "1=1";
		
		if (isset($this->order_by)) {
		    $query .= " order by " . $this->order_by;
		}
		else {
			$query .= " order by gr.recommend_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "method=_selRecommendations class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selRecommendations
}
?>
