<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_form.css);
-->
</style>

<script type="text/javascript">

	function showHideFeedbackFrom(state) {
		var field = document.getElementById('id_feedback_enjoyment');
		var comment_field = document.getElementById('id_feedback_comment');
		if (state) {
			field.style.display = 'block';
			comment_field.innerHTML = '<?php echo $lang['txt_leave_comment']; ?>';
		}
		else {
			field.style.display = 'none';
			comment_field.innerHTML = '<?php echo $lang['txt_did_not_go']; ?>';
		}
	}
	
</script>
<form method="post" name="frm" />
<div class="col_main">	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['txt_activity']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
			
				<?php if (isset($event)) { ?>
				
					<?php
					if ($event['status_id'] != $event_config['event']['status']['live']) {
					?>
					<div class="picture" style="padding:10px; margin-bottom:20px; width:488px">
						<?php
						if (!empty($event_config['owner_allow_to_live_status'])) {
						?>
							<?php echo $lang['txt_status_not_live_owner_set'];?><br />
	
							<p align="right">
								<a href="index.php?amn=evt_item&amp;event_id=<?php echo $event['event_id'];?>&amp;set_status_live=1"><?php echo $lang['href_set_to_live'];?></a><br />
							</p>
						<?php
						}
						else {
						?>
							<?php echo $lang['txt_status_not_live'];?><br />
						<?php }?>
					</div>
					<?php }?>
				
				<div class="metadata_top">
				<?php if (isset($bookmark)) { ?>
					<input type="image" src="<?php echo $template_path_core;?>img/unmark.png" name="mark_0" value="0" alt="remove bookmark" border="0" title="<?php echo $lang['txt_remove_bookmark']; ?>" />
				<?php } else { ?>
					<input type="image" src="<?php echo $template_path_core;?>img/mark.png" name="mark_1" value="1" alt="bookmark" border="0" title="<?php echo $lang['txt_bookmark']; ?>" />
				<?php } ?>
				</div>
				
				<p class="txt_item_title">
					<?php echo $event['event_title']; ?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4">
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_start']; ?></b><br />
						</td>
						<td align="top">
							<?php echo $this->date->formatDate($event['event_start_datetime']); ?>,
							<?php echo $this->date->formatDate($event['event_start_datetime'], 4); ?>
						</td>
					</tr>
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_duration']; ?></b><br />
						</td>
						<td align="top">
							<?php if ($event['event_duration'] < 24) { ?>
							<?php echo $event['event_duration']; ?> <?php echo $lang['txt_hours']; ?> 
							<?php } else { ?>
							<?php echo round($event['event_duration']/24);?> <?php echo $lang['txt_days']; ?> 
							<?php } ?>
						</td>
					</tr>
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_location']; ?></b><br />
						</td>
						<td align="top">
							<?php echo $event['location_name']; ?><br />
						</td>
					</tr>
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_venue']; ?></b><br /> 
						</td>
						<td align="top">
							<?php echo $event['event_venue']; ?><br />
						</td>
					</tr>
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_participants']; ?></b><br /> 
						</td>
						<td align="top">
							<?php echo $event['count_participants']; ?><br />
						</td>
					</tr>
					<tr>
						<td align="top">
							<b><?php echo $lang['txt_places']; ?></b><br /> 
						</td>
						<td align="top">
							<?php if ($event['event_allocation'] == '') { ?>
							<?php echo $lang['txt_participants_no_limit']; ?><br />
							<?php } else { ?>
							<?php echo $event['event_allocation']; ?><br />
							<?php } ?>
						</td>
					</tr>
				</table>
			
				<div style="overflow: auto; width:510px;margin-top:6px;margin-bottom:6px;">
				<?php if (isset($view_body_text)) { ?>
				<?php echo $event['event_body']; ?><br />
				<?php } ?>
				</div>
				
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="1" height="12" alt="" /><br />
				
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
					<tr>
						<td>
							<?php
							if (isset($_SESSION['user_id'])) {
							?>
							<?php
							if (isset($recommend)) {
							?>
								<input type="image" src="<?php echo $template_path_core;?>img/unrecommend.png" name="recommend_0" value="0" alt="<?php echo $lang['txt_alt_remove_recommendation'];?>" border="0" title="<?php echo $lang['txt_title_remove_recommendation'];?>" />
							<?php
							}
							else {
							?>
								<input type="image" src="<?php echo $template_path_core;?>img/recommend.png" name="recommend_1" value="1" alt="<?php echo $lang['txt_alt_add_recommendation'];?>" border="0" title="<?php echo $lang['txt_title_add_recommendation'];?>" />
							<?php }?>
							&nbsp;
							<?php }?>
							
							<?php if (isset($matrix[0]['relation']) && !isset($matrix[0]['relation']['respected'])) { ?>
								<a href="index.php?amn=evt_item&amp;respect=1&amp;event_id=<?php echo $event['event_id'];?>"><?php echo $lang['href_respect'];?></a>
								&nbsp;
							<?php } ?>
							
							<?php echo $event['event_create_datetime'];?>
							
							<br />
						</td>
						<td align="right">
							<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['event'];?>&amp;identity_id=<?php echo $identity['identity_id'];?>&amp;event_id=<?php echo $event['event_id'];?>"><?php echo $identity['identity_nic'];?></a>
							
							<?php 
							if (isset($matrix[0])) {
								echo drawMatrix($matrix[0]);
							} ?>
							
							<?php
							if (isset($identity['testimonial_count'])) {
							?>
							&nbsp; 
							<span class="icon_frame">
								<span class="icon_title">&nbsp;<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['event'];?>&amp;identity_id=<?php echo $identity['identity_id'];?>&amp;event_id=<?php echo $event['event_id'];?>"><?php echo $lang['txt_vouched'];?></a>&nbsp;</span>
								<span class="icon_value">&nbsp;<?php echo $identity['testimonial_count'];?>&nbsp;</span>
							</span>
							<?php }?>
					
							<br />
						<span style="float:left"></td>
					</tr>
				</table>
				<?php } ?>
			</div>
		</div>
	</div>
	
	<?php if (isset($feedback)) { ?>
		<div class="box">
			<div class="box_top">
				<div class="content">
					<h1><?php echo $lang['hdr_feedback']; ?></h1>
				</div>
			</div>
			
			<div class="box_mid">
				<div class="content">
				<?php foreach($feedback as $f): ?>
				<table width="100%">
					<tr id="feedback_id_<?php echo $f['feedback_id']; ?>">
						<td align="right">
						<a href="index.php?amn=core_profile&amp;identity_id=<?php echo $f['identity_id']; ?>"><?php echo $f['identity_nic']; ?></a>, 
							<?php echo $f['feedback_create_datetime']; ?>
						</td>
					</tr>
					<tr>
						<td>
						<?php echo $lang['txt_did_you_go']; ?>
						<i>
							<?php 
							if (!empty($f['feedback_participation'])) {
								echo "-" . $lang['txt_yes'];
							}
							else {
								echo "-" . $lang['txt_no']; 
							}
							?>
						</i>
						</td>
					</tr>
					<?php if ($f['feedback_participation']) { ?>
					<tr>
						<td>
						<?php echo $lang['txt_did_you_enjoy']; ?>
						<i>
							<?php 
							if (!empty($f['feedback_enjoyment'])) {
								echo "-" . $lang['txt_yes'];
							} 
							else {
								echo "-" . $lang['txt_no'];
							}
							?>
						</i>
						</td>
					</tr>
					<?php } ?>
					<tr>
						<td>
						<?php echo $lang['txt_arrange_again']; ?>
						<i>
							<?php 
							if (!empty($f['feedback_arrangement'])) {
								echo "-" . $lang['txt_yes'];
							}
							else {
								echo "-" . $lang['txt_no'];
							}
							?>
						</i>
						</td>
					</tr>
				</table>
				<?php if (isset($f['feedback_comment']) && !empty($f['feedback_comment'])) { ?>
				<p>
				<?php if ($f['feedback_participation']) { ?>
				<b><?php echo $lang['txt_comment']; ?></b>
				<?php } else { ?>
				<b><?php $lang['txt_comment']; ?></b>
				<?php } ?>
				-<i><?php echo $f['feedback_comment']?></i>
				</p>
				<?php } ?>
				<hr />
				<?php endforeach; ?>
			</div>
		</div>
	</div>
	<?php } ?>
</div>

<div class="col_side">
	<?php
	if (isset($_REQUEST['feedback'])) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_feedback']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<form method="post" action="index.php?amn=evt_item&amp;event_id=<?php echo $_REQUEST['event_id'];?>">
				<input type="hidden" name="feedback" value="1" />
				<p>
					<?php echo $lang['txt_did_you_go'];?>
					<div style="text-align: right">
					<?php echo $lang['txt_yes']; ?> <input type="radio" value="1" name="feedback_participation" onclick="showHideFeedbackFrom(true);"/>
					<?php echo $lang['txt_no']; ?> <input type="radio" value="0" name="feedback_participation" onclick="showHideFeedbackFrom(false);"/>
					</div>
				</p>
				<hr />
				
				<span id="id_feedback_enjoyment" style="display: block;">
				<p>
					<?php echo $lang['txt_did_you_enjoy']; ?>
					<div style="text-align: right">
					<?php echo $lang['txt_yes']; ?> <input type="radio" value="1" name="feedback_enjoyment"/>
					<?php echo $lang['txt_no']; ?> <input type="radio" value="0" name="feedback_enjoyment"/>
					</div>
				</p>
				<hr />
				</span>

				<p>
					<span id="id_feedback_arrangement"><?php echo $lang['txt_arrange_again']; ?></span>
					<div style="text-align: right">
					<?php echo $lang['txt_yes']; ?> <input type="radio" value="1" name="feedback_arrangement"/>
					<?php echo $lang['txt_no']; ?> <input type="radio" value="0" name="feedback_arrangement"/>
					</div>
				</p>
				<hr />
				<p>
					<span id="id_feedback_comment"><?php $lang['txt_leave_comment']; ?></span>
					<div>
					<textarea name="feedback_comment"></textarea>
					</div>
				</p>
				<p>
					<div style="text-align: right">
						<?php echo $lang['txt_feedback_to_maintainer']; ?> <input type="checkbox" name="feedback_private" value="1" />
					</div>
				</p>
				
				<p align="right">
					<input type="submit" value="send" class="input_submit" name="activity_feedback"/>
				</p>
				</form>
			</div>
		</div>
	</div>
	<?php
	}
	else {
	?>

	<?php if (isset($feedback_summery)) { ?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_feedback_summery']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
			<p><i><?php echo $lang['txt_did_you_know']; ?></i></p>
				<ul>
					<li>
						<?php 
						echo $feedback_summery['participation_total'];
						echo " " . $lang['txt_of'] . " ";
						echo $feedback_summery['total'] . " (";
						echo $feedback_summery['participation_freq'] . "%) ";
						echo $lang['txt_users_participated'];
						?>
					</li>
					<li>
						<?php 
						echo $feedback_summery['enjoyment_freq'] . "% ";
						echo $lang['txt_users_enjoyed'];
						?>
					</li>
					<li>
						<?php
						echo $feedback_summery['arrangement_freq'] . "% ";
						echo $lang['txt_user_participate_again'];
						?>
					</li>
				</ul>
				<?php if (isset($feedback_link)) { ?>
				<?php echo $lang['txt_do_you_want_to_write']; ?> <a href="index.php?amn=evt_item&amp;event_id=<?php echo $_REQUEST['event_id']?>&amp;feedback=1"><?php echo $lang['hdr_feedback']; ?></a> <?php echo $lang['txt_to_event']; ?>
				<?php } ?>
			</div>
		</div>
	</div>
	<?php 
	} 
	elseif (isset($feedback_link)) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_feedback_summery']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
			<p><?php echo $lang['txt_do_you_want_to_write']; ?> <a href="index.php?amn=evt_item&amp;event_id=<?php echo $_REQUEST['event_id']?>&amp;feedback=1"><?php echo $lang['hdr_feedback']; ?></a> <?php echo $lang['txt_to_event']; ?></p>
			</div>
		</div>
	</div>
	<?php } ?>
	
	<?php if (isset($_SESSION['md5'])) { ?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_my_participation']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
			<?php if (isset($participation)) { ?>
			<table border="0" cellpadding="2" cellspacing="2">
				<tbody><tr>
				<td valign="top">
					<?php echo $lang['txt_joined']; ?><br>
				</td>
				<td valign="top">
					<?php echo $this->date->FormatDate($participation['participation_create_datetime']); ?><br />
				</td>
				</tr>
				<tr>
					<td valign="top">
						<?php echo $lang['txt_status']; ?><br>
					</td>
					<td valign="top">
					<?php if (!empty($participation['role_id'])) { ?>
						<?php echo $lang['user_role'][$participation['role_id']]; ?><br />
					<?php } else { ?>
						<?php echo $lang['user_participation_status'][$participation['status_id']]; ?><br />
					<?php } ?>
					</td>
				</tr>
				</tbody>
			</table>
			<?php } else { ?>
				<p><?php echo $lang['event_type'][$event['event_type']]; ?>
				
				<?php if ($event['event_type'] == $event_config['type']['membership_type'] || $event['event_type'] == $event_config['type']['approved'] || $event['event_type'] == $event_config['type']['open']) { ?>
				: <a href="index.php?amn=core_participation&amp;module_id=<?php echo $core_config['module_id']['event']; ?>&amp;item_id=<?php echo $event['event_id']; ?>" class="href_button"><?php echo $lang['hrf_join']; ?></a></p>
				<?php } ?>
			<?php } ?>
			</div>
		</div>
	</div>
	<?php } ?>

	<div class="box">
		<div class="box_top">
			<div class="content">
				<h1><?php echo $lang['hdr_people']; ?></h1>
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $lang['txt_started_by']; ?></b><br />
					<a href="index.php?amn=core_profile&amp;module_id=<?php echo $core_config['module_id']['event'];?>&amp;item_id=<?php echo $event['event_id']?>&amp;identity_id=<?php echo $identity['identity_id']?>"><?php echo $identity['identity_nic']; ?></a><br />
				</p>
				
				<p>
					<b><?php echo $lang['hdr_people_attending']; ?></b><br />
					<?php echo $event['count_participants']; ?> 
					<?php echo $lang['txt_people_attending']; ?><br />
				</p>
			</div>
		</div>
	</div>
	<?php }?>
	
	
	<?php
	if (isset($_SESSION['user_id'])) {
	?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<a href="#" style="float:left;" onClick="javascript:launchPopupWindow('components/core/help.php?help=core_tags');" style="cursor:help;"><img src="<?php echo $template_path_core;?>img/help.png" alt="<?php echo $lang['alt_help'];?>" border="0" /></a>

				<h1><?php echo $lang['hdr_tags'];?></h1>
			</div>
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p>
					<?php
					if (isset($tags)) {
					$prnt = "";
					foreach($tags as $key => $i):
						$prnt .= $i['tag_body'] . "<sup><a href='index.php?amn=evt_item&amp;event_id=" . $event['event_id'] . "&amp;edit_tag=" . $i['tag_id'] . "' style='text-decoration:none;'>&#43;</a></sup> ";
					endforeach;
					echo $prnt;
					}
					?>
				</p>
				
				<p>
					<input type="hidden" name="tag_id" value="<?php if (isset($tag)) { echo $tag['tag_id'];}?>" />
					<input type="text" class="input1" name="tag_body" size="10" value="<?php if (isset($tag)) { echo $tag['tag_body'];}?>" /><br />
				</p>
				
				<p style="float:right; margin-bottom:0px; margin-top:0px;">
					<input type="submit" name="insert_tag" class="input_submit" style="font-size:60%;" value="<?php echo $lang['sub_tag_ok'];?>" />
					<input type="submit" name="delete_tag" class="input_submit" style="font-size:60%;" value="<?php echo $lang['sub_tag_delete'];?>" /><br />
				</p>
			</div>
		</div>
	</div>
	<?php }?>
	
	
</div>
</form>