<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";

include_once ('config/evt.config.php');
include_once ("inc/evt_initiate.inc.php");


// FAVOURITES -----------------------------------------

if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['event']);
	$bookmark->item_id = $event->event_id;
	$bookmark->inner_item_id = $event->event_id;
	$bookmark->user_id = $_SESSION['user_id'];
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	
	if (isset($_POST['mark_0_x'])) {
		$bookmark->deleteBookmark();
	}
	elseif (isset($_POST['mark_1_x'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_POST['mark_2_x'])) {
		$bookmark->insertBookmark(1);
	}
	elseif (isset($_POST['recommend_0_x'])) {
		$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
		$bookmark->deleteBookmark();
	}
	elseif (isset($_POST['recommend_1_x'])) {
		$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
	}
	
	$output_bookmark = $bookmark->selBookmarks();
	$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
	$output_recommend = $bookmark->selBookmarks();
	
	
	
	// select tags
		require_once('components/core/class/Tag.class.php');
		$tag = new Tag($db, $core_config['module_id']['event']);
		$tag->item_id = $output_event['event_id'];
		$tag->inner_item_id = $output_event['event_id'];
		$tag->user_id = $_SESSION['user_id'];	
		
		if (isset($_POST['insert_tag']) && !empty($_POST['tag_body'])) {
			if (empty($_POST['tag_id'])) { // we insert
				$tag->insertTag($_POST['tag_body']);
			}
			elseif (!empty($_POST['tag_id'])) { // we delete
				$tag->deleteTag($_POST['tag_id']);
			}
			else { // we update tag
				$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
			}
		}
		elseif (isset($_POST['delete_tag']) && !empty($_POST['tag_id'])) {
			$tag->deleteTag($_POST['tag_id']);
		}
		elseif (isset($_REQUEST['edit_tag'])) {
			$output_tag = $tag->selTag($_REQUEST['edit_tag']);
		
			if (!empty($output_tag)) {
			$body->set('tag', $output_tag);
			}
		}
		
		$output_tags = $tag->selTags();
		
		if (!empty($output_tags)) {
			$body->set('tags', $output_tags);
		}
	
	
}
// We need to check if this event is old or not
	$old_event = false; // assume it is not
	
	$query = "
		SELECT e.event_end_datetime
		FROM " . $db->prefix . "_event e
		WHERE e.event_id=" . $_REQUEST['event_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields['event_end_datetime'])) {
		if (date('Y-m-d h:i:s', time()) > $result->fields['event_end_datetime']) {
			$old_event = true;
		}
	}
	$result->Close();
	

if (isset($_REQUEST['identity_id'])) {
	$strong_relation = $participation->selRelations($output_participation['identity_id']);

	if (!empty($strong_relation)) {
		foreach($strong_relation as $s) {
			if ($s['identity_id_relation'] == $_REQUEST['identity_id']) {
				$body->set('destroy_relation', 1);
			}
		}
	}
}

if ($old_event) {
	if (!empty($output_participation)) {
		// Finally we need to check if the user already has done some feedback
		$query = "
			SELECT f.user_id
			FROM " . $db->prefix . "_event_feedback f
			WHERE f.user_id=" . $_SESSION['user_id'] . "
			AND f.event_id=" . $event->event_id
		;
			
		$result = $db->Execute($query);
		if (!empty($result->fields['user_id'])) {
			unset($_REQUEST['feedback']);
		}
		else {
			$output_feedback_link = true;
		}
		$result->Close();
		$event->identity_id = $output_participation['identity_id'];
	}
	else {
		unset($_REQUEST['feedback']);
	}
}
else {
	unset($_REQUEST['feedback']);
}
	
if (isset($_POST['activity_feedback'])) {
	$event->insertFeedback($_POST);
	if (empty($GLOBALS['am_error_log'])) {
		unset($_REQUEST['feedback'], $output_feedback_link); // we have done some feedback
		
		//Count the feedback for this event
		$query = "
			SELECT COUNT(*) AS total_event_feedback
			FROM " . $db->prefix . "_event_feedback
			WHERE event_id=" . $event->event_id
		;
		
		$result = $db->Execute($query);
		if (isset($result->fields)) {
			$total_event_feedback = $result->fields['total_event_feedback'];
			$result->Close();
		}
		else {
			// error-code here
		}
		
		// insert statistics ------------------------------
		require_once('components/core/class/Statistic.class.php');
		$statistic = new Statistic($db, $event_config['statistic']);
		$statistic->module_id = $core_config['module_id']['event'];
		$statistic->user_id = $_SESSION['user_id'];
		
		// insert event statistics
		$statistic->statistic_type_id = $event_config['statistic']['total_event_feedback'];
		$statistic->setStatistic($total_event_feedback);
	}
}


// If the event is old, we get the feedback from the event
if ($old_event) {

	if (isset($_SESSION['user_id'])) {
		$output_feedback = $event->selFeedback($output_event['user_id'] != $_SESSION['user_id']);
	}
	else {
		$output_feedback = $event->selFeedback(false);
	}
	
	$participation_freq = 0;
	$enjoyment_freq = 0;
	$arrangement_freq = 0;
	$total = 0;
	
	foreach($output_feedback as $t) {
		if ($t['feedback_participation']) {
			$participation_freq++;
		}
		if ($t['feedback_enjoyment']) {
			$enjoyment_freq++;
		}
		if ($t['feedback_arrangement']) {
			$arrangement_freq++;
		}
		$total++;
	}
		
	if ($total > 0) {
		$output_feedback_summery['total'] = $total;
		$output_feedback_summery['participation_total'] = $participation_freq;
		$output_feedback_summery['enjoyment_total'] = $enjoyment_freq;
		$output_feedback_summery['arrangement_total'] = $arrangement_freq;
		$output_feedback_summery['participation_freq'] = round($participation_freq / $total * 100);
		$output_feedback_summery['enjoyment_freq'] = $participation_freq == 0 ? 0 : round($enjoyment_freq / $participation_freq * 100);
		$output_feedback_summery['arrangement_freq'] = round($arrangement_freq / $total * 100);
		$body->set('feedback_summery', $output_feedback_summery);
	}
}


$author_participation = $participation->selParticipation($output_event['user_id']);
$output_identity = $user->selUserIdentity(null, $author_participation['identity_id']);


if (!empty($_SESSION['md5'])) {

	require_once ('components/core/class/Network.class.php');
	$network = new Network($db, $core_config, null, $output_identity['identity_id']);

	// GET AND SET RELATIONSHIP -----------------------------------------------
	if (!empty($output_participation) && $output_event['user_id'] != $_SESSION['user_id']) {
		
		$network->setIdentities($output_participation['identity_id'], $output_identity['identity_id']);
		$output_matrix = $network->selMatrix();
		$body->set('matrix', $output_matrix);

		// GET THEIR TESTIMONIAL COUNT ---------------------------
		require_once ("components/core/class/Testimonial.class.php");
		$testimonial = new Testimonial($db);
		$testimonial->identity_id = $output_identity['identity_id'];
		$testimonial->testifier_identity_id = $output_participation['identity_id'];

		// count testimonials
		$output_identity['testimonial_count'] = $testimonial->countTestimonials();
	}
	elseif ($output_event['user_id'] != $_SESSION['user_id']) { // we select "the best card"
		
		$network->user_id = $_SESSION['user_id'];
		$network->identity_type = $core_config['user']['identity']['type']['registered'];
		$output_matrix = $network->selMatrix();
		$body->set('matrix', $output_matrix);
	}
	
	if (isset($_REQUEST['respect']) && $_REQUEST['respect'] == 1 ) {
			
		$data['module_id'] = $core_config['module_id']['event'];
		$data['item_id'] = $output_event['event_id'];
		$data['identity_id'] = $output_matrix[0]['identity']['identity_id'];
		$data['identity_id_relation'] = $output_identity['identity_id'];
		$data['relation_create_datetime'] = time();
		$data['user_id'] = $_SESSION['user_id'];
		
		$network->insertRespect($data);
		$network->setIdentities($data['identity_id'], $data['identity_id_relation']);
		$network->im = $im;
		
		$output_matrix[0]['relation']['respected'] = 1; // is now respected
		$body->set('matrix', $output_matrix);
		
		include_once($language_path_core . 'inc/network_common.inc.php');
		if ($network->isMutual()) {
	
			$message_body = readTxtFile($language_path_core . "texts/im_mutual_respect.txt.php");
			$message_body = str_replace("SYS_KEYWORD_NAME", $output_identity['identity_nic'], $message_body);

			$suffix = $core_config['module'][$core_config['module_id']['event']]['prefix'];
			if (is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
				include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
			}

			$function_name = "selItemModule_" . $suffix;
		
			if (function_exists($function_name)) {
				$respected_item = $function_name($data['item_id']);
				$message_body = str_replace("SYS_KEYWORD_ITEM", $respected_item['item_title'], $message_body);
				$message_body = str_replace("SYS_KEYWORD_URL", $respected_item['item_url'], $message_body);
			}
	
			$network->message_body = $message_body;
			$network->message_subject = $lang['txt_subject_mutual'];
			$network->insertRespectMessage($data['identity_id_relation'], $output_identity['user_id'], $data['identity_id']);
		}
		elseif ($core_config['node']['network_mode'] == 1) {
	
			$core_identity_url = "index.php?amn=core_profile&identity_id=" . $data['identity_id'];
			$core_identity_name = $output_identity['identity_nic'];
			$message_body = readTxtFile($language_path_core . "texts/im_respect.txt.php");
			$message_body = str_replace("SYS_KEYWORD_NAME", $core_identity_name, $message_body);
			$message_body = str_replace("SYS_KEYWORD_URL", $core_identity_url, $message_body);
		
			$network->message_body = $message_body;
			$network->message_subject = $lang['txt_subject_respect'];
			$network->insertRespectMessage($data['identity_id_relation'], $output_identity['user_id']);
		}
	}
	
	if (!empty($_REQUEST['set_status_live']) && ($output_event['user_id'] == $_SESSION['user_id']) && ($output_event['status_id'] == $event_config['event']['status']['pending'])) {
		// the event is pending and the owner is allowed to set it to live st
		
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_event  
			WHERE 
			event_id=" . $output_event['event_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			//update event
			$rec = array();
			$rec['status_id'] = $event_config['event']['status']['live'];

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);

			$output_event['status_id'] = $event_config['event']['status']['live'];
		}
	}
}
$body->set('identity', $output_identity);


if (isset($_REQUEST['list'])) {
	$output_participants = $participation->selParticipants();
}

if (!empty($output_event[0])) {
	$output_event['count_participants'] = $participation->countParticipants($core_config['participation']['status']['active']);
	$output_event['event_create_datetime'] = $event->date->formatDate($output_event['event_create_datetime'], 1);
	$body->set('event', $output_event);	
}
else {
	header('location: index.php?amn=evt_item' . strip_tags(SID));
	exit;
}

// we need to select my strong ties in this event.
if (!empty($output_participation)) {
	$query = "
		SELECT t1.identity_id_relation AS identity_id, i.identity_nic
		FROM " . $db->prefix . "_relation AS t1 
		INNER JOIN " . $db->prefix . "_relation AS t2 
		ON t1.identity_id=t2.identity_id_relation 
		AND t1.identity_id_relation=t2.identity_id 
		AND t1.module_id=t2.module_id 
		AND t1.item_id=t2.item_id
		INNER JOIN " . $db->prefix . "_user_identity i
		ON t1.identity_id_relation=i.identity_id
		WHERE t1.identity_id=" . $output_participation['identity_id'] . "
		AND t1.identity_id_relation != " . $output_participation['identity_id'] . "
		AND t1.module_id=" . $core_config['module_id']['event'] . " 
		AND t1.item_id=" . $event->event_id
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$output_strong_ties = array();
		while(!$result->EOF) {
			array_push($output_strong_ties, $result->fields);
			$result->moveNext();
		}
		$result->Close();
	}
}



if (isset($_REQUEST['identity_id'])) {
	$output_identity2 = $user->selUserIdentity(null, $_REQUEST['identity_id']);
}

if (!empty($output_common_ties)) {
	$body->set('common_ties', $output_common_ties);
}

if (!empty($output_feedback)) {
	$body->set('feedback', $output_feedback);
}

if (!empty($output_feedback_link)) {
	$body->set('feedback_link', $output_feedback_link);
}

if (!empty($output_participants)) {
	unset($user->identity_type);
	foreach($output_participants as $key => $p) {
 		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id']);
	}
	$body->set('participants', $output_participants);
}

if (!empty($output_identity2)) {
	$body->set('identity', $output_identity2);
}

if (!empty($output_participation)) {
	$body->set('relation_link', true);
 	$body->set('participation', $output_participation);
}

if (!empty($output_strong_ties)) {
	$body->set('strong_ties', $output_strong_ties);
}

if (!empty($output_bookmark)) {
	$body->set('bookmark', 1);
}

if (!empty($output_recommend)) {
	$body->set('recommend', 1);
}

if (!empty($output_recommend)) {
	$body->set('recommend', 1);
}

if (isset($output_event['event_private']) && !empty($output_event['event_private'])) {
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $core_config['user']['status']['active']) {
		// All active participants shall see the body-text
		$output_view_body_text = 1;
	}
	
	if (isset($output_participation['role_id']) && $output_participation['role_id'] == $event_config['role']['coordinator']) {
		// All coordinators shall see the body-text
		$output_view_body_text = 1;
	}
	
	if ($output_event['user_id'] == $_SESSION['user_id']) {
		// The owner shall see the body-text
		$output_view_body_text = 1;
	}
}
else { // The body-text is seen by everybody
	$output_view_body_text = 1;
}

if (isset($output_view_body_text)) {
	$body->set('view_body_text', 1);
}

// $body->set('event_config', $event_config);

?>