<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<script type="text/javascript">

	function highlightTags(i, mode) {
		var list = document.getElementById('tag_cloud').getElementsByTagName('span');
		
		var cls = "tag_"+i;
		if (mode == "over") {
			for(j = 0; j < list.length; j++) {
				if (list[j].className.substr(0, cls.length) == cls) {
					list[j].className = "tag_active";
				}
				else {
					if (list[j].className.length <= "tag_notactive".length) {
						list[j].className = list[j].className + " tag_notactive";
					}
				}
			}
		}
		else {
			for(j = 0; j < list.length; j++) {
				if (list[j].className == "tag_active") {
					list[j].className = "tag_"+i;
				}
				else {
					list[j].className = list[j].className.substr(0, "tag_active".length - 1);
				}
			}
		}
	}

</script>
	
<div class="col_left1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=core_tags#module_tags');" />
			
				<?php echo $lang['hdr_tagcloud']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php if (isset($tags)) { $i=0; ?>
				<p id="tag_cloud">
					<?php foreach($tags as $t): ?>
					<span class="tag_<?php echo $t['tag_count']; ?>">
						<a onmouseout="highlightTags(<?php echo $t['tag_count']?>, 'out');" onmouseover="highlightTags(<?php echo $t['tag_count']?>, 'over');" href="index.php?amn=evt_list&amp;event_tag=<?php echo $t['tag_body']; ?>"><?php echo $t['tag_body']; ?></a><sub><?php echo $t['tag_count']; ?></sub>
					</span>
					<?php endforeach; ?>
				</p>
				<?php
				} else {
				?>
					<p>
						<?php echo $lang['template_error']['err_no_items'];?><br />
					</p>
				<?php }?>
			</div>
		</div>
	</div>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=core_bookmarks');" />
			
				<?php echo $lang['hdr_highest_attendance']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php if (isset($events)) { ?>
				<p>
					<?php foreach($events as $e): ?>
						<a href="index.php?amn=evt_item&amp;event_id=<?php echo $e['event_id']; ?>"><?php echo $this->date->formatDate($e['event_start_datetime']); ?></a>: <?php echo $e['event_title']; ?> (<?php echo $e['count_attendance']; ?>) <br />
					<?php endforeach; ?>
				</p>
				<?php
				} else {
				?>
					<p>
						<?php echo $lang['template_error']['err_no_items'];?><br />
					</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=core_bookmarks');" />
			
				<?php echo $lang['hdr_most_recommended']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php if (isset($recommendations)) { ?>
				<p>
				<?php foreach($recommendations as $r): ?>
				<a href="index.php?amn=evt_item&amp;event_id=<?php echo $r['event_id'];?>"><?php echo $this->date->formatDate($r['event_start_datetime']); ?>:</a> <?php echo $r['event_title']; ?> (<?php echo $r['total']; ?>)<br />
				<?php endforeach; ?>
				</p>
				<?php } else { echo $lang['template_error']['err_no_items']; } ?>
			</div>
		</div>
	</div>
</div>