<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";

include_once ('config/evt.config.php');
include_once ("inc/evt_initiate.inc.php");


// FAVOURITES -----------------------------------------

if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['event']);
	$bookmark->item_id = $event->event_id;
	$bookmark->inner_item_id = $event->event_id;
	$bookmark->user_id = $_SESSION['user_id'];
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];

	if (isset($_POST['mark'])) {

		if ($_POST['mark'] == 1) {
			$bookmark->insertBookmark();
		}
		else {
			$bookmark->deleteBookmark();
		}
	}

	if (isset($_POST['recommend'])) {
		$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
	
		if ($_POST['recommend'] == 1) {
			$bookmark->insertBookmark();
		}
		else {
			$bookmark->deleteBookmark();
		}
	}
	
	$output_bookmark = $bookmark->selBookmarks();
	$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
	$output_recommend = $bookmark->selBookmarks();
}
// We need to check if this event is old or not
	$old_event = false; // assume it is not
	
	$query = "
		SELECT e.event_end_datetime
		FROM " . $db->prefix . "_event e
		WHERE e.event_id=" . $_REQUEST['event_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields['event_end_datetime'])) {
		if (date('Y-m-d h:i:s', time()) > $result->fields['event_end_datetime']) {
			$old_event = true;
		}
	}
	$result->Close();
	

if (isset($_REQUEST['identity_id'])) {
	$strong_relation = $participation->selRelations($output_participation['identity_id']);

	if (!empty($strong_relation)) {
		foreach($strong_relation as $s) {
			if ($s['identity_id_relation'] == $_REQUEST['identity_id']) {
				$body->set('destroy_relation', 1);
			}
		}
	}

	
	
	if (!empty($strong_relation) && isset($_REQUEST['destroy_relation'])) {
		// delete the relation
		$participation->deleteRelations(array($_REQUEST['identity_id']), $output_participation['identity_id']);
		header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
		exit;
	}
	
	if (isset($_REQUEST['create_relation']) && !empty($output_participation)) {
		// create the relation
		
		$data = array();
		$data['module_id'] = $core_config['module_id']['event'];
		$data['item_id'] = $_REQUEST['event_id'];
		$data['identity_id'] = $output_participation['identity_id'];
		$data['identity_id_relation'] = $_REQUEST['identity_id'];
		$data['relation_create_datetime'] = time();
		$data['relation_portable'] = 0;
		$data['user_id'] = $_SESSION['user_id'];
		
		$table  = $db->prefix . '_relation';
		$query  = $db->GetInsertSQL($table, $data, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
			exit;
		}
		else {
			// error-code here
		}
	}
}

if ($old_event) {
	if (!empty($output_participation)) {
		// Finally we need to check if the user already has done some feedback
		$query = "
			SELECT f.user_id
			FROM " . $db->prefix . "_event_feedback f
			WHERE f.user_id=" . $_SESSION['user_id'] . "
			AND f.event_id=" . $event->event_id
		;
			
		$result = $db->Execute($query);
		if (!empty($result->fields['user_id'])) {
			unset($_REQUEST['feedback']);
		}
		else {
			$output_feedback_link = true;
		}
		$result->Close();
		$event->identity_id = $output_participation['identity_id'];
	}
	else {
		unset($_REQUEST['feedback']);
	}
}
else {
	unset($_REQUEST['feedback']);
}
	
if (isset($_POST['activity_feedback'])) {
	$event->insertFeedback($_POST);
	if (empty($GLOBALS['am_error_log'])) {
		unset($_REQUEST['feedback'], $output_feedback_link); // we have done some feedback
		
		//Count the feedback for this event
		$query = "
			SELECT COUNT(*) AS total_event_feedback
			FROM " . $db->prefix . "_event_feedback
			WHERE event_id=" . $event->event_id
		;
		
		$result = $db->Execute($query);
		if (isset($result->fields)) {
			$total_event_feedback = $result->fields['total_event_feedback'];
			$result->Close();
		}
		else {
			// error-code here
		}
		
		// insert statistics ------------------------------
		require_once('components/core/class/Statistic.class.php');
		$statistic = new Statistic($db, $event_config['statistic']);
		$statistic->module_id = $core_config['module_id']['event'];
		$statistic->user_id = $_SESSION['user_id'];
		
		// insert event statistics
		$statistic->statistic_type_id = $event_config['statistic']['total_event_feedback'];
		$statistic->setStatistic($total_event_feedback);
	}
}


// If the event is old, we get the feedback from the event
if ($old_event) {

	if (isset($_SESSION['user_id'])) {
		$output_feedback = $event->selFeedback($output_event['user_id'] != $_SESSION['user_id']);
	}
	else {
		$output_feedback = $event->selFeedback(false);
	}
	
	$participation_freq = 0;
	$enjoyment_freq = 0;
	$arrangement_freq = 0;
	$total = 0;
	
	foreach($output_feedback as $t) {
		if ($t['feedback_participation']) {
			$participation_freq++;
		}
		if ($t['feedback_enjoyment']) {
			$enjoyment_freq++;
		}
		if ($t['feedback_arrangement']) {
			$arrangement_freq++;
		}
		$total++;
	}
		
	if ($total > 0) {
		$output_feedback_summery['total'] = $total;
		$output_feedback_summery['participation_total'] = $participation_freq;
		$output_feedback_summery['enjoyment_total'] = $enjoyment_freq;
		$output_feedback_summery['arrangement_total'] = $arrangement_freq;
		$output_feedback_summery['participation_freq'] = round($participation_freq / $total * 100);
		$output_feedback_summery['enjoyment_freq'] = $participation_freq == 0 ? 0 : round($enjoyment_freq / $participation_freq * 100);
		$output_feedback_summery['arrangement_freq'] = round($arrangement_freq / $total * 100);
		$body->set('feedback_summery', $output_feedback_summery);
	}
}

// Setup Tie -------------------------------------------------------------
require_once ("components/core/class/Tie.class.php");
$tie = new Tie($db, $core_config);
$tie->count_weak = true;
$tie->count_strong = true;
$tie->module_id = $core_config['module_id']['event'];
$tie->item_id = $_REQUEST['event_id'];

if (!empty($output_participation)) {
	$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
}
elseif (isset($_SESSION['user_id'])) {
 	$user->identity_type = $core_config['user']['identity']['type']['registered'];
  	$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
}

if (isset($_SESSION['user_id'])) {
	$output_common_ties = $tie->selCommonTies($output_event['identity_id'], $output_identity['identity_id']);
	$output_common_ties['is_mutual'] = $tie->isMutual($output_event['identity_id'], $output_identity['identity_id']);
	$output_common_ties['identity_id'] = $output_identity['identity_id'];
}

if (isset($_REQUEST['list'])) {
	$output_participants = $participation->selParticipants();
}

if (!empty($output_event)) {
	$output_event['count_participants'] = $participation->countParticipants($event_config['user']['status']['active']);
	$output_event['event_create_datetime'] = $event->date->formatDate($output_event['event_create_datetime'], 1);
	$body->set('event', $output_event);	
}


// we need to select my strong ties in this event.
if (!empty($output_participation)) {
$query = "
	SELECT t1.identity_id_relation AS identity_id, i.identity_nic
	FROM " . $db->prefix . "_relation AS t1 
	INNER JOIN " . $db->prefix . "_relation AS t2 
	ON t1.identity_id=t2.identity_id_relation 
	AND t1.identity_id_relation=t2.identity_id 
	AND t1.module_id=t2.module_id 
	AND t1.item_id=t2.item_id
	INNER JOIN " . $db->prefix . "_user_identity i
	ON t1.identity_id_relation=i.identity_id
	WHERE t1.identity_id=" . $output_participation['identity_id'] . "
	AND t1.identity_id_relation != " . $output_participation['identity_id'] . "
	AND t1.module_id=" . $core_config['module_id']['event'] . " 
	AND t1.item_id=" . $event->event_id
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_strong_ties = array();
	while(!$result->EOF) {
		array_push($output_strong_ties, $result->fields);
		$result->moveNext();
	}
	$result->Close();
}
}



if (isset($_REQUEST['identity_id'])) {
	$output_identity2 = $user->selUserIdentity(null, $_REQUEST['identity_id']);
}

if (!empty($output_common_ties)) {
	$body->set('common_ties', $output_common_ties);
}

if (!empty($output_feedback)) {
	$body->set('feedback', $output_feedback);
}

if (!empty($output_feedback_link)) {
	$body->set('feedback_link', $output_feedback_link);
}

if (!empty($output_participants)) {
	unset($user->identity_type);
	foreach($output_participants as $key => $p) {
 		$output_participants[$key]['identity'] = $user->selUserIdentity(null, $p['identity_id']);
	}
	$body->set('participants', $output_participants);
}

if (!empty($output_identity2)) {
	$body->set('identity', $output_identity2);
}

if (!empty($output_participation)) {
	$body->set('relation_link', true);
 	$body->set('participation', $output_participation);
}

if (!empty($output_strong_ties)) {
	$body->set('strong_ties', $output_strong_ties);
}

if (!empty($output_bookmark)) {
	$body->set('bookmark', 1);
}

if (!empty($output_recommend)) {
	$body->set('recommend', 1);
}

if (isset($output_event['event_private']) && !empty($output_event['event_private'])) {
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $event_config['user']['status']['active']) {
		// All active participants shall see the body-text
		$output_view_body_text = 1;
	}
	
	if (isset($output_participation['role_id']) && $output_participation['role_id'] == $event_config['role']['coordinator']) {
		// All coordinators shall see the body-text
		$output_view_body_text = 1;
	}
	
	if ($output_event['user_id'] == $_SESSION['user_id']) {
		// The owner shall see the body-text
		$output_view_body_text = 1;
	}
}
else { // The body-text is seen by everybody
	$output_view_body_text = 1;
}

if (isset($output_view_body_text)) {
	$body->set('view_body_text', 1);
}

// $body->set('event_config', $event_config);

?>