<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");

require_once($language_path_core . 'inc/html_edit.lang.inc.php');

if (empty($output_blog)) {
	header("Location: index.php?amn=blg_overview&" . strip_tags(SID));
	exit;
}

if (isset($_POST['preview_entry'])) {
	$output_entry = $_POST;
	
	require_once('components/core/class/Kses/kses.php');
		
	$output_entry['entry_body_preview'] = kses_parse($output_entry['entry_body'], 'max');

	$output_entry['entry_body'] = stripslashes($output_entry['entry_body']);
	$output_entry['entry_body_preview'] = stripslashes($output_entry['entry_body_preview']);
	$output_entry['entry_body_preview'] = $output_entry['entry_body_preview'];
	
	$body->set('entry', $output_entry);

}
elseif (isset($_POST['save_entry'])) {
	
	if (empty($_POST['entry_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (empty($_POST['entry_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$rec = array();
		$rec['entry_title'] = strip_tags($_POST['entry_title']);
		$rec['entry_synopsis'] = strip_tags($_POST['entry_synopsis']);
		
		require_once('components/core/class/Kses/kses.php');
		
		$rec['entry_body'] = kses_parse($_POST['entry_body'], 'max');
		
		if (!empty($_POST['entry_id'])) {
			
			$rec['entry_edit_datetime'] = time();
			
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_blog_entry 
				WHERE 
				entry_id=" . $_POST['entry_id']
			;
			
			$result = $db->Execute($query);
			
			if (isset($result->fields)) {
				$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
			
			header("Location: index.php?amn=blg_item&blog_id=" . $_POST['blog_id'] . "&entry_id=" . $_POST['entry_id'] . "&" . strip_tags(SID));
			exit;
		}
		else { // we insert
			$rec['blog_id'] = $_POST['blog_id'];
			$rec['entry_create_datetime'] = time();
			$rec['user_id'] = $_SESSION['user_id'];
			
			$table = $db->prefix . "_blog_entry";
			
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
				
			if (isset($result)) {
				$entry_id = $db->Insert_ID();
			}
		
			if (isset($entry_id)) {
				header("Location: index.php?amn=blg_item&blog_id=" . $_POST['blog_id'] . "&entry_id=" . $entry_id . "&" . strip_tags(SID));
				exit;
			}
		}
	}
	else {
		$output_entry = $_POST;
		
		if (get_magic_quotes_gpc()) {
 			$output_entry['entry_body'] = stripslashes($output_entry['entry_body']);
		}
	}
}


// file setup --------------------------------------------------
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->item_id = $output_blog['blog_id'];
$file->module_id = $core_config['module_id']['blog'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];

$output_images = $file->selFiles("images", "t2");
$output_files = $file->selFiles();

if (!empty($output_images)) {
	$body->set("images", $output_images);
}

if (!empty($output_files)) {
	$body->set("files", $output_files);
}

if (isset($_REQUEST['entry_id']) && !empty($output_entry)) {
	
	$body->set("entry", $output_entry);
}

$body->set("module_id", $core_config['module_id']['blog']);

?>
