<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$menu_section= "blog";

$output_blog['item_id'] = $output_blog['blog_id'];
$body->set('item', $output_blog);




// GET FAVOURITES --------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db, $core_config['module_id']['blog']);

// get my bookmarked favourites
$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
$output_bookmarks = $bookmark->selBookmarks(1);

if (!empty($output_bookmarks)) {
	// we get item_id's and we get the sets from that
	foreach ($output_bookmarks as $key => $i):
		$blog->blog_ids[] = $i['item_id'];
	endforeach;
	
	unset ($blog->file);
	
	if (!empty($blog->blog_ids)) {
		$output_bookmarks = $blog->selBlogs();
	}
	
	$body->set('recommendations', $output_bookmarks);
}






// GET USER STATISTICS ---------------------------------------------------
require_once('components/core/class/Statistic.class.php');
$statistic = new Statistic($db, $blog_config['statistic']);
$statistic->module_id = $core_config['module_id']['blog'];
$statistic->item_id = $output_blog['blog_id'];

$output_statistics['blog'] = $statistic->selStatistics();

if (!empty($output_statistics)) {
	$body->set('statistics', $output_statistics);
}


// WIKI SETS ------------------------------------------------
// get the wiki sets that I am contributing to
unset($participation->item_id);
$output_set_participation = $participation->selParticipants(null, null, $output_identity_relation['user_id']);

if (!empty($output_set_participation)) {
	// get participants for each item
	foreach($output_set_participation as $key => $i):
		$blog->blog_ids[] = $i['item_id'];
	endforeach;
	
	$blog->file = $file;
	$blog->file->module_id = $core_config['module_id']['blog'];
	$blog->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	$blog->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	

	$output_user_blogs = $blog->selBlogs();
	
	if (!empty($output_user_blogs)) {
		$body->set('user_blogs', $output_user_blogs);
	}		
}


// GET LATEST COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['blog']);

$comment->module_id = $core_config['module_id']['blog'];
$comment->item_id = $output_blog['blog_id'];
$comment->user_id = $output_identity_relation['user_id'];
$comment->limit = 4;
$comment->order_by = "c.comment_create_datetime desc";

$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$body->set('latest_comments', $output_comments);
}


// GET LATEST ENTRIES -------------------------------------------
$blog->limit = 16;
$blog->user_id = $output_identity_relation['user_id'];

$output_entries = $blog->selEntries();

if (!empty($output_entries)) {
	$body->set('entries', $output_entries);
}

?>
