<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['blog'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$blog->file = $file;

// get the latest entries
$blog->limit = 16;
$output_entries = $blog->selEntries(null);

if (!empty($output_entries)) {
	$body->set('entries', $output_entries);
}

// get latest blogs
$blog->limit = 4;
$blog->order_by = "blog_create_datetime desc";
$output_blogs = $blog->selBlogs();

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

unset ($blog->order_by, $blog->limit);


// participation in blogs
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['blog'];
	$participation->status_id = $blog_config['user']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$blog->blog_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($blog->blog_ids)) {
			$output_my_blogs = $blog->selBlogs();
		}

		if (!empty($output_my_blogs)) {
			$body->set('my_blogs', $output_my_blogs);
		}
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['blog']);
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$blog->blog_ids[] = $i['item_id'];
		endforeach;
		
		unset ($blog->file);
		
		if (!empty($blog->blog_ids)) {
			$output_my_bookmarks = $blog->selBlogs();
		}
		
		if (!empty($output_my_bookmarks)) {
			$body->set('my_bookmarks', $output_my_bookmarks);
		}
	}
	
	// REVISIONS FROM RESPECTED NETWORK
	unset($participation->item_id);
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	$output_respected_network = $participation->selRelations();
	
	if (!empty($output_respected_network)) {
		// add their identities
		foreach ($output_respected_network as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_respected_network as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						
						if ($p['identity_id'] == $i['identity_id']) {
							$output_respected_network[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
		}
		
		
		// get their latest entry
		foreach ($output_respected_network as $key => $i):
		
			$query = "
				SELECT e.entry_id, e.entry_id, e.entry_title, 
				e.entry_create_datetime 
				FROM " . $db->prefix . "_blog_entry e, " . $db->prefix . "_participation p 
				WHERE 
				e.user_id=" . $i['identity']['user_id'] . " AND 
				p.module_id=" . $core_config['module_id']['blog'] . " AND
				p.identity_id=" . $i['identity']['identity_id'] . " AND 
				p.user_id=e.user_id AND 
				order by e.entry_create_datetime desc"
			;
			
			$result = $db->SelectLimit($query, 1);
	
			if (isset($result->fields)) {
				$output_respected_network[$key]['entry'] = $result->fields;
			}
		endforeach;
		
		$body->set('tied_entries', $output_respected_network);
		
		// get latest comments from respected network
		require_once('components/core/class/Comment.class.php');
		$comment = new Comment($db, $core_config['module_id']['blog']);
		$comment->module_id = $core_config['module_id']['blog'];
		
		foreach ($output_respected_network as $key => $i):
			$comment->user_ids[] = $i['identity']['user_id'];
		endforeach;
		
		$comment->user_ids = array_unique($comment->user_ids);
		
		if (!empty($comment->user_ids)) {
			$comment->order_by = "c.comment_create_datetime desc";
			$comment->limit = 10;
			
			$output_tied_comments = $comment->selComments();
			
			// cut down comment body and apply identities
			if (!empty($output_identities)) {
				foreach ($output_tied_comments as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_tied_comments[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('tied_comments', $output_tied_comments);
		}
	}
}

?>
