//  Copyright (C) 2011, 2014 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>

#include <gtkmm.h>
#include <sigc++/functors/mem_fun.h>

#include "preferences-dialog.h"

#include "glade-helpers.h"
#include "ucompose.hpp"
#include "defs.h"
#include "Configuration.h"

PreferencesDialog::PreferencesDialog()
{
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(get_glade_path()
				    + "/preferences-dialog.ui");

    xml->get_widget("dialog", dialog);

    xml->get_widget("play_music_checkbutton", play_music_checkbutton);
    play_music_checkbutton->set_active(Configuration::s_musicenable);
    play_music_checkbutton->signal_toggled().connect(
	sigc::mem_fun(this, &PreferencesDialog::on_play_music_toggled));
    
}

PreferencesDialog::~PreferencesDialog()
{
  delete dialog;
}

void PreferencesDialog::set_parent_window(Gtk::Window &parent)
{
    dialog->set_transient_for(parent);
}

void PreferencesDialog::hide()
{
  dialog->hide();
}

void PreferencesDialog::run()
{
    dialog->show();
    dialog->run();
    dialog->hide();
    Configuration::saveConfigurationFile(Configuration::configuration_file_path);
}

void PreferencesDialog::on_play_music_toggled()
{
    bool play_music = play_music_checkbutton->get_active();

    Configuration::s_musicenable = play_music;
}
