//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <sigc++/functors/mem_fun.h>

#include "raftlist.h"
#include "raft.h"
#include "GameMap.h"
#include "xmlhelper.h"

std::string Raftlist::d_tag = "raftlist";
//#define debug(x) {cerr<<__FILE__<<": "<<__LINE__<<": "<<x<<endl<<flush;}
#define debug(x)

Raftlist* Raftlist::s_instance=0;

Raftlist* Raftlist::getInstance()
{
    if (s_instance == 0)
        s_instance = new Raftlist();

    return s_instance;
}

Raftlist* Raftlist::getInstance(XML_Helper* helper)
{
    if (s_instance)
        deleteInstance();

    s_instance = new Raftlist(helper);
    return s_instance;
}

void Raftlist::deleteInstance()
{
    if (s_instance)
        delete s_instance;

    s_instance = 0;
}

Raftlist::Raftlist()
{
}

Raftlist::Raftlist(XML_Helper* helper)
{
    helper->registerTag(Raft::d_tag, sigc::mem_fun(this, &Raftlist::load));
}

bool Raftlist::save(XML_Helper* helper) const
{
    bool retval = true;

    retval &= helper->openTag(Raftlist::d_tag);

    for (const_iterator it = begin(); it != end(); it++)
        retval &= (*it)->save(helper);
    
    retval &= helper->closeTag();

    return retval;
}

bool Raftlist::load(std::string tag, XML_Helper* helper)
{
    if (tag != Raft::d_tag)
    //what has happened?
        return false;
    
    push_back(new Raft(helper));

    return true;
}
