//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "raft.h"

std::string Raft::d_tag = "raft";

Raft::Raft(Vector<int> src, Vector<int> dest)
{
  d_src = src;
  d_dest = dest;
  d_is_at_destination = false;
}

Raft::Raft(XML_Helper* helper)
{
  int x, y;
  helper->getData(x, "src_x");
  helper->getData(y, "src_y");
  d_src.x = x;
  d_src.y = y;
  helper->getData(x, "dest_x");
  helper->getData(y, "dest_y");
  d_dest.x = x;
  d_dest.y = y;
  helper->getData(d_is_at_destination, "at_destination");
}

Raft::Raft(const Raft& s)
  :d_src(s.d_src), d_dest(s.d_dest), d_is_at_destination(s.d_is_at_destination)
{
}

Raft::~Raft()
{
}

bool Raft::save(XML_Helper* helper) const
{
    bool retval = true;

    retval &= helper->openTag(Raft::d_tag);
    retval &= helper->saveData("src_x", d_src.x);
    retval &= helper->saveData("src_y", d_src.y);
    retval &= helper->saveData("dest_x", d_dest.x);
    retval &= helper->saveData("dest_y", d_dest.y);
    retval &= helper->saveData("at_destination", d_is_at_destination);
    retval &= helper->closeTag();
    
    return retval;
}
