// Copyright (C) 2004 John Farrell
// Copyright (C) 2005, 2007 Ulf Lorenz
// Copyright (C) 2009, 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef MOVE_RESULT_H
#define MOVE_RESULT_H

#include "fight.h"

using namespace std;
class Stack;

/** 
  * This is needed by the AI so it can tell when a stack dies.
  */
//! The result of a move by a stack.
class MoveResult
{
    public:
        MoveResult();
        ~MoveResult();

        //! set the result of any fight that happened
        void setFightResult(Fight::Result d_fightResult);

        //! set how many steps were taken in this move
        void setStepCount(int stepCount) { d_stepCount = stepCount; }

        int getStepCount() const {return d_stepCount;};

        //! return the result of the fight, if there was one
        Fight::Result getFightResult() const { return d_fightResult; }

        //! did anything actually happen in this move?
        bool didSomething() const { return (d_fight || (d_stepCount > 0) ); }

        void setTooLargeStackInTheWay(bool s) {d_too_large_stack_in_the_way=s;}
        bool getTooLargeStackInTheWay() const {return d_too_large_stack_in_the_way;}

        void setMoveAborted(bool a) {d_move_aborted = a;}
        bool getMoveAborted() const {return d_move_aborted;}

	void fillData(Stack *s, int stepCount);

    private:
        bool d_result;
        bool d_fight;
        int d_stepCount;
        //this is when we can't jump over a friendly stack.
        bool d_too_large_stack_in_the_way;
        Fight::Result d_fightResult;
        bool d_move_aborted;
};

#endif // MOVE_RESULT_H

// End of file
