// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef DEFINITIONS_H
#define DEFINITIONS_H

#include <gtkmm.h>
#include <glibmm.h>
#include <string>
#include <libintl.h>

#define ARMY_SAVEGAME_VERSION "0.0.0"
#define ARMY_ARMYSET_VERSION "0.0.0"
#define ARMY_CONFIG_VERSION "0.0.0"
#define ARMY_MUSIC_VERSION "0.0.0"

const unsigned int MAX_PLAYERS = 2;
const unsigned int MAX_STACK_SIZE = 1;
const unsigned int MAX_ARMIES_ON_A_SINGLE_TILE = 2;

const unsigned int MAP_SIZE_NORMAL_WIDTH = 52;
const unsigned int MAP_SIZE_NORMAL_HEIGHT = 48;

#define HUMAN_PLAYER_TYPE "Human"
#define DUMMY_PLAYER_TYPE "Dummy"
#define NO_PLAYER_TYPE "Off"

const std::string ARMYSETDIR = "armysets";
const std::string MAPDIR = "maps";
const std::string ARMYSET_EXT = ".ast";
const std::string MAP_EXT = ".map";
const std::string SAVE_EXT = ".sav";

const unsigned int CURSOR_TYPES = 2;
const unsigned int DICE_TYPES = 6 + 1;
#endif // DEFINITIONS_H

