// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef NEXT_TURN_H
#define NEXT_TURN_H

#include <sigc++/trackable.h>
#include <sigc++/connection.h>
#include "playerlist.h"

class NextTurn: public sigc::trackable
{
    public:
        NextTurn();

        ~NextTurn();
        
        virtual void start()=0;

        virtual void endTurn()=0;

	void stop();

	void nextPlayer();

        void setContinuingTurn() { continuing_turn = true; };

        /**
           \brief signals for announcing events
         */
        sigc::signal<void, Player*> splayerStart;

	// emitted whenever a new player's turn starts.
        sigc::signal<void, Player*> snextTurn;
        
        //! Signal which is emitted whenever a new round starts
        sigc::signal<void> snextRound;

        //! Signal as a workaround for a display bug; updates the screen
        sigc::signal<void> supdating;

	//! Signal when we're done doing next-turn duties.
        sigc::signal<void> srequestAbort;

    protected:

        //! If set to true, the game is interrupted at the next occasion
        bool d_stop;

        // whether we're starting a turn again from loading a game
        bool continuing_turn;

    protected:

	sigc::connection abort;
};

#endif //NEXT_TURN_H
