// generated by: arc -xuNP -A ./../argrt -M -o std_use.c -H std_use.h -m std_use.argl.tmp std_use.arg 
#include "std_use.h"

/** :_syn_to_call <list of (argile syntax) ls>: -> list of ((argile) match) **/
static argrt_list_t * _syn_to_call(argrt_list_t *);
/** :_not_local <call> <shovel sh> <int mid>: -> bool **/
static unsigned char _not_local(argile_call_t *, argile_shovel_t *, int);
/** :_use_match <call> <match m>: -> bool **/
static unsigned char _use_match(argile_call_t *, argile_match_t *);

int argmod_use_defmaker = 1;
int argmod_use_modulable = 1;
char( argmod_use_doc[]) = "Use an external argile source file, importing its global definitions.\nIt takes a first list containing either a word or text parameter, followed\nby a word or text parameter, which are file names (a `.argl' or `.arg' may\nbe implicitely appended to match real file names). An optional second list\nof parameters of type syntax, followed by another parameter of type syntax,\nmay be specified to tell which local definitions must be defined before\nincluding the list of source files. If the binding option `include' is set,\nthe global definitions exported by the included file will also be exported\nwhen current file is used or included.\nSyntax requirements:\n  :[ {<word>|<text>} , ...] {<word>|<text>} ([<syntax> , ...] <syntax>):\n";

/** :argmod_use_reject <call>: -> int **/
int argmod_use_reject(argile_call_t * p_argile_call)
{
  int parmid = 0;
  char( tmp[64]);
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  unsigned char ret;

  if ((argile).deps_only) {
    return 0;
  }
  if ((((p_argile_call)->owner) && (((p_argile_call)->owner)->type == ARGILE_CALL_IMPLICIT))) {
    return 0;
  }
  sh = argile_shovel_new(p_argile_call);
  while ((argile_shovel_diglist(sh, 2) > 0)) {
    (parmid)++;
    if (_not_local(p_argile_call, sh, 1)) {
      argile_shovel_del(sh);
      snprintf(((char *)tmp), sizeof(tmp), "std/use: ""parameter %d in second list is not a local definition", parmid);
      ({
        argile_call_add_reject(p_argile_call, ((char *)tmp));
        return -1;
      });
    }
    argile_shovel_shiftlist(sh, 2, 1);
  };
  ret = _not_local(p_argile_call, sh, 2);
  argile_shovel_del(sh);
  if (ret) {
    ({
      argile_call_add_reject(p_argile_call, "std/use: ""last parameter is not a local definition");
      return -1;
    });
  }
  return 0;
}

/** :_syn_to_call <list of (argile syntax) ls>: -> list of ((argile) match) **/
static argrt_list_t * _syn_to_call(argrt_list_t * ls)
{
  argrt_list_t * lm = ((argrt_list_t *)0);

  for (; (ls); ls = ((argrt_list_t *)ls)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)ls)->data);
    switch ((s)->type) {
      case ARGILE_SYN_WORD: {
        argile_match_t * m = ((argile_match_t *)0);

        m = argile_match_new(ARGILE_MATCH_WORD, ARGRT_strdup(((s)->value).syn_word));
        argrt_list_append(&lm, argrt_list_new(((void *)((long)m)), (void *)&argile_match_del));
      } break;
      case ARGILE_SYN_OP: {
        argile_match_t * m = ((argile_match_t *)0);

        m = argile_match_new(ARGILE_MATCH_OP, ARGRT_strdup(((s)->value).syn_op));
        argrt_list_append(&lm, argrt_list_new(((void *)((long)m)), (void *)&argile_match_del));
      } break;
      case ARGILE_SYN_PARAM: {} break;
      case ARGILE_SYN_OPTION: ;
      case ARGILE_SYN_ENUM: ;
      case ARGILE_SYN_LIST: {} break;
      default: {} break;
    };
  };
  return argrt_list_start(lm);
}

/** :_not_local <call> <shovel sh> <int mid>: -> bool **/
static unsigned char _not_local(argile_call_t * p_argile_call_2, argile_shovel_t * sh, int mid)
{
  argile_match_t * m = ((argile_match_t *)0);
  argile_code_t * c = ((argile_code_t *)0);
  argrt_list_t * s;
  argrt_list_t * vcall;
  int vlen = 0;
  argrt_list_t * ld;

  m = argile_shovel_digmatch(sh, mid, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0);
  if ((m == ((argile_match_t *)0))) {
    return 0;
  }
  c = (p_argile_call_2)->scope;
  while (((c) && ((c)->ghost))) {
    c = (c)->upper;
  };
  if ((c == ((argile_code_t *)0))) {
    return 1;
  }
  s = argile_match_eval_syntax(m);
  vcall = _syn_to_call(s);
  vlen = ((int)argrt_list_count(vcall));
  ld = (c)->defs;
  for (; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if ((d)->implicit) {
      continue;
    }
    if ((argile_match_try((d)->syntax, vcall, vlen, ((int *)0), 0))) {
      argrt_list_delete_all(vcall);
      return 0;
    }
  };
  argrt_list_delete_all(vcall);
  return 1;
}

/** :argmod_use_compile <call>: -> nothing **/
void argmod_use_compile(argile_call_t * p_argile_call_3)
{
  argile_shovel_t * sh_2 = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);
  unsigned char ok;

  sh_2 = argile_shovel_new(p_argile_call_3);
  ok = 1;
  while ((ok && (argile_shovel_diglist(sh_2, 1) > 0))) {
    if (((m = argile_shovel_digmatch(sh_2, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0)) || (m = argile_shovel_digmatch(sh_2, 1, (argile_type_t)ARGILE_TYPE_TEXT, (char *)0)))) {
      ok = _use_match(p_argile_call_3, m);
    }
    argile_shovel_shiftlist(sh_2, 1, 1);
  };
  if (ok) {
    if (((((m = argile_shovel_digmatch(sh_2, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0)) || (m = argile_shovel_digmatch(sh_2, 1, (argile_type_t)ARGILE_TYPE_TEXT, (char *)0))) || (m = argile_shovel_digmatch(sh_2, 2, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))) || (m = argile_shovel_digmatch(sh_2, 2, (argile_type_t)ARGILE_TYPE_TEXT, (char *)0)))) {
      _use_match(p_argile_call_3, m);
    }
  }
  argile_shovel_del(sh_2);
}

/** :_use_match <call> <match m>: -> bool **/
static unsigned char _use_match(argile_call_t * p_argile_call_4, argile_match_t * m)
{
  char * filename = "";

  if (!(((filename = argile_match_eval_word(m))))) {
    argile_text_t * text = ((argile_text_t *)0);

    if (((text = argile_match_eval_text(m)))) {
      filename = (text)->str;
    }
  }
  if (!((filename))) {
    argile_die_at(p_argile_call_4, "std/use: ""only word or text constant are allowed");
  }
  else {
    argile_file_t * file = ((argile_file_t *)0);

    file = argile_loadfile(filename);
    if ((file == ((argile_file_t *)0))) {
      return 0;
    }
    if ((argile_def_has_option((p_argile_call_4)->def, "include"))) {
      argile_code_include((p_argile_call_4)->scope, (file)->code, 1);
    }
    else {
      argile_code_include((p_argile_call_4)->scope, (file)->code, 0);
    }
  }
  return 1;
}

