// generated by: arc -xuNP -A ./../argrt -M -o std_gencode.c -H std_gencode.h -m std_gencode.argl.tmp std_gencode.arg 
#include "std_gencode.h"

/** :eval text <match m>: -> argile text **/
static argile_text_t * eval_text(argile_match_t *);

char( argmod_gencode_doc[]) = "Generate code for all its arguments (in a list of any parameter),\nwithout separating them.\nIf the binding option `ref' is set, and the first parameter is a\ntext constant literal beginning by any number of `*' and `&'\nthen they will be understood as address of/dereferencing C operators,\nand they will be compressed for a clearer C output.\nIf the binding option `no_semicolon' is set, the next output\nline ending semicolon will be inhibited.\nSyntax requirements:\n  :[<any>...]:\n";
int argmod_gencode_isconst = 1;

/** :argmod_gencode_gettype <call>: -> argile type **/
argile_type_t argmod_gencode_gettype(argile_call_t * p_argile_call)
{
  return (p_argile_call)->context;
}

/** :eval text <match m>: -> argile text **/
static argile_text_t * eval_text(argile_match_t * m)
{
  if (((m)->type == ARGILE_MATCH_CONS)) {
    argile_cons_t * c = ((argile_cons_t *)0);

    c = ((m)->value).cons;
    if (((c)->ctype == ARGILE_CONS_TEXT)) {
      return ((c)->cvalue).text;
    }
  }
  return ((argile_text_t *)0);
}

/** :argmod_gencode_gencode <call>: -> nothing **/
void argmod_gencode_gencode(argile_call_t * p_argile_call_2)
{
  unsigned char has_ref;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  int p_num = 1;

  has_ref = (argile_def_has_option((p_argile_call_2)->def, "ref"));
  sh = argile_shovel_new(p_argile_call_2);
  while ((argile_shovel_diglist(sh, 1) > 0)) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = argile_shovel_diganymatch(sh, 1, (char *)0);
    if ((m_2)) {
      argile_text_t * txt = ((argile_text_t *)0);

      txt = eval_text(m_2);
      if ((txt)) {
        if ((has_ref && (p_num == 1))) {
          int i = 0;
          unsigned char looping;

          looping = 1;
          while ((looping && (i < (txt)->len))) {
            switch (((txt)->str)[i]) {
              case '&': {
                argile_ref(-1);
                (i)++;
              } break;
              case '*': {
                argile_ref(1);
                (i)++;
              } break;
              default: {
                looping = 0;
              } break;
            };
          };
          argile_output((((txt)->str) + i), ((txt)->len - i));
        }
        else {
          argile_output((txt)->str, (txt)->len);
        }
      }
      else {
        argile_match_gencode(m_2);
      }
    }
    (p_num)++;
    argile_shovel_shiftlist(sh, 1, 1);
  };
  argile_shovel_del(sh);
  if ((((p_argile_call_2)->owner == ((argile_call_t *)0)) && (argile_def_has_option((p_argile_call_2)->def, "no_semicolon")))) {
    (argile).no_semicolon = 1;
  }
}

