// generated by: arc -xuNP -A ./../argrt -M -o std_funcdef.c -H std_funcdef.h -m std_funcdef.argl.tmp std_funcdef.arg 
#include "std_funcdef.h"

/** :<match m> has var type: -> bool **/
static unsigned char has_var_type(argile_match_t *);
/** :make syntax <(list of (argile syntax)) & syntax> <list of (match) match>: -> nothing **/
static void make_syntax(argrt_list_t * *, argrt_list_t *);
/** :make params <list of (argile syntax) syn>: -> list of ((argile) syn param) **/
static argrt_list_t * make_params(argrt_list_t *);

char( argmod_funcdef_doc[]) = "Define a function, a macro or an anonymous function.\nNeeds a syntax, or a word (parameter-less function or macro).\nWhen the binding option `macro' is specified, it defines a macro instead\nof a function. When no word or syntax parameter is specified, an anonymous\nfunction is returned.\nIf the binding option `private' is set, the definition\nis private to the module (not exported; equivalent to `static' in C).\nIf the binding option `Cmacro' is set, it defines a C-macro (with #define)\ninstead of a C function.\nMay also return the function body code, when it's not a macro or C-macro.\nSyntax requirements:\n  :( {<syntax>|<word>} ) (<type>) <code>:\n";
int argmod_funcdef_isconst = 1;
int argmod_funcdef_defmaker = 1;

/** :argmod_funcdef_gettype <call>: -> argile type **/
argile_type_t argmod_funcdef_gettype(argile_call_t * p_argile_call)
{
  argile_type_t t;
  argile_shovel_t * sh = ((argile_shovel_t *)0);

  t = (argile_type_t)ARGILE_TYPE_NOTHING;
  sh = argile_shovel_new(p_argile_call);
  if ((!((argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) && !((argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))))) {
    t = (argile_type_t)ARGILE_TYPE_CODE;
  }
  argile_shovel_del(sh);
  if ((((p_argile_call)->context != (argile_type_t)ARGILE_TYPE_NOTHING) && (((p_argile_call)->owner) && !(((argile_def_has_option((p_argile_call)->def, "macro")) || (argile_def_has_option((p_argile_call)->def, "Cmacro"))))))) {
    if (((p_argile_call)->context == (argile_type_t)ARGILE_TYPE_CODE)) {
      return (argile_type_t)ARGILE_TYPE_CODE;
    }
    return (((int)(p_argile_call)->context) & ((1 << 30) - 1));
  }
  return t;
}

/** :argmod_funcdef_compile <call>: -> nothing **/
void argmod_funcdef_compile(argile_call_t * p_argile_call_2)
{
  argile_type_t type;
  unsigned char del_syn;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argrt_list_t * syntax = ((argrt_list_t *)0);
  argile_code_t * code = ((argile_code_t *)0);
  unsigned char got_type;
  unsigned char var_type;
  argile_match_t * m = ((argile_match_t *)0);
  unsigned char got_syn;

  del_syn = 0;
  sh = argile_shovel_new(p_argile_call_2);
  got_type = 0;
  var_type = 0;
  m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
  if ((m)) {
    type = argile_match_eval_type(m);
    got_type = 1;
    var_type = has_var_type(m);
  }
  else {
    type = (argile_type_t)ARGILE_TYPE_NOTHING;
  }
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0))) {
    code = argile_match_eval_code(m);
  }
  got_syn = 0;
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) {
    syntax = argile_match_eval_syntax(m);
    got_syn = 1;
  }
  else if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))) {
    char * word = "";

    word = argile_match_eval_word(m);
    if ((word)) {
      word = ARGRT_strdup(word);
      syntax = argrt_list_new(((void *)((long)argile_syntax_new(ARGILE_SYN_WORD, word))), (void *)&argile_syntax_del);
      del_syn = 1;
      got_syn = 1;
    }
  }
  if ((got_syn && (code))) {
    argile_def_t * d = ((argile_def_t *)0);
    argrt_list_t * params;
    argrt_list_t * lp;

    (p_argile_call_2)->data = code;
    (code)->type = type;
    if ((argile_def_has_option((p_argile_call_2)->def, "macro"))) {
      (code)->macro = 1;
      (code)->cmacro = 0;
    }
    if ((argile_def_has_option((p_argile_call_2)->def, "Cmacro"))) {
      (code)->cmacro = 1;
      (code)->macro = 0;
    }
    d = argile_def_new(syntax, ((int)del_syn), type, p_argile_call_2, ARGILE_DEF_FUNC, code);
    (code)->func = d;
    (d)->vartype = var_type;
    (d)->private = (argile_def_has_option((p_argile_call_2)->def, "private"));
    if ((((p_argile_call_2)->context != (argile_type_t)ARGILE_TYPE_NOTHING) && (((p_argile_call_2)->owner) && !(((code)->macro || (code)->cmacro))))) {
      (d)->locall = 1;
    }
    argile_code_def((p_argile_call_2)->scope, d, 1);
    params = make_params(syntax);
    (code)->has_params = (params != ((argrt_list_t *)0));
    lp = params;
    for (; (lp); lp = ((argrt_list_t *)lp)->next) {
      argile_syn_param_t * p = ((argile_syn_param_t *)0);

      p = *((argile_syn_param_t * *)&((argrt_list_t *)lp)->data);
      syntax = ((argrt_list_t *)0);
      if (((p)->name)) {
        char * word = "";

        word = ARGRT_strdup((p)->name);
        syntax = argrt_list_new(((void *)((long)argile_syntax_new(ARGILE_SYN_WORD, word))), (void *)&argile_syntax_del);
      }
      else {
        make_syntax(&syntax, (p)->match);
        syntax = argrt_list_start(syntax);
      }
      if ((syntax != ((argrt_list_t *)0))) {
        argile_def_t * def = ((argile_def_t *)0);

        def = argile_def_new(syntax, 1, (((((((int)(p)->type) >> 30) & 1))) ? ((p)->type) : ((((int)(((int)(p)->type) & ((1 << 30) - 1))) | (1 << 31)))), ((argile_call_t *)0), ARGILE_DEF_VAR, argile_var_new((p)->type, ((argile_match_t *)0)));
        (def)->param = p;
        if ((((p)->def) && ((p)->def)->locall)) {
          argile_def_reuse_var((p)->def, ((def)->dval).var);
        }
        (p)->def = def;
        argile_code_def(code, def, 1);
      }
    };
    argrt_list_delete_all(params);
  }
  else if ((code)) {
    if (((code)->anon == (char *)0)) {
      argile_code_anon(code);
    }
    if (got_type) {
      (code)->type = type;
    }
    (p_argile_call_2)->data = code;
  }
  else if (((syntax) && del_syn)) {
    argrt_list_delete_all(syntax);
  }
  argile_shovel_del(sh);
}

/** :<match m> has var type: -> bool **/
static unsigned char has_var_type(argile_match_t * m)
{
  if ((m == ((argile_match_t *)0))) {
    return 0;
  }
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * sub = ((argile_call_t *)0);
    argrt_list_t * lm;

    sub = ((m)->value).call;
    if ((((sub)->def) && (((sub)->def)->locall || ((sub)->def)->vartype))) {
      return 1;
    }
    for (lm = (sub)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
      if (has_var_type(((argile_match_t *)*((argile_match_t * *)&((argrt_list_t *)lm)->data)))) {
        return 1;
      }
    };
  }
  return 0;
}

/** :make syntax <(list of (argile syntax)) & syntax> <list of (match) match>: -> nothing **/
static void make_syntax(argrt_list_t * * syntax, argrt_list_t * match)
{
  argrt_list_t * lm;

  for (lm = match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = ((argile_match_t *)*((argile_match_t * *)&((argrt_list_t *)lm)->data));
    if ((m_2 == ((argile_match_t *)0))) {
      continue;
    }
    switch ((m_2)->type) {
      case ARGILE_MATCH_WORD: {
        char * str = "";
        argile_syntax_t * syn = ((argile_syntax_t *)0);

        str = ARGRT_strdup(((m_2)->value).word);
        syn = argile_syntax_new(ARGILE_SYN_WORD, str);
        argrt_list_append(syntax, argrt_list_new(((void *)((long)syn)), (void *)&argile_syntax_del));
      } break;
      case ARGILE_MATCH_OP: {
        char * str = "";
        argile_syntax_t * syn = ((argile_syntax_t *)0);

        str = ARGRT_strdup(((m_2)->value).op);
        syn = argile_syntax_new(ARGILE_SYN_OP, str);
        argrt_list_append(syntax, argrt_list_new(((void *)((long)syn)), (void *)&argile_syntax_del));
      } break;
      case ARGILE_MATCH_SUBCALL: {
        make_syntax(syntax, (((m_2)->value).call)->match);
      } break;
      default: {} break;
    };
  };
}

/** :make params <list of (argile syntax) syn>: -> list of ((argile) syn param) **/
static argrt_list_t * make_params(argrt_list_t * syn)
{
  argrt_list_t * params = ((argrt_list_t *)0);

  for (; (syn); syn = ((argrt_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syn)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        argrt_list_append(&params, argrt_list_new(((void *)((long)((s)->value).syn_param)), ((argile_deleter_t)0)));
      } break;
      case ARGILE_SYN_OPTION: {
        argrt_list_append(&params, make_params(((s)->value).syn_option));
        params = argrt_list_end(params);
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * enm;

        enm = ((s)->value).syn_enum;
        for (; (enm); enm = ((argrt_list_t *)enm)->next) {
          argrt_list_append(&params, make_params(*((argrt_list_t * *)&((argrt_list_t *)enm)->data)));
          params = argrt_list_end(params);
        };
      } break;
      case ARGILE_SYN_LIST: {
        argrt_list_append(&params, make_params((((s)->value).syn_list)->sub));
        params = argrt_list_end(params);
      } break;
      default: {} break;
    };
  };
  return argrt_list_start(params);
}

/** :argmod_funcdef_reject <call>: -> int **/
int argmod_funcdef_reject(argile_call_t * p_argile_call_3)
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * mword = ((argile_match_t *)0);
  argile_match_t * mcode = ((argile_match_t *)0);

  sh = argile_shovel_new(p_argile_call_3);
  mword = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  mcode = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0);
  argile_shovel_del(sh);
  if (((mword) && !((argile_match_eval_word(mword))))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""word parameter is not constant");
  }
  if (!((mcode))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""no body code parameter");
  }
  if (!((argile_match_eval_code(mcode)))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""body code parameter is not constant");
  }
  return 0;
}

/** :argmod_funcdef_gencode <call>: -> nothing **/
void argmod_funcdef_gencode(argile_call_t * p_argile_call_4)
{
  argile_code_t * code = ((argile_code_t *)0);

  code = ((argile_code_t *)(p_argile_call_4)->data);
  if (((p_argile_call_4)->owner == ((argile_call_t *)0))) {
    return;
  }
  if ((code)) {
    if (((code)->anon)) {
      argile_puts("&");
      argile_puts((code)->anon);
    }
    else if ((((p_argile_call_4)->context != (argile_type_t)ARGILE_TYPE_NOTHING) && !(((code)->macro || (code)->cmacro)))) {
      argile_def_t * def = ((argile_def_t *)0);

      def = argile_util_getfuncdef(code);
      if (((p_argile_call_4)->context == (argile_type_t)ARGILE_TYPE_CODE)) {
        argile_puts("(void *(*)(void *, ...))");
      }
      else {
        argile_puts("(void *)");
      }
      argile_puts("&");
      argile_puts((((def)) ? (argile_def_gen_id(def)) : ("0")));
    }
  }
}

