// generated by: arc -xuNP -A ./../argrt -M -o std_ctype.c -H std_ctype.h -m std_ctype.argl.tmp std_ctype.arg 
#include "std_ctype.h"

int argmod_ctype_defmaker = 1;
argile_type_t argmod_ctype_type = ARGILE_TYPE_TYPE;
char( argmod_ctype_doc[]) = {"Define a new C type, by specifying C syntax; takes a word or\nsyntax parameter for the name of the type, a text parameter for\nthe C prefix, and an optional second text parameter for the C suffix.\nIf the prefix is omitted, it will be guessed from syntax (or word).\nWith bind option `def' a C-typedef will be generated at top level.\nSyntax requirements:\n  :<word>:\n  :<word> <text>:\n  :<syntax> <text>:\n  :{<word>|<syntax>} <text> (<text>):\n"};

/** :argmod_ctype_evaltype <call>: -> argile type **/
argile_type_t argmod_ctype_evaltype(argile_call_t * p_argile_call)
{
  argile_type_t t;

  if (((p_argile_call)->data != NULL)) {
    return ((argile_type_t)((long)(p_argile_call)->data));
  }
  t = argile_type_new();
  (p_argile_call)->data = ((void *)((long)t));
  (p_argile_call)->keep_data = 1;
  argile_type_set_info(t, ARGILE_TYPE_KIND_CTYPE);
  return t;
}

/** :argmod_ctype_compile <call>: -> nothing **/
void argmod_ctype_compile(argile_call_t * p_argile_call_2)
{
  argrt_list_t * syn = ((argrt_list_t *)0);
  int del_syn = 0;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);

  sh = argile_shovel_new(p_argile_call_2);
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) {
    syn = argile_match_eval_syntax(m);
  }
  else if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))) {
    char * word = "";

    if (((word = argile_match_eval_word(m)))) {
      syn = argrt_list_new(((void *)((long)argile_syntax_new(ARGILE_SYN_WORD, ARGRT_strdup(word)))), (void *)&argile_syntax_del);
      del_syn = 1;
    }
  }
  if ((syn)) {
    argile_type_t t;
    argile_def_t * d = ((argile_def_t *)0);
    argile_type_info_t * i = ((argile_type_info_t *)0);

    t = argmod_ctype_evaltype(p_argile_call_2);
    d = argile_def_new(syn, del_syn, (argile_type_t)ARGILE_TYPE_TYPE, p_argile_call_2, ARGILE_DEF_TYPE, (p_argile_call_2)->data);
    argile_code_def((p_argile_call_2)->scope, d, 1);
    i = argile_type_set_info(t, ARGILE_TYPE_KIND_CTYPE);
    if ((i)) {
      char * pre = (char *)0;
      char * suf = (char *)0;
      argile_text_t * txt = ((argile_text_t *)0);

      m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TEXT, (char *)0);
      if ((m == ((argile_match_t *)0))) {
        argile_syntax_t * s = ((argile_syntax_t *)0);

        s = *((argile_syntax_t * *)&((argrt_list_t *)syn)->data);
        if (((s) && ((s)->type == ARGILE_SYN_WORD))) {
          pre = ARGRT_strdup(((s)->value).syn_word);
        }
      }
      else if (((txt = argile_match_eval_text(m)))) {
        pre = ((char *)ARGRT_malloc(((txt)->len + 1)));
        memcpy(pre, (txt)->str, ((txt)->len + 1));
        m = argile_shovel_digmatch(sh, 2, (argile_type_t)ARGILE_TYPE_TEXT, (char *)0);
        if (((m) && (txt = argile_match_eval_text(m)))) {
          suf = ((char *)ARGRT_malloc(((txt)->len + 1)));
          memcpy(suf, (txt)->str, ((txt)->len + 1));
        }
      }
      (((i)->tval).t_ctype).prefix = pre;
      (((i)->tval).t_ctype).suffix = suf;
      if ((argile_def_has_option((p_argile_call_2)->def, "def"))) {
        (((i)->tval).t_ctype).use_typedef = 1;
      }
    }
  }
  argile_shovel_del(sh);
}

