// generated by: arc -xuNP -A ./../argrt -M -o std_class.c -H std_class.h -m std_class.argl.tmp std_class.arg 
#include "std_class.h"

/** :new class <argile code scope> <argile code code> <def> <argile type type>: -> class **/
static class_t * new_class(argile_code_t *, argile_code_t *, argile_def_t *, argile_type_t);
/** :del <class c>: -> nothing **/
static void del(class_t *);
/** :dig class type <shovel sh> <call> (<argile code code>): -> argile type **/
static argile_type_t dig_class_type(argile_shovel_t *, argile_call_t *, argile_code_t *, ...);
/** :compile class code <shovel sh> <call> <argile code code>: -> int **/
static int compile_class_code(argile_shovel_t *, argile_call_t *, argile_code_t *);
/** :mark <list of (match) lm> processed: -> nothing **/
static void mark_processed(argrt_list_t *);
/** :syntax error <call c>: -> int **/
static int syntax_error(argile_call_t *);

int argmod_class_defmaker = 1;
char( argmod_class_doc[]) = {"Define a class type; takes a word or syntax parameter for the name, and a\ncode block that must contain only calls to :<type> <word field> (/<nat>):\n(the natural option specifies the number of bits for the field).\nIf a field has a raw value class type, then the sub class is\nincluded in the current (field by content instead of field by pointer).\nAn optional type parameter can be used to specify a parent class, that\nmakes an implicit field named `_parent_' (so it can't be used for other\nfields).\nIf the bind option `union' is specified, it will make an union\ninstead of a class (in this case, the parent type will be ignored).\nIf the bind option `extern' is set, the type will not be defined in C.\nIf the bind option `struct' is set, no C typedef will be generated.\nSyntax requirements:\n  :<word> <code>:\n  :<syntax> <code>:\n  :{<word>|<syntax>} (<type>) <code>:\n"};

/** :argmod_class_compile <call>: -> nothing **/
void argmod_class_compile(argile_call_t * p_argile_call)
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_type_t class_type;
  argile_type_t parent;

  if ((argile_def_has_option((p_argile_call)->def, "union"))) {
    return;
  }
  sh = argile_shovel_new(p_argile_call);
  class_type = dig_class_type(sh, p_argile_call, ((argile_code_t *)0));
  if ((class_type != (argile_type_t)ARGILE_TYPE_NOTHING)) {
    argile_match_t * m = ((argile_match_t *)0);

    m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
    if ((m)) {
      parent = argile_match_eval_type(m);
      if ((parent != (argile_type_t)ARGILE_TYPE_NOTHING)) {
        argile_type_info_t * info = ((argile_type_info_t *)0);
        unsigned char is_class;

        info = argile_type_get_info(parent);
        is_class = ((info != ((argile_type_info_t *)0)) && ((info)->ttype == ARGILE_TYPE_KIND_CLASS));
        info = argile_type_get_info(class_type);
        if (((info) && ((info)->ttype == ARGILE_TYPE_KIND_CLASS))) {
          argile_field_t * f = ((argile_field_t *)0);

          f = argile_field_new((((int)(((int)parent) & ((1 << 30) - 1))) | (1 << 30)), class_type, "_parent_");
          if (!(is_class)) {
            parent = (((int)(((int)parent) & ((1 << 30) - 1))) | (1 << 31));
          }
          argrt_list_prepend(&(((info)->tval).t_class).fields, argrt_list_new(((void *)((long)f)), (void *)&argile_field_del));
          argrt_list_prepend(&(info)->casters, argrt_list_new(((void *)((long)argile_type_caster_new(parent, ((argile_code_t *)0)))), (void *)&argile_type_caster_del));
        }
      }
    }
  }
  argile_shovel_del(sh);
}

/** :argmod_class_reject <call>: -> int **/
int argmod_class_reject(argile_call_t * p_argile_call_2)
{
  int reject = 0;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);

  sh = argile_shovel_new(p_argile_call_2);
  m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
  if ((m)) {
    argile_type_t type;

    type = argile_match_eval_type(m);
    if ((((((int)type) >> 31) & 1))) {
      argile_shovel_del(sh);
      return argile_call_add_reject(p_argile_call_2, "std/class: ""parent type is by reference");
    }
    if ((((((int)type) >> 30) & 1))) {
      argile_shovel_del(sh);
      return argile_call_add_reject(p_argile_call_2, "std/class: ""parent type is by raw value");
    }
  }
  m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0);
  if ((m)) {
    argile_code_t * code = ((argile_code_t *)0);

    code = argile_match_eval_code(m);
    if ((code)) {
      reject = compile_class_code(sh, p_argile_call_2, code);
    }
    else {
      reject = argile_call_add_reject(p_argile_call_2, "std/class: ""code parameter is not constant");
    }
  }
  argile_shovel_del(sh);
  return reject;
}

/** :argmod_class_gettype <call>: -> argile type **/
argile_type_t argmod_class_gettype(argile_call_t * p_argile_call_3)
{
  return ((((p_argile_call_3)->owner)) ? (ARGILE_TYPE_TYPE) : (ARGILE_TYPE_NOTHING));
}

/** :argmod_class_evaltype <call>: -> argile type **/
argile_type_t argmod_class_evaltype(argile_call_t * p_argile_call_4)
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_type_t t;

  if (((p_argile_call_4)->owner == ((argile_call_t *)0))) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  }
  sh = argile_shovel_new(p_argile_call_4);
  t = dig_class_type(sh, p_argile_call_4, ((argile_code_t *)0));
  argile_shovel_del(sh);
  return t;
}

/** :argmod_class_gencode <call>: -> nothing **/
void argmod_class_gencode(argile_call_t * p_argile_call_5)
{
  argile_type_t t;

  if ((((p_argile_call_5)->data == NULL) || ((p_argile_call_5)->owner == ((argile_call_t *)0)))) {
    return;
  }
  t = (((class_t *)(p_argile_call_5)->data))->type;
  argile_type_gen_prefix(t);
  argile_type_gen_suffix(t);
}

/** :new class <argile code scope> <argile code code> <def> <argile type type>: -> class **/
static class_t * new_class(argile_code_t * scope, argile_code_t * code, argile_def_t * p_argile_def, argile_type_t type)
{
  class_t * c = ((class_t *)0);

  c = ((class_t *)memset(ARGRT_malloc(sizeof(class_t)), 0, sizeof(class_t)));
  (c)->scope = scope;
  (c)->code = code;
  (c)->def = p_argile_def;
  (c)->type = type;
  return c;
}

/** :del <class c>: -> nothing **/
static void del(class_t * c)
{
  argrt_list_t * ld;
  int i = 0;

  if (((c)->code)) {
    argrt_list_t * lc;

    lc = ((c)->code)->calls;
    for (; (lc); lc = ((argrt_list_t *)lc)->next) {
      (*((argile_call_t * *)&((argrt_list_t *)lc)->data))->def = ((argile_def_t *)0);
    };
  }
  ld = argrt_list_search(((c)->scope)->defs, (c)->def, ((argile_comparer_t)0));
  if ((ld)) {
    if ((((argrt_list_t *)ld)->next == ((argrt_list_t *)0))) {
      ((c)->scope)->defs_tail = ((argrt_list_t *)ld)->prev;
    }
    argrt_list_remove(&((c)->scope)->defs, ld);
    argrt_list_delete_all(ld);
  }
  for (i = 0; ((i <= (4096 - 1))); (i)++) {
    argrt_list_t * ld_2;

    while (((ld_2 = argrt_list_search(((argile).defs)[i], (c)->def, ((argile_comparer_t)0))))) {
      argrt_list_remove(&((argile).defs)[i], ld_2);
      argrt_list_delete_all(ld_2);
    };
  };
  ARGRT_free(c);
}

/** :dig class type <shovel sh> <call> (<argile code code>): -> argile type **/
static argile_type_t dig_class_type(argile_shovel_t * sh, argile_call_t * p_argile_call_6, argile_code_t * code_2, ...)
{
  argrt_list_t * syn = ((argrt_list_t *)0);
  unsigned char del_syn;
  argile_match_t * m = ((argile_match_t *)0);

  if (!(((p_argile_call_6)->data == NULL))) {
    return (((class_t *)(p_argile_call_6)->data))->type;
  }
  del_syn = 0;
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) {
    syn = argile_match_eval_syntax(m);
    del_syn = 0;
  }
  else if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))) {
    char * word = "";

    if (((word = argile_match_eval_word(m)))) {
      syn = argrt_list_new(((void *)((long)argile_syntax_new(ARGILE_SYN_WORD, ARGRT_strdup(word)))), (void *)&argile_syntax_del);
      del_syn = 1;
    }
  }
  if ((syn)) {
    argile_type_t type_2;
    argile_type_info_t * info = ((argile_type_info_t *)0);
    argile_def_t * d = ((argile_def_t *)0);

    type_2 = argile_type_new();
    info = argile_type_set_info(type_2, ARGILE_TYPE_KIND_BIND);
    (info)->ext = (argile_def_has_option((p_argile_call_6)->def, "extern"));
    d = argile_def_new(syn, ((int)del_syn), (argile_type_t)ARGILE_TYPE_TYPE, p_argile_call_6, ARGILE_DEF_TYPE, ((void *)((long)type_2)));
    (d)->ext = (info)->ext;
    argile_code_def((p_argile_call_6)->scope, d, 1);
    (p_argile_call_6)->data = new_class((p_argile_call_6)->scope, code_2, d, type_2);
    (p_argile_call_6)->del = (void *)&del;
    (p_argile_call_6)->keep_data = 1;
    return type_2;
  }
  argile_die_at(p_argile_call_6, "std/class: ""no name or syntax for new type");
  return ARGILE_TYPE_NOTHING;
}

/** :compile class code <shovel sh> <call> <argile code code>: -> int **/
static int compile_class_code(argile_shovel_t * sh_2, argile_call_t * p_argile_call_7, argile_code_t * code_3)
{
  argile_type_t class_type;
  unsigned char is_union;
  argile_type_kind_t type_kind;
  argrt_list_t * fields;
  argile_type_info_t * info = ((argile_type_info_t *)0);
  argrt_list_t * lc;

  class_type = dig_class_type(sh_2, p_argile_call_7, code_3);
  if ((class_type == (argile_type_t)ARGILE_TYPE_NOTHING)) {
    return 1;
  }
  if (((code_3)->calls == ((argrt_list_t *)0))) {
    argile_die_at(p_argile_call_7, "std/class: ""no fields");
    return 1;
  }
  is_union = (argile_def_has_option((p_argile_call_7)->def, "union"));
  type_kind = ((is_union) ? (ARGILE_TYPE_KIND_UNION) : (ARGILE_TYPE_KIND_CLASS));
  info = argile_type_get_info(class_type);
  if (((info) && ((info)->ttype == type_kind))) {
    if (is_union) {
      fields = (((info)->tval).t_union).variants;
    }
    else {
      fields = (((info)->tval).t_class).fields;
    }
  }
  else {
    int i = 0;

    i = ((int)argrt_list_count((code_3)->calls));
    fields = ((argrt_list_t *)0);
    while (((i)-- > 0)) {
      argile_field_t * f = ((argile_field_t *)0);

      f = argile_field_new((argile_type_t)ARGILE_TYPE_NOTHING, class_type, (char *)0);
      argrt_list_prepend(&fields, argrt_list_new(((void *)((long)f)), (void *)&argile_field_del));
    };
    info = argile_type_set_info(class_type, type_kind);
    if (is_union) {
      (((info)->tval).t_union).variants = fields;
    }
    else {
      (((info)->tval).t_class).fields = fields;
      (((info)->tval).t_class)._struct = (argile_def_has_option((p_argile_call_7)->def, "struct"));
    }
  }
  for (lc = (code_3)->calls; ((lc) && (fields)); lc = ((argrt_list_t *)lc)->next,fields = ((argrt_list_t *)fields)->next) {
    argile_call_t * c_2 = ((argile_call_t *)0);
    argrt_list_t * lm;
    unsigned char val;
    int bits = 0;
    argile_type_t type_2;
    char * name = (char *)0;

    c_2 = *((argile_call_t * *)&((argrt_list_t *)lc)->data);
    lm = (c_2)->match;
    val = 0;
    if (((c_2)->def)) {
      continue;
    }
    type_2 = (argile_type_t)ARGILE_TYPE_NOTHING;
    mark_processed(lm);
    if (((lm) && (((argrt_list_t *)lm)->next))) {
      argrt_list_t * end;
      argile_match_t * m = ((argile_match_t *)0);

      end = argrt_list_end(lm);
      m = *((argile_match_t * *)&((argrt_list_t *)end)->data);
      if (((m) && ((m)->type == ARGILE_MATCH_CONS))) {
        int err = 0;

        bits = ((int)argile_match_eval_long(m, &err));
        if ((err != 0)) {
          return syntax_error(c_2);
        }
        if ((bits < 1)) {
          argile_die_at(c_2, "std/class: ""number of field bits must be > 0");
          return 1;
        }
        if ((bits >= (1 << 16))) {
          bits = 0xffff;
        }
        end = ((argrt_list_t *)end)->prev;
        if ((end == ((argrt_list_t *)0))) {
          return syntax_error(c_2);
        }
        m = *((argile_match_t * *)&((argrt_list_t *)end)->data);
        if (((m == ((argile_match_t *)0)) || (((m)->type != ARGILE_MATCH_OP) || (strcmp(((m)->value).op, "/") != 0)))) {
          return syntax_error(c_2);
        }
        end = ((argrt_list_t *)end)->prev;
        if ((end == ((argrt_list_t *)0))) {
          return syntax_error(c_2);
        }
        m = *((argile_match_t * *)&((argrt_list_t *)end)->data);
      }
      if (((m) && ((m)->type == ARGILE_MATCH_WORD))) {
        unsigned char compiled;

        argrt_list_unlink(((argrt_list_t *)end)->prev, end);
        compiled = 0;
        if ((argile_type_compile(&type_2, lm, code_3, p_argile_call_7, &(c_2)->def, ((argile_call_t * *)0), &lm))) {
          (c_2)->match = lm;
          (c_2)->compiled = 1;
          compiled = 1;
          ((argile).curcall)++;
          name = ((m)->value).word;
          if ((((((int)type_2) >> 30) & 1))) {
            val = 1;
            type_2 = (((int)type_2) & ((1 << 30) - 1));
          }
        }
        argrt_list_link(argrt_list_end((c_2)->match), end);
        if (!(compiled)) {
          return argile_call_add_reject(p_argile_call_7, "std/class: ""could not compile type yet");
        }
      }
      else {
        return syntax_error(c_2);
      }
    }
    if ((name)) {
      argile_field_t * f = ((argile_field_t *)0);

      f = *((argile_field_t * *)&((argrt_list_t *)fields)->data);
      if (!(((f)->name == (char *)0))) {
        ARGRT_free((f)->name);
      }
      (f)->name = ARGRT_strdup(name);
      (f)->type = type_2;
      (f)->bits = ((unsigned int)bits);
      if (((val && (info = argile_type_get_info(type_2))) && ((info)->ttype == ARGILE_TYPE_KIND_CLASS))) {
        (f)->type = (((int)(((int)(f)->type) & ((1 << 30) - 1))) | (1 << 30));
      }
    }
    else {
      return syntax_error(c_2);
    }
  };
  (code_3)->compiled = 1;
  return 0;
}

/** :mark <list of (match) lm> processed: -> nothing **/
static void mark_processed(argrt_list_t * lm_2)
{
  for (; (lm_2); lm_2 = ((argrt_list_t *)lm_2)->next) {
    if ((*((argile_match_t * *)&((argrt_list_t *)lm_2)->data))) {
      (*((argile_match_t * *)&((argrt_list_t *)lm_2)->data))->processed = 1;
    }
  };
}

/** :syntax error <call c>: -> int **/
static int syntax_error(argile_call_t * c_3)
{
  argile_die_at(c_3, "std/class: ""syntax in body is :<type> <word> (/<nat>):");
  return 1;
}

