// generated by: arc -xuNP -A ./../argrt -M -o file.c -H file.h -m file.argl.tmp file.arg 

#ifdef WIN32
#include <unistd.h> //;
#include <windows.h> //;

#endif

#include "file.h"

/** :argile_file_new <text path> <stat pst>: -> (argile) file **/
argile_file_t * argile_file_new(char * path, struct stat * pst)
{
  argile_file_t * file = ((argile_file_t *)0);

  file = ((argile_file_t *)memset(ARGRT_malloc(sizeof(argile_file_t)), 0, sizeof(argile_file_t)));
  (file)->path = ARGRT_strdup(path);
  
#ifndef WIN32
  (file)->error = 0;
  if ((pst)) {
    (file)->device = (pst)->st_dev;
    (file)->inode = (pst)->st_ino;
  }
  else {
    struct stat st = ((struct stat){0});

    if ((stat(path, &st) != 0)) {
      (file)->error = errno;
    }
    else {
      (file)->device = (st).st_dev;
      (file)->inode = (st).st_ino;
    }
  }
  
#else
  (file)->error = 1;
  if (!((access((file)->path, F_OK)))) {
    HANDLE wf;

    wf = CreateFile((file)->path,0,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS|FILE_ATTRIBUTE_READONLY,NULL);
    if ((wf != INVALID_HANDLE_VALUE)) {
      BY_HANDLE_FILE_INFORMATION wi;

      ZeroMemory(&wi, sizeof(wi));
      if ((GetFileInformationByHandle(wf, &wi))) {
        (file)->device = wi.nFileIndexHigh;
        (file)->inode = wi.nFileIndexLow;
        (file)->error = 0;
      }
    }
  }
  
#endif
  (file)->code = ((argile_code_t *)0);
  return file;
}

/** :argile_file_del <file>: -> nothing **/
void argile_file_del(argile_file_t * p_argile_file)
{
  ARGRT_free((p_argile_file)->path);
  if (((p_argile_file)->code)) {
    argile_code_del((p_argile_file)->code);
  }
  ARGRT_free(p_argile_file);
}

/** :argile_file_eq <file fa> <file fb>: -> int **/
int argile_file_eq(argile_file_t * fa, argile_file_t * fb)
{
  if (((fa == ((argile_file_t *)0)) != (fb == ((argile_file_t *)0)))) {
    return 0;
  }
  return ((int)(((((fa)->error == 0) && ((fb)->error == 0)) && ((fa)->device == (fb)->device)) && ((fa)->inode == (fb)->inode)));
}

/** :argile_filename_eq <file f> <text path>: -> int **/
int argile_filename_eq(argile_file_t * f, char * path_2)
{
  if (((f == ((argile_file_t *)0)) || ((f)->error != 0))) {
    return 1;
  }
  return ((int)(strcmp((f)->path, path_2) == 0));
}

/** :argile_file_load <file>: -> nothing **/
void argile_file_load(argile_file_t * p_argile_file_2)
{
  argile_code_t * oldmain = ((argile_code_t *)0);
  argile_inout_t oldinput;
  char * oldname = "";
  unsigned char oldcmt;
  argrt_list_t * oldinc;
  argrt_list_t * oldsys;
  unsigned char oldmonly;
  argile_stats_t oldstat = ((argile_stats_t){0});
  argrt_list_t * oldglob;
  argrt_list_t * ldef;

  oldmain = (argile).main;
  oldinput = (argile).input;
  oldname = (argile).input_name;
  oldcmt = (argile).get_comments;
  oldinc = (argile).includes;
  oldsys = (argile).sysincludes;
  oldmonly = (argile).main_only;
  oldstat = (argile).stat;
  oldglob = (argile).globally;
  (p_argile_file_2)->depth = ++((argile).depth);
  if (((argile).lazy && !((argile).cat_main))) {
    (argile).main_only = 1;
  }
  (argile).includes = ((argrt_list_t *)0);
  (argile).sysincludes = ((argrt_list_t *)0);
  (argile).input = (void *)&argile_input_path;
  (argile).input_name = (p_argile_file_2)->path;
  (argile).globally = ((argrt_list_t *)0);
  (argile).get_comments = 0;
  memset(&(argile).stat, 0, sizeof(argile_stats_t));
  (p_argile_file_2)->code = argile_code_new(((argile_code_t *)0), ((argrt_list_t *)0));
  (argile).main = (p_argile_file_2)->code;
  for (ldef = (oldmain)->defs; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ldef)->data));
    if ((d)->implicit) {
      argile_code_def((argile).main, d, 0);
      ((argile).main)->has_weak_defs = 1;
    }
  };
  if (((argile_parse((p_argile_file_2)->path) != 0) || (argile_compile() != 0))) {
    (p_argile_file_2)->code = ((argile_code_t *)0);
    if (((argile).killer)) {
      argrt_list_prepend(&(argile).leaks, argrt_list_new(((void *)((long)((void *)(argile).main))), (void *)&argile_code_del));
    }
    else {
      argile_code_del((argile).main);
    }
  }
  argrt_list_delete_all((argile).includes);
  argrt_list_delete_all((argile).sysincludes);
  argrt_list_delete_all((argile).globally);
  for (ldef = (oldmain)->defs; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ldef)->data));
    if ((d)->implicit) {
      (d)->scope = oldmain;
    }
  };
  if (((argile).main_only && ((p_argile_file_2)->code != ((argile_code_t *)0)))) {
    for (ldef = ((p_argile_file_2)->code)->defs; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ldef)->data));
      if (((d)->dtype == ARGILE_DEF_FUNC)) {
        argile_code_t * c = ((argile_code_t *)0);

        c = ((d)->dval).code;
        if (((c) && !((c)->macro))) {
          argrt_list_delete_all((c)->calls);
          (c)->calls = ((argrt_list_t *)0);
        }
      }
    };
  }
  (argile).input = oldinput;
  (argile).input_name = oldname;
  (argile).main = oldmain;
  (argile).get_comments = oldcmt;
  (argile).includes = oldinc;
  (argile).sysincludes = oldsys;
  (argile).main_only = oldmonly;
  *&(argile).stat = *&oldstat;
  (argile).globally = oldglob;
  ((argile).depth)--;
}

