// generated by: arc -xuNP -A ./../argrt -M -o cons.c -H cons.h -m cons.argl.tmp cons.arg 
#include "cons.h"

/** :simplify <cons c> <(cons type) & t> <(long) & i>: -> nothing **/
static void simplify(argile_cons_t * * ca, argile_cons_t *, argile_cons_type_t *, long *);
/** :_hexachar <int n>: -> byte **/
static char _hexachar(int);
/** :_cons_type_match <cons> <argile type type> <argile type cmp>: -> bool **/
static unsigned char _cons_type_match(argile_cons_t *, argile_type_t, argile_type_t);

/** :argile_cons_new <cons type type> <any data>: -> (argile) cons **/
argile_cons_t * argile_cons_new(argile_cons_type_t type, void * data)
{
  argile_cons_t * cons = ((argile_cons_t *)0);

  cons = ((argile_cons_t *)memset(ARGRT_malloc(sizeof(argile_cons_t)), 0, sizeof(argile_cons_t)));
  (cons)->ctype = type;
  ((cons)->cvalue).data = data;
  switch (type) {
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_HEX: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_INTEGER;
    } break;
    case ARGILE_CONS_REAL: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_REAL;
    } break;
    case ARGILE_CONS_TEXT: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_TEXT;
    } break;
    case ARGILE_CONS_CODE: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_CODE;
    } break;
    case ARGILE_CONS_SYNTAX: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_SYNTAX;
    } break;
    default: {} break;
  };
  (cons)->rtype = (cons)->type;
  return cons;
}

/** :argile_cons_del <cons>: -> nothing **/
void argile_cons_del(argile_cons_t * p_argile_cons)
{
  switch ((p_argile_cons)->ctype) {
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_REAL: {
      ARGRT_free(((p_argile_cons)->cvalue).data);
    } break;
    case ARGILE_CONS_TEXT: {
      argile_text_del(((p_argile_cons)->cvalue).text);
    } break;
    case ARGILE_CONS_CODE: {
      argile_code_del(((p_argile_cons)->cvalue).code);
    } break;
    case ARGILE_CONS_SYNTAX: {
      argrt_list_delete_all(((p_argile_cons)->cvalue).syntax);
    } break;
    default: {} break;
  };
  ARGRT_free(p_argile_cons);
}

/** :argile_cons_eq <cons ca> <cons cb>: -> int **/
int argile_cons_eq(argile_cons_t * ca, argile_cons_t * cb)
{
  argile_cons_type_t ta;
  argile_cons_type_t tb;
  long ia;
  long ib;

  if ((ca == cb)) {
    return 1;
  }
  if (((ca == ((argile_cons_t *)0)) || (cb == ((argile_cons_t *)0)))) {
    return 0;
  }
  simplify(&ca, ca, &ta, &ia);
  simplify(&ca, cb, &tb, &ib);
  if ((ta != tb)) {
    return 0;
  }
  switch (ta) {
    case ARGILE_CONS_DEC: {
      return (((ia == ib)) ? (1) : (0));
    } break;
    case ARGILE_CONS_REAL: {
      double ra = 0.0;
      double rb = 0.0;

      ra = strtod(((ca)->cvalue).real, NULL);
      rb = strtod(((cb)->cvalue).real, NULL);
      return (((ra == rb)) ? (1) : (0));
    } break;
    case ARGILE_CONS_TEXT: {
      return (((strcmp((((ca)->cvalue).text)->str, (((cb)->cvalue).text)->str) == 0)) ? (1) : (0));
    } break;
    case ARGILE_CONS_CODE: {
      argile_code_t * xa = ((argile_code_t *)0);
      argile_code_t * xb = ((argile_code_t *)0);

      xa = ((ca)->cvalue).code;
      xb = ((cb)->cvalue).code;
      if ((((xa)->calls == ((argrt_list_t *)0)) && ((xb)->calls == ((argrt_list_t *)0)))) {
        return 1;
      }
      return 0;
    } break;
    case ARGILE_CONS_SYNTAX: {
      return 1;
    } break;
    default: {} break;
  };
  return 0;
}

/** :argile_cons_string <cons> <int indent> <buff buf>: -> nothing **/
void argile_cons_string(argile_cons_t * p_argile_cons_2, int indent, argile_buff_t * buf)
{
  switch ((p_argile_cons_2)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_REAL: {
      argile_buff_puts(buf, ((char *)((p_argile_cons_2)->cvalue).data));
    } break;
    case ARGILE_CONS_TEXT: {
      argile_cons_text_string(((p_argile_cons_2)->cvalue).text, buf);
    } break;
    case ARGILE_CONS_CODE: {
      unsigned char b;
      int i = 0;

      if ((argile).skip_codes) {
        argile_buff_puts(buf, "{...}");
        break;
      }
      if (((((p_argile_cons_2)->cvalue).code)->calls == ((argrt_list_t *)0))) {
        argile_buff_puts(buf, "{}");
        break;
      }
      b = (!((argile).dump_indent) || (((((p_argile_cons_2)->cvalue).code)->owner)->owner));
      if (b) {
        argile_buff_putc(buf, ("{")[0]);
      }
      argile_buff_putc(buf, '\n');
      argile_code_string(((p_argile_cons_2)->cvalue).code, (indent + 1), buf);
      for (i = 1; ((i <= indent)); (i)++) {
        argile_buff_puts(buf, "  ");
      };
      if (b) {
        argile_buff_putc(buf, ("}")[0]);
      }
    } break;
    case ARGILE_CONS_SYNTAX: {
      argile_buff_putc(buf, (":")[0]);
      argile_syntax_string(((p_argile_cons_2)->cvalue).syntax, buf);
      argile_buff_putc(buf, (":")[0]);
    } break;
    default: {
      argile_buff_puts(buf, "(: bad constant type ");
      argile_buff_putn(buf, ((int)(p_argile_cons_2)->ctype));
      argile_buff_puts(buf, " :)");
    } break;
  };
}

/** :argile_cons_text_string <argile text t> <buff b>: -> nothing **/
void argile_cons_text_string(argile_text_t * t, argile_buff_t * b)
{
  unsigned char after_hex;

  after_hex = 0;
  argile_buff_putc(b, ("\"")[0]);
  if ((t)) {
    int i = 0;

    for (i = 0; (i < (t)->len); (i)++) {
      unsigned char is_hex;
      char c;

      is_hex = 0;
      switch ((c = ((t)->str)[i])) {
        case '"': {
          argile_buff_puts(b, "\\\"");
        } break;
        case '\\': {
          argile_buff_puts(b, "\\\\");
        } break;
        case '\a': {
          argile_buff_puts(b, "\\a");
        } break;
        case '\b': {
          argile_buff_puts(b, "\\b");
        } break;
        case '\t': {
          argile_buff_puts(b, "\\t");
        } break;
        case '\n': {
          argile_buff_puts(b, "\\n");
        } break;
        case '\v': {
          argile_buff_puts(b, "\\v");
        } break;
        case '\f': {
          argile_buff_puts(b, "\\f");
        } break;
        case '\r': {
          argile_buff_puts(b, "\\r");
        } break;
        default: {
          if (((argile).hexa_str && (((c < ' ') || (c > '~')) || (after_hex && ((((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f'))) || ((c >= 'A') && (c <= 'F'))))))) {
            argile_buff_puts(b, "\\x");
            argile_buff_putc(b, _hexachar(((int)(c >> 4))));
            argile_buff_putc(b, _hexachar(((int)c)));
            is_hex = 1;
          }
          else {
            argile_buff_putc(b, c);
          }
        } break;
      };
      after_hex = is_hex;
    };
  }
  argile_buff_putc(b, ("\"")[0]);
}

/** :argile_cons_setup <cons> <call owner>: -> nothing **/
void argile_cons_setup(argile_cons_t * p_argile_cons_3, argile_call_t * owner)
{
  if (((p_argile_cons_3)->ctype == ARGILE_CONS_CODE)) {
    (((p_argile_cons_3)->cvalue).code)->owner = owner;
    (((p_argile_cons_3)->cvalue).code)->upper = (owner)->scope;
  }
}

/** :argile_cons_match_type <cons> <argile type type>: -> int **/
int argile_cons_match_type(argile_cons_t * p_argile_cons_4, argile_type_t type_2)
{
  if ((((((int)type_2) >> 31) & 1))) {
    return 0;
  }
  switch ((p_argile_cons_4)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_BIN: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_INTEGER)) {
        return 1;
      }
      if (((((p_argile_cons_4)->cvalue).dec)[0] != '-')) {
        if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_NATURAL)) {
          return 1;
        }
      }
      return 0;
    } break;
    case ARGILE_CONS_REAL: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_REAL)) {
        return 1;
      }
      return 0;
    } break;
    case ARGILE_CONS_TEXT: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_TEXT)) {
        return 1;
      }
      return 0;
    } break;
    case ARGILE_CONS_CODE: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_CODE)) {
        return 1;
      }
      return 0;
    } break;
    case ARGILE_CONS_SYNTAX: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_SYNTAX)) {
        return 1;
      }
      return 0;
    } break;
    default: {} break;
  };
  return 0;
}

/** :argile_cons_gencode <cons>: -> nothing **/
void argile_cons_gencode(argile_cons_t * p_argile_cons_5)
{
  switch ((p_argile_cons_5)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_REAL: {
      argile_puts(((char *)((p_argile_cons_5)->cvalue).data));
    } break;
    case ARGILE_CONS_BIN: {
      char * digits = "";

      digits = ((p_argile_cons_5)->cvalue).bin;
      while (((((digits)[0] != '\0') && ((digits)[0] != 'b')) && ((digits)[0] != 'B'))) {
        (digits)++;
      };
      if (((digits)[0])) {
        (digits)++;
      }
      if (((((p_argile_cons_5)->cvalue).bin)[0] == '-')) {
        argile_puts("-");
      }
      
#if HAVE_STRTOLL
      argile_printf("0x%llx", strtoll(digits, NULL, 2));
      
#else
      argile_printf("0x%lx", strtol(digits, NULL, 2));
      
#endif
    } break;
    case ARGILE_CONS_TEXT: {
      argile_buff_t b_2 = ((argile_buff_t){0});

      argile_cons_text_string(((p_argile_cons_5)->cvalue).text, &b_2);
      argile_output((b_2).ptr, ((int)(b_2).len));
      ARGRT_free((b_2).ptr);
    } break;
    case ARGILE_CONS_CODE: {
      argile_code_t * code = ((argile_code_t *)0);

      code = ((p_argile_cons_5)->cvalue).code;
      if (((code)->anon)) {
        argile_printf("(void *)&%s", (code)->anon);
      }
      else if (((code)->calls)) {
        if ((argile).inside_cmacro) {
          argile_puts("{ \\\n");
        }
        else {
          argile_puts("{\n");
        }
        ((argile).indent)++;
        argile_code_gen_vars(code, 0);
        argile_code_gencode(code);
        ((argile).indent)--;
        argile_indent();
        argile_puts("}");
      }
      else {
        argile_puts("{}");
      }
    } break;
    case ARGILE_CONS_SYNTAX: {
      argile_buff_t b_2 = ((argile_buff_t){0});
      argile_buff_t b2 = ((argile_buff_t){0});
      unsigned char old;

      old = (argile).use_colors;
      if (old) {
        (argile).use_colors = 0;
      }
      argile_syntax_string(((p_argile_cons_5)->cvalue).syntax, &b2);
      argile_buff_escape(&b2, "\"\\", '\\');
      argile_buff_puts(&b_2, "\":");
      argile_buff_cat(&b_2, &b2);
      argile_buff_puts(&b_2, ":\"");
      if (old) {
        (argile).use_colors = 1;
      }
      argile_output((b_2).ptr, ((int)(b_2).len));
      ARGRT_free((b_2).ptr);
      ARGRT_free((b2).ptr);
    } break;
    default: {} break;
  };
}

/** :argile_cons_find_autoparams <cons>: -> bool **/
unsigned char argile_cons_find_autoparams(argile_cons_t * p_argile_cons_6)
{
  unsigned char found;

  found = 0;
  switch ((p_argile_cons_6)->ctype) {
    case ARGILE_CONS_CODE: {
      if (argile_code_find_autoparams(((p_argile_cons_6)->cvalue).code)) {
        found = 1;
      }
    } break;
    case ARGILE_CONS_SYNTAX: {
      if (argile_syntax_find_autoparams(((p_argile_cons_6)->cvalue).syntax)) {
        found = 1;
      }
    } break;
    default: {} break;
  };
  return found;
}

/** :simplify <cons c> <(cons type) & t> <(long) & i>: -> nothing **/
static void simplify(argile_cons_t * * ca, argile_cons_t * c, argile_cons_type_t * t_2, long * i)
{
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).hex, NULL, 16);
    } break;
    case ARGILE_CONS_DEC: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).dec, NULL, 10);
    } break;
    case ARGILE_CONS_OCT: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).oct, NULL, 8);
    } break;
    case ARGILE_CONS_BIN: {
      char * str = "";

      *t_2 = ARGILE_CONS_DEC;
      str = ((*ca)->cvalue).bin;
      if (((str)[0] == '-')) {
        *i = (-strtol(((str) + 3), NULL, 2));
      }
      else {
        *i = strtol(((str) + 2), NULL, 2);
      }
    } break;
    default: {
      *t_2 = (c)->ctype;
      *i = ((long)0);
    } break;
  };
}

/** :_hexachar <int n>: -> byte **/
static char _hexachar(int n)
{
  n &= 0xf;
  if ((n < 10)) {
    return (char)(n + '0');
  }
  return ((n - 10) + 'a');
}

/** :_cons_type_match <cons> <argile type type> <argile type cmp>: -> bool **/
static unsigned char _cons_type_match(argile_cons_t * p_argile_cons_7, argile_type_t type_3, argile_type_t cmp)
{
  unsigned char t_3;

  t_3 = (type_3 == (argile_type_t)ARGILE_TYPE_ANYTHING);
  if (!(t_3)) {
    t_3 = (argile_type_match(type_3, cmp));
  }
  if (!(t_3)) {
    return 0;
  }
  (p_argile_cons_7)->type = cmp;
  (p_argile_cons_7)->rtype = type_3;
  return t_3;
}

