// generated by: arc -xuNP -A ./../argrt -M -o code.c -H code.h -m code.argl.tmp code.arg 
#include "code.h"

/** :gen param id of <def> from <call>: -> text **/
static char * gen_param_id_of_from(argile_def_t *, argile_call_t *);
/** :gen protofuncs <argile code code> <bool statics> <bool bodies>: -> int **/
static int gen_protofuncs(argile_code_t *, unsigned char, unsigned char);
/** :gen protofuncs <argile call call> <bool statics> <bool bodies>: -> int **/
static int gen_protofuncs_2(argile_call_t *, unsigned char, unsigned char);
/** :<var> has data block: -> bool **/
static unsigned char has_data_block(argile_var_t *);
/** :_cumulated_numcomp <call>: -> int **/
static int _cumulated_numcomp(argile_call_t *);
/** :_f_all <def>: -> int **/
static int _f_all(argile_def_t *);
/** :_f_defmakers <def>: -> int **/
static int _f_defmakers(argile_def_t *);
/** :_percent <int n> <int max>: -> nothing **/
static void _percent(int * last, int, int);
/** :gen defines <call> <bool privates>: -> nothing **/
static void gen_defines(argile_call_t *, unsigned char);
/** :<argile code c> has several calls: -> bool **/
static unsigned char has_several_calls(argile_code_t *);
/** :gen Cmacro autoparams: -> nothing **/
static void gen_Cmacro_autoparams(int * nparams, argile_code_t * * body);
/** :gen Cmacro params <list of (argile syntax) lsyn>: -> nothing **/
static void gen_Cmacro_params(int * nparams, argrt_list_t *);
/** :pregen includes rec <argile code up>: -> nothing **/
static void pregen_includes_rec(argile_code_t *);
/** :pregen <argile code code> <bool in_macro>: -> nothing **/
static void pregen(argile_code_t *, unsigned char);
/** :pregen <call> <bool in_macro>: -> nothing **/
static void pregen_2(argile_call_t *, unsigned char);
/** :gen typedefs <argile code code> <bool privates> <bool global>: -> int **/
static int gen_typedefs(argile_code_t *, unsigned char, unsigned char);
/** :gen typedefs <argile call call>: -> int **/
static int gen_typedefs_2(argile_call_t *);
/** :gen enums <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_enums(argile_code_t *, unsigned char, unsigned char);
/** :gen enums <call>: -> nothing **/
static void gen_enums_2(argile_call_t *);
/** :gen structs and unions <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_structs_and_unions(argile_code_t *, unsigned char, unsigned char);
/** :gen structs and unions <call>: -> nothing **/
static void gen_structs_and_unions_2(argile_call_t *);
/** :gen structs and unions <argile code code> <def d> <type info ti>: -> nothing **/
static void gen_structs_and_unions_3(argile_code_t *, argile_def_t *, argile_type_info_t *);
/** :<list of (argile syntax) syn> has pseudo param: -> bool **/
static unsigned char has_pseudo_param(argrt_list_t *);
/** :<list of (argile syntax) syn> has optenulis: -> bool **/
static unsigned char has_optenulis(argrt_list_t *);
/** :gen syntax comment <def d> <call c>: -> nothing **/
static void gen_syntax_comment(argile_def_t *, argile_call_t *);
/** :private vars <call>: -> nothing **/
static void private_vars(argile_call_t *);

static argile_filter_t( _filters[]) = {(void *)&_f_defmakers, (void *)&_f_all, NULL};
static char *( _filters_desc[]) = {"definitions making new definitions only", "all definitions", NULL};

/** :argile_code_new <argile code upper> <list of (call) calls>: -> argile code **/
argile_code_t * argile_code_new(argile_code_t * upper, argrt_list_t * calls)
{
  argile_code_t * code = ((argile_code_t *)0);

  code = ((argile_code_t *)memset(ARGRT_malloc(sizeof(argile_code_t)), 0, sizeof(argile_code_t)));
  (code)->calls = calls;
  (code)->upper = upper;
  (code)->type = (argile_type_t)ARGILE_TYPE_NOTHING;
  if (((argile).input_name)) {
    (code)->input = ARGRT_strdup((argile).input_name);
  }
  for (; (calls); calls = ((argrt_list_t *)calls)->next) {
    argile_call_setup(*((argile_call_t * *)&((argrt_list_t *)calls)->data), code, ((argile_call_t *)0));
  };
  (code)->maxmatch = ((short)-1);
  return code;
}

/** :argile_code_del <argile code code>: -> nothing **/
void argile_code_del(argile_code_t * code)
{
  argile_code_t * up = ((argile_code_t *)0);

  if (((code)->input)) {
    ARGRT_free((code)->input);
  }
  if (((code)->anon)) {
    ARGRT_free((code)->anon);
  }
  argrt_list_delete_all((code)->special_ids);
  argrt_list_delete_all((code)->autoparams);
  argrt_list_delete_all((code)->gtypes);
  argrt_list_delete_all((code)->macro_shovels);
  argrt_list_delete_all((code)->macro_calls);
  argrt_list_delete_all((code)->calls);
  argrt_list_delete_all((code)->defs);
  up = (code)->upper;
  while (!(((up == ((argile_code_t *)0)) || ((up)->ghost == ((argile_code_t *)0))))) {
    argile_code_t * upper_2 = ((argile_code_t *)0);

    upper_2 = (up)->upper;
    if (((up)->input)) {
      ARGRT_free((up)->input);
    }
    ARGRT_free(up);
    up = upper_2;
  };
  ARGRT_free(code);
}

/** :argile_code_append <(argile code) & code> <call owner> <list of (call) calls>: -> nothing **/
void argile_code_append(argile_code_t * * code_2, argile_call_t * owner, argrt_list_t * calls_2)
{
  if ((*code_2)) {
    if (((*code_2)->calls)) {
      argrt_list_link(argrt_list_end((*code_2)->calls), calls_2);
    } else {
      (*code_2)->calls = calls_2;
    }
    for (; (calls_2); calls_2 = ((argrt_list_t *)calls_2)->next) {
      argile_call_setup(*((argile_call_t * *)&((argrt_list_t *)calls_2)->data), *code_2, ((argile_call_t *)0));
    };
    if ((((*code_2)->input == (char *)0) && ((argile).input_name != (char *)0))) {
      (*code_2)->input = ARGRT_strdup((argile).input_name);
    }
  } else {
    *code_2 = argile_code_new((((owner)) ? ((owner)->scope) : (((argile_code_t *)0))), calls_2);
    (*code_2)->owner = owner;
  }
}

/** :argile_code_string <argile code code> <int indent> <buff buf>: -> nothing **/
void argile_code_string(argile_code_t * code_3, int indent, argile_buff_t * buf)
{
  argrt_list_t * lcall;

  lcall = (code_3)->calls;
  for (; (lcall); lcall = ((argrt_list_t *)lcall)->next) {
    argile_call_t * call = ((argile_call_t *)0);
    int i = 0;

    call = *((argile_call_t * *)&((argrt_list_t *)lcall)->data);
    for (i = 0; (i < indent); (i)++) {
      argile_buff_puts(buf, "  ");
    };
    if (((call)->comment)) {
      argile_buff_puts(buf, "(:");
      argile_buff_puts(buf, (call)->comment);
      argile_buff_puts(buf, ":)\n");
      for (i = 0; (i < indent); (i)++) {
        argile_buff_puts(buf, "  ");
      };
    }
    argile_call_string(call, indent, buf);
    if ((argile).stats) {
      argile_buff_puts(buf, " (: rec=");
      argile_buff_putn(buf, _cumulated_numcomp(call));
      argile_buff_puts(buf, " line=");
      argile_buff_putn(buf, (((call)->loc).start).row);
      argile_buff_puts(buf, " :)");
    }
    argile_buff_puts(buf, (((argile).dump_indent) ? ("\n") : (";\n")));
  };
}

/** :argile_code_compile <argile code code> <argile type type>: -> int **/
int argile_code_compile(argile_code_t * code_4, argile_type_t type)
{
  int old_numcomp = 0;
  argile_filter_t old_filter;
  int total = 0;
  int not_compiled = 0;
  argrt_list_t * lcall;
  int last = 0;
  argile_call_t * first = ((argile_call_t *)0);
  int fid = 0;

  if ((code_4)->compiled) {
    return 0;
  }
  old_numcomp = (argile).numcomp;
  old_filter = (argile).nextdef_filter;
  (code_4)->type = type;
  argile_code_check_dupes(code_4);
  lcall = (code_4)->calls;
  for (; (lcall); lcall = ((argrt_list_t *)lcall)->next) {
    if ((*((argile_call_t * *)&((argrt_list_t *)lcall)->data))->compiled) {
      (total)++;
    } else {
      (not_compiled)++;
    }
  };
  for (fid = 0; (not_compiled != 0); (fid)++) {
    int compiled = 0;

    (argile).nextdef_filter = (_filters)[fid];
    if (((argile).nextdef_filter == ((argile_filter_t)0))) {
      break;
    }
    if ((argile).debugcomp) {
      printf("%s %s\n", "FILTERING:", (_filters_desc)[fid]);
    }
    do {
      compiled = 0;
      for (lcall = (code_4)->calls; (lcall); lcall = ((argrt_list_t *)lcall)->next) {
        argile_call_t * call = ((argile_call_t *)0);

        call = *((argile_call_t * *)&((argrt_list_t *)lcall)->data);
        if ((call)->compiled) {
          continue;
        }
        if (((first == ((argile_call_t *)0)) || (first)->compiled)) {
          first = call;
        }
        (argile).numcomp = 0;
        if ((argile_call_compile_syntaxes(call) != 0)) {
          if ((argile_call_compile_as(call, (((((argrt_list_t *)lcall)->next == ((argrt_list_t *)0))) ? (type) : ((argile_type_t)ARGILE_TYPE_ANYTHING))))) {
            argile_forget_rejects(call);
            argrt_list_delete_all((call)->pot_defs);
            (call)->pot_defs = ((argrt_list_t *)0);
            argile_call_find_all_path(call);
            argile_call_compile_binds(call);
            (compiled)++;
            (not_compiled)--;
            _percent(&last, ++((argile).curcall), (argile).numcalls);
          }
          else if ((((argile).maxcomp > 0) && ((argile).numcomp >= (argile).maxcomp))) {
            if (((_filters)[(fid + 1)] == ((argile_filter_t)0))) {
              argile_die_at(call, "max compilation recursion (%d) reached.\nPlease, add some parenthesis.", (argile).maxcomp);
            }
          }
        }
        else {
          argile_call_add_reject(call, "some syntax parameter could not compile");
        }
        if (((argile).error)) {
          if ((argile).deps_only) {
            argile_resurrect();
            continue;
          }
          (argile).numcomp = old_numcomp;
          (argile).nextdef_filter = old_filter;
          argile_code_reset_dupes(code_4);
          return -1;
        }
      };
      total += compiled;
    } while (((compiled != 0) && (not_compiled != 0)));
  };
  (argile).numcomp = old_numcomp;
  (argile).nextdef_filter = old_filter;
  argile_code_reset_dupes(code_4);
  if (((not_compiled != 0) && !((argile).deps_only))) {
    if ((first)) {
      argile_die_at(first, "first unmatched call");
    } else {
      argile_die("could not compile some call");
    }
    return -1;
  }
  if (!((argile).main_only)) {
    for (lcall = (code_4)->calls; (lcall); lcall = ((argrt_list_t *)lcall)->next) {
      if ((argile_call_compile_subcodes(*((argile_call_t * *)&((argrt_list_t *)lcall)->data)) != 0)) {
        if (!((argile).deps_only)) {
          return -1;
        }
      }
    };
  }
  (code_4)->compiled = 1;
  return 0;
}

/** :argile_code_include <argile code code> <argile code included> <int deep>: -> nothing **/
void argile_code_include(argile_code_t * code_5, argile_code_t * included, int deep)
{
  argile_code_t * old = ((argile_code_t *)0);

  old = code_5;
  while (((included) && (included != code_5))) {
    argile_code_t * mid = ((argile_code_t *)0);

    if ((((included)->ghost) && ((included)->ghost == code_5))) {
      break;
    }
    mid = argile_code_new((code_5)->upper, ((argrt_list_t *)0));
    (mid)->owner = (code_5)->owner;
    (code_5)->upper = mid;
    if (((included)->ghost)) {
      (mid)->ghost = (included)->ghost;
    } else {
      (mid)->ghost = included;
    }
    (mid)->inc = (deep != 0);
    (mid)->calls = (included)->calls;
    (mid)->type = (included)->type;
    (mid)->defs = (included)->defs;
    (mid)->defs_tail = (included)->defs_tail;
    (mid)->has_weak_defs = (included)->has_weak_defs;
    code_5 = mid;
    do {
      included = (included)->upper;
    } while (((included) && !((included)->inc)));
  };
  argile_code_check_dupes(old);
}

/** :argile_code_nextdef <(argile code) & pcode> <(list of (def)) & pprev> <(list of (def)) & pnext>: -> list of ((argile) def) **/
argrt_list_t * argile_code_nextdef(argile_code_t * * pcode, argrt_list_t * * pprev, argrt_list_t * * pnext)
{
  argile_call_t * owner_2 = ((argile_call_t *)0);
  argrt_list_t * cur;

  while ((*pcode)) {
    while ((*pprev)) {
      cur = *pprev;
      *pprev = ((argrt_list_t *)*pprev)->prev;
      if ((((argile).nextdef_filter == ((argile_filter_t)0)) || ((*(argile).nextdef_filter)(*((argile_def_t * *)&((argrt_list_t *)cur)->data))))) {
        return cur;
      }
    };
    while ((*pnext)) {
      cur = *pnext;
      *pnext = ((argrt_list_t *)*pnext)->next;
      if ((((argile).nextdef_filter == ((argile_filter_t)0)) || ((*(argile).nextdef_filter)(*((argile_def_t * *)&((argrt_list_t *)cur)->data))))) {
        return cur;
      }
    };
    owner_2 = (*pcode)->owner;
    do {
      *pcode = (*pcode)->upper;
    } while (((*pcode) && (*pcode)->dupe));
    if ((*pcode)) {
      argile_code_getdef(*pcode, owner_2, pprev, pnext);
    }
  };
  return ((argrt_list_t *)0);
}

/** :argile_code_getdef <argile code code> <call> <(list of (def)) & pprev> <(list of (def)) & pnext>: -> nothing **/
void argile_code_getdef(argile_code_t * code_6, argile_call_t * p_argile_call, argrt_list_t * * pprev_2, argrt_list_t * * pnext_2)
{
  argrt_list_t * ldef;
  argrt_list_t * lcall;

  ldef = (code_6)->defs;
  lcall = (code_6)->calls;
  if ((p_argile_call)) {
    while (((p_argile_call)->owner)) {
      p_argile_call = (p_argile_call)->owner;
    };
    while (((ldef) && (lcall))) {
      argile_def_t * def = ((argile_def_t *)0);

      def = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
      if (((def)->maker)) {
        argile_call_t * maker = ((argile_call_t *)0);

        maker = (def)->maker;
        while (((maker)->owner)) {
          maker = (maker)->owner;
        };
        while (((lcall != ((argrt_list_t *)0)) && (*((argile_call_t * *)&((argrt_list_t *)lcall)->data) != maker))) {
          if ((*((argile_call_t * *)&((argrt_list_t *)lcall)->data) == p_argile_call)) {
            *pprev_2 = ((argrt_list_t *)ldef)->prev;
            *pnext_2 = ldef;
            return;
          }
          lcall = ((argrt_list_t *)lcall)->next;
        };
      }
      ldef = ((argrt_list_t *)ldef)->next;
    };
  }
  *pprev_2 = (code_6)->defs_tail;
  *pnext_2 = ((argrt_list_t *)0);
}

/** :argile_code_def <argile code code> <def> <int del>: -> nothing **/
void argile_code_def(argile_code_t * code_7, argile_def_t * p_argile_def, int del)
{
  argrt_list_t * curr;
  argrt_list_t * prev;
  argrt_list_t * next;

  (p_argile_def)->scope = code_7;
  curr = argrt_list_new(((void *)((long)p_argile_def)), (((del != 0)) ? ((void *)&argile_def_del) : (((argile_deleter_t)0))));
  argile_code_getdef(code_7, (p_argile_def)->maker, &prev, &next);
  if ((prev == ((argrt_list_t *)0))) {
    argrt_list_prepend(&(code_7)->defs, curr);
    if (((code_7)->defs_tail == ((argrt_list_t *)0))) {
      (code_7)->defs_tail = (code_7)->defs;
    }
  } else if ((next == ((argrt_list_t *)0))) {
    argrt_list_append(&(code_7)->defs_tail, curr);
    if (((code_7)->defs == ((argrt_list_t *)0))) {
      (code_7)->defs = (code_7)->defs_tail;
    }
  } else {
    argrt_list_link(prev, curr);
    argrt_list_link(curr, next);
  }
  if ((((p_argile_def)->maxmatch < 0) || (((code_7)->maxmatch >= 0) && ((p_argile_def)->maxmatch > (code_7)->maxmatch)))) {
    (code_7)->maxmatch = (p_argile_def)->maxmatch;
  }
  if (((p_argile_def)->minmatch < (code_7)->minmatch)) {
    (code_7)->minmatch = (p_argile_def)->minmatch;
  }
  if (((p_argile_def)->minparam < (code_7)->minparam)) {
    (code_7)->minparam = (p_argile_def)->minparam;
  }
  if (((p_argile_def)->minchar < (code_7)->minchar)) {
    (code_7)->minchar = (p_argile_def)->minchar;
  }
  if (((p_argile_def)->minchsum < (code_7)->minchsum)) {
    (code_7)->minchsum = (p_argile_def)->minchsum;
  }
  if (((p_argile_def)->minword < (code_7)->minword)) {
    (code_7)->minword = (p_argile_def)->minword;
  }
  if (((p_argile_def)->minop < (code_7)->minop)) {
    (code_7)->minop = (p_argile_def)->minop;
  }
  if ((!((code_7)->has_weak_defs) && (p_argile_def)->weak)) {
    (code_7)->has_weak_defs = 1;
  }
  if ((argile).stats) {
    switch ((p_argile_def)->dtype) {
      case ARGILE_DEF_BIND: {
        (((argile).stat).binds)++;
      } break;
      case ARGILE_DEF_FUNC: {
        if ((argile_def_is_macro(p_argile_def))) {
          (((argile).stat).macros)++;
        }
        else if ((argile_def_is_cmacro(p_argile_def))) {
          (((argile).stat).Cmacros)++;
        }
        else {
          (((argile).stat).funcs)++;
        }
      } break;
      case ARGILE_DEF_VAR: {
        if (((p_argile_def)->param)) {
          (((argile).stat).params)++;
        } else {
          (((argile).stat).vars)++;
        }
      } break;
      default: {} break;
    };
  }
}

/** :argile_code_check_dupes <argile code code>: -> nothing **/
void argile_code_check_dupes(argile_code_t * code_8)
{
  for (code_8 = (code_8)->upper; (code_8); code_8 = (code_8)->upper) {
    if ((((code_8)->ghost) && !((code_8)->dupe))) {
      argile_code_t * up = ((argile_code_t *)0);

      for (up = (code_8)->upper; (up); up = (up)->upper) {
        if (((up)->ghost == (code_8)->ghost)) {
          (up)->dupe = 1;
        }
      };
    }
  };
}

/** :argile_code_reset_dupes <argile code code>: -> nothing **/
void argile_code_reset_dupes(argile_code_t * code_9)
{
  for (code_9 = (code_9)->upper; (code_9); code_9 = (code_9)->upper) {
    if ((code_9)->dupe) {
      (code_9)->dupe = 0;
    }
  };
}

/** :argile_code_anon <argile code code>: -> nothing **/
void argile_code_anon(argile_code_t * code_10)
{
  argile_buff_t b = ((argile_buff_t){0});

  if (((code_10)->anon)) {
    return;
  }
  argile_buff_puts(&b, "anonymous");
  if (((code_10)->owner)) {
    argile_buff_putc(&b, '_');
    argile_buff_putn(&b, ((((code_10)->owner)->loc).start).row);
    argile_buff_putc(&b, '_');
    argile_buff_putn(&b, ((((code_10)->owner)->loc).end).row);
    argile_buff_putc(&b, '_');
  }
  argile_buff_putc(&b, '\0');
  argile_check_local_collisions(&b, (argile).main);
  argile_check_collisions(&b);
  (code_10)->anon = (b).ptr;
  (code_10)->type = (argile_type_t)ARGILE_TYPE_ANYTHING;
}

/** :argile_code_caster <argile code code> <argile type from> <argile type to>: -> nothing **/
void argile_code_caster(argile_code_t * code_11, argile_type_t from, argile_type_t to)
{
  argile_buff_t b = ((argile_buff_t){0});

  if (((code_11)->anon)) {
    return;
  }
  argile_buff_puts(&b, "cast_");
  argile_type_gen_id_part(from, (code_11)->owner, &b);
  argile_buff_puts(&b, "_to_");
  argile_type_gen_id_part(to, (code_11)->owner, &b);
  argile_buff_putc(&b, '\0');
  argile_check_local_collisions(&b, (argile).main);
  argile_check_collisions(&b);
  (code_11)->caster = 1;
  (code_11)->type = to;
  (code_11)->anon = (b).ptr;
}

/** :argile_code_find_first_param <argile code code>: -> (argile) def **/
argile_def_t * argile_code_find_first_param(argile_code_t * code_12)
{
  argrt_list_t * ld;

  for (ld = (code_12)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ld)->data));
    if (((d)->param)) {
      return d;
    }
  };
  return ((argile_def_t *)0);
}

/** :argile_code_gencode <argile code code>: -> nothing **/
void argile_code_gencode(argile_code_t * code_13)
{
  char * endl = "\n";
  unsigned char variadic;
  argrt_list_t * lc;

  if ((argile).inside_cmacro) {
    endl = " \\\n";
  }
  if (((code_13)->calls == ((argrt_list_t *)0))) {
    if (((code_13)->type != (argile_type_t)ARGILE_TYPE_NOTHING)) {
      argile_code_gen_line(code_13);
      argile_indent();
      if (!(((code_13)->macro || (code_13)->cmacro))) {
        argile_puts("return ");
      }
      argile_type_gen_zero((code_13)->type);
      argile_puts(";");
      argile_puts(endl);
    }
    return;
  }
  variadic = 0;
  if ((((code_13)->anon) && !((code_13)->caster))) {
    argile_indent();
    argile_printf("va_list %s;%s", "anon_va", endl);
    argile_indent();
    argile_printf("va_start(%s, %s);%s%s", "anon_va", "anon_arg", endl, endl);
    variadic = 1;
  }
  for (lc = (code_13)->calls; ((lc) && !(((argile).error))); lc = ((argrt_list_t *)lc)->next) {
    argile_call_t * c = ((argile_call_t *)0);

    c = ((argile_call_t *)*((argile_call_t * *)&((argrt_list_t *)lc)->data));
    if ((((((argrt_list_t *)lc)->next == ((argrt_list_t *)0)) && !(((code_13)->macro || (code_13)->cmacro))) && ((code_13)->type != (argile_type_t)ARGILE_TYPE_NOTHING))) {
      argile_type_t t;

      t = argile_call_get_type(c);
      if (((argile_type_match((code_13)->type, t)) && !((((code_13)->type == (argile_type_t)ARGILE_TYPE_ANYTHING) && (t == (argile_type_t)ARGILE_TYPE_NOTHING))))) {
        argile_call_gen_line(c);
        argile_indent();
        if (variadic) {
          argile_printf("%s = ", "anon_arg");
        } else {
          argile_puts("return ");
        }
        if ((((code_13)->type == (argile_type_t)ARGILE_TYPE_ANYTHING) && (t != (argile_type_t)ARGILE_TYPE_ANYTHING))) {
          argile_puts("(");
          argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
          argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
          argile_puts(")");
        }
        argile_call_gencode(c, 1);
        argile_puts(";");
        argile_puts(endl);
        if (variadic) {
          argile_indent();
          argile_printf("va_end(%s);%s", "anon_va", endl);
          argile_indent();
          argile_printf("return %s;%s", "anon_arg", endl);
        }
      }
      else {
        argile_call_gen_line(c);
        argile_call_gencode(c, 0);
        if (variadic) {
          argile_indent();
          argile_printf("va_end(%s);%s", "anon_va", endl);
        }
        argile_indent();
        argile_puts("return ");
        argile_type_gen_zero((code_13)->type);
        argile_puts(";");
        argile_puts(endl);
      }
    }
    else {
      argile_call_gen_line(c);
      argile_call_gencode(c, 0);
    }
  };
}

/** :argile_code_gendata <argile code code>: -> nothing **/
void argile_code_gendata(argile_code_t * code_14)
{
  argrt_list_t * lc;

  argile_puts("{");
  for (lc = (code_14)->calls; ((lc) && !(((argile).error))); lc = ((argrt_list_t *)lc)->next) {
    argile_call_t * c = ((argile_call_t *)0);

    c = *((argile_call_t * *)&((argrt_list_t *)lc)->data);
    if ((((argrt_list_t *)lc)->next)) {
      argile_call_gencode(c, 2);
      argile_puts(", ");
    } else {
      argile_type_t old;

      old = (c)->context;
      (c)->context = (argile_type_t)ARGILE_TYPE_ANYTHING;
      argile_call_gencode(c, 2);
      (c)->context = old;
    }
  };
  argile_puts("}");
}

/** :argile_code_gen_includes <argile code code>: -> nothing **/
void argile_code_gen_includes(argile_code_t * code_15)
{
  unsigned char some;
  argrt_list_t * li;
  argrt_list_t * lp;

  some = 0;
  for (li = argrt_list_end((argile).sysincludes); (li); li = ((argrt_list_t *)li)->prev) {
    argile_printf("#include <%s>\n", *((char * *)&((argrt_list_t *)li)->data));
    some = 1;
  };
  if (some) {
    argile_puts("\n");
    some = 0;
  }
  for (li = argrt_list_end((argile).includes); (li); li = ((argrt_list_t *)li)->prev) {
    char * incl = "";
    unsigned char found_sys;

    incl = *((char * *)&((argrt_list_t *)li)->data);
    found_sys = 0;
    for (lp = (argile).sys_inc_path; (lp); lp = ((argrt_list_t *)lp)->next) {
      char * path = "";
      int plen = 0;

      path = *((char * *)&((argrt_list_t *)lp)->data);
      plen = strlen(path);
      if ((strncmp(incl, path, plen) == 0)) {
        int offset = 0;

        offset = plen;
        while (((incl)[offset] == '/')) {
          (offset)++;
        };
        argile_printf("#include <%s>\n", ((incl) + offset));
        found_sys = 1;
        break;
      }
    };
    some = 1;
    if (found_sys) {
      continue;
    }
    argile_printf("#include \"%s\"\n", incl);
  };
  if (some) {
    argile_puts("\n");
  }
}

/** :argile_code_gen_defines <argile code code> <bool privates>: -> nothing **/
void argile_code_gen_defines(argile_code_t * code_16, unsigned char privates)
{
  unsigned char some;
  argrt_list_t * ldef;
  argrt_list_t * lcall;

  some = 0;
  if (((code_16 == (argile).main) != privates)) {
    for (ldef = (code_16)->defs; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
      argile_def_t * def = ((argile_def_t *)0);

      def = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
      if ((def)->ext) {
        continue;
      }
      if ((privates && !(((def)->private || (code_16 != (argile).main))))) {
        continue;
      }
      if (((def)->dtype == ARGILE_DEF_FUNC)) {
        argile_code_t * body = ((argile_code_t *)0);

        body = ((def)->dval).code;
        if ((body == ((argile_code_t *)0))) {
          continue;
        }
        if ((body)->cmacro) {
          int nparams = 0;
          unsigned char old_in_cmacro;

          some = 1;
          argile_def_gen_line(def, code_16);
          argile_puts("#define ");
          argile_puts(argile_def_gen_id(def));
          if ((body)->has_params) {
            argile_puts("(");
          }
          gen_Cmacro_autoparams(&nparams, &body);
          gen_Cmacro_params(&nparams, (def)->syntax);
          if ((body)->has_params) {
            argile_puts(")");
          }
          argile_puts(" ");
          old_in_cmacro = (argile).inside_cmacro;
          (argile).inside_cmacro = 1;
          if (has_several_calls(body)) {
            if (((body)->type != (argile_type_t)ARGILE_TYPE_NOTHING)) {
              argile_puts("(");
            }
            argile_puts("{ \\\n");
            ((argile).indent)++;
            argile_code_gen_vars(body, 0);
            argile_code_gencode(body);
            ((argile).indent)--;
            argile_puts("}");
            if (((body)->type != (argile_type_t)ARGILE_TYPE_NOTHING)) {
              argile_puts(")");
            }
            argile_puts("\n");
          }
          else if (((body)->calls)) {
            argile_call_t * call = ((argile_call_t *)0);

            call = *((argile_call_t * *)&((argrt_list_t *)(body)->calls)->data);
            if (((call)->def == ((argile_def_t *)0))) {
              argile_call_gencode(call, 0);
            }
            else {
              argile_puts("(");
              argile_call_gencode(call, 0);
              argile_puts(")");
            }
          }
          argile_puts("\n");
          (argile).inside_cmacro = old_in_cmacro;
        }
      }
    };
  }
  for (lcall = (code_16)->calls; (lcall); lcall = ((argrt_list_t *)lcall)->next) {
    argile_call_t * call = ((argile_call_t *)0);

    call = *((argile_call_t * *)&((argrt_list_t *)lcall)->data);
    gen_defines(call, privates);
  };
  if (some) {
    argile_puts("\n");
  }
}

/** :argile_code_pregen_ids <argile code code>: -> nothing **/
void argile_code_pregen_ids(argile_code_t * code_17)
{
  pregen_includes_rec((code_17)->upper);
  pregen(code_17, 0);
}

/** :argile_code_gen_typedefs <argile code code> <int privates>: -> nothing **/
void argile_code_gen_typedefs(argile_code_t * code_18, int privates_2)
{
  if ((gen_typedefs(code_18, (privates_2 != 0), 1) != 0)) {
    argile_puts("\n");
  }
}

/** :argile_code_gen_enums <argile code code> <int privates>: -> nothing **/
void argile_code_gen_enums(argile_code_t * code_19, int privates_3)
{
  gen_enums(code_19, (privates_3 != 0), 1);
}

/** :argile_code_gen_structs_and_unions <argile code code> <int privates>: -> nothing **/
void argile_code_gen_structs_and_unions(argile_code_t * code_20, int privates_4)
{
  gen_structs_and_unions(code_20, (privates_4 != 0), 1);
}

/** :argile_code_gen_protos <argile code code> <int statics>: -> nothing **/
void argile_code_gen_protos(argile_code_t * code_21, int statics)
{
  if ((gen_protofuncs(code_21, (statics != 0), 0) != 0)) {
    argile_puts("\n");
  }
}

/** :argile_code_gen_funcs <argile code code>: -> nothing **/
void argile_code_gen_funcs(argile_code_t * code_22)
{
  gen_protofuncs(code_22, 1, 1);
}

/** :gen param id of <def> from <call>: -> text **/
static char * gen_param_id_of_from(argile_def_t * p_argile_def_2, argile_call_t * p_argile_call_2)
{
  argile_syn_param_t * p = ((argile_syn_param_t *)0);

  p = (p_argile_def_2)->param;
  if ((((p != ((argile_syn_param_t *)0)) && ((p)->genid == (char *)0)) && ((p)->name == (char *)0))) {
    argile_buff_t b = ((argile_buff_t){0});

    argile_buff_puts(&b, "p_");
    argile_type_gen_id_part((p)->type, p_argile_call_2, &b);
    argile_buff_putc(&b, '\0');
    argile_check_local_collisions(&b, (p_argile_def_2)->scope);
    argile_check_collisions(&b);
    (p)->genid = (b).ptr;
    return (p)->genid;
  }
  return argile_def_gen_id(p_argile_def_2);
}

/** :gen protofuncs <argile code code> <bool statics> <bool bodies>: -> int **/
static int gen_protofuncs(argile_code_t * code_23, unsigned char statics_2, unsigned char bodies)
{
  int count = 0;
  argrt_list_t * cur;
  argrt_list_t * lc;

  if (((code_23)->anon)) {
    unsigned char skip;

    skip = 0;
    argile_code_gen_line(code_23);
    if (((code_23)->caster)) {
      if ((bodies || !(statics_2))) {
        argile_def_t * from_2 = ((argile_def_t *)0);

        from_2 = argile_code_find_first_param(code_23);
        if ((from_2)) {
          argile_type_t t;

          t = (((int)(from_2)->type) & ~((1 << 31)));
          argile_type_gen_prefix((code_23)->type);
          argile_printf(" %s(", (code_23)->anon);
          argile_type_gen_prefix(t);
          argile_puts(" ");
          argile_puts(gen_param_id_of_from(from_2, (code_23)->owner));
          argile_type_gen_suffix(t);
          argile_puts(")");
          argile_type_gen_suffix((code_23)->type);
        } else {
          argile_die_at((code_23)->owner, "no parameter found in caster (bug)");
        }
      } else {
        skip = 1;
      }
    } else if ((bodies || statics_2)) {
      argile_puts("static ");
      argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_printf(" %s(", (code_23)->anon);
      argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_puts("anon_arg");
      argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_puts(", ...)");
      argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
    } else {
      skip = 1;
    }
    if (!(skip)) {
      if (bodies) {
        argile_puts("\n{\n");
        ((argile).indent)++;
        argile_code_gen_vars(code_23, 0);
        argile_code_gencode(code_23);
        ((argile).indent)--;
        argile_puts("}\n\n");
      } else {
        argile_puts(";\n");
      }
    }
    (count)++;
  }
  for (cur = (code_23)->defs; (cur); cur = ((argrt_list_t *)cur)->next) {
    int nparam = 0;
    argile_def_t * d = ((argile_def_t *)0);
    argile_code_t * body = ((argile_code_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)cur)->data);
    if ((((d)->dtype != ARGILE_DEF_FUNC) || (d)->nodecl)) {
      continue;
    }
    body = ((d)->dval).code;
    if (((bodies && (body == ((argile_code_t *)0))) || ((body) && ((body)->macro || (body)->cmacro)))) {
      continue;
    }
    if ((!(bodies) && ((!(statics_2) && ((d)->private || (code_23 != (argile).main))) || ((statics_2 && !((d)->private)) && (code_23 == (argile).main))))) {
      continue;
    }
    gen_syntax_comment(d, ((((code_23)->calls)) ? (*((argile_call_t * *)&((argrt_list_t *)(code_23)->calls)->data)) : (((argile_call_t *)0))));
    argile_def_gen_line(d, code_23);
    if (((code_23 != (argile).main) || (d)->private)) {
      argile_puts("static ");
    }
    argile_type_gen_prefix((d)->type);
    argile_printf(" %s(", argile_def_gen_id(d));
    if ((body)) {
      argrt_list_t * la;

      for (la = (body)->autoparams; (la); la = ((argrt_list_t *)la)->next) {
        argile_def_t * a = ((argile_def_t *)0);

        a = *((argile_def_t * *)&((argrt_list_t *)la)->data);
        if (((nparam)++ != 0)) {
          argile_puts(", ");
        }
        argile_type_gen_prefix((a)->type);
        argile_puts(" ");
        if ((((((int)(a)->type) >> 30) & 1))) {
          argile_ref(1);
        }
        argile_puts(argile_def_gen_id(a));
        argile_type_gen_suffix((a)->type);
      };
    }
    argile_syntax_gen_params((d)->syntax, ((int)bodies), &nparam);
    if ((((body) && (body)->variadic) || ((body == ((argile_code_t *)0)) && !((d)->ext)))) {
      argile_syntax_gen_options((d)->syntax, body, &nparam);
      argile_syntax_gen_enums((d)->syntax, body, &nparam);
      argile_syntax_gen_lists((d)->syntax, body, &nparam);
    }
    if ((has_pseudo_param((d)->syntax) || (((body) && !((body)->variadic)) && has_optenulis((d)->syntax)))) {
      if ((nparam != 0)) {
        argile_puts(", ");
        argile_puts("...");
      }
    }
    argile_puts(")");
    argile_type_gen_suffix((d)->type);
    if (bodies) {
      argile_puts("\n");
      argile_puts("{\n");
      ((argile).indent)++;
      argile_code_gen_vars(body, 0);
      argile_code_gencode(body);
      ((argile).indent)--;
      argile_puts("}\n\n");
    } else {
      argile_puts(";\n");
    }
    (count)++;
  };
  for (lc = (code_23)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
    count += gen_protofuncs_2(*((argile_call_t * *)&((argrt_list_t *)lc)->data), statics_2, bodies);
  };
  return count;
}

/** :gen protofuncs <argile call call> <bool statics> <bool bodies>: -> int **/
static int gen_protofuncs_2(argile_call_t * call, unsigned char statics_3, unsigned char bodies_2)
{
  int count = 0;
  argrt_list_t * lm;

  for (lm = (call)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      count += gen_protofuncs_2(((m)->value).call, statics_3, bodies_2);
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * c = ((argile_cons_t *)0);

      c = ((m)->value).cons;
      if (((c)->ctype == ARGILE_CONS_CODE)) {
        count += gen_protofuncs(((c)->cvalue).code, statics_3, bodies_2);
      }
    }
  };
  return count;
}

/** :argile_code_gen_vars <argile code code> <int externs>: -> nothing **/
void argile_code_gen_vars(argile_code_t * code_24, int externs)
{
  unsigned char some;
  argrt_list_t * ld;

  some = 0;
  for (ld = (code_24)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if ((((d)->dtype != ARGILE_DEF_VAR) || (((((d)->param) || (d)->nodecl) || (d)->locall) || (d)->private))) {
      continue;
    }
    if (((code_24 == (argile).main) && ((d)->ext && (externs == 0)))) {
      continue;
    }
    if ((!((d)->ext) && (externs == 1))) {
      continue;
    }
    argile_def_gen_line(d, code_24);
    argile_indent();
    if (((externs != 0) || (d)->ext)) {
      argile_puts("extern ");
    }
    argile_type_gen_prefix((((d)->dval).var)->type);
    argile_puts(" ");
    argile_puts(argile_def_gen_id(d));
    argile_type_gen_suffix((((d)->dval).var)->type);
    if (((externs == 0) && !((d)->ext))) {
      argile_match_t * init = ((argile_match_t *)0);

      init = (((d)->dval).var)->init;
      if ((argile_match_is_const(init))) {
        argile_puts(" = ");
        if (has_data_block(((d)->dval).var)) {
          argile_code_gendata(((((init)->value).cons)->cvalue).code);
        }
        else {
          argile_match_gencode(init);
        }
      } else {
        argile_type_t t;
        argile_type_info_t * i = ((argile_type_info_t *)0);

        t = (((int)(d)->type) & ~((1 << 31)));
        i = argile_type_get_info(t);
        if ((((i == ((argile_type_info_t *)0)) || ((i)->ttype == ARGILE_TYPE_KIND_BIND)) || ((i)->ttype == ARGILE_TYPE_KIND_CLASS))) {
          argile_puts(" = ");
          argile_type_gen_zero(t);
        }
      }
    }
    argile_puts((((argile).inside_cmacro) ? ("; \\\n") : (";\n")));
    if (!(some)) {
      some = 1;
    }
  };
  if ((some && !((argile).inside_cmacro))) {
    argile_puts("\n");
  }
}

/** :<var> has data block: -> bool **/
static unsigned char has_data_block(argile_var_t * p_argile_var)
{
  if ((((((int)(p_argile_var)->type) >> 30) & 1))) {
    if (((p_argile_var)->init)) {
      if ((((p_argile_var)->init)->type == ARGILE_MATCH_CONS)) {
        argile_cons_t * cons = ((argile_cons_t *)0);

        cons = (((p_argile_var)->init)->value).cons;
        if (((cons)->ctype == ARGILE_CONS_CODE)) {
          if ((((cons)->cvalue).code)) {
            return 1;
          }
        }
      }
    }
  }
  return 0;
}

/** :argile_code_gen_private_vars <argile code code>: -> nothing **/
void argile_code_gen_private_vars(argile_code_t * code_25)
{
  unsigned char some;
  argrt_list_t * ld;
  argrt_list_t * lc;

  some = 0;
  for (ld = (code_25)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);
    argile_match_t * init = ((argile_match_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if ((((d)->dtype != ARGILE_DEF_VAR) || ((((!((d)->private) || ((d)->param)) || (d)->nodecl) || (d)->locall) || (d)->ext))) {
      continue;
    }
    argile_def_gen_line(d, code_25);
    argile_indent();
    argile_puts("static ");
    argile_type_gen_prefix((((d)->dval).var)->type);
    argile_puts(" ");
    argile_puts(argile_def_gen_id(d));
    argile_type_gen_suffix((((d)->dval).var)->type);
    init = (((d)->dval).var)->init;
    if ((argile_match_is_const(init))) {
      argile_puts(" = ");
      if (has_data_block(((d)->dval).var)) {
        argile_code_gendata(((((init)->value).cons)->cvalue).code);
      }
      else {
        argile_match_gencode(init);
      }
    } else {
      argile_type_t t;
      argile_type_info_t * i = ((argile_type_info_t *)0);

      t = (((int)(d)->type) & ~((1 << 31)));
      i = argile_type_get_info(t);
      if (((!((i)) || ((i)->ttype == ARGILE_TYPE_KIND_BIND)) || ((i)->ttype == ARGILE_TYPE_KIND_CLASS))) {
        argile_puts(" = ");
        argile_type_gen_zero(t);
      }
    }
    argile_puts((((argile).inside_cmacro) ? ("; \\\n") : (";\n")));
    if (!(some)) {
      some = 1;
    }
  };
  if ((some && !((argile).inside_cmacro))) {
    argile_puts("\n");
  }
  for (lc = (code_25)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
    private_vars(*((argile_call_t * *)&((argrt_list_t *)lc)->data));
  };
}

/** :argile_code_gen_main <argile code code>: -> nothing **/
void argile_code_gen_main(argile_code_t * code_26)
{
  argrt_list_t * lc;

  (code_26)->type = (argile_type_t)ARGILE_TYPE_INTEGER;
  lc = argrt_list_end((code_26)->calls);
  if (((lc) && (*((argile_call_t * *)&((argrt_list_t *)lc)->data)))) {
    (*((argile_call_t * *)&((argrt_list_t *)lc)->data))->context = (argile_type_t)ARGILE_TYPE_INTEGER;
  }
  argile_puts("int main(int argc, char **argv)\n{\n");
  ((argile).indent)++;
  if ((argile).cat_main) {
    argrt_list_t * lf;

    lf = (argile).used;
    for (; (lf); lf = ((argrt_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);

      f = *((argile_file_t * *)&((argrt_list_t *)lf)->data);
      if (((f)->code == code_26)) {
        continue;
      }
      argile_indent();
      argile_printf("/* %s */ {\n", (f)->path);
      ((argile).indent)++;
      ((f)->code)->type = (argile_type_t)ARGILE_TYPE_NOTHING;
      argile_code_gencode((f)->code);
      ((argile).indent)--;
      argile_indent();
      argile_puts("}\n");
    };
  }
  argile_code_gencode(code_26);
  ((argile).indent)--;
  argile_puts("}\n");
}

/** :argile_code_gen_line <argile code code>: -> nothing **/
void argile_code_gen_line(argile_code_t * code_27)
{
  if (((argile).gen_lines == 0)) {
    return;
  }
  if (((code_27)->macro || (code_27)->cmacro)) {
    return;
  }
  if (((code_27)->owner == ((argile_call_t *)0))) {
    return;
  }
  argile_call_gen_line((code_27)->owner);
}

/** :argile_code_find_autoparams <argile code code>: -> bool **/
unsigned char argile_code_find_autoparams(argile_code_t * code_28)
{
  unsigned char found;
  argrt_list_t * lc;

  found = 0;
  lc = (code_28)->calls;
  for (; (lc); lc = ((argrt_list_t *)lc)->next) {
    if (argile_call_find_autoparams(*((argile_call_t * *)&((argrt_list_t *)lc)->data))) {
      found = 1;
    }
  };
  return found;
}

/** :argile_code_push_macro_params <argile code code> <call>: -> nothing **/
void argile_code_push_macro_params(argile_code_t * code_29, argile_call_t * p_argile_call_3)
{
  argrt_list_t * ld;

  argrt_list_prepend(&(code_29)->macro_calls, argrt_list_new(((void *)((long)p_argile_call_3)), ((argile_deleter_t)0)));
  argrt_list_prepend(&(code_29)->macro_shovels, argrt_list_new(((void *)((long)argile_shovel_new(p_argile_call_3))), (void *)&argile_shovel_del));
  ld = (code_29)->defs;
  for (; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if (((((d)->param) && !((d)->locall)) && !((d)->reused_var))) {
      argrt_list_t * lcp;

      lcp = (p_argile_call_3)->params;
      for (; (lcp); lcp = ((argrt_list_t *)lcp)->next) {
        argile_call_param_t * cp = ((argile_call_param_t *)0);

        cp = *((argile_call_param_t * *)&((argrt_list_t *)lcp)->data);
        if (((cp)->syn_param == (d)->param)) {
          argrt_list_prepend(&(((d)->dval).var)->macro_params, argrt_list_new(((void *)((long)cp)), ((argile_deleter_t)0)));
          break;
        }
      };
      if ((lcp == ((argrt_list_t *)0))) {
        argrt_list_prepend(&(((d)->dval).var)->macro_params, argrt_list_new(((void *)((long)(argile_call_param_t *)0)), ((argile_deleter_t)0)));
      }
    }
  };
}

/** :argile_code_pop_macro_params <argile code code>: -> nothing **/
void argile_code_pop_macro_params(argile_code_t * code_30)
{
  argrt_list_t * ld;

  for (ld = (code_30)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if ((((d)->param != ((argile_syn_param_t *)0)) && (!((d)->locall) && !((d)->reused_var)))) {
      argrt_list_delete_all(argrt_list_pop(&(((d)->dval).var)->macro_params));
    }
  };
  argrt_list_delete_all(argrt_list_pop(&(code_30)->macro_shovels));
  argrt_list_delete_all(argrt_list_pop(&(code_30)->macro_calls));
}

/** :_cumulated_numcomp <call>: -> int **/
static int _cumulated_numcomp(argile_call_t * p_argile_call_4)
{
  unsigned int n = 0;
  argrt_list_t * lm;

  n = (p_argile_call_4)->numcomp;
  lm = (p_argile_call_4)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_call_t * sub = ((argile_call_t *)0);
      int c = 0;

      sub = ((m)->value).call;
      c = _cumulated_numcomp(sub);
      if (((sub)->type == ARGILE_CALL_EXPLICIT)) {
        n += c;
      }
    }
  };
  return ((int)n);
}

/** :_f_all <def>: -> int **/
static int _f_all(argile_def_t * p_argile_def_3)
{
  return 1;
}

/** :_f_defmakers <def>: -> int **/
static int _f_defmakers(argile_def_t * p_argile_def_4)
{
  if ((((p_argile_def_4)->dtype == ARGILE_DEF_BIND) && (((p_argile_def_4)->dval).bind)->defmaker)) {
    return 1;
  }
  if (((p_argile_def_4)->type == (argile_type_t)ARGILE_TYPE_TYPE)) {
    if (((p_argile_def_4)->dtype == ARGILE_DEF_TYPE)) {
      return 1;
    }
    if ((argile_def_is_macro(p_argile_def_4))) {
      return 1;
    }
  }
  if (((p_argile_def_4)->param != ((argile_syn_param_t *)0))) {
    return 1;
  }
  return 0;
}

/** :_percent <int n> <int max>: -> nothing **/
static void _percent(int * last, int n, int max)
{
  int p = 0;

  if (!((argile).progress)) {
    return;
  }
  p = ((n * 1000) / max);
  if ((p != *last)) {
    *last = p;
    fprintf(stderr, "\r% 3d.%d%%%s", (p / 10), (p % 10), (((p >= 1000)) ? ("\n") : ("")));
  }
}

/** :gen defines <call> <bool privates>: -> nothing **/
static void gen_defines(argile_call_t * p_argile_call_5, unsigned char privates_5)
{
  argrt_list_t * lm;

  lm = (p_argile_call_5)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      gen_defines(((m)->value).call, privates_5);
    }
    else if ((((m)->type == ARGILE_MATCH_CONS) && privates_5)) {
      argile_cons_t * c = ((argile_cons_t *)0);

      c = ((m)->value).cons;
      if (((c)->ctype == ARGILE_CONS_CODE)) {
        argile_code_gen_defines(((c)->cvalue).code, privates_5);
      }
    }
  };
}

/** :<argile code c> has several calls: -> bool **/
static unsigned char has_several_calls(argile_code_t * c)
{
  argrt_list_t * ld;

  if ((((c)->calls) && (((argrt_list_t *)(c)->calls)->next))) {
    return 1;
  }
  ld = (c)->defs;
  for (; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if (((!((d)->implicit) && !((d)->nodecl)) && !(((d)->param)))) {
      return 1;
    }
  };
  return 0;
}

/** :gen Cmacro autoparams: -> nothing **/
static void gen_Cmacro_autoparams(int * nparams, argile_code_t * * body)
{
  argrt_list_t * lap;

  for (lap = (*body)->autoparams; (lap); lap = ((argrt_list_t *)lap)->next) {
    if (((*nparams)++ > 0)) {
      argile_puts(",");
    }
    argile_puts(argile_def_gen_id(*((argile_def_t * *)&((argrt_list_t *)lap)->data)));
  };
}

/** :gen Cmacro params <list of (argile syntax) lsyn>: -> nothing **/
static void gen_Cmacro_params(int * nparams, argrt_list_t * lsyn)
{
  for (; (lsyn); lsyn = ((argrt_list_t *)lsyn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)lsyn)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        if (((*nparams)++ > 0)) {
          argile_puts(",");
        }
        argile_puts(argile_syn_param_gen_id(((s)->value).syn_param));
      } break;
      case ARGILE_SYN_OPTION: {
        gen_Cmacro_params(nparams, ((s)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * le;

        le = ((s)->value).syn_enum;
        for (; (le); le = ((argrt_list_t *)le)->next) {
          gen_Cmacro_params(nparams, *((argrt_list_t * *)&((argrt_list_t *)le)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        gen_Cmacro_params(nparams, (((s)->value).syn_list)->sub);
      } break;
      default: {} break;
    };
  };
}

/** :pregen includes rec <argile code up>: -> nothing **/
static void pregen_includes_rec(argile_code_t * up)
{
  argrt_list_t * ld;

  if (((up == ((argile_code_t *)0)) || ((up)->ghost == ((argile_code_t *)0)))) {
    return;
  }
  pregen_includes_rec((up)->upper);
  for (ld = (up)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ld)->data));
    if (!(((((((d)->locall || (d)->private) || ((d)->param != ((argile_syn_param_t *)0))) || ((d)->dtype == ARGILE_DEF_BIND)) || ((d)->dtype == ARGILE_DEF_TYPE)) || (argile_def_is_macro(d))))) {
      argile_def_gen_id(d);
    }
  };
}

/** :pregen <argile code code> <bool in_macro>: -> nothing **/
static void pregen(argile_code_t * code_31, unsigned char in_macro)
{
  argrt_list_t * ld;
  argrt_list_t * lc;

  if ((((code_31)->macro || (code_31)->cmacro) && !(in_macro))) {
    in_macro = 1;
  }
  for (ld = (code_31)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if (((d)->dtype == ARGILE_DEF_TYPE)) {
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      ti = argile_type_get_info(((d)->dval).type);
      if ((ti != ((argile_type_info_t *)0))) {
        if (((ti)->name == (char *)0)) {
          (ti)->name = argile_def_gen_id(d);
        }
        if (((ti)->ttype == ARGILE_TYPE_KIND_CLASS)) {
          argrt_list_t * f;

          for (f = (((ti)->tval).t_class).fields; (f); f = ((argrt_list_t *)f)->next) {
            argile_field_gen_id(*((argile_field_t * *)&((argrt_list_t *)f)->data), (char *)0, ((argile_call_t *)0));
          };
        }
        else if (((ti)->ttype == ARGILE_TYPE_KIND_UNION)) {
          argrt_list_t * f;

          for (f = (((ti)->tval).t_union).variants; (f); f = ((argrt_list_t *)f)->next) {
            argile_field_gen_id(*((argile_field_t * *)&((argrt_list_t *)f)->data), "u_", (d)->maker);
          };
        }
      }
    } else if (((in_macro && ((d)->dtype == ARGILE_DEF_VAR)) && ((d)->param == ((argile_syn_param_t *)0)))) {
      argile_def_pregen_global_id(d);
    }
  };
  for (lc = (code_31)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
    pregen_2(*((argile_call_t * *)&((argrt_list_t *)lc)->data), in_macro);
  };
}

/** :pregen <call> <bool in_macro>: -> nothing **/
static void pregen_2(argile_call_t * p_argile_call_6, unsigned char in_macro_2)
{
  argrt_list_t * lm;

  for (lm = (p_argile_call_6)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      pregen_2(((m)->value).call, in_macro_2);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      argile_code_t * code_32 = ((argile_code_t *)0);

      code_32 = ((((m)->value).cons)->cvalue).code;
      if ((((!(((code_32)->anon)) && ((code_32)->owner)) && (((code_32)->owner)->def)) && ((((((code_32)->owner)->def)->dtype == ARGILE_DEF_FUNC) && !((argile_def_is_macro(((code_32)->owner)->def)))) && !((argile_def_is_cmacro(((code_32)->owner)->def)))))) {
        argile_code_anon(code_32);
      }
      pregen(code_32, in_macro_2);
    }
  };
}

/** :gen typedefs <argile code code> <bool privates> <bool global>: -> int **/
static int gen_typedefs(argile_code_t * code_32, unsigned char privates_6, unsigned char global)
{
  int done = 0;

  if (((global && !(privates_6)) || (privates_6 && !(global)))) {
    argrt_list_t * ld;

    for (ld = (code_32)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if ((ti == ((argile_type_info_t *)0))) {
        continue;
      }
      (ti)->rec = 1;
    };
    for (ld = (code_32)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti == ((argile_type_info_t *)0)) || !((ti)->rec))) {
        continue;
      }
      (ti)->rec = 0;
      switch ((ti)->ttype) {
        case ARGILE_TYPE_KIND_ENUM: {
          argile_def_gen_line(d, code_32);
          argile_indent();
          argile_printf("typedef enum   %s_e %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_UNION: {
          argile_def_gen_line(d, code_32);
          argile_indent();
          argile_printf("typedef union  %s_u %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_CLASS: {
          if ((((ti)->tval).t_class)._struct) {
            break;
          }
          argile_def_gen_line(d, code_32);
          argile_indent();
          argile_printf("typedef struct %s_s %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_CTYPE: {
          if ((((ti)->tval).t_ctype).use_typedef) {
            char * p = "";
            char * s = "";

            p = (((ti)->tval).t_ctype).prefix;
            s = (((ti)->tval).t_ctype).suffix;
            argile_printf("typedef %s %s%s;\n", (((p)) ? (p) : ("")), (ti)->name, (((s)) ? (s) : ("")));
            (done)++;
          }
        } break;
        default: {} break;
      };
    };
  }
  if (privates_6) {
    argrt_list_t * lc;

    for (lc = (code_32)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
      done += gen_typedefs_2(*((argile_call_t * *)&((argrt_list_t *)lc)->data));
    };
  }
  return done;
}

/** :gen typedefs <argile call call>: -> int **/
static int gen_typedefs_2(argile_call_t * call_2)
{
  int count = 0;
  argrt_list_t * lm;

  for (lm = (call_2)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      count += gen_typedefs_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      count += gen_typedefs(((((m)->value).cons)->cvalue).code, 1, 0);
    }
  };
  return count;
}

/** :gen enums <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_enums(argile_code_t * code_33, unsigned char privates_7, unsigned char global_2)
{
  if (((global_2 && !(privates_7)) || (privates_7 && !(global_2)))) {
    argrt_list_t * ld;

    for (ld = (code_33)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if (!(((d)->dtype == ARGILE_DEF_TYPE))) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && ((ti)->ttype == ARGILE_TYPE_KIND_ENUM))) {
        (ti)->rec = 1;
      }
    };
    for (ld = (code_33)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if (!(((d)->dtype == ARGILE_DEF_TYPE))) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && (ti)->rec)) {
        argrt_list_t * lm;
        argrt_list_t * lv;

        (ti)->rec = 0;
        lm = (((ti)->tval).t_enum).members;
        lv = (((ti)->tval).t_enum).values;
        argile_printf("enum   %s_e {\n", argile_def_gen_id(d));
        while (((lm) && (lv))) {
          argile_puts("  ");
          argile_puts(*((char * *)&((argrt_list_t *)lm)->data));
          if ((*((int* *)&((argrt_list_t *)lv)->data))) {
            argile_printf(" = %i", **((int* *)&((argrt_list_t *)lv)->data));
          }
          if ((((argrt_list_t *)lm)->next)) {
            argile_puts(",");
          }
          argile_puts("\n");
          lm = ((argrt_list_t *)lm)->next;
          lv = ((argrt_list_t *)lv)->next;
        };
        argile_puts("};\n\n");
      }
    };
  }
  if (privates_7) {
    argrt_list_t * lc;

    for (lc = (code_33)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
      gen_enums_2(*((argile_call_t * *)&((argrt_list_t *)lc)->data));
    };
  }
}

/** :gen enums <call>: -> nothing **/
static void gen_enums_2(argile_call_t * p_argile_call_7)
{
  argrt_list_t * lm;

  for (lm = (p_argile_call_7)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      gen_enums_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      gen_enums(((((m)->value).cons)->cvalue).code, 1, 0);
    }
  };
}

/** :gen structs and unions <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_structs_and_unions(argile_code_t * code_34, unsigned char privates_8, unsigned char global_3)
{
  if (((global_3 && !(privates_8)) || (privates_8 && !(global_3)))) {
    argrt_list_t * lx;

    for (lx = (code_34)->defs; (lx); lx = ((argrt_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)lx)->data);
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && (((ti)->ttype == ARGILE_TYPE_KIND_CLASS) || ((ti)->ttype == ARGILE_TYPE_KIND_UNION)))) {
        (ti)->rec = 1;
      }
    };
    for (lx = (code_34)->defs; (lx); lx = ((argrt_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)lx)->data);
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      }
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && (ti)->rec)) {
        gen_structs_and_unions_3(code_34, d, ti);
      }
    };
  }
  if (privates_8) {
    argrt_list_t * lc;

    for (lc = (code_34)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
      gen_structs_and_unions_2(*((argile_call_t * *)&((argrt_list_t *)lc)->data));
    };
  }
}

/** :gen structs and unions <call>: -> nothing **/
static void gen_structs_and_unions_2(argile_call_t * p_argile_call_8)
{
  argrt_list_t * lm;

  for (lm = (p_argile_call_8)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (!((m))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      gen_structs_and_unions_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      gen_structs_and_unions(((((m)->value).cons)->cvalue).code, 1, 0);
    }
  };
}

/** :gen structs and unions <argile code code> <def d> <type info ti>: -> nothing **/
static void gen_structs_and_unions_3(argile_code_t * code_35, argile_def_t * d, argile_type_info_t * ti)
{
  argrt_list_t * fields;
  char * format = "";
  argrt_list_t * lf;

  if (!((ti)->rec)) {
    return;
  }
  (ti)->rec = 0;
  if (((ti)->ttype == ARGILE_TYPE_KIND_CLASS)) {
    fields = (((ti)->tval).t_class).fields;
    if ((((ti)->tval).t_class)._struct) {
      format = "struct %s {\n";
    }
    else {
      format = "struct %s_s {\n";
    }
  } else if (((ti)->ttype == ARGILE_TYPE_KIND_UNION)) {
    fields = (((ti)->tval).t_union).variants;
    format = "union  %s_u {\n";
  } else {
    return;
  }
  if ((d == ((argile_def_t *)0))) {
    argrt_list_t * ld;

    ld = (code_35)->defs;
    for (; (ld); ld = ((argrt_list_t *)ld)->next) {
      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_TYPE) && (((d)->dval).type == (ti)->type))) {
        break;
      }
    };
    if ((ld == ((argrt_list_t *)0))) {
      return;
    }
  }
  lf = fields;
  for (; (lf); lf = ((argrt_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = *((argile_field_t * *)&((argrt_list_t *)lf)->data);
    if ((((ti = argile_type_get_info((f)->type)) && (ti)->rec) && ((((((int)(f)->type) >> 30) & 1)) || ((ti)->ttype == ARGILE_TYPE_KIND_UNION)))) {
      gen_structs_and_unions_3(code_35, ((argile_def_t *)0), ti);
    }
  };
  argile_def_gen_line(d, code_35);
  argile_indent();
  argile_printf(format, argile_def_gen_id(d));
  ((argile).indent)++;
  for (lf = fields; (lf); lf = ((argrt_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = *((argile_field_t * *)&((argrt_list_t *)lf)->data);
    argile_indent();
    argile_type_gen_prefix((f)->type);
    argile_puts(" ");
    argile_puts(argile_field_gen_id(f, "u_", (d)->maker));
    argile_type_gen_suffix((f)->type);
    if (((f)->bits != 0)) {
      argile_printf(" : %u", (f)->bits);
    }
    argile_puts(";\n");
  };
  ((argile).indent)--;
  argile_indent();
  argile_puts("};\n\n");
}

/** :<list of (argile syntax) syn> has pseudo param: -> bool **/
static unsigned char has_pseudo_param(argrt_list_t * syn)
{
  for (; (syn); syn = ((argrt_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syn)->data);
    if ((((s)->type == ARGILE_SYN_LIST) && (((s)->value).syn_list)->pseudoempty)) {
      return 1;
    }
  };
  return 0;
}

/** :<list of (argile syntax) syn> has optenulis: -> bool **/
static unsigned char has_optenulis(argrt_list_t * syn_2)
{
  for (; (syn_2); syn_2 = ((argrt_list_t *)syn_2)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syn_2)->data);
    switch ((s)->type) {
      case ARGILE_SYN_OPTION: ;
      case ARGILE_SYN_ENUM: ;
      case ARGILE_SYN_LIST: {
        return 1;
      } break;
      default: {} break;
    };
  };
  return 0;
}

/** :gen syntax comment <def d> <call c>: -> nothing **/
static void gen_syntax_comment(argile_def_t * d_2, argile_call_t * c_2)
{
  unsigned char old;
  argile_buff_t b = ((argile_buff_t){0});

  if (!((argile).proto_syntax)) {
    return;
  }
  old = (argile).use_colors;
  (argile).use_colors = 0;
  argile_syntax_string((d_2)->syntax, &b);
  if (((b).ptr)) {
    argile_puts("/** :");
    argile_output((b).ptr, ((int)(b).len));
    argile_puts(": -> ");
    argile_buff_flush(&b);
    argile_typename((d_2)->type, &b, ((((d_2)->scope)) ? ((d_2)->scope) : ((c_2)->scope)));
    argile_output((b).ptr, ((int)(b).len));
    argile_puts(" **/\n");
    ARGRT_free((b).ptr);
  }
  (argile).use_colors = old;
}

/** :private vars <call>: -> nothing **/
static void private_vars(argile_call_t * p_argile_call_9)
{
  argrt_list_t * lm;

  for (lm = (p_argile_call_9)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (!((m))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      private_vars(((m)->value).call);
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * c_3 = ((argile_cons_t *)0);

      c_3 = ((m)->value).cons;
      if (((c_3)->ctype == ARGILE_CONS_CODE)) {
        argile_code_gen_private_vars(((c_3)->cvalue).code);
      }
    }
  };
}

