// generated by: arc -xuNP -A ./../argrt -M -o call.c -H call.h -m call.argl.tmp call.arg 
#include "call.h"

typedef struct call_path_t_s call_path_t;

struct call_path_t_s {
  int prm;
  int opt;
  int enm;
  int lst;
  argrt_list_t * match;
  argile_call_t * call;
};

/** :_compile <call> as <argile type type>: -> bool **/
static unsigned char _compile_as(argile_call_t *, argile_type_t);
/** :owner - most of <call>: -> (argile) call **/
static argile_call_t * owner_most_of(argile_call_t *);
/** :<def> is made in <call>: -> bool **/
static unsigned char is_made_in(argile_def_t *, argile_call_t *);
/** :<argile code code> has several calls: -> bool **/
static unsigned char has_several_calls(argile_code_t *);
/** :propagate autoparam <def> from <call>: -> bool **/
static unsigned char propagate_autoparam_from(argile_def_t *, argile_call_t *);
/** :shadow of matches <list of (match) matches> <call owner> <argile type type>: -> list of ((argile) match) **/
static argrt_list_t * shadow_of_matches(argile_call_t * * p_argile_call, argrt_list_t *, argile_call_t *, argile_type_t);
/** :_match_path_rec <call_path path> <list of (argile syntax) syntax> <(int) * eaten>: -> bool **/
static unsigned char _match_path_rec(call_path_t *, argrt_list_t *, int*);
/** :_fix_path_rec <call_path path> <list of (argile syntax) syntax>: -> nothing **/
static void _fix_path_rec(call_path_t *, argrt_list_t *);
/** :_make_call_list <call_path path> <call list cl> <list of (argile syntax) syntax>: -> nothing **/
static void _make_call_list(call_path_t *, argile_call_list_t *, argrt_list_t *);
/** :_undo_call_list <call_path path> <call list cl>: -> nothing **/
static void _undo_call_list(call_path_t *, argile_call_list_t *);
/** :_add_param_value <call_path path> <syn param syn_param> <match>: -> nothing **/
static void _add_param_value(call_path_t *, argile_syn_param_t *, argile_match_t *);
/** :_add_syn_val <(list of (list of (int))) & list> <int id>: -> list of (int) **/
static argrt_list_t * _add_syn_val(argrt_list_t * *, int);
/** :_match_no_more <call_path path> <list of (argile syntax) syn>: -> bool **/
static unsigned char _match_no_more(call_path_t *, argrt_list_t *);
/** :_count_syn <list of (match) match> <int max> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static void _count_syn(argrt_list_t *, int, int *, int *, int *, int *, int *);
/** :§ <text t>: -> int **/
static int _xc2a7__text(char *);
/** :_adj_syn <list of (match) match> <int add> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static void _adj_syn(argrt_list_t *, int, int *, int *, int *, int *, int *);
/** :_print_compil_ <call> <argile type type>: -> nothing **/
static void _print_compil_(argile_call_t *, argile_type_t);
/** :known call signature of <call> + <def> + <int off> + <int len>: -> bool **/
static unsigned char known_call_signature_of(argile_call_t *, argile_def_t *, int, int);
/** :make call signature of <call> + <def> + <int off> + <int len> in <buff>: -> nothing **/
static void make_call_signature_of_in(argile_call_t *, argile_def_t *, int, int, argile_buff_t *);
/** :bypass deps only <call>: -> bool **/
static unsigned char bypass_deps_only(argile_call_t *);
/** :fix param enum <list of (argile syntax) ls> <match m> <call c>: -> bool **/
static unsigned char fix_param_enum(argile_call_t * * p_argile_call_2, argrt_list_t *, argile_match_t *, argile_call_t *);
/** :<list of (list of (argile syntax)) le> is enum of param <argile syntax matched>: -> bool **/
static unsigned char is_enum_of_param(argrt_list_t *, argile_syntax_t *);
/** :check end line: -> nothing **/
static void check_end_line(unsigned char * need_indent);
/** :_get_union_fields <argile type ctx> <argile type type>: -> list of ((argile) field) **/
static argrt_list_t * _get_union_fields(argile_type_t, argile_type_t);
/** :_call_args <call>: -> nothing **/
static void _call_args(argile_call_t *);
/** :_comma <(bool) & first>: -> nothing **/
static void _comma(unsigned char *);
/** :_get_macro_body <argile code code> <def>: -> argile code **/
static argile_code_t * _get_macro_body(argile_code_t *, argile_def_t *);

static argrt_list_t raw_head = ((argrt_list_t){0});

/** :argile_call_new <def> <list of (match) match>: -> (argile) call **/
argile_call_t * argile_call_new(argile_def_t * p_argile_def, argrt_list_t * match)
{
  argile_call_t * call = ((argile_call_t *)0);

  call = ((argile_call_t *)memset(ARGRT_malloc(sizeof(argile_call_t)), 0, sizeof(argile_call_t)));
  (call)->type = ARGILE_CALL_EXPLICIT;
  (call)->def = p_argile_def;
  (call)->match = match;
  (call)->compiled = (((p_argile_def == ((argile_def_t *)0))) ? (0) : (1));
  return call;
}

/** :argile_call_del <call>: -> nothing **/
void argile_call_del(argile_call_t * p_argile_call_3)
{
  if ((p_argile_call_3 == ((argile_call_t *)0))) {
    return;
  }
  if (((p_argile_call_3)->del)) {
    (*(p_argile_call_3)->del)((p_argile_call_3)->data);
  }
  argrt_list_delete_all((p_argile_call_3)->pot_defs);
  argrt_list_delete_all((p_argile_call_3)->rejects);
  argrt_list_delete_all((p_argile_call_3)->match);
  argrt_list_delete_all((p_argile_call_3)->params);
  argrt_list_delete_all((p_argile_call_3)->options);
  argrt_list_delete_all((p_argile_call_3)->enums);
  argrt_list_delete_all((p_argile_call_3)->lists);
  if (((p_argile_call_3)->comment)) {
    ARGRT_free((p_argile_call_3)->comment);
  }
  if (((p_argile_call_3)->sigs)) {
    int s = 0;

    for (s = 0; ((s <= (256 - 1))); (s)++) {
      argrt_list_delete_all(((p_argile_call_3)->sigs)[s]);
    };
    ARGRT_free((p_argile_call_3)->sigs);
  }
  ARGRT_free(p_argile_call_3);
}

/** :argile_call_eq <call ca> <call cb> (<bool ignore_params> <bool ignore_oel>): -> int **/
int argile_call_eq(argile_call_t * ca, argile_call_t * cb, unsigned char ignore_params, unsigned char ignore_oel, ...)
{
  if ((ca == cb)) {
    return 1;
  }
  if (((ca == ((argile_call_t *)0)) || (cb == ((argile_call_t *)0)))) {
    return 0;
  }
  if ((((ca)->def == ((argile_def_t *)0)) && ((cb)->def == ((argile_def_t *)0)))) {
    if ((((ca)->match == ((argrt_list_t *)0)) || ((cb)->match == ((argrt_list_t *)0)))) {
      return 0;
    }
    return ((int)(argile_match_eq(*((argile_match_t * *)&((argrt_list_t *)(ca)->match)->data), *((argile_match_t * *)&((argrt_list_t *)(cb)->match)->data))));
  }
  if (((ca)->def != (cb)->def)) {
    if ((((ca)->def == ((argile_def_t *)0)) || ((cb)->def == ((argile_def_t *)0)))) {
      return 0;
    }
    if (((((ca)->def)->param) || (((cb)->def)->param))) {
      if ((((ca)->def)->param != ((cb)->def)->param)) {
        return 0;
      }
    }
    else {
      if ((((ca)->def)->dtype != ((cb)->def)->dtype)) {
        return 0;
      }
      if ((((ca)->def)->dtype != ARGILE_DEF_FUNC)) {
        return 0;
      }
      if (((((ca)->def)->dval).code != (((cb)->def)->dval).code)) {
        return 0;
      }
    }
  }
  if (!(ignore_params)) {
    if (((ca)->params != (cb)->params)) {
      argrt_list_t * la;
      argrt_list_t * lb;

      la = (ca)->params;
      lb = (cb)->params;
      while (((la) && (lb))) {
        argile_call_param_t * cpa = ((argile_call_param_t *)0);
        argile_call_param_t * cpb = ((argile_call_param_t *)0);
        argrt_list_t * lla;
        argrt_list_t * llb;

        cpa = *((argile_call_param_t * *)&((argrt_list_t *)la)->data);
        cpb = *((argile_call_param_t * *)&((argrt_list_t *)lb)->data);
        if (((cpa)->syn_param != (cpb)->syn_param)) {
          return 0;
        }
        lla = (cpa)->matches;
        llb = (cpb)->matches;
        while (((lla) && (llb))) {
          if (!((argile_match_eq(*((argile_match_t * *)&((argrt_list_t *)lla)->data), *((argile_match_t * *)&((argrt_list_t *)llb)->data))))) {
            return 0;
          }
          lla = ((argrt_list_t *)lla)->next;
          llb = ((argrt_list_t *)llb)->next;
        };
        if (((lla) || (llb))) {
          return 0;
        }
        la = ((argrt_list_t *)la)->next;
        lb = ((argrt_list_t *)lb)->next;
      };
      if (((la) || (lb))) {
        return 0;
      }
    }
  }
  if (!(ignore_oel)) {
    if (((ca)->options != (cb)->options)) {
      argrt_list_t * la;
      argrt_list_t * lb;

      la = (ca)->options;
      lb = (cb)->options;
      while (((la) && (lb))) {
        if ((*((argrt_list_t * *)&((argrt_list_t *)la)->data) != *((argrt_list_t * *)&((argrt_list_t *)lb)->data))) {
          argrt_list_t * lla;
          argrt_list_t * llb;

          lla = *((argrt_list_t * *)&((argrt_list_t *)la)->data);
          llb = *((argrt_list_t * *)&((argrt_list_t *)lb)->data);
          while (((lla) && (llb))) {
            if ((*((int *)&((argrt_list_t *)lla)->data._int) != *((int *)&((argrt_list_t *)llb)->data._int))) {
              return 0;
            }
            lla = ((argrt_list_t *)lla)->next;
            llb = ((argrt_list_t *)llb)->next;
          };
          if (((lla) || (llb))) {
            return 0;
          }
        }
        la = ((argrt_list_t *)la)->next;
        lb = ((argrt_list_t *)lb)->next;
      };
      if (((la) || (lb))) {
        return 0;
      }
    }
    if (((ca)->enums != (cb)->enums)) {
      argrt_list_t * la;
      argrt_list_t * lb;

      la = (ca)->enums;
      lb = (cb)->enums;
      while (((la) && (lb))) {
        if ((*((argrt_list_t * *)&((argrt_list_t *)la)->data) != *((argrt_list_t * *)&((argrt_list_t *)lb)->data))) {
          argrt_list_t * lla;
          argrt_list_t * llb;

          lla = *((argrt_list_t * *)&((argrt_list_t *)la)->data);
          llb = *((argrt_list_t * *)&((argrt_list_t *)lb)->data);
          while (((lla) && (llb))) {
            if ((*((int *)&((argrt_list_t *)lla)->data._int) != *((int *)&((argrt_list_t *)llb)->data._int))) {
              return 0;
            }
            lla = ((argrt_list_t *)lla)->next;
            llb = ((argrt_list_t *)llb)->next;
          };
          if (((lla) || (llb))) {
            return 0;
          }
        }
        la = ((argrt_list_t *)la)->next;
        lb = ((argrt_list_t *)lb)->next;
      };
      if (((la) || (lb))) {
        return 0;
      }
    }
    if (((ca)->lists != (cb)->lists)) {
      argrt_list_t * la;
      argrt_list_t * lb;

      la = (ca)->lists;
      lb = (cb)->lists;
      while (((la) && (lb))) {
        argile_call_list_t * cla = ((argile_call_list_t *)0);
        argile_call_list_t * clb = ((argile_call_list_t *)0);

        cla = *((argile_call_list_t * *)&((argrt_list_t *)la)->data);
        clb = *((argile_call_list_t * *)&((argrt_list_t *)lb)->data);
        if (((cla)->values != (clb)->values)) {
          argrt_list_t * lla;
          argrt_list_t * llb;

          lla = (cla)->values;
          llb = (clb)->values;
          while (((lla) && (llb))) {
            if ((*((int *)&((argrt_list_t *)lla)->data._int) != *((int *)&((argrt_list_t *)llb)->data._int))) {
              return 0;
            }
            lla = ((argrt_list_t *)lla)->next;
            llb = ((argrt_list_t *)llb)->next;
          };
          if (((lla) || (llb))) {
            return 0;
          }
        }
        la = ((argrt_list_t *)la)->next;
        lb = ((argrt_list_t *)lb)->next;
      };
      if (((la) || (lb))) {
        return 0;
      }
    }
  }
  return 1;
}

/** :argile_call_shadow <call>: -> (argile) call **/
argile_call_t * argile_call_shadow(argile_call_t * p_argile_call)
{
  argile_call_t * copy = ((argile_call_t *)0);
  argrt_list_t * tail;
  argrt_list_t * list;
  argrt_list_t * list_2;
  argrt_list_t * list_3;
  argrt_list_t * list_4;

  copy = argile_call_new((p_argile_call)->def, ((argrt_list_t *)0));
  (copy)->context = (p_argile_call)->context;
  (copy)->scope = (p_argile_call)->scope;
  *&(copy)->loc = *&(p_argile_call)->loc;
  (copy)->matched = (p_argile_call)->matched;
  (copy)->rejected = (p_argile_call)->rejected;
  (copy)->stealth = (p_argile_call)->stealth;
  (copy)->match = shadow_of_matches(&p_argile_call, (p_argile_call)->match, copy, (argile_type_t)ARGILE_TYPE_NOTHING);
  tail = ((argrt_list_t *)0);
  for (list = (p_argile_call)->params; (list); list = ((argrt_list_t *)list)->next) {
    argile_call_param_t * dst = ((argile_call_param_t *)0);
    argile_call_param_t * src = ((argile_call_param_t *)0);

    src = ((argile_call_param_t *)*((argile_call_param_t * *)&((argrt_list_t *)list)->data));
    dst = argile_call_param_new((src)->syn_param, shadow_of_matches(&p_argile_call, (src)->matches, copy, ((src)->syn_param)->type));
    (dst)->def = (src)->def;
    argrt_list_append(&tail, argrt_list_new(((void *)((long)dst)), (void *)&argile_call_param_del));
    if (((copy)->params == ((argrt_list_t *)0))) {
      (copy)->params = ((argrt_list_t *)tail);
    }
  };
  tail = ((argrt_list_t *)0);
  for (list_2 = (p_argile_call)->options; (list_2); list_2 = ((argrt_list_t *)list_2)->next) {
    argrt_list_append(&tail, argrt_list_new(((void *)((long)((argrt_list_t *)argrt_list_shadow(*((argrt_list_t * *)&((argrt_list_t *)list_2)->data))))), (void *)&argrt_list_delete_all));
    if (((copy)->options == ((argrt_list_t *)0))) {
      (copy)->options = ((argrt_list_t *)tail);
    }
  };
  tail = ((argrt_list_t *)0);
  for (list_3 = (p_argile_call)->enums; (list_3); list_3 = ((argrt_list_t *)list_3)->next) {
    argrt_list_append(&tail, argrt_list_new(((void *)((long)((argrt_list_t *)argrt_list_shadow(*((argrt_list_t * *)&((argrt_list_t *)list_3)->data))))), (void *)&argrt_list_delete_all));
    if (((copy)->enums == ((argrt_list_t *)0))) {
      (copy)->enums = ((argrt_list_t *)tail);
    }
  };
  tail = ((argrt_list_t *)0);
  for (list_4 = (p_argile_call)->lists; (list_4); list_4 = ((argrt_list_t *)list_4)->next) {
    argile_call_list_t * dst = ((argile_call_list_t *)0);
    argile_call_list_t * src = ((argile_call_list_t *)0);

    src = ((argile_call_list_t *)*((argile_call_list_t * *)&((argrt_list_t *)list_4)->data));
    dst = argile_call_list_new(argrt_list_shadow((src)->params), argrt_list_shadow((src)->options), argrt_list_shadow((src)->enums), argrt_list_shadow((src)->lists));
    (dst)->values = argrt_list_shadow((src)->values);
    argrt_list_append(&tail, argrt_list_new(((void *)((long)dst)), (void *)&argile_call_list_del));
    if (((copy)->lists == ((argrt_list_t *)0))) {
      (copy)->lists = ((argrt_list_t *)tail);
    }
  };
  return copy;
}

/** :argile_call_param_new <syn param synparam> <list of (match) matches>: -> (argile) call param **/
argile_call_param_t * argile_call_param_new(argile_syn_param_t * synparam, argrt_list_t * matches)
{
  argile_call_param_t * cp = ((argile_call_param_t *)0);

  cp = ((argile_call_param_t *)memset(ARGRT_malloc(sizeof(argile_call_param_t)), 0, sizeof(argile_call_param_t)));
  (cp)->syn_param = synparam;
  (cp)->matches = matches;
  return cp;
}

/** :argile_call_param_del <call param cp>: -> nothing **/
void argile_call_param_del(argile_call_param_t * cp)
{
  argrt_list_delete_all((cp)->matches);
  ARGRT_free(cp);
}

/** :argile_call_list_new <list of (int) params> <list of (int) options> <list of (int) enums> <list of (int) lists>: -> (argile) call list **/
argile_call_list_t * argile_call_list_new(argrt_list_t * params, argrt_list_t * options, argrt_list_t * enums, argrt_list_t * lists)
{
  argile_call_list_t * cl = ((argile_call_list_t *)0);

  cl = ((argile_call_list_t *)memset(ARGRT_malloc(sizeof(argile_call_list_t)), 0, sizeof(argile_call_list_t)));
  (cl)->params = params;
  (cl)->options = options;
  (cl)->enums = enums;
  (cl)->lists = lists;
  return cl;
}

/** :argile_call_list_del <call list cl>: -> nothing **/
void argile_call_list_del(argile_call_list_t * cl)
{
  argrt_list_delete_all((cl)->values);
  argrt_list_delete_all((cl)->params);
  argrt_list_delete_all((cl)->options);
  argrt_list_delete_all((cl)->enums);
  argrt_list_delete_all((cl)->lists);
  ARGRT_free(cl);
}

/** :argile_call_string <call> <int indent> <buff buf>: -> nothing **/
void argile_call_string(argile_call_t * p_argile_call_4, int indent, argile_buff_t * buf)
{
  argrt_list_t * m;

  if ((p_argile_call_4)->rejected) {
    argile_push_color(buf, "\x1b[1;33m");
  } else if ((p_argile_call_4)->compiled) {
    argile_push_color(buf, "\x1b[1;32m");
  }
  m = (p_argile_call_4)->match;
  for (; (m); m = ((argrt_list_t *)m)->next) {
    if ((*((argile_match_t * *)&((argrt_list_t *)m)->data) == ((argile_match_t *)0))) {
      continue;
    }
    if ((!((p_argile_call_4)->compiled) && !((p_argile_call_4)->rejected))) {
      argile_match_string(*((argile_match_t * *)&((argrt_list_t *)m)->data), indent, buf, 1);
    } else {
      argile_match_string(*((argile_match_t * *)&((argrt_list_t *)m)->data), indent, buf, 0);
    }
    if ((((argrt_list_t *)m)->next != ((argrt_list_t *)0))) {
      argile_buff_putc(buf, ' ');
    }
  };
  if (((p_argile_call_4)->compiled || (p_argile_call_4)->rejected)) {
    argile_pop_color(buf);
  }
}

/** :argile_call_find_all_path <call>: -> nothing **/
void argile_call_find_all_path(argile_call_t * p_argile_call_5)
{
  argrt_list_t * lm;

  lm = (p_argile_call_5)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      argile_call_find_all_path(((m)->value).call);
    }
  };
  if ((((((p_argile_call_5)->params == ((argrt_list_t *)0)) && ((p_argile_call_5)->options == ((argrt_list_t *)0))) && ((p_argile_call_5)->enums == ((argrt_list_t *)0))) && ((p_argile_call_5)->lists == ((argrt_list_t *)0)))) {
    argile_call_find_path(p_argile_call_5);
  }
}

/** :argile_call_find_path <call>: -> nothing **/
void argile_call_find_path(argile_call_t * p_argile_call_6)
{
  call_path_t path = {0};

  if (((p_argile_call_6)->def == ((argile_def_t *)0))) {
    return;
  }
  (path).call = p_argile_call_6;
  (path).match = (p_argile_call_6)->match;
  _match_path_rec(&path, ((p_argile_call_6)->def)->syntax, ((int*)0));
  (path).prm = 0;
  (path).opt = 0;
  (path).enm = 0;
  (path).lst = 0;
  _fix_path_rec(&path, ((p_argile_call_6)->def)->syntax);
  if (((((p_argile_call_6)->def)->dtype == ARGILE_DEF_FUNC) && ((((p_argile_call_6)->def)->dval).code))) {
    argrt_list_t * ld;

    ld = ((((p_argile_call_6)->def)->dval).code)->defs;
    for (; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if (((d)->param)) {
        argrt_list_t * cur;

        cur = (p_argile_call_6)->params;
        for (; (cur); cur = ((argrt_list_t *)cur)->next) {
          argile_call_param_t * p = ((argile_call_param_t *)0);

          p = *((argile_call_param_t * *)&((argrt_list_t *)cur)->data);
          if (((d)->param == (p)->syn_param)) {
            (p)->def = d;
            break;
          }
        };
      }
    };
  }
}

/** :argile_call_unfind_path <call>: -> nothing **/
void argile_call_unfind_path(argile_call_t * p_argile_call_7)
{
  {
    argrt_list_delete_all((p_argile_call_7)->params);
    (p_argile_call_7)->params = ((argrt_list_t *)0);
  };
  {
    argrt_list_delete_all((p_argile_call_7)->options);
    (p_argile_call_7)->options = ((argrt_list_t *)0);
  };
  {
    argrt_list_delete_all((p_argile_call_7)->enums);
    (p_argile_call_7)->enums = ((argrt_list_t *)0);
  };
  {
    argrt_list_delete_all((p_argile_call_7)->lists);
    (p_argile_call_7)->lists = ((argrt_list_t *)0);
  };
}

/** :argile_call_setup <call> <argile code code> <call owner>: -> nothing **/
void argile_call_setup(argile_call_t * p_argile_call_8, argile_code_t * code, argile_call_t * owner)
{
  argrt_list_t * cur;

  (p_argile_call_8)->scope = code;
  (p_argile_call_8)->owner = owner;
  for (cur = (p_argile_call_8)->match; (cur); cur = ((argrt_list_t *)cur)->next) {
    if ((*((argile_match_t * *)&((argrt_list_t *)cur)->data))) {
      argile_match_setup(*((argile_match_t * *)&((argrt_list_t *)cur)->data), p_argile_call_8);
    }
  };
}

/** :argile_call_compile_as <call> <argile type type>: -> int **/
int argile_call_compile_as(argile_call_t * p_argile_call_9, argile_type_t type)
{
  argrt_list_t * lm;
  int ret = 0;

  (p_argile_call_9)->hit = ++((argile).last_hit);
  (p_argile_call_9)->minmatch = ((short)0);
  (p_argile_call_9)->maxmatch = ((short)0);
  for (lm = (p_argile_call_9)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((argile_match_t * *)&((argrt_list_t *)lm)->data));
    if ((((m)->type == ARGILE_MATCH_WORD) || ((m)->type == ARGILE_MATCH_OP))) {
      unsigned int h = 0;
      argrt_list_t * ld;

      h = (argile_hash(((m)->value).word) % 4096);
      for (ld = ((argile).defs)[h]; (ld); ld = ((argrt_list_t *)ld)->next) {
        argile_def_t * d = ((argile_def_t *)0);

        d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ld)->data));
        if (((d)->hit < (p_argile_call_9)->hit)) {
          (d)->hit = (p_argile_call_9)->hit;
          (d)->hitcombo = ((unsigned short)1);
        }
        else {
          ((d)->hitcombo)++;
        }
        if (!((d)->implicit)) {
          ((d)->scope)->hit = (p_argile_call_9)->hit;
        }
        if (((p_argile_call_9)->minmatch > (d)->minmatch)) {
          (p_argile_call_9)->minmatch = (d)->minmatch;
        }
        if (((p_argile_call_9)->maxmatch >= 0)) {
          if ((((d)->maxmatch < 0) || ((p_argile_call_9)->maxmatch < (d)->maxmatch))) {
            (p_argile_call_9)->maxmatch = (d)->maxmatch;
          }
        }
      };
    }
  };
  if ((((p_argile_call_9)->match) && ((((argrt_list_t *)(p_argile_call_9)->match)->next) || ((*((argile_match_t * *)&((argrt_list_t *)(p_argile_call_9)->match)->data))->type == ARGILE_MATCH_SUBCALL)))) {
    argile_call_t * owner_2 = ((argile_call_t *)0);
    argrt_list_t * prev;
    argrt_list_t * next;
    argrt_list_t * ldef;
    argrt_list_t * first;
    argile_code_t * code_2 = ((argile_code_t *)0);

    argrt_list_delete_all((p_argile_call_9)->pot_defs);
    (p_argile_call_9)->pot_defs = ((argrt_list_t *)0);
    owner_2 = owner_most_of(p_argile_call_9);
    first = ((argrt_list_t *)0);
    code_2 = (p_argile_call_9)->scope;
    argile_code_getdef(code_2, p_argile_call_9, &prev, &next);
    while ((ldef = argile_code_nextdef(&code_2, &prev, &next))) {
      argile_def_t * def = ((argile_def_t *)0);

      if ((((code_2)->hit < (p_argile_call_9)->hit) && !((code_2)->has_weak_defs))) {
        prev = ((argrt_list_t *)0);
        next = ((argrt_list_t *)0);
        continue;
      }
      def = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
      if (((def)->locall && !(is_made_in(def, owner_2)))) {
        continue;
      }
      if ((def)->weak) {
        if (((p_argile_call_9)->minmatch > (def)->minmatch)) {
          (p_argile_call_9)->minmatch = (def)->minmatch;
        }
        if (((p_argile_call_9)->maxmatch >= 0)) {
          if ((((def)->maxmatch < 0) || ((p_argile_call_9)->maxmatch < (def)->maxmatch))) {
            (p_argile_call_9)->maxmatch = (def)->maxmatch;
          }
        }
      }
      else if ((((def)->hit < (p_argile_call_9)->hit) || ((def)->hitcombo < (def)->mincombo))) {
        continue;
      }
      argrt_list_append(&(p_argile_call_9)->pot_defs, argrt_list_new(((void *)((long)def)), ((argile_deleter_t)0)));
      if ((first == ((argrt_list_t *)0))) {
        first = (p_argile_call_9)->pot_defs;
      }
    };
    (p_argile_call_9)->pot_defs = first;
  }
  if ((((p_argile_call_9)->sigs == ((argrt_list_t *(*))0)) && (((int)argrt_list_count((p_argile_call_9)->match)) > 5))) {
    (p_argile_call_9)->sigs = ((argrt_list_t *(*))memset(ARGRT_malloc((256 * sizeof(argrt_list_t *))), 0, (256 * sizeof(argrt_list_t *))));
  }
  ret = ((_compile_as(p_argile_call_9, type)) ? (1) : (0));
  if (((p_argile_call_9)->sigs)) {
    int s = 0;

    for (s = 0; ((s <= (256 - 1))); (s)++) {
      argrt_list_delete_all(((p_argile_call_9)->sigs)[s]);
    };
    ARGRT_free((p_argile_call_9)->sigs);
    (p_argile_call_9)->sigs = ((argrt_list_t *(*))0);
  }
  return ret;
}

/** :_compile <call> as <argile type type>: -> bool **/
static unsigned char _compile_as(argile_call_t * p_argile_call_10, argile_type_t type_2)
{
  argile_call_t * owner_2 = ((argile_call_t *)0);
  argrt_list_t * prev;
  argrt_list_t * next;
  argrt_list_t * ldef;
  int max = 0;
  int maxwords = 0;
  int maxops = 0;
  int maxparams = 0;
  int maxchars = 0;
  int maxsum = 0;
  unsigned char pd_speedup;
  int len = 0;

  if ((argile).stats) {
    (((argile).stat).num_call_compile_as)++;
  }
  if ((p_argile_call_10)->compiled) {
    return 1;
  }
  if ((((argile).maxcomp > 0) && ((argile).maxcomp <= (argile).numcomp))) {
    return 0;
  }
  ((argile).numcomp)++;
  ((p_argile_call_10)->numcomp)++;
  if ((argile).debugcomp) {
    ((argile).indent)++;
  }
  (p_argile_call_10)->context = type_2;
  {
    argrt_list_t * lm;

    lm = (p_argile_call_10)->match;
    for (; (lm); lm = ((argrt_list_t *)lm)->next) {
      if ((*((argile_match_t * *)&((argrt_list_t *)lm)->data))) {
        (*((argile_match_t * *)&((argrt_list_t *)lm)->data))->processed = 1;
      }
    };
  };
  owner_2 = owner_most_of(p_argile_call_10);
  max = ((int)argrt_list_count((p_argile_call_10)->match));
  if ((max == 0)) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    code_2 = (p_argile_call_10)->scope;
    argile_code_getdef(code_2, p_argile_call_10, &prev, &next);
    while ((ldef = argile_code_nextdef(&code_2, &prev, &next))) {
      argile_def_t * def = ((argile_def_t *)0);
      argile_type_t calltype;

      def = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
      if ((((def)->syntax) || ((def)->locall && !(is_made_in(def, owner_2))))) {
        continue;
      }
      ((def)->numtry)++;
      ((def)->nummatch)++;
      (p_argile_call_10)->matched = 1;
      (p_argile_call_10)->compiled = 1;
      (p_argile_call_10)->def = def;
      calltype = argile_call_get_type(p_argile_call_10);
      if (((type_2 == (argile_type_t)ARGILE_TYPE_NOTHING) || (argile_type_match(type_2, calltype)))) {
        if (!((argile_call_reject(p_argile_call_10)))) {
          if ((argile).debugcomp) {
            ((argile).indent)--;
            _print_compil_(p_argile_call_10, type_2);
            printf("%s\n", " => OK");
          }
          return 1;
        }
        (p_argile_call_10)->rejected = 1;
      } else {
        argile_call_mismatch(p_argile_call_10, type_2, calltype, "empty subcall type mismatch: ");
      }
      (p_argile_call_10)->def = ((argile_def_t *)0);
      (p_argile_call_10)->compiled = 0;
    };
    (p_argile_call_10)->def = ((argile_def_t *)0);
    (p_argile_call_10)->compiled = 0;
    return 0;
  } else if ((max == 1)) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)(p_argile_call_10)->match)->data);
    if ((m)) {
      if ((((m)->type == ARGILE_MATCH_SUBCALL) && ((((m)->value).call)->match == ((argrt_list_t *)0)))) {
        argile_call_t * sub = ((argile_call_t *)0);
        unsigned char ret;

        sub = ((m)->value).call;
        ret = _compile_as(sub, type_2);
        (p_argile_call_10)->def = (sub)->def;
        (p_argile_call_10)->compiled = (sub)->compiled;
        return ret;
      } else if ((((m)->type == ARGILE_MATCH_CONS) && ((p_argile_call_10)->type == ARGILE_CALL_EXPLICIT))) {
        if (((type_2 != (argile_type_t)ARGILE_TYPE_NOTHING) && !((argile_cons_match_type(((m)->value).cons, type_2))))) {
          argile_call_mismatch(p_argile_call_10, type_2, (((m)->value).cons)->type, "literal type mismatch: ");
          if ((argile).debugcomp) {
            ((argile).indent)--;
          }
          return 0;
        }
        (p_argile_call_10)->compiled = 1;
        if ((argile).debugcomp) {
          ((argile).indent)--;
        }
        return 1;
      }
    }
  }
  _count_syn((p_argile_call_10)->match, max, &maxwords, &maxops, &maxparams, &maxchars, &maxsum);
  pd_speedup = (max > 1);
  for (len = max; ((len >= 1)); (len)--) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    if ((len < (p_argile_call_10)->minmatch)) {
      break;
    }
    if ((((p_argile_call_10)->maxmatch >= 0) && (len > (p_argile_call_10)->maxmatch))) {
      continue;
    }
    code_2 = (p_argile_call_10)->scope;
    if (pd_speedup) {
      ((argrt_list_t *)((argrt_list_t *)&raw_head))->next = (p_argile_call_10)->pot_defs;
      ldef = ((argrt_list_t *)&raw_head);
    }
    else {
      argile_code_getdef(code_2, p_argile_call_10, &prev, &next);
      ldef = ((argrt_list_t *)0);
    }
    while ((ldef = ((pd_speedup) ? (((argrt_list_t *)ldef)->next) : (argile_code_nextdef(&code_2, &prev, &next))))) {
      argile_def_t * def = ((argile_def_t *)0);
      int nwords = 0;
      int nops = 0;
      int nparams = 0;
      int nchars = 0;
      int chsum = 0;
      int off = 0;
      argrt_list_t * head;
      argrt_list_t * tail;

      def = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
      if (pd_speedup) {
        code_2 = (def)->scope;
        if (((len < (code_2)->minmatch) || (((code_2)->maxmatch >= 0) && (len > (code_2)->maxmatch)))) {
          continue;
        }
      } else {
        if (((len < (code_2)->minmatch) || (((code_2)->maxmatch >= 0) && (len > (code_2)->maxmatch)))) {
          prev = ((argrt_list_t *)0);
          next = ((argrt_list_t *)0);
          continue;
        }
        if ((((code_2)->hit < (p_argile_call_10)->hit) && !((code_2)->has_weak_defs))) {
          prev = ((argrt_list_t *)0);
          next = ((argrt_list_t *)0);
          continue;
        }
        if (((def)->locall && !(is_made_in(def, owner_2)))) {
          continue;
        }
        if ((((def)->hit < (p_argile_call_10)->hit) && !((def)->weak))) {
          continue;
        }
      }
      if (((len < (def)->minmatch) || (((def)->maxmatch >= 0) && (len > (def)->maxmatch)))) {
        continue;
      }
      if ((((maxparams < (code_2)->minparam) || (maxwords < (code_2)->minword)) || ((maxops < (code_2)->minop) || ((maxchars < (code_2)->minchar) || (maxsum < (code_2)->minchsum))))) {
        prev = ((argrt_list_t *)0);
        next = ((argrt_list_t *)0);
        continue;
      }
      _count_syn((p_argile_call_10)->match, len, &nwords, &nops, &nparams, &nchars, &chsum);
      head = (p_argile_call_10)->match;
      tail = argrt_list_seek(head, (len - 1));
      while ((tail)) {
        argile_match_t * m = ((argile_match_t *)0);

        m = *((argile_match_t * *)&((argrt_list_t *)head)->data);
        if ((m == ((argile_match_t *)0))) {
          goto cont;
        }
        if ((off != 0)) {
          _adj_syn(((argrt_list_t *)head)->prev, -1, &nwords, &nops, &nparams, &nchars, &chsum);
          _adj_syn(tail, 1, &nwords, &nops, &nparams, &nchars, &chsum);
        }
        if (((max > 1) && (len == 1))) {
          if ((((m)->type == ARGILE_MATCH_SUBCALL) || ((m)->type == ARGILE_MATCH_CONS))) {
            goto cont;
          }
        }
        if (((nwords < (def)->minword) || (((def)->maxword >= 0) && (nwords > (def)->maxword)))) {
          goto cont;
        }
        if (((nops < (def)->minop) || (((def)->maxop >= 0) && (nops > (def)->maxop)))) {
          goto cont;
        }
        if (((nparams < (def)->minparam) || (((def)->maxparam >= 0) && (nparams > (def)->maxparam)))) {
          goto cont;
        }
        if (((nchars < (def)->minchar) || (((def)->maxchar >= 0) && (nchars > (def)->maxchar)))) {
          goto cont;
        }
        if (((chsum < (def)->minchsum) || (((def)->maxchsum >= 0) && (chsum > (def)->maxchsum)))) {
          goto cont;
        }
        ((def)->numtry)++;
        if ((argile_match_try((def)->syntax, head, len, ((int *)0), 0))) {
          argile_call_t * sub = ((argile_call_t *)0);
          argrt_list_t * lm;

          ((def)->nummatch)++;
          if ((len == max)) {
            argile_type_t calltype;

            (p_argile_call_10)->matched = 1;
            (p_argile_call_10)->def = def;
            (p_argile_call_10)->compiled = 1;
            argile_call_find_path(p_argile_call_10);
            if ((argile_call_compile_subcalls(p_argile_call_10) == 0)) {
              (p_argile_call_10)->def = ((argile_def_t *)0);
              (p_argile_call_10)->compiled = 0;
              argile_call_unfind_path(p_argile_call_10);
              goto cont;
            }
            calltype = argile_call_get_type(p_argile_call_10);
            if (((type_2 == (argile_type_t)ARGILE_TYPE_NOTHING) || (argile_type_match(type_2, calltype)))) {
              int r = 0;

              r = argile_call_reject(p_argile_call_10);
              if ((r <= 0)) {
                if ((argile).debugcomp) {
                  ((argile).indent)--;
                  _print_compil_(p_argile_call_10, type_2);
                  if ((r < 0)) {
                    printf("%s\n", " => RETRY");
                  } else {
                    printf("%s\n", " => OK");
                  }
                }
                if ((r < 0)) {
                  argile_call_uncompile_subcalls(p_argile_call_10, 0);
                  (p_argile_call_10)->def = ((argile_def_t *)0);
                  (p_argile_call_10)->compiled = 0;
                  (p_argile_call_10)->rejected = 1;
                  return 0;
                }
                return 1;
              }
              (p_argile_call_10)->rejected = 1;
            } else {
              argile_call_mismatch(p_argile_call_10, type_2, calltype, "call type mismatch: ");
            }
            argile_call_uncompile_subcalls(p_argile_call_10, 0);
            (p_argile_call_10)->def = ((argile_def_t *)0);
            (p_argile_call_10)->compiled = 0;
            goto cont;
          }
          if (((p_argile_call_10)->sigs)) {
            if (known_call_signature_of(p_argile_call_10, def, off, len)) {
              goto cont;
            }
          }
          sub = argile_call_make_implicit(p_argile_call_10, def, head, tail);
          if ((((argile_call_compile_subcalls(sub) != 0) && !((argile_call_reject(sub)))) && _compile_as(p_argile_call_10, type_2))) {
            if ((argile).debugcomp) {
              ((argile).indent)--;
            }
            return 1;
          }
          lm = (p_argile_call_10)->match;
          for (; (lm); lm = ((argrt_list_t *)lm)->next) {
            if (((*((argile_match_t * *)&((argrt_list_t *)lm)->data)) && ((*((argile_match_t * *)&((argrt_list_t *)lm)->data))->value.data == sub))) {
              argile_call_undo_implicit(p_argile_call_10, sub, lm);
              break;
            }
          };
        }
        cont:;
        head = ((argrt_list_t *)head)->next;
        tail = ((argrt_list_t *)tail)->next;
        (off)++;
      };
    };
  };
  (p_argile_call_10)->def = ((argile_def_t *)0);
  (p_argile_call_10)->compiled = 0;
  if ((argile).debugcomp) {
    ((argile).indent)--;
    _print_compil_(p_argile_call_10, type_2);
    printf("%s\n", " => NO");
  }
  return 0;
}

/** :owner - most of <call>: -> (argile) call **/
static argile_call_t * owner_most_of(argile_call_t * p_argile_call_11)
{
  if ((p_argile_call_11 == ((argile_call_t *)0))) {
    return ((argile_call_t *)0);
  }
  while (!(((p_argile_call_11)->owner == ((argile_call_t *)0)))) {
    p_argile_call_11 = (p_argile_call_11)->owner;
  };
  return p_argile_call_11;
}

/** :<def> is made in <call>: -> bool **/
static unsigned char is_made_in(argile_def_t * p_argile_def_2, argile_call_t * p_argile_call_12)
{
  argile_code_t * scope = ((argile_code_t *)0);

  if (((p_argile_def_2)->maker == p_argile_call_12)) {
    return 1;
  }
  if (((p_argile_def_2)->param != ((argile_syn_param_t *)0))) {
    return 0;
  }
  scope = (p_argile_call_12)->scope;
  while ((scope != ((argile_code_t *)0))) {
    if ((((scope)->ghost == ((argile_code_t *)0)) && ((p_argile_def_2)->maker == (scope)->owner))) {
      return 1;
    }
    scope = (scope)->upper;
  };
  return 0;
}

/** :argile_call_compile_binds <call>: -> nothing **/
void argile_call_compile_binds(argile_call_t * p_argile_call_13)
{
  argrt_list_t * list;

  list = (p_argile_call_13)->match;
  for (; (list); list = ((argrt_list_t *)list)->next) {
    argile_match_t * match_2 = ((argile_match_t *)0);

    match_2 = *((argile_match_t * *)&((argrt_list_t *)list)->data);
    if ((match_2 == ((argile_match_t *)0))) {
      continue;
    }
    if (((match_2)->type == ARGILE_MATCH_SUBCALL)) {
      argile_call_compile_binds(((match_2)->value).call);
    }
  };
  if ((((p_argile_call_13)->def) && (((p_argile_call_13)->def)->dtype == ARGILE_DEF_BIND))) {
    argile_bind_t * bind = ((argile_bind_t *)0);

    bind = (((p_argile_call_13)->def)->dval).bind;
    if (!(((bind)->compile == ((void (*)(argile_call_t *))0)))) {
      (*(bind)->compile)(p_argile_call_13);
    }
  }
}

/** :argile_call_compile_subcalls <call>: -> int **/
int argile_call_compile_subcalls(argile_call_t * p_argile_call_2)
{
  unsigned char bypass;
  unsigned char need_refind_path;
  int order = 0;
  int order_max = 0;

  bypass = bypass_deps_only(p_argile_call_2);
  need_refind_path = 0;
  while ((order <= order_max)) {
    argrt_list_t * lm;

    lm = (p_argile_call_2)->match;
    for (; (lm); lm = ((argrt_list_t *)lm)->next) {
      argile_match_t * m = ((argile_match_t *)0);

      m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
      if ((m == ((argile_match_t *)0))) {
        continue;
      }
      if ((((m)->matched)->type == ARGILE_SYN_PARAM)) {
        argile_syn_param_t * sp = ((argile_syn_param_t *)0);

        sp = (((m)->matched)->value).syn_param;
        if (((sp)->order > order_max)) {
          order_max = (sp)->order;
        }
        if (((sp)->order != order)) {
          continue;
        }
        if ((((m)->type == ARGILE_MATCH_SUBCALL) && ((((m)->value).call)->type == ARGILE_CALL_EXPLICIT))) {
          argile_call_t * c = ((argile_call_t *)0);
          argile_type_t t;

          c = ((m)->value).call;
          t = argile_syn_param_eval_type(sp, p_argile_call_2);
          if (!((argile_call_compile_as(c, t)))) {
            if (!(bypass)) {
              if (fix_param_enum(&p_argile_call_2, ((p_argile_call_2)->def)->syntax, m, c)) {
                need_refind_path = 1;
              }
              else {
                argile_call_uncompile_subcalls(p_argile_call_2, 0);
                return 0;
              }
            }
          }
        }
        else if (!(bypass)) {
          argile_type_t pt;

          pt = argile_syn_param_eval_type(sp, p_argile_call_2);
          if (!((pt == (sp)->type))) {
            argile_type_t mt;

            mt = argile_match_get_type(m);
            if (!((argile_match_type(m, pt)))) {
              argile_call_mismatch(p_argile_call_2, pt, mt, "macro parameter type mismatch: ");
              argile_call_uncompile_subcalls(p_argile_call_2, 0);
              return 0;
            }
          }
        }
      }
    };
    (order)++;
  };
  if (need_refind_path) {
    argile_call_unfind_path(p_argile_call_2);
    argile_call_find_path(p_argile_call_2);
  }
  return 1;
}

/** :argile_call_uncompile_subcalls <call> <int undo_implicits>: -> nothing **/
void argile_call_uncompile_subcalls(argile_call_t * p_argile_call_14, int undo_implicits)
{
  argrt_list_t * lm;

  if (!((p_argile_call_14)->keep_data)) {
    if (!(((p_argile_call_14)->del == ((argile_deleter_t)0)))) {
      (*(p_argile_call_14)->del)((p_argile_call_14)->data);
    }
    (p_argile_call_14)->data = NULL;
    (p_argile_call_14)->del = ((argile_deleter_t)0);
  }
  argile_call_unfind_path(p_argile_call_14);
  lm = (p_argile_call_14)->match;
  while (!((lm == ((argrt_list_t *)0)))) {
    argrt_list_t * next;
    argile_match_t * m = ((argile_match_t *)0);

    next = ((argrt_list_t *)lm)->next;
    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_call_t * c = ((argile_call_t *)0);

      c = ((m)->value).call;
      switch ((c)->type) {
        case ARGILE_CALL_IMPLICIT: {
          if ((undo_implicits != 0)) {
            argile_call_uncompile_subcalls(c, 1);
            argile_call_undo_implicit(p_argile_call_14, c, lm);
          }
        } break;
        case ARGILE_CALL_EXPLICIT: {
          argile_call_uncompile_subcalls(c, 1);
          (c)->def = ((argile_def_t *)0);
          (c)->compiled = 0;
        } break;
        default: {} break;
      };
    }
    lm = next;
  };
}

/** :argile_call_compile_syntaxes <call>: -> int **/
int argile_call_compile_syntaxes(argile_call_t * p_argile_call_15)
{
  argrt_list_t * lm;

  lm = (p_argile_call_15)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      if ((argile_call_compile_syntaxes(((m)->value).call) == 0)) {
        return 0;
      }
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_SYNTAX))) {
      argrt_list_t * syn;

      syn = ((((m)->value).cons)->cvalue).syntax;
      if (!((argile_syntax_compile_params(syn, (p_argile_call_15)->scope, p_argile_call_15)))) {
        return 0;
      }
    }
  };
  return 1;
}

/** :argile_call_compile_subcodes <call>: -> int **/
int argile_call_compile_subcodes(argile_call_t * p_argile_call_16)
{
  argrt_list_t * lm;

  lm = (p_argile_call_16)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m == ((argile_match_t *)0))) {
      continue;
    }
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      if ((argile_call_compile_subcodes(((m)->value).call) != 0)) {
        return -1;
      }
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      if (((((m)->value).cons)->ctype == ARGILE_CONS_CODE)) {
        argile_code_t * c = ((argile_code_t *)0);

        c = ((((m)->value).cons)->cvalue).code;
        if ((argile_code_compile(c, (c)->type) != 0)) {
          return -1;
        }
      }
    }
  };
  return 0;
}

/** :argile_call_make_implicit <call> <def> <list of (match) head> <list of (match) tail>: -> (argile) call **/
argile_call_t * argile_call_make_implicit(argile_call_t * p_argile_call_17, argile_def_t * p_argile_def_3, argrt_list_t * head, argrt_list_t * tail)
{
  argile_call_t * sub = ((argile_call_t *)0);
  argrt_list_t * lm;

  sub = argile_call_new(p_argile_def_3, head);
  (sub)->type = ARGILE_CALL_IMPLICIT;
  *&(sub)->loc = *&(p_argile_call_17)->loc;
  lm = argrt_list_new(((void *)((long)argile_match_new(ARGILE_MATCH_SUBCALL, sub))), (void *)&argile_match_del);
  if ((head == (p_argile_call_17)->match)) {
    (p_argile_call_17)->match = lm;
  }
  argrt_list_link(((argrt_list_t *)head)->prev, lm);
  argrt_list_link(lm, ((argrt_list_t *)tail)->next);
  ((argrt_list_t *)head)->prev = ((argrt_list_t *)0);
  ((argrt_list_t *)tail)->next = ((argrt_list_t *)0);
  argile_call_setup(sub, (p_argile_call_17)->scope, p_argile_call_17);
  argile_call_find_path(sub);
  return sub;
}

/** :argile_call_undo_implicit <call> <call sub> <list of (match) matches>: -> nothing **/
void argile_call_undo_implicit(argile_call_t * p_argile_call_18, argile_call_t * sub, argrt_list_t * matches_2)
{
  (p_argile_call_18)->numcomp += (sub)->numcomp;
  argile_call_take_rejects(p_argile_call_18, sub);
  argile_call_uncompile_subcalls(sub, 0);
  argrt_list_link(((argrt_list_t *)matches_2)->prev, (sub)->match);
  argrt_list_link(argrt_list_end((sub)->match), ((argrt_list_t *)matches_2)->next);
  if ((((argrt_list_t *)matches_2)->prev == ((argrt_list_t *)0))) {
    (p_argile_call_18)->match = (sub)->match;
  }
  (sub)->match = ((argrt_list_t *)0);
  ((argrt_list_t *)matches_2)->prev = ((argrt_list_t *)0);
  ((argrt_list_t *)matches_2)->next = ((argrt_list_t *)0);
  argrt_list_delete_all(matches_2);
  argile_call_setup(p_argile_call_18, (p_argile_call_18)->scope, (p_argile_call_18)->owner);
}

/** :argile_call_get_type <call>: -> argile type **/
argile_type_t argile_call_get_type(argile_call_t * p_argile_call_19)
{
  if (!((p_argile_call_19)->compiled)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  }
  if (((p_argile_call_19)->def == ((argile_def_t *)0))) {
    return (((*((argile_match_t * *)&((argrt_list_t *)(p_argile_call_19)->match)->data))->value).cons)->type;
  }
  if ((((p_argile_call_19)->def)->dtype == ARGILE_DEF_BIND)) {
    argile_bind_t * b = ((argile_bind_t *)0);

    b = (((p_argile_call_19)->def)->dval).bind;
    if (((b)->gettype)) {
      return (*(b)->gettype)(p_argile_call_19);
    }
    if (((b)->type)) {
      return *(b)->type;
    }
  } else if ((((((p_argile_call_19)->def)->maker) && ((p_argile_call_19)->def)->vartype) && (((p_argile_call_19)->def)->dtype == ARGILE_DEF_FUNC))) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    code_2 = (((p_argile_call_19)->def)->dval).code;
    if (((code_2) && ((code_2)->macro || (code_2)->cmacro))) {
      argile_shovel_t * sh = ((argile_shovel_t *)0);
      argile_match_t * m = ((argile_match_t *)0);

      sh = argile_shovel_new(((p_argile_call_19)->def)->maker);
      m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
      argile_shovel_del(sh);
      if ((m)) {
        argile_type_t t;

        argile_code_push_macro_params(code_2, p_argile_call_19);
        t = argile_match_eval_type(m);
        argile_code_pop_macro_params(code_2);
        return t;
      }
    }
  }
  return ((p_argile_call_19)->def)->type;
}

/** :argile_call_reject <call>: -> int **/
int argile_call_reject(argile_call_t * p_argile_call_20)
{
  argile_bind_t * b = ((argile_bind_t *)0);

  if ((!(((p_argile_call_20)->def)) || (((p_argile_call_20)->def)->dtype != ARGILE_DEF_BIND))) {
    return 0;
  }
  b = (((p_argile_call_20)->def)->dval).bind;
  if (((b)->reject == ((int (*)(argile_call_t *))0))) {
    return 0;
  }
  return (*(b)->reject)(p_argile_call_20);
}

/** :argile_call_add_reject <call> <text reason>: -> int **/
int argile_call_add_reject(argile_call_t * p_argile_call_21, char * reason)
{
  argile_buff_t b = (argile_buff_t){0};

  (p_argile_call_21)->rejected = 1;
  if ((((argile).maxreject != 0) && ((p_argile_call_21)->nrejects >= (argile).maxreject))) {
    return 1;
  }
  argile_buff_puts(&b, reason);
  argile_buff_puts(&b, "\n  ");
  if (((p_argile_call_21)->owner != ((argile_call_t *)0))) {
    argile_buff_putc(&b, ("(")[0]);
  }
  argile_call_string(p_argile_call_21, 1, &b);
  if (((p_argile_call_21)->owner != ((argile_call_t *)0))) {
    argile_buff_putc(&b, (")")[0]);
  }
  argile_buff_puts(&b, "\n -> at \"");
  if ((((p_argile_call_21)->scope)->input)) {
    argile_buff_puts(&b, ((p_argile_call_21)->scope)->input);
  } else {
    argile_buff_puts(&b, "anonymous input");
  }
  argile_buff_puts(&b, "\", from line ");
  argile_buff_putn(&b, (((p_argile_call_21)->loc).start).row);
  argile_buff_puts(&b, " column ");
  argile_buff_putn(&b, (((p_argile_call_21)->loc).start).col);
  argile_buff_puts(&b, ", to line ");
  argile_buff_putn(&b, (((p_argile_call_21)->loc).end).row);
  argile_buff_puts(&b, " column ");
  argile_buff_putn(&b, (((p_argile_call_21)->loc).end).col);
  argile_buff_putc(&b, '\0');
  if ((argrt_list_search((p_argile_call_21)->rejects, (b).ptr, (void *)&argile_streq))) {
    ARGRT_free((b).ptr);
    return 1;
  }
  argrt_list_prepend(&(p_argile_call_21)->rejects, argrt_list_new(((void *)((long)(b).ptr)), &ARGRT_free));
  ((p_argile_call_21)->nrejects)++;
  ((argile).stat).rejsize += (b).len;
  ((argile).stat).rejmaxsize += (b).max;
  return 1;
}

/** :argile_call_take_rejects <call dst> <call src>: -> nothing **/
void argile_call_take_rejects(argile_call_t * dst, argile_call_t * src)
{
  argrt_list_t * lr;

  lr = argrt_list_pop(&(src)->rejects);
  while (((lr) && (((argile).maxreject == 0) || ((dst)->nrejects < (argile).maxreject)))) {
    if ((argrt_list_search((dst)->rejects, *((char * *)&((argrt_list_t *)lr)->data), (void *)&argile_streq))) {
      argrt_list_delete_all(lr);
    } else {
      argrt_list_prepend(&(dst)->rejects, lr);
      ((dst)->nrejects)++;
    }
    lr = argrt_list_pop(&(src)->rejects);
  };
  if ((lr)) {
    argrt_list_delete_all(lr);
  }
  if (((src)->rejects)) {
    argrt_list_delete_all((src)->rejects);
    (src)->rejects = ((argrt_list_t *)0);
  }
  (src)->nrejects = 0;
}

/** :argile_forget_rejects <call>: -> nothing **/
void argile_forget_rejects(argile_call_t * p_argile_call_22)
{
  argrt_list_t * lm;

  argrt_list_delete_all((p_argile_call_22)->rejects);
  (p_argile_call_22)->rejects = ((argrt_list_t *)0);
  (p_argile_call_22)->nrejects = 0;
  lm = (p_argile_call_22)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_forget_rejects(((m)->value).call);
    }
  };
}

/** :argile_call_mismatch <call> <argile type expected> <argile type got> <text error>: -> nothing **/
void argile_call_mismatch(argile_call_t * p_argile_call_23, argile_type_t expected, argile_type_t got, char * error)
{
  argile_buff_t b = ((argile_buff_t){0});
  char( tmp[32]);

  if ((error)) {
    argile_buff_puts(&b, error);
  }
  argile_buff_puts(&b, "got \"");
  argile_typename(got, &b, (p_argile_call_23)->scope);
  argile_buff_puts(&b, "\" (");
  snprintf(((char *)tmp), sizeof(tmp), "0x%x", got);
  argile_buff_puts(&b, ((char *)tmp));
  argile_buff_puts(&b, ") where \"");
  argile_typename(expected, &b, (p_argile_call_23)->scope);
  snprintf(((char *)tmp), sizeof(tmp), "0x%x", expected);
  argile_buff_puts(&b, "\" (");
  argile_buff_puts(&b, ((char *)tmp));
  argile_buff_puts(&b, ") was expected");
  argile_buff_putc(&b, '\0');
  argile_call_add_reject(p_argile_call_23, (b).ptr);
  ARGRT_free((b).ptr);
}

/** :argile_call_need_indent <call>: -> int **/
int argile_call_need_indent(argile_call_t * p_argile_call_24)
{
  if ((((p_argile_call_24)->owner == ((argile_call_t *)0)) && (!((((p_argile_call_24)->scope)->macro || ((p_argile_call_24)->scope)->cmacro)) || has_several_calls((p_argile_call_24)->scope)))) {
    return 1;
  }
  return 0;
}

/** :<argile code code> has several calls: -> bool **/
static unsigned char has_several_calls(argile_code_t * code_2)
{
  argrt_list_t * ld;

  if ((((code_2)->calls) && (((argrt_list_t *)(code_2)->calls)->next))) {
    return 1;
  }
  ld = (code_2)->defs;
  for (; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if (((!((d)->implicit) && !((d)->nodecl)) && !(((d)->param)))) {
      return 1;
    }
  };
  return 0;
}

/** :argile_call_need_return <call>: -> int **/
int argile_call_need_return(argile_call_t * p_argile_call_25)
{
  argrt_list_t * end;

  if ((((p_argile_call_25)->scope)->type == (argile_type_t)ARGILE_TYPE_NOTHING)) {
    return 0;
  }
  end = argrt_list_end(((p_argile_call_25)->scope)->calls);
  if (((end) && (*((argile_call_t * *)&((argrt_list_t *)end)->data) == p_argile_call_25))) {
    return 1;
  }
  return 0;
}

/** :argile_call_gencode <call> <int returned>: -> nothing **/
void argile_call_gencode(argile_call_t * p_argile_call_26, int returned)
{
  unsigned char need_indent;
  argrt_list_t * union_fields = ((argrt_list_t *)0);
  argrt_list_t * lf;

  if (((argile).error)) {
    return;
  }
  if ((((argile).maxgen > 0) && ((argile).numgen >= (argile).maxgen))) {
    argile_die_at(p_argile_call_26, "max. gencode recursions (%d) reached (macros).", (argile).maxgen);
    return;
  }
  ((argile).numgen)++;
  need_indent = ((returned == 0) && (argile_call_need_indent(p_argile_call_26)));
  if (((p_argile_call_26)->def == ((argile_def_t *)0))) {
    if ((((p_argile_call_26)->match) && (*((argile_match_t * *)&((argrt_list_t *)(p_argile_call_26)->match)->data)))) {
      argile_match_t * m = ((argile_match_t *)0);

      m = *((argile_match_t * *)&((argrt_list_t *)(p_argile_call_26)->match)->data);
      if (need_indent) {
        argile_indent();
      }
      if (((m)->type == ARGILE_MATCH_CONS)) {
        if (((returned == 2) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
          argile_code_gendata(((((m)->value).cons)->cvalue).code);
        }
        else if (((p_argile_call_26)->owner == ((argile_call_t *)0))) {
          argile_match_gencode(m);
        }
        else {
          argile_cons_gencode(((m)->value).cons);
        }
        check_end_line(&need_indent);
      }
    }
    ((argile).numgen)--;
    return;
  }
  if (!((argile_def_is_macro((p_argile_call_26)->def)))) {
    argile_type_t ct;
    argile_type_t dt;

    ct = (((int)(p_argile_call_26)->context) & ~((1 << 31)));
    dt = (((int)argile_call_get_type(p_argile_call_26)) & ~((1 << 31)));
    if ((ct != dt)) {
      argrt_list_t * lf_2;

      union_fields = _get_union_fields(ct, dt);
      lf_2 = argrt_list_end(union_fields);
      if (((lf_2) && (*((argile_field_t * *)&((argrt_list_t *)lf_2)->data)))) {
        argile_field_t * f = ((argile_field_t *)0);

        f = *((argile_field_t * *)&((argrt_list_t *)lf_2)->data);
        if ((((((int)(f)->type) >> 30) & 1))) {
          argile_ref(-1);
        }
        if ((((((int)(f)->type) >> 31) & 1))) {
          argile_ref(1);
        }
      }
    }
  }
  switch (((p_argile_call_26)->def)->dtype) {
    case ARGILE_DEF_VAR: {
      argile_var_t * var = ((argile_var_t *)0);

      var = (((p_argile_call_26)->def)->dval).var;
      if (need_indent) {
        argile_indent();
      }
      argile_call_gen_ref(p_argile_call_26);
      if (((var)->macro_params)) {
        argile_call_param_gencode(*((argile_call_param_t * *)&((argrt_list_t *)(var)->macro_params)->data), p_argile_call_26);
      }
      else {
        if ((((((p_argile_call_26)->def)->param) && (((p_argile_call_26)->def)->param)->in_list) && !((p_argile_call_26)->autoparam))) {
          argile_ref(1);
        }
        argile_puts(argile_def_gen_id((p_argile_call_26)->def));
      }
      check_end_line(&need_indent);
    } break;
    case ARGILE_DEF_TYPE: {
      if (need_indent) {
        argile_indent();
      }
      argile_type_gen_prefix((((p_argile_call_26)->def)->dval).type);
      argile_type_gen_suffix((((p_argile_call_26)->def)->dval).type);
      check_end_line(&need_indent);
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * code_3 = ((argile_code_t *)0);

      code_3 = (((p_argile_call_26)->def)->dval).code;
      if (((code_3) && (code_3)->macro)) {
        if (((code_3)->calls == ((argrt_list_t *)0))) {
          break;
        }
        if (!((code_3)->compiled)) {
          unsigned char old;

          old = (argile).main_only;
          (argile).main_only = 0;
          argile_code_compile(code_3, (code_3)->type);
          (argile).main_only = old;
        }
        if (has_several_calls(code_3)) {
          if (need_indent) {
            argile_indent();
          }
          if (((code_3)->type == (argile_type_t)ARGILE_TYPE_TYPE)) {
            argile_type_t t;

            t = argile_call_eval_type(p_argile_call_26);
            argile_type_gen_prefix(t);
            argile_type_gen_suffix(t);
          } else {
            unsigned char ret;

            ret = ((code_3)->type != (argile_type_t)ARGILE_TYPE_NOTHING);
            if (ret) {
              argile_puts("(");
            }
            argile_puts("{\n");
            ((argile).indent)++;
            argile_code_push_macro_params(code_3, p_argile_call_26);
            argile_code_gen_vars(code_3, 0);
            argile_code_gencode(code_3);
            argile_code_pop_macro_params(code_3);
            ((argile).indent)--;
            argile_indent();
            argile_puts("}");
            if (ret) {
              argile_puts(")");
            }
          }
          check_end_line(&need_indent);
        } else {
          if (need_indent) {
            argile_indent();
          }
          argile_code_push_macro_params(code_3, p_argile_call_26);
          argile_call_gen_ref(p_argile_call_26);
          argile_call_gencode(*((argile_call_t * *)&((argrt_list_t *)(code_3)->calls)->data), 1);
          argile_code_pop_macro_params(code_3);
          check_end_line(&need_indent);
        }
      } else {
        if (need_indent) {
          argile_indent();
        }
        argile_call_gen_ref(p_argile_call_26);
        argile_puts(argile_def_gen_id((p_argile_call_26)->def));
        if (!((((code_3) && (code_3)->cmacro) && !((code_3)->has_params)))) {
          argile_puts("(");
          _call_args(p_argile_call_26);
          argile_puts(")");
        }
        check_end_line(&need_indent);
      }
    } break;
    case ARGILE_DEF_BIND: {
      argile_bind_t * b = ((argile_bind_t *)0);

      b = (((p_argile_call_26)->def)->dval).bind;
      if (((b)->gencode)) {
        if (!(need_indent)) {
          (*(b)->gencode)(p_argile_call_26);
        } else {
          argile_buff_t buf_2 = ((argile_buff_t){0});

          argile_push_output((void *)&argile_output_buff, &buf_2);
          (*(b)->gencode)(p_argile_call_26);
          argile_pop_output();
          if (((buf_2).ptr)) {
            argile_indent();
            argile_output((buf_2).ptr, ((int)(buf_2).len));
            check_end_line(&need_indent);
            ARGRT_free((buf_2).ptr);
          }
        }
      }
    } break;
    default: {} break;
  };
  for (lf = union_fields; (lf); lf = ((argrt_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = ((argile_field_t *)*((argile_field_t * *)&((argrt_list_t *)lf)->data));
    argile_puts(".");
    argile_puts(argile_field_gen_id(f, "u_", ((p_argile_call_26)->def)->maker));
  };
  argrt_list_delete_all(union_fields);
  ((argile).numgen)--;
}

/** :argile_call_param_gencode <call param param> <call from>: -> nothing **/
void argile_call_param_gencode(argile_call_param_t * param, argile_call_t * from)
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);

  if ((param == ((argile_call_param_t *)0))) {
    return;
  }
  if ((from)) {
    argile_code_t * c = ((argile_code_t *)0);

    c = _get_macro_body((from)->scope, (param)->def);
    if ((c)) {
      sh = *((argile_shovel_t * *)&((argrt_list_t *)(c)->macro_shovels)->data);
    }
  }
  if ((sh)) {
    m = argile_shovel_digparamatch(sh, (param)->syn_param);
  } else if (((param)->matches)) {
    m = *((argile_match_t * *)&((argrt_list_t *)(param)->matches)->data);
  }
  if ((m)) {
    if ((((m)->type == ARGILE_MATCH_WORD) && !((((param)->def) && (((((param)->def)->dval).var)->macro_params))))) {
      argile_puts("\"");
      argile_match_gencode(m);
      argile_puts("\"");
    }
    else if ((((m)->type == ARGILE_MATCH_SUBCALL) && (((param)->syn_param)->tcall != ((argile_call_t *)0)))) {
      (((m)->value).call)->context = argile_call_eval_type(((param)->syn_param)->tcall);
      argile_match_gencode(m);
    }
    else {
      argile_match_gencode(m);
    }
  }
  else if ((((param)->syn_param)->init)) {
    argile_match_gencode(((param)->syn_param)->init);
  }
  else if ((((param)->syn_param)->tcall)) {
    argile_type_gen_zero(argile_call_eval_type(((param)->syn_param)->tcall));
  }
  else {
    argile_type_gen_zero(((param)->syn_param)->type);
  }
}

/** :argile_call_gen_ref <call>: -> nothing **/
void argile_call_gen_ref(argile_call_t * p_argile_call_27)
{
  unsigned char is_ref;
  unsigned char is_raw;
  unsigned char in_ref;
  unsigned char in_raw;

  in_ref = (((((int)(p_argile_call_27)->context) >> 31) & 1));
  in_raw = (((((int)(p_argile_call_27)->context) >> 30) & 1));
  if ((p_argile_call_27)->autoparam) {
    is_ref = !((((((int)((p_argile_call_27)->def)->type) >> 30) & 1)));
    is_raw = 0;
  } else if ((((p_argile_call_27)->def)->dtype == ARGILE_DEF_VAR)) {
    is_ref = ((((p_argile_call_27)->def)->param) && (((((int)(((p_argile_call_27)->def)->param)->type) >> 31) & 1)));
    is_raw = (((((int)((p_argile_call_27)->def)->type) >> 30) & 1));
  } else {
    argile_type_t t;

    t = argile_call_get_type(p_argile_call_27);
    is_ref = (((((int)t) >> 31) & 1));
    is_raw = (((((int)t) >> 30) & 1));
  }
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  }
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  }
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  }
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  }
}

/** :argile_call_gen_line <call>: -> nothing **/
void argile_call_gen_line(argile_call_t * p_argile_call_28)
{
  unsigned char implicit;

  if ((((argile).gen_lines == 0) || ((argile).outctx))) {
    return;
  }
  if ((argile).inside_cmacro) {
    return;
  }
  implicit = ((((argile).last_input_name) && (strcmp((argile).last_input_name, ((p_argile_call_28)->scope)->input) == 0)) && ((((p_argile_call_28)->loc).start).row == (argile).last_input_line));
  (argile).last_input_line = (((p_argile_call_28)->loc).start).row;
  (argile).last_input_name = ((p_argile_call_28)->scope)->input;
  if (implicit) {
    return;
  }
  ((argile).next_input_buff)->len = 0;
  if (((argile).gen_lines == 1)) {
    argile_buff_puts((argile).next_input_buff, "#line ");
    argile_buff_putn((argile).next_input_buff, (((p_argile_call_28)->loc).start).row);
    argile_buff_puts((argile).next_input_buff, " \"");
    argile_buff_puts((argile).next_input_buff, ((p_argile_call_28)->scope)->input);
    argile_buff_puts((argile).next_input_buff, "\"\n");
  } else if (((argile).gen_lines == 2)) {
    argile_buff_puts((argile).next_input_buff, "#line ");
    argile_buff_putn((argile).next_input_buff, (((p_argile_call_28)->loc).start).row);
    argile_buff_puts((argile).next_input_buff, " \"");
    argile_buff_puts((argile).next_input_buff, (argile).output_name);
    argile_buff_puts((argile).next_input_buff, ":");
    argile_buff_putn((argile).next_input_buff, ((argile).output_line + 1));
    argile_buff_puts((argile).next_input_buff, ": ");
    argile_buff_puts((argile).next_input_buff, ((p_argile_call_28)->scope)->input);
    argile_buff_puts((argile).next_input_buff, "\"\n");
  }
}

/** :argile_call_eval_type <call>: -> argile type **/
argile_type_t argile_call_eval_type(argile_call_t * p_argile_call_29)
{
  argile_def_t * d = ((argile_def_t *)0);

  d = (p_argile_call_29)->def;
  if ((d == ((argile_def_t *)0))) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  }
  switch ((d)->dtype) {
    case ARGILE_DEF_VAR: {
      if (((((d)->dval).var)->macro_params)) {
        argile_match_t * m = ((argile_match_t *)0);
        argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

        cp_2 = *((argile_call_param_t * *)&((argrt_list_t *)(((d)->dval).var)->macro_params)->data);
        if ((((cp_2) && ((cp_2)->matches)) && (*((argile_match_t * *)&((argrt_list_t *)(cp_2)->matches)->data)))) {
          m = argile_match_terminal(*((argile_match_t * *)&((argrt_list_t *)(cp_2)->matches)->data));
        } else {
          m = ((cp_2)->syn_param)->init;
        }
        if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
          return argile_call_eval_type(((m)->value).call);
        }
      }
      return (argile_type_t)ARGILE_TYPE_NOTHING;
    } break;
    case ARGILE_DEF_TYPE: {
      return ((d)->dval).type;
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * body = ((argile_code_t *)0);

      body = ((d)->dval).code;
      if ((((body) && (body)->macro) && ((body)->calls))) {
        argile_type_info_t * master = ((argile_type_info_t *)0);
        argrt_list_t * lt;
        int er = 0;
        argile_buff_t b = ((argile_buff_t){0});
        char * pre = "";
        char * suf = (char *)0;
        argile_call_t * gen = ((argile_call_t *)0);
        argile_type_t type_3;
        argile_type_info_t * info = ((argile_type_info_t *)0);

        lt = (body)->gtypes;
        for (; (lt); lt = ((argrt_list_t *)lt)->next) {
          argile_type_info_t * info_2 = ((argile_type_info_t *)0);

          info_2 = *((argile_type_info_t * *)&((argrt_list_t *)lt)->data);
          if ((((info_2)->ttype == ARGILE_TYPE_KIND_CTYPE) && (argile_call_eq(p_argile_call_29, (((info_2)->tval).t_ctype).generator, 0, 1)))) {
            if ((argile_call_eq(p_argile_call_29, (((info_2)->tval).t_ctype).generator, 1, 0))) {
              return (info_2)->type;
            }
            master = (((info_2)->tval).t_ctype).master;
            break;
          }
        };
        argile_code_reset_dupes((p_argile_call_29)->scope);
        er = argile_code_compile(body, (d)->type);
        argile_code_check_dupes((p_argile_call_29)->scope);
        if ((er != 0)) {
          break;
        }
        argile_push_output((void *)&argile_output_buff, &b);
        argile_code_push_macro_params(body, p_argile_call_29);
        memset(&b, 0, sizeof(argile_buff_t));
        argile_call_gencode(*((argile_call_t * *)&((argrt_list_t *)(body)->calls)->data), 1);
        argile_flush_refs();
        argile_buff_putc(&b, '\0');
        pre = (b).ptr;
        if ((((argrt_list_t *)(body)->calls)->next)) {
          memset(&b, 0, sizeof(argile_buff_t));
          argile_call_gencode(*((argile_call_t * *)&((argrt_list_t *)((argrt_list_t *)(body)->calls)->next)->data), 1);
          argile_flush_refs();
          argile_buff_putc(&b, '\0');
          suf = (b).ptr;
        }
        argile_code_pop_macro_params(body);
        argile_pop_output();
        gen = argile_call_shadow(p_argile_call_29);
        type_3 = argile_type_new();
        info = argile_type_set_info(type_3, ARGILE_TYPE_KIND_CTYPE);
        (((info)->tval).t_ctype).prefix = pre;
        (((info)->tval).t_ctype).suffix = suf;
        (((info)->tval).t_ctype).generator = gen;
        (((info)->tval).t_ctype).master = (((master == ((argile_type_info_t *)0))) ? (info) : (master));
        argrt_list_prepend(&(body)->gtypes, argrt_list_new(((void *)((long)info)), ((argile_deleter_t)0)));
        return type_3;
      }
    } break;
    case ARGILE_DEF_BIND: {
      argile_bind_t * b = ((argile_bind_t *)0);

      b = ((d)->dval).bind;
      if (((b)->evaltype)) {
        return (*(b)->evaltype)(p_argile_call_29);
      }
    } break;
    default: {} break;
  };
  return ARGILE_TYPE_NOTHING;
}

/** :argile_call_find_autoparams <call>: -> bool **/
unsigned char argile_call_find_autoparams(argile_call_t * p_argile_call_30)
{
  argile_def_t * d = ((argile_def_t *)0);
  unsigned char found;
  argrt_list_t * lm;

  d = (p_argile_call_30)->def;
  if ((d == ((argile_def_t *)0))) {
    return 0;
  }
  found = 0;
  switch ((d)->dtype) {
    case ARGILE_DEF_VAR: {
      if ((((d)->scope)->ghost == ((argile_code_t *)0))) {
        if (propagate_autoparam_from(d, p_argile_call_30)) {
          found = 1;
        }
      }
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * c = ((argile_code_t *)0);

      c = ((d)->dval).code;
      if (!((c == ((argile_code_t *)0)))) {
        argrt_list_t * ap;

        for (ap = (c)->autoparams; (ap); ap = ((argrt_list_t *)ap)->next) {
          if (propagate_autoparam_from(*((argile_def_t * *)&((argrt_list_t *)ap)->data), p_argile_call_30)) {
            found = 1;
          }
        };
      }
    } break;
    default: {} break;
  };
  lm = (p_argile_call_30)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    if (argile_match_find_autoparams(*((argile_match_t * *)&((argrt_list_t *)lm)->data))) {
      found = 1;
    }
  };
  return found;
}

/** :propagate autoparam <def> from <call>: -> bool **/
static unsigned char propagate_autoparam_from(argile_def_t * p_argile_def_4, argile_call_t * p_argile_call_31)
{
  argile_code_t * scope = ((argile_code_t *)0);
  unsigned char propagated;

  scope = (p_argile_call_31)->scope;
  if ((((p_argile_call_31)->def)->dtype == ARGILE_DEF_VAR)) {
    unsigned char local;

    local = 0;
    while (((scope) && (scope != (argile).main))) {
      if ((scope == (p_argile_def_4)->scope)) {
        local = 1;
        break;
      }
      scope = (scope)->upper;
    };
    if (!(local)) {
      return 0;
    }
  }
  propagated = 0;
  scope = (p_argile_call_31)->scope;
  while ((((scope) && (scope != (argile).main)) && (scope != (p_argile_def_4)->scope))) {
    if (((!(((scope)->ghost)) && ((scope)->func)) && !((scope)->macro))) {
      if (!((argrt_list_search((scope)->autoparams, p_argile_def_4, ((argile_comparer_t)0))))) {
        argrt_list_prepend(&(scope)->autoparams, argrt_list_new(((void *)((long)p_argile_def_4)), ((argile_deleter_t)0)));
        (p_argile_def_4)->autoable = 1;
        propagated = 1;
      }
      if ((((p_argile_call_31)->def)->dtype == ARGILE_DEF_VAR)) {
        (p_argile_call_31)->autoparam = 1;
      }
    }
    scope = (scope)->upper;
  };
  return propagated;
}

/** :shadow of matches <list of (match) matches> <call owner> <argile type type>: -> list of ((argile) match) **/
static argrt_list_t * shadow_of_matches(argile_call_t * * p_argile_call, argrt_list_t * matches_3, argile_call_t * owner_2, argile_type_t type_3)
{
  argrt_list_t * shadow;
  argrt_list_t * cur;

  if (((argile).error != (char *)0)) {
    return ((argrt_list_t *)0);
  }
  if ((((argile).maxgen > 0) && ((argile).numgen >= (argile).maxgen))) {
    argile_die_at(*p_argile_call, "max. gencode recursions (%d) reached (parametric type)", (argile).maxgen);
    return ((argrt_list_t *)0);
  }
  ((argile).numgen)++;
  shadow = argrt_list_shadow(matches_3);
  cur = shadow;
  for (; (cur); cur = ((argrt_list_t *)cur)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = argile_match_terminal(*((argile_match_t * *)&((argrt_list_t *)cur)->data));
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_def_t * d = ((argile_def_t *)0);

      d = (((m)->value).call)->def;
      m = argile_match_shadow(m);
      ((m)->value).call = argile_call_shadow(((m)->value).call);
      (((m)->value).call)->owner = owner_2;
      (m)->hollow = ((d) && ((d)->param));
      if (!((m)->evaled)) {
        if (((type_3 == (argile_type_t)ARGILE_TYPE_TYPE) || ((((m)->matched) && (((m)->matched)->type == ARGILE_SYN_PARAM)) && (((((m)->matched)->value).syn_param)->type == (argile_type_t)ARGILE_TYPE_TYPE)))) {
          (m)->etype = argile_match_eval_type(m);
          (m)->evaled = 1;
        }
      }
      *((argile_match_t * *)&((argrt_list_t *)cur)->data) = m;
      ((argrt_list_t *)cur)->del = (void (*)(void *))(void *)&argile_match_del;
    }
  };
  ((argile).numgen)--;
  return shadow;
}

/** :_match_path_rec <call_path path> <list of (argile syntax) syntax> <(int) * eaten>: -> bool **/
static unsigned char _match_path_rec(call_path_t * path_2, argrt_list_t * syntax, int* eaten)
{
  int _eaten = 0;

  if ((eaten)) {
    *eaten = 0;
  }
  while (((syntax) && ((path_2)->match))) {
    argile_syntax_t * s = ((argile_syntax_t *)0);
    argile_match_t * m = ((argile_match_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syntax)->data);
    m = *((argile_match_t * *)&((argrt_list_t *)(path_2)->match)->data);
    if ((m)) {
      switch ((s)->type) {
        case ARGILE_SYN_WORD: ;
        case ARGILE_SYN_OP: {
          if (((m)->matched != s)) {
            return _match_no_more(path_2, syntax);
          }
          if ((eaten)) {
            (*eaten)++;
          }
          (path_2)->match = ((argrt_list_t *)(path_2)->match)->next;
        } break;
        case ARGILE_SYN_PARAM: {
          if (((m)->matched != s)) {
            return _match_no_more(path_2, syntax);
          }
          if ((eaten)) {
            (*eaten)++;
          }
          (path_2)->match = ((argrt_list_t *)(path_2)->match)->next;
          ++((path_2)->prm);
          _add_param_value(path_2, ((s)->value).syn_param, m);
        } break;
        case ARGILE_SYN_OPTION: {
          argrt_list_t * val;

          val = _add_syn_val(&((path_2)->call)->options, ++((path_2)->opt));
          *((int *)&((argrt_list_t *)val)->data._int) = ((_match_path_rec(path_2, ((s)->value).syn_option, &_eaten)) ? (1) : (0));
          if (!((eaten == ((int*)0)))) {
            *eaten += _eaten;
          }
        } break;
        case ARGILE_SYN_ENUM: {
          int e = 1;
          int found = 0;
          argrt_list_t * val;
          argrt_list_t * enm;

          val = _add_syn_val(&((path_2)->call)->enums, ++((path_2)->enm));
          enm = ((s)->value).syn_enum;
          while (!((enm == ((argrt_list_t *)0)))) {
            if ((found != 0)) {
              _match_no_more(path_2, *((argrt_list_t * *)&((argrt_list_t *)enm)->data));
            } else if (_match_path_rec(path_2, *((argrt_list_t * *)&((argrt_list_t *)enm)->data), &_eaten)) {
              if ((eaten)) {
                *eaten += _eaten;
              }
              found = e;
            }
            (e)++;
            enm = ((argrt_list_t *)enm)->next;
          };
          if ((found == 0)) {
            return _match_no_more(path_2, ((argrt_list_t *)syntax)->next);
          }
          *((int *)&((argrt_list_t *)val)->data._int) = found;
        } break;
        case ARGILE_SYN_LIST: {
          int count = 0;
          int old_prm = 0;
          int old_opt = 0;
          int old_enm = 0;
          int old_lst = 0;
          argrt_list_t * clval;
          unsigned char fresh;
          argile_call_list_t * cl_2 = ((argile_call_list_t *)0);
          argrt_list_t * ival;

          old_prm = (path_2)->prm;
          old_opt = (path_2)->opt;
          old_enm = (path_2)->enm;
          old_lst = ++((path_2)->lst);
          fresh = 0;
          if (((path_2)->lst <= ((int)argrt_list_count(((path_2)->call)->lists)))) {
            clval = argrt_list_seek(((path_2)->call)->lists, ((path_2)->lst - 1));
          } else {
            clval = argrt_list_new(((void *)((long)argile_call_list_new(((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0)))), (void *)&argile_call_list_del);
            argrt_list_push_back(&((path_2)->call)->lists, clval);
            fresh = 1;
          }
          cl_2 = *((argile_call_list_t * *)&((argrt_list_t *)clval)->data);
          ival = argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0));
          argrt_list_push_back(&(cl_2)->values, ival);
          if (fresh) {
            _make_call_list(path_2, cl_2, (((s)->value).syn_list)->sub);
          }
          (path_2)->prm = old_prm;
          (path_2)->opt = old_opt;
          (path_2)->enm = old_enm;
          (path_2)->lst = old_lst;
          while ((_match_path_rec(path_2, (((s)->value).syn_list)->sub, &_eaten) && (_eaten != 0))) {
            (path_2)->prm = old_prm;
            (path_2)->opt = old_opt;
            (path_2)->enm = old_enm;
            (path_2)->lst = old_lst;
            (count)++;
            if ((eaten)) {
              *eaten += _eaten;
            }
          };
          if ((count < (((s)->value).syn_list)->min)) {
            if ((((argrt_list_t *)ival)->prev == ((argrt_list_t *)0))) {
              (cl_2)->values = ((argrt_list_t *)0);
            }
            argrt_list_unlink(((argrt_list_t *)ival)->prev, ival);
            argrt_list_delete_all(ival);
            return _match_no_more(path_2, ((argrt_list_t *)syntax)->next);
          }
          *((int *)&((argrt_list_t *)ival)->data._int) = count;
          _undo_call_list(path_2, cl_2);
        } break;
        default: {} break;
      };
    }
    syntax = ((argrt_list_t *)syntax)->next;
  };
  _match_no_more(path_2, syntax);
  return (argile_syntax_is_terminal(syntax));
}

/** :_fix_path_rec <call_path path> <list of (argile syntax) syntax>: -> nothing **/
static void _fix_path_rec(call_path_t * path_3, argrt_list_t * syntax_2)
{
  for (; (syntax_2); syntax_2 = ((argrt_list_t *)syntax_2)->next) {
    argile_syntax_t * syn = ((argile_syntax_t *)0);

    syn = *((argile_syntax_t * *)&((argrt_list_t *)syntax_2)->data);
    switch ((syn)->type) {
      case ARGILE_SYN_PARAM: {
        argrt_list_t * lx;

        ((path_3)->prm)++;
        lx = ((path_3)->call)->params;
        for (; (lx); lx = ((argrt_list_t *)lx)->next) {
          argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

          cp_2 = *((argile_call_param_t * *)&((argrt_list_t *)lx)->data);
          if (((cp_2)->syn_param == ((syn)->value).syn_param)) {
            break;
          }
        };
        if ((lx == ((argrt_list_t *)0))) {
          argrt_list_push_back(&((path_3)->call)->params, argrt_list_new(((void *)((long)argile_call_param_new(((syn)->value).syn_param, ((argrt_list_t *)0)))), (void *)&argile_call_param_del));
        }
      } break;
      case ARGILE_SYN_OPTION: {
        if ((++((path_3)->opt) > ((int)argrt_list_count(((path_3)->call)->options)))) {
          argrt_list_push_back(&((path_3)->call)->options, argrt_list_new(((void *)((long)argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0)))), (void *)&argrt_list_delete_all));
        }
        _fix_path_rec(path_3, ((syn)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * lx;

        if ((++((path_3)->enm) > ((int)argrt_list_count(((path_3)->call)->enums)))) {
          argrt_list_push_back(&((path_3)->call)->enums, argrt_list_new(((void *)((long)argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0)))), (void *)&argrt_list_delete_all));
        }
        lx = ((syn)->value).syn_enum;
        for (; (lx); lx = ((argrt_list_t *)lx)->next) {
          _fix_path_rec(path_3, *((argrt_list_t * *)&((argrt_list_t *)lx)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((++((path_3)->lst) > ((int)argrt_list_count(((path_3)->call)->lists)))) {
          int old_prm = 0;
          int old_opt = 0;
          int old_enm = 0;
          int old_lst = 0;
          argile_call_list_t * cl_2 = ((argile_call_list_t *)0);

          old_prm = (path_3)->prm;
          old_opt = (path_3)->opt;
          old_enm = (path_3)->enm;
          old_lst = (path_3)->lst;
          cl_2 = argile_call_list_new(((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0));
          argrt_list_push_back(&((path_3)->call)->lists, argrt_list_new(((void *)((long)cl_2)), (void *)&argile_call_list_del));
          (cl_2)->values = argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0));
          _make_call_list(path_3, cl_2, (((syn)->value).syn_list)->sub);
          (path_3)->prm = old_prm;
          (path_3)->opt = old_opt;
          (path_3)->enm = old_enm;
          (path_3)->lst = old_lst;
        }
        _fix_path_rec(path_3, (((syn)->value).syn_list)->sub);
      } break;
      default: {} break;
    };
  };
}

/** :_make_call_list <call_path path> <call list cl> <list of (argile syntax) syntax>: -> nothing **/
static void _make_call_list(call_path_t * path_4, argile_call_list_t * cl_2, argrt_list_t * syntax_3)
{
  for (; (syntax_3); syntax_3 = ((argrt_list_t *)syntax_3)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syntax_3)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        argrt_list_push_back(&(cl_2)->params, argrt_list_new(((void *)((long)((int)++((path_4)->prm)))), ((argile_deleter_t)0)));
      } break;
      case ARGILE_SYN_OPTION: {
        argrt_list_push_back(&(cl_2)->options, argrt_list_new(((void *)((long)((int)++((path_4)->opt)))), ((argile_deleter_t)0)));
        _make_call_list(path_4, cl_2, ((s)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * le;

        argrt_list_push_back(&(cl_2)->enums, argrt_list_new(((void *)((long)((int)++((path_4)->enm)))), ((argile_deleter_t)0)));
        le = ((s)->value).syn_enum;
        for (; (le); le = ((argrt_list_t *)le)->next) {
          _make_call_list(path_4, cl_2, *((argrt_list_t * *)&((argrt_list_t *)le)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        argrt_list_push_back(&(cl_2)->lists, argrt_list_new(((void *)((long)((int)++((path_4)->lst)))), ((argile_deleter_t)0)));
      } break;
      default: {} break;
    };
  };
}

/** :_undo_call_list <call_path path> <call list cl>: -> nothing **/
static void _undo_call_list(call_path_t * path_5, argile_call_list_t * cl_3)
{
  argrt_list_t * end;
  argrt_list_t * found;
  argrt_list_t * cur;
  argrt_list_t * cur_2;
  argrt_list_t * cur_3;
  argrt_list_t * cur_4;

  for (cur = (cl_3)->params; (cur); cur = ((argrt_list_t *)cur)->next) {
    found = argrt_list_seek(((path_5)->call)->params, (*((int *)&((argrt_list_t *)cur)->data._int) - 1));
    if ((found)) {
      argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

      cp_2 = ((argile_call_param_t *)*((void * *)&((argrt_list_t *)found)->data.any));
      end = argrt_list_end((cp_2)->matches);
      if ((end)) {
        if (!((((argrt_list_t *)end)->prev))) {
          (cp_2)->matches = ((argrt_list_t *)0);
        }
        argrt_list_unlink(((argrt_list_t *)end)->prev, end);
        argrt_list_delete_all(end);
      }
    }
  };
  for (cur_2 = (cl_3)->options; (cur_2); cur_2 = ((argrt_list_t *)cur_2)->next) {
    found = argrt_list_seek(((path_5)->call)->options, (*((int *)&((argrt_list_t *)cur_2)->data._int) - 1));
    if ((found)) {
      end = argrt_list_end(((argrt_list_t *)*((void * *)&((argrt_list_t *)found)->data.any)));
      if ((end)) {
        if (!((((argrt_list_t *)end)->prev))) {
          *((void * *)&((argrt_list_t *)found)->data.any) = NULL;
        }
        argrt_list_unlink(((argrt_list_t *)end)->prev, end);
        argrt_list_delete_all(end);
      }
    }
  };
  for (cur_3 = (cl_3)->enums; (cur_3); cur_3 = ((argrt_list_t *)cur_3)->next) {
    found = argrt_list_seek(((path_5)->call)->enums, (*((int *)&((argrt_list_t *)cur_3)->data._int) - 1));
    if ((found)) {
      end = argrt_list_end(((argrt_list_t *)*((void * *)&((argrt_list_t *)found)->data.any)));
      if ((end)) {
        if (!((((argrt_list_t *)end)->prev))) {
          *((void * *)&((argrt_list_t *)found)->data.any) = NULL;
        }
        argrt_list_unlink(((argrt_list_t *)end)->prev, end);
        argrt_list_delete_all(end);
      }
    }
  };
  for (cur_4 = (cl_3)->lists; (cur_4); cur_4 = ((argrt_list_t *)cur_4)->next) {
    found = argrt_list_seek(((path_5)->call)->lists, (*((int *)&((argrt_list_t *)cur_4)->data._int) - 1));
    if ((found)) {
      argile_call_list_t * sub_2 = ((argile_call_list_t *)0);

      sub_2 = ((argile_call_list_t *)*((void * *)&((argrt_list_t *)found)->data.any));
      end = argrt_list_end((sub_2)->values);
      if ((end)) {
        if (!((((argrt_list_t *)end)->prev))) {
          (sub_2)->values = ((argrt_list_t *)0);
        }
        argrt_list_unlink(((argrt_list_t *)end)->prev, end);
        argrt_list_delete_all(end);
      }
    }
  };
}

/** :_add_param_value <call_path path> <syn param syn_param> <match>: -> nothing **/
static void _add_param_value(call_path_t * path_6, argile_syn_param_t * syn_param, argile_match_t * p_argile_match)
{
  argrt_list_t * lp;

  lp = ((path_6)->call)->params;
  for (; (lp); lp = ((argrt_list_t *)lp)->next) {
    argile_call_param_t * p = ((argile_call_param_t *)0);

    p = *((argile_call_param_t * *)&((argrt_list_t *)lp)->data);
    if (((p)->syn_param == syn_param)) {
      argrt_list_push_back(&(p)->matches, argrt_list_new(((void *)((long)p_argile_match)), ((argile_deleter_t)0)));
      return;
    }
  };
  argrt_list_push_back(&((path_6)->call)->params, argrt_list_new(((void *)((long)argile_call_param_new(syn_param, argrt_list_new(((void *)((long)p_argile_match)), ((argile_deleter_t)0))))), (void *)&argile_call_param_del));
}

/** :_add_syn_val <(list of (list of (int))) & list> <int id>: -> list of (int) **/
static argrt_list_t * _add_syn_val(argrt_list_t * * list, int id)
{
  int count = 0;
  argrt_list_t * val;
  argrt_list_t * elem;
  argrt_list_t * loi;

  val = *list;
  for (; (val); val = ((argrt_list_t *)val)->next) {
    (count)++;
    if ((((argrt_list_t *)val)->next == ((argrt_list_t *)0))) {
      break;
    }
  };
  if ((id <= count)) {
    elem = argrt_list_seek(*list, (id - 1));
  } else {
    elem = argrt_list_new(((void *)((long)((argrt_list_t *)0))), (void *)&argrt_list_delete_all);
    if ((val)) {
      argrt_list_link(val, elem);
    } else {
      *list = elem;
    }
  }
  loi = argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0));
  argrt_list_push_back(((argrt_list_t * *)&((argrt_list_t *)elem)->data), loi);
  return loi;
}

/** :_match_no_more <call_path path> <list of (argile syntax) syn>: -> bool **/
static unsigned char _match_no_more(call_path_t * path_7, argrt_list_t * syn)
{
  for (; (syn); syn = ((argrt_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)syn)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        ++((path_7)->prm);
        _add_param_value(path_7, ((s)->value).syn_param, ((argile_match_t *)0));
      } break;
      case ARGILE_SYN_OPTION: {
        _add_syn_val(&((path_7)->call)->options, ++((path_7)->opt));
        _match_no_more(path_7, ((s)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * sub_2;

        _add_syn_val(&((path_7)->call)->enums, ++((path_7)->enm));
        sub_2 = ((s)->value).syn_enum;
        for (; (sub_2); sub_2 = ((argrt_list_t *)sub_2)->next) {
          _match_no_more(path_7, *((argrt_list_t * *)&((argrt_list_t *)sub_2)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        int old_prm = 0;
        int old_opt = 0;
        int old_enm = 0;
        int old_lst = 0;
        argrt_list_t * val;
        unsigned char fresh;
        argile_call_list_t * cl_4 = ((argile_call_list_t *)0);

        old_prm = (path_7)->prm;
        old_opt = (path_7)->opt;
        old_enm = (path_7)->enm;
        old_lst = ++((path_7)->lst);
        fresh = 0;
        if (((path_7)->lst <= ((int)argrt_list_count(((path_7)->call)->lists)))) {
          val = argrt_list_seek(((path_7)->call)->lists, ((path_7)->lst - 1));
        } else {
          val = argrt_list_new(((void *)((long)argile_call_list_new(((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0), ((argrt_list_t *)0)))), (void *)&argile_call_list_del);
          argrt_list_push_back(&((path_7)->call)->lists, val);
          fresh = 1;
        }
        cl_4 = *((argile_call_list_t * *)&((argrt_list_t *)val)->data);
        argrt_list_push_back(&(cl_4)->values, argrt_list_new(((void *)((long)0)), ((argile_deleter_t)0)));
        if (fresh) {
          _make_call_list(path_7, cl_4, (((s)->value).syn_list)->sub);
        }
        (path_7)->prm = old_prm;
        (path_7)->opt = old_opt;
        (path_7)->enm = old_enm;
        (path_7)->lst = old_lst;
      } break;
      default: {} break;
    };
  };
  return 0;
}

/** :_count_syn <list of (match) match> <int max> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static void _count_syn(argrt_list_t * match_2, int max_2, int * nw, int * no, int * np, int * nb, int * ns)
{
  *nw = 0;
  *no = 0;
  *np = 0;
  *nb = 0;
  *ns = 0;
  while (((match_2) && ((max_2)-- != 0))) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)match_2)->data);
    if ((m)) {
      switch ((m)->type) {
        case ARGILE_MATCH_WORD: {
          (*nw)++;
          *nb += strlen(((m)->value).word);
          *ns += _xc2a7__text(((m)->value).word);
        } break;
        case ARGILE_MATCH_OP: {
          (*no)++;
          *nb += strlen(((m)->value).op);
          *ns += _xc2a7__text(((m)->value).op);
        } break;
        case ARGILE_MATCH_CONS: ;
        case ARGILE_MATCH_SUBCALL: {
          (*np)++;
        } break;
        default: {} break;
      };
    }
    match_2 = ((argrt_list_t *)match_2)->next;
  };
}

/** :§ <text t>: -> int **/
static int _xc2a7__text(char * t)
{
  int s = 0;

  while (((t)[0] != 0)) {
    s += (((t)++)[0] & 0xff);
  };
  return s;
}

/** :_adj_syn <list of (match) match> <int add> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static void _adj_syn(argrt_list_t * match_3, int add, int * nw_2, int * no_2, int * np_2, int * nb_2, int * ns_2)
{
  argile_match_t * m = ((argile_match_t *)0);

  m = *((argile_match_t * *)&((argrt_list_t *)match_3)->data);
  if ((m == ((argile_match_t *)0))) {
    return;
  }
  switch ((m)->type) {
    case ARGILE_MATCH_WORD: {
      *nw_2 += add;
      *nb_2 += (add * strlen(((m)->value).word));
      *ns_2 += (add * _xc2a7__text(((m)->value).word));
    } break;
    case ARGILE_MATCH_OP: {
      *no_2 += add;
      *nb_2 += (add * strlen(((m)->value).op));
      *ns_2 += (add * _xc2a7__text(((m)->value).op));
    } break;
    case ARGILE_MATCH_CONS: ;
    case ARGILE_MATCH_SUBCALL: {
      *np_2 += add;
    } break;
    default: {} break;
  };
}

/** :_print_compil_ <call> <argile type type>: -> nothing **/
static void _print_compil_(argile_call_t * p_argile_call_32, argile_type_t type_4)
{
  argile_buff_t b = ((argile_buff_t){0});
  int i = 0;

  for (i = 1; ((i <= (argile).indent)); (i)++) {
    argile_buff_puts(&b, "  ");
  };
  argile_call_string(p_argile_call_32, (argile).indent, &b);
  argile_buff_puts(&b, " (: as ");
  argile_typename(type_4, &b, (p_argile_call_32)->scope);
  argile_buff_puts(&b, " :)");
  argile_buff_putc(&b, '\0');
  printf("%s", (b).ptr);
  ARGRT_free((b).ptr);
}

/** :known call signature of <call> + <def> + <int off> + <int len>: -> bool **/
static unsigned char known_call_signature_of(argile_call_t * p_argile_call_33, argile_def_t * p_argile_def_5, int off, int len_2)
{
  argile_buff_t * sigbuf = ((argile_buff_t *)0);
  char * signature = "";
  unsigned int s = 0;

  sigbuf = (argile).signbuffer;
  argile_buff_flush(sigbuf);
  make_call_signature_of_in(p_argile_call_33, p_argile_def_5, off, len_2, sigbuf);
  argile_buff_putc(sigbuf, '\0');
  signature = (sigbuf)->ptr;
  s = (argile_hash(signature) % 256);
  if ((argrt_list_search(((p_argile_call_33)->sigs)[s], signature, (void *)&argile_streq) == ((argrt_list_t *)0))) {
    signature = ((char *)ARGRT_malloc((sigbuf)->len));
    memcpy(signature, (sigbuf)->ptr, (sigbuf)->len);
    argrt_list_prepend(&((p_argile_call_33)->sigs)[s], argrt_list_new(((void *)((long)signature)), &ARGRT_free));
    return 0;
  }
  return 1;
}

/** :make call signature of <call> + <def> + <int off> + <int len> in <buff>: -> nothing **/
static void make_call_signature_of_in(argile_call_t * p_argile_call_34, argile_def_t * p_argile_def_6, int off_2, int len_3, argile_buff_t * p_argile_buff)
{
  int pos = 0;
  argrt_list_t * lm;

  lm = (p_argile_call_34)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    if (!((p_argile_def_6 == ((argile_def_t *)0)))) {
      if ((pos == off_2)) {
        argile_buff_printf(p_argile_buff, "(%p", p_argile_def_6);
      }
    }
    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      argile_buff_printf(p_argile_buff, "(%p", (((m)->value).call)->def);
      make_call_signature_of_in(((m)->value).call, ((argile_def_t *)0), 0, 0, p_argile_buff);
      argile_buff_puts(p_argile_buff, ")");
    }
    else {
      argile_buff_puts(p_argile_buff, ".");
    }
    (pos)++;
    if (!((p_argile_def_6 == ((argile_def_t *)0)))) {
      if ((pos == (off_2 + len_3))) {
        argile_buff_puts(p_argile_buff, ")");
      }
    }
  };
}

/** :bypass deps only <call>: -> bool **/
static unsigned char bypass_deps_only(argile_call_t * p_argile_call_35)
{
  argile_bind_t * bnd = ((argile_bind_t *)0);
  argile_module_t * std = ((argile_module_t *)0);

  if (!((argile).deps_only)) {
    return 0;
  }
  if ((((p_argile_call_35)->def)->dtype != ARGILE_DEF_BIND)) {
    return 0;
  }
  bnd = (((p_argile_call_35)->def)->dval).bind;
  if ((strcmp((bnd)->name, "use") != 0)) {
    return 0;
  }
  std = argile_getmod("std");
  if ((std == ((argile_module_t *)0))) {
    return 0;
  }
  bnd = argile_module_getbind(std, "use");
  if ((bnd == ((argile_bind_t *)0))) {
    return 0;
  }
  if ((bnd != (((p_argile_call_35)->def)->dval).bind)) {
    return 0;
  }
  return 1;
}

/** :fix param enum <list of (argile syntax) ls> <match m> <call c>: -> bool **/
static unsigned char fix_param_enum(argile_call_t * * p_argile_call_2, argrt_list_t * ls, argile_match_t * m, argile_call_t * c)
{
  for (; (ls); ls = ((argrt_list_t *)ls)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argrt_list_t *)ls)->data);
    switch ((s)->type) {
      case ARGILE_SYN_OPTION: {
        if (fix_param_enum(p_argile_call_2, ((s)->value).syn_option, m, c)) {
          return 1;
        }
      } break;
      case ARGILE_SYN_ENUM: {
        argrt_list_t * le;

        le = ((s)->value).syn_enum;
        if (is_enum_of_param(le, (m)->matched)) {
          for (; (le); le = ((argrt_list_t *)le)->next) {
            ls = *((argrt_list_t * *)&((argrt_list_t *)le)->data);
            if ((((argrt_list_t *)ls)->next == ((argrt_list_t *)0))) {
              s = *((argile_syntax_t * *)&((argrt_list_t *)ls)->data);
              if ((((s)->type == ARGILE_SYN_PARAM) && ((s != (m)->matched) && _compile_as(c, argile_syn_param_eval_type(((s)->value).syn_param, *p_argile_call_2))))) {
                (m)->matched = s;
                return 1;
              }
            }
          };
          return 0;
        } else {
          for (; (le); le = ((argrt_list_t *)le)->next) {
            if (fix_param_enum(p_argile_call_2, *((argrt_list_t * *)&((argrt_list_t *)le)->data), m, c)) {
              return 1;
            }
          };
        }
      } break;
      case ARGILE_SYN_LIST: {
        if (fix_param_enum(p_argile_call_2, (((s)->value).syn_list)->sub, m, c)) {
          return 1;
        }
      } break;
      default: {} break;
    };
  };
  return 0;
}

/** :<list of (list of (argile syntax)) le> is enum of param <argile syntax matched>: -> bool **/
static unsigned char is_enum_of_param(argrt_list_t * le_2, argile_syntax_t * matched)
{
  int count = 0;
  unsigned char found;

  found = 0;
  for (; (le_2); le_2 = ((argrt_list_t *)le_2)->next) {
    argrt_list_t * ls_2;

    ls_2 = *((argrt_list_t * *)&((argrt_list_t *)le_2)->data);
    if ((((argrt_list_t *)ls_2)->next == ((argrt_list_t *)0))) {
      argile_syntax_t * s_2 = ((argile_syntax_t *)0);

      s_2 = *((argile_syntax_t * *)&((argrt_list_t *)ls_2)->data);
      if (((s_2)->type == ARGILE_SYN_PARAM)) {
        (count)++;
        if ((s_2 == matched)) {
          found = 1;
        }
        if ((found && (count >= 2))) {
          return 1;
        }
      }
    }
  };
  return 0;
}

/** :check end line: -> nothing **/
static void check_end_line(unsigned char * need_indent)
{
  if (*need_indent) {
    if ((argile).no_semicolon) {
      (argile).no_semicolon = 0;
    }
    else {
      argile_puts(";");
    }
    if ((argile).inside_cmacro) {
      argile_puts(" \\\n");
    }
    else {
      argile_puts("\n");
    }
  }
}

/** :_get_union_fields <argile type ctx> <argile type type>: -> list of ((argile) field) **/
static argrt_list_t * _get_union_fields(argile_type_t ctx, argile_type_t type_5)
{
  argile_type_info_t * i = ((argile_type_info_t *)0);

  i = argile_type_get_info(type_5);
  if (((i) && ((i)->ttype == ARGILE_TYPE_KIND_UNION))) {
    argrt_list_t * lv;

    if ((i)->rec) {
      return ((argrt_list_t *)0);
    }
    if ((((i)->tval).t_union).silent) {
      return ((argrt_list_t *)0);
    }
    lv = (((i)->tval).t_union).variants;
    for (; (lv); lv = ((argrt_list_t *)lv)->next) {
      argile_field_t * f = ((argile_field_t *)0);
      argrt_list_t * lf_2;

      f = *((argile_field_t * *)&((argrt_list_t *)lv)->data);
      if ((ctx == (((int)(f)->type) & ((1 << 30) - 1)))) {
        return argrt_list_new(((void *)((long)f)), ((argile_deleter_t)0));
      }
      (i)->rec = 1;
      lf_2 = _get_union_fields(ctx, (f)->type);
      (i)->rec = 0;
      if ((lf_2)) {
        argrt_list_prepend(&lf_2, argrt_list_new(((void *)((long)f)), ((argile_deleter_t)0)));
        return lf_2;
      }
    };
  }
  return ((argrt_list_t *)0);
}

/** :_call_args <call>: -> nothing **/
static void _call_args(argile_call_t * p_argile_call_36)
{
  argile_code_t * code_4 = ((argile_code_t *)0);
  unsigned char first;
  argile_call_param_t * cvariadic = ((argile_call_param_t *)0);
  argrt_list_t * lp;

  code_4 = (((p_argile_call_36)->def)->dval).code;
  first = 1;
  if ((code_4)) {
    argrt_list_t * ld;

    for (ld = (code_4)->autoparams; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      int ref = 0;
      argile_code_t * scope = ((argile_code_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      _comma(&first);
      if ((((d)->param == ((argile_syn_param_t *)0)) || !((((((int)((d)->param)->type) >> 31) & 1))))) {
        (ref)--;
      }
      if ((((d)->param) && ((d)->param)->in_list)) {
        (ref)++;
      }
      scope = (p_argile_call_36)->scope;
      while ((scope)) {
        if (((scope == code_4) || (argrt_list_search((scope)->autoparams, d, ((argile_comparer_t)0))))) {
          ref = 0;
          break;
        }
        if (((d)->scope == scope)) {
          break;
        }
        scope = (scope)->upper;
      };
      argile_ref(ref);
      argile_puts(argile_def_gen_id(d));
    };
  }
  lp = (p_argile_call_36)->params;
  for (; (lp); lp = ((argrt_list_t *)lp)->next) {
    argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

    cp_2 = *((argile_call_param_t * *)&((argrt_list_t *)lp)->data);
    if (((cp_2)->syn_param)->pseudo) {
      cvariadic = cp_2;
      continue;
    }
    _comma(&first);
    if ((((code_4) && (code_4)->cmacro) || !(((cp_2)->syn_param)->in_list))) {
      argile_call_param_gencode(cp_2, ((argile_call_t *)0));
    }
    else {
      unsigned char sub_first;
      argile_type_t t_2;
      argrt_list_t * ly;

      sub_first = 1;
      t_2 = ((cp_2)->syn_param)->type;
      argile_puts("(");
      argile_type_gen_prefix(t_2);
      argile_puts("[]");
      argile_type_gen_suffix(t_2);
      argile_puts("){");
      ly = (cp_2)->matches;
      do {
        _comma(&sub_first);
        argile_call_param_gencode(cp_2, ((argile_call_t *)0));
        if (((cp_2)->matches)) {
          (cp_2)->matches = ((argrt_list_t *)(cp_2)->matches)->next;
        }
      } while (((cp_2)->matches));
      (cp_2)->matches = ly;
      argile_puts("}");
    }
  };
  if (((code_4) && (code_4)->cmacro)) {
    return;
  }
  if ((((code_4) && (code_4)->variadic) || ((code_4 == ((argile_code_t *)0)) && !(((p_argile_call_36)->def)->ext)))) {
    int id_2 = 1;
    argrt_list_t * lo;
    argrt_list_t * le;
    argrt_list_t * ll;

    lo = (p_argile_call_36)->options;
    for (; (lo); lo = ((argrt_list_t *)lo)->next) {
      unsigned char in_list;
      argrt_list_t * ly;

      in_list = 0;
      ly = (p_argile_call_36)->lists;
      for (; (ly); ly = ((argrt_list_t *)ly)->next) {
        if (((*((argile_call_list_t * *)&((argrt_list_t *)ly)->data)) && (argrt_list_search((*((argile_call_list_t * *)&((argrt_list_t *)ly)->data))->options, ((void *)((long)(long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        }
      };
      _comma(&first);
      if (!(in_list)) {
        argile_putn((((*((argrt_list_t * *)&((argrt_list_t *)lo)->data))) ? (*((int *)&((argrt_list_t *)*((argrt_list_t * *)&((argrt_list_t *)lo)->data))->data._int)) : (0)));
      } else if ((*((argrt_list_t * *)&((argrt_list_t *)lo)->data))) {
        unsigned char sub_first;
        argrt_list_t * ly_2;

        sub_first = 1;
        argile_puts("(char[]){");
        ly_2 = *((argrt_list_t * *)&((argrt_list_t *)lo)->data);
        for (; (ly_2); ly_2 = ((argrt_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argrt_list_t *)ly_2)->data._int));
        };
        argile_puts("}");
      } else {
        argile_puts("(char *)0");
      }
      (id_2)++;
    };
    id_2 = 1;
    le = (p_argile_call_36)->enums;
    for (; (le); le = ((argrt_list_t *)le)->next) {
      unsigned char in_list;
      argrt_list_t * ly;

      in_list = 0;
      ly = (p_argile_call_36)->lists;
      for (; (ly); ly = ((argrt_list_t *)ly)->next) {
        if (((*((argile_call_list_t * *)&((argrt_list_t *)ly)->data)) && (argrt_list_search((*((argile_call_list_t * *)&((argrt_list_t *)ly)->data))->enums, ((void *)((long)(long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        }
      };
      _comma(&first);
      if (!(in_list)) {
        argile_putn((((*((argrt_list_t * *)&((argrt_list_t *)le)->data))) ? (*((int *)&((argrt_list_t *)*((argrt_list_t * *)&((argrt_list_t *)le)->data))->data._int)) : (0)));
      } else if ((*((argrt_list_t * *)&((argrt_list_t *)le)->data))) {
        unsigned char sub_first;
        argrt_list_t * ly_2;

        sub_first = 1;
        argile_puts("(int[]){");
        ly_2 = *((argrt_list_t * *)&((argrt_list_t *)le)->data);
        for (; (ly_2); ly_2 = ((argrt_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argrt_list_t *)ly_2)->data._int));
        };
        argile_puts("}");
      } else {
        argile_puts("(int *)0");
      }
      (id_2)++;
    };
    id_2 = 1;
    ll = (p_argile_call_36)->lists;
    for (; (ll); ll = ((argrt_list_t *)ll)->next) {
      unsigned char in_list;
      argile_call_list_t * cl_4 = ((argile_call_list_t *)0);
      argrt_list_t * ly;

      in_list = 0;
      cl_4 = *((argile_call_list_t * *)&((argrt_list_t *)ll)->data);
      if (((cvariadic) && (((cl_4)->params) && !((((argrt_list_t *)(cl_4)->params)->next))))) {
        if (((!(((cl_4)->options)) && !(((cl_4)->enums))) && !(((cl_4)->lists)))) {
          argrt_list_t * lcp;

          lcp = argrt_list_seek((p_argile_call_36)->params, (*((int *)&((argrt_list_t *)(cl_4)->params)->data._int) - 1));
          if ((lcp)) {
            argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

            cp_2 = *((argile_call_param_t * *)&((argrt_list_t *)lcp)->data);
            if ((((cp_2) && ((cp_2)->syn_param)) && ((cp_2)->syn_param)->pseudo)) {
              continue;
            }
          }
        }
      }
      ly = (p_argile_call_36)->lists;
      for (; (ly); ly = ((argrt_list_t *)ly)->next) {
        if ((((ll != ly) && (*((argile_call_list_t * *)&((argrt_list_t *)ly)->data))) && (argrt_list_search((*((argile_call_list_t * *)&((argrt_list_t *)ly)->data))->lists, ((void *)((long)(long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        }
      };
      cl_4 = *((argile_call_list_t * *)&((argrt_list_t *)ll)->data);
      _comma(&first);
      if (!(in_list)) {
        argile_putn(((((cl_4) && ((cl_4)->values))) ? (*((int *)&((argrt_list_t *)(cl_4)->values)->data._int)) : (0)));
      } else if (((cl_4) && ((cl_4)->values))) {
        unsigned char sub_first;
        argrt_list_t * ly_2;

        sub_first = 1;
        argile_puts("(int[]){");
        ly_2 = (cl_4)->values;
        for (; (ly_2); ly_2 = ((argrt_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argrt_list_t *)ly_2)->data._int));
        };
        argile_puts("}");
      } else {
        argile_puts("(int *)0");
      }
      (id_2)++;
    };
  }
  if ((cvariadic)) {
    argile_call_param_t * cp_2 = ((argile_call_param_t *)0);
    argrt_list_t * ly;

    cp_2 = cvariadic;
    ly = (cp_2)->matches;
    for (; ((cp_2)->matches); (cp_2)->matches = ((argrt_list_t *)(cp_2)->matches)->next) {
      _comma(&first);
      argile_call_param_gencode(cp_2, ((argile_call_t *)0));
    };
    (cp_2)->matches = ly;
  }
}

/** :_comma <(bool) & first>: -> nothing **/
static void _comma(unsigned char * first_2)
{
  if (*first_2) {
    *first_2 = 0;
  } else {
    argile_puts(", ");
  }
}

/** :_get_macro_body <argile code code> <def>: -> argile code **/
static argile_code_t * _get_macro_body(argile_code_t * code_3, argile_def_t * p_argile_def_7)
{
  if ((p_argile_def_7 == ((argile_def_t *)0))) {
    return ((argile_code_t *)0);
  }
  while ((code_3)) {
    if ((((code_3)->macro_shovels) && ((p_argile_def_7)->scope == code_3))) {
      return code_3;
    }
    code_3 = (code_3)->upper;
  };
  return ((argile_code_t *)0);
}

