// generated by: arc -xuNP -A ./../argrt -M -o buff.c -H buff.h -m buff.argl.tmp buff.arg 
#include "buff.h"

/** :argile_buff_new <nat size>: -> (argile) buff **/
argile_buff_t * argile_buff_new(unsigned int size)
{
  argile_buff_t * buff = ((argile_buff_t *)0);

  buff = ((argile_buff_t *)memset(ARGRT_malloc(sizeof(argile_buff_t)), 0, sizeof(argile_buff_t)));
  if ((size < 32)) {
    size = 32;
  }
  (buff)->ptr = ((char *)ARGRT_malloc(size));
  (buff)->len = 0;
  (buff)->max = size;
  return buff;
}

/** :argile_buff_del <buff self>: -> nothing **/
void argile_buff_del(argile_buff_t * self)
{
  if (!(((self)->ptr == (char *)0))) {
    ARGRT_free((self)->ptr);
  }
  (self)->ptr = (char *)0;
  ARGRT_free(self);
}

/** :argile_buff_set <buff self> <text ptr> <nat len> <nat max>: -> nothing **/
void argile_buff_set(argile_buff_t * self_2, char * ptr, unsigned int len, unsigned int max)
{
  (self_2)->ptr = ptr;
  (self_2)->len = len;
  if ((len > max)) {
    (self_2)->max = len;
  } else {
    (self_2)->max = max;
  }
}

/** :argile_buff_cat <buff self> <buff append>: -> nothing **/
void argile_buff_cat(argile_buff_t * self_3, argile_buff_t * append)
{
  argile_buff_add(self_3, (append)->ptr, (append)->len);
}

/** :argile_buff_add <buff self> <text ptr> <nat len>: -> nothing **/
void argile_buff_add(argile_buff_t * self_4, char * ptr_2, unsigned int len_2)
{
  int inc = 0;

  inc = ((len_2 + (self_4)->len) - (self_4)->max);
  if ((inc > 0)) {
    argile_buff_grow(self_4, inc);
  }
  memcpy((((self_4)->ptr) + (self_4)->len), ptr_2, len_2);
  (self_4)->len += len_2;
}

/** :argile_buff_putc <buff self> <byte ch>: -> nothing **/
void argile_buff_putc(argile_buff_t * self_5, char ch)
{
  if (((self_5)->len >= (self_5)->max)) {
    argile_buff_grow(self_5, ((int)32));
  }
  ((self_5)->ptr)[(self_5)->len] = ch;
  argile_buff_seek(self_5, 1);
}

/** :argile_buff_puts <buff self> <text s>: -> nothing **/
void argile_buff_puts(argile_buff_t * self_6, char * s)
{
  while ((((s)[0] != 0) && ((self_6)->len < (self_6)->max))) {
    ((self_6)->ptr)[(self_6)->len] = ((s)++)[0];
    argile_buff_seek(self_6, 1);
  };
  argile_buff_add(self_6, s, ((unsigned int)strlen(s)));
}

/** :argile_buff_putn <buff self> <int num>: -> nothing **/
void argile_buff_putn(argile_buff_t * self_7, int num)
{
  char( str[32]);

  snprintf(((char *)str), sizeof(str), "%i", num);
  argile_buff_puts(self_7, ((char *)str));
}

/** :argile_buff_grow <buff self> <int grow>: -> nothing **/
void argile_buff_grow(argile_buff_t * self_8, int grow)
{
  unsigned int newsize = 0;
  unsigned int mod = 0;

  newsize = ((self_8)->max + grow);
  if ((newsize < 32)) {
    newsize = 32;
  }
  mod = (grow % 32);
  if ((mod != 0)) {
    newsize += (32 - mod);
  }
  (self_8)->ptr = ((char *)ARGRT_realloc((self_8)->ptr, newsize));
  (self_8)->max = newsize;
}

/** :argile_buff_seek <buff self> <int offset>: -> nothing **/
void argile_buff_seek(argile_buff_t * self_9, int offset)
{
  int newlen = 0;

  newlen = ((self_9)->len + offset);
  if ((newlen < 0)) {
    newlen = 0;
  }
  if ((newlen > (self_9)->max)) {
    (self_9)->len = (self_9)->max;
  } else {
    (self_9)->len = ((unsigned int)newlen);
  }
}

/** :argile_buff_find <buff self> <byte>: -> int **/
int argile_buff_find(argile_buff_t * self_10, char p_byte)
{
  int pos = 0;

  for (pos = 0; (pos < (self_10)->len); (pos)++) {
    if ((((self_10)->ptr)[pos] == p_byte)) {
      return pos;
    }
  };
  return -1;
}

/** :argile_buff_count <buff self> <byte ch>: -> int **/
int argile_buff_count(argile_buff_t * self_11, char ch_2)
{
  int pos = 0;
  int count = 0;

  while ((pos < (self_11)->len)) {
    if ((((self_11)->ptr)[(pos)++] == ch_2)) {
      (count)++;
    }
  };
  return count;
}

/** :argile_buff_shift <buff self> <int from> <int to> <int len>: -> nothing **/
void argile_buff_shift(argile_buff_t * self_12, int from, int to, int len_3)
{
  int i = 0;

  if ((len_3 < 0)) {
    from += len_3;
    to += len_3;
    len_3 = (-len_3);
  }
  if ((from < 0)) {
    from = 0;
  }
  if ((to < 0)) {
    to = 0;
  }
  if ((from >= (self_12)->len)) {
    from = ((self_12)->len - 1);
  }
  if ((to >= (self_12)->len)) {
    to = ((self_12)->len - 1);
  }
  if (((from + len_3) > (self_12)->len)) {
    len_3 = ((self_12)->len - from);
  }
  if (((to + len_3) > (self_12)->len)) {
    len_3 = ((self_12)->len - to);
  }
  while ((((i < len_3) && (from < (self_12)->max)) && (to < (self_12)->max))) {
    ((self_12)->ptr)[to] = ((self_12)->ptr)[from];
    (to)++;
    (from)++;
    (i)++;
  };
}

/** :argile_buff_flush <buff self>: -> nothing **/
void argile_buff_flush(argile_buff_t * self_13)
{
  (self_13)->len = 0;
}

/** :argile_buff_cmp <buff a> <buff b>: -> int **/
int argile_buff_cmp(argile_buff_t * a, argile_buff_t * b)
{
  int p = 0;

  while (((p < (a)->len) && (p < (b)->len))) {
    int diff = 0;

    diff = ((((a)->ptr)[p] & 0xff) - (((b)->ptr)[p] & 0xff));
    if ((diff != 0)) {
      return diff;
    }
    (p)++;
  };
  return ((((a)->ptr)[p] & 0xff) - (((b)->ptr)[p] & 0xff));
}

/** :argile_buff_escape <buff self> <text toescape> <byte esc>: -> nothing **/
void argile_buff_escape(argile_buff_t * self_14, char * toescape, char esc)
{
  char( toesc[32]);
  int i = 0;
  char ch_3;
  int count = 0;
  int inc = 0;

  memset(toesc, 0, sizeof(toesc));
  for (i = 0; ((ch_3 = (toescape)[i])); (i)++) {
    ch_3 &= 0xff;
    (((char *)toesc))[(ch_3 >> 3)] |= (1 << (ch_3 & 7));
  };
  for (i = 0; (i < (self_14)->len); (i)++) {
    ch_3 = (((self_14)->ptr)[i] & 0xff);
    if (((((((char *)toesc))[(ch_3 >> 3)] >> (ch_3 & 7)) & 1) != 0)) {
      (count)++;
    }
  };
  inc = ((count + (self_14)->len) - (self_14)->max);
  if ((inc > 0)) {
    argile_buff_grow(self_14, inc);
  }
  for (i = 0; (i < (self_14)->len); (i)++) {
    ch_3 = (((self_14)->ptr)[i] & 0xff);
    if (((((((char *)toesc))[(ch_3 >> 3)] >> (ch_3 & 7)) & 1) != 0)) {
      int j = 0;

      for (j = ((self_14)->len - 1); (j >= i); (j)--) {
        ((self_14)->ptr)[(j + 1)] = ((self_14)->ptr)[j];
      };
      ((self_14)->len)++;
      ((self_14)->ptr)[(i)++] = esc;
    }
  };
}

/** :argile_buff_printf <buff self> <text fmt> [...]: -> nothing **/
void argile_buff_printf(argile_buff_t * self_15, char * fmt, ...)
{
  va_list va;
  int max_2 = 0;

  va_start(va, fmt);
  max_2 = vsnprintf((char *)0, 0, fmt, va);
  va_end(va);
  if (((max_2)++ > 0)) {
    int inc = 0;
    int len_4 = 0;

    inc = ((max_2 + (self_15)->len) - (self_15)->max);
    if ((inc > 0)) {
      argile_buff_grow(self_15, inc);
    }
    va_start(va, fmt);
    len_4 = vsnprintf((((self_15)->ptr) + (self_15)->len), max_2, fmt, va);
    va_end(va);
    if ((len_4 < max_2)) {
      (self_15)->len += len_4;
    }
    else {
      (self_15)->len += (max_2 - 1);
    }
  }
}

