// generated by: arc -xuNP -A ./../argrt -M -o argilectx.c -H argilectx.h -m argilectx.argl.tmp argilectx.arg 
#include "argile.h" //;
#include <compiler/parser.h> //;

#include "argilectx.h"

/** :attribute comments to calls: -> nothing **/
static void attribute_comments_to_calls();
/** :print line <text dst> <int len>: -> nothing **/
static void print_line(char *, int);
/** :<text str> ends by <int n> <text end>: -> int **/
static int ends_by(char *, int, char *);
/** :try new file <text path>: -> (argile) file **/
static argile_file_t * try_new_file(char *);
/** :convert <text colour> to daltonism: -> text **/
static char * convert_to_daltonism(char *);
/** :<argile code c> is not included: -> bool **/
static unsigned char is_not_included(argile_code_t *);
/** :<pos a> > <pos b>: -> bool **/
static unsigned char argile_pos_superior_argile_pos(argile_pos_t *, argile_pos_t *);
/** :<comment c>: -> nothing **/
static void comment(comment_t *);
/** :print define: -> nothing **/
static void print_define(argile_file_t * * file, int * size, char * * name);
/** :get word size of <text t>: -> int **/
static int get_word_size_of(char *);
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
static void write_ref_or_raw_in_with(argile_buff_t *, argile_buff_t *, argile_def_t *, char *);
/** :add include <text p>: -> nothing **/
static void add_include(char *);
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
static argile_file_t * try_in_dir(char *, int, char *, int);
/** :strip useless slashes in <text s>: -> nothing **/
static void strip_useless_slashes_in(char *);
/** :<text str> doesn ' t end by ext: -> bool **/
static unsigned char doesn_t_end_by_ext(char *);
/** :cached - stat <text p> <stat st>: -> int **/
static int cached_stat(char *, struct stat *);
/** :reduce <text d> <text s>: -> nothing **/
static void reduce(char *, char *);
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
static int id_end_num(char *, unsigned int, int *);
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void check_id_num(argile_buff_t *, char *, unsigned char *, int *, int *);
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void check_call_id_num(argile_call_t *, argile_buff_t *, unsigned char *, int *, int *);
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
static void search_in_with(argrt_list_t *, argile_code_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
static void search_in_with_2(argrt_list_t *, argile_call_t *, void (*)(argile_def_t *));
/** :split op <text str> <int len> <int optoken>: -> nothing **/
static void split_op(char *, int, int);
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/
static argrt_list_t * new_range(unsigned int, unsigned int);

argile_t argile = ((argile_t){0});
char * argile_default_operators = "\n# UNICODE extra operators\n00A1 00BF  # Latin-1 various operators\n00D7       # Latin-1 X multiplication sign\n00F7       # Latin-1 division sign\n2010 206F  # General Punctuation\n2070 209F  # Superscipts and Subscripts\n20A0 20CF  # Currency Symbols\n2190 21FF  # Arrows\n2200 22FF  # Mathematical Operators\n2300 23FF  # Miscellaneous Technical\n27C0 27EF  # Miscellaneous Mathematical Symbols-A\n27F0 27FF  # Supplemental Arrows-A\n2900 297F  # Supplemental Arrows-B\n2980 29FF  # Miscellaneous Mathematical Symbols-B\n2A00 2AFF  # Supplemental Mathematical Operators \n2E00 2E7F  # Supplemental Punctuation\n3000 303F  # CJK Symbols and Punctuation\n";

/** :argile_init: -> int **/
int argile_init()
{
  memset(&argile, 0, sizeof(argile_t));
  (argile).colpertab = 8;
  (argile).maxmatch = 500;
  (argile).maxcomp = 1000;
  (argile).maxgen = 500;
  (argile).maxreject = 5;
  (argile).next_type = ((int)ARGILE_NEXT_TYPE);
  ((argile).enc_utf8).charsize = (void *)&argile_utf8_charsize;
  ((argile).enc_utf8).charat = (void *)&argile_utf8_charat;
  (argile).output = (void *)&argile_output_file;
  (argile).output_data = stdout;
  (argile).output_name = "standard output";
  (argile).output_line = 1;
  (argile).last_input_line = 1;
  (argile).next_input_buff = argile_buff_new(512);
  (argile).get_comments = 1;
  (argile).signbuffer = argile_buff_new(512);
  argile_add_keyword("auto");
  argile_add_keyword("break");
  argile_add_keyword("case");
  argile_add_keyword("char");
  argile_add_keyword("const");
  argile_add_keyword("continue");
  argile_add_keyword("default");
  argile_add_keyword("do");
  argile_add_keyword("double");
  argile_add_keyword("else");
  argile_add_keyword("enum");
  argile_add_keyword("extern");
  argile_add_keyword("float");
  argile_add_keyword("for");
  argile_add_keyword("goto");
  argile_add_keyword("if");
  argile_add_keyword("int");
  argile_add_keyword("long");
  argile_add_keyword("register");
  argile_add_keyword("return");
  argile_add_keyword("short");
  argile_add_keyword("signed");
  argile_add_keyword("sizeof");
  argile_add_keyword("static");
  argile_add_keyword("struct");
  argile_add_keyword("switch");
  argile_add_keyword("typedef");
  argile_add_keyword("union");
  argile_add_keyword("unsigned");
  argile_add_keyword("void");
  argile_add_keyword("volatile");
  argile_add_keyword("while");
  argile_add_reserved("anon_arg");
  argile_add_reserved("anon_va");
  return 0;
}

/** :argile_uninit: -> nothing **/
void argile_uninit()
{
  int i_2 = 0;

  argile_choke_leaks();
  if (((argile).error != (char *)0)) {
    ARGRT_free((argile).error);
  }
  for (i_2 = 0; (i_2 < 512); (i_2)++) {
    argrt_list_delete_all(((argile).types)[i_2]);
  };
  if ((((argile).main != ((argile_code_t *)0)) && is_not_included((argile).main))) {
    argile_code_del((argile).main);
  }
  for (i_2 = 0; (i_2 < 1024); (i_2)++) {
    argrt_list_delete_all(((argile).ids)[i_2]);
  };
  for (i_2 = 0; (i_2 < 4096); (i_2)++) {
    argrt_list_delete_all(((argile).defs)[i_2]);
    ((argile).defs)[i_2] = ((argrt_list_t *)0);
  };
  argrt_list_delete_all((argile).used);
  argrt_list_delete_all((argile).mods);
  argrt_list_delete_all((argile).file_path);
  argrt_list_delete_all((argile).globally);
  argrt_list_delete_all((argile).includes);
  argrt_list_delete_all((argile).sysincludes);
  argrt_list_delete_all((argile).sys_inc_path);
  argrt_list_delete_all((argile).op_ranges);
  argrt_list_delete_all((argile).options);
  argrt_list_delete_all((argile).keywords);
  argrt_list_delete_all((argile).reserved);
  argrt_list_delete_all((argile).file_warns);
  argrt_list_delete_all((argile).stat_fails);
  argrt_list_delete_all((argile).comments);
  argile_buff_del((argile).next_input_buff);
  argile_buff_del((argile).signbuffer);
  memset(&argile, 0, sizeof(argile_t));
}

/** :argile_get_option <text opt>: -> text **/
char * argile_get_option(char * opt)
{
  argrt_list_t * lo;

  lo = (argile).options;
  while (!(((lo == ((argrt_list_t *)0)) || (((argrt_list_t *)lo)->next == ((argrt_list_t *)0))))) {
    if ((strcmp(*((char * *)&((argrt_list_t *)lo)->data), opt) == 0)) {
      return *((char * *)&((argrt_list_t *)((argrt_list_t *)lo)->next)->data);
    }
    lo = ((argrt_list_t *)lo)->next;
  };
  return (char *)0;
}

/** :argile_parse <any data>: -> int **/
int argile_parse(void * data)
{
  int ret = 0;

  (argile).input_data = data;
  (argile).input_ended = 0;
  (argile).separator = 0;
  (argile).new_line = 1;
  (argile).indents = ((argrt_list_t *)0);
  (argile).tokens = ((argrt_list_t *)0);
  (argile).last_token = ((argrt_list_t *)0);
  (((argile).loc).start).row = 1;
  (((argile).loc).start).col = 0;
  (((argile).loc).end).row = 1;
  (((argile).loc).end).col = 0;
  (argile).linebuff = argile_buff_new(0);
  argile_resurrect();
  ret = argile_yyparse();
  ((((argile).loc).end).row)--;
  argile_buff_del((argile).linebuff);
  (argile).linebuff = ((argile_buff_t *)0);
  argrt_list_delete_all((argile).indents);
  (argile).indents = ((argrt_list_t *)0);
  argrt_list_delete_all((argile).tokens);
  (argile).tokens = ((argrt_list_t *)0);
  (argile).last_token = ((argrt_list_t *)0);
  if (((argile).error)) {
    argile_choke_leaks();
    if ((((argile).main) && (((argile).main)->calls))) {
      ((argile).main)->calls = ((argrt_list_t *)0);
    }
    return -1;
  }
  argile_forget_leaks();
  attribute_comments_to_calls();
  return ret;
}

/** :attribute comments to calls: -> nothing **/
static void attribute_comments_to_calls()
{
  argrt_list_t * lcall;
  argrt_list_t * lcomm;

  if (!((argile).get_comments)) {
    return;
  }
  if (((argile).main == ((argile_code_t *)0))) {
    return;
  }
  lcall = ((argile).main)->calls;
  lcomm = argrt_list_start((argile).comments);
  while (!(((lcall == ((argrt_list_t *)0)) || ((*((argile_call_t * *)&((argrt_list_t *)lcall)->data))->match != ((argrt_list_t *)0))))) {
    lcall = ((argrt_list_t *)lcall)->next;
  };
  if ((lcall == ((argrt_list_t *)0))) {
    return;
  }
  while (!(((lcomm == ((argrt_list_t *)0)) || argile_pos_superior_argile_pos(&(*((comment_t * *)&((argrt_list_t *)lcomm)->data))->pos, &((*((argile_call_t * *)&((argrt_list_t *)lcall)->data))->loc).start)))) {
    (*((comment_t * *)&((argrt_list_t *)lcomm)->data))->top = 1;
    lcomm = ((argrt_list_t *)lcomm)->next;
  };
  while (!(((lcall == ((argrt_list_t *)0)) || (lcomm == ((argrt_list_t *)0))))) {
    comment_t * comm = ((comment_t *)0);
    argile_pos_t * pcomm = ((argile_pos_t *)0);

    comm = *((comment_t * *)&((argrt_list_t *)lcomm)->data);
    pcomm = &(comm)->pos;
    while (!(((lcall == ((argrt_list_t *)0)) || argile_pos_superior_argile_pos(&((*((argile_call_t * *)&((argrt_list_t *)lcall)->data))->loc).start, pcomm)))) {
      lcall = ((argrt_list_t *)lcall)->next;
    };
    if (!((lcall == ((argrt_list_t *)0)))) {
      argile_call_t * call = ((argile_call_t *)0);

      call = *((argile_call_t * *)&((argrt_list_t *)lcall)->data);
      if (((call)->comment)) {
        ARGRT_free((call)->comment);
      }
      (call)->comment = (comm)->txt;
      (comm)->txt = (char *)0;
    }
    lcomm = ((argrt_list_t *)lcomm)->next;
  };
}

/** :argile_compile: -> int **/
int argile_compile()
{
  int r = 0;

  r = argile_compile_as((argile_type_t)ARGILE_TYPE_ANYTHING);
  argile_add_gstats();
  return r;
}

/** :argile_compile_as <argile type t>: -> int **/
int argile_compile_as(argile_type_t t)
{
  if (!(((argile).main))) {
    return 0;
  }
  return argile_code_compile((argile).main, t);
}

/** :argile_add_comment <text txt> <int line> <int col>: -> nothing **/
void argile_add_comment(char * txt, int line, int col)
{
  comment_t * cmt = ((comment_t *)0);

  if (((txt)[0] != (":")[0])) {
    ARGRT_free(txt);
    return;
  }
  cmt = ((comment_t *)memset(ARGRT_malloc(sizeof(comment_t)), 0, sizeof(comment_t)));
  (cmt)->txt = txt;
  ((cmt)->pos).row = line;
  ((cmt)->pos).col = col;
  argrt_list_append(&(argile).comments, argrt_list_new(((void *)((long)cmt)), (void *)&comment));
}

/** :argile_add_keyword <text word>: -> nothing **/
void argile_add_keyword(char * word)
{
  unsigned int hash = 0;

  hash = (argile_hash(word) % 1024);
  argrt_list_prepend(&((argile).ids)[hash], argrt_list_new(((void *)((long)word)), ((argile_deleter_t)0)));
  argrt_list_prepend(&(argile).keywords, argrt_list_new(((void *)((long)word)), ((argile_deleter_t)0)));
}

/** :argile_add_reserved <text word>: -> nothing **/
void argile_add_reserved(char * word_2)
{
  unsigned int hash = 0;

  hash = (argile_hash(word_2) % 1024);
  argrt_list_prepend(&((argile).ids)[hash], argrt_list_new(((void *)((long)word_2)), ((argile_deleter_t)0)));
  argrt_list_prepend(&(argile).reserved, argrt_list_new(((void *)((long)word_2)), ((argile_deleter_t)0)));
}

/** :argile_gencode <text header>: -> nothing **/
void argile_gencode(char * header)
{
  argrt_list_t * lc;

  if (((argile).globally != ((argrt_list_t *)0))) {
    for (lc = argrt_list_end((argile).globally); (lc); lc = ((argrt_list_t *)lc)->prev) {
      argile_code_t * code = ((argile_code_t *)0);

      code = *((argile_code_t * *)&((argrt_list_t *)lc)->data);
      if (!((code)->compiled)) {
        unsigned char old;

        old = (argile).main_only;
        (argile).main_only = 0;
        argile_code_compile(code, (code)->type);
        (argile).main_only = old;
      }
      argile_code_gencode(code);
    };
    argile_puts("\n");
  }
  argile_code_pregen_ids((argile).main);
  argile_find_all_autoparams();
  if ((header)) {
    argile_printf("#include \"%s\"\n\n", header);
  }
  else {
    argile_gen_header((char *)0);
  }
  argile_code_gen_defines((argile).main, (1));
  argile_code_gen_typedefs((argile).main, 1);
  argile_code_gen_enums((argile).main, 1);
  argile_code_gen_structs_and_unions((argile).main, 1);
  argile_code_gen_protos((argile).main, 1);
  argile_code_gen_vars((argile).main, 0);
  for (lc = (argile).globally; (lc); lc = ((argrt_list_t *)lc)->next) {
    argile_code_gen_vars(*((argile_code_t * *)&((argrt_list_t *)lc)->data), 0);
  };
  argile_code_gen_private_vars((argile).main);
  argile_code_gen_funcs((argile).main);
  if ((argile).do_main) {
    argile_code_gen_main((argile).main);
  }
  argile_flush_refs();
}

/** :argile_gen_header <text name>: -> nothing **/
void argile_gen_header(char * name)
{
  int size = 0;
  argile_file_t * file = ((argile_file_t *)0);

  if ((name)) {
    char * s = "";
    int match = 0;
    argrt_list_t * lf;

    s = strrchr(name, '/');
    if ((s)) {
      name = ((s) + 1);
    }
    size = get_word_size_of(name);
    lf = (argile).used;
    for (; (lf); lf = ((argrt_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);
      int sz = 0;

      f = *((argile_file_t * *)&((argrt_list_t *)lf)->data);
      s = strrchr((f)->path, '/');
      if ((s)) {
        (s)++;
      }
      else {
        s = (f)->path;
      }
      sz = get_word_size_of(s);
      if (((sz == size) && (strncmp(s, name, sz) == 0))) {
        (match)++;
        file = f;
      }
    };
    if ((match != 1)) {
      file = ((argile_file_t *)0);
    }
    argile_puts("#ifndef ");
    print_define(&file, &size, &name);
    argile_puts("\n#define ");
    print_define(&file, &size, &name);
    argile_puts("\n\n");
  }
  argile_code_gen_defines((argile).main, (0));
  argile_code_gen_typedefs((argile).main, 0);
  argile_code_gen_includes((argile).main);
  argile_code_gen_enums((argile).main, 0);
  argile_code_gen_structs_and_unions((argile).main, 0);
  if ((name)) {
    argile_code_gen_vars((argile).main, 2);
  }
  else {
    argile_code_gen_vars((argile).main, 1);
  }
  argile_code_gen_protos((argile).main, 0);
  if ((name)) {
    argile_puts("#endif /* ");
    print_define(&file, &size, &name);
    argile_puts(" */\n");
  }
}

/** :argile_gen_module <FILE f>: -> nothing **/
void argile_gen_module(FILE * f)
{
  argile_buff_t s = ((argile_buff_t){0});
  argile_buff_t t_2 = ((argile_buff_t){0});
  argile_call_t * c = ((argile_call_t *)0);
  char * new_line = "";
  unsigned char old;
  argrt_list_t * lcom;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_def_t * duse = ((argile_def_t *)0);
  argile_def_t * dinc = ((argile_def_t *)0);
  argile_def_t * dvar = ((argile_def_t *)0);
  argile_def_t * dfunc = ((argile_def_t *)0);
  argile_def_t * dcmac = ((argile_def_t *)0);
  argile_def_t * dext = ((argile_def_t *)0);
  argile_def_t * dnodecl = ((argile_def_t *)0);
  argile_def_t * dtref = ((argile_def_t *)0);
  argile_def_t * dtraw = ((argile_def_t *)0);

  new_line = (((argile).dump_indent) ? ("\n") : (";\n"));
  old = (argile).use_colors;
  (argile).use_colors = 0;
  lcom = argrt_list_start((argile).comments);
  for (; (lcom); lcom = ((argrt_list_t *)lcom)->next) {
    comment_t * com = ((comment_t *)0);

    com = *((comment_t * *)&((argrt_list_t *)lcom)->data);
    if (!((com)->top)) {
      break;
    }
    fprintf(f, "(:%s:)\n", (com)->txt);
  };
  mod = argile_getmod("std");
  if ((mod)) {
    argrt_list_t * lx;

    lx = ((argile).main)->calls;
    for (; (lx); lx = ((argrt_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      c = *((argile_call_t * *)&((argrt_list_t *)lx)->data);
      d = (c)->def;
      if ((((d) && ((d)->dtype == ARGILE_DEF_BIND)) && (((d)->dval).bind)->modulable)) {
        argile_buff_flush(&s);
        argile_call_string(c, 0, &s);
        if (((s).ptr)) {
          if (((c)->comment)) {
            fprintf(f, "(:%s:)\n", (c)->comment);
          }
          fwrite((s).ptr, (s).len, 1, f);
        }
        fputs(new_line, f);
      }
    };
  }
  else {
    argrt_list_t * p = ((argrt_list_t *)0);
    argrt_list_t * lx;
    argrt_list_t * lp;

    lx = (argile).used;
    for (; (lx); lx = ((argrt_list_t *)lx)->next) {
      argile_file_t * fp = ((argile_file_t *)0);
      argile_code_t * u = ((argile_code_t *)0);

      fp = *((argile_file_t * *)&((argrt_list_t *)lx)->data);
      for (u = ((argile).main)->upper; (u); u = (u)->upper) {
        if (((u)->ghost == (fp)->code)) {
          argrt_list_prepend(&p, argrt_list_new(((void *)((long)(fp)->path)), ((argile_deleter_t)0)));
          break;
        }
      };
    };
    lp = p;
    for (; (lp); lp = ((argrt_list_t *)lp)->next) {
      fprintf(f, "use \"%s\"%s", *((char * *)&((argrt_list_t *)lp)->data), new_line);
    };
    argrt_list_delete_all(p);
  }
  if ((((argile).main)->calls)) {
    c = *((argile_call_t * *)&((argrt_list_t *)((argile).main)->calls)->data);
  }
  else {
    c = ((argile_call_t *)0);
  }
  duse = argile_find_def("std", "use", "", 1);
  dinc = argile_find_def("std", "use", "include", 1);
  dvar = argile_find_def("std", "extdef", "", 1);
  dfunc = argile_find_def("std", "extdef", "func", 1);
  dcmac = argile_find_def("std", "extdef", "Cmacro", 1);
  dext = argile_find_def("std", "extern", "", 1);
  dnodecl = argile_find_def("std", "extern", "nodecl", 1);
  dtref = argile_find_def("std", "typeref", "", 1);
  dtraw = argile_find_def("std", "typeraw", "", 1);
  if (((duse) && ((dinc) && ((dvar) && ((dfunc) && ((dcmac) && ((dext) && ((dnodecl) && ((dtref) && (dtraw)))))))))) {
    argrt_list_t * lx;

    lx = ((argile).main)->defs;
    for (; (lx); lx = ((argrt_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)lx)->data);
      if (((d)->locall || (d)->private)) {
        continue;
      }
      if (((d)->dtype == ARGILE_DEF_VAR)) {
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argrt_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        }
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, argile_def_gen_id(d), ((argrt_list_t *)0), &s);
        }
        else {
          argile_syntax_module_call((dvar)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        }
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          }
          fwrite((s).ptr, (s).len, 1, f);
        }
        fputs(new_line, f);
      }
      else if ((((d)->dtype == ARGILE_DEF_FUNC) && !((argile_def_is_macro(d))))) {
        unsigned char got_type_in_buffer;

        argile_buff_flush(&t_2);
        got_type_in_buffer = 0;
        if (((((d)->dval).code) && (((d)->dval).code)->cmacro)) {
          if (((d)->maker)) {
            argile_shovel_t * sh = ((argile_shovel_t *)0);
            argile_match_t * m = ((argile_match_t *)0);

            sh = argile_shovel_new((d)->maker);
            m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
            if ((m != ((argile_match_t *)0))) {
              if (((m)->type == ARGILE_MATCH_SUBCALL)) {
                argile_call_string(((m)->value).call, 0, &t_2);
                got_type_in_buffer = 1;
              }
            }
            argile_shovel_del(sh);
          }
        }
        if (!(got_type_in_buffer)) {
          argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
          if ((((((int)(d)->type) >> 31) & 1))) {
            argile_buff_flush(&s);
            argile_syntax_module_call((dtref)->syntax, &t_2, (char *)0, ((argrt_list_t *)0), &s);
            argile_buff_flush(&t_2);
            argile_buff_cat(&t_2, &s);
          }
          else if ((((((int)(d)->type) >> 30) & 1))) {
            argile_buff_flush(&s);
            argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argrt_list_t *)0), &s);
            argile_buff_flush(&t_2);
            argile_buff_cat(&t_2, &s);
          }
        }
        argile_buff_flush(&s);
        if (((((d)->dval).code) && (((d)->dval).code)->cmacro)) {
          argile_syntax_module_call((dcmac)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        }
        else if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, (char *)0, (d)->syntax, &s);
        }
        else {
          argile_syntax_module_call((dfunc)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        }
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          }
          fwrite((s).ptr, (s).len, 1, f);
        }
        fputs(new_line, f);
      }
      else if (((d)->maker)) {
        argile_buff_flush(&s);
        argile_call_string((d)->maker, 0, &s);
        if (((s).ptr)) {
          if ((((d)->maker)->comment)) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          }
          fwrite((s).ptr, (s).len, 1, f);
        }
        fputs(new_line, f);
      }
    };
  }
  if (((s).ptr)) {
    ARGRT_free((s).ptr);
  }
  if (((t_2).ptr)) {
    ARGRT_free((t_2).ptr);
  }
  (argile).use_colors = old;
}

/** :argile_printf <text fmt> [...]: -> nothing **/
void argile_printf(char * fmt, ...)
{
  va_list args;
  int max = 0;

  va_start(args, fmt);
  max = vsnprintf((char *)0, 0, fmt, args);
  va_end(args);
  if (((max)++ > 0)) {
    char * string = "";
    int len = 0;

    string = ((char *)ARGRT_malloc(max));
    va_start(args, fmt);
    len = vsnprintf(string, max, fmt, args);
    va_end(args);
    if ((len < max)) {
      argile_output(string, len);
    }
    else {
      argile_output(string, max);
    }
    ARGRT_free(string);
  }
}

/** :argile_die <text fmt> [...]: -> nothing **/
void argile_die(char * fmt_2, ...)
{
  va_list args;
  int max = 0;

  if (((argile).error)) {
    return;
  }
  va_start(args, fmt_2);
  max = vsnprintf((char *)0, 0, fmt_2, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len = 0;

    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 64);
    }
    (argile).error = ((char *)ARGRT_malloc(max));
    va_start(args, fmt_2);
    len = vsnprintf((argile).error, max, fmt_2, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len), (max - len));
    }
  }
}

/** :print line <text dst> <int len>: -> nothing **/
static void print_line(char * dst, int len)
{
  int ofs = 0;
  int i_2 = 0;

  if (((argile).linebuff == ((argile_buff_t *)0))) {
    return;
  }
  argile_buff_putc((argile).linebuff, '\0');
  ofs = snprintf(dst, len, "\n%s\n", ((argile).linebuff)->ptr);
  argile_buff_seek((argile).linebuff, (-1));
  if (((((argile).loc).start).row == (((argile).loc).end).row)) {
    while ((i_2 < (((argile).loc).start).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "-");
      (i_2)++;
    };
  }
  if ((i_2 < (((argile).loc).end).col)) {
    while ((i_2 < (((argile).loc).end).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "^");
      (i_2)++;
    };
  }
  else {
    ofs += snprintf(((dst) + ofs), (len - ofs), "^");
  }
  snprintf(((dst) + ofs), (len - ofs), "-> at \"%s\", line %d", ((((argile).input_name)) ? ((argile).input_name) : ("anonymous input")), (((argile).loc).end).row);
}

/** :argile_die_again <text fmt> [...]: -> nothing **/
void argile_die_again(char * fmt_3, ...)
{
  char * old_death = "";
  va_list args;
  int max = 0;

  old_death = (argile).error;
  va_start(args, fmt_3);
  max = vsnprintf((char *)0, 0, fmt_3, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len_2 = 0;

    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 32);
    }
    (argile).error = ((char *)ARGRT_malloc(max));
    va_start(args, fmt_3);
    len_2 = vsnprintf((argile).error, max, fmt_3, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len_2), (max - len_2));
    }
  }
  if (!((old_death == (char *)0))) {
    ARGRT_free(old_death);
  }
}

/** :argile_die_hard <text fmt> [...]: -> nothing **/
void argile_die_hard(char * fmt_4, ...)
{
  va_list args;

  fprintf(stderr, "\n");
  va_start(args, fmt_4);
  vfprintf(stderr, fmt_4, args);
  va_end(args);
  if ((((argile).linebuff) && (((argile).linebuff)->len != 0))) {
    int len_2 = 0;
    char * tmp = "";

    len_2 = ((((argile).linebuff)->len * 2) + 32);
    tmp = ((char *)ARGRT_malloc(len_2));
    print_line(tmp, len_2);
    fprintf(stderr, "%s\n", tmp);
    ARGRT_free(tmp);
  }
  {
    fprintf(stderr, "\n");
    exit(1);
  };
}

/** :argile_die_at <call at> <text fmt> [...]: -> nothing **/
void argile_die_at(argile_call_t * at, char * fmt_5, ...)
{
  va_list args;
  int max = 0;
  argile_buff_t buf = ((argile_buff_t){0});

  if (((argile).error)) {
    return;
  }
  va_start(args, fmt_5);
  max = vsnprintf((char *)0, 0, fmt_5, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len_2 = 0;

    argile_buff_puts(&buf, "\n  ");
    if (((at)->owner)) {
      argile_buff_putc(&buf, ("(")[0]);
    }
    argile_call_string(at, 1, &buf);
    if (((at)->owner)) {
      argile_buff_putc(&buf, (")")[0]);
    }
    if ((((at)->context != (argile_type_t)ARGILE_TYPE_NOTHING) && ((at)->context != (argile_type_t)ARGILE_TYPE_ANYTHING))) {
      argile_buff_puts(&buf, "\n(expected return type: ");
      argile_typename((at)->context, &buf, (at)->scope);
      argile_buff_puts(&buf, ")");
    }
    argile_buff_puts(&buf, "\n=> at \"");
    if ((((at)->scope)->input)) {
      argile_buff_puts(&buf, ((at)->scope)->input);
    }
    else {
      argile_buff_puts(&buf, "anonymous input");
    }
    argile_buff_puts(&buf, "\", from line ");
    argile_buff_putn(&buf, (((at)->loc).start).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).start).col);
    argile_buff_puts(&buf, ", to line ");
    argile_buff_putn(&buf, (((at)->loc).end).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).end).col);
    argile_buff_putc(&buf, '\0');
    max += (buf).len;
    (argile).error = ((char *)ARGRT_malloc(max));
    va_start(args, fmt_5);
    len_2 = vsnprintf((argile).error, max, fmt_5, args);
    snprintf((((argile).error) + len_2), (max - len_2), "%s", (buf).ptr);
    va_end(args);
    ARGRT_free((buf).ptr);
    (argile).killer = at;
  }
}

/** :argile_warn_at <call at> <text fmt> [...]: -> nothing **/
void argile_warn_at(argile_call_t * at_2, char * fmt_6, ...)
{
  va_list args;

  if (((argile).error)) {
    return;
  }
  fprintf(stderr, "warning: ");
  va_start(args, fmt_6);
  vfprintf(stderr, fmt_6, args);
  va_end(args);
  fprintf(stderr, "\n  ");
  {
    argile_buff_t buf = ((argile_buff_t){0});

    argile_call_string(at_2, 1, &buf);
    argile_buff_putc(&buf, '\0');
    if (((at_2)->owner == ((argile_call_t *)0))) {
      fprintf(stderr, "%s", (buf).ptr);
    }
    else {
      fprintf(stderr, "(%s)", (buf).ptr);
    }
    ARGRT_free((buf).ptr);
  };
  fprintf(stderr, "\n=> at \"%s\"", (((((at_2)->scope)->input)) ? (((at_2)->scope)->input) : ("anonymous input")));
  fprintf(stderr, ", from line %d column %d", (((at_2)->loc).start).row, (((at_2)->loc).start).col);
  fprintf(stderr, ", to line %d column %d\n", (((at_2)->loc).end).row, (((at_2)->loc).end).col);
}

/** :argile_resurrect: -> nothing **/
void argile_resurrect()
{
  if (((argile).error)) {
    ARGRT_free((argile).error);
    (argile).error = (char *)0;
  }
}

/** :argile_def <list of (argile syntax) syntax> <int del_syntax> <argile type type> <def type dtype> <any dval>: -> nothing **/
void argile_def(argrt_list_t * syntax, int del_syntax, argile_type_t type, argile_def_type_t dtype, void * dval)
{
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argrt_list_t *)0));
  }
  argile_code_def((argile).main, argile_def_new(syntax, del_syntax, type, ((argile_call_t *)0), dtype, dval), 1);
}

/** :argile_bind <text synstr> <text modname> <text name>: -> nothing **/
void argile_bind(char * synstr, char * modname, char * name_2)
{
  argrt_list_t * syn;
  unsigned char comp;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_bind_t * bind = ((argile_bind_t *)0);

  if (((argile).error)) {
    return;
  }
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argrt_list_t *)0));
  }
  if (((((syn = argile_syntax_parse(synstr)) && (comp = (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) && (mod = argile_getmod(modname))) && (bind = argile_module_getbind(mod, name_2)))) {
    argile_type_t type_2;

    type_2 = ((((bind)->type)) ? (*(bind)->type) : ((argile_type_t)ARGILE_TYPE_NOTHING));
    if ((bind)->deftype) {
      if (((bind)->gettype)) {
        type_2 = (*(bind)->gettype)(NULL);
      }
      argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)type_2)));
    }
    else {
      argile_def(syn, 1, type_2, ARGILE_DEF_BIND, bind);
    }
  }
  else if ((syn)) {
    if (!(comp)) {
      argile_die("binding: %s some parameter type could not compile", synstr);
    }
    else if ((mod == ((argile_module_t *)0))) {
      argile_die("binding: %s: no such module", modname);
    }
    else if ((bind == ((argile_bind_t *)0))) {
      argile_die("binding: %s: no such binding in module %s", name_2, modname);
    }
    argrt_list_delete_all(syn);
  }
}

/** :argile_deftype <text synstr> <argile type t>: -> nothing **/
void argile_deftype(char * synstr_2, argile_type_t t_2)
{
  argrt_list_t * syn;

  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argrt_list_t *)0));
  }
  syn = argile_syntax_parse(synstr_2);
  if (((syn) && (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) {
    argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)t_2)));
  }
  else if ((syn)) {
    argile_die("type definition: %s some parameter type did not compile", synstr_2);
    argrt_list_delete_all(syn);
  }
}

/** :argile_implicitize: -> nothing **/
void argile_implicitize()
{
  argrt_list_t * ldef;

  if (((argile).main == ((argile_code_t *)0))) {
    return;
  }
  for (ldef = ((argile).main)->defs; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
    (*((argile_def_t * *)&((argrt_list_t *)ldef)->data))->implicit = 1;
  };
  ((argile).main)->has_weak_defs = 1;
  ((argile).stat).binds = 0;
  ((argile).stat).num_match_try = 0;
}

/** :argile_typename <argile type type> <buff buf> <argile code scope>: -> int **/
int argile_typename(argile_type_t type_2, argile_buff_t * buf, argile_code_t * scope)
{
  argile_buff_t tmp = ((argile_buff_t){0});
  argile_def_t * dtyperef = ((argile_def_t *)0);
  argile_def_t * dtyperaw = ((argile_def_t *)0);
  argile_type_info_t * info = ((argile_type_info_t *)0);
  argrt_list_t * cur;
  argrt_list_t * prev;
  argrt_list_t * next;

  dtyperef = argile_find_def("std", "typeref", "", 0);
  dtyperaw = argile_find_def("std", "typeraw", "", 0);
  info = argile_type_get_info(type_2);
  if (((info) && ((info)->ttype == ARGILE_TYPE_KIND_CTYPE))) {
    if (((((info)->tval).t_ctype).generator)) {
      unsigned char old_sc;
      unsigned char old_et;

      old_sc = (argile).skip_codes;
      old_et = (argile).eval_types;
      (argile).skip_codes = 1;
      (argile).eval_types = 1;
      argile_buff_flush(&tmp);
      argile_call_string((((info)->tval).t_ctype).generator, 0, &tmp);
      (argile).skip_codes = old_sc;
      (argile).eval_types = old_et;
      if ((((((int)type_2) >> 31) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      }
      else if ((((((int)type_2) >> 30) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      }
      else {
        argile_buff_cat(buf, &tmp);
      }
      if (((tmp).ptr)) {
        ARGRT_free((tmp).ptr);
      }
      return 1;
    }
  }
  argile_code_getdef(scope, ((argile_call_t *)0), &prev, &next);
  while ((cur = argile_code_nextdef(&scope, &prev, &next))) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)cur)->data);
    if ((((d)->dtype != ARGILE_DEF_TYPE) || ((d)->type != (argile_type_t)ARGILE_TYPE_TYPE))) {
      continue;
    }
    if ((((d)->dval).type == (((int)type_2) & ((1 << 30) - 1)))) {
      if ((((((int)type_2) >> 31) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference to");
      }
      else if ((((((int)type_2) >> 30) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure of");
      }
      else {
        argile_syntax_string((d)->syntax, buf);
      }
      if (((tmp).ptr)) {
        ARGRT_free((tmp).ptr);
      }
      return 1;
    }
  };
  argile_buff_putn(buf, ((int)type_2));
  return 0;
}

/** :argile_getmod <text name>: -> (argile) module **/
argile_module_t * argile_getmod(char * name_3)
{
  argrt_list_t * lmod;

  for (lmod = (argile).mods; (lmod); lmod = ((argrt_list_t *)lmod)->next) {
    argile_module_t * mod = ((argile_module_t *)0);

    mod = *((argile_module_t * *)&((argrt_list_t *)lmod)->data);
    if ((strcmp(name_3, (mod)->name) == 0)) {
      return mod;
    }
  };
  return ((argile_module_t *)0);
}

/** :argile_addmod <module mod>: -> nothing **/
void argile_addmod(argile_module_t * mod)
{
  argrt_list_prepend(&(argile).mods, argrt_list_new(((void *)((long)mod)), (void *)&argile_module_del));
}

/** :<text str> ends by <int n> <text end>: -> int **/
static int ends_by(char * str, int n, char * end)
{
  int e = 0;

  e = strlen(end);
  if (((n > e) && (strcmp(((str) + (n - e)), end) == 0))) {
    return e;
  }
  return 0;
}

/** :argile_init_std: -> nothing **/
void argile_init_std()
{
  argile_module_t * std = ((argile_module_t *)0);

  std = argile_module_new("std");
  argmod_init_binds(std);
  argile_addmod(std);
}

/** :argile_getfile <file>: -> (argile) file **/
argile_file_t * argile_getfile(argile_file_t * p_argile_file)
{
  argrt_list_t * lf;

  lf = argrt_list_search((argile).used, p_argile_file, (void *)&argile_file_eq);
  if ((lf == ((argrt_list_t *)0))) {
    return ((argile_file_t *)0);
  }
  return *((argile_file_t * *)&((argrt_list_t *)lf)->data);
}

/** :argile_getfile_by_name <text name>: -> (argile) file **/
argile_file_t * argile_getfile_by_name(char * name_4)
{
  argrt_list_t * lf;

  lf = argrt_list_search((argile).used, name_4, (void *)&argile_filename_eq);
  if ((lf == ((argrt_list_t *)0))) {
    return ((argile_file_t *)0);
  }
  return *((argile_file_t * *)&((argrt_list_t *)lf)->data);
}

/** :argile_addfile <file>: -> nothing **/
void argile_addfile(argile_file_t * p_argile_file_2)
{
  argrt_list_prepend(&(argile).used, argrt_list_new(((void *)((long)p_argile_file_2)), (void *)&argile_file_del));
}

/** :argile_loadfile <text path>: -> (argile) file **/
argile_file_t * argile_loadfile(char * path)
{
  argile_file_t * file = ((argile_file_t *)0);
  argile_file_t * old = ((argile_file_t *)0);

  if ((argile).verbose) {
    {
      int i = 0;

      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
        fprintf(stderr, " ");
      };
    };
    fprintf(stderr, "   loading file %s\n", path);
  }
  file = argile_getfile_by_name(path);
  if (!((file == ((argile_file_t *)0)))) {
    return file;
  }
  file = try_new_file(path);
  if ((file == ((argile_file_t *)0))) {
    argile_die("include file: %s: could not find file", path);
    return ((argile_file_t *)0);
  }
  if (((file)->error != 0)) {
    argile_die("%s: %s", path, strerror((file)->error));
    argile_file_del(file);
    return ((argile_file_t *)0);
  }
  old = argile_getfile(file);
  if ((old)) {
    argile_file_del(file);
    add_include((old)->path);
    return old;
  }
  argile_addfile(file);
  argile_file_load(file);
  if (((argile).error)) {
    argrt_list_t * lf;

    lf = (argile).used;
    argrt_list_remove(&(argile).used, lf);
    ((argrt_list_t *)lf)->next = ((argrt_list_t *)0);
    argrt_list_delete_all(lf);
    return ((argile_file_t *)0);
  }
  add_include((file)->path);
  if ((argile).verbose) {
    {
      int i = 0;

      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
        fprintf(stderr, " ");
      };
    };
    fprintf(stderr, "   loaded  file %s\n", (file)->path);
  }
  return file;
}

/** :try new file <text path>: -> (argile) file **/
static argile_file_t * try_new_file(char * path_2)
{
  char * base = (char *)0;
  int baselen = 0;
  argrt_list_t * lf;
  int extlen = 0;
  int libextlen = 0;
  int pathlen = 0;
  argile_file_t * file = ((argile_file_t *)0);
  argrt_list_t * lp;

  if (((path_2)[0] == '/')) {
    return argile_file_new(path_2, ((struct stat *)0));
  }
  lf = (argile).used;
  for (; (lf); lf = ((argrt_list_t *)lf)->next) {
    if (((*((argile_file_t * *)&((argrt_list_t *)lf)->data))->code == (argile).main)) {
      base = (*((argile_file_t * *)&((argrt_list_t *)lf)->data))->path;
    }
  };
  if ((base)) {
    char * b = "";

    b = strrchr(base, '/');
    if ((b)) {
      baselen = ((b) - base);
    }
    else {
      base = ".";
      baselen = 1;
    }
  }
  extlen = strlen(".arg");
  libextlen = strlen(".argl");
  if ((libextlen > extlen)) {
    extlen = libextlen;
  }
  pathlen = (((1 + strlen(path_2)) + extlen) + 1);
  if (((base) && (file = try_in_dir(path_2, pathlen, base, baselen)))) {
    return file;
  }
  lp = (argile).file_path;
  for (; (lp); lp = ((argrt_list_t *)lp)->next) {
    char * dirpath = "";
    int dirlen = 0;

    dirpath = *((char * *)&((argrt_list_t *)lp)->data);
    dirlen = strlen(dirpath);
    file = try_in_dir(path_2, pathlen, dirpath, dirlen);
    if ((file != ((argile_file_t *)0))) {
      return file;
    }
  };
  return ((argile_file_t *)0);
}

/** :argile_push_output <inout output> <any output_data>: -> nothing **/
void argile_push_output(argile_inout_t output, void * output_data)
{
  void *(* ptrs);

  ptrs = ((void *(*))ARGRT_malloc((5 * sizeof(void *))));
  (ptrs)[0] = (argile).output;
  (ptrs)[1] = (argile).output_data;
  (ptrs)[2] = (argile).output_name;
  (ptrs)[3] = ((void *)((long)(long)(argile).output_line));
  (ptrs)[4] = ((void *)((long)(long)(argile).refcount));
  argrt_list_prepend(&(argile).outctx, argrt_list_new(((void *)((long)ptrs)), &ARGRT_free));
  (argile).output = output;
  (argile).output_data = output_data;
  (argile).output_line = 1;
  (argile).refcount = 0;
}

/** :argile_pop_output: -> nothing **/
void argile_pop_output()
{
  argrt_list_t * h;
  void *(* p);

  if (((argile).refcount != 0)) {
    argile_flush_refs();
  }
  h = argrt_list_pop(&(argile).outctx);
  p = ((void *(*))*((void *(* *))&((argrt_list_t *)h)->data));
  (argile).output = ((argile_inout_t)(p)[0]);
  (argile).output_data = (p)[1];
  (argile).output_name = ((char *)(p)[2]);
  (argile).output_line = ((int)((long)(p)[3]));
  (argile).refcount = ((int)((long)(p)[4]));
  argrt_list_delete_all(h);
}

/** :argile_push_color <buff out> <text color>: -> nothing **/
void argile_push_color(argile_buff_t * out, char * color)
{
  if ((((argile).colors == ((argrt_list_t *)0)) || (strcmp(color, *((char * *)&((argrt_list_t *)(argile).colors)->data)) != 0))) {
    if ((argile).use_colors) {
      argile_buff_puts(out, color);
    }
    if ((argile).daltonism) {
      argile_buff_puts(out, convert_to_daltonism(color));
    }
  }
  argrt_list_prepend(&(argile).colors, argrt_list_new(((void *)((long)color)), ((argile_deleter_t)0)));
}

/** :convert <text colour> to daltonism: -> text **/
static char * convert_to_daltonism(char * colour)
{
  if ((strcmp(colour, "\x1b[1;32m") == 0)) {
    return "(:O:)";
  }
  if ((strcmp(colour, "\x1b[1;31m") == 0)) {
    return "(:E:)";
  }
  if ((strcmp(colour, "\x1b[1;33m") == 0)) {
    return "(:R:)";
  }
  if ((strcmp(colour, "\x1b[2;32m") == 0)) {
    return "(:W:)";
  }
  if ((strcmp(colour, "\x1b[0;1m") == 0)) {
    return "(:U:)";
  }
  return "";
}

/** :argile_pop_color <buff out>: -> nothing **/
void argile_pop_color(argile_buff_t * out_2)
{
  argrt_list_t * head;

  head = argrt_list_pop(&(argile).colors);
  if (((argile).colors)) {
    char * cur = "";

    cur = *((char * *)&((argrt_list_t *)(argile).colors)->data);
    if (((strcmp(cur, *((char * *)&((argrt_list_t *)head)->data)) != 0) && (argile).use_colors)) {
      argile_buff_puts(out_2, cur);
    }
    if ((argile).daltonism) {
      argile_buff_puts(out_2, convert_to_daltonism(cur));
    }
  }
  else if ((argile).use_colors) {
    argile_buff_puts(out_2, "\x1b[0m");
  }
  argrt_list_delete_all(head);
}

/** :argile_push_token <int tok>: -> nothing **/
void argile_push_token(int tok)
{
  argrt_list_append(&(argile).last_token, argrt_list_new(((void *)((long)tok)), ((argile_deleter_t)0)));
  if (((argile).tokens == ((argrt_list_t *)0))) {
    (argile).tokens = (argile).last_token;
  }
}

/** :argile_pop_token: -> int **/
int argile_pop_token()
{
  argrt_list_t * lt;
  int t_3 = 0;

  if (((argile).tokens == ((argrt_list_t *)0))) {
    return 0;
  }
  lt = argrt_list_pop(&(argile).tokens);
  if (((argile).tokens == ((argrt_list_t *)0))) {
    (argile).last_token = ((argrt_list_t *)0);
  }
  t_3 = *((int *)&((argrt_list_t *)lt)->data._int);
  argrt_list_delete_all(lt);
  return t_3;
}

/** :argile_push_optoken <int token>: -> nothing **/
void argile_push_optoken(int token)
{
  argrt_list_append(&(argile).last_optoken, argrt_list_new(((void *)((long)token)), ((argile_deleter_t)0)));
  if (((argile).ops_tokens == ((argrt_list_t *)0))) {
    (argile).ops_tokens = (argile).last_optoken;
  }
}

/** :argile_pop_optoken: -> int **/
int argile_pop_optoken()
{
  argrt_list_t * lt;
  int t_3 = 0;

  if (((argile).ops_tokens == ((argrt_list_t *)0))) {
    return 0;
  }
  lt = argrt_list_pop(&(argile).ops_tokens);
  if (((argile).ops_tokens == ((argrt_list_t *)0))) {
    (argile).last_optoken = ((argrt_list_t *)0);
  }
  t_3 = *((int *)&((argrt_list_t *)lt)->data._int);
  argrt_list_delete_all(lt);
  return t_3;
}

/** :argile_push_op <text op>: -> nothing **/
void argile_push_op(char * op)
{
  argrt_list_append(&(argile).last_op, argrt_list_new(((void *)((long)op)), ((argile_deleter_t)0)));
  if (((argile).ops == ((argrt_list_t *)0))) {
    (argile).ops = (argile).last_op;
  }
}

/** :argile_pop_op: -> text **/
char * argile_pop_op()
{
  argrt_list_t * lv;
  char * val = "";

  if (((argile).ops == ((argrt_list_t *)0))) {
    return (char *)0;
  }
  lv = argrt_list_pop(&(argile).ops);
  if (((argile).ops == ((argrt_list_t *)0))) {
    (argile).last_op = ((argrt_list_t *)0);
  }
  val = *((char * *)&((argrt_list_t *)lv)->data);
  argrt_list_delete_all(lv);
  return val;
}

/** :argile_push_indent <int indent>: -> nothing **/
void argile_push_indent(int indent)
{
  if (((indent > -1) && (indent == argile_top_indent()))) {
    return;
  }
  argrt_list_prepend(&(argile).indents, argrt_list_new(((void *)((long)indent)), ((argile_deleter_t)0)));
}

/** :argile_top_indent: -> int **/
int argile_top_indent()
{
  if (((argile).indents == ((argrt_list_t *)0))) {
    return -2;
  }
  return *((int *)&((argrt_list_t *)(argile).indents)->data._int);
}

/** :argile_pop_indent: -> int **/
int argile_pop_indent()
{
  argrt_list_t * ltop;
  int top = 0;

  if (((argile).indents == ((argrt_list_t *)0))) {
    return -2;
  }
  ltop = argrt_list_pop(&(argile).indents);
  top = *((int *)&((argrt_list_t *)ltop)->data._int);
  argrt_list_delete_all(ltop);
  return top;
}

/** :argile_yyinput <text buf> <int len>: -> int **/
int argile_yyinput(char * buf_2, int len_2)
{
  if (((argile).input_ended || ((argile).input == ((argile_inout_t)0)))) {
    return 0;
  }
  return (*(argile).input)((argile).input_data, buf_2, len_2);
}

/** :argile_yylex_wrapper: -> int **/
int argile_yylex_wrapper()
{
  if (((argile).error)) {
    return 0;
  }
  if (((argile).tokens)) {
    return argile_pop_token();
  }
  if (((argile).ops_tokens)) {
    *&argile_yylval.string = argile_pop_op();
    return argile_pop_optoken();
  }
  if ((argile).input_ended) {
    return 0;
  }
  return argile_yylex();
}

/** :argile_add_leak <any data>: -> nothing **/
void argile_add_leak(void * data_2)
{
  argrt_list_prepend(&(argile).leaks, argrt_list_new(((void *)((long)data_2)), &ARGRT_free));
}

/** :argile_rm_leak <any data>: -> nothing **/
void argile_rm_leak(void * data_3)
{
  argrt_list_t * found;

  found = argrt_list_search((argile).leaks, data_3, ((argile_comparer_t)0));
  if ((found)) {
    argrt_list_remove(&(argile).leaks, found);
    ((argrt_list_t *)found)->del = ((void (*)(void *))0);
    argrt_list_delete_all(found);
  }
}

/** :argile_choke_leaks: -> nothing **/
void argile_choke_leaks()
{
  argrt_list_delete_all((argile).leaks);
  (argile).leaks = ((argrt_list_t *)0);
}

/** :argile_forget_leaks: -> nothing **/
void argile_forget_leaks()
{
  argrt_list_t * ll;
  argrt_list_t * nx;

  for (ll = (argile).leaks; (ll); ll = nx) {
    nx = ((argrt_list_t *)ll)->next;
    ARGRT_free(ll);
  };
  (argile).leaks = ((argrt_list_t *)0);
}

/** :argile_gen_ref <argile type context> <argile type type>: -> nothing **/
void argile_gen_ref(argile_type_t context, argile_type_t type_3)
{
  unsigned char is_ref;
  unsigned char is_raw;
  unsigned char in_ref;
  unsigned char in_raw;

  is_ref = (((((int)type_3) >> 31) & 1));
  is_raw = (((((int)type_3) >> 30) & 1));
  in_ref = (((((int)context) >> 31) & 1));
  in_raw = (((((int)context) >> 30) & 1));
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  }
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  }
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  }
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  }
}

/** :argile_ref <int count>: -> nothing **/
void argile_ref(int count)
{
  (argile).refcount += count;
}

/** :argile_flush_refs: -> nothing **/
void argile_flush_refs()
{
  if (((argile).refcount < 0)) {
    while ((((argile).refcount)++ != 0)) {
      (*(argile).output)((argile).output_data, "&", 1);
    };
  }
  else if (((argile).refcount > 0)) {
    while ((((argile).refcount)-- != 0)) {
      (*(argile).output)((argile).output_data, "*", 1);
    };
  }
  (argile).refcount = 0;
}

/** :argile_output <text buf> <int len>: -> nothing **/
void argile_output(char * buf_3, int len_3)
{
  if (((((argile).gen_lines != 0) && ((argile).outctx == ((argrt_list_t *)0))) && (((argile).next_input_buff)->len > 0))) {
    unsigned int n_2 = 0;

    n_2 = ((argile).next_input_buff)->len;
    ((argile).next_input_buff)->len = 0;
    argile_output(((argile).next_input_buff)->ptr, ((int)n_2));
    ((argile).last_input_line)--;
  }
  if ((len_3 > 0)) {
    int i_2 = 0;

    argile_flush_refs();
    for (i_2 = 0; ((i_2 <= (len_3 - 1))); (i_2)++) {
      if (((buf_3)[i_2] == '\n')) {
        ((argile).output_line)++;
        ((argile).last_input_line)++;
      }
    };
    (*(argile).output)((argile).output_data, buf_3, len_3);
  }
}

/** :argile_puts <text s>: -> nothing **/
void argile_puts(char * s)
{
  if (((s)[0] != 0)) {
    argile_output(s, strlen(s));
  }
}

/** :argile_putn <int n>: -> nothing **/
void argile_putn(int n_2)
{
  char( s_2[16]);

  n_2 = snprintf(((char *)s_2), sizeof(s_2), "%d", n_2);
  if (((n_2 > 0) && (n_2 < sizeof(s_2)))) {
    argile_output(((char *)s_2), n_2);
  }
}

/** :argile_indent: -> nothing **/
void argile_indent()
{
  int i_2 = 0;

  for (i_2 = 0; (i_2 < (argile).indent); (i_2)++) {
    argile_puts("  ");
  };
}

/** :argile_hash <text t>: -> nat **/
unsigned int argile_hash(char * t_3)
{
  unsigned int h = 0;

  while (((t_3)[0] != 0)) {
    h += ((unsigned int)((t_3)++)[0]);
    h += (h << 10);
    h ^= (h >> 6);
  };
  h += (h << 3);
  h ^= (h >> 11);
  h += (h << 15);
  return h;
}

/** :argile_streq <any a> <any b>: -> int **/
int argile_streq(void * a, void * b)
{
  return ((int)(strcmp(((char *)a), ((char *)b)) == 0));
}

/** :argile_check_collisions <buff ident_buff>: -> nothing **/
void argile_check_collisions(argile_buff_t * ident_buff)
{
  int num = 2;
  int end_2 = 0;
  unsigned int id = 0;

  end_2 = id_end_num((ident_buff)->ptr, (ident_buff)->len, &num);
  id = (argile_hash((ident_buff)->ptr) % 1024);
  while ((argrt_list_search(((argile).ids)[id], (ident_buff)->ptr, (void *)&argile_streq))) {
    (ident_buff)->len = ((unsigned int)end_2);
    argile_buff_putc(ident_buff, '_');
    argile_buff_putn(ident_buff, (num)++);
    argile_buff_putc(ident_buff, '\0');
    id = (argile_hash((ident_buff)->ptr) % 1024);
  };
  argrt_list_prepend(&((argile).ids)[id], argrt_list_new(((void *)((long)ARGRT_strdup((ident_buff)->ptr))), &ARGRT_free));
}

/** :argile_check_local_collisions <buff ident_buff> <argile code code>: -> nothing **/
void argile_check_local_collisions(argile_buff_t * ident_buff_2, argile_code_t * code)
{
  int min = -1;
  int max = 1;
  unsigned char found;
  int num = 1;
  unsigned int h = 0;

  found = 0;
  while ((code)) {
    argrt_list_t * ld;
    argrt_list_t * lid;
    argrt_list_t * lc;

    for (ld = (code)->defs; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      char * id = "";

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if ((d)->locall) {
        continue;
      }
      id = (d)->genid;
      if (((id == (char *)0) && ((d)->param != ((argile_syn_param_t *)0)))) {
        id = ((d)->param)->genid;
      }
      check_id_num(ident_buff_2, id, &found, &min, &max);
    };
    for (lid = (code)->special_ids; (lid); lid = ((argrt_list_t *)lid)->next) {
      check_id_num(ident_buff_2, *((char * *)&((argrt_list_t *)lid)->data), &found, &min, &max);
    };
    for (lc = (code)->calls; (lc); lc = ((argrt_list_t *)lc)->next) {
      check_call_id_num(*((argile_call_t * *)&((argrt_list_t *)lc)->data), ident_buff_2, &found, &min, &max);
    };
    code = (code)->upper;
  };
  ((ident_buff_2)->len)--;
  h = (argile_hash((ident_buff_2)->ptr) % 1024);
  while ((argrt_list_search(((argile).ids)[h], (ident_buff_2)->ptr, (void *)&argile_streq))) {
    unsigned int end_2 = 0;

    found = 1;
    if ((num > max)) {
      max = num;
    }
    if (((min < 0) || (num < min))) {
      min = num;
    }
    end_2 = (ident_buff_2)->len;
    argile_buff_putc(ident_buff_2, '_');
    argile_buff_putn(ident_buff_2, ++(num));
    argile_buff_putc(ident_buff_2, '\0');
    (ident_buff_2)->len = end_2;
    h = (argile_hash((ident_buff_2)->ptr) % 1024);
  };
  argile_buff_putc(ident_buff_2, '\0');
  if (found) {
    ((ident_buff_2)->len)--;
    argile_buff_putc(ident_buff_2, '_');
    if ((min > 2)) {
      argile_buff_putn(ident_buff_2, (min - 1));
    }
    else {
      argile_buff_putn(ident_buff_2, (max + 1));
    }
    argile_buff_putc(ident_buff_2, '\0');
  }
}

/** :argile_globally <argile code code>: -> nothing **/
void argile_globally(argile_code_t * code_2)
{
  argrt_list_prepend(&(argile).globally, argrt_list_new(((void *)((long)code_2)), ((argile_deleter_t)0)));
}

/** :argile_search_defs <text pattern> <function (def) callback>: -> nothing **/
void argile_search_defs(char * pattern, void (* callback)(argile_def_t *))
{
  argile_buff_t b_2 = {0};
  argrt_list_t * syntax_2;

  if (((pattern)[0] != (":")[0])) {
    argile_buff_puts(&b_2, ":");
    argile_buff_puts(&b_2, pattern);
    argile_buff_puts(&b_2, ":");
    argile_buff_putc(&b_2, '\0');
  }
  syntax_2 = argile_syntax_parse(((((b_2).ptr == (char *)0)) ? (pattern) : ((b_2).ptr)));
  if (((argile).error == (char *)0)) {
    search_in_with(syntax_2, (argile).main, callback);
  }
  argrt_list_delete_all(syntax_2);
  if (!(((b_2).ptr == (char *)0))) {
    ARGRT_free((b_2).ptr);
  }
}

/** :argile_match_or_reject <call c> <match m> <argile type t> <text error>: -> int **/
int argile_match_or_reject(argile_call_t * c, argile_match_t * m, argile_type_t t_4, char * error)
{
  argile_type_t mt;

  if ((argile_match_type(m, t_4))) {
    return 0;
  }
  mt = argile_match_get_type(m);
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * s_2 = ((argile_call_t *)0);

    s_2 = ((m)->value).call;
    if (((s_2)->type == ARGILE_CALL_EXPLICIT)) {
      argile_call_uncompile_subcalls(s_2, 1);
      (s_2)->def = ((argile_def_t *)0);
      (s_2)->compiled = 0;
      if ((argile_call_compile_as(s_2, t_4))) {
        return 0;
      }
    }
  }
  argile_call_mismatch(c, t_4, mt, error);
  return 1;
}

/** :argile_split_ops <int ops_type> <text str> <int len> <(text) & lval>: -> int **/
int argile_split_ops(int ops_type, char * str_2, int len_4, char * * lval)
{
  unsigned char o;
  unsigned char w;
  unsigned int c_2 = 0;
  unsigned int n_3 = 1;
  int i_2 = 0;
  int li = 0;

  if (((argile).op_ranges == ((argrt_list_t *)0))) {
    *lval = ARGRT_strdup(str_2);
    argile_push_token(T_WORD);
    return argile_pop_token();
  }
  w = 0;
  for (i_2 = 0; ((i_2 < len_4) && (n_3 > 0)); i_2 += n_3) {
    if (((argile).encoding == ((argile_encode_t *)0))) {
      c_2 = ((unsigned int)((unsigned char)(str_2)[i_2]));
    }
    else {
      c_2 = (*((argile).encoding)->charat)(((str_2) + i_2), (len_4 - i_2));
      n_3 = (*((argile).encoding)->charsize)(((str_2) + i_2), (len_4 - i_2));
    }
    o = (argile_is_operator(c_2));
    if (o) {
      if (w) {
        split_op(((str_2) + li), (i_2 - li), T_WORD);
      }
      split_op(((str_2) + i_2), ((int)n_3), ops_type);
      li = i_2;
    }
    else if (!(w)) {
      li = i_2;
    }
    w = !(o);
  };
  if (w) {
    split_op(((str_2) + li), (i_2 - li), T_WORD);
  }
  *lval = argile_pop_op();
  argile_push_token(argile_pop_optoken());
  return argile_pop_token();
}

/** :argile_is_operator <nat ch>: -> int **/
int argile_is_operator(unsigned int ch)
{
  argrt_list_t * lr;

  lr = (argile).op_ranges;
  for (; (lr); lr = ((argrt_list_t *)lr)->next) {
    unsigned int(* r);

    r = *((unsigned int(* *))&((argrt_list_t *)lr)->data);
    if ((ch < (r)[0])) {
      return 0;
    }
    if ((ch <= (r)[1])) {
      return 1;
    }
  };
  return 0;
}

/** :argile_add_operators <nat a> <nat b>: -> nothing **/
void argile_add_operators(unsigned int a_2, unsigned int b_2)
{
  if ((b_2 == 0)) {
    b_2 = a_2;
  }
  if ((b_2 < a_2)) {
    unsigned int c_2 = 0;

    c_2 = a_2;
    a_2 = b_2;
    b_2 = c_2;
  }
  if (((argile).op_ranges)) {
    unsigned int(* r);
    argrt_list_t * lr;
    argrt_list_t * nr;

    for (lr = (argile).op_ranges; (lr); lr = nr) {
      r = *((unsigned int(* *))&((argrt_list_t *)lr)->data);
      nr = ((argrt_list_t *)lr)->next;
      if ((a_2 < (r)[0])) {
        if ((((r)[0] != 0) && (b_2 < ((r)[0] - 1)))) {
          argrt_list_t * lnu;

          lnu = new_range(a_2, b_2);
          if ((((argrt_list_t *)lr)->prev)) {
            argrt_list_link(((argrt_list_t *)lr)->prev, lnu);
          }
          else {
            (argile).op_ranges = lnu;
          }
          argrt_list_link(lnu, lr);
          break;
        }
        (r)[0] = a_2;
        if ((b_2 <= (r)[1])) {
          break;
        }
        (r)[1] = b_2;
        if ((nr == ((argrt_list_t *)0))) {
          break;
        }
        argrt_list_remove(&(argile).op_ranges, lr);
        argrt_list_delete_all(lr);
      }
      else if ((a_2 <= ((r)[1] + 1))) {
        if ((b_2 <= (r)[1])) {
          break;
        }
        (r)[1] = b_2;
        if ((nr == ((argrt_list_t *)0))) {
          break;
        }
        a_2 = (r)[0];
        argrt_list_remove(&(argile).op_ranges, lr);
        argrt_list_delete_all(lr);
      }
    };
    if (((lr == ((argrt_list_t *)0)) && (a_2 > (r)[1]))) {
      argrt_list_link(argrt_list_end((argile).op_ranges), new_range(a_2, b_2));
    }
  }
  else {
    (argile).op_ranges = new_range(a_2, b_2);
  }
}

/** :argile_remove_operators <nat a> <nat b>: -> nothing **/
void argile_remove_operators(unsigned int a_3, unsigned int b_3)
{
  argrt_list_t * lr;
  argrt_list_t * nr;

  if ((b_3 == 0)) {
    b_3 = a_3;
  }
  if ((a_3 > b_3)) {
    unsigned int c_2 = 0;

    c_2 = a_3;
    a_3 = b_3;
    b_3 = c_2;
  }
  for (lr = (argile).op_ranges; (lr != ((argrt_list_t *)0)); lr = nr) {
    unsigned int(* r);

    nr = ((argrt_list_t *)lr)->next;
    r = *((unsigned int(* *))&((argrt_list_t *)lr)->data);
    if ((b_3 < (r)[0])) {
      break;
    }
    if ((a_3 > (r)[1])) {
      continue;
    }
    if ((r)[0] < a_3 && a_3 <= (r)[1] && (r)[1] <= b_3) {
      (r)[1] = (a_3 - 1);
      continue;
    }
    if (a_3 <= (r)[0] && (r)[0] <= b_3 && b_3 < (r)[1]) {
      (r)[0] = (b_3 + 1);
      continue;
    }
    if (((a_3 <= (r)[0]) && ((r)[1] <= b_3))) {
      argrt_list_remove(&(argile).op_ranges, lr);
      argrt_list_delete_all(lr);
      continue;
    }
    if ((((r)[0] < a_3) && (b_3 < (r)[1]))) {
      unsigned int(* r2);
      argrt_list_t * lr2;

      r2 = ((unsigned int(*))memset(ARGRT_malloc((2 * sizeof(unsigned int))), 0, (2 * sizeof(unsigned int))));
      (r2)[0] = (b_3 + 1);
      (r2)[1] = (r)[1];
      (r)[1] = (a_3 - 1);
      lr2 = argrt_list_new(((void *)((long)r2)), &ARGRT_free);
      argrt_list_link(lr, lr2);
      argrt_list_link(lr2, nr);
      continue;
    }
  };
}

/** :argile_find_def <text mod> <text bnd> <text opt> <int err>: -> (argile) def **/
argile_def_t * argile_find_def(char * mod_2, char * bnd, char * opt_2, int err)
{
  argile_module_t * m_2 = ((argile_module_t *)0);
  argile_bind_t * b_4 = ((argile_bind_t *)0);
  unsigned char o;
  argile_code_t * c_2 = ((argile_code_t *)0);

  m_2 = argile_getmod(mod_2);
  if ((m_2 == ((argile_module_t *)0))) {
    if ((err != 0)) {
      argile_die("module '%s' not found", mod_2);
    }
    return ((argile_def_t *)0);
  }
  b_4 = argile_module_getbind(m_2, bnd);
  if ((b_4 == ((argile_bind_t *)0))) {
    if ((err)) {
      argile_die("binding '%s' not found in module '%s'", bnd, mod_2);
    }
    return ((argile_def_t *)0);
  }
  o = 0;
  for (c_2 = (argile).main; (c_2); c_2 = (c_2)->upper) {
    argrt_list_t * ld;

    ld = (c_2)->defs;
    for (; (ld); ld = ((argrt_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind == b_4))) {
        if (((opt_2 == (char *)0) || ((opt_2)[0] == 0))) {
          if (((d)->options == ((argrt_list_t *)0))) {
            return d;
          }
        }
        else if ((argile_def_has_option(d, opt_2))) {
          return d;
        }
        o = 1;
      }
    };
  };
  if ((err)) {
    if (o) {
      argile_die("binding '%s' in module '%s' not defined with option '%s'\n  (did you forget to use std ?)", bnd, mod_2, opt_2);
    }
    else {
      argile_die("binding '%s' in module '%s' found, but not defined", bnd, mod_2);
    }
  }
  return ((argile_def_t *)0);
}

/** :argile_find_all_autoparams: -> nothing **/
void argile_find_all_autoparams()
{
  argrt_list_t * ldef;

  if (((argile).main == ((argile_code_t *)0))) {
    return;
  }
  ldef = ((argile).main)->defs;
  for (; (ldef); ldef = ((argrt_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argrt_list_t *)ldef)->data);
    if ((((d)->dtype == ARGILE_DEF_FUNC) && (((d)->dval).code))) {
      unsigned char loop;

      loop = 1;
      while (loop) {
        loop = argile_code_find_autoparams(((d)->dval).code);
      };
    }
  };
}

/** :argile_add_gstats: -> nothing **/
void argile_add_gstats()
{
  ((argile).gstat).rejsize += ((argile).stat).rejsize;
  ((argile).gstat).rejmaxsize += ((argile).stat).rejmaxsize;
  ((argile).gstat).hitsize += ((argile).stat).hitsize;
  ((argile).gstat).num_match_eq += ((argile).stat).num_match_eq;
  ((argile).gstat).num_match_try += ((argile).stat).num_match_try;
  ((argile).gstat).num_call_compile_as += ((argile).stat).num_call_compile_as;
  ((argile).gstat).vars += ((argile).stat).vars;
  ((argile).gstat).params += ((argile).stat).params;
  ((argile).gstat).funcs += ((argile).stat).funcs;
  ((argile).gstat).macros += ((argile).stat).macros;
  ((argile).gstat).Cmacros += ((argile).stat).Cmacros;
  ((argile).gstat).binds += ((argile).stat).binds;
}

/** :<argile code c> is not included: -> bool **/
static unsigned char is_not_included(argile_code_t * c_2)
{
  argrt_list_t * cur;

  for (cur = (argile).used; (cur); cur = ((argrt_list_t *)cur)->next) {
    if (((*((argile_file_t * *)&((argrt_list_t *)cur)->data))->code == c_2)) {
      return 0;
    }
  };
  return 1;
}

/** :<pos a> > <pos b>: -> bool **/
static unsigned char argile_pos_superior_argile_pos(argile_pos_t * a_4, argile_pos_t * b_4)
{
  if (((a_4)->row == (b_4)->row)) {
    return ((a_4)->col > (b_4)->col);
  }
  return ((a_4)->row > (b_4)->row);
}

/** :<comment c>: -> nothing **/
static void comment(comment_t * c_3)
{
  if (((c_3)->txt)) {
    ARGRT_free((c_3)->txt);
  }
  ARGRT_free(c_3);
}

/** :print define: -> nothing **/
static void print_define(argile_file_t * * file, int * size, char * * name)
{
  argile_output("_", 1);
  argile_output(*name, *size);
  argile_puts("_HEADER_");
  if ((*file)) {
    argile_printf("_device_%lu_inode_%lu_", ((unsigned long)(*file)->device), ((unsigned long)(*file)->inode));
  }
}

/** :get word size of <text t>: -> int **/
static int get_word_size_of(char * t_5)
{
  int size_2 = 0;

  while (((((((t_5)[0] >= 'a') && ((t_5)[0] <= 'z')) || (((t_5)[0] >= 'A') && ((t_5)[0] <= 'Z'))) || (((t_5)[0] >= '0') && ((t_5)[0] <= '9'))) || ((t_5)[0] == '_'))) {
    (size_2)++;
    (t_5)++;
  };
  return size_2;
}

/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
static void write_ref_or_raw_in_with(argile_buff_t * tb, argile_buff_t * out_3, argile_def_t * d, char * name_5)
{
  if ((d)) {
    argile_syntax_module_call((d)->syntax, tb, (char *)0, ((argrt_list_t *)0), out_3);
  }
  else {
    argile_buff_puts(out_3, name_5);
    argile_buff_puts(out_3, " (");
    argile_buff_cat(out_3, tb);
    argile_buff_putc(out_3, (")")[0]);
  }
}

/** :add include <text p>: -> nothing **/
static void add_include(char * p)
{
  int n_3 = 0;
  char * h = "";
  int e = 0;

  n_3 = strlen(p);
  h = ((char *)ARGRT_malloc((n_3 + 3)));
  memcpy(h, p, n_3);
  if (((e = ends_by(p, n_3, ".arg")) || (e = ends_by(p, n_3, ".argl")))) {
    memcpy(((((h) + n_3)) - e), ".h", 3);
  }
  else {
    memcpy(((h) + n_3), ".h", 3);
  }
  if ((argrt_list_search((argile).includes, h, (void *)&argile_streq))) {
    ARGRT_free(h);
  }
  else {
    argrt_list_prepend(&(argile).includes, argrt_list_new(((void *)((long)h)), &ARGRT_free));
  }
}

/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
static argile_file_t * try_in_dir(char * path_3, int plen, char * dir, int dlen)
{
  int trysize = 0;
  char * trypath = "";
  int end_2 = 0;
  struct stat st = ((struct stat){0});

  trysize = ((dlen + 1) + plen);
  trypath = ((char *)ARGRT_malloc(trysize));
  memcpy(trypath, dir, dlen);
  snprintf(((trypath) + dlen), (trysize - dlen), "/%s", path_3);
  strip_useless_slashes_in(trypath);
  end_2 = strlen(trypath);
  if (doesn_t_end_by_ext(path_3)) {
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".argl");
    if (((cached_stat(trypath, &st) == 0) && !(S_ISDIR((st).st_mode)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);
      time_t time;

      file_2 = argile_file_new(trypath, &st);
      time = (st).st_mtime;
      snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
      if (((stat(trypath, &st) == 0) && !(S_ISDIR((st).st_mode)))) {
        argile_file_t * srcfile = ((argile_file_t *)0);

        srcfile = argile_file_new(trypath, &st);
        if (time<(st).st_mtime) {
          if (!((argrt_list_search((argile).file_warns, (file_2)->path, (void *)&argile_streq)))) {
            argrt_list_prepend(&(argile).file_warns, argrt_list_new(((void *)((long)ARGRT_strdup((file_2)->path))), &ARGRT_free));
            fprintf(stderr, "%s: warning: %s is ignored (older than %s)\n", "arc", (file_2)->path, trypath);
          }
          argile_file_del(file_2);
          ARGRT_free(trypath);
          return srcfile;
        }
        if ((argile_file_eq(srcfile, (argile).main_file))) {
          argile_file_del(file_2);
          ARGRT_free(trypath);
          return srcfile;
        }
        argile_file_del(srcfile);
        (file_2)->derived = 1;
      }
      ARGRT_free(trypath);
      return file_2;
    }
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
    if (((stat(trypath, &st) == 0) && !(S_ISDIR((st).st_mode)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);

      file_2 = argile_file_new(trypath, &st);
      ARGRT_free(trypath);
      return file_2;
    }
  }
  (trypath)[end_2] = '\0';
  if (((stat(trypath, &st) == 0) && !(S_ISDIR((st).st_mode)))) {
    argile_file_t * file_2 = ((argile_file_t *)0);

    file_2 = argile_file_new(trypath, &st);
    ARGRT_free(trypath);
    return file_2;
  }
  ARGRT_free(trypath);
  return ((argile_file_t *)0);
}

/** :strip useless slashes in <text s>: -> nothing **/
static void strip_useless_slashes_in(char * s_2)
{
  while (((s_2)[0] != 0)) {
    if (((s_2)[0] == '/')) {
      int x = 0;

      if (!((strncmp(((s_2) + 1), "./", 2)))) {
        x = 3;
        while (!((strncmp(((s_2) + x), "./", 2)))) {
          x += 2;
        };
        reduce(((s_2) + 1), ((s_2) + x));
      }
      else {
        x = 1;
        while (((s_2)[x] == '/')) {
          (x)++;
        };
        reduce(((s_2) + 1), ((s_2) + x));
      }
    }
    (s_2)++;
  };
}

/** :<text str> doesn ' t end by ext: -> bool **/
static unsigned char doesn_t_end_by_ext(char * str_3)
{
  int elen = 0;
  int llen = 0;
  int slen = 0;

  elen = strlen(".arg");
  llen = strlen(".argl");
  slen = strlen(str_3);
  if (((slen > elen) && (strcmp(".arg", ((str_3) + (slen - elen))) == 0))) {
    return 0;
  }
  if (((slen > llen) && (strcmp(".argl", ((str_3) + (slen - llen))) == 0))) {
    return 0;
  }
  return 1;
}

/** :cached - stat <text p> <stat st>: -> int **/
static int cached_stat(char * p_2, struct stat * st_2)
{
  int r = 0;

  if ((argrt_list_search((argile).stat_fails, p_2, (void *)&argile_streq))) {
    return -1;
  }
  r = stat(p_2, st_2);
  if ((r != 0)) {
    argrt_list_prepend(&(argile).stat_fails, argrt_list_new(((void *)((long)ARGRT_strdup(p_2))), &ARGRT_free));
  }
  return r;
}

/** :reduce <text d> <text s>: -> nothing **/
static void reduce(char * d_2, char * s_3)
{
  while (((s_3)[0] != 0)) {
    ((d_2)++)[0] = ((s_3)++)[0];
  };
  (d_2)[0] = (s_3)[0];
}

/** :id end num <text s> <nat n> <(int) & num>: -> int **/
static int id_end_num(char * s_4, unsigned int n_3, int * num_2)
{
  int i_2 = 0;
  int u = -1;
  char c_4;

  for (i_2 = 0; (i_2 < n_3); (i_2)++) {
    if (((s_4)[i_2] == '_')) {
      u = i_2;
    }
  };
  if (((u <= 0) || ((s_4)[(u + 1)] == 0))) {
    return (n_3 - 1);
  }
  for (i_2 = (u + 1); (c_4 = (s_4)[i_2]); (i_2)++) {
    if (((c_4 < '0') || (c_4 > '9'))) {
      return (n_3 - 1);
    }
  };
  *num_2 = atoi(((s_4) + (u + 1)));
  return u;
}

/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void check_id_num(argile_buff_t * b_5, char * id, unsigned char * found_2, int * min_2, int * max_2)
{
  int i_2 = 0;

  i_2 = ((b_5)->len - 1);
  if (((id) && !((strncmp(id, (b_5)->ptr, i_2))))) {
    if (((id)[i_2] == 0)) {
      *found_2 = 1;
    }
    else if (((id)[i_2] == '_')) {
      do {
        (i_2)++;
      } while ((((id)[i_2] >= '0') && ((id)[i_2] <= '9')));
      if (((id)[i_2] == 0)) {
        i_2 = atoi(((id) + (b_5)->len));
        if ((i_2 > *max_2)) {
          *max_2 = i_2;
        }
        if (((*min_2 < 0) || (i_2 < *min_2))) {
          *min_2 = i_2;
        }
      }
    }
  }
}

/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void check_call_id_num(argile_call_t * p_argile_call, argile_buff_t * b_6, unsigned char * found_3, int * min_3, int * max_3)
{
  argrt_list_t * lm;

  for (lm = (p_argile_call)->match; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = ((argile_match_t *)*((argile_match_t * *)&((argrt_list_t *)lm)->data));
    if ((m_2 == ((argile_match_t *)0))) {
      continue;
    }
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      check_call_id_num(((m_2)->value).call, b_6, found_3, min_3, max_3);
    }
    else if (((m_2)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * cons = ((argile_cons_t *)0);

      cons = ((m_2)->value).cons;
      if (((cons)->ctype == ARGILE_CONS_CODE)) {
        check_id_num(b_6, (((cons)->cvalue).code)->anon, found_3, min_3, max_3);
      }
    }
  };
}

/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
static void search_in_with(argrt_list_t * syn, argile_code_t * code_3, void (* callback_2)(argile_def_t *))
{
  argrt_list_t * ld;
  argrt_list_t * lc;

  ld = (code_3)->defs;
  for (; (ld); ld = ((argrt_list_t *)ld)->next) {
    argile_def_t * d_3 = ((argile_def_t *)0);

    d_3 = *((argile_def_t * *)&((argrt_list_t *)ld)->data);
    if (((d_3)->maker == ((argile_call_t *)0))) {
      continue;
    }
    if ((argile_syntax_match((d_3)->syntax, syn))) {
      (*callback_2)(d_3);
    }
  };
  lc = (code_3)->calls;
  for (; (lc); lc = ((argrt_list_t *)lc)->next) {
    search_in_with_2(syn, *((argile_call_t * *)&((argrt_list_t *)lc)->data), callback_2);
  };
}

/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
static void search_in_with_2(argrt_list_t * syn_2, argile_call_t * p_argile_call_2, void (* callback_3)(argile_def_t *))
{
  argrt_list_t * lm;

  lm = (p_argile_call_2)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if ((m_2 == ((argile_match_t *)0))) {
      continue;
    }
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      search_in_with_2(syn_2, ((m_2)->value).call, callback_3);
    }
    else if ((((m_2)->type == ARGILE_MATCH_CONS) && ((((m_2)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      search_in_with(syn_2, ((((m_2)->value).cons)->cvalue).code, callback_3);
    }
  };
}

/** :split op <text str> <int len> <int optoken>: -> nothing **/
static void split_op(char * str_4, int len_5, int optoken)
{
  char * cpy = "";

  cpy = ((char *)ARGRT_malloc((len_5 + 1)));
  argile_add_leak(cpy);
  memcpy(cpy, str_4, len_5);
  (cpy)[len_5] = '\0';
  argile_push_op(cpy);
  argile_push_optoken(optoken);
}

/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/
static argrt_list_t * new_range(unsigned int a_5, unsigned int b_7)
{
  unsigned int(* r);

  r = ((unsigned int(*))memset(ARGRT_malloc((2 * sizeof(unsigned int))), 0, (2 * sizeof(unsigned int))));
  (r)[0] = a_5;
  (r)[1] = b_7;
  return argrt_list_new(((void *)((long)r)), &ARGRT_free);
}

