// generated by: arc -xuNP -A ./../argrt -o arc.c -H arc.h -m arc.argl.tmp arc.arg 
#define _GNU_SOURCE //;
#include <getopt.h> //;

#include "arc.h"

typedef struct modbind_t_s modbind_t;

struct modbind_t_s {
  argile_module_t * module;
  argile_bind_t * bind;
};

/** :add path <text path> (- - free): -> nothing **/
static void add_path_free(char *, char opt1);
/** :add inc path <text path> (- - free): -> nothing **/
static void add_inc_path_free(char *, char opt1);
/** :check <int i> is positive: -> nothing **/
static void check_is_positive(char * * oname, int);
/** :check <text t> is a number: -> nothing **/
static void check_is_a_number(char *);
/** :split <text v> into <(list) & tail> (and rewind): -> nothing **/
static void split_into_and_rewind(char *, argrt_list_t * *, char opt1);
/** :mystrndup <text t> <int size>: -> text **/
static char * mystrndup(char *, int);
/** :parse op range in <text>: -> nothing **/
static void parse_op_range_in(char *);
/** :make implicit binds: -> bool **/
static unsigned char make_implicit_binds();
/** :print command line in <FILE f>: -> nothing **/
static void print_command_line_in(FILE *);
/** :print bind doc <module mod> <bind bnd>: -> nothing **/
static void print_bind_doc(argile_module_t *, argile_bind_t *);
/** :bindcmp <modbind a> <modbind b>: -> int **/
static int bindcmp(modbind_t *, modbind_t *);
/** :<def>: -> nothing **/
static void argile_def_2(argile_def_t *);
/** :<text file> <int fs> has ext <text ext> <int es>: -> bool **/
static unsigned char has_ext(char *, int, char *, int);
/** :print rejects <call> <int count>: -> int **/
static int print_rejects(argile_call_t *, int);

char * filename = (char *)0;
char * output = (char *)0;
char * module = (char *)0;
char * line = (char *)0;
char * deps = (char *)0;
char * head = (char *)0;
char * grep = (char *)0;
int colpertab = -1;
int maxmatch = -1;
int maxcomp = -1;
int maxgen = -1;
int maxrejt = -1;
unsigned char nocolors;
unsigned char noautouse;
unsigned char dump_mode;
unsigned char dump_indent;
unsigned char verbose;
unsigned char do_main;
unsigned char concat;
unsigned char stats;
unsigned char debugcomp;
unsigned int genlines = 0;
unsigned char daltonism;
unsigned char utf8;
unsigned char hexastr;
unsigned char proto_syntax;
unsigned char show_progress;
char * ops_file = (char *)0;
argrt_list_t * file_path = ((argrt_list_t *)0);
argrt_list_t * env_path = ((argrt_list_t *)0);
argrt_list_t * auto_use = ((argrt_list_t *)0);
argrt_list_t * mod_docs = ((argrt_list_t *)0);
argrt_list_t * arg_opts = ((argrt_list_t *)0);
argrt_list_t * sys_inc_path = ((argrt_list_t *)0);
void * firstbrk = NULL;
char *(* global_argv);
int global_argc = 0;
int errorCode = 0;

static argrt_list_t * first_path = ((argrt_list_t *)0);

static argrt_list_t * first_path_2 = ((argrt_list_t *)0);

static argrt_list_t * binds = ((argrt_list_t *)0);

/** :vmessage <text msg> [...]: -> nothing **/
void vmessage(char * msg, ...)
{
  va_list vargs;

  if (!(verbose)) {
    return;
  }
  fprintf(stderr, " * ");
  if ((((msg)[0] >= 'a') && ((msg)[0] <= 'z'))) {
    fprintf(stderr, "%c", (((msg)++)[0] + ('A' - 'a')));
  }
  va_start(vargs, msg);
  vfprintf(stderr, msg, vargs);
  va_end(vargs);
  fprintf(stderr, "...\n");
}

/** :complete file path: -> nothing **/
void complete_file_path()
{
  char( dir[512]);
  char * var = "";

  if ((env_path != ((argrt_list_t *)0))) {
    if ((file_path != ((argrt_list_t *)0))) {
      argrt_list_link(file_path, env_path);
      file_path = argrt_list_start(file_path);
    } else {
      file_path = env_path;
    }
    return;
  }
  add_path_free(".", 0);
  if (((var = ((char *)getenv("HOME"))))) {
    snprintf(((char *)dir), sizeof(dir), "%s/include/argile/argrt", var);
    add_path_free(ARGRT_strdup(((char *)dir)), 1);
    snprintf(((char *)dir), sizeof(dir), "%s/include/argile", var);
    add_path_free(ARGRT_strdup(((char *)dir)), 1);
  }
  snprintf(((char *)dir), sizeof(dir), "%s/argrt", PKGINCLUDEDIR);
  add_path_free(ARGRT_strdup(((char *)dir)), 1);
  add_path_free(ARGRT_strdup(((char *)PKGINCLUDEDIR)), 1);
  file_path = argrt_list_start(file_path);
}

/** :add path <text path> (- - free): -> nothing **/
static void add_path_free(char * path, char opt1)
{
  if ((first_path == ((argrt_list_t *)0))) {
    first_path = file_path;
  }
  if ((argrt_list_search(first_path, path, (void *)&argile_streq))) {
    if ((opt1 != 0)) {
      ARGRT_free(path);
    }
  } else {
    argrt_list_append(&file_path, argrt_list_new(((void *)((long)path)), (((opt1 != 0)) ? (&ARGRT_free) : (((argile_deleter_t)0)))));
  }
}

/** :complete sys inc path: -> nothing **/
void complete_sys_inc_path()
{
  char( dirbuf[512]);
  char * slash = "";

  snprintf(((char *)dirbuf), sizeof(dirbuf), "%s", PKGINCLUDEDIR);
  slash = strrchr(((char *)dirbuf), '/');
  if ((slash == (char *)0)) {
    return;
  }
  if (((strcmp(slash, "/argile") == 0) || (strcmp(slash, "/argile/") == 0))) {
    (slash)[0] = '\0';
  }
  add_inc_path_free(ARGRT_strdup(((char *)dirbuf)), 1);
  sys_inc_path = argrt_list_start(sys_inc_path);
}

/** :add inc path <text path> (- - free): -> nothing **/
static void add_inc_path_free(char * path_2, char opt1)
{
  if ((argile).verbose) {
    fprintf(stderr, "   adding include path %s\n", path_2);
  }
  if ((first_path_2 == ((argrt_list_t *)0))) {
    first_path_2 = sys_inc_path;
  }
  if ((argrt_list_search(first_path_2, path_2, (void *)&argile_streq))) {
    if ((opt1 != 0)) {
      ARGRT_free(path_2);
    }
  } else {
    argrt_list_append(&sys_inc_path, argrt_list_new(((void *)((long)path_2)), (((opt1 != 0)) ? (&ARGRT_free) : (((argile_deleter_t)0)))));
  }
}

/** :parse options <int c> <array of (text) v>: -> nothing **/
void parse_options(int c, char *(* v))
{
  struct option(* opts) = (struct option[]){{"max-match-rec", required_argument, NULL, 'a'}, {"add-dir", required_argument, NULL, 'A'}, {"bind-doc", required_argument, NULL, 'b'}, {"double-source-lines", no_argument, NULL, 'B'}, {"max-comp-rec", required_argument, NULL, 'c'}, {"concat", no_argument, NULL, 'C'}, {"dump", no_argument, NULL, 'd'}, {"debug-comp", no_argument, NULL, 'D'}, {"env-help", no_argument, NULL, 'e'}, {"max-gen-rec", required_argument, NULL, 'g'}, {"get-defs", required_argument, NULL, 'G'}, {"help", no_argument, NULL, 'h'}, {"header", required_argument, NULL, 'H'}, {"indent", no_argument, NULL, 'i'}, {"include-dir", required_argument, NULL, 'I'}, {"line", required_argument, NULL, 'l'}, {"source-lines", no_argument, NULL, 'L'}, {"module", required_argument, NULL, 'm'}, {"no-main", no_argument, NULL, 'M'}, {"no-color", no_argument, NULL, 'n'}, {"no-auto-use", no_argument, NULL, 'N'}, {"output", required_argument, NULL, 'o'}, {"operators", required_argument, NULL, 'O'}, {"deps", required_argument, NULL, 'p'}, {"proto-syntax", no_argument, NULL, 'P'}, {"max-rejects", required_argument, NULL, 'r'}, {"show-progress", no_argument, NULL, 'R'}, {"stats", no_argument, NULL, 'S'}, {"col-per-tab", required_argument, NULL, 't'}, {"daltonism", no_argument, NULL, 'T'}, {"utf8", no_argument, NULL, 'u'}, {"use", required_argument, NULL, 'U'}, {"verbose", no_argument, NULL, 'v'}, {"version", no_argument, NULL, 'V'}, {"hexa-string", no_argument, NULL, 'x'}, {"extract-operators", no_argument, NULL, 'X'}, {NULL, 0, NULL, 0}};
  char * shorts = "a:A:b:Bc:CdDeg:G:hH:iI:l:Lm:MnNo:O:p:Pr:RSt:TuU:vVxX";
  int curopt = 0;
  int opt = 0;
  int id = 0;

  curopt = optind;
  opterr = 0;
  while (((opt = getopt_long(c, v, shorts, opts, &id)) != -1)) {
    char * oname = (char *)0;
    int i = 0;

    while (!((((char *)((opts)[i]).name) == (char *)0))) {
      if ((((opts)[i]).val == opt)) {
        oname = ((char *)((opts)[i]).name);
        break;
      }
      (i)++;
    };
    if ((oname != (char *)0)) {
      argrt_list_append(&arg_opts, argrt_list_new(((void *)((long)oname)), ((argile_deleter_t)0)));
      argrt_list_append(&arg_opts, argrt_list_new(((void *)((long)(((optarg)) ? (optarg) : ("")))), ((argile_deleter_t)0)));
    }
    switch (opt) {
      case 'a': {
        check_is_a_number(optarg);
        maxmatch = atoi(optarg);
        check_is_positive(&oname, maxmatch);
      } break;
      case 'A': {
        add_path_free(optarg, 0);
      } break;
      case 'b': {
        argrt_list_append(&mod_docs, argrt_list_new(((void *)((long)optarg)), ((argile_deleter_t)0)));
      } break;
      case 'B': {
        genlines = 2;
      } break;
      case 'c': {
        check_is_a_number(optarg);
        maxcomp = atoi(optarg);
        check_is_positive(&oname, maxcomp);
      } break;
      case 'C': {
        concat = 1;
      } break;
      case 'd': {
        dump_mode = 1;
      } break;
      case 'D': {
        debugcomp = 1;
      } break;
      case 'e': {
        char path_separator;

        path_separator = (":")[0];
        
#ifdef WIN32
        path_separator = (";")[0];
        
#endif
        fprintf(stderr, "Environment variables help:\nARGILE_AUTO_USE      : list of  files separated by '%c' (see --use)\nARGILE_COLOR         : 0 or 1 (opposite of --no-color)\nARGILE_COLPERTAB     : integer (see --col-per-tab)\nARGILE_DALTONISM     : 0 or 1 (see --daltonism)\nARGILE_FILE_PATH     : list of pathes separated by '%c' (see --add-dir)\nARGILE_HEXASTR       : 0 or 1 (see --hexa-string)\nARGILE_INDENT_STYLE  : 0 or 1 (see --indent)\nARGILE_LINENUMS      : 0, 1 or 2 (see --source-lines and --double-source-lines)\nARGILE_MAXCOMP       : integer (see --max-comp-rec)\nARGILE_MAXGEN        : integer (see --max-gen-rec)\nARGILE_MAXMATCH      : integer (see --max-match-rec)\nARGILE_MAXREJECTS    : integer (see --max-rejects)\nARGILE_OPERATORS_FILE: (see --operators and --extract-operators)\nARGILE_OPERATORS     : string of additional operator characters (or ranges)\n                       (ex: \"!#-'*-/<-@[-`|~\" : '-' sign delimits a range;\n                        so  \"<-@\" means from '<' character to '@')\nARGILE_UTF8          : 0 or 1 (see --utf8)\nHOME                 : when no ARGILE_FILE_PATH is set, $HOME/include/argile/\n                       $HOME/include/argile/argrt/ , /usr/include/argile/ ,\n                       /usr/include/argile/argrt/ and `./'\n                       are also added to the file path.\n", path_separator, path_separator);
        exit(0);
      } break;
      case 'g': {
        check_is_a_number(optarg);
        maxgen = atoi(optarg);
        check_is_positive(&oname, maxgen);
      } break;
      case 'G': {
        grep = optarg;
      } break;
      case 'H': {
        head = optarg;
      } break;
      case 'i': {
        dump_indent = 1;
      } break;
      case 'I': {
        add_inc_path_free(optarg, 0);
      } break;
      case 'l': {
        line = optarg;
      } break;
      case 'L': {
        genlines = 1;
      } break;
      case 'm': {
        module = optarg;
      } break;
      case 'M': {
        do_main = 0;
      } break;
      case 'n': {
        nocolors = 1;
      } break;
      case 'N': {
        noautouse = 1;
      } break;
      case 'o': {
        output = optarg;
      } break;
      case 'O': {
        ops_file = optarg;
      } break;
      case 'p': {
        deps = optarg;
      } break;
      case 'P': {
        proto_syntax = 1;
      } break;
      case 'r': {
        check_is_a_number(optarg);
        maxrejt = atoi(optarg);
        check_is_positive(&oname, maxrejt);
      } break;
      case 'R': {
        show_progress = 1;
      } break;
      case 'S': {
        stats = 1;
      } break;
      case 't': {
        check_is_a_number(optarg);
        colpertab = atoi(optarg);
        check_is_positive(&oname, colpertab);
      } break;
      case 'T': {
        daltonism = 1;
      } break;
      case 'u': {
        utf8 = 1;
      } break;
      case 'U': {
        argrt_list_append(&auto_use, argrt_list_new(((void *)((long)optarg)), ((argile_deleter_t)0)));
      } break;
      case 'v': {
        verbose = 1;
      } break;
      case 'V': {
        printf("%s (Argile Compiler) version %s\nCopyright (C) 2009,2010,2011,2014 the Argile authors\n(see the AUTHORS file distributed along with this software).\nThis is free software; see the source for copying conditions.  There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\n", "arc", VERSION);
        exit(0);
      } break;
      case 'x': {
        hexastr = 1;
      } break;
      case 'X': {
        printf("%s\n", argile_default_operators);
        exit(0);
      } break;
      case 'h': ;
      case '?': ;
      default: {
        fprintf(stderr, "Usage: %s [options...] [--] [file]\nOptions help:\n-a --max-match-rec <max> : Limit syntax match depth; 0 = no limit (may take ages)\n                           (default is %d)\n-A --add-dir       <dir> : Add directory to file path list\n-b --bind-doc     <name> : Finds documentation of binding (e.g std/print)\n-B --double-source-lines : Generate line numbers of both argile and C sources\n-c --max-comp-rec  <max> : Limit compilation depth; 0 = no limit (may take ages)\n                           (default is %d)\n-C --concat              : Concatenate main codes in main function\n-d --dump                : Dump precompiled code on stdout\n-D --debug-comp          : Dump compilation process\n-e --env-help            : Show the environment variables help\n-g --max-gen-rec   <max> : Limit gencode depth; 0 = no limit (may crash)\n                           (default is %d)\n-G --get-defs   <syntax> : Get definitions matching syntax\n-h --help                : Show this help\n-H --header       <file> : Generate C Header in file\n-i --indent              : Code dumping is indentation-based\n-I --include-dir   <dir> : Add directory to system include path list\n-l --line <string>       : Parse string instead of file or stdin\n-L --source-lines        : Generate source line numbers for C preprocessor\n-m --module       <file> : Generate modularized argile header in file\n-M --no-main             : Generate NO main function\n-n --no-color            : Don't use colors (for errors and dumping)\n-N --no-auto-use         : Disable auto use file list\n-o --output       <file> : Generate C code in file instead of stdout\n-O --operators    <file> : Set extra operators file (see --extract-operators)\n                           (each line is 1 or 2 hexadecimal numbers: start end)\n-p --deps         <file> : Generate Makefile dependencies in file\n-P --proto-syntax        : Generate syntax comment for functions prototypes\n-r --max-rejects   <max> : Limit reject history; 0 = no limit\n                           (default is %d)\n-R --show-progress       : Show progress percentage during compilation\n-S --stats               : Print compilation statistics when dumping\n-t --col-per-tab  <cols> : Set number of columns per tabulation (default = %d)\n-T --daltonism           : Print symbols corresponding to colors (dumping)\n-u --utf8                : Use UTF-8 for column counting and $ARGILE_OPERATORS\n                           (this is the default)\n-U --use          <file> : Use file (preload)\n-v --verbose             : Print additional informations\n-V --version             : Show version information and exit\n-x --hexa-string         : Use hexadecimal sequences for non-ascii strings\n-X --extract-operators   : Get default extra operators file content\n", "arc", 500, 1000, 500, 5, 8);
        if ((opt == '?')) {
          fprintf(stderr, "Bad option '%s'\n", (v)[curopt]);
        }
        if ((opt == 'h')) {
          exit(0);
        }
        exit(1);
      } break;
    };
    curopt = optind;
  };
  filename = (v)[optind];
  c = (c - (optind + 1));
  v = (v + (optind + 1));
}

/** :parse environ: -> nothing **/
void parse_environ()
{
  char * v_2 = "";

  if ((!(noautouse) && (v_2 = ((char *)getenv("ARGILE_AUTO_USE"))))) {
    split_into_and_rewind(v_2, &auto_use, 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_COLOR")))) {
    nocolors = (atoi(v_2) == 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_COLPERTAB")))) {
    colpertab = atoi(v_2);
  }
  if ((v_2 = ((char *)getenv("ARGILE_DALTONISM")))) {
    daltonism = (atoi(v_2) != 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_FILE_PATH")))) {
    split_into_and_rewind(v_2, &env_path, 1);
  }
  if ((v_2 = ((char *)getenv("ARGILE_HEXASTR")))) {
    hexastr = (atoi(v_2) != 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_INDENT_STYLE")))) {
    dump_indent = (atoi(v_2) != 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_LINENUMS")))) {
    genlines = ((unsigned int)atoi(v_2));
  }
  if ((v_2 = ((char *)getenv("ARGILE_MAXCOMP")))) {
    maxcomp = atoi(v_2);
  }
  if ((v_2 = ((char *)getenv("ARGILE_MAXGEN")))) {
    maxgen = atoi(v_2);
  }
  if ((v_2 = ((char *)getenv("ARGILE_MAXMATCH")))) {
    maxmatch = atoi(v_2);
  }
  if ((v_2 = ((char *)getenv("ARGILE_MAXREJECTS")))) {
    maxrejt = atoi(v_2);
  }
  if ((v_2 = ((char *)getenv("ARGILE_UTF8")))) {
    utf8 = (atoi(v_2) != 0);
  }
  if ((v_2 = ((char *)getenv("ARGILE_OPERATORS_FILE")))) {
    ops_file = v_2;
  }
}

/** :parse environ after init: -> nothing **/
void parse_environ_after_init()
{
  char * v_2 = "";

  if (((v_2 = ((char *)getenv("ARGILE_OPERATORS"))))) {
    if (((argile).encoding)) {
      argile_decoder_t charat;
      argile_decoder_t charsize;
      unsigned int v0 = 0;
      int n = 0;

      charat = ((argile).encoding)->charat;
      charsize = ((argile).encoding)->charsize;
      n = strlen(v_2);
      while ((v0 = (*charat)(v_2, n))) {
        unsigned int n0 = 0;
        unsigned int n1 = 0;

        n0 = (*charsize)(v_2, n);
        n1 = (*charsize)(((v_2) + n0), (n - n0));
        if ((n1 > 0)) {
          unsigned int v1 = 0;

          n1 += n0;
          v1 = (*charat)(((v_2) + n0), (n - n0));
          if ((v1 == '-')) {
            unsigned int n2 = 0;

            n2 = (*charsize)(((v_2) + n1), (n - n1));
            if ((n2 > 0)) {
              unsigned int v2 = 0;

              n2 += n1;
              v2 = (*charat)(((v_2) + n1), (n - n1));
              if ((v2 != 0)) {
                argile_add_operators(v0, v2);
                v_2 = ((v_2) + n2);
                n -= n2;
                continue;
              }
            }
          }
        }
        argile_add_operators(v0, 0);
        if ((n0 == 0)) {
          break;
        }
        v_2 = ((v_2) + n0);
        n -= n0;
      };
    } else {
      while (((v_2)[0] != 0)) {
        if ((((v_2)[1] == '-') && ((v_2)[2] != 0))) {
          argile_add_operators(((v_2)[0] & 0xff), ((v_2)[2] & 0xff));
          v_2 = ((v_2) + 3);
          continue;
        }
        argile_add_operators(((v_2)[0] & 0xff), 0);
        (v_2)++;
      };
    }
  }
}

/** :compile <text file>: -> nothing **/
void compile(char * file)
{
  argile_init_std();
  if ((mod_docs)) {
    argrt_list_t * ld;

    vmessage("fetching embedded documentation");
    for (ld = mod_docs; (ld); ld = ((argrt_list_t *)ld)->next) {
      char * name = "";
      char * slash = "";

      name = *((char * *)&((argrt_list_t *)ld)->data);
      slash = strchr(name, '/');
      if ((slash != (char *)0)) {
        argile_module_t * mod = ((argile_module_t *)0);

        ((slash)++)[0] = '\0';
        mod = argile_getmod(name);
        if ((mod == ((argile_module_t *)0))) {
          fprintf(stderr, "%s: %s: module not found\n", "arc", name);
          continue;
        }
        if (((slash)[0] == '*')) {
          argrt_list_t * lb;

          for (lb = (mod)->binds; (lb); lb = ((argrt_list_t *)lb)->next) {
            print_bind_doc(mod, *((argile_bind_t * *)&((argrt_list_t *)lb)->data));
          };
        } else {
          argile_bind_t * bnd = ((argile_bind_t *)0);

          bnd = argile_module_getbind(mod, slash);
          if ((bnd == ((argile_bind_t *)0))) {
            fprintf(stderr, "%s: %s: bind not found in %s\n", "arc", slash, name);
            continue;
          }
          print_bind_doc(mod, bnd);
        }
      } else {
        argrt_list_t * lm;

        for (lm = (argile).mods; (lm); lm = ((argrt_list_t *)lm)->next) {
          argile_module_t * mod = ((argile_module_t *)0);
          argile_bind_t * bnd = ((argile_bind_t *)0);

          mod = *((argile_module_t * *)&((argrt_list_t *)lm)->data);
          bnd = argile_module_getbind(mod, name);
          if ((bnd != ((argile_bind_t *)0))) {
            print_bind_doc(mod, bnd);
          }
        };
      }
    };
    print_bind_doc(((argile_module_t *)0), ((argile_bind_t *)0));
    printf("==========================\n");
    return;
  }
  if ((ops_file)) {
    FILE * f;

    vmessage("loading operators file %s", ops_file);
    f = fopen(ops_file, "r");
    if ((f == ((FILE *)0))) {
      fprintf(stderr, "%s: %m\n", ops_file);
      return;
    }
    else {
      char( buff[64]);
      char * line_2 = "";

      line_2 = ((char *)buff);
      while (!((fgets(line_2, sizeof(buff), f) == (char *)0))) {
        parse_op_range_in(line_2);
      };
      fclose(f);
    }
  }
  else {
    char * p = "";

    p = argile_default_operators;
    while (((p)[0] != '\0')) {
      parse_op_range_in(p);
      while (!((((p)[0] == '\0') || ((p)[0] == '\n')))) {
        (p)++;
      };
      if (((p)[0] == '\0')) {
        break;
      }
      (p)++;
    };
  }
  if (make_implicit_binds()) {
    fprintf(stderr, "%s: implicit bindings error: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
    return;
  }
  (argile).deps_only = (((((deps) && !((grep))) && !((output))) && !((head))) && !((module)));
  (argile).main_only = (((((grep) && !((deps))) && !((output))) && !((head))) && !((module)));
  if (!(noautouse)) {
    argrt_list_t * lu;

    for (lu = auto_use; (lu); lu = ((argrt_list_t *)lu)->next) {
      char * au = "";
      argile_file_t * fp = ((argile_file_t *)0);

      au = *((char * *)&((argrt_list_t *)lu)->data);
      vmessage("preloading argile file %s", au);
      fp = argile_loadfile(au);
      if ((fp == ((argile_file_t *)0))) {
        fprintf(stderr, "%s: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
        return;
      }
      if (((argile).main == ((argile_code_t *)0))) {
        (argile).main = argile_code_new(((argile_code_t *)0), ((argrt_list_t *)0));
      }
      argile_code_include((argile).main, (fp)->code, 0);
    };
  }
  if ((line)) {
    vmessage("parsing string");
    (argile).input = (void *)&argile_input_string;
    (argile).input_name = "command line";
    if ((argile_parse(&line) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
      return;
    }
  } else if ((file)) {
    argile_file_t * f = ((argile_file_t *)0);

    vmessage("parsing %s", file);
    (argile).input = (void *)&argile_input_path;
    (argile).input_name = file;
    if ((argile_parse(file) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
      return;
    }
    f = argile_file_new(file, ((struct stat *)0));
    if (((f)->error != 0)) {
      argile_file_del(f);
    } else {
      (f)->code = (argile).main;
      argile_addfile(f);
      (argile).main_file = f;
    }
  } else {
    int fd = 0;

    vmessage("parsing standard input");
    (argile).input = (void *)&argile_input_fd;
    (argile).input_name = "standard input";
    if ((argile_parse(&fd) != 0)) {
      fprintf(stderr, "%s: parse error: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
      return;
    }
  }
  vmessage("compiling");
  argile_compile();
  if (dump_mode) {
    argile_buff_t code = ((argile_buff_t){0});

    vmessage("dumping");
    argile_code_string((argile).main, 0, &code);
    argile_buff_putc(&code, '\0');
    printf("%s", (code).ptr);
    ARGRT_free((code).ptr);
  }
  if ((grep)) {
    vmessage("searching syntax \"%s\"", grep);
    argile_search_defs(grep, (void *)&argile_def_2);
  }
  if (((!(dump_mode) && !((grep))) && !(((argile).error)))) {
    if (do_main) {
      argile_add_reserved("main");
    }
    if ((output)) {
      FILE * f;

      vmessage("generating C code");
      if (!(((f = fopen(output, "w"))))) {
        fprintf(stderr, "%s: %s: %m\n", "arc", output);
      }
      else {
        fprintf(f, "//");
        print_command_line_in(f);
        fprintf(f, "\n");
        (argile).output = (void *)&argile_output_file;
        (argile).output_data = f;
        (argile).output_name = output;
        (argile).output_line = 1;
        argile_gencode(head);
        (argile).output_data = NULL;
        fclose(f);
      }
    }
    else if (((!((module)) && !((deps))) && !((head)))) {
      vmessage("generating C code");
      argile_gencode((char *)0);
    }
    if ((head)) {
      FILE * f;

      vmessage("generating C header");
      if (!(((f = fopen(head, "w"))))) {
        fprintf(stderr, "%s: %s: %m\n", "arc", head);
      } else {
        fprintf(f, "//");
        print_command_line_in(f);
        fprintf(f, "\n");
        (argile).output = (void *)&argile_output_file;
        (argile).output_data = f;
        (argile).output_name = head;
        (argile).output_line = 1;
        argile_gen_header(head);
        (argile).output_data = NULL;
        fclose(f);
      }
    }
    if ((deps)) {
      FILE * f;

      vmessage("generating dependencies");
      if (((f = fopen(deps, "w")))) {
        int elen = 0;
        argrt_list_t * lf;

        elen = strlen(".argl");
        if ((output)) {
          fprintf(f, "%s ", output);
        }
        if ((head)) {
          fprintf(f, "%s ", head);
        }
        if ((module)) {
          fprintf(f, "%s ", module);
        }
        fprintf(f, ":");
        lf = (argile).used;
        for (; (lf); lf = ((argrt_list_t *)lf)->next) {
          argile_file_t * af = ((argile_file_t *)0);
          int plen = 0;

          af = *((argile_file_t * *)&((argrt_list_t *)lf)->data);
          plen = strlen((af)->path);
          if (((af)->derived && has_ext((af)->path, plen, ".argl", elen))) {
            fprintf(f, " ");
            fwrite((af)->path, (plen - elen), 1, f);
            fprintf(f, ".arg");
          } else {
            fprintf(f, " %s", (af)->path);
          }
        };
        fprintf(f, "\n");
        fclose(f);
      } else {
        fprintf(stderr, "%s: %s: %m\n", "arc", deps);
      }
    }
    if ((module)) {
      FILE * f;

      vmessage("modularizing");
      if (((f = fopen(module, "w")))) {
        fprintf(f, "(:");
        print_command_line_in(f);
        fprintf(f, ":)\n");
        argile_gen_module(f);
        fclose(f);
      } else {
        fprintf(stderr, "%s: %s: %m\n", "arc", module);
      }
    }
  }
  if (show_progress) {
    fprintf(stderr, "\n");
  }
  if (stats) {
    printf("%s%u%s%u\n", "   - Variables               ", (&(argile).stat)->vars, " / ", (&(argile).gstat)->vars);
    printf("%s%u%s%u\n", "   - Parameters_____________ ", (&(argile).stat)->params, " / ", (&(argile).gstat)->params);
    printf("%s%u%s%u\n", "   - Functions               ", (&(argile).stat)->funcs, " / ", (&(argile).gstat)->funcs);
    printf("%s%u%s%u\n", "   - Macros_________________ ", (&(argile).stat)->macros, " / ", (&(argile).gstat)->macros);
    printf("%s%u%s%u\n", "   - C-Macros                ", (&(argile).stat)->Cmacros, " / ", (&(argile).gstat)->Cmacros);
    printf("%s%u%s%u\n", "   - Bindings_______________ ", (&(argile).stat)->binds, " / ", (&(argile).gstat)->binds);
    printf("%s%i\n", "   - Types                   ", (argile).next_type);
    printf("%s%i\n", "   - Files used_____________ ", ((int)argrt_list_count((argile).used)));
    printf("%s%u%s%u\n", "   - # :match_eq:            ", (&(argile).stat)->num_match_eq, " / ", (&(argile).gstat)->num_match_eq);
    printf("%s%u%s%u\n", "   - # :match_try:__________ ", (&(argile).stat)->num_match_try, " / ", (&(argile).gstat)->num_match_try);
    printf("%s%u%s%u\n", "   - # :call_compile_as:     ", (&(argile).stat)->num_call_compile_as, " / ", (&(argile).gstat)->num_call_compile_as);
    printf("%s%u%s%u%s%u%s%u\n", "   - Rejections max bytes___ ", (&(argile).stat)->rejsize, "/", (&(argile).stat)->rejmaxsize, " / ", (&(argile).gstat)->rejsize, "/", (&(argile).gstat)->rejmaxsize);
    printf("%s%u%s%u\n", "   - Def filtering words     ", ((argile).stat).hitsize, " / ", ((argile).gstat).hitsize);
    printf("%s%u\n", "   - Def filter passes______ ", (argile).last_hit);
    printf("%s%u\n", "   - # :malloc:              ", argrt_dbg_allocs);
    
#if HAVE_SBRK
    printf("%s%i\n", "   - Allocated bytes (brk)__ ", ((int)(sbrk(0)-firstbrk)));
    
#endif
  }
  if (((argile).error)) {
    if (((argile).killer)) {
      int count = 0;

      count = print_rejects((argile).killer, 0);
      if ((count != 0)) {
        fprintf(stderr, "%d rejection%s\n", count, (((count > 1)) ? ("s") : ("")));
      }
    }
    fprintf(stderr, "%s: compilation error: %s\n", "arc", (argile).error);
    if (!(dump_mode)) {
      fprintf(stderr, "  (to get context of error use --dump option;");
      fprintf(stderr, " add parenthesis to get rejections)\n");
    }
    return;
  }
}

/** :check <int i> is positive: -> nothing **/
static void check_is_positive(char * * oname, int i_2)
{
  if ((i_2 < 0)) {
    {
      fprintf(stderr, "negative number is invalid for this option (--%s)\n", *oname);
      exit(1);
    };
  }
}

/** :check <text t> is a number: -> nothing **/
static void check_is_a_number(char * t)
{
  char * s = "";

  s = t;
  if (((s)[0] == '-')) {
    (s)++;
  }
  if (((s)[0] != 0)) {
    do {
      if ((((s)[0] < '0') || ((s)[0] > '9'))) {
        break;
      }
      (s)++;
    } while (((s)[0] != 0));
    if (((s)[0] == 0)) {
      return;
    }
  }
  {
    fprintf(stderr, "'%s' is not an integer number\n", t);
    exit(1);
  };
}

/** :split <text v> into <(list) & tail> (and rewind): -> nothing **/
static void split_into_and_rewind(char * v_3, argrt_list_t * * tail, char opt1)
{
  char separator;

  separator = (":")[0];
  
#ifdef WIN32
  separator = (";")[0];
  
#endif
  while (((v_3)[0] != 0)) {
    char * d = "";

    d = v_3;
    while ((((v_3)[0] != 0) && ((v_3)[0] != separator))) {
      (v_3)++;
    };
    if ((d != v_3)) {
      argrt_list_append(tail, argrt_list_new(((void *)((long)mystrndup(d, ((v_3) - d)))), &ARGRT_free));
    }
    if (((v_3)[0])) {
      (v_3)++;
    }
  };
  if ((opt1 != 0)) {
    *tail = argrt_list_start(*tail);
  }
}

/** :mystrndup <text t> <int size>: -> text **/
static char * mystrndup(char * t_2, int size)
{
  char * cpy = "";

  cpy = ((char *)ARGRT_malloc((size + 1)));
  memcpy(cpy, t_2, size);
  (cpy)[size] = '\0';
  return cpy;
}

/** :parse op range in <text>: -> nothing **/
static void parse_op_range_in(char * p_text)
{
  unsigned int first = 0;
  unsigned int last = 0;
  int s = 0;

  s = sscanf(p_text, "%x %x", &first, &last);
  if ((s == 2)) {
    argile_add_operators(first, last);
  }
  if ((s == 1)) {
    argile_add_operators(first, 0);
  }
}

/** :make implicit binds: -> bool **/
static unsigned char make_implicit_binds()
{
  argile_deftype(((char *)":word:"), (argile_type_t)ARGILE_TYPE_WORD);
  argile_deftype(((char *)":text:"), (argile_type_t)ARGILE_TYPE_TEXT);
  argile_deftype(((char *)":syntax:"), (argile_type_t)ARGILE_TYPE_SYNTAX);
  argile_bind(((char *)":use [{<word> | <text>} , ...] {<word> | <text>}:"), ((char *)"std"), ((char *)"use"));
  argile_bind(((char *)":bind <syntax> to <word module> / <word bind>:"), ((char *)"std"), ((char *)"bind"));
  {
    argrt_list_t * ld;
    argrt_list_t * next;
    int i = 0;

    for (i = 0; (i < 4096); (i)++) {
      for (ld = ((argile).defs)[i]; (ld); ld = next) {
        argile_def_t * d = ((argile_def_t *)0);

        d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ld)->data));
        next = ((argrt_list_t *)ld)->next;
        if ((((d)->dtype == ARGILE_DEF_TYPE) && ((d)->type == (argile_type_t)ARGILE_TYPE_TYPE))) {
          argrt_list_link(((argrt_list_t *)ld)->prev, ((argrt_list_t *)ld)->next);
          if ((((argrt_list_t *)ld)->prev == ((argrt_list_t *)0))) {
            ((argile).defs)[i] = ((argrt_list_t *)ld)->next;
          }
          ((argrt_list_t *)ld)->prev = ((argrt_list_t *)0);
          ((argrt_list_t *)ld)->next = ((argrt_list_t *)0);
          argrt_list_delete_all(ld);
          (((argile).stat).hitsize)--;
        }
      };
    };
    for (ld = ((argile).main)->defs; (ld); ld = next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = ((argile_def_t *)*((argile_def_t * *)&((argrt_list_t *)ld)->data));
      next = ((argrt_list_t *)ld)->next;
      if ((((d)->dtype == ARGILE_DEF_TYPE) && ((d)->type == (argile_type_t)ARGILE_TYPE_TYPE))) {
        argrt_list_link(((argrt_list_t *)ld)->prev, ((argrt_list_t *)ld)->next);
        if ((((argrt_list_t *)ld)->prev == ((argrt_list_t *)0))) {
          ((argile).main)->defs = ((argrt_list_t *)((argrt_list_t *)ld)->next);
        }
        ((argrt_list_t *)ld)->prev = ((argrt_list_t *)0);
        ((argrt_list_t *)ld)->next = ((argrt_list_t *)0);
        argrt_list_delete_all(ld);
      }
    };
  };
  argile_implicitize();
  return ((argile).error != (char *)0);
}

/** :print command line in <FILE f>: -> nothing **/
static void print_command_line_in(FILE * f)
{
  int i = 0;

  fprintf(f, " generated by: arc ");
  for (i = 1; ((i <= (global_argc - 1))); (i)++) {
    fprintf(f, "%s ", (global_argv)[i]);
  };
}

/** :print bind doc <module mod> <bind bnd>: -> nothing **/
static void print_bind_doc(argile_module_t * mod, argile_bind_t * bnd)
{
  modbind_t * mb = ((modbind_t *)0);

  if ((mod == ((argile_module_t *)0))) {
    argrt_list_t * cur;

    argrt_list_sort(binds, (void *)&bindcmp);
    for (cur = binds; (cur); cur = ((argrt_list_t *)cur)->next) {
      mod = (*((modbind_t * *)&((argrt_list_t *)cur)->data))->module;
      bnd = (*((modbind_t * *)&((argrt_list_t *)cur)->data))->bind;
      printf("%s\n", "==========================");
      printf("%s%s%s%s\n", (mod)->name, "/", (bnd)->name, " :");
      printf("%s\n", "==========================");
      if (!(((bnd)->doc == (char *)0))) {
        printf("%s\n", (bnd)->doc);
      }
    };
    argrt_list_delete_all(binds);
    binds = ((argrt_list_t *)0);
    return;
  }
  mb = ((modbind_t *)memset(ARGRT_malloc(sizeof(modbind_t)), 0, sizeof(modbind_t)));
  (mb)->module = mod;
  (mb)->bind = bnd;
  argrt_list_prepend(&binds, argrt_list_new(((void *)((long)mb)), &ARGRT_free));
}

/** :bindcmp <modbind a> <modbind b>: -> int **/
static int bindcmp(modbind_t * a, modbind_t * b)
{
  int cmp = 0;

  cmp = (-strcmp(((a)->module)->name, ((b)->module)->name));
  if ((cmp != 0)) {
    return cmp;
  }
  return (-strcmp(((a)->bind)->name, ((b)->bind)->name));
}

/** :<def>: -> nothing **/
static void argile_def_2(argile_def_t * p_argile_def)
{
  char * input = "";
  char * category = "";
  char * deftype = "";
  argile_buff_t sbuf = ((argile_buff_t){0});
  argile_buff_t tbuf = ((argile_buff_t){0});
  int line_2 = -1;

  if (((p_argile_def)->locall || (p_argile_def)->implicit)) {
    return;
  }
  input = ((p_argile_def)->scope)->input;
  if ((input == (char *)0)) {
    input = "<none>";
  }
  category = ((((p_argile_def)->scope == (argile).main)) ? ("main") : ("sub."));
  switch ((p_argile_def)->dtype) {
    case ARGILE_DEF_VAR: {
      deftype = "varia";
    } break;
    case ARGILE_DEF_FUNC: {
      deftype = "funct";
      if ((((p_argile_def)->dval).code)) {
        if ((((p_argile_def)->dval).code)->macro) {
          deftype = "macro";
        }
        else if ((((p_argile_def)->dval).code)->cmacro) {
          deftype = "Cmacr";
        }
        else {
          deftype = "funct";
        }
      }
    } break;
    case ARGILE_DEF_TYPE: {
      deftype = "type.";
    } break;
    case ARGILE_DEF_BIND: {
      deftype = "bind.";
    } break;
    default: {
      deftype = "?????";
    } break;
  };
  argile_syntax_string((p_argile_def)->syntax, &sbuf);
  argile_buff_putc(&sbuf, '\0');
  argile_typename((p_argile_def)->type, &tbuf, (p_argile_def)->scope);
  argile_buff_putc(&tbuf, '\0');
  if (!(((p_argile_def)->maker == ((argile_call_t *)0)))) {
    line_2 = ((((p_argile_def)->maker)->loc).start).row;
  }
  printf("%s:%d: [%s/%s] :%s: -> (%s)\n", input, line_2, category, deftype, (sbuf).ptr, (tbuf).ptr);
  ARGRT_free((sbuf).ptr);
  ARGRT_free((tbuf).ptr);
}

/** :<text file> <int fs> has ext <text ext> <int es>: -> bool **/
static unsigned char has_ext(char * file_2, int fs, char * ext, int es)
{
  if ((fs < es)) {
    return 0;
  }
  return (strcmp(ext, ((file_2) + (fs - es))) == 0);
}

/** :print rejects <call> <int count>: -> int **/
static int print_rejects(argile_call_t * p_argile_call, int count_2)
{
  argrt_list_t * reject;
  argrt_list_t * lm;

  reject = (p_argile_call)->rejects;
  for (; (reject); reject = ((argrt_list_t *)reject)->next) {
    fprintf(stderr, "\n[%d] %s\n", ++(count_2), *((char * *)&((argrt_list_t *)reject)->data));
  };
  lm = (p_argile_call)->match;
  for (; (lm); lm = ((argrt_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argrt_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      count_2 = print_rejects(((m)->value).call, count_2);
    }
  };
  return count_2;
}

int main(int argc, char **argv)
{
  nocolors = 0;
  noautouse = 0;
  dump_mode = 0;
  dump_indent = 0;
  verbose = 0;
  do_main = 1;
  concat = 0;
  stats = 0;
  debugcomp = 0;
  daltonism = 0;
  utf8 = 1;
  hexastr = 0;
  proto_syntax = 0;
  show_progress = 0;
  
#if HAVE_SBRK
  firstbrk = sbrk(0);
  
#endif
  parse_environ();
  parse_options(argc, argv);
  global_argv = argv;
  global_argc = argc;
  if (verbose) {
    fprintf(stderr, "%s %s %s\n", "arc", "(Argile Compiler) version", VERSION);
  }
  if ((argile_init() != 0)) {
    {
      fprintf(stderr, "%s: init error: %s\n", "arc", ((((argile).error == (char *)0)) ? ("") : ((argile).error)));
      exit(1);
    };
  }
  if ((maxmatch >= 0)) {
    (argile).maxmatch = maxmatch;
  }
  if ((maxcomp >= 0)) {
    (argile).maxcomp = maxcomp;
  }
  if ((maxgen >= 0)) {
    (argile).maxgen = maxgen;
  }
  if ((maxrejt >= 0)) {
    (argile).maxreject = maxrejt;
  }
  if ((colpertab > 0)) {
    (argile).colpertab = ((unsigned int)colpertab);
  }
  (argile).verbose = verbose;
  (argile).stats = stats;
  (argile).debugcomp = debugcomp;
  (argile).do_main = do_main;
  if ((concat && !(do_main))) {
    fprintf(stderr, "%s: warning: --no-main(-M) disables --concat(-C)\n", "arc");
  }
  else {
    (argile).cat_main = concat;
  }
  (argile).use_colors = !(nocolors);
  (argile).daltonism = daltonism;
  (argile).dump_indent = dump_indent;
  (argile).gen_lines = genlines;
  (argile).hexa_str = hexastr;
  (argile).proto_syntax = proto_syntax;
  (argile).progress = show_progress;
  if (!(concat)) {
    (argile).lazy = 1;
  }
  if (utf8) {
    (argile).encoding = &(argile).enc_utf8;
  }
  complete_file_path();
  (argile).file_path = file_path;
  complete_sys_inc_path();
  (argile).sys_inc_path = sys_inc_path;
  (argile).options = argrt_list_start(arg_opts);
  auto_use = argrt_list_start(auto_use);
  mod_docs = argrt_list_start(mod_docs);
  parse_environ_after_init();
  compile(filename);
  argrt_list_delete_all(auto_use);
  argrt_list_delete_all(mod_docs);
  errorCode = ((((argile).error == (char *)0)) ? (0) : (1));
  argile_uninit();
  if ((argrt_dbg_allocs != argrt_dbg_frees)) {
    if (!(nocolors)) {
      fprintf(stderr, "%s", "\x1b[1;31m");
    }
    fprintf(stderr, "%s: %d mallocs , %d frees\n", "arc", argrt_dbg_allocs, argrt_dbg_frees);
    if (!(nocolors)) {
      fprintf(stderr, "%s", "\x1b[0m");
    }
  }
  return errorCode;
  return 0;
}
