#ifndef ARGRT_CONFIG_H
#define ARGRT_CONFIG_H

# undef WITH_GC

# ifdef WITH_GC
#  define ARGRT_USE_GC  1
#  define ARGRT_USE_DBG 0
# else
#  define ARGRT_USE_GC  0
#  define ARGRT_USE_DBG 1
# endif

# if ARGRT_USE_DBG

#  include "./dbg.h"

#  define ARGRT_malloc		argrt_dbg_malloc
#  define ARGRT_realloc		argrt_dbg_realloc
#  define ARGRT_free		argrt_dbg_free
#  define ARGRT_strdup		argrt_dbg_strdup

# elif ARGRT_USE_GC

#  include <gc/gc.h>

#  define ARGRT_malloc		GC_malloc
#  define ARGRT_realloc		GC_realloc
#  define ARGRT_free		GC_free
#  define ARGRT_strdup		GC_strdup

# else

#  define ARGRT_malloc		malloc
#  define ARGRT_realloc		realloc
#  define ARGRT_free		free
#  define ARGRT_strdup		strdup

# endif

#endif
