#!/bin/sh
#############################################################################
# arc.sh -- local Argile compiler wrapping script
#
#   Copyright (C) 2009,2010,2011,2014 the Argile authors
#
#   This software is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This software is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this software.  If not, see <http://www.gnu.org/licenses/>.
#
#############################################################################
#
# This script runs the argile compiler, either from the backup if present,
# or from an external installation otherwise.
#

#-------------------------------------------------#
# Usage: arc.sh <BACKUP_DIR> [<ARC_ARGUMENTS>...] #
#-------------------------------------------------#

# script name
self=$(basename "$0")

# arc
arc="$1/arc"

shift

echo_exec() {
    echo "$*"
    exec "$@"
}

if [ -x "$arc" ]
then
    echo_exec "$arc" "$@"
else # trying external argile compiler
    echo_exec arc "$@"
fi
