// generated by: arc -xuNP -A ./../argrt -M -o syntax.c -H syntax.h -m syntax.argl.tmp syntax.arg 
#include "syntax.h"

static void syntax_string(argile_list_t *, argile_buff_t *, unsigned char, unsigned char);
/** :syntax string <list of (argile syntax) s> <buff> <bool in_enum> <bool in_list>: -> nothing **/
static void decode(argile_buff_t *, char *);
/** :decode <buff b> <text s>: -> nothing **/
static char * sub_gen_id(argile_syntax_t *, argile_code_t *, char *, int);
/** :sub gen id <argile syntax s> <argile code c> <text p> <int i>: -> text **/
static void escape(argile_buff_t *, char *, unsigned char, unsigned char);
/** :escape <buff b> <text s> <bool in_enum> <bool in_list>: -> nothing **/
static void get_words(argile_list_t *, argile_list_t * *);
/** :get words <list of (argile syntax) lsyn> <(list of (text)) & tail>: -> nothing **/
static void gen_no_word(argile_list_t *, argile_call_t *, argile_buff_t *);
/** :gen no word <list of (argile syntax) ls> <call maker> <buff b>: -> nothing **/
static void gen_options(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen options <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
static void gen_enums(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen enums <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
static void gen_lists(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen lists <list of (argile syntax) syn> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
static void escape_2(argile_buff_t *, char *);
/** :escape <buff b> <text s>: -> nothing **/
static int compile_params(argile_list_t *, argile_code_t *, argile_call_t *, unsigned char);
/** :compile params <list of (argile syntax) lsyn> <argile code scope> <call> <bool in_list>: -> int **/
static unsigned char compile_init(argile_match_t *, argile_type_t, argile_code_t *, argile_call_t *);
/** :compile init <match> <argile type t> <argile code c> <call>: -> bool **/
static argile_list_t * syn_match(argile_list_t *, argile_list_t *);
/** :syn match <list of (argile syntax) ls> <list of (argile syntax) lp>: -> list of (argile syntax) **/
static argile_list_t * match_match(argile_list_t *, argile_list_t *);
/** :match match <list of (match) lm> <list of (match) lp>: -> list of (match) **/
static void module_call(argile_list_t *, argile_buff_t *, char *, argile_list_t *, argile_buff_t *);
/** :module call <list of (argile syntax) ls> <buff bt> <text w> <list of (argile syntax) ls2> <buff out>: -> nothing **/
static unsigned char missing_param(argile_list_t *, char *, argile_list_t *);
/** :missing param <list of (argile syntax) ls> <text w> <list of (argile syntax) ls2>: -> bool **/

static char *( _opnames[94]) = {"exclam", "doublequote", "sharp", "dollar", "percent", "ampersand", "quote", "", "", "star", "plus", "comma", "dash", "dot", "slash", "", "", "", "", "", "", "", "", "", "", "colon", "semicolon", "inferior", "equal", "superior", "question", "at", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "opensquare", "backslash", "closesquare", "carret", "underscore", "backquote", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "openbrace", "pipe", "closebrace", "tilde"};
static char *( _opshorts[94]) = {"ex", "dq", "sh", "do", "pe", "am", "sq", "", "", "st", "pl", "cm", "da", "dt", "sl", "", "", "", "", "", "", "", "", "", "", "cl", "se", "in", "eq", "su", "qu", "at", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "os", "bs", "cs", "ca", "un", "bq", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "ob", "pi", "cb", "ti"};

static char * chex = "0123456789abcdef";

argile_syntax_t * argile_syntax_new(argile_syn_type_t t, void * data)
/** :argile_syntax_new <syn type t> <any data>: -> argile syntax **/
{
  argile_syntax_t * syn = ((argile_syntax_t *)0);

  syn = ((argile_syntax_t *)memset(argile_dbg_malloc(sizeof(argile_syntax_t)), 0, sizeof(argile_syntax_t)));
  (syn)->type = t;
  ((syn)->value).data = data;
  return syn;
}

void argile_syntax_del(argile_syntax_t * s)
/** :argile_syntax_del <argile syntax s>: -> nothing **/
{
  switch ((s)->type) {
    case ARGILE_SYN_WORD: ;
    case ARGILE_SYN_OP: {
      argile_dbg_free(((s)->value).data);
    } break;
    case ARGILE_SYN_PARAM: {
      argile_syn_param_del(((s)->value).syn_param);
    } break;
    case ARGILE_SYN_OPTION: {
      argile_list_del(((s)->value).syn_option);
    } break;
    case ARGILE_SYN_ENUM: {
      argile_list_del(((s)->value).syn_enum);
    } break;
    case ARGILE_SYN_LIST: {
      argile_syn_list_del(((s)->value).syn_list);
    } break;
    default: {} break;
  };
  if (((s)->genid)) {
    argile_dbg_free((s)->genid);
  } //;
  argile_dbg_free(s);
}

void argile_syntax_string(argile_list_t * s_2, argile_buff_t * buf)
/** :argile_syntax_string <list of (argile syntax) s> <buff buf>: -> nothing **/
{
  syntax_string(s_2, buf, 0, 0);
}

static void syntax_string(argile_list_t * s_3, argile_buff_t * p_argile_buff, unsigned char in_enum, unsigned char in_list)
/** :syntax string <list of (argile syntax) s> <buff> <bool in_enum> <bool in_list>: -> nothing **/
{
  for (; (s_3); s_3 = ((argile_list_t *)s_3)->next) {
    argile_syntax_t * syn = ((argile_syntax_t *)0);

    syn = *((argile_syntax_t * *)&((argile_list_t *)s_3)->data);
    switch ((syn)->type) {
      case ARGILE_SYN_WORD: {
        argile_buff_puts(p_argile_buff, ((syn)->value).syn_word);
      } break;
      case ARGILE_SYN_OP: {
        escape(p_argile_buff, ((syn)->value).syn_op, in_enum, in_list);
      } break;
      case ARGILE_SYN_PARAM: {
        argile_syn_param_string(((syn)->value).syn_param, p_argile_buff);
      } break;
      case ARGILE_SYN_OPTION: {
        argile_buff_putc(p_argile_buff, *&("(")[0]);
        syntax_string(((syn)->value).syn_option, p_argile_buff, 0, 0);
        argile_buff_putc(p_argile_buff, *&(")")[0]);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * cur;

        argile_buff_putc(p_argile_buff, *&("{")[0]);
        cur = ((syn)->value).syn_enum;
        for (; (cur); cur = ((argile_list_t *)cur)->next) {
          syntax_string(*((argile_list_t * *)&((argile_list_t *)cur)->data), p_argile_buff, 1, 0);
          if ((((argile_list_t *)cur)->next)) {
            argile_buff_puts(p_argile_buff, " | ");
          } //;
        };
        argile_buff_putc(p_argile_buff, *&("}")[0]);
      } break;
      case ARGILE_SYN_LIST: {
        argile_syn_list_string(((syn)->value).syn_list, p_argile_buff);
      } break;
      default: {
        argile_buff_puts(p_argile_buff, "(: bad syntax type ");
        argile_buff_putn(p_argile_buff, ((int)(syn)->type));
        argile_buff_puts(p_argile_buff, " :)");
      } break;
    };
    if ((((argile_list_t *)s_3)->next)) {
      argile_buff_putc(p_argile_buff, ' ');
    } //;
  };
}

void argile_syntax_gen_id(argile_list_t * s_4, argile_call_t * maker, argile_buff_t * buf_2)
/** :argile_syntax_gen_id <list of (argile syntax) s> <call maker> <buff buf>: -> nothing **/
{
  argile_list_t * words = ((argile_list_t *)0);

  if ((s_4 == NULL)) {
    argile_buff_puts(buf_2, "anonymous");
    if ((maker)) {
      argile_buff_putc(buf_2, '_');
      argile_buff_putn(buf_2, (((maker)->loc).start).row);
      argile_buff_putc(buf_2, '_');
      argile_buff_putn(buf_2, (((maker)->loc).end).row);
      argile_buff_putc(buf_2, '_');
    } //;
    return;
  } //;
  get_words(s_4, &words);
  if ((words)) {
    for (words = argile_list_start(words); (((argile_list_t *)words)->next); words = ((argile_list_t *)words)->next) {
      decode(buf_2, *((char * *)&((argile_list_t *)words)->data));
      argile_buff_putc(buf_2, '_');
    };
    decode(buf_2, *((char * *)&((argile_list_t *)words)->data));
    argile_list_del(words);
  } //;
  else {
    unsigned int i = 0;

    gen_no_word(s_4, maker, buf_2);
    i = (buf_2)->len;
    while (((i != 0) && (*&((buf_2)->ptr)[(i - 1)] == '_'))) {
      (i)--;
    };
    (buf_2)->len = i;
  };
}

static void decode(argile_buff_t * b, char * s_5)
/** :decode <buff b> <text s>: -> nothing **/
{
  while ((*&(s_5)[0] != 0)) {
    if (((*&(s_5)[0] & 128) != 0)) {
      argile_buff_puts(b, "_x");
      while (((*&(s_5)[0] & 128) != 0)) {
        argile_buff_putc(b, *&(chex)[((*&(s_5)[0] >> 4) & 0xf)]);
        argile_buff_putc(b, *&(chex)[(*&(s_5)[0] & 0xf)]);
        (s_5)++;
      };
      argile_buff_putc(b, '_');
    } //;
    else {
      argile_buff_putc(b, *&((s_5)++)[0]);
    };
  };
}

void argile_syntax_gen_params(argile_list_t * syn, int names, int * param)
/** :argile_syntax_gen_params <list of (argile syntax) syn> <int names> <(int) & param>: -> nothing **/
{
  int* pparam;
  int dummy = 0;

  pparam = &*param;
  if ((pparam == NULL)) {
    pparam = &dummy;
  } //;
  for (; (syn); syn = ((argile_list_t *)syn)->next) {
    argile_syntax_t * s_6 = ((argile_syntax_t *)0);

    s_6 = *((argile_syntax_t * *)&((argile_list_t *)syn)->data);
    switch ((s_6)->type) {
      case ARGILE_SYN_PARAM: {
        argile_type_t t_2;

        t_2 = (((s_6)->value).syn_param)->type;
        if (((*pparam)++ != 0)) {
          argile_puts(", ");
        } //;
        argile_type_gen_prefix(t_2);
        if ((names != 0)) {
          argile_puts(" ");
        } //;
        if ((((s_6)->value).syn_param)->in_list) {
          argile_ref(1);
        } //;
        if ((names != 0)) {
          argile_puts(argile_syn_param_gen_id(((s_6)->value).syn_param));
        } //;
        argile_type_gen_suffix(t_2);
      } break;
      case ARGILE_SYN_OPTION: {
        argile_syntax_gen_params(((s_6)->value).syn_option, ((int)(names != 0)), pparam);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

        e = ((s_6)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          argile_syntax_gen_params(*((argile_list_t * *)&((argile_list_t *)e)->data), ((int)(names != 0)), pparam);
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((((s_6)->value).syn_list)->pseudoempty) {
          break;
        } //;
        argile_syntax_gen_params((((s_6)->value).syn_list)->sub, ((int)(names != 0)), pparam);
      } break;
      default: {} break;
    };
  };
}

void argile_syntax_gen_options(argile_list_t * s_6, argile_code_t * body, int * param_2)
/** :argile_syntax_gen_options <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
  int num = 0;

  gen_options(s_6, body, &num, ((&*param_2) && (*param_2)), 0);
  *param_2 += num;
}

static char * sub_gen_id(argile_syntax_t * s_7, argile_code_t * c, char * p, int i)
/** :sub gen id <argile syntax s> <argile code c> <text p> <int i>: -> text **/
{
  if (((s_7)->genid == NULL)) {
    argile_buff_t b_2 = ((argile_buff_t){0});

    argile_buff_puts(&b_2, p);
    argile_buff_putn(&b_2, i);
    argile_buff_putc(&b_2, '\0');
    if ((c)) {
      argile_check_local_collisions(&b_2, c);
      argile_list_prepend(&(c)->special_ids, argile_list_new((b_2).ptr, ((argile_deleter_t)0)));
    } //;
    (s_7)->genid = (b_2).ptr;
  } //;
  return (s_7)->genid;
}

void argile_syntax_gen_enums(argile_list_t * s_8, argile_code_t * body_2, int * param_3)
/** :argile_syntax_gen_enums <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
  int num = 0;

  gen_enums(s_8, body_2, &num, ((&*param_3) && (*param_3)), 0);
  *param_3 += num;
}

void argile_syntax_gen_lists(argile_list_t * s_9, argile_code_t * body_3, int * param_4)
/** :argile_syntax_gen_lists <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
  int num = 0;

  gen_lists(s_9, body_3, &num, ((&*param_4) && (*param_4)), 0);
  *param_4 += num;
}

void argile_syntax_gen_call(argile_list_t * s_10, argile_buff_t * buf_3)
/** :argile_syntax_gen_call <list of (argile syntax) s> <buff buf>: -> nothing **/
{
  for (; (s_10); s_10 = ((argile_list_t *)s_10)->next) {
    argile_syntax_t * s_11 = ((argile_syntax_t *)0);

    s_11 = *((argile_syntax_t * *)&((argile_list_t *)s_10)->data);
    switch ((s_11)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        argile_buff_puts(buf_3, ((s_11)->value).syn_word);
        argile_buff_putc(buf_3, ' ');
      } break;
      case ARGILE_SYN_PARAM: {
        if (((((s_11)->value).syn_param)->type == ARGILE_TYPE_WORD)) {
          argile_buff_puts(buf_3, "_word_ ");
        } //;
        else {
          argile_buff_puts(buf_3, "(nil) ");
        };
      } break;
      case ARGILE_SYN_OPTION: {
        argile_syntax_gen_call(((s_11)->value).syn_option, buf_3);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_syntax_gen_call(*((argile_list_t * *)&((argile_list_t *)((s_11)->value).syn_enum)->data), buf_3);
      } break;
      case ARGILE_SYN_LIST: {
        argile_syn_list_t * sl = ((argile_syn_list_t *)0);
        int i_2 = 0;

        sl = ((s_11)->value).syn_list;
        for (i_2 = 0; (i_2 < (sl)->min); (i_2)++) {
          argile_syntax_gen_call((sl)->sub, buf_3);
        };
      } break;
      default: {} break;
    };
  };
}

int argile_syntax_check_format(char * str)
/** :argile_syntax_check_format <text str>: -> int **/
{
  if ((*&(str)[0] != *&(":")[0])) {
    return 0;
  } //;
  (str)++;
  while (((*&(str)[0] != 0) && (*&(str)[0] != *&(":")[0]))) {
    (str)++;
  };
  if ((*&(str)[0] == 0)) {
    return 0;
  } //;
  (str)++;
  if ((*&(str)[0] != 0)) {
    return 0;
  } //;
  return 1;
}

argile_list_t * argile_syntax_parse(char * str_2)
/** :argile_syntax_parse <text str>: -> list of (argile syntax) **/
{
  argile_code_t * oldmain = ((argile_code_t *)0);
  argile_inout_t oldinput;
  char * oldname = "";
  unsigned char oldcmt;
  int oldnumcalls = 0;
  char * ptr = "";
  argile_list_t * syn_2 = ((argile_list_t *)0);
  unsigned char got_syn;

  if (!((argile_syntax_check_format(str_2)))) {
    argile_die("\"%s\" is invalid syntax string", str_2);
    return ((argile_list_t *)0);
  } //;
  oldmain = (argile).main;
  oldinput = (argile).input;
  oldname = (argile).input_name;
  oldcmt = (argile).get_comments;
  oldnumcalls = (argile).numcalls;
  (argile).input = (void *)&argile_input_string;
  (argile).input_name = "syntax string";
  (argile).get_comments = 0;
  (argile).main = argile_code_new(oldmain, ((argile_list_t *)0));
  ptr = str_2;
  got_syn = 0;
  if ((((!((argile_parse(&ptr) != 0)) && ((argile).main)) && (((argile).main)->calls)) && !((((argile_list_t *)((argile).main)->calls)->next)))) {
    argile_call_t * call = ((argile_call_t *)0);

    call = *((argile_call_t * *)&((argile_list_t *)((argile).main)->calls)->data);
    if ((((call)->match) && !((((argile_list_t *)(call)->match)->next)))) {
      argile_match_t * match = ((argile_match_t *)0);

      match = *((argile_match_t * *)&((argile_list_t *)(call)->match)->data);
      if (((match)->type == ARGILE_MATCH_CONS)) {
        argile_cons_t * cons = ((argile_cons_t *)0);

        cons = (match)->value.cons;
        if (((cons)->ctype == ARGILE_CONS_SYNTAX)) {
          syn_2 = ((cons)->cvalue).syntax;
          ((cons)->cvalue).syntax = ((argile_list_t *)0);
          got_syn = 1;
        } //;
      } //;
    } //;
  } //;
  argile_code_del((argile).main);
  (argile).main = oldmain;
  (argile).input = oldinput;
  (argile).input_name = oldname;
  (argile).get_comments = oldcmt;
  (argile).numcalls = oldnumcalls;
  if (!(got_syn)) {
    argile_die("\"%s\": not correctly parsed", str_2);
  } //;
  return syn_2;
}

argile_syn_param_t * argile_syn_param_new(argile_list_t * call, argile_match_t * init)
/** :argile_syn_param_new <list of (match) call> <match init>: -> (argile) syn param **/
{
  argile_syn_param_t * p_2 = ((argile_syn_param_t *)0);

  p_2 = ((argile_syn_param_t *)memset(argile_dbg_malloc(sizeof(argile_syn_param_t)), 0, sizeof(argile_syn_param_t)));
  (p_2)->match = call;
  (p_2)->init = init;
  return p_2;
}

void argile_syn_param_del(argile_syn_param_t * s_11)
/** :argile_syn_param_del <syn param s>: -> nothing **/
{
  if (!(((s_11)->name == NULL))) {
    argile_dbg_free((s_11)->name);
  } //;
  if (!(((s_11)->genid == NULL))) {
    argile_dbg_free((s_11)->genid);
  } //;
  argile_list_del((s_11)->match);
  if (!(((s_11)->init == NULL))) {
    argile_match_del((s_11)->init);
  } //;
  argile_dbg_free(s_11);
}

void argile_syn_param_string(argile_syn_param_t * s_12, argile_buff_t * buf_4)
/** :argile_syn_param_string <syn param s> <buff buf>: -> nothing **/
{
  unsigned char old;
  argile_list_t * lm;

  old = (argile).skip_codes;
  (argile).skip_codes = 1;
  argile_buff_putc(buf_4, '<');
  for (lm = (s_12)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_OP)) {
      escape_2(buf_4, ((m)->value).op);
    } //;
    else {
      unsigned char pushed;

      pushed = 1;
      if (((m)->matched == NULL)) {
        argile_push_color(buf_4, (((m)->processed) ? ("\x1b[1;31m") : ("\x1b[0;1m")));
      } //;
      else if (((((m)->matched)->type != ARGILE_SYN_PARAM) || (((((m)->matched)->value).syn_param)->type != ARGILE_TYPE_WORD))) {
        argile_push_color(buf_4, "\x1b[1;32m");
      } //;
      else {
        pushed = 0;
      };
      argile_match_string(m, 0, buf_4, 0);
      if (pushed) {
        argile_pop_color(buf_4);
      } //;
    };
    if ((((argile_list_t *)lm)->next != NULL)) {
      argile_buff_putc(buf_4, ' ');
    } //;
  };
  if (((s_12)->name)) {
    argile_buff_putc(buf_4, ' ');
    argile_buff_puts(buf_4, (s_12)->name);
  } //;
  if (((s_12)->init)) {
    argile_buff_puts(buf_4, " = ");
    argile_match_string((s_12)->init, 0, buf_4, 0);
  } //;
  argile_buff_putc(buf_4, '>');
  (argile).skip_codes = old;
}

char * argile_syn_param_gen_id(argile_syn_param_t * s_13)
/** :argile_syn_param_gen_id <syn param s>: -> text **/
{
  if (((s_13)->genid == NULL)) {
    argile_buff_t b_2 = ((argile_buff_t){0});

    if (((s_13)->name)) {
      decode(&b_2, (s_13)->name);
    } //;
    else {
      argile_buff_puts(&b_2, "p_");
      argile_type_gen_id_part((s_13)->type, ((argile_call_t *)0), &b_2);
    };
    argile_buff_putc(&b_2, '\0');
    if (((s_13)->def)) {
      argile_check_local_collisions(&b_2, ((s_13)->def)->scope);
      argile_check_collisions(&b_2);
    } //;
    else {
      argile_check_collisions(&b_2);
    };
    (s_13)->genid = (b_2).ptr;
  } //;
  return (s_13)->genid;
}

argile_syn_list_t * argile_syn_list_new(argile_list_t * sub, int min, int max)
/** :argile_syn_list_new <list of (argile syntax) sub> <int min> <int max>: -> (argile) syn list **/
{
  argile_syn_list_t * s_14 = ((argile_syn_list_t *)0);

  s_14 = ((argile_syn_list_t *)memset(argile_dbg_malloc(sizeof(argile_syn_list_t)), 0, sizeof(argile_syn_list_t)));
  (s_14)->sub = sub;
  (s_14)->min = min;
  (s_14)->max = max;
  return s_14;
}

void argile_syn_list_del(argile_syn_list_t * s_14)
/** :argile_syn_list_del <syn list s>: -> nothing **/
{
  argile_list_del((s_14)->sub);
  argile_dbg_free(s_14);
}

void argile_syn_list_string(argile_syn_list_t * s_15, argile_buff_t * buf_5)
/** :argile_syn_list_string <syn list s> <buff buf>: -> nothing **/
{
  argile_buff_putc(buf_5, '[');
  if (!((s_15)->pseudoempty)) {
    syntax_string((s_15)->sub, buf_5, 0, 1);
    argile_buff_putc(buf_5, ' ');
  } //;
  argile_buff_puts(buf_5, "...");
  if ((((s_15)->min != 0) || ((s_15)->max != 0))) {
    argile_buff_putc(buf_5, ' ');
    if (((s_15)->min != 0)) {
      argile_buff_putn(buf_5, (s_15)->min);
      if (((s_15)->max != (s_15)->min)) {
        argile_buff_putc(buf_5, ',');
        if (((s_15)->max != 0)) {
          argile_buff_putn(buf_5, (s_15)->max);
        } //;
      } //;
    } //;
    else {
      argile_buff_puts(buf_5, "0,");
      argile_buff_putn(buf_5, (s_15)->max);
    };
  } //;
  argile_buff_putc(buf_5, ']');
}

int argile_syntax_compile_params(argile_list_t * syntax, argile_code_t * scope, argile_call_t * p_argile_call)
/** :argile_syntax_compile_params <list of (argile syntax) syntax> <argile code scope> <call>: -> int **/
{
  return compile_params(syntax, scope, p_argile_call, 0);
}

int argile_syntax_is_terminal(argile_list_t * syn_2)
/** :argile_syntax_is_terminal <list of (argile syntax) syn>: -> int **/
{
  for (; (syn_2); syn_2 = ((argile_list_t *)syn_2)->next) {
    argile_syntax_t * s_16 = ((argile_syntax_t *)0);

    s_16 = *((argile_syntax_t * *)&((argile_list_t *)syn_2)->data);
    if (((s_16)->type == ARGILE_SYN_OPTION)) {
      continue;
    } //;
    if ((((s_16)->type == ARGILE_SYN_LIST) && ((((s_16)->value).syn_list)->min == 0))) {
      continue;
    } //;
    return 0;
  };
  return 1;
}

int argile_syntax_match(argile_list_t * syntax_2, argile_list_t * syn_pattern)
/** :argile_syntax_match <list of (argile syntax) syntax> <list of (argile syntax) syn_pattern>: -> int **/
{
  if ((syn_match(syntax_2, syn_pattern) == NULL)) {
    return 1;
  } //;
  return 0;
}

void argile_syntax_module_call(argile_list_t * syntax_3, argile_buff_t * type_bp, char * word_p, argile_list_t * syntax_p, argile_buff_t * out)
/** :argile_syntax_module_call <list of (argile syntax) syntax> <buff type_bp> <text word_p> <list of (argile syntax) syntax_p> <buff out>: -> nothing **/
{
  module_call(syntax_3, type_bp, word_p, syntax_p, out);
  if ((((out)->len > 0) && (*&((out)->ptr)[((out)->len - 1)] == ' '))) {
    ((out)->len)--;
  } //;
}

unsigned char argile_syntax_find_autoparams(argile_list_t * syn_3)
/** :argile_syntax_find_autoparams <list of (argile syntax) syn>: -> bool **/
{
  unsigned char found;

  found = 0;
  for (; (syn_3); syn_3 = ((argile_list_t *)syn_3)->next) {
    argile_syntax_t * s_16 = ((argile_syntax_t *)0);

    s_16 = *((argile_syntax_t * *)&((argile_list_t *)syn_3)->data);
    switch ((s_16)->type) {
      case ARGILE_SYN_PARAM: {
        argile_match_t * init_2 = ((argile_match_t *)0);

        init_2 = (((s_16)->value).syn_param)->init;
        if ((init_2 != NULL)) {
          if (argile_match_find_autoparams(init_2)) {
            found = 1;
          } //;
        } //;
      } break;
      case ARGILE_SYN_OPTION: {
        if (argile_syntax_find_autoparams(((s_16)->value).syn_option)) {
          found = 1;
        } //;
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s_16)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          if (argile_syntax_find_autoparams(*((argile_list_t * *)&((argile_list_t *)le)->data))) {
            found = 1;
          } //;
        };
      } break;
      case ARGILE_SYN_LIST: {
        if (argile_syntax_find_autoparams((((s_16)->value).syn_list)->sub)) {
          found = 1;
        } //;
      } break;
      default: {} break;
    };
  };
  return found;
}

static void escape(argile_buff_t * b_2, char * s_16, unsigned char in_enum_2, unsigned char in_list_2)
/** :escape <buff b> <text s> <bool in_enum> <bool in_list>: -> nothing **/
{
  while ((*&(s_16)[0])) {
    switch (*&(s_16)[0]) {
      case '\\': ;
      case '<': ;
      case '[': {
        argile_buff_putc(b_2, '\\');
      } break;
      case ']': {
        if (in_list_2) {
          argile_buff_putc(b_2, '\\');
        } //;
      } break;
      case '|': {
        if (in_enum_2) {
          argile_buff_putc(b_2, '\\');
        } //;
      } break;
      default: {} break;
    };
    argile_buff_putc(b_2, *&(s_16)[0]);
    (s_16)++;
  };
}

static void get_words(argile_list_t * lsyn, argile_list_t * * tail)
/** :get words <list of (argile syntax) lsyn> <(list of (text)) & tail>: -> nothing **/
{
  for (; (lsyn); lsyn = ((argile_list_t *)lsyn)->next) {
    argile_syntax_t * s_17 = ((argile_syntax_t *)0);

    s_17 = *((argile_syntax_t * *)&((argile_list_t *)lsyn)->data);
    switch ((s_17)->type) {
      case ARGILE_SYN_WORD: {
        argile_list_append(tail, argile_list_new(((s_17)->value).syn_word, ((argile_deleter_t)0)));
      } break;
      case ARGILE_SYN_OPTION: {
        get_words(((s_17)->value).syn_option, tail);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

        e = ((s_17)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          get_words(*((argile_list_t * *)&((argile_list_t *)e)->data), tail);
        };
      } break;
      case ARGILE_SYN_LIST: {
        get_words((((s_17)->value).syn_list)->sub, tail);
      } break;
      default: {} break;
    };
  };
}

static void gen_no_word(argile_list_t * ls, argile_call_t * maker_2, argile_buff_t * b_3)
/** :gen no word <list of (argile syntax) ls> <call maker> <buff b>: -> nothing **/
{
  for (; (ls); ls = ((argile_list_t *)ls)->next) {
    argile_syntax_t * s_17 = ((argile_syntax_t *)0);

    s_17 = *((argile_syntax_t * *)&((argile_list_t *)ls)->data);
    switch ((s_17)->type) {
      case ARGILE_SYN_OP: {
        unsigned char ok;
        char * str_3 = "";

        ok = 0;
        str_3 = ((s_17)->value).syn_op;
        while ((*&(str_3)[0])) {
          if (((*&(str_3)[0] >= '!') && (*&(str_3)[0] <= '~'))) {
            if (0) {
              argile_buff_puts(b_3, (_opnames)[(*&(str_3)[0] - '!')]);
            } //;
            else {
              argile_buff_puts(b_3, (_opshorts)[(*&(str_3)[0] - '!')]);
            };
            ok = 1;
          } //;
          (str_3)++;
        };
        if (!(ok)) {
          decode(b_3, ((s_17)->value).syn_op);
          ok = 1;
        } //;
        if (ok) {
          argile_buff_putc(b_3, '_');
        } //;
      } break;
      case ARGILE_SYN_PARAM: {
        argile_type_gen_id_part((((s_17)->value).syn_param)->type, maker_2, b_3);
        argile_buff_putc(b_3, '_');
      } break;
      case ARGILE_SYN_OPTION: {
        gen_no_word(((s_17)->value).syn_option, maker_2, b_3);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s_17)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          gen_no_word(*((argile_list_t * *)&((argile_list_t *)le)->data), maker_2, b_3);
        };
      } break;
      case ARGILE_SYN_LIST: {
        gen_no_word((((s_17)->value).syn_list)->sub, maker_2, b_3);
      } break;
      default: {} break;
    };
  };
}

static void gen_options(argile_list_t * syntax_4, argile_code_t * body_4, int * num_2, unsigned char comma, unsigned char in_list_3)
/** :gen options <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
  for (; (syntax_4); syntax_4 = ((argile_list_t *)syntax_4)->next) {
    argile_syntax_t * s_17 = ((argile_syntax_t *)0);

    s_17 = *((argile_syntax_t * *)&((argile_list_t *)syntax_4)->data);
    switch ((s_17)->type) {
      case ARGILE_SYN_OPTION: {
        if ((comma || (*num_2 != 0))) {
          argile_puts(", ");
        } //;
        argile_puts("char ");
        if (in_list_3) {
          argile_ref(1);
        } //;
        argile_puts(sub_gen_id(s_17, body_4, "opt", ++(*num_2)));
        comma = 1;
        gen_options(((s_17)->value).syn_option, body_4, num_2, comma, in_list_3);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

        e = ((s_17)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_options(*((argile_list_t * *)&((argile_list_t *)e)->data), body_4, num_2, comma, in_list_3);
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((((s_17)->value).syn_list)->pseudoempty) {
          break;
        } //;
        gen_options((((s_17)->value).syn_list)->sub, body_4, num_2, comma, 1);
      } break;
      default: {} break;
    };
  };
}

static void gen_enums(argile_list_t * syntax_5, argile_code_t * body_5, int * num_3, unsigned char comma_2, unsigned char in_list_4)
/** :gen enums <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
  for (; (syntax_5); syntax_5 = ((argile_list_t *)syntax_5)->next) {
    argile_syntax_t * s_17 = ((argile_syntax_t *)0);

    s_17 = *((argile_syntax_t * *)&((argile_list_t *)syntax_5)->data);
    switch ((s_17)->type) {
      case ARGILE_SYN_OPTION: {
        gen_enums(((s_17)->value).syn_option, body_5, num_3, comma_2, in_list_4);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

        if ((comma_2 || (*num_3 != 0))) {
          argile_puts(", ");
        } //;
        argile_puts("int ");
        if (in_list_4) {
          argile_ref(1);
        } //;
        argile_puts(sub_gen_id(s_17, body_5, "enm", ++(*num_3)));
        comma_2 = 1;
        e = ((s_17)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_enums(*((argile_list_t * *)&((argile_list_t *)e)->data), body_5, num_3, comma_2, in_list_4);
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((((s_17)->value).syn_list)->pseudoempty) {
          break;
        } //;
        gen_enums((((s_17)->value).syn_list)->sub, body_5, num_3, comma_2, 1);
      } break;
      default: {} break;
    };
  };
}

static void gen_lists(argile_list_t * syn_4, argile_code_t * body_6, int * num_4, unsigned char comma_3, unsigned char in_list_5)
/** :gen lists <list of (argile syntax) syn> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
  for (; (syn_4); syn_4 = ((argile_list_t *)syn_4)->next) {
    argile_syntax_t * s_17 = ((argile_syntax_t *)0);

    s_17 = *((argile_syntax_t * *)&((argile_list_t *)syn_4)->data);
    switch ((s_17)->type) {
      case ARGILE_SYN_OPTION: {
        gen_lists(((s_17)->value).syn_option, body_6, num_4, comma_3, in_list_5);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

        e = ((s_17)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_lists(*((argile_list_t * *)&((argile_list_t *)e)->data), body_6, num_4, comma_3, in_list_5);
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((((s_17)->value).syn_list)->pseudoempty) {
          break;
        } //;
        if ((comma_3 || (*num_4 != 0))) {
          argile_puts(", ");
        } //;
        argile_puts("int ");
        if (in_list_5) {
          argile_ref(1);
        } //;
        argile_puts(sub_gen_id(s_17, body_6, "lst", ++(*num_4)));
        comma_3 = 1;
        gen_lists((((s_17)->value).syn_list)->sub, body_6, num_4, comma_3, 1);
      } break;
      default: {} break;
    };
  };
}

static void escape_2(argile_buff_t * b_4, char * s_17)
/** :escape <buff b> <text s>: -> nothing **/
{
  while ((*&(s_17)[0])) {
    switch (*&(s_17)[0]) {
      case '\\': ;
      case '<': ;
      case '>': ;
      case '=': {
        argile_buff_putc(b_4, '\\');
      } break;
      default: {} break;
    };
    argile_buff_putc(b_4, *&(s_17)[0]);
    (s_17)++;
  };
}

static int compile_params(argile_list_t * lsyn_2, argile_code_t * scope_2, argile_call_t * p_argile_call_2, unsigned char in_list_6)
/** :compile params <list of (argile syntax) lsyn> <argile code scope> <call> <bool in_list>: -> int **/
{
  for (; (lsyn_2); lsyn_2 = ((argile_list_t *)lsyn_2)->next) {
    argile_syntax_t * syn_5 = ((argile_syntax_t *)0);

    syn_5 = *((argile_syntax_t * *)&((argile_list_t *)lsyn_2)->data);
    switch ((syn_5)->type) {
      case ARGILE_SYN_PARAM: {
        argile_syn_param_t * param_5 = ((argile_syn_param_t *)0);
        argile_list_t * pcall;

        param_5 = ((syn_5)->value).syn_param;
        if ((param_5)->comp) {
          continue;
        } //;
        (param_5)->in_list = in_list_6;
        pcall = (param_5)->match;
        if ((pcall == NULL)) {
          return 0;
        } //;
        if ((((argile_list_t *)pcall)->next)) {
          argile_list_t * end;
          argile_match_t * m = ((argile_match_t *)0);

          end = argile_list_end(pcall);
          m = *((argile_match_t * *)&((argile_list_t *)end)->data);
          if ((((m) && (((argile_list_t *)end)->prev)) && ((m)->type == ARGILE_MATCH_WORD))) {
            argile_list_t * prev;

            prev = ((argile_list_t *)end)->prev;
            argile_list_unlink(prev, end);
            if ((argile_type_compile(&(param_5)->type, pcall, scope_2, p_argile_call_2, ((argile_def_t * *)0), &pcall))) {
              if (compile_init((param_5)->init, (param_5)->type, scope_2, p_argile_call_2)) {
                if ((((param_5)->init == NULL) || (argile_match_type((param_5)->init, (param_5)->type)))) {
                  if (!((pcall == NULL))) {
                    (param_5)->match = pcall;
                  } //;
                  (param_5)->name = argile_dbg_strdup(((m)->value).word);
                  (param_5)->comp = 1;
                  argile_list_del(end);
                  continue;
                } //;
              } //;
            } //;
            if ((pcall)) {
              (param_5)->match = pcall;
            } //;
            else {
              pcall = (param_5)->match;
            };
            argile_list_link(prev, end);
          } //;
        } //;
        if (((!((argile_type_compile(&(param_5)->type, pcall, scope_2, p_argile_call_2, ((argile_def_t * *)0), &pcall))) || !(compile_init((param_5)->init, (param_5)->type, scope_2, p_argile_call_2))) || (((param_5)->init) && !((argile_match_type((param_5)->init, (param_5)->type)))))) {
          if ((pcall)) {
            (param_5)->match = pcall;
          } //;
          return 0;
        } //;
        if ((pcall)) {
          (param_5)->match = pcall;
        } //;
        (param_5)->name = (char *)0;
        (param_5)->comp = 1;
      } break;
      case ARGILE_SYN_OPTION: {
        if ((compile_params(((syn_5)->value).syn_option, scope_2, p_argile_call_2, in_list_6) == 0)) {
          return 0;
        } //;
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * sub_2;

        sub_2 = ((syn_5)->value).syn_enum;
        for (; (sub_2); sub_2 = ((argile_list_t *)sub_2)->next) {
          if ((compile_params(*((argile_list_t * *)&((argile_list_t *)sub_2)->data), scope_2, p_argile_call_2, in_list_6) == 0)) {
            return 0;
          } //;
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((compile_params((((syn_5)->value).syn_list)->sub, scope_2, p_argile_call_2, 1) == 0)) {
          return 0;
        } //;
      } break;
      default: {} break;
    };
  };
  return 1;
}

static unsigned char compile_init(argile_match_t * p_argile_match, argile_type_t t_2, argile_code_t * c_2, argile_call_t * p_argile_call_3)
/** :compile init <match> <argile type t> <argile code c> <call>: -> bool **/
{
  argile_call_t * sub_2 = ((argile_call_t *)0);
  argile_filter_t old;

  if (((p_argile_match == NULL) || ((p_argile_match)->type != ARGILE_MATCH_SUBCALL))) {
    return 1;
  } //;
  sub_2 = ((p_argile_match)->value).call;
  argile_call_uncompile_subcalls(sub_2, 1);
  old = (argile).nextdef_filter;
  (argile).nextdef_filter = ((argile_filter_t)0);
  argile_call_setup(sub_2, c_2, p_argile_call_3);
  if (((argile_call_compile_syntaxes(sub_2) != 0) && (argile_call_compile_as(sub_2, t_2)))) {
    (argile).nextdef_filter = old;
    argile_call_find_all_path(sub_2);
    argile_call_compile_binds(sub_2);
    return 1;
  } //;
  argile_call_take_rejects(p_argile_call_3, sub_2);
  (argile).nextdef_filter = old;
  return 0;
}

static argile_list_t * syn_match(argile_list_t * ls_2, argile_list_t * lp)
/** :syn match <list of (argile syntax) ls> <list of (argile syntax) lp>: -> list of (argile syntax) **/
{
  while (((ls_2) && (lp))) {
    argile_syntax_t * s_18 = ((argile_syntax_t *)0);
    argile_syntax_t * p_2 = ((argile_syntax_t *)0);

    s_18 = *((argile_syntax_t * *)&((argile_list_t *)ls_2)->data);
    p_2 = *((argile_syntax_t * *)&((argile_list_t *)lp)->data);
    switch ((s_18)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        if ((((p_2)->type == (s_18)->type) && (strcmp(((p_2)->value).syn_word, ((s_18)->value).syn_word) == 0))) {
          lp = ((argile_list_t *)lp)->next;
        } //;
      } break;
      case ARGILE_SYN_PARAM: {
        if (((s_18)->type == (p_2)->type)) {
          argile_syn_param_t * sp = ((argile_syn_param_t *)0);
          argile_syn_param_t * pp = ((argile_syn_param_t *)0);

          sp = ((s_18)->value).syn_param;
          pp = ((p_2)->value).syn_param;
          if ((match_match((sp)->match, (pp)->match) == NULL)) {
            lp = ((argile_list_t *)lp)->next;
          } //;
        } //;
      } break;
      case ARGILE_SYN_OPTION: {
        lp = syn_match(((s_18)->value).syn_option, lp);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s_18)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          lp = syn_match(*((argile_list_t * *)&((argile_list_t *)le)->data), lp);
        };
      } break;
      case ARGILE_SYN_LIST: {
        lp = syn_match((((s_18)->value).syn_list)->sub, lp);
      } break;
      default: {} break;
    };
    ls_2 = ((argile_list_t *)ls_2)->next;
  };
  return lp;
}

static argile_list_t * match_match(argile_list_t * lm, argile_list_t * lp_2)
/** :match match <list of (match) lm> <list of (match) lp>: -> list of (match) **/
{
  while (((lm) && (lp_2))) {
    argile_match_t * m = ((argile_match_t *)0);
    argile_match_t * p_2 = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    p_2 = *((argile_match_t * *)&((argile_list_t *)lp_2)->data);
    switch ((m)->type) {
      case ARGILE_MATCH_WORD: ;
      case ARGILE_MATCH_OP: {
        if ((((p_2)->type == (m)->type) && (strcmp(((p_2)->value).word, ((m)->value).word) == 0))) {
          lp_2 = ((argile_list_t *)lp_2)->next;
        } //;
      } break;
      case ARGILE_MATCH_CONS: {
        if ((((p_2)->type == (m)->type) && (argile_cons_eq((p_2)->value.cons, (m)->value.cons)))) {
          lp_2 = ((argile_list_t *)lp_2)->next;
        } //;
      } break;
      case ARGILE_MATCH_SUBCALL: {
        if (((p_2)->type == (m)->type)) {
          if ((match_match((((m)->value).call)->match, (((p_2)->value).call)->match) == NULL)) {
            lp_2 = ((argile_list_t *)lp_2)->next;
          } //;
        } //;
        else {
          lp_2 = match_match((((m)->value).call)->match, lp_2);
        };
      } break;
      default: {} break;
    };
    lm = ((argile_list_t *)lm)->next;
  };
  return lp_2;
}

static void module_call(argile_list_t * ls_3, argile_buff_t * bt, char * w, argile_list_t * ls2, argile_buff_t * out_2)
/** :module call <list of (argile syntax) ls> <buff bt> <text w> <list of (argile syntax) ls2> <buff out>: -> nothing **/
{
  for (; (ls_3); ls_3 = ((argile_list_t *)ls_3)->next) {
    argile_syntax_t * s_18 = ((argile_syntax_t *)0);

    s_18 = *((argile_syntax_t * *)&((argile_list_t *)ls_3)->data);
    switch ((s_18)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        argile_buff_puts(out_2, ((s_18)->value).syn_word);
        argile_buff_putc(out_2, ' ');
      } break;
      case ARGILE_SYN_PARAM: {
        switch ((((s_18)->value).syn_param)->type) {
          case ARGILE_TYPE_TYPE: {
            argile_buff_putc(out_2, *&("(")[0]);
            argile_buff_cat(out_2, bt);
            argile_buff_putc(out_2, *&(")")[0]);
            argile_buff_putc(out_2, ' ');
          } break;
          case ARGILE_TYPE_WORD: {
            if (((w) && (*&(w)[0]))) {
              argile_buff_puts(out_2, w);
              argile_buff_putc(out_2, ' ');
            } //;
          } break;
          case ARGILE_TYPE_SYNTAX: {
            argile_buff_putc(out_2, *&(":")[0]);
            argile_syntax_string(ls2, out_2);
            argile_buff_putc(out_2, *&(":")[0]);
            argile_buff_putc(out_2, ' ');
          } break;
          default: {
            argile_buff_puts(out_2, "(nil) ");
          } break;
        };
      } break;
      case ARGILE_SYN_OPTION: {
        module_call(((s_18)->value).syn_option, bt, w, ls2, out_2);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s_18)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          if (!(missing_param(*((argile_list_t * *)&((argile_list_t *)le)->data), w, ls2))) {
            module_call(*((argile_list_t * *)&((argile_list_t *)le)->data), bt, w, ls2, out_2);
            break;
          } //;
        };
        if (((le == NULL) && (((s_18)->value).syn_enum))) {
          module_call(*((argile_list_t * *)&((argile_list_t *)((s_18)->value).syn_enum)->data), bt, w, ls2, out_2);
        } //;
      } break;
      case ARGILE_SYN_LIST: {
        int i_2 = 0;
        int min_2 = 1;

        if (((((s_18)->value).syn_list)->min > 1)) {
          min_2 = (((s_18)->value).syn_list)->min;
        } //;
        for (i_2 = 0; (i_2 < min_2); (i_2)++) {
          module_call((((s_18)->value).syn_list)->sub, bt, w, ls2, out_2);
        };
      } break;
      default: {} break;
    };
  };
}

static unsigned char missing_param(argile_list_t * ls_4, char * w_2, argile_list_t * ls2_2)
/** :missing param <list of (argile syntax) ls> <text w> <list of (argile syntax) ls2>: -> bool **/
{
  for (; (ls_4); ls_4 = ((argile_list_t *)ls_4)->next) {
    argile_syntax_t * s_19 = ((argile_syntax_t *)0);

    s_19 = *((argile_syntax_t * *)&((argile_list_t *)ls_4)->data);
    switch ((s_19)->type) {
      case ARGILE_SYN_PARAM: {
        argile_type_t t_3;

        t_3 = (((s_19)->value).syn_param)->type;
        if ((t_3 == ARGILE_TYPE_WORD)) {
          if (((w_2 == NULL) || (*&(w_2)[0] == 0))) {
            return 1;
          } //;
        } //;
        else if ((t_3 == ARGILE_TYPE_SYNTAX)) {
          if ((ls2_2 == NULL)) {
            return 1;
          } //;
        } //;
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le_2;

        le_2 = ((s_19)->value).syn_enum;
        for (; (le_2); le_2 = ((argile_list_t *)le_2)->next) {
          if (!(missing_param(*((argile_list_t * *)&((argile_list_t *)le_2)->data), w_2, ls2_2))) {
            break;
          } //;
        };
        if ((le_2 == NULL)) {
          return 1;
        } //;
      } break;
      case ARGILE_SYN_LIST: {
        if (((((s_19)->value).syn_list)->min > 0)) {
          if (missing_param((((s_19)->value).syn_list)->sub, w_2, ls2_2)) {
            return 1;
          } //;
        } //;
      } break;
      default: {} break;
    };
  };
  return 0;
}

