// generated by: arc -xuNP -A ./../argrt -M -o std_autocast.c -H std_autocast.h -m std_autocast.argl.tmp std_autocast.arg 
#include "std_autocast.h"

int argmod_autocast_modulable = 1;
char( argmod_autocast_doc[]) = {"Add a global automatic implicit type caster;\ntakes a `from' and a `to' type parameters.\nWhen the `reciprocal' option is specified at binding,\nan additionnal caster is added (`to' and `from' types inverted). An optional\ncode block can also be specified (except with `reciprocal' option) to call\ncustom code at casts, then the `from' type parameter is defined in the\nblock with the same syntax as the type itself.\nSyntax requirements:\n  :<type from> <type to>:\n  :<type from> <type to> <code>:\n"};

int argmod_autocast_reject(argile_call_t * p_argile_call)
/** :argmod_autocast_reject <call>: -> int **/
{
  argile_match_t * m = ((argile_match_t *)0);
  argile_shovel_t * sh = ((argile_shovel_t *)0);

  sh = argile_shovel_new(p_argile_call);
  if ((argile_def_has_option((p_argile_call)->def, "reciprocal"))) {
    m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
    if ((m == NULL)) {
      argile_shovel_del(sh);
      return argile_call_add_reject(p_argile_call, "std/autocast: ""missing types");
    } //;
    if ((((((int)argile_match_eval_type(m)) >> 31) & 1))) {
      return argile_call_add_reject(p_argile_call, "std/autocast: ""from a reference type");
    } //;
    m = argile_shovel_digmatch(sh, 2, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
    argile_shovel_del(sh);
    if ((m == NULL)) {
      return argile_call_add_reject(p_argile_call, "std/autocast: ""missing second type");
    } //;
    if ((((((int)argile_match_eval_type(m)) >> 31) & 1))) {
      return argile_call_add_reject(p_argile_call, "std/autocast: ""from a reference type");
    } //;
  } //;
  else {
    m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, "from");
    argile_shovel_del(sh);
    if ((m == NULL)) {
      return argile_call_add_reject(p_argile_call, "std/autocast: ""missing `from' type");
    } //;
    if ((((((int)argile_match_eval_type(m)) >> 31) & 1))) {
      return argile_call_add_reject(p_argile_call, "std/autocast: ""from a reference type");
    } //;
  };
  return 0;
}

void argmod_autocast_compile(argile_call_t * p_argile_call_2)
/** :argmod_autocast_compile <call>: -> nothing **/
{
  argile_list_t * lfrom = ((argile_list_t *)0);
  argile_type_t from;
  argile_type_t to;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  unsigned char r;
  argile_match_t * m = ((argile_match_t *)0);

  from = (argile_type_t)ARGILE_TYPE_NOTHING;
  to = (argile_type_t)ARGILE_TYPE_NOTHING;
  sh = argile_shovel_new(p_argile_call_2);
  r = (argile_def_has_option((p_argile_call_2)->def, "reciprocal"));
  m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, ((!(r)) ? ("from") : (NULL)));
  if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
    lfrom = (((m)->value).call)->match;
    from = argile_match_eval_type(m);
  } //;
  if (r) {
    m = argile_shovel_digmatch(sh, 2, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
  } //;
  else {
    m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, "to");
  };
  if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
    to = argile_match_eval_type(m);
  } //;
  if (((from != ARGILE_TYPE_NOTHING) && (to != ARGILE_TYPE_NOTHING))) {
    argile_type_info_t * info = ((argile_type_info_t *)0);
    argile_code_t * code = ((argile_code_t *)0);

    info = argile_type_get_info(from);
    if ((info == NULL)) {
      info = argile_type_set_info(from, ARGILE_TYPE_KIND_BIND);
    } //;
    m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0);
    if (((m) && (code = argile_match_eval_code(m)))) {
      argile_list_t * syn = ((argile_list_t *)0);
      argile_syn_param_t * p = ((argile_syn_param_t *)0);
      argile_list_t * lm;
      argile_def_t * d = ((argile_def_t *)0);

      p = argile_syn_param_new(argile_list_shadow(lfrom), ((argile_match_t *)0));
      (p)->type = from;
      (p)->comp = 1;
      lm = lfrom;
      for (; (lm); lm = ((argile_list_t *)lm)->next) {
        m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
        if ((m == NULL)) {
          continue;
        } //;
        switch ((m)->type) {
          case ARGILE_MATCH_WORD: {
            argile_syntax_t * s = ((argile_syntax_t *)0);

            s = argile_syntax_new(ARGILE_SYN_WORD, argile_dbg_strdup(((m)->value).word));
            argile_list_append(&syn, argile_list_new(s, (void *)&argile_syntax_del));
          } break;
          case ARGILE_MATCH_OP: {
            argile_syntax_t * s = ((argile_syntax_t *)0);

            s = argile_syntax_new(ARGILE_SYN_OP, argile_dbg_strdup(((m)->value).op));
            argile_list_append(&syn, argile_list_new(s, (void *)&argile_syntax_del));
          } break;
          default: {} break;
        };
      };
      syn = argile_list_start(syn);
      argile_code_caster(code, from, to);
      d = argile_def_new(syn, 1, (((((((int)from) >> 30) & 1))) ? (from) : ((((int)(((int)from) & ((1 << 30) - 1))) | (1 << 31)))), ((argile_call_t *)0), ARGILE_DEF_VAR, argile_var_new(from, ((argile_match_t *)0)));
      (d)->param = p;
      (p)->def = d;
      argile_code_def(code, d, 1);
      (p_argile_call_2)->data = p;
      (p_argile_call_2)->del = (void *)&argile_syn_param_del;
    } //;
    argile_list_prepend(&(info)->casters, argile_list_new(argile_type_caster_new(to, code), (void *)&argile_type_caster_del));
    if (r) {
      argile_list_t * lcast;

      info = argile_type_get_info(to);
      if ((info == NULL)) {
        info = argile_type_set_info(to, ARGILE_TYPE_KIND_BIND);
      } //;
      lcast = argile_list_new(argile_type_caster_new(from, ((argile_code_t *)0)), (void *)&argile_type_caster_del);
      argile_list_prepend(&(info)->casters, lcast);
    } //;
  } //;
  else {
    argile_die_at(p_argile_call_2, "std/autocast: ""both from-type and to-type are required");
  };
  argile_shovel_del(sh);
}

