// generated by: arc -xuNP -A ./../argrt -M -o file.c -H file.h -m file.argl.tmp file.arg 

#ifdef WIN32 //;
#include <unistd.h> //;
#include <windows.h> //;

#endif //;

#include "file.h"

argile_file_t * argile_file_new(char * path, struct stat * pst)
/** :argile_file_new <text path> <stat pst>: -> (argile) file **/
{
  argile_file_t * file = ((argile_file_t *)0);

  file = ((argile_file_t *)memset(argile_dbg_malloc(sizeof(argile_file_t)), 0, sizeof(argile_file_t)));
  (file)->path = argile_dbg_strdup(path);
  
#ifndef WIN32 //;
  (file)->error = 0;
  if ((pst)) {
    (file)->device = (pst)->st_dev;
    (file)->inode = (pst)->st_ino;
  } //;
  else {
    struct stat st = ((struct stat){0});

    if ((stat(path, &st) != 0)) {
      (file)->error = errno;
    } //;
    else {
      (file)->device = (st).st_dev;
      (file)->inode = (st).st_ino;
    };
  };
  
#else //;
  (file)->error = 1;
  if (!((access((file)->path, F_OK)))) {
    HANDLE wf;

    wf = CreateFile((file)->path,0,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS|FILE_ATTRIBUTE_READONLY,NULL);
    if ((wf != INVALID_HANDLE_VALUE)) {
      BY_HANDLE_FILE_INFORMATION wi;

      ZeroMemory(&wi, sizeof(wi));
      if ((GetFileInformationByHandle(wf, &wi))) {
        (file)->device = wi.nFileIndexHigh;
        (file)->inode = wi.nFileIndexLow;
        (file)->error = 0;
      } //;
    } //;
  } //;
  
#endif //;
  (file)->code = ((argile_code_t *)0);
  return file;
}

void argile_file_del(argile_file_t * p_argile_file)
/** :argile_file_del <file>: -> nothing **/
{
  argile_dbg_free((p_argile_file)->path);
  if (((p_argile_file)->code)) {
    argile_code_del((p_argile_file)->code);
  } //;
  argile_dbg_free(p_argile_file);
}

int argile_file_eq(argile_file_t * fa, argile_file_t * fb)
/** :argile_file_eq <file fa> <file fb>: -> int **/
{
  if (((fa == NULL) != (fb == NULL))) {
    return 0;
  } //;
  return ((int)(((((fa)->error == 0) && ((fb)->error == 0)) && ((fa)->device == (fb)->device)) && ((fa)->inode == (fb)->inode)));
}

int argile_filename_eq(argile_file_t * f, char * path_2)
/** :argile_filename_eq <file f> <text path>: -> int **/
{
  if (((f == NULL) || ((f)->error != 0))) {
    return 1;
  } //;
  return ((int)(strcmp((f)->path, path_2) == 0));
}

void argile_file_load(argile_file_t * p_argile_file_2)
/** :argile_file_load <file>: -> nothing **/
{
  argile_code_t * oldmain = ((argile_code_t *)0);
  argile_inout_t oldinput;
  char * oldname = "";
  unsigned char oldcmt;
  argile_list_t * oldinc;
  argile_list_t * oldsys;
  unsigned char oldmonly;
  argile_stats_t oldstat = ((argile_stats_t){0});
  argile_list_t * oldglob;
  argile_list_t * ldef;

  oldmain = (argile).main;
  oldinput = (argile).input;
  oldname = (argile).input_name;
  oldcmt = (argile).get_comments;
  oldinc = (argile).includes;
  oldsys = (argile).sysincludes;
  oldmonly = (argile).main_only;
  oldstat = (argile).stat;
  oldglob = (argile).globally;
  (p_argile_file_2)->depth = ++((argile).depth);
  if (((argile).lazy && !((argile).cat_main))) {
    (argile).main_only = 1;
  } //;
  (argile).includes = ((argile_list_t *)0);
  (argile).sysincludes = ((argile_list_t *)0);
  (argile).input = (void *)&argile_input_path;
  (argile).input_name = (p_argile_file_2)->path;
  (argile).globally = ((argile_list_t *)0);
  (argile).get_comments = 0;
  memset(&(argile).stat, 0, sizeof(*&(argile).stat));
  (p_argile_file_2)->code = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  (argile).main = (p_argile_file_2)->code;
  for (ldef = (oldmain)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ldef)->data.u_anything));
    if ((d)->implicit) {
      argile_code_def((argile).main, d, 0);
      ((argile).main)->has_weak_defs = 1;
    } //;
  };
  if (((argile_parse((p_argile_file_2)->path) != 0) || (argile_compile() != 0))) {
    (p_argile_file_2)->code = ((argile_code_t *)0);
    if (((argile).killer)) {
      argile_list_prepend(&(argile).leaks, argile_list_new((argile).main, (void *)&argile_code_del));
    } //;
    else {
      argile_code_del((argile).main);
    };
  } //;
  argile_list_del((argile).includes);
  argile_list_del((argile).sysincludes);
  argile_list_del((argile).globally);
  for (ldef = (oldmain)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ldef)->data.u_anything));
    if ((d)->implicit) {
      (d)->scope = oldmain;
    } //;
  };
  if (((argile).main_only && ((p_argile_file_2)->code != NULL))) {
    for (ldef = ((p_argile_file_2)->code)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ldef)->data.u_anything));
      if (((d)->dtype == ARGILE_DEF_FUNC)) {
        argile_code_t * c = ((argile_code_t *)0);

        c = ((d)->dval).code;
        if (((c) && !((c)->macro))) {
          argile_list_del((c)->calls);
          (c)->calls = ((argile_list_t *)0);
        } //;
      } //;
    };
  } //;
  (argile).input = oldinput;
  (argile).input_name = oldname;
  (argile).main = oldmain;
  (argile).get_comments = oldcmt;
  (argile).includes = oldinc;
  (argile).sysincludes = oldsys;
  (argile).main_only = oldmonly;
  *&(argile).stat = *&oldstat;
  (argile).globally = oldglob;
  ((argile).depth)--;
}

