// generated by: arc -xuNP -A ./../argrt -M -o call.c -H call.h -m call.argl.tmp call.arg 
#include "call.h"

typedef struct call_path_t_s call_path_t;

struct call_path_t_s {
  int prm;
  int opt;
  int enm;
  int lst;
  argile_list_t * match;
  argile_call_t * call;
};

static unsigned char _compile_as(argile_call_t *, argile_type_t);
/** :_compile <call> as <argile type type>: -> bool **/
static argile_call_t * owner_most_of(argile_call_t *);
/** :owner - most of <call>: -> (argile) call **/
static unsigned char is_made_in(argile_def_t *, argile_call_t *);
/** :<def> is made in <call>: -> bool **/
static void _push_macro_params(argile_code_t *, argile_call_t *);
/** :_push_macro_params <argile code code> <call>: -> nothing **/
static void _pop_macro_params(argile_code_t *);
/** :_pop_macro_params <argile code code>: -> nothing **/
static unsigned char has_several_calls(argile_code_t *);
/** :<argile code code> has several calls: -> bool **/
static unsigned char propagate_autoparam_from(argile_def_t *, argile_call_t *);
/** :propagate autoparam <def> from <call>: -> bool **/
static argile_list_t * shadow_of_matches(argile_call_t * * p_argile_call, argile_list_t *, argile_call_t *, argile_type_t);
/** :shadow of matches <list of (match) matches> <call owner> <argile type type>: -> list of (match) **/
static unsigned char _match_path_rec(call_path_t *, argile_list_t *, int*);
/** :_match_path_rec <call_path path> <list of (argile syntax) syntax> <(int) * eaten>: -> bool **/
static void _fix_path_rec(call_path_t *, argile_list_t *);
/** :_fix_path_rec <call_path path> <list of (argile syntax) syntax>: -> nothing **/
static void _make_call_list(call_path_t *, argile_call_list_t *, argile_list_t *);
/** :_make_call_list <call_path path> <call list cl> <list of (argile syntax) syntax>: -> nothing **/
static void _undo_call_list(call_path_t *, argile_call_list_t *);
/** :_undo_call_list <call_path path> <call list cl>: -> nothing **/
static void _add_param_value(call_path_t *, argile_syn_param_t *, argile_match_t *);
/** :_add_param_value <call_path path> <syn param syn_param> <match>: -> nothing **/
static argile_list_t * _add_syn_val(argile_list_t * *, int);
/** :_add_syn_val <(list of (list of (int))) & list> <int id>: -> list of (int) **/
static unsigned char _match_no_more(call_path_t *, argile_list_t *);
/** :_match_no_more <call_path path> <list of (argile syntax) syn>: -> bool **/
static void _count_syn(argile_list_t *, int, int *, int *, int *, int *, int *);
/** :_count_syn <list of (match) match> <int max> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static int _xc2a7_(char *);
/** :§ <text t>: -> int **/
static void _adj_syn(argile_list_t *, int, int *, int *, int *, int *, int *);
/** :_adj_syn <list of (match) match> <int add> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
static void _print_compil_(argile_call_t *, argile_type_t);
/** :_print_compil_ <call> <argile type type>: -> nothing **/
static unsigned char known_call_signature_of(argile_call_t *, argile_def_t *, int, int);
/** :known call signature of <call> + <def> + <int off> + <int len>: -> bool **/
static void make_call_signature_of_in(argile_call_t *, argile_def_t *, int, int, argile_buff_t *);
/** :make call signature of <call> + <def> + <int off> + <int len> in <buff>: -> nothing **/
static unsigned char bypass_deps_only(argile_call_t *);
/** :bypass deps only <call>: -> bool **/
static unsigned char fix_param_enum(argile_list_t *, argile_match_t *, argile_call_t *);
/** :fix param enum <list of (argile syntax) ls> <match m> <call c>: -> bool **/
static unsigned char is_enum_of_param(argile_list_t *, argile_syntax_t *);
/** :<list of (list of (argile syntax)) le> is enum of param <argile syntax matched>: -> bool **/
static void _def_params_locall(argile_list_t *, argile_call_t *);
/** :_def_params_locall <list of (argile syntax) syntax> <call>: -> nothing **/
static argile_list_t * _get_union_fields(argile_type_t, argile_type_t);
/** :_get_union_fields <argile type ctx> <argile type type>: -> list of (field) **/
static void _call_args(argile_call_t *);
/** :_call_args <call>: -> nothing **/
static void _comma(unsigned char *);
/** :_comma <(bool) & first>: -> nothing **/
static argile_code_t * _get_macro_body(argile_code_t *, argile_def_t *);
/** :_get_macro_body <argile code code> <def>: -> argile code **/

static argile_list_t raw_head = ((argile_list_t){0});

argile_call_t * argile_call_new(argile_def_t * p_argile_def, argile_list_t * match)
/** :argile_call_new <def> <list of (match) match>: -> (argile) call **/
{
  argile_call_t * call = ((argile_call_t *)0);

  call = ((argile_call_t *)memset(argile_dbg_malloc(sizeof(argile_call_t)), 0, sizeof(argile_call_t)));
  (call)->type = ARGILE_CALL_EXPLICIT;
  (call)->def = p_argile_def;
  (call)->match = match;
  (call)->compiled = (((p_argile_def == NULL)) ? (0) : (1));
  return call;
}

void argile_call_del(argile_call_t * p_argile_call_2)
/** :argile_call_del <call>: -> nothing **/
{
  if ((p_argile_call_2 == NULL)) {
    return;
  } //;
  if (((p_argile_call_2)->del)) {
    (*(p_argile_call_2)->del)((p_argile_call_2)->data);
  } //;
  argile_list_del((p_argile_call_2)->pot_defs);
  argile_list_del((p_argile_call_2)->rejects);
  argile_list_del((p_argile_call_2)->match);
  argile_list_del((p_argile_call_2)->params);
  argile_list_del((p_argile_call_2)->options);
  argile_list_del((p_argile_call_2)->enums);
  argile_list_del((p_argile_call_2)->lists);
  if (((p_argile_call_2)->comment)) {
    argile_dbg_free((p_argile_call_2)->comment);
  } //;
  if (((p_argile_call_2)->sigs)) {
    int s = 0;

    for (s = 0; ((s <= (256 - 1))); (s)++) {
      argile_list_del(((p_argile_call_2)->sigs)[s]);
    };
    argile_dbg_free((p_argile_call_2)->sigs);
  } //;
  argile_dbg_free(p_argile_call_2);
}

int argile_call_eq(argile_call_t * ca, argile_call_t * cb)
/** :argile_call_eq <call ca> <call cb>: -> int **/
{
  if ((ca == cb)) {
    return 1;
  } //;
  if (((ca == NULL) || (cb == NULL))) {
    return 0;
  } //;
  if ((((ca)->def == NULL) && ((cb)->def == NULL))) {
    if ((((ca)->match == NULL) || ((cb)->match == NULL))) {
      return 0;
    } //;
    return ((int)(argile_match_eq(*((argile_match_t * *)&((argile_list_t *)(ca)->match)->data), *((argile_match_t * *)&((argile_list_t *)(cb)->match)->data))));
  } //;
  if (((ca)->def != (cb)->def)) {
    if ((((ca)->def) && (((cb)->def) && ((((ca)->def)->param) || (((cb)->def)->param))))) {
      if ((((ca)->def)->param != ((cb)->def)->param)) {
        return 0;
      } //;
    } else {
      return 0;
    };
  } //;
  if (((ca)->params != (cb)->params)) {
    argile_list_t * la;
    argile_list_t * lb;

    la = (ca)->params;
    lb = (cb)->params;
    while (((la) && (lb))) {
      argile_call_param_t * cpa = ((argile_call_param_t *)0);
      argile_call_param_t * cpb = ((argile_call_param_t *)0);
      argile_list_t * lla;
      argile_list_t * llb;

      cpa = *((argile_call_param_t * *)&((argile_list_t *)la)->data);
      cpb = *((argile_call_param_t * *)&((argile_list_t *)lb)->data);
      if (((cpa)->syn_param != (cpb)->syn_param)) {
        return 0;
      } //;
      lla = (cpa)->matches;
      llb = (cpb)->matches;
      while (((lla) && (llb))) {
        if (!((argile_match_eq(*((argile_match_t * *)&((argile_list_t *)lla)->data), *((argile_match_t * *)&((argile_list_t *)llb)->data))))) {
          return 0;
        } //;
        lla = ((argile_list_t *)lla)->next;
        llb = ((argile_list_t *)llb)->next;
      };
      if (((lla) || (llb))) {
        return 0;
      } //;
      la = ((argile_list_t *)la)->next;
      lb = ((argile_list_t *)lb)->next;
    };
    if (((la) || (lb))) {
      return 0;
    } //;
  } //;
  if (((ca)->options != (cb)->options)) {
    argile_list_t * la;
    argile_list_t * lb;

    la = (ca)->options;
    lb = (cb)->options;
    while (((la) && (lb))) {
      if ((*((argile_list_t * *)&((argile_list_t *)la)->data) != *((argile_list_t * *)&((argile_list_t *)lb)->data))) {
        argile_list_t * lla;
        argile_list_t * llb;

        lla = *((argile_list_t * *)&((argile_list_t *)la)->data);
        llb = *((argile_list_t * *)&((argile_list_t *)lb)->data);
        while (((lla) && (llb))) {
          if ((*((int *)&((argile_list_t *)lla)->data.u_int) != *((int *)&((argile_list_t *)llb)->data.u_int))) {
            return 0;
          } //;
          lla = ((argile_list_t *)lla)->next;
          llb = ((argile_list_t *)llb)->next;
        };
        if (((lla) || (llb))) {
          return 0;
        } //;
      } //;
      la = ((argile_list_t *)la)->next;
      lb = ((argile_list_t *)lb)->next;
    };
    if (((la) || (lb))) {
      return 0;
    } //;
  } //;
  if (((ca)->enums != (cb)->enums)) {
    argile_list_t * la;
    argile_list_t * lb;

    la = (ca)->enums;
    lb = (cb)->enums;
    while (((la) && (lb))) {
      if ((*((argile_list_t * *)&((argile_list_t *)la)->data) != *((argile_list_t * *)&((argile_list_t *)lb)->data))) {
        argile_list_t * lla;
        argile_list_t * llb;

        lla = *((argile_list_t * *)&((argile_list_t *)la)->data);
        llb = *((argile_list_t * *)&((argile_list_t *)lb)->data);
        while (((lla) && (llb))) {
          if ((*((int *)&((argile_list_t *)lla)->data.u_int) != *((int *)&((argile_list_t *)llb)->data.u_int))) {
            return 0;
          } //;
          lla = ((argile_list_t *)lla)->next;
          llb = ((argile_list_t *)llb)->next;
        };
        if (((lla) || (llb))) {
          return 0;
        } //;
      } //;
      la = ((argile_list_t *)la)->next;
      lb = ((argile_list_t *)lb)->next;
    };
    if (((la) || (lb))) {
      return 0;
    } //;
  } //;
  if (((ca)->lists != (cb)->lists)) {
    argile_list_t * la;
    argile_list_t * lb;

    la = (ca)->lists;
    lb = (cb)->lists;
    while (((la) && (lb))) {
      argile_call_list_t * cla = ((argile_call_list_t *)0);
      argile_call_list_t * clb = ((argile_call_list_t *)0);

      cla = *((argile_call_list_t * *)&((argile_list_t *)la)->data);
      clb = *((argile_call_list_t * *)&((argile_list_t *)lb)->data);
      if (((cla)->values != (clb)->values)) {
        argile_list_t * lla;
        argile_list_t * llb;

        lla = (cla)->values;
        llb = (clb)->values;
        while (((lla) && (llb))) {
          if ((*((int *)&((argile_list_t *)lla)->data.u_int) != *((int *)&((argile_list_t *)llb)->data.u_int))) {
            return 0;
          } //;
          lla = ((argile_list_t *)lla)->next;
          llb = ((argile_list_t *)llb)->next;
        };
        if (((lla) || (llb))) {
          return 0;
        } //;
      } //;
      la = ((argile_list_t *)la)->next;
      lb = ((argile_list_t *)lb)->next;
    };
    if (((la) || (lb))) {
      return 0;
    } //;
  } //;
  return 1;
}

argile_call_t * argile_call_shadow(argile_call_t * p_argile_call)
/** :argile_call_shadow <call>: -> (argile) call **/
{
  argile_call_t * copy = ((argile_call_t *)0);
  argile_list_t * tail;
  argile_list_t * list;

  copy = argile_call_new((p_argile_call)->def, ((argile_list_t *)0));
  (copy)->context = (p_argile_call)->context;
  (copy)->scope = (p_argile_call)->scope;
  *&(copy)->loc = *&(p_argile_call)->loc;
  (copy)->matched = (p_argile_call)->matched;
  (copy)->rejected = (p_argile_call)->rejected;
  (copy)->stealth = (p_argile_call)->stealth;
  (copy)->match = shadow_of_matches(&p_argile_call, (p_argile_call)->match, copy, (argile_type_t)ARGILE_TYPE_NOTHING);
  tail = ((argile_list_t *)0);
  for (list = (p_argile_call)->params; (list); list = ((argile_list_t *)list)->next) {
    argile_call_param_t * dst = ((argile_call_param_t *)0);
    argile_call_param_t * src = ((argile_call_param_t *)0);

    src = ((argile_call_param_t *)*((void * *)&((argile_list_t *)list)->data.u_anything));
    dst = argile_call_param_new((src)->syn_param, shadow_of_matches(&p_argile_call, (src)->matches, copy, ((src)->syn_param)->type));
    (dst)->def = (src)->def;
    argile_list_append(&tail, argile_list_new(dst, (void *)&argile_call_param_del));
    if (((copy)->params == NULL)) {
      (copy)->params = ((argile_list_t *)tail);
    } //;
  };
  tail = ((argile_list_t *)0);
  for (list = (p_argile_call)->options; (list); list = ((argile_list_t *)list)->next) {
    argile_list_append(&tail, argile_list_new(argile_list_shadow(((argile_list_t *)*((void * *)&((argile_list_t *)list)->data.u_anything))), (void *)&argile_list_del));
    if (((copy)->options == NULL)) {
      (copy)->options = ((argile_list_t *)tail);
    } //;
  };
  tail = ((argile_list_t *)0);
  for (list = (p_argile_call)->enums; (list); list = ((argile_list_t *)list)->next) {
    argile_list_append(&tail, argile_list_new(argile_list_shadow(((argile_list_t *)*((void * *)&((argile_list_t *)list)->data.u_anything))), (void *)&argile_list_del));
    if (((copy)->enums == NULL)) {
      (copy)->enums = ((argile_list_t *)tail);
    } //;
  };
  tail = ((argile_list_t *)0);
  for (list = (p_argile_call)->lists; (list); list = ((argile_list_t *)list)->next) {
    argile_call_list_t * dst = ((argile_call_list_t *)0);
    argile_call_list_t * src = ((argile_call_list_t *)0);

    src = ((argile_call_list_t *)*((void * *)&((argile_list_t *)list)->data.u_anything));
    dst = argile_call_list_new(argile_list_shadow((src)->params), argile_list_shadow((src)->options), argile_list_shadow((src)->enums), argile_list_shadow((src)->lists));
    (dst)->values = argile_list_shadow((src)->values);
    argile_list_append(&tail, argile_list_new(dst, (void *)&argile_call_list_del));
    if (((copy)->lists == NULL)) {
      (copy)->lists = ((argile_list_t *)tail);
    } //;
  };
  return copy;
}

argile_call_param_t * argile_call_param_new(argile_syn_param_t * synparam, argile_list_t * matches)
/** :argile_call_param_new <syn param synparam> <list of (match) matches>: -> (argile) call param **/
{
  argile_call_param_t * cp = ((argile_call_param_t *)0);

  cp = ((argile_call_param_t *)memset(argile_dbg_malloc(sizeof(argile_call_param_t)), 0, sizeof(argile_call_param_t)));
  (cp)->syn_param = synparam;
  (cp)->matches = matches;
  return cp;
}

void argile_call_param_del(argile_call_param_t * cp)
/** :argile_call_param_del <call param cp>: -> nothing **/
{
  argile_list_del((cp)->matches);
  argile_dbg_free(cp);
}

argile_call_list_t * argile_call_list_new(argile_list_t * params, argile_list_t * options, argile_list_t * enums, argile_list_t * lists)
/** :argile_call_list_new <list of (int) params> <list of (int) options> <list of (int) enums> <list of (int) lists>: -> (argile) call list **/
{
  argile_call_list_t * cl = ((argile_call_list_t *)0);

  cl = ((argile_call_list_t *)memset(argile_dbg_malloc(sizeof(argile_call_list_t)), 0, sizeof(argile_call_list_t)));
  (cl)->params = params;
  (cl)->options = options;
  (cl)->enums = enums;
  (cl)->lists = lists;
  return cl;
}

void argile_call_list_del(argile_call_list_t * cl)
/** :argile_call_list_del <call list cl>: -> nothing **/
{
  argile_list_del((cl)->values);
  argile_list_del((cl)->params);
  argile_list_del((cl)->options);
  argile_list_del((cl)->enums);
  argile_list_del((cl)->lists);
  argile_dbg_free(cl);
}

void argile_call_string(argile_call_t * p_argile_call_3, int indent, argile_buff_t * buf)
/** :argile_call_string <call> <int indent> <buff buf>: -> nothing **/
{
  argile_list_t * m;

  if ((p_argile_call_3)->rejected) {
    argile_push_color(buf, "\x1b[1;33m");
  } else if ((p_argile_call_3)->compiled) {
    argile_push_color(buf, "\x1b[1;32m");
  } //;
  m = (p_argile_call_3)->match;
  for (; (m); m = ((argile_list_t *)m)->next) {
    if ((*((argile_match_t * *)&((argile_list_t *)m)->data) == NULL)) {
      continue;
    } //;
    if ((!((p_argile_call_3)->compiled) && !((p_argile_call_3)->rejected))) {
      argile_match_string(*((argile_match_t * *)&((argile_list_t *)m)->data), indent, buf, 1);
    } else {
      argile_match_string(*((argile_match_t * *)&((argile_list_t *)m)->data), indent, buf, 0);
    };
    if ((((argile_list_t *)m)->next != NULL)) {
      argile_buff_putc(buf, ' ');
    } //;
  };
  if (((p_argile_call_3)->compiled || (p_argile_call_3)->rejected)) {
    argile_pop_color(buf);
  } //;
}

void argile_call_find_all_path(argile_call_t * p_argile_call_4)
/** :argile_call_find_all_path <call>: -> nothing **/
{
  argile_list_t * lm;

  lm = (p_argile_call_4)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      argile_call_find_all_path(((m)->value).call);
    } //;
  };
  if ((((((p_argile_call_4)->params == NULL) && ((p_argile_call_4)->options == NULL)) && ((p_argile_call_4)->enums == NULL)) && ((p_argile_call_4)->lists == NULL))) {
    argile_call_find_path(p_argile_call_4);
  } //;
}

void argile_call_find_path(argile_call_t * p_argile_call_5)
/** :argile_call_find_path <call>: -> nothing **/
{
  call_path_t path = {0};
  argile_list_t * cur;

  if (((p_argile_call_5)->def == NULL)) {
    return;
  } //;
  (path).call = p_argile_call_5;
  (path).match = (p_argile_call_5)->match;
  _match_path_rec(&path, ((p_argile_call_5)->def)->syntax, ((int*)0));
  (path).prm = 0;
  (path).opt = 0;
  (path).enm = 0;
  (path).lst = 0;
  _fix_path_rec(&path, ((p_argile_call_5)->def)->syntax);
  cur = (p_argile_call_5)->params;
  for (; (cur); cur = ((argile_list_t *)cur)->next) {
    argile_call_param_t * p = ((argile_call_param_t *)0);

    p = *((argile_call_param_t * *)&((argile_list_t *)cur)->data);
    if (((((p_argile_call_5)->def)->dtype == ARGILE_DEF_FUNC) && ((((p_argile_call_5)->def)->dval).code))) {
      argile_list_t * ld;

      ld = ((((p_argile_call_5)->def)->dval).code)->defs;
      for (; (ld); ld = ((argile_list_t *)ld)->next) {
        argile_def_t * d = ((argile_def_t *)0);

        d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
        if ((((d)->param) && ((d)->param == (p)->syn_param))) {
          (p)->def = d;
          break;
        } //;
      };
    } //;
  };
}

void argile_call_unfind_path(argile_call_t * p_argile_call_6)
/** :argile_call_unfind_path <call>: -> nothing **/
{
  {
    argile_list_del((p_argile_call_6)->params);
    (p_argile_call_6)->params = ((argile_list_t *)0);
  };
  {
    argile_list_del((p_argile_call_6)->options);
    (p_argile_call_6)->options = ((argile_list_t *)0);
  };
  {
    argile_list_del((p_argile_call_6)->enums);
    (p_argile_call_6)->enums = ((argile_list_t *)0);
  };
  {
    argile_list_del((p_argile_call_6)->lists);
    (p_argile_call_6)->lists = ((argile_list_t *)0);
  };
}

void argile_call_setup(argile_call_t * p_argile_call_7, argile_code_t * code, argile_call_t * owner)
/** :argile_call_setup <call> <argile code code> <call owner>: -> nothing **/
{
  argile_list_t * cur;

  (p_argile_call_7)->scope = code;
  (p_argile_call_7)->owner = owner;
  for (cur = (p_argile_call_7)->match; (cur); cur = ((argile_list_t *)cur)->next) {
    if ((*((void * *)&((argile_list_t *)cur)->data.u_anything))) {
      argile_match_setup(((argile_match_t *)*((void * *)&((argile_list_t *)cur)->data.u_anything)), p_argile_call_7);
    } //;
  };
}

int argile_call_compile_as(argile_call_t * p_argile_call_8, argile_type_t type)
/** :argile_call_compile_as <call> <argile type type>: -> int **/
{
  argile_list_t * lm;
  int ret = 0;

  (p_argile_call_8)->hit = ++((argile).last_hit);
  (p_argile_call_8)->minmatch = ((short)0);
  (p_argile_call_8)->maxmatch = ((short)0);
  for (lm = (p_argile_call_8)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((((m)->type == ARGILE_MATCH_WORD) || ((m)->type == ARGILE_MATCH_OP))) {
      unsigned int h = 0;
      argile_list_t * ld;

      h = (argile_hash(((m)->value).word) % 4096);
      for (ld = ((argile).defs)[h]; (ld); ld = ((argile_list_t *)ld)->next) {
        argile_def_t * d = ((argile_def_t *)0);

        d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
        if (((d)->hit < (p_argile_call_8)->hit)) {
          (d)->hit = (p_argile_call_8)->hit;
          (d)->hitcombo = ((unsigned short)1);
        } //;
        else {
          ((d)->hitcombo)++;
        };
        if (!((d)->implicit)) {
          ((d)->scope)->hit = (p_argile_call_8)->hit;
        } //;
        if (((p_argile_call_8)->minmatch > (d)->minmatch)) {
          (p_argile_call_8)->minmatch = (d)->minmatch;
        } //;
        if (((p_argile_call_8)->maxmatch >= 0)) {
          if ((((d)->maxmatch < 0) || ((p_argile_call_8)->maxmatch < (d)->maxmatch))) {
            (p_argile_call_8)->maxmatch = (d)->maxmatch;
          } //;
        } //;
      };
    } //;
  };
  if ((((p_argile_call_8)->match) && (((argile_list_t *)(p_argile_call_8)->match)->next))) {
    argile_call_t * owner_2 = ((argile_call_t *)0);
    argile_list_t * prev;
    argile_list_t * next;
    argile_list_t * ldef;
    argile_list_t * first;
    argile_code_t * code_2 = ((argile_code_t *)0);

    argile_list_del((p_argile_call_8)->pot_defs);
    (p_argile_call_8)->pot_defs = ((argile_list_t *)0);
    owner_2 = owner_most_of(p_argile_call_8);
    first = ((argile_list_t *)0);
    code_2 = (p_argile_call_8)->scope;
    argile_code_getdef(code_2, p_argile_call_8, &prev, &next);
    while ((ldef = argile_code_nextdef(&code_2, &prev, &next))) {
      argile_def_t * def = ((argile_def_t *)0);

      if ((((code_2)->hit < (p_argile_call_8)->hit) && !((code_2)->has_weak_defs))) {
        prev = ((argile_list_t *)0);
        next = ((argile_list_t *)0);
        continue;
      } //;
      def = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
      if (((def)->locall && !(is_made_in(def, owner_2)))) {
        continue;
      } //;
      if ((def)->weak) {
        if (((p_argile_call_8)->minmatch > (def)->minmatch)) {
          (p_argile_call_8)->minmatch = (def)->minmatch;
        } //;
        if (((p_argile_call_8)->maxmatch >= 0)) {
          if ((((def)->maxmatch < 0) || ((p_argile_call_8)->maxmatch < (def)->maxmatch))) {
            (p_argile_call_8)->maxmatch = (def)->maxmatch;
          } //;
        } //;
      } //;
      else if ((((def)->hit < (p_argile_call_8)->hit) || ((def)->hitcombo < (def)->mincombo))) {
        continue;
      } //;
      argile_list_append(&(p_argile_call_8)->pot_defs, argile_list_new(def, ((argile_deleter_t)0)));
      if ((first == NULL)) {
        first = (p_argile_call_8)->pot_defs;
      } //;
    };
    (p_argile_call_8)->pot_defs = first;
  } //;
  if ((((p_argile_call_8)->sigs == NULL) && (argile_list_count((p_argile_call_8)->match) > 5))) {
    unsigned int size = 0;

    size = (256 * sizeof(argile_list_t *));
    (p_argile_call_8)->sigs = ((argile_list_t *(*))memset(argile_dbg_malloc(size), 0, size));
  } //;
  ret = ((_compile_as(p_argile_call_8, type)) ? (1) : (0));
  if (((p_argile_call_8)->sigs)) {
    int s = 0;

    for (s = 0; ((s <= (256 - 1))); (s)++) {
      argile_list_del(((p_argile_call_8)->sigs)[s]);
    };
    argile_dbg_free((p_argile_call_8)->sigs);
    (p_argile_call_8)->sigs = ((argile_list_t *(*))0);
  } //;
  return ret;
}

static unsigned char _compile_as(argile_call_t * p_argile_call_9, argile_type_t type_2)
/** :_compile <call> as <argile type type>: -> bool **/
{
  argile_call_t * owner_2 = ((argile_call_t *)0);
  argile_list_t * prev;
  argile_list_t * next;
  argile_list_t * ldef;
  int max = 0;
  int maxwords = 0;
  int maxops = 0;
  int maxparams = 0;
  int maxchars = 0;
  int maxsum = 0;
  unsigned char pd_speedup;
  int len = 0;

  if ((argile).stats) {
    (((argile).stat).num_call_compile_as)++;
  } //;
  if ((p_argile_call_9)->compiled) {
    return 1;
  } //;
  if ((((argile).maxcomp > 0) && ((argile).maxcomp <= (argile).numcomp))) {
    return 0;
  } //;
  ((argile).numcomp)++;
  ((p_argile_call_9)->numcomp)++;
  if ((argile).debugcomp) {
    ((argile).indent)++;
  } //;
  (p_argile_call_9)->context = type_2;
  {
    argile_list_t * lm;

    lm = (p_argile_call_9)->match;
    for (; (lm); lm = ((argile_list_t *)lm)->next) {
      if ((*((argile_match_t * *)&((argile_list_t *)lm)->data))) {
        (*((argile_match_t * *)&((argile_list_t *)lm)->data))->processed = 1;
      } //;
    };
  };
  owner_2 = owner_most_of(p_argile_call_9);
  max = argile_list_count((p_argile_call_9)->match);
  if ((max == 0)) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    code_2 = (p_argile_call_9)->scope;
    argile_code_getdef(code_2, p_argile_call_9, &prev, &next);
    while ((ldef = argile_code_nextdef(&code_2, &prev, &next))) {
      argile_def_t * def = ((argile_def_t *)0);
      argile_type_t calltype;

      def = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
      if ((((def)->syntax) || ((def)->locall && !(is_made_in(def, owner_2))))) {
        continue;
      } //;
      ((def)->numtry)++;
      ((def)->nummatch)++;
      (p_argile_call_9)->matched = 1;
      (p_argile_call_9)->compiled = 1;
      (p_argile_call_9)->def = def;
      calltype = argile_call_get_type(p_argile_call_9);
      if (((type_2 == ARGILE_TYPE_NOTHING) || (argile_type_match(type_2, calltype)))) {
        if (!((argile_call_reject(p_argile_call_9)))) {
          if ((argile).debugcomp) {
            ((argile).indent)--;
            _print_compil_(p_argile_call_9, type_2);
            printf("%s\n", " => OK");
          } //;
          return 1;
        } //;
        (p_argile_call_9)->rejected = 1;
      } else {
        argile_call_mismatch(p_argile_call_9, type_2, calltype, "type mismatch: ");
      };
      (p_argile_call_9)->def = ((argile_def_t *)0);
      (p_argile_call_9)->compiled = 0;
    };
    (p_argile_call_9)->def = ((argile_def_t *)0);
    (p_argile_call_9)->compiled = 0;
    return 0;
  } else if ((max == 1)) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)(p_argile_call_9)->match)->data);
    if ((m)) {
      if ((((m)->type == ARGILE_MATCH_SUBCALL) && ((((m)->value).call)->match == NULL))) {
        argile_call_t * sub = ((argile_call_t *)0);
        unsigned char ret;

        sub = ((m)->value).call;
        ret = _compile_as(sub, type_2);
        (p_argile_call_9)->def = (sub)->def;
        (p_argile_call_9)->compiled = (sub)->compiled;
        return ret;
      } else if ((((m)->type == ARGILE_MATCH_CONS) && ((p_argile_call_9)->type == ARGILE_CALL_EXPLICIT))) {
        if (((type_2 != ARGILE_TYPE_NOTHING) && !((argile_cons_match_type(((m)->value).cons, type_2))))) {
          argile_call_mismatch(p_argile_call_9, type_2, (((m)->value).cons)->type, "bad litteral: ");
          if ((argile).debugcomp) {
            ((argile).indent)--;
          } //;
          return 0;
        } //;
        (p_argile_call_9)->compiled = 1;
        if ((argile).debugcomp) {
          ((argile).indent)--;
        } //;
        return 1;
      } //;
    } //;
  } //;
  _count_syn((p_argile_call_9)->match, max, &maxwords, &maxops, &maxparams, &maxchars, &maxsum);
  pd_speedup = (max > 1);
  for (len = max; ((len >= 1)); (len)--) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    if ((len < (p_argile_call_9)->minmatch)) {
      break;
    } //;
    if ((((p_argile_call_9)->maxmatch >= 0) && (len > (p_argile_call_9)->maxmatch))) {
      continue;
    } //;
    code_2 = (p_argile_call_9)->scope;
    if (pd_speedup) {
      ((argile_list_t *)((argile_list_t *)&raw_head))->next = (p_argile_call_9)->pot_defs;
      ldef = ((argile_list_t *)&raw_head);
    } //;
    else {
      argile_code_getdef(code_2, p_argile_call_9, &prev, &next);
      ldef = ((argile_list_t *)0);
    };
    while ((ldef = ((pd_speedup) ? (((argile_list_t *)ldef)->next) : (argile_code_nextdef(&code_2, &prev, &next))))) {
      argile_def_t * def = ((argile_def_t *)0);
      int nwords = 0;
      int nops = 0;
      int nparams = 0;
      int nchars = 0;
      int chsum = 0;
      int off = 0;
      argile_list_t * head;
      argile_list_t * tail;

      def = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
      if (pd_speedup) {
        code_2 = (def)->scope;
        if (((len < (code_2)->minmatch) || (((code_2)->maxmatch >= 0) && (len > (code_2)->maxmatch)))) {
          continue;
        } //;
      } else {
        if (((len < (code_2)->minmatch) || (((code_2)->maxmatch >= 0) && (len > (code_2)->maxmatch)))) {
          prev = ((argile_list_t *)0);
          next = ((argile_list_t *)0);
          continue;
        } //;
        if ((((code_2)->hit < (p_argile_call_9)->hit) && !((code_2)->has_weak_defs))) {
          prev = ((argile_list_t *)0);
          next = ((argile_list_t *)0);
          continue;
        } //;
        if (((def)->locall && !(is_made_in(def, owner_2)))) {
          continue;
        } //;
        if ((((def)->hit < (p_argile_call_9)->hit) && !((def)->weak))) {
          continue;
        } //;
      };
      if (((len < (def)->minmatch) || (((def)->maxmatch >= 0) && (len > (def)->maxmatch)))) {
        continue;
      } //;
      if ((((maxparams < (code_2)->minparam) || (maxwords < (code_2)->minword)) || ((maxops < (code_2)->minop) || ((maxchars < (code_2)->minchar) || (maxsum < (code_2)->minchsum))))) {
        prev = ((argile_list_t *)0);
        next = ((argile_list_t *)0);
        continue;
      } //;
      _count_syn((p_argile_call_9)->match, len, &nwords, &nops, &nparams, &nchars, &chsum);
      head = (p_argile_call_9)->match;
      tail = argile_list_seek(head, (len - 1));
      while ((tail)) {
        argile_match_t * m = ((argile_match_t *)0);

        m = *((argile_match_t * *)&((argile_list_t *)head)->data);
        if ((m == NULL)) {
          goto cont;
        } //;
        if ((off != 0)) {
          _adj_syn(((argile_list_t *)head)->prev, -1, &nwords, &nops, &nparams, &nchars, &chsum);
          _adj_syn(tail, 1, &nwords, &nops, &nparams, &nchars, &chsum);
        } //;
        if (((max > 1) && (len == 1))) {
          if ((((m)->type == ARGILE_MATCH_SUBCALL) || ((m)->type == ARGILE_MATCH_CONS))) {
            goto cont;
          } //;
        } //;
        if (((nwords < (def)->minword) || (((def)->maxword >= 0) && (nwords > (def)->maxword)))) {
          goto cont;
        } //;
        if (((nops < (def)->minop) || (((def)->maxop >= 0) && (nops > (def)->maxop)))) {
          goto cont;
        } //;
        if (((nparams < (def)->minparam) || (((def)->maxparam >= 0) && (nparams > (def)->maxparam)))) {
          goto cont;
        } //;
        if (((nchars < (def)->minchar) || (((def)->maxchar >= 0) && (nchars > (def)->maxchar)))) {
          goto cont;
        } //;
        if (((chsum < (def)->minchsum) || (((def)->maxchsum >= 0) && (chsum > (def)->maxchsum)))) {
          goto cont;
        } //;
        ((def)->numtry)++;
        if ((argile_match_try((def)->syntax, head, len, ((int *)0), 0))) {
          argile_call_t * sub = ((argile_call_t *)0);
          argile_list_t * lm;

          ((def)->nummatch)++;
          if ((len == max)) {
            argile_type_t calltype;

            (p_argile_call_9)->matched = 1;
            (p_argile_call_9)->def = def;
            (p_argile_call_9)->compiled = 1;
            if ((argile_call_compile_subcalls(p_argile_call_9) == 0)) {
              (p_argile_call_9)->def = ((argile_def_t *)0);
              (p_argile_call_9)->compiled = 0;
              goto cont;
            } //;
            argile_call_find_path(p_argile_call_9);
            calltype = argile_call_get_type(p_argile_call_9);
            if (((type_2 == ARGILE_TYPE_NOTHING) || (argile_type_match(type_2, calltype)))) {
              int r = 0;

              r = argile_call_reject(p_argile_call_9);
              if ((r <= 0)) {
                if ((argile).debugcomp) {
                  ((argile).indent)--;
                  _print_compil_(p_argile_call_9, type_2);
                  if ((r < 0)) {
                    printf("%s\n", " => RETRY");
                  } else {
                    printf("%s\n", " => OK");
                  };
                } //;
                if ((r < 0)) {
                  argile_call_uncompile_subcalls(p_argile_call_9, 0);
                  (p_argile_call_9)->def = ((argile_def_t *)0);
                  (p_argile_call_9)->compiled = 0;
                  (p_argile_call_9)->rejected = 1;
                  return 0;
                } //;
                return 1;
              } //;
              (p_argile_call_9)->rejected = 1;
            } else {
              argile_call_mismatch(p_argile_call_9, type_2, calltype, "type mismatch: ");
            };
            argile_call_uncompile_subcalls(p_argile_call_9, 0);
            (p_argile_call_9)->def = ((argile_def_t *)0);
            (p_argile_call_9)->compiled = 0;
            goto cont;
          } //;
          if (((p_argile_call_9)->sigs)) {
            if (known_call_signature_of(p_argile_call_9, def, off, len)) {
              goto cont;
            } //;
          } //;
          sub = argile_call_make_implicit(p_argile_call_9, def, head, tail);
          if ((((argile_call_compile_subcalls(sub) != 0) && !((argile_call_reject(sub)))) && _compile_as(p_argile_call_9, type_2))) {
            if ((argile).debugcomp) {
              ((argile).indent)--;
            } //;
            return 1;
          } //;
          lm = (p_argile_call_9)->match;
          for (; (lm); lm = ((argile_list_t *)lm)->next) {
            if (((*((argile_match_t * *)&((argile_list_t *)lm)->data)) && ((*((argile_match_t * *)&((argile_list_t *)lm)->data))->value.data == sub))) {
              argile_call_undo_implicit(p_argile_call_9, sub, lm);
              break;
            } //;
          };
        } //;
        cont:;
        head = ((argile_list_t *)head)->next;
        tail = ((argile_list_t *)tail)->next;
        (off)++;
      };
    };
  };
  (p_argile_call_9)->def = ((argile_def_t *)0);
  (p_argile_call_9)->compiled = 0;
  if ((argile).debugcomp) {
    ((argile).indent)--;
    _print_compil_(p_argile_call_9, type_2);
    printf("%s\n", " => NO");
  } //;
  return 0;
}

static argile_call_t * owner_most_of(argile_call_t * p_argile_call_10)
/** :owner - most of <call>: -> (argile) call **/
{
  if ((p_argile_call_10 == NULL)) {
    return ((argile_call_t *)0);
  } //;
  while (!(((p_argile_call_10)->owner == NULL))) {
    p_argile_call_10 = (p_argile_call_10)->owner;
  };
  return p_argile_call_10;
}

static unsigned char is_made_in(argile_def_t * p_argile_def_2, argile_call_t * p_argile_call_11)
/** :<def> is made in <call>: -> bool **/
{
  argile_code_t * scope = ((argile_code_t *)0);

  if (((p_argile_def_2)->maker == p_argile_call_11)) {
    return 1;
  } //;
  if (((p_argile_def_2)->param != NULL)) {
    return 0;
  } //;
  scope = (p_argile_call_11)->scope;
  while ((scope != NULL)) {
    if ((((scope)->ghost == NULL) && ((p_argile_def_2)->maker == (scope)->owner))) {
      return 1;
    } //;
    scope = (scope)->upper;
  };
  return 0;
}

void argile_call_compile_binds(argile_call_t * p_argile_call_12)
/** :argile_call_compile_binds <call>: -> nothing **/
{
  argile_list_t * list;

  list = (p_argile_call_12)->match;
  for (; (list); list = ((argile_list_t *)list)->next) {
    argile_match_t * match_2 = ((argile_match_t *)0);

    match_2 = *((argile_match_t * *)&((argile_list_t *)list)->data);
    if ((match_2 == NULL)) {
      continue;
    } //;
    if (((match_2)->type == ARGILE_MATCH_SUBCALL)) {
      argile_call_compile_binds(((match_2)->value).call);
    } //;
  };
  if ((((p_argile_call_12)->def) && (((p_argile_call_12)->def)->dtype == ARGILE_DEF_BIND))) {
    argile_bind_t * bind = ((argile_bind_t *)0);

    bind = (((p_argile_call_12)->def)->dval).bind;
    if (!(((bind)->compile == NULL))) {
      (*(bind)->compile)(p_argile_call_12);
    } //;
  } //;
}

int argile_call_compile_subcalls(argile_call_t * p_argile_call_13)
/** :argile_call_compile_subcalls <call>: -> int **/
{
  argile_list_t * lm;

  lm = (p_argile_call_13)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      argile_call_t * c = ((argile_call_t *)0);

      c = ((m)->value).call;
      if (((c)->type == ARGILE_CALL_EXPLICIT)) {
        if ((((m)->matched)->type == ARGILE_SYN_PARAM)) {
          argile_type_t t;

          t = ((((m)->matched)->value).syn_param)->type;
          if (!((argile_call_compile_as(c, t)))) {
            if ((!(bypass_deps_only(p_argile_call_13)) && !(fix_param_enum(((p_argile_call_13)->def)->syntax, m, c)))) {
              argile_call_uncompile_subcalls(p_argile_call_13, 0);
              return 0;
            } //;
          } //;
        } else {
          argile_die_at(p_argile_call_13, "hmm weird, a subcall matches a non-parameter o_O");
          return 0;
        };
      } //;
    } //;
  };
  return 1;
}

void argile_call_uncompile_subcalls(argile_call_t * p_argile_call_14, int undo_implicits)
/** :argile_call_uncompile_subcalls <call> <int undo_implicits>: -> nothing **/
{
  argile_list_t * lm;

  if (!((p_argile_call_14)->keep_data)) {
    if (!(((p_argile_call_14)->del == NULL))) {
      (*(p_argile_call_14)->del)((p_argile_call_14)->data);
    } //;
    (p_argile_call_14)->data = NULL;
    (p_argile_call_14)->del = ((argile_deleter_t)0);
  } //;
  argile_call_unfind_path(p_argile_call_14);
  lm = (p_argile_call_14)->match;
  while (!((lm == NULL))) {
    argile_list_t * next;
    argile_match_t * m = ((argile_match_t *)0);

    next = ((argile_list_t *)lm)->next;
    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_call_t * c = ((argile_call_t *)0);

      c = ((m)->value).call;
      switch ((c)->type) {
        case ARGILE_CALL_IMPLICIT: {
          if ((undo_implicits != 0)) {
            argile_call_uncompile_subcalls(c, 1);
            argile_call_undo_implicit(p_argile_call_14, c, lm);
          } //;
        } break;
        case ARGILE_CALL_EXPLICIT: {
          argile_call_uncompile_subcalls(c, 1);
          (c)->def = ((argile_def_t *)0);
          (c)->compiled = 0;
        } break;
        default: {} break;
      };
    } //;
    lm = next;
  };
}

int argile_call_compile_syntaxes(argile_call_t * p_argile_call_15)
/** :argile_call_compile_syntaxes <call>: -> int **/
{
  argile_call_t * owner_2 = ((argile_call_t *)0);
  argile_list_t * lm;

  owner_2 = owner_most_of(p_argile_call_15);
  lm = (p_argile_call_15)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      if ((argile_call_compile_syntaxes(((m)->value).call) == 0)) {
        return 0;
      } //;
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_SYNTAX))) {
      argile_list_t * syn;

      syn = ((((m)->value).cons)->cvalue).syntax;
      if (!((argile_syntax_compile_params(syn, (p_argile_call_15)->scope, p_argile_call_15)))) {
        return 0;
      } //;
      _def_params_locall(syn, owner_2);
    } //;
  };
  return 1;
}

int argile_call_compile_subcodes(argile_call_t * p_argile_call_16)
/** :argile_call_compile_subcodes <call>: -> int **/
{
  argile_list_t * lm;

  lm = (p_argile_call_16)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      if ((argile_call_compile_subcodes(((m)->value).call) != 0)) {
        return -1;
      } //;
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      if (((((m)->value).cons)->ctype == ARGILE_CONS_CODE)) {
        argile_code_t * c = ((argile_code_t *)0);

        c = ((((m)->value).cons)->cvalue).code;
        if ((argile_code_compile(c, (c)->type) != 0)) {
          return -1;
        } //;
      } //;
    } //;
  };
  return 0;
}

argile_call_t * argile_call_make_implicit(argile_call_t * p_argile_call_17, argile_def_t * p_argile_def_3, argile_list_t * head, argile_list_t * tail)
/** :argile_call_make_implicit <call> <def> <list of (match) head> <list of (match) tail>: -> (argile) call **/
{
  argile_call_t * sub = ((argile_call_t *)0);
  argile_list_t * lm;

  sub = argile_call_new(p_argile_def_3, head);
  (sub)->type = ARGILE_CALL_IMPLICIT;
  *&(sub)->loc = *&(p_argile_call_17)->loc;
  lm = argile_list_new(argile_match_new(ARGILE_MATCH_SUBCALL, sub), (void *)&argile_match_del);
  if ((head == (p_argile_call_17)->match)) {
    (p_argile_call_17)->match = lm;
  } //;
  argile_list_link(((argile_list_t *)head)->prev, lm);
  argile_list_link(lm, ((argile_list_t *)tail)->next);
  ((argile_list_t *)head)->prev = ((argile_list_t *)0);
  ((argile_list_t *)tail)->next = ((argile_list_t *)0);
  argile_call_setup(sub, (p_argile_call_17)->scope, p_argile_call_17);
  argile_call_find_path(sub);
  return sub;
}

void argile_call_undo_implicit(argile_call_t * p_argile_call_18, argile_call_t * sub, argile_list_t * matches_2)
/** :argile_call_undo_implicit <call> <call sub> <list of (match) matches>: -> nothing **/
{
  (p_argile_call_18)->numcomp += (sub)->numcomp;
  argile_call_take_rejects(p_argile_call_18, sub);
  argile_call_uncompile_subcalls(sub, 0);
  argile_list_link(((argile_list_t *)matches_2)->prev, (sub)->match);
  argile_list_link(argile_list_end((sub)->match), ((argile_list_t *)matches_2)->next);
  if ((((argile_list_t *)matches_2)->prev == NULL)) {
    (p_argile_call_18)->match = (sub)->match;
  } //;
  (sub)->match = ((argile_list_t *)0);
  ((argile_list_t *)matches_2)->prev = ((argile_list_t *)0);
  ((argile_list_t *)matches_2)->next = ((argile_list_t *)0);
  argile_list_del(matches_2);
  argile_call_setup(p_argile_call_18, (p_argile_call_18)->scope, (p_argile_call_18)->owner);
}

argile_type_t argile_call_get_type(argile_call_t * p_argile_call_19)
/** :argile_call_get_type <call>: -> argile type **/
{
  if (!((p_argile_call_19)->compiled)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  if (((p_argile_call_19)->def == NULL)) {
    return (((*((argile_match_t * *)&((argile_list_t *)(p_argile_call_19)->match)->data))->value).cons)->type;
  } //;
  if ((((p_argile_call_19)->def)->dtype == ARGILE_DEF_BIND)) {
    argile_bind_t * b = ((argile_bind_t *)0);

    b = (((p_argile_call_19)->def)->dval).bind;
    if (((b)->gettype)) {
      return (*(b)->gettype)(p_argile_call_19);
    } //;
    if (((b)->type)) {
      return *(b)->type;
    } //;
  } else if ((((((p_argile_call_19)->def)->maker) && ((p_argile_call_19)->def)->vartype) && (((p_argile_call_19)->def)->dtype == ARGILE_DEF_FUNC))) {
    argile_code_t * code_2 = ((argile_code_t *)0);

    code_2 = (((p_argile_call_19)->def)->dval).code;
    if ((code_2)->macro) {
      argile_shovel_t * sh = ((argile_shovel_t *)0);
      argile_match_t * m = ((argile_match_t *)0);

      sh = argile_shovel_new(((p_argile_call_19)->def)->maker);
      m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
      argile_shovel_del(sh);
      if ((m)) {
        argile_type_t t;

        _push_macro_params(code_2, p_argile_call_19);
        t = argile_match_eval_type(m);
        _pop_macro_params(code_2);
        return t;
      } //;
    } //;
  } //;
  return ((p_argile_call_19)->def)->type;
}

static void _push_macro_params(argile_code_t * code_2, argile_call_t * p_argile_call_20)
/** :_push_macro_params <argile code code> <call>: -> nothing **/
{
  argile_list_t * ld;

  argile_list_prepend(&(code_2)->macro_calls, argile_list_new(p_argile_call_20, ((argile_deleter_t)0)));
  argile_list_prepend(&(code_2)->macro_shovels, argile_list_new(argile_shovel_new(p_argile_call_20), (void *)&argile_shovel_del));
  ld = (code_2)->defs;
  for (; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
    if (((((d)->param) && !((d)->locall)) && !((d)->reused_var))) {
      argile_list_t * lcp;

      lcp = (p_argile_call_20)->params;
      for (; (lcp); lcp = ((argile_list_t *)lcp)->next) {
        argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

        cp_2 = *((argile_call_param_t * *)&((argile_list_t *)lcp)->data);
        if (((cp_2)->syn_param == (d)->param)) {
          argile_list_prepend(&(((d)->dval).var)->macro_params, argile_list_new(cp_2, ((argile_deleter_t)0)));
          break;
        } //;
      };
      if ((lcp == NULL)) {
        argile_list_prepend(&(((d)->dval).var)->macro_params, argile_list_new(NULL, ((argile_deleter_t)0)));
      } //;
    } //;
  };
}

static void _pop_macro_params(argile_code_t * code_3)
/** :_pop_macro_params <argile code code>: -> nothing **/
{
  argile_list_t * ld;

  for (ld = (code_3)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if ((((d)->param != NULL) && (!((d)->locall) && !((d)->reused_var)))) {
      argile_list_del(argile_list_pop(&(((d)->dval).var)->macro_params));
    } //;
  };
  argile_list_del(argile_list_pop(&(code_3)->macro_shovels));
  argile_list_del(argile_list_pop(&(code_3)->macro_calls));
}

int argile_call_reject(argile_call_t * p_argile_call_21)
/** :argile_call_reject <call>: -> int **/
{
  argile_bind_t * b = ((argile_bind_t *)0);

  if ((!(((p_argile_call_21)->def)) || (((p_argile_call_21)->def)->dtype != ARGILE_DEF_BIND))) {
    return 0;
  } //;
  b = (((p_argile_call_21)->def)->dval).bind;
  if (((b)->reject == NULL)) {
    return 0;
  } //;
  return (*(b)->reject)(p_argile_call_21);
}

int argile_call_add_reject(argile_call_t * p_argile_call_22, char * reason)
/** :argile_call_add_reject <call> <text reason>: -> int **/
{
  argile_buff_t b = (argile_buff_t){0};

  (p_argile_call_22)->rejected = 1;
  if ((((argile).maxreject != 0) && ((p_argile_call_22)->nrejects >= (argile).maxreject))) {
    return 1;
  } //;
  argile_buff_puts(&b, reason);
  argile_buff_puts(&b, "\n  ");
  if (((p_argile_call_22)->owner != NULL)) {
    argile_buff_putc(&b, *&("(")[0]);
  } //;
  argile_call_string(p_argile_call_22, 1, &b);
  if (((p_argile_call_22)->owner != NULL)) {
    argile_buff_putc(&b, *&(")")[0]);
  } //;
  argile_buff_puts(&b, "\n -> at \"");
  if ((((p_argile_call_22)->scope)->input)) {
    argile_buff_puts(&b, ((p_argile_call_22)->scope)->input);
  } else {
    argile_buff_puts(&b, "anonymous input");
  };
  argile_buff_puts(&b, "\", from line ");
  argile_buff_putn(&b, (((p_argile_call_22)->loc).start).row);
  argile_buff_puts(&b, " column ");
  argile_buff_putn(&b, (((p_argile_call_22)->loc).start).col);
  argile_buff_puts(&b, ", to line ");
  argile_buff_putn(&b, (((p_argile_call_22)->loc).end).row);
  argile_buff_puts(&b, " column ");
  argile_buff_putn(&b, (((p_argile_call_22)->loc).end).col);
  argile_buff_putc(&b, '\0');
  if ((argile_list_search((p_argile_call_22)->rejects, (b).ptr, (void *)&argile_streq))) {
    argile_dbg_free((b).ptr);
    return 1;
  } //;
  argile_list_prepend(&(p_argile_call_22)->rejects, argile_list_new((b).ptr, (void *)&argile_dbg_free));
  ((p_argile_call_22)->nrejects)++;
  ((argile).stat).rejsize += (b).len;
  ((argile).stat).rejmaxsize += (b).max;
  return 1;
}

void argile_call_take_rejects(argile_call_t * dst, argile_call_t * src)
/** :argile_call_take_rejects <call dst> <call src>: -> nothing **/
{
  argile_list_t * lr;

  lr = argile_list_pop(&(src)->rejects);
  while (((lr) && (((argile).maxreject == 0) || ((dst)->nrejects < (argile).maxreject)))) {
    if ((argile_list_search((dst)->rejects, *((char * *)&((argile_list_t *)lr)->data), (void *)&argile_streq))) {
      argile_list_del(lr);
    } else {
      argile_list_prepend(&(dst)->rejects, lr);
      ((dst)->nrejects)++;
    };
    lr = argile_list_pop(&(src)->rejects);
  };
  if ((lr)) {
    argile_list_del(lr);
  } //;
  if (((src)->rejects)) {
    argile_list_del((src)->rejects);
    (src)->rejects = ((argile_list_t *)0);
  } //;
  (src)->nrejects = 0;
}

void argile_forget_rejects(argile_call_t * p_argile_call_23)
/** :argile_forget_rejects <call>: -> nothing **/
{
  argile_list_t * lm;

  argile_list_del((p_argile_call_23)->rejects);
  (p_argile_call_23)->rejects = ((argile_list_t *)0);
  (p_argile_call_23)->nrejects = 0;
  lm = (p_argile_call_23)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_forget_rejects(((m)->value).call);
    } //;
  };
}

void argile_call_mismatch(argile_call_t * p_argile_call_24, argile_type_t expected, argile_type_t got, char * error)
/** :argile_call_mismatch <call> <argile type expected> <argile type got> <text error>: -> nothing **/
{
  argile_buff_t b = ((argile_buff_t){0});
  char( tmp[32]);

  if ((error)) {
    argile_buff_puts(&b, error);
  } //;
  argile_buff_puts(&b, "got \"");
  argile_typename(got, &b, (p_argile_call_24)->scope);
  argile_buff_puts(&b, "\" (");
  snprintf(((char *)tmp), sizeof(tmp), "0x%x", got);
  argile_buff_puts(&b, ((char *)tmp));
  argile_buff_puts(&b, ") where \"");
  argile_typename(expected, &b, (p_argile_call_24)->scope);
  snprintf(((char *)tmp), sizeof(tmp), "0x%x", expected);
  argile_buff_puts(&b, "\" (");
  argile_buff_puts(&b, ((char *)tmp));
  argile_buff_puts(&b, ") was expected");
  argile_buff_putc(&b, '\0');
  argile_call_add_reject(p_argile_call_24, (b).ptr);
  argile_dbg_free((b).ptr);
}

int argile_call_need_indent(argile_call_t * p_argile_call_25)
/** :argile_call_need_indent <call>: -> int **/
{
  if ((((p_argile_call_25)->owner == NULL) && (!(((p_argile_call_25)->scope)->macro) || has_several_calls((p_argile_call_25)->scope)))) {
    return 1;
  } //;
  return 0;
}

static unsigned char has_several_calls(argile_code_t * code_4)
/** :<argile code code> has several calls: -> bool **/
{
  argile_list_t * ld;

  if ((((code_4)->calls) && (((argile_list_t *)(code_4)->calls)->next))) {
    return 1;
  } //;
  ld = (code_4)->defs;
  for (; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
    if (((!((d)->implicit) && !((d)->nodecl)) && !(((d)->param)))) {
      return 1;
    } //;
  };
  return 0;
}

int argile_call_need_return(argile_call_t * p_argile_call_26)
/** :argile_call_need_return <call>: -> int **/
{
  argile_list_t * end;

  if ((((p_argile_call_26)->scope)->type == ARGILE_TYPE_NOTHING)) {
    return 0;
  } //;
  end = argile_list_end(((p_argile_call_26)->scope)->calls);
  if (((end) && (*((argile_call_t * *)&((argile_list_t *)end)->data) == p_argile_call_26))) {
    return 1;
  } //;
  return 0;
}

void argile_call_gencode(argile_call_t * p_argile_call_27, int returned)
/** :argile_call_gencode <call> <int returned>: -> nothing **/
{
  unsigned char need_indent;
  argile_list_t * union_fields = ((argile_list_t *)0);
  argile_list_t * lf;

  if (((argile).error)) {
    return;
  } //;
  if ((((argile).maxgen > 0) && ((argile).numgen >= (argile).maxgen))) {
    argile_die_at(p_argile_call_27, "max. gencode recursions (%d) reached (macros).", (argile).maxgen);
    return;
  } //;
  ((argile).numgen)++;
  need_indent = ((returned == 0) && (argile_call_need_indent(p_argile_call_27)));
  if (((p_argile_call_27)->def == NULL)) {
    if ((((p_argile_call_27)->match) && (*((argile_match_t * *)&((argile_list_t *)(p_argile_call_27)->match)->data)))) {
      argile_match_t * m = ((argile_match_t *)0);

      m = *((argile_match_t * *)&((argile_list_t *)(p_argile_call_27)->match)->data);
      if (need_indent) {
        argile_indent();
      } //;
      if (((m)->type == ARGILE_MATCH_CONS)) {
        if (((returned == 2) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
          argile_code_gendata(((((m)->value).cons)->cvalue).code);
        } //;
        else if (((p_argile_call_27)->owner == NULL)) {
          argile_match_gencode(m);
        } //;
        else {
          argile_cons_gencode(((m)->value).cons);
        };
        if (need_indent) {
          argile_puts(";\n");
        } //;
      } //;
    } //;
    ((argile).numgen)--;
    return;
  } //;
  if (!((argile_def_is_macro((p_argile_call_27)->def)))) {
    argile_type_t ct;
    argile_type_t dt;

    ct = (((int)(p_argile_call_27)->context) & ~((1 << 31)));
    dt = (((int)argile_call_get_type(p_argile_call_27)) & ~((1 << 31)));
    if ((ct != dt)) {
      argile_list_t * lf_2;

      union_fields = _get_union_fields(ct, dt);
      lf_2 = argile_list_end(union_fields);
      if (((lf_2) && (*((argile_field_t * *)&((argile_list_t *)lf_2)->data)))) {
        argile_field_t * f = ((argile_field_t *)0);

        f = *((argile_field_t * *)&((argile_list_t *)lf_2)->data);
        if ((((((int)(f)->type) >> 30) & 1))) {
          argile_ref(-1);
        } //;
        if ((((((int)(f)->type) >> 31) & 1))) {
          argile_ref(1);
        } //;
      } //;
    } //;
  } //;
  switch (((p_argile_call_27)->def)->dtype) {
    case ARGILE_DEF_VAR: {
      argile_var_t * var = ((argile_var_t *)0);

      var = (((p_argile_call_27)->def)->dval).var;
      if (need_indent) {
        argile_indent();
      } //;
      argile_call_gen_ref(p_argile_call_27);
      if (((var)->macro_params)) {
        argile_call_param_gencode(*((argile_call_param_t * *)&((argile_list_t *)(var)->macro_params)->data), p_argile_call_27);
      } //;
      else {
        if ((((((p_argile_call_27)->def)->param) && (((p_argile_call_27)->def)->param)->in_list) && !((p_argile_call_27)->autoparam))) {
          argile_ref(1);
        } //;
        argile_puts(argile_def_gen_id((p_argile_call_27)->def));
      };
      if (need_indent) {
        argile_puts(";\n");
      } //;
    } break;
    case ARGILE_DEF_TYPE: {
      if (need_indent) {
        argile_indent();
      } //;
      argile_type_gen_prefix((((p_argile_call_27)->def)->dval).type);
      argile_type_gen_suffix((((p_argile_call_27)->def)->dval).type);
      if (need_indent) {
        argile_puts(";\n");
      } //;
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * code_5 = ((argile_code_t *)0);

      code_5 = (((p_argile_call_27)->def)->dval).code;
      if (((code_5) && (code_5)->macro)) {
        if (((code_5)->calls == NULL)) {
          break;
        } //;
        if (!((code_5)->compiled)) {
          unsigned char old;

          old = (argile).main_only;
          (argile).main_only = 0;
          argile_code_compile(code_5, (code_5)->type);
          (argile).main_only = old;
        } //;
        if (has_several_calls(code_5)) {
          if (need_indent) {
            argile_indent();
          } //;
          if (((code_5)->type == ARGILE_TYPE_TYPE)) {
            argile_type_t t;

            t = argile_call_eval_type(p_argile_call_27);
            argile_type_gen_prefix(t);
            argile_type_gen_suffix(t);
          } else {
            unsigned char ret;

            ret = ((code_5)->type != ARGILE_TYPE_NOTHING);
            if (ret) {
              argile_puts("(");
            } //;
            argile_puts("{\n");
            ((argile).indent)++;
            _push_macro_params(code_5, p_argile_call_27);
            argile_code_gen_vars(code_5, 0);
            argile_code_gencode(code_5);
            _pop_macro_params(code_5);
            ((argile).indent)--;
            argile_indent();
            argile_puts("}");
            if (ret) {
              argile_puts(")");
            } //;
          };
          if (need_indent) {
            argile_puts(";\n");
          } //;
        } else {
          if (need_indent) {
            argile_indent();
          } //;
          _push_macro_params(code_5, p_argile_call_27);
          argile_call_gen_ref(p_argile_call_27);
          argile_call_gencode(*((argile_call_t * *)&((argile_list_t *)(code_5)->calls)->data), 1);
          _pop_macro_params(code_5);
          if (need_indent) {
            argile_puts(";\n");
          } //;
        };
      } else {
        if (need_indent) {
          argile_indent();
        } //;
        argile_call_gen_ref(p_argile_call_27);
        argile_puts(argile_def_gen_id((p_argile_call_27)->def));
        argile_puts("(");
        _call_args(p_argile_call_27);
        argile_puts(")");
        if (need_indent) {
          argile_puts(";\n");
        } //;
      };
    } break;
    case ARGILE_DEF_BIND: {
      argile_bind_t * b = ((argile_bind_t *)0);

      b = (((p_argile_call_27)->def)->dval).bind;
      if (((b)->gencode)) {
        if (!(need_indent)) {
          (*(b)->gencode)(p_argile_call_27);
        } else {
          argile_buff_t buf_2 = ((argile_buff_t){0});

          argile_push_output((void *)&argile_output_buff, &buf_2);
          (*(b)->gencode)(p_argile_call_27);
          argile_pop_output();
          if (((buf_2).ptr)) {
            argile_indent();
            argile_output((buf_2).ptr, ((int)(buf_2).len));
            argile_puts(";\n");
            argile_dbg_free((buf_2).ptr);
          } //;
        };
      } //;
    } break;
    default: {} break;
  };
  for (lf = union_fields; (lf); lf = ((argile_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = ((argile_field_t *)*((void * *)&((argile_list_t *)lf)->data.u_anything));
    argile_puts(".");
    argile_puts(argile_field_gen_id(f, "u_", ((p_argile_call_27)->def)->maker));
  };
  argile_list_del(union_fields);
  ((argile).numgen)--;
}

void argile_call_param_gencode(argile_call_param_t * param, argile_call_t * from)
/** :argile_call_param_gencode <call param param> <call from>: -> nothing **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);

  if ((param == NULL)) {
    return;
  } //;
  if ((from)) {
    argile_code_t * c = ((argile_code_t *)0);

    c = _get_macro_body((from)->scope, (param)->def);
    if ((c)) {
      sh = *((argile_shovel_t * *)&((argile_list_t *)(c)->macro_shovels)->data);
    } //;
  } //;
  if ((sh)) {
    m = argile_shovel_digparamatch(sh, (param)->syn_param);
  } else if (((param)->matches)) {
    m = *((argile_match_t * *)&((argile_list_t *)(param)->matches)->data);
  } //;
  if ((m)) {
    if ((((m)->type == ARGILE_MATCH_WORD) && !((((param)->def) && (((((param)->def)->dval).var)->macro_params))))) {
      argile_puts("\"");
      argile_match_gencode(m);
      argile_puts("\"");
    } else {
      argile_match_gencode(m);
    };
  } else if ((((param)->syn_param)->init)) {
    argile_match_gencode(((param)->syn_param)->init);
  } else {
    argile_type_gen_zero(((param)->syn_param)->type);
  };
}

void argile_call_gen_ref(argile_call_t * p_argile_call_28)
/** :argile_call_gen_ref <call>: -> nothing **/
{
  unsigned char is_ref;
  unsigned char is_raw;
  unsigned char in_ref;
  unsigned char in_raw;

  in_ref = (((((int)(p_argile_call_28)->context) >> 31) & 1));
  in_raw = (((((int)(p_argile_call_28)->context) >> 30) & 1));
  if ((p_argile_call_28)->autoparam) {
    is_ref = !((((((int)((p_argile_call_28)->def)->type) >> 30) & 1)));
    is_raw = 0;
  } else if ((((p_argile_call_28)->def)->dtype == ARGILE_DEF_VAR)) {
    is_ref = ((((p_argile_call_28)->def)->param) && (((((int)(((p_argile_call_28)->def)->param)->type) >> 31) & 1)));
    is_raw = (((((int)((p_argile_call_28)->def)->type) >> 30) & 1));
  } else {
    argile_type_t t;

    t = argile_call_get_type(p_argile_call_28);
    is_ref = (((((int)t) >> 31) & 1));
    is_raw = (((((int)t) >> 30) & 1));
  };
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  } //;
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  } //;
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  } //;
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  } //;
}

void argile_call_gen_line(argile_call_t * p_argile_call_29)
/** :argile_call_gen_line <call>: -> nothing **/
{
  unsigned char implicit;

  if ((((argile).gen_lines == 0) || ((argile).outctx))) {
    return;
  } //;
  implicit = ((((argile).last_input_name) && (strcmp((argile).last_input_name, ((p_argile_call_29)->scope)->input) == 0)) && ((((p_argile_call_29)->loc).start).row == (argile).last_input_line));
  (argile).last_input_line = (((p_argile_call_29)->loc).start).row;
  (argile).last_input_name = ((p_argile_call_29)->scope)->input;
  if (implicit) {
    return;
  } //;
  ((argile).next_input_buff)->len = 0;
  if (((argile).gen_lines == 1)) {
    argile_buff_puts((argile).next_input_buff, "#line ");
    argile_buff_putn((argile).next_input_buff, (((p_argile_call_29)->loc).start).row);
    argile_buff_puts((argile).next_input_buff, " \"");
    argile_buff_puts((argile).next_input_buff, ((p_argile_call_29)->scope)->input);
    argile_buff_puts((argile).next_input_buff, "\"\n");
  } else if (((argile).gen_lines == 2)) {
    argile_buff_puts((argile).next_input_buff, "#line ");
    argile_buff_putn((argile).next_input_buff, (((p_argile_call_29)->loc).start).row);
    argile_buff_puts((argile).next_input_buff, " \"");
    argile_buff_puts((argile).next_input_buff, (argile).output_name);
    argile_buff_puts((argile).next_input_buff, ":");
    argile_buff_putn((argile).next_input_buff, ((argile).output_line + 1));
    argile_buff_puts((argile).next_input_buff, ": ");
    argile_buff_puts((argile).next_input_buff, ((p_argile_call_29)->scope)->input);
    argile_buff_puts((argile).next_input_buff, "\"\n");
  } //;
}

argile_type_t argile_call_eval_type(argile_call_t * p_argile_call_30)
/** :argile_call_eval_type <call>: -> argile type **/
{
  argile_def_t * d = ((argile_def_t *)0);

  d = (p_argile_call_30)->def;
  if ((d == NULL)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  switch ((d)->dtype) {
    case ARGILE_DEF_VAR: {
      if (((((d)->dval).var)->macro_params)) {
        argile_match_t * m = ((argile_match_t *)0);
        argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

        cp_2 = *((argile_call_param_t * *)&((argile_list_t *)(((d)->dval).var)->macro_params)->data);
        if ((((cp_2) && ((cp_2)->matches)) && (*((argile_match_t * *)&((argile_list_t *)(cp_2)->matches)->data)))) {
          m = argile_match_terminal(*((argile_match_t * *)&((argile_list_t *)(cp_2)->matches)->data));
        } else {
          m = ((cp_2)->syn_param)->init;
        };
        if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
          return argile_call_eval_type(((m)->value).call);
        } //;
      } //;
      return (argile_type_t)ARGILE_TYPE_NOTHING;
    } break;
    case ARGILE_DEF_TYPE: {
      return ((d)->dval).type;
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * body = ((argile_code_t *)0);

      body = ((d)->dval).code;
      if ((((body) && (body)->macro) && ((body)->calls))) {
        argile_list_t * lt;
        int er = 0;
        argile_buff_t b = ((argile_buff_t){0});
        char * pre = "";
        char * suf = (char *)0;
        argile_call_t * gen = ((argile_call_t *)0);
        argile_type_t type_3;
        argile_type_info_t * info = ((argile_type_info_t *)0);

        lt = (body)->gtypes;
        for (; (lt); lt = ((argile_list_t *)lt)->next) {
          argile_type_info_t * info_2 = ((argile_type_info_t *)0);

          info_2 = *((argile_type_info_t * *)&((argile_list_t *)lt)->data);
          if ((((info_2)->ttype == ARGILE_TYPE_KIND_CTYPE) && (argile_call_eq(p_argile_call_30, (((info_2)->tval).t_ctype).generator)))) {
            return (info_2)->type;
          } //;
        };
        argile_code_reset_dupes((p_argile_call_30)->scope);
        er = argile_code_compile(body, (d)->type);
        argile_code_check_dupes((p_argile_call_30)->scope);
        if ((er != 0)) {
          break;
        } //;
        argile_push_output((void *)&argile_output_buff, &b);
        _push_macro_params(body, p_argile_call_30);
        memset(&b, 0, sizeof(*&b));
        argile_call_gencode(*((argile_call_t * *)&((argile_list_t *)(body)->calls)->data), 1);
        argile_flush_refs();
        argile_buff_putc(&b, '\0');
        pre = (b).ptr;
        if ((((argile_list_t *)(body)->calls)->next)) {
          memset(&b, 0, sizeof(*&b));
          argile_call_gencode(*((argile_call_t * *)&((argile_list_t *)((argile_list_t *)(body)->calls)->next)->data), 1);
          argile_flush_refs();
          argile_buff_putc(&b, '\0');
          suf = (b).ptr;
        } //;
        _pop_macro_params(body);
        argile_pop_output();
        gen = argile_call_shadow(p_argile_call_30);
        type_3 = argile_type_new();
        info = argile_type_set_info(type_3, ARGILE_TYPE_KIND_CTYPE);
        (((info)->tval).t_ctype).prefix = pre;
        (((info)->tval).t_ctype).suffix = suf;
        (((info)->tval).t_ctype).generator = gen;
        argile_list_prepend(&(body)->gtypes, argile_list_new(info, ((argile_deleter_t)0)));
        return type_3;
      } //;
    } break;
    case ARGILE_DEF_BIND: {
      argile_bind_t * b = ((argile_bind_t *)0);

      b = ((d)->dval).bind;
      if (((b)->evaltype)) {
        return (*(b)->evaltype)(p_argile_call_30);
      } //;
    } break;
    default: {} break;
  };
  return ARGILE_TYPE_NOTHING;
}

unsigned char argile_call_find_autoparams(argile_call_t * p_argile_call_31)
/** :argile_call_find_autoparams <call>: -> bool **/
{
  argile_def_t * d = ((argile_def_t *)0);
  unsigned char found;
  argile_list_t * lm;

  d = (p_argile_call_31)->def;
  if ((d == NULL)) {
    return 0;
  } //;
  found = 0;
  switch ((d)->dtype) {
    case ARGILE_DEF_VAR: {
      if ((((d)->scope)->ghost == NULL)) {
        if (propagate_autoparam_from(d, p_argile_call_31)) {
          found = 1;
        } //;
      } //;
    } break;
    case ARGILE_DEF_FUNC: {
      argile_code_t * c = ((argile_code_t *)0);

      c = ((d)->dval).code;
      if (!((c == NULL))) {
        argile_list_t * ap;

        for (ap = (c)->autoparams; (ap); ap = ((argile_list_t *)ap)->next) {
          if (propagate_autoparam_from(((argile_def_t *)*((void * *)&((argile_list_t *)ap)->data.u_anything)), p_argile_call_31)) {
            found = 1;
          } //;
        };
      } //;
    } break;
    default: {} break;
  };
  lm = (p_argile_call_31)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    if (argile_match_find_autoparams(*((argile_match_t * *)&((argile_list_t *)lm)->data))) {
      found = 1;
    } //;
  };
  return found;
}

static unsigned char propagate_autoparam_from(argile_def_t * p_argile_def_4, argile_call_t * p_argile_call_32)
/** :propagate autoparam <def> from <call>: -> bool **/
{
  argile_code_t * scope = ((argile_code_t *)0);
  unsigned char propagated;

  scope = (p_argile_call_32)->scope;
  if ((((p_argile_call_32)->def)->dtype == ARGILE_DEF_VAR)) {
    unsigned char local;

    local = 0;
    while (((scope) && (scope != (argile).main))) {
      if ((scope == (p_argile_def_4)->scope)) {
        local = 1;
        break;
      } //;
      scope = (scope)->upper;
    };
    if (!(local)) {
      return 0;
    } //;
  } //;
  propagated = 0;
  scope = (p_argile_call_32)->scope;
  while ((((scope) && (scope != (argile).main)) && (scope != (p_argile_def_4)->scope))) {
    if (((!(((scope)->ghost)) && ((scope)->func)) && !((scope)->macro))) {
      if (!((argile_list_search((scope)->autoparams, p_argile_def_4, ((argile_comparer_t)0))))) {
        argile_list_prepend(&(scope)->autoparams, argile_list_new(p_argile_def_4, ((argile_deleter_t)0)));
        (p_argile_def_4)->autoable = 1;
        propagated = 1;
      } //;
      if ((((p_argile_call_32)->def)->dtype == ARGILE_DEF_VAR)) {
        (p_argile_call_32)->autoparam = 1;
      } //;
    } //;
    scope = (scope)->upper;
  };
  return propagated;
}

static argile_list_t * shadow_of_matches(argile_call_t * * p_argile_call, argile_list_t * matches_3, argile_call_t * owner_2, argile_type_t type_3)
/** :shadow of matches <list of (match) matches> <call owner> <argile type type>: -> list of (match) **/
{
  argile_list_t * shadow;
  argile_list_t * cur;

  if (((argile).error != NULL)) {
    return ((argile_list_t *)0);
  } //;
  if ((((argile).maxgen > 0) && ((argile).numgen >= (argile).maxgen))) {
    argile_die_at(*p_argile_call, "max. gencode recursions (%d) reached (type generators)", (argile).maxgen);
    return ((argile_list_t *)0);
  } //;
  ((argile).numgen)++;
  shadow = argile_list_shadow(matches_3);
  cur = shadow;
  for (; (cur); cur = ((argile_list_t *)cur)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = argile_match_terminal(*((argile_match_t * *)&((argile_list_t *)cur)->data));
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_def_t * d = ((argile_def_t *)0);

      d = (((m)->value).call)->def;
      m = argile_match_shadow(m);
      ((m)->value).call = argile_call_shadow(((m)->value).call);
      (((m)->value).call)->owner = owner_2;
      (m)->hollow = ((d) && ((d)->param));
      if (((type_3 == ARGILE_TYPE_TYPE) && !((m)->evaled))) {
        (m)->etype = argile_match_eval_type(m);
        (m)->evaled = 1;
      } //;
      *((argile_match_t * *)&((argile_list_t *)cur)->data) = m;
      ((argile_list_t *)cur)->del = (void *)&argile_match_del;
    } //;
  };
  ((argile).numgen)--;
  return shadow;
}

static unsigned char _match_path_rec(call_path_t * path_2, argile_list_t * syntax, int* eaten)
/** :_match_path_rec <call_path path> <list of (argile syntax) syntax> <(int) * eaten>: -> bool **/
{
  int _eaten = 0;

  if ((eaten)) {
    *eaten = 0;
  } //;
  while (((syntax) && ((path_2)->match))) {
    argile_syntax_t * s = ((argile_syntax_t *)0);
    argile_match_t * m = ((argile_match_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syntax)->data);
    m = *((argile_match_t * *)&((argile_list_t *)(path_2)->match)->data);
    if ((m)) {
      switch ((s)->type) {
        case ARGILE_SYN_WORD: ;
        case ARGILE_SYN_OP: {
          if (((m)->matched != s)) {
            return _match_no_more(path_2, syntax);
          } //;
          if ((eaten)) {
            (*eaten)++;
          } //;
          (path_2)->match = ((argile_list_t *)(path_2)->match)->next;
        } break;
        case ARGILE_SYN_PARAM: {
          if (((m)->matched != s)) {
            return _match_no_more(path_2, syntax);
          } //;
          if ((eaten)) {
            (*eaten)++;
          } //;
          (path_2)->match = ((argile_list_t *)(path_2)->match)->next;
          ++((path_2)->prm);
          _add_param_value(path_2, ((s)->value).syn_param, m);
        } break;
        case ARGILE_SYN_OPTION: {
          argile_list_t * val;

          val = _add_syn_val(&((path_2)->call)->options, ++((path_2)->opt));
          *((int *)&((argile_list_t *)val)->data.u_int) = ((_match_path_rec(path_2, ((s)->value).syn_option, &_eaten)) ? (1) : (0));
          if (!((eaten == NULL))) {
            *eaten += _eaten;
          } //;
        } break;
        case ARGILE_SYN_ENUM: {
          int e = 1;
          int found = 0;
          argile_list_t * val;
          argile_list_t * enm;

          val = _add_syn_val(&((path_2)->call)->enums, ++((path_2)->enm));
          enm = ((s)->value).syn_enum;
          while (!((enm == NULL))) {
            if ((found != 0)) {
              _match_no_more(path_2, *((argile_list_t * *)&((argile_list_t *)enm)->data));
            } else if (_match_path_rec(path_2, *((argile_list_t * *)&((argile_list_t *)enm)->data), &_eaten)) {
              if ((eaten)) {
                *eaten += _eaten;
              } //;
              found = e;
            } //;
            (e)++;
            enm = ((argile_list_t *)enm)->next;
          };
          if ((found == 0)) {
            return _match_no_more(path_2, ((argile_list_t *)syntax)->next);
          } //;
          *((int *)&((argile_list_t *)val)->data.u_int) = found;
        } break;
        case ARGILE_SYN_LIST: {
          int count = 0;
          int old_prm = 0;
          int old_opt = 0;
          int old_enm = 0;
          int old_lst = 0;
          argile_list_t * val;
          unsigned char fresh;
          argile_call_list_t * cl_2 = ((argile_call_list_t *)0);

          old_prm = (path_2)->prm;
          old_opt = (path_2)->opt;
          old_enm = (path_2)->enm;
          old_lst = ++((path_2)->lst);
          fresh = 0;
          if (((path_2)->lst <= argile_list_count(((path_2)->call)->lists))) {
            val = argile_list_seek(((path_2)->call)->lists, ((path_2)->lst - 1));
          } else {
            val = argile_list_new(argile_call_list_new(((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0)), (void *)&argile_call_list_del);
            argile_list_push_back(&((path_2)->call)->lists, val);
            fresh = 1;
          };
          cl_2 = ((argile_call_list_t *)*((void * *)&((argile_list_t *)val)->data.u_anything));
          val = argile_list_new(NULL, ((argile_deleter_t)0));
          argile_list_push_back(&(cl_2)->values, val);
          if (fresh) {
            _make_call_list(path_2, cl_2, (((s)->value).syn_list)->sub);
          } //;
          (path_2)->prm = old_prm;
          (path_2)->opt = old_opt;
          (path_2)->enm = old_enm;
          (path_2)->lst = old_lst;
          while ((_match_path_rec(path_2, (((s)->value).syn_list)->sub, &_eaten) && (_eaten != 0))) {
            (path_2)->prm = old_prm;
            (path_2)->opt = old_opt;
            (path_2)->enm = old_enm;
            (path_2)->lst = old_lst;
            (count)++;
            if ((eaten)) {
              *eaten += _eaten;
            } //;
          };
          if ((count < (((s)->value).syn_list)->min)) {
            if ((((argile_list_t *)val)->prev == NULL)) {
              (cl_2)->values = ((argile_list_t *)0);
            } //;
            argile_list_unlink(((argile_list_t *)val)->prev, val);
            argile_list_del(val);
            return _match_no_more(path_2, ((argile_list_t *)syntax)->next);
          } //;
          *((void * *)&((argile_list_t *)val)->data.u_anything) = ((void *)((long)count));
          _undo_call_list(path_2, cl_2);
        } break;
        default: {} break;
      };
    } //;
    syntax = ((argile_list_t *)syntax)->next;
  };
  _match_no_more(path_2, syntax);
  return (argile_syntax_is_terminal(syntax));
}

static void _fix_path_rec(call_path_t * path_3, argile_list_t * syntax_2)
/** :_fix_path_rec <call_path path> <list of (argile syntax) syntax>: -> nothing **/
{
  for (; (syntax_2); syntax_2 = ((argile_list_t *)syntax_2)->next) {
    argile_syntax_t * syn = ((argile_syntax_t *)0);

    syn = *((argile_syntax_t * *)&((argile_list_t *)syntax_2)->data);
    switch ((syn)->type) {
      case ARGILE_SYN_PARAM: {
        argile_list_t * lx;

        ((path_3)->prm)++;
        for (lx = ((path_3)->call)->params; (lx); lx = ((argile_list_t *)lx)->next) {
          argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

          cp_2 = ((argile_call_param_t *)*((void * *)&((argile_list_t *)lx)->data.u_anything));
          if (((cp_2)->syn_param == ((syn)->value).syn_param)) {
            break;
          } //;
        };
        if ((lx == NULL)) {
          argile_list_push_back(&((path_3)->call)->params, argile_list_new(argile_call_param_new(((syn)->value).syn_param, ((argile_list_t *)0)), (void *)&argile_call_param_del));
        } //;
      } break;
      case ARGILE_SYN_OPTION: {
        if ((++((path_3)->opt) > argile_list_count(((path_3)->call)->options))) {
          argile_list_push_back(&((path_3)->call)->options, argile_list_new(argile_list_new(NULL, ((argile_deleter_t)0)), (void *)&argile_list_del));
        } //;
        _fix_path_rec(path_3, ((syn)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * lx;

        if ((++((path_3)->enm) > argile_list_count(((path_3)->call)->enums))) {
          argile_list_push_back(&((path_3)->call)->enums, argile_list_new(argile_list_new(NULL, ((argile_deleter_t)0)), (void *)&argile_list_del));
        } //;
        lx = ((syn)->value).syn_enum;
        for (; (lx); lx = ((argile_list_t *)lx)->next) {
          _fix_path_rec(path_3, *((argile_list_t * *)&((argile_list_t *)lx)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        if ((++((path_3)->lst) > argile_list_count(((path_3)->call)->lists))) {
          int old_prm = 0;
          int old_opt = 0;
          int old_enm = 0;
          int old_lst = 0;
          argile_call_list_t * cl_2 = ((argile_call_list_t *)0);

          old_prm = (path_3)->prm;
          old_opt = (path_3)->opt;
          old_enm = (path_3)->enm;
          old_lst = (path_3)->lst;
          cl_2 = argile_call_list_new(((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0));
          argile_list_push_back(&((path_3)->call)->lists, argile_list_new(cl_2, (void *)&argile_call_list_del));
          (cl_2)->values = argile_list_new(NULL, ((argile_deleter_t)0));
          _make_call_list(path_3, cl_2, (((syn)->value).syn_list)->sub);
          (path_3)->prm = old_prm;
          (path_3)->opt = old_opt;
          (path_3)->enm = old_enm;
          (path_3)->lst = old_lst;
        } //;
        _fix_path_rec(path_3, (((syn)->value).syn_list)->sub);
      } break;
      default: {} break;
    };
  };
}

static void _make_call_list(call_path_t * path_4, argile_call_list_t * cl_2, argile_list_t * syntax_3)
/** :_make_call_list <call_path path> <call list cl> <list of (argile syntax) syntax>: -> nothing **/
{
  for (; (syntax_3); syntax_3 = ((argile_list_t *)syntax_3)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syntax_3)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        argile_list_push_back(&(cl_2)->params, argile_list_new(((void *)((long)++((path_4)->prm))), ((argile_deleter_t)0)));
      } break;
      case ARGILE_SYN_OPTION: {
        argile_list_push_back(&(cl_2)->options, argile_list_new(((void *)((long)++((path_4)->opt))), ((argile_deleter_t)0)));
        _make_call_list(path_4, cl_2, ((s)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        argile_list_push_back(&(cl_2)->enums, argile_list_new(((void *)((long)++((path_4)->enm))), ((argile_deleter_t)0)));
        le = ((s)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          _make_call_list(path_4, cl_2, *((argile_list_t * *)&((argile_list_t *)le)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        argile_list_push_back(&(cl_2)->lists, argile_list_new(((void *)((long)++((path_4)->lst))), ((argile_deleter_t)0)));
      } break;
      default: {} break;
    };
  };
}

static void _undo_call_list(call_path_t * path_5, argile_call_list_t * cl_3)
/** :_undo_call_list <call_path path> <call list cl>: -> nothing **/
{
  argile_list_t * cur_2;
  argile_list_t * end;
  argile_list_t * found;

  for (cur_2 = (cl_3)->params; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
    found = argile_list_seek(((path_5)->call)->params, (((int)((long)*((void * *)&((argile_list_t *)cur_2)->data.u_anything))) - 1));
    if ((found)) {
      argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

      cp_2 = ((argile_call_param_t *)*((void * *)&((argile_list_t *)found)->data.u_anything));
      end = argile_list_end((cp_2)->matches);
      if ((end)) {
        if (!((((argile_list_t *)end)->prev))) {
          (cp_2)->matches = ((argile_list_t *)0);
        } //;
        argile_list_unlink(((argile_list_t *)end)->prev, end);
        argile_list_del(end);
      } //;
    } //;
  };
  for (cur_2 = (cl_3)->options; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
    found = argile_list_seek(((path_5)->call)->options, (((int)((long)*((void * *)&((argile_list_t *)cur_2)->data.u_anything))) - 1));
    if ((found)) {
      end = argile_list_end(((argile_list_t *)*((void * *)&((argile_list_t *)found)->data.u_anything)));
      if ((end)) {
        if (!((((argile_list_t *)end)->prev))) {
          *((void * *)&((argile_list_t *)found)->data.u_anything) = NULL;
        } //;
        argile_list_unlink(((argile_list_t *)end)->prev, end);
        argile_list_del(end);
      } //;
    } //;
  };
  for (cur_2 = (cl_3)->enums; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
    found = argile_list_seek(((path_5)->call)->enums, (((int)((long)*((void * *)&((argile_list_t *)cur_2)->data.u_anything))) - 1));
    if ((found)) {
      end = argile_list_end(((argile_list_t *)*((void * *)&((argile_list_t *)found)->data.u_anything)));
      if ((end)) {
        if (!((((argile_list_t *)end)->prev))) {
          *((void * *)&((argile_list_t *)found)->data.u_anything) = NULL;
        } //;
        argile_list_unlink(((argile_list_t *)end)->prev, end);
        argile_list_del(end);
      } //;
    } //;
  };
  for (cur_2 = (cl_3)->lists; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
    found = argile_list_seek(((path_5)->call)->lists, (((int)((long)*((void * *)&((argile_list_t *)cur_2)->data.u_anything))) - 1));
    if ((found)) {
      argile_call_list_t * sub_2 = ((argile_call_list_t *)0);

      sub_2 = ((argile_call_list_t *)*((void * *)&((argile_list_t *)found)->data.u_anything));
      end = argile_list_end((sub_2)->values);
      if ((end)) {
        if (!((((argile_list_t *)end)->prev))) {
          (sub_2)->values = ((argile_list_t *)0);
        } //;
        argile_list_unlink(((argile_list_t *)end)->prev, end);
        argile_list_del(end);
      } //;
    } //;
  };
}

static void _add_param_value(call_path_t * path_6, argile_syn_param_t * syn_param, argile_match_t * p_argile_match)
/** :_add_param_value <call_path path> <syn param syn_param> <match>: -> nothing **/
{
  argile_list_t * lp;

  lp = ((path_6)->call)->params;
  for (; (lp); lp = ((argile_list_t *)lp)->next) {
    argile_call_param_t * p = ((argile_call_param_t *)0);

    p = *((argile_call_param_t * *)&((argile_list_t *)lp)->data);
    if (((p)->syn_param == syn_param)) {
      argile_list_push_back(&(p)->matches, argile_list_new(p_argile_match, ((argile_deleter_t)0)));
      return;
    } //;
  };
  argile_list_push_back(&((path_6)->call)->params, argile_list_new(argile_call_param_new(syn_param, argile_list_new(p_argile_match, ((argile_deleter_t)0))), (void *)&argile_call_param_del));
}

static argile_list_t * _add_syn_val(argile_list_t * * list, int id)
/** :_add_syn_val <(list of (list of (int))) & list> <int id>: -> list of (int) **/
{
  int count = 0;
  argile_list_t * val;
  argile_list_t * elem;
  argile_list_t * loi;

  val = *list;
  for (; (val); val = ((argile_list_t *)val)->next) {
    (count)++;
    if ((((argile_list_t *)val)->next == NULL)) {
      break;
    } //;
  };
  if ((id <= count)) {
    elem = argile_list_seek(*list, (id - 1));
  } else {
    elem = argile_list_new(NULL, (void *)&argile_list_del);
    if ((val)) {
      argile_list_link(val, elem);
    } else {
      *list = elem;
    };
  };
  loi = argile_list_new(NULL, ((argile_deleter_t)0));
  argile_list_push_back(((argile_list_t * *)&((argile_list_t *)elem)->data), loi);
  return loi;
}

static unsigned char _match_no_more(call_path_t * path_7, argile_list_t * syn)
/** :_match_no_more <call_path path> <list of (argile syntax) syn>: -> bool **/
{
  for (; (syn); syn = ((argile_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syn)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        ++((path_7)->prm);
        _add_param_value(path_7, ((s)->value).syn_param, ((argile_match_t *)0));
      } break;
      case ARGILE_SYN_OPTION: {
        _add_syn_val(&((path_7)->call)->options, ++((path_7)->opt));
        _match_no_more(path_7, ((s)->value).syn_option);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * sub_2;

        _add_syn_val(&((path_7)->call)->enums, ++((path_7)->enm));
        sub_2 = ((s)->value).syn_enum;
        for (; (sub_2); sub_2 = ((argile_list_t *)sub_2)->next) {
          _match_no_more(path_7, *((argile_list_t * *)&((argile_list_t *)sub_2)->data));
        };
      } break;
      case ARGILE_SYN_LIST: {
        int old_prm = 0;
        int old_opt = 0;
        int old_enm = 0;
        int old_lst = 0;
        argile_list_t * val;
        unsigned char fresh;
        argile_call_list_t * cl_4 = ((argile_call_list_t *)0);

        old_prm = (path_7)->prm;
        old_opt = (path_7)->opt;
        old_enm = (path_7)->enm;
        old_lst = ++((path_7)->lst);
        fresh = 0;
        if (((path_7)->lst <= argile_list_count(((path_7)->call)->lists))) {
          val = argile_list_seek(((path_7)->call)->lists, ((path_7)->lst - 1));
        } else {
          val = argile_list_new(argile_call_list_new(((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0), ((argile_list_t *)0)), (void *)&argile_call_list_del);
          argile_list_push_back(&((path_7)->call)->lists, val);
          fresh = 1;
        };
        cl_4 = *((argile_call_list_t * *)&((argile_list_t *)val)->data);
        argile_list_push_back(&(cl_4)->values, argile_list_new(NULL, ((argile_deleter_t)0)));
        if (fresh) {
          _make_call_list(path_7, cl_4, (((s)->value).syn_list)->sub);
        } //;
        (path_7)->prm = old_prm;
        (path_7)->opt = old_opt;
        (path_7)->enm = old_enm;
        (path_7)->lst = old_lst;
      } break;
      default: {} break;
    };
  };
  return 0;
}

static void _count_syn(argile_list_t * match_2, int max_2, int * nw, int * no, int * np, int * nb, int * ns)
/** :_count_syn <list of (match) match> <int max> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
{
  *nw = 0;
  *no = 0;
  *np = 0;
  *nb = 0;
  *ns = 0;
  while (((match_2) && ((max_2)-- != 0))) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)match_2)->data);
    if ((m)) {
      switch ((m)->type) {
        case ARGILE_MATCH_WORD: {
          (*nw)++;
          *nb += strlen(((m)->value).word);
          *ns += _xc2a7_(((m)->value).word);
        } break;
        case ARGILE_MATCH_OP: {
          (*no)++;
          *nb += strlen(((m)->value).op);
          *ns += _xc2a7_(((m)->value).op);
        } break;
        case ARGILE_MATCH_CONS: ;
        case ARGILE_MATCH_SUBCALL: {
          (*np)++;
        } break;
        default: {} break;
      };
    } //;
    match_2 = ((argile_list_t *)match_2)->next;
  };
}

static int _xc2a7_(char * t)
/** :§ <text t>: -> int **/
{
  int s = 0;

  while ((*&(t)[0] != 0)) {
    s += (*&((t)++)[0] & 0xff);
  };
  return s;
}

static void _adj_syn(argile_list_t * match_3, int add, int * nw_2, int * no_2, int * np_2, int * nb_2, int * ns_2)
/** :_adj_syn <list of (match) match> <int add> <(int) & nw> <(int) & no> <(int) & np> <(int) & nb> <(int) & ns>: -> nothing **/
{
  argile_match_t * m = ((argile_match_t *)0);

  m = *((argile_match_t * *)&((argile_list_t *)match_3)->data);
  if ((m == NULL)) {
    return;
  } //;
  switch ((m)->type) {
    case ARGILE_MATCH_WORD: {
      *nw_2 += add;
      *nb_2 += (add * strlen(((m)->value).word));
      *ns_2 += (add * _xc2a7_(((m)->value).word));
    } break;
    case ARGILE_MATCH_OP: {
      *no_2 += add;
      *nb_2 += (add * strlen(((m)->value).op));
      *ns_2 += (add * _xc2a7_(((m)->value).op));
    } break;
    case ARGILE_MATCH_CONS: ;
    case ARGILE_MATCH_SUBCALL: {
      *np_2 += add;
    } break;
    default: {} break;
  };
}

static void _print_compil_(argile_call_t * p_argile_call_33, argile_type_t type_4)
/** :_print_compil_ <call> <argile type type>: -> nothing **/
{
  argile_buff_t b = ((argile_buff_t){0});
  int i = 0;

  for (i = 1; ((i <= (argile).indent)); (i)++) {
    argile_buff_puts(&b, "  ");
  };
  argile_call_string(p_argile_call_33, (argile).indent, &b);
  argile_buff_puts(&b, " (: as ");
  argile_typename(type_4, &b, (p_argile_call_33)->scope);
  argile_buff_puts(&b, " :)");
  argile_buff_putc(&b, '\0');
  printf("%s", (b).ptr);
  argile_dbg_free((b).ptr);
}

static unsigned char known_call_signature_of(argile_call_t * p_argile_call_34, argile_def_t * p_argile_def_5, int off, int len_2)
/** :known call signature of <call> + <def> + <int off> + <int len>: -> bool **/
{
  argile_buff_t * sigbuf = ((argile_buff_t *)0);
  char * signature = "";
  unsigned int s = 0;

  sigbuf = (argile).signbuffer;
  argile_buff_flush(sigbuf);
  make_call_signature_of_in(p_argile_call_34, p_argile_def_5, off, len_2, sigbuf);
  argile_buff_putc(sigbuf, '\0');
  signature = (sigbuf)->ptr;
  s = (argile_hash(signature) % 256);
  if ((argile_list_search(((p_argile_call_34)->sigs)[s], signature, (void *)&argile_streq) == NULL)) {
    signature = ((char *)argile_dbg_malloc((sigbuf)->len));
    memcpy(signature, (sigbuf)->ptr, (sigbuf)->len);
    argile_list_prepend(&((p_argile_call_34)->sigs)[s], argile_list_new(signature, (void *)&argile_dbg_free));
    return 0;
  } //;
  return 1;
}

static void make_call_signature_of_in(argile_call_t * p_argile_call_35, argile_def_t * p_argile_def_6, int off_2, int len_3, argile_buff_t * p_argile_buff)
/** :make call signature of <call> + <def> + <int off> + <int len> in <buff>: -> nothing **/
{
  int pos = 0;
  argile_list_t * lm;

  lm = (p_argile_call_35)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    if (!((p_argile_def_6 == NULL))) {
      if ((pos == off_2)) {
        argile_buff_printf(p_argile_buff, "(%p", p_argile_def_6);
      } //;
    } //;
    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      argile_buff_printf(p_argile_buff, "(%p", (((m)->value).call)->def);
      make_call_signature_of_in(((m)->value).call, ((argile_def_t *)0), 0, 0, p_argile_buff);
      argile_buff_puts(p_argile_buff, ")");
    } //;
    else {
      argile_buff_puts(p_argile_buff, ".");
    };
    (pos)++;
    if (!((p_argile_def_6 == NULL))) {
      if ((pos == (off_2 + len_3))) {
        argile_buff_puts(p_argile_buff, ")");
      } //;
    } //;
  };
}

static unsigned char bypass_deps_only(argile_call_t * p_argile_call_36)
/** :bypass deps only <call>: -> bool **/
{
  argile_bind_t * bnd = ((argile_bind_t *)0);
  argile_module_t * std = ((argile_module_t *)0);

  if (!((argile).deps_only)) {
    return 0;
  } //;
  if ((((p_argile_call_36)->def)->dtype != ARGILE_DEF_BIND)) {
    return 0;
  } //;
  bnd = (((p_argile_call_36)->def)->dval).bind;
  if ((strcmp((bnd)->name, "use") != 0)) {
    return 0;
  } //;
  std = argile_getmod("std");
  if ((std == NULL)) {
    return 0;
  } //;
  bnd = argile_module_getbind(std, "use");
  if ((bnd == NULL)) {
    return 0;
  } //;
  if ((bnd != (((p_argile_call_36)->def)->dval).bind)) {
    return 0;
  } //;
  return 1;
}

static unsigned char fix_param_enum(argile_list_t * ls, argile_match_t * m, argile_call_t * c)
/** :fix param enum <list of (argile syntax) ls> <match m> <call c>: -> bool **/
{
  for (; (ls); ls = ((argile_list_t *)ls)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)ls)->data);
    switch ((s)->type) {
      case ARGILE_SYN_OPTION: {
        if (fix_param_enum(((s)->value).syn_option, m, c)) {
          return 1;
        } //;
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s)->value).syn_enum;
        if (is_enum_of_param(le, (m)->matched)) {
          for (; (le); le = ((argile_list_t *)le)->next) {
            ls = *((argile_list_t * *)&((argile_list_t *)le)->data);
            if ((((argile_list_t *)ls)->next == NULL)) {
              s = *((argile_syntax_t * *)&((argile_list_t *)ls)->data);
              if ((((s)->type == ARGILE_SYN_PARAM) && ((s != (m)->matched) && _compile_as(c, (((s)->value).syn_param)->type)))) {
                (m)->matched = s;
                return 1;
              } //;
            } //;
          };
          return 0;
        } else {
          for (; (le); le = ((argile_list_t *)le)->next) {
            if (fix_param_enum(*((argile_list_t * *)&((argile_list_t *)le)->data), m, c)) {
              return 1;
            } //;
          };
        };
      } break;
      case ARGILE_SYN_LIST: {
        if (fix_param_enum((((s)->value).syn_list)->sub, m, c)) {
          return 1;
        } //;
      } break;
      default: {} break;
    };
  };
  return 0;
}

static unsigned char is_enum_of_param(argile_list_t * le_2, argile_syntax_t * matched)
/** :<list of (list of (argile syntax)) le> is enum of param <argile syntax matched>: -> bool **/
{
  int count = 0;
  unsigned char found;

  found = 0;
  for (; (le_2); le_2 = ((argile_list_t *)le_2)->next) {
    argile_list_t * ls_2;

    ls_2 = *((argile_list_t * *)&((argile_list_t *)le_2)->data);
    if ((((argile_list_t *)ls_2)->next == NULL)) {
      argile_syntax_t * s_2 = ((argile_syntax_t *)0);

      s_2 = *((argile_syntax_t * *)&((argile_list_t *)ls_2)->data);
      if (((s_2)->type == ARGILE_SYN_PARAM)) {
        (count)++;
        if ((s_2 == matched)) {
          found = 1;
        } //;
        if ((found && (count >= 2))) {
          return 1;
        } //;
      } //;
    } //;
  };
  return 0;
}

static void _def_params_locall(argile_list_t * syntax_4, argile_call_t * p_argile_call_37)
/** :_def_params_locall <list of (argile syntax) syntax> <call>: -> nothing **/
{
  for (; (syntax_4); syntax_4 = ((argile_list_t *)syntax_4)->next) {
    argile_syntax_t * syn_2 = ((argile_syntax_t *)0);

    syn_2 = *((argile_syntax_t * *)&((argile_list_t *)syntax_4)->data);
    switch ((syn_2)->type) {
      case ARGILE_SYN_PARAM: {
        argile_syn_param_t * p = ((argile_syn_param_t *)0);
        argile_def_t * d = ((argile_def_t *)0);

        p = ((syn_2)->value).syn_param;
        if ((((p)->name == NULL) || (!((p)->comp) || ((p)->genid)))) {
          break;
        } //;
        d = argile_def_new(argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, argile_dbg_strdup((p)->name)), (void *)&argile_syntax_del), 1, (((int)(p)->type) & ~((1 << 31))), p_argile_call_37, ARGILE_DEF_VAR, argile_var_new((p)->type, ((argile_match_t *)0)));
        (p)->def = d;
        (d)->param = p;
        (d)->locall = 1;
        argile_code_def((p_argile_call_37)->scope, d, 1);
      } break;
      case ARGILE_SYN_OPTION: {
        _def_params_locall(((syn_2)->value).syn_option, p_argile_call_37);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((syn_2)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          _def_params_locall(*((argile_list_t * *)&((argile_list_t *)le)->data), p_argile_call_37);
        };
      } break;
      case ARGILE_SYN_LIST: {
        _def_params_locall((((syn_2)->value).syn_list)->sub, p_argile_call_37);
      } break;
      default: {} break;
    };
  };
}

static argile_list_t * _get_union_fields(argile_type_t ctx, argile_type_t type_5)
/** :_get_union_fields <argile type ctx> <argile type type>: -> list of (field) **/
{
  argile_type_info_t * i = ((argile_type_info_t *)0);

  i = argile_type_get_info(type_5);
  if (((i) && ((i)->ttype == ARGILE_TYPE_KIND_UNION))) {
    argile_list_t * lv;

    if ((i)->rec) {
      return ((argile_list_t *)0);
    } //;
    if ((((i)->tval).t_union).silent) {
      return ((argile_list_t *)0);
    } //;
    lv = (((i)->tval).t_union).variants;
    for (; (lv); lv = ((argile_list_t *)lv)->next) {
      argile_field_t * f = ((argile_field_t *)0);
      argile_list_t * lf_2;

      f = *((argile_field_t * *)&((argile_list_t *)lv)->data);
      if ((ctx == (((int)(f)->type) & ((1 << 30) - 1)))) {
        return argile_list_new(f, ((argile_deleter_t)0));
      } //;
      (i)->rec = 1;
      lf_2 = _get_union_fields(ctx, (f)->type);
      (i)->rec = 0;
      if ((lf_2)) {
        argile_list_prepend(&lf_2, argile_list_new(f, ((argile_deleter_t)0)));
        return lf_2;
      } //;
    };
  } //;
  return ((argile_list_t *)0);
}

static void _call_args(argile_call_t * p_argile_call_38)
/** :_call_args <call>: -> nothing **/
{
  argile_code_t * code_6 = ((argile_code_t *)0);
  unsigned char first;
  argile_call_param_t * cvariadic = ((argile_call_param_t *)0);
  argile_list_t * lp;

  code_6 = (((p_argile_call_38)->def)->dval).code;
  first = 1;
  if ((code_6)) {
    argile_list_t * ld;

    for (ld = (code_6)->autoparams; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      int ref = 0;
      argile_code_t * scope = ((argile_code_t *)0);

      d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
      _comma(&first);
      if ((((d)->param == NULL) || !((((((int)((d)->param)->type) >> 31) & 1))))) {
        (ref)--;
      } //;
      if ((((d)->param) && ((d)->param)->in_list)) {
        (ref)++;
      } //;
      scope = (p_argile_call_38)->scope;
      while ((scope)) {
        if (((scope == code_6) || (argile_list_search((scope)->autoparams, d, ((argile_comparer_t)0))))) {
          ref = 0;
          break;
        } //;
        if (((d)->scope == scope)) {
          break;
        } //;
        scope = (scope)->upper;
      };
      argile_ref(ref);
      argile_puts(argile_def_gen_id(d));
    };
  } //;
  lp = (p_argile_call_38)->params;
  for (; (lp); lp = ((argile_list_t *)lp)->next) {
    argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

    cp_2 = *((argile_call_param_t * *)&((argile_list_t *)lp)->data);
    if (((cp_2)->syn_param)->pseudo) {
      cvariadic = cp_2;
      continue;
    } //;
    _comma(&first);
    if (!(((cp_2)->syn_param)->in_list)) {
      argile_call_param_gencode(cp_2, ((argile_call_t *)0));
    } else {
      unsigned char sub_first;
      argile_type_t t_2;
      argile_list_t * ly;

      sub_first = 1;
      t_2 = ((cp_2)->syn_param)->type;
      argile_puts("(");
      argile_type_gen_prefix(t_2);
      argile_puts("[]");
      argile_type_gen_suffix(t_2);
      argile_puts("){");
      ly = (cp_2)->matches;
      do {
        _comma(&sub_first);
        argile_call_param_gencode(cp_2, ((argile_call_t *)0));
        if (((cp_2)->matches)) {
          (cp_2)->matches = ((argile_list_t *)(cp_2)->matches)->next;
        } //;
      } while (((cp_2)->matches));
      (cp_2)->matches = ly;
      argile_puts("}");
    };
  };
  if ((((code_6) && (code_6)->variadic) || ((code_6 == NULL) && !(((p_argile_call_38)->def)->ext)))) {
    int id_2 = 1;
    argile_list_t * lo;
    argile_list_t * le;
    argile_list_t * ll;

    lo = (p_argile_call_38)->options;
    for (; (lo); lo = ((argile_list_t *)lo)->next) {
      unsigned char in_list;
      argile_list_t * ly;

      in_list = 0;
      ly = (p_argile_call_38)->lists;
      for (; (ly); ly = ((argile_list_t *)ly)->next) {
        if (((*((argile_call_list_t * *)&((argile_list_t *)ly)->data)) && (argile_list_search((*((argile_call_list_t * *)&((argile_list_t *)ly)->data))->options, ((void *)((long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        } //;
      };
      _comma(&first);
      if (!(in_list)) {
        argile_putn((((*((argile_list_t * *)&((argile_list_t *)lo)->data))) ? (*((int *)&((argile_list_t *)*((argile_list_t * *)&((argile_list_t *)lo)->data))->data.u_int)) : (0)));
      } else if ((*((argile_list_t * *)&((argile_list_t *)lo)->data))) {
        unsigned char sub_first;
        argile_list_t * ly_2;

        sub_first = 1;
        argile_puts("(char[]){");
        ly_2 = *((argile_list_t * *)&((argile_list_t *)lo)->data);
        for (; (ly_2); ly_2 = ((argile_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argile_list_t *)ly_2)->data.u_int));
        };
        argile_puts("}");
      } else {
        argile_puts("(char *)0");
      };
      (id_2)++;
    };
    id_2 = 1;
    le = (p_argile_call_38)->enums;
    for (; (le); le = ((argile_list_t *)le)->next) {
      unsigned char in_list;
      argile_list_t * ly;

      in_list = 0;
      ly = (p_argile_call_38)->lists;
      for (; (ly); ly = ((argile_list_t *)ly)->next) {
        if (((*((argile_call_list_t * *)&((argile_list_t *)ly)->data)) && (argile_list_search((*((argile_call_list_t * *)&((argile_list_t *)ly)->data))->enums, ((void *)((long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        } //;
      };
      _comma(&first);
      if (!(in_list)) {
        argile_putn((((*((argile_list_t * *)&((argile_list_t *)le)->data))) ? (*((int *)&((argile_list_t *)*((argile_list_t * *)&((argile_list_t *)le)->data))->data.u_int)) : (0)));
      } else if ((*((argile_list_t * *)&((argile_list_t *)le)->data))) {
        unsigned char sub_first;
        argile_list_t * ly_2;

        sub_first = 1;
        argile_puts("(int[]){");
        ly_2 = *((argile_list_t * *)&((argile_list_t *)le)->data);
        for (; (ly_2); ly_2 = ((argile_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argile_list_t *)ly_2)->data.u_int));
        };
        argile_puts("}");
      } else {
        argile_puts("(int *)0");
      };
      (id_2)++;
    };
    id_2 = 1;
    ll = (p_argile_call_38)->lists;
    for (; (ll); ll = ((argile_list_t *)ll)->next) {
      unsigned char in_list;
      argile_call_list_t * cl_4 = ((argile_call_list_t *)0);
      argile_list_t * ly;

      in_list = 0;
      cl_4 = *((argile_call_list_t * *)&((argile_list_t *)ll)->data);
      if (((cvariadic) && (((cl_4)->params) && !((((argile_list_t *)(cl_4)->params)->next))))) {
        if (((!(((cl_4)->options)) && !(((cl_4)->enums))) && !(((cl_4)->lists)))) {
          argile_list_t * lcp;

          lcp = argile_list_seek((p_argile_call_38)->params, (*((int *)&((argile_list_t *)(cl_4)->params)->data.u_int) - 1));
          if ((lcp)) {
            argile_call_param_t * cp_2 = ((argile_call_param_t *)0);

            cp_2 = *((argile_call_param_t * *)&((argile_list_t *)lcp)->data);
            if ((((cp_2) && ((cp_2)->syn_param)) && ((cp_2)->syn_param)->pseudo)) {
              continue;
            } //;
          } //;
        } //;
      } //;
      ly = (p_argile_call_38)->lists;
      for (; (ly); ly = ((argile_list_t *)ly)->next) {
        if ((((ll != ly) && (*((argile_call_list_t * *)&((argile_list_t *)ly)->data))) && (argile_list_search((*((argile_call_list_t * *)&((argile_list_t *)ly)->data))->lists, ((void *)((long)id_2)), ((argile_comparer_t)0))))) {
          in_list = 1;
        } //;
      };
      cl_4 = *((argile_call_list_t * *)&((argile_list_t *)ll)->data);
      _comma(&first);
      if (!(in_list)) {
        argile_putn(((((cl_4) && ((cl_4)->values))) ? (*((int *)&((argile_list_t *)(cl_4)->values)->data.u_int)) : (0)));
      } else if (((cl_4) && ((cl_4)->values))) {
        unsigned char sub_first;
        argile_list_t * ly_2;

        sub_first = 1;
        argile_puts("(int[]){");
        ly_2 = (cl_4)->values;
        for (; (ly_2); ly_2 = ((argile_list_t *)ly_2)->next) {
          _comma(&sub_first);
          argile_putn(*((int *)&((argile_list_t *)ly_2)->data.u_int));
        };
        argile_puts("}");
      } else {
        argile_puts("(int *)0");
      };
      (id_2)++;
    };
  } //;
  if ((cvariadic)) {
    argile_call_param_t * cp_2 = ((argile_call_param_t *)0);
    argile_list_t * ly;

    cp_2 = cvariadic;
    ly = (cp_2)->matches;
    for (; ((cp_2)->matches); (cp_2)->matches = ((argile_list_t *)(cp_2)->matches)->next) {
      _comma(&first);
      argile_call_param_gencode(cp_2, ((argile_call_t *)0));
    };
    (cp_2)->matches = ly;
  } //;
}

static void _comma(unsigned char * first_2)
/** :_comma <(bool) & first>: -> nothing **/
{
  if (*first_2) {
    *first_2 = 0;
  } else {
    argile_puts(", ");
  };
}

static argile_code_t * _get_macro_body(argile_code_t * code_5, argile_def_t * p_argile_def_7)
/** :_get_macro_body <argile code code> <def>: -> argile code **/
{
  if ((p_argile_def_7 == NULL)) {
    return ((argile_code_t *)0);
  } //;
  while ((code_5)) {
    if ((((code_5)->macro_shovels) && ((p_argile_def_7)->scope == code_5))) {
      return code_5;
    } //;
    code_5 = (code_5)->upper;
  };
  return ((argile_code_t *)0);
}

