// generated by: arc -xuNP -A ./../argrt -M -o match.c -H match.h -m match.argl.tmp match.arg 
#include "match.h"

static argile_cons_t * get_cons(argile_match_t *);
/** :get cons <match>: -> (argile) cons **/
static int _check_recurse_eq(argile_match_t *, argile_match_t *);
/** :_check_recurse_eq <match ma> <match mb>: -> int **/
static unsigned char _match_try_rec(argile_list_t *, argile_list_t *, int, int *, unsigned char);
/** :_match_try_rec <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <bool in_list>: -> bool **/

argile_match_t * argile_match_new(argile_match_type_t type, void * data)
/** :argile_match_new <match type type> <any data>: -> (argile) match **/
{
  argile_match_t * match = ((argile_match_t *)0);

  match = ((argile_match_t *)memset(argile_dbg_malloc(sizeof(argile_match_t)), 0, sizeof(argile_match_t)));
  (match)->type = type;
  ((match)->value).data = data;
  return match;
}

void argile_match_del(argile_match_t * p_argile_match)
/** :argile_match_del <match>: -> nothing **/
{
  switch ((p_argile_match)->type) {
    case ARGILE_MATCH_WORD: ;
    case ARGILE_MATCH_OP: {
      argile_dbg_free(((p_argile_match)->value).word);
    } break;
    case ARGILE_MATCH_CONS: {
      argile_cons_del(((p_argile_match)->value).cons);
    } break;
    case ARGILE_MATCH_SUBCALL: {
      argile_call_del(((p_argile_match)->value).call);
    } break;
    default: {} break;
  };
  argile_dbg_free(p_argile_match);
}

int argile_match_eq(argile_match_t * ma, argile_match_t * mb)
/** :argile_match_eq <match ma> <match mb>: -> int **/
{
  unsigned char ha;
  unsigned char hb;
  argile_type_t ta;
  argile_type_t tb;

  if ((argile).stats) {
    (((argile).stat).num_match_eq)++;
  } //;
  if ((ma == mb)) {
    return 1;
  } //;
  if (((ma == NULL) || (mb == NULL))) {
    return 0;
  } //;
  ha = (ma)->hollow;
  if ((!(ha) && ((ma)->type == ARGILE_MATCH_SUBCALL))) {
    argile_def_t * d = ((argile_def_t *)0);

    d = (((ma)->value).call)->def;
    if ((((d) && ((d)->param)) && !(((((d)->dval).var)->macro_params)))) {
      ha = 1;
    } //;
  } //;
  hb = (mb)->hollow;
  if ((!(hb) && ((mb)->type == ARGILE_MATCH_SUBCALL))) {
    argile_def_t * d = ((argile_def_t *)0);

    d = (((mb)->value).call)->def;
    if ((((d) && ((d)->param)) && !(((((d)->dval).var)->macro_params)))) {
      hb = 1;
    } //;
  } //;
  if ((ha && hb)) {
    return ((((ma)->matched == (mb)->matched)) ? (1) : (0));
  } //;
  if ((ha || hb)) {
    return 0;
  } //;
  ta = (((int)argile_match_get_type(ma)) & ~((1 << 31)));
  tb = (((int)argile_match_get_type(mb)) & ~((1 << 31)));
  if ((ta != tb)) {
    return 0;
  } //;
  switch (ta) {
    case ARGILE_TYPE_TYPE: {
      return (((argile_match_eval_type(ma) == argile_match_eval_type(mb))) ? (1) : (0));
    } break;
    case ARGILE_TYPE_WORD: {
      char * wa = "";
      char * wb = "";

      wa = argile_match_eval_word(ma);
      wb = argile_match_eval_word(mb);
      if (((wa == NULL) && (wb == NULL))) {
        return 1;
      } //;
      if (((wa == NULL) || (wb == NULL))) {
        return 0;
      } //;
      return (((strcmp(wa, wb) == 0)) ? (1) : (0));
    } break;
    case ARGILE_TYPE_INTEGER: {
      int ea = 0;
      int eb = 0;
      long ia;
      long ib;

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ia = argile_match_eval_long(ma, &ea);
      ib = argile_match_eval_long(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((ea != 0) || (eb != 0))) {
        return 0;
      } //;
      return (((ia == ib)) ? (1) : (0));
    } break;
    case ARGILE_TYPE_NATURAL: {
      int ea = 0;
      int eb = 0;
      unsigned int na = 0;
      unsigned int nb = 0;

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      na = argile_match_eval_nat(ma, &ea);
      nb = argile_match_eval_nat(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((ea != 0) || (eb != 0))) {
        return 0;
      } //;
      return (((na == nb)) ? (1) : (0));
    } break;
    case ARGILE_TYPE_REAL: {
      int ea = 0;
      int eb = 0;
      double ra = 0.0;
      double rb = 0.0;

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ra = argile_match_eval_real(ma, &ea);
      rb = argile_match_eval_real(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((ea != 0) || (eb != 0))) {
        return 0;
      } //;
      return (((ra == rb)) ? (1) : (0));
    } break;
    case ARGILE_TYPE_TEXT: {
      argile_text_t * xa = ((argile_text_t *)0);
      argile_text_t * xb = ((argile_text_t *)0);

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      xa = argile_match_eval_text(ma);
      xb = argile_match_eval_text(mb);
      if (((xa == NULL) && (xb == NULL))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((xa == NULL) || (xb == NULL))) {
        return 0;
      } //;
      return (((strcmp((xa)->str, (xb)->str) == 0)) ? (1) : (0));
    } break;
    case ARGILE_TYPE_SYNTAX: {
      argile_list_t * sa;
      argile_list_t * sb;

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      sa = argile_match_eval_syntax(ma);
      sb = argile_match_eval_syntax(mb);
      if (((sa == NULL) && (sb == NULL))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((sa == NULL) || (sb == NULL))) {
        return 0;
      } //;
    } break;
    case ARGILE_TYPE_CODE: {
      argile_code_t * ca = ((argile_code_t *)0);
      argile_code_t * cb = ((argile_code_t *)0);

      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ca = argile_match_eval_code(ma);
      cb = argile_match_eval_code(mb);
      if (((ca == NULL) && (cb == NULL))) {
        return _check_recurse_eq(ma, mb);
      } //;
      if (((ca == NULL) || (cb == NULL))) {
        return 0;
      } //;
      if ((((ca)->calls == NULL) && ((cb)->calls == NULL))) {
        return 1;
      } //;
      if ((((ca)->calls == NULL) || ((cb)->calls == NULL))) {
        return 0;
      } //;
    } break;
    default: {} break;
  };
  return 0;
}

argile_match_t * argile_match_shadow(argile_match_t * p_argile_match_2)
/** :argile_match_shadow <match>: -> (argile) match **/
{
  argile_match_t * shadow = ((argile_match_t *)0);

  shadow = argile_match_new((p_argile_match_2)->type, ((p_argile_match_2)->value).data);
  (shadow)->matched = (p_argile_match_2)->matched;
  (shadow)->processed = (p_argile_match_2)->processed;
  (shadow)->hollow = (p_argile_match_2)->hollow;
  (shadow)->evaled = (p_argile_match_2)->evaled;
  (shadow)->etype = (p_argile_match_2)->etype;
  return shadow;
}

void argile_match_string(argile_match_t * p_argile_match_3, int indent, argile_buff_t * buf, int cons_types)
/** :argile_match_string <match> <int indent> <buff buf> <int cons_types>: -> nothing **/
{
  char * clr = (char *)0;

  if (((p_argile_match_3)->matched)) {
    if (((((p_argile_match_3)->matched)->type == ARGILE_SYN_PARAM) && (((((p_argile_match_3)->matched)->value).syn_param)->type == ARGILE_TYPE_WORD))) {
      clr = "\x1b[2;32m";
    } //;
    else if ((cons_types != 0)) {
      clr = "\x1b[1;32m";
    } //;
  } //;
  else if ((cons_types != 0)) {
    clr = (((p_argile_match_3)->processed) ? ("\x1b[1;31m") : ("\x1b[0;1m"));
  } //;
  if ((clr)) {
    argile_push_color(buf, clr);
  } //;
  switch ((p_argile_match_3)->type) {
    case ARGILE_MATCH_WORD: ;
    case ARGILE_MATCH_OP: {
      argile_buff_puts(buf, ((p_argile_match_3)->value).word);
    } break;
    case ARGILE_MATCH_CONS: {
      if ((cons_types != 0)) {
        argile_buff_putc(buf, '<');
        argile_typename((((p_argile_match_3)->value).cons)->type, buf, (argile).main);
        argile_buff_putc(buf, '>');
      } //;
      else {
        argile_cons_string(((p_argile_match_3)->value).cons, indent, buf);
      };
    } break;
    case ARGILE_MATCH_SUBCALL: {
      argile_call_t * call = ((argile_call_t *)0);

      call = ((p_argile_match_3)->value).call;
      if ((call)->stealth) {
        argile_buff_puts(buf, "(:[:) ");
        argile_call_string(call, indent, buf);
        argile_buff_puts(buf, " (:]:)");
      } //;
      else {
        argile_buff_putc(buf, *&("(")[0]);
        argile_call_string(call, indent, buf);
        argile_buff_putc(buf, *&(")")[0]);
      };
    } break;
    default: {
      argile_buff_puts(buf, "(: bad match type ");
      argile_buff_putn(buf, ((int)(p_argile_match_3)->type));
      argile_buff_puts(buf, " :)");
    } break;
  };
  if ((clr)) {
    argile_pop_color(buf);
  } //;
}

void argile_match_setup(argile_match_t * p_argile_match_4, argile_call_t * owner)
/** :argile_match_setup <match> <call owner>: -> nothing **/
{
  if (((p_argile_match_4)->type == ARGILE_MATCH_CONS)) {
    argile_cons_setup(((p_argile_match_4)->value).cons, owner);
  } //;
  else if (((p_argile_match_4)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_setup(((p_argile_match_4)->value).call, (owner)->scope, owner);
  } //;
}

int argile_match_type(argile_match_t * p_argile_match_5, argile_type_t type_2)
/** :argile_match_type <match> <argile type type>: -> int **/
{
  if ((type_2 == ARGILE_TYPE_WORD)) {
    if (((p_argile_match_5)->type == ARGILE_MATCH_WORD)) {
      return 1;
    } //;
    if ((argile_match_eval_word(p_argile_match_5))) {
      return 1;
    } //;
    return 0;
  } //;
  switch ((p_argile_match_5)->type) {
    case ARGILE_MATCH_WORD: {
      return (((type_2 == ARGILE_TYPE_WORD)) ? (1) : (0));
    } break;
    case ARGILE_MATCH_CONS: {
      return (((argile_cons_match_type(((p_argile_match_5)->value).cons, type_2))) ? (1) : (0));
    } break;
    case ARGILE_MATCH_SUBCALL: {
      argile_call_t * sub = ((argile_call_t *)0);
      argile_type_t old;

      sub = ((p_argile_match_5)->value).call;
      old = (sub)->context;
      if (!((sub)->compiled)) {
        return 1;
      } //;
      (sub)->context = type_2;
      if ((argile_type_match(type_2, argile_call_get_type(sub)))) {
        return 1;
      } //;
      (sub)->context = old;
      return 0;
    } break;
    default: {} break;
  };
  return 0;
}

int argile_match_try(argile_list_t * syntax, argile_list_t * match, int size, int * size_ret, int in_list)
/** :argile_match_try <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <int in_list>: -> int **/
{
  int oldmatch = 0;
  unsigned char try;

  if ((argile).stats) {
    (((argile).stat).num_match_try)++;
  } //;
  oldmatch = (argile).nummatch;
  (argile).nummatch = 0;
  try = _match_try_rec(syntax, match, size, size_ret, (in_list));
  if ((((argile).maxmatch > 0) && ((argile).maxmatch <= (argile).nummatch))) {
    argile_buff_t b = ((argile_buff_t){0});

    argile_syntax_string(syntax, &b);
    argile_buff_putc(&b, '\0');
    argile_die("max. syntax match (%d) reached\n  :%s:", (argile).maxmatch, (b).ptr);
    argile_dbg_free((b).ptr);
  } //;
  (argile).nummatch = oldmatch;
  return ((int)try);
}

argile_type_t argile_match_get_type(argile_match_t * p_argile_match_6)
/** :argile_match_get_type <match>: -> argile type **/
{
  if ((p_argile_match_6 == NULL)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  switch ((p_argile_match_6)->type) {
    case ARGILE_MATCH_WORD: {
      return (argile_type_t)ARGILE_TYPE_WORD;
    } break;
    case ARGILE_MATCH_CONS: {
      return (((p_argile_match_6)->value).cons)->type;
    } break;
    case ARGILE_MATCH_SUBCALL: {
      return argile_call_get_type(((p_argile_match_6)->value).call);
    } break;
    default: {} break;
  };
  return ARGILE_TYPE_NOTHING;
}

void argile_match_gencode(argile_match_t * p_argile_match_7)
/** :argile_match_gencode <match>: -> nothing **/
{
  argile_type_t type_3;
  argile_type_t t;
  unsigned char need_ref;
  argile_list_t * chain = ((argile_list_t *)0);
  int paren = 0;
  argile_list_t * lc;

  if ((p_argile_match_7 == NULL)) {
    return;
  } //;
  switch ((p_argile_match_7)->type) {
    case ARGILE_MATCH_WORD: {
      argile_puts(((p_argile_match_7)->value).word);
      return;
    } break;
    case ARGILE_MATCH_CONS: {
      type_3 = (((p_argile_match_7)->value).cons)->rtype;
    } break;
    case ARGILE_MATCH_SUBCALL: {
      type_3 = (((p_argile_match_7)->value).call)->context;
    } break;
    default: {
      type_3 = (argile_type_t)ARGILE_TYPE_NOTHING;
    } break;
  };
  t = argile_match_get_type(p_argile_match_7);
  need_ref = 0;
  (argile_type_cast_chain((((int)type_3) & ~((1 << 31))), (((int)t) & ~((1 << 31))), ((int)(((((int)type_3) >> 31) & 1))), ((argile_type_info_t *)0), &chain));
  lc = chain;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    argile_type_caster_t * c = ((argile_type_caster_t *)0);

    c = *((argile_type_caster_t * *)&((argile_list_t *)lc)->data);
    if (((c)->code)) {
      argile_printf("%s(", ((c)->code)->anon);
      (paren)++;
    } //;
    else {
      if (((((((int)(c)->to) >> 31) & 1)) && !((((((int)type_3) >> 31) & 1))))) {
        argile_ref(1);
      } //;
      if (((((((int)type_3) >> 31) & 1)) && !((((((int)(c)->to) >> 31) & 1))))) {
        need_ref = 1;
      } //;
      argile_puts("(");
      argile_type_gen_prefix((c)->to);
      if (need_ref) {
        argile_ref(1);
      } //;
      argile_type_gen_suffix((c)->to);
      argile_puts(")");
    };
    type_3 = (c)->to;
  };
  argile_list_del(chain);
  switch ((p_argile_match_7)->type) {
    case ARGILE_MATCH_CONS: {
      if (need_ref) {
        argile_ref(-1);
      } //;
      argile_cons_gencode(((p_argile_match_7)->value).cons);
    } break;
    case ARGILE_MATCH_SUBCALL: {
      if ((need_ref && !((((((int)(((p_argile_match_7)->value).call)->context) >> 31) & 1))))) {
        argile_ref(-1);
      } //;
      argile_call_gencode(((p_argile_match_7)->value).call, 0);
    } break;
    default: {} break;
  };
  while (((paren)-- > 0)) {
    argile_puts(")");
  };
}

argile_match_t * argile_match_terminal(argile_match_t * p_argile_match_8)
/** :argile_match_terminal <match>: -> (argile) match **/
{
  if ((p_argile_match_8 == NULL)) {
    return ((argile_match_t *)0);
  } //;
  if (((p_argile_match_8)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * sub = ((argile_call_t *)0);
    argile_def_t * def = ((argile_def_t *)0);

    sub = ((p_argile_match_8)->value).call;
    def = (sub)->def;
    if ((def)) {
      argile_code_t * scope = ((argile_code_t *)0);

      scope = (def)->scope;
      if (((((def)->locall && ((def)->param)) && (((def)->param)->def)) && (((def)->param)->def != def))) {
        def = ((def)->param)->def;
        scope = (def)->scope;
      } //;
      if (((((def)->param) && ((def)->dtype == ARGILE_DEF_VAR)) && ((((def)->dval).var)->macro_params))) {
        argile_code_t * body = ((argile_code_t *)0);

        for (body = scope; (body); body = (body)->upper) {
          if ((((body)->macro_shovels) && ((def)->scope == body))) {
            argile_shovel_t * sh = ((argile_shovel_t *)0);
            argile_match_t * m = ((argile_match_t *)0);

            sh = *((argile_shovel_t * *)&((argile_list_t *)(body)->macro_shovels)->data);
            m = argile_shovel_digparamatch(sh, (def)->param);
            if ((m == p_argile_match_8)) {
              return ((argile_match_t *)0);
            } //;
            return argile_match_terminal(m);
          } //;
        };
      } //;
      else if (((def)->dtype == ARGILE_DEF_TYPE)) {
        return p_argile_match_8;
      } //;
      else if (((def)->dtype == ARGILE_DEF_BIND)) {
        return p_argile_match_8;
      } //;
    } //;
    else if ((((sub)->type == ARGILE_CALL_EXPLICIT) && ((sub)->match != NULL))) {
      argile_match_t * m = ((argile_match_t *)0);

      m = *((argile_match_t * *)&((argile_list_t *)(sub)->match)->data);
      if (((m) && ((m)->type == ARGILE_MATCH_CONS))) {
        return m;
      } //;
    } //;
  } //;
  return p_argile_match_8;
}

argile_type_t argile_match_eval_type(argile_match_t * p_argile_match_9)
/** :argile_match_eval_type <match>: -> argile type **/
{
  if ((p_argile_match_9)->evaled) {
    return (p_argile_match_9)->etype;
  } //;
  if (((p_argile_match_9)->type != ARGILE_MATCH_SUBCALL)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  return argile_call_eval_type(((p_argile_match_9)->value).call);
}

char * argile_match_eval_word(argile_match_t * p_argile_match_10)
/** :argile_match_eval_word <match>: -> text **/
{
  p_argile_match_10 = argile_match_terminal(p_argile_match_10);
  if (((p_argile_match_10) && ((p_argile_match_10)->type == ARGILE_MATCH_WORD))) {
    return ((p_argile_match_10)->value).word;
  } //;
  return (char *)0;
}

long argile_match_eval_long(argile_match_t * p_argile_match_11, int * error)
/** :argile_match_eval_long <match> <(int) & error>: -> long **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_11);
  if (!((&*error == NULL))) {
    *error = 1;
  } //;
  if ((c == NULL)) {
    return ((long)0);
  } //;
  if (!((&*error == NULL))) {
    *error = 0;
  } //;
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      return strtol(((c)->cvalue).hex, NULL, 16);
    } break;
    case ARGILE_CONS_DEC: {
      return strtol(((c)->cvalue).dec, NULL, 10);
    } break;
    case ARGILE_CONS_OCT: {
      return strtol(((c)->cvalue).oct, NULL, 8);
    } break;
    case ARGILE_CONS_BIN: {
      if ((*&(((c)->cvalue).bin)[0] == '-')) {
        return (-strtol(((((c)->cvalue).bin) + 3), NULL, 2));
      } //;
      return strtol(((((c)->cvalue).bin) + 2), NULL, 2);
    } break;
    default: {} break;
  };
  if (!((&*error == NULL))) {
    *error = 1;
  } //;
  return ((long)0);
}

static argile_cons_t * get_cons(argile_match_t * p_argile_match_12)
/** :get cons <match>: -> (argile) cons **/
{
  p_argile_match_12 = argile_match_terminal(p_argile_match_12);
  if (((p_argile_match_12) && ((p_argile_match_12)->type == ARGILE_MATCH_CONS))) {
    return ((p_argile_match_12)->value).cons;
  } //;
  return ((argile_cons_t *)0);
}

unsigned int argile_match_eval_nat(argile_match_t * p_argile_match_13, int * error_2)
/** :argile_match_eval_nat <match> <(int) & error>: -> nat **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_13);
  if (!((&*error_2 == NULL))) {
    *error_2 = 1;
  } //;
  if ((c == NULL)) {
    return 0;
  } //;
  if (!((&*error_2 == NULL))) {
    *error_2 = 0;
  } //;
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      return ((unsigned int)strtoul(((c)->cvalue).hex, NULL, 16));
    } break;
    case ARGILE_CONS_DEC: {
      return ((unsigned int)strtoul(((c)->cvalue).dec, NULL, 10));
    } break;
    case ARGILE_CONS_OCT: {
      return ((unsigned int)strtoul(((c)->cvalue).oct, NULL, 8));
    } break;
    case ARGILE_CONS_BIN: {
      if ((*&(((c)->cvalue).bin)[0] == '-')) {
        return ((unsigned int)strtoul(((((c)->cvalue).bin) + 3), NULL, 2));
      } //;
      return ((unsigned int)strtoul(((((c)->cvalue).bin) + 2), NULL, 2));
    } break;
    default: {} break;
  };
  if (!((&*error_2 == NULL))) {
    *error_2 = 1;
  } //;
  return 0;
}

double argile_match_eval_real(argile_match_t * p_argile_match_14, int * error_3)
/** :argile_match_eval_real <match> <(int) & error>: -> real **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_14);
  if (!((&*error_3 == NULL))) {
    *error_3 = 1;
  } //;
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_REAL))) {
    return 0.0;
  } //;
  if (!((&*error_3 == NULL))) {
    *error_3 = 0;
  } //;
  return ((double)strtod(((c)->cvalue).real, NULL));
}

argile_text_t * argile_match_eval_text(argile_match_t * p_argile_match_15)
/** :argile_match_eval_text <match>: -> argile text **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_15);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_TEXT))) {
    return ((argile_text_t *)0);
  } //;
  return ((c)->cvalue).text;
}

argile_list_t * argile_match_eval_syntax(argile_match_t * p_argile_match_16)
/** :argile_match_eval_syntax <match>: -> list of (argile syntax) **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_16);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_SYNTAX))) {
    return ((argile_list_t *)0);
  } //;
  return ((c)->cvalue).syntax;
}

argile_code_t * argile_match_eval_code(argile_match_t * p_argile_match_17)
/** :argile_match_eval_code <match>: -> argile code **/
{
  argile_cons_t * c = ((argile_cons_t *)0);

  c = get_cons(p_argile_match_17);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_CODE))) {
    return ((argile_code_t *)0);
  } //;
  return ((c)->cvalue).code;
}

int argile_match_is_const(argile_match_t * p_argile_match_18)
/** :argile_match_is_const <match>: -> int **/
{
  argile_def_t * d = ((argile_def_t *)0);

  if ((p_argile_match_18 == NULL)) {
    return 0;
  } //;
  if (((p_argile_match_18)->type != ARGILE_MATCH_SUBCALL)) {
    return 1;
  } //;
  d = (((p_argile_match_18)->value).call)->def;
  if ((d == NULL)) {
    return 1;
  } //;
  if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind)->is_const)) {
    return 1;
  } //;
  return 0;
}

unsigned char argile_match_find_autoparams(argile_match_t * p_argile_match_19)
/** :argile_match_find_autoparams <match>: -> bool **/
{
  unsigned char found;

  found = 0;
  switch ((p_argile_match_19)->type) {
    case ARGILE_MATCH_SUBCALL: {
      if (argile_call_find_autoparams(((p_argile_match_19)->value).call)) {
        found = 1;
      } //;
    } break;
    case ARGILE_MATCH_CONS: {
      if (argile_cons_find_autoparams(((p_argile_match_19)->value).cons)) {
        found = 1;
      } //;
    } break;
    default: {} break;
  };
  return found;
}

static int _check_recurse_eq(argile_match_t * ma_2, argile_match_t * mb_2)
/** :_check_recurse_eq <match ma> <match mb>: -> int **/
{
  if (((ma_2 == NULL) || (mb_2 == NULL))) {
    return 1;
  } //;
  if (((ma_2)->type != (mb_2)->type)) {
    return 1;
  } //;
  if (((ma_2)->type != ARGILE_MATCH_SUBCALL)) {
    return 1;
  } //;
  return argile_call_eq(((ma_2)->value).call, ((mb_2)->value).call);
}

static unsigned char _match_try_rec(argile_list_t * syntax_2, argile_list_t * match_2, int size_2, int * size_ret_2, unsigned char in_list_2)
/** :_match_try_rec <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <bool in_list>: -> bool **/
{
  int count = 0;

  if ((((argile).maxmatch > 0) && ((argile).maxmatch <= (argile).nummatch))) {
    return 0;
  } //;
  ((argile).nummatch)++;
  if (!((&*size_ret_2 == NULL))) {
    *size_ret_2 = 0;
  } //;
  while ((((match_2) && (syntax_2)) && (size_2 > 0))) {
    argile_match_t * m = ((argile_match_t *)0);
    argile_syntax_t * s = ((argile_syntax_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)match_2)->data);
    s = *((argile_syntax_t * *)&((argile_list_t *)syntax_2)->data);
    if ((m)) {
      switch ((s)->type) {
        case ARGILE_SYN_WORD: {
          if ((((m)->type != ARGILE_MATCH_WORD) || (strcmp(((m)->value).word, ((s)->value).syn_word) != 0))) {
            return 0;
          } //;
          (m)->matched = s;
          (size_2)--;
          (count)++;
        } break;
        case ARGILE_SYN_OP: {
          if ((((m)->type != ARGILE_MATCH_OP) || (strcmp(((m)->value).op, ((s)->value).syn_op) != 0))) {
            return 0;
          } //;
          (m)->matched = s;
          (size_2)--;
          (count)++;
        } break;
        case ARGILE_SYN_PARAM: {
          if (!((argile_match_type(m, (((s)->value).syn_param)->type)))) {
            return 0;
          } //;
          (m)->matched = s;
          (size_2)--;
          (count)++;
        } break;
        case ARGILE_SYN_OPTION: {
          argile_list_t * end;
          int eaten = 0;
          unsigned char try_2;

          end = argile_list_end(((s)->value).syn_option);
          argile_list_link(end, ((argile_list_t *)syntax_2)->next);
          try_2 = _match_try_rec(((s)->value).syn_option, match_2, size_2, &eaten, in_list_2);
          argile_list_unlink(end, ((argile_list_t *)syntax_2)->next);
          argile_list_link(syntax_2, ((argile_list_t *)syntax_2)->next);
          if (!(try_2)) {
            try_2 = _match_try_rec(((argile_list_t *)syntax_2)->next, match_2, size_2, &eaten, in_list_2);
          } //;
          if (!((&*size_ret_2 == NULL))) {
            *size_ret_2 = (count + eaten);
          } //;
          return try_2;
        } break;
        case ARGILE_SYN_ENUM: {
          unsigned char try_2;
          argile_list_t * cur;
          int eaten = 0;

          try_2 = 0;
          cur = ((s)->value).syn_enum;
          for (; (cur); cur = ((argile_list_t *)cur)->next) {
            argile_list_t * inner;
            argile_list_t * end;

            inner = *((argile_list_t * *)&((argile_list_t *)cur)->data);
            end = argile_list_end(inner);
            argile_list_link(end, ((argile_list_t *)syntax_2)->next);
            try_2 = _match_try_rec(inner, match_2, size_2, &eaten, in_list_2);
            argile_list_unlink(end, ((argile_list_t *)syntax_2)->next);
            if (try_2) {
              break;
            } //;
          };
          argile_list_link(syntax_2, ((argile_list_t *)syntax_2)->next);
          if (!((&*size_ret_2 == NULL))) {
            *size_ret_2 = (count + eaten);
          } //;
          return try_2;
        } break;
        case ARGILE_SYN_LIST: {
          int num = 0;
          int eaten = 0;
          int min = 0;
          int max = 0;
          unsigned char try_2;

          min = (((s)->value).syn_list)->min;
          max = (((s)->value).syn_list)->max;
          try_2 = 0;
          for (num = 0; ((max == 0) || (num < max)); (num)++) {
            try_2 = _match_try_rec((((s)->value).syn_list)->sub, match_2, size_2, &eaten, 1);
            if (((eaten == 0) || !(try_2))) {
              break;
            } //;
            match_2 = argile_list_seek(match_2, eaten);
            size_2 -= eaten;
            count += eaten;
          };
          if ((num < min)) {
            return 0;
          } //;
          try_2 = _match_try_rec(((argile_list_t *)syntax_2)->next, match_2, size_2, &eaten, in_list_2);
          if (!((&*size_ret_2 == NULL))) {
            *size_ret_2 = (count + eaten);
          } //;
          return try_2;
        } break;
        default: {} break;
      };
    } //;
    match_2 = ((argile_list_t *)match_2)->next;
    syntax_2 = ((argile_list_t *)syntax_2)->next;
  };
  if (((size_2 != 0) && !(in_list_2))) {
    return 0;
  } //;
  if (!((&*size_ret_2 == NULL))) {
    *size_ret_2 = count;
  } //;
  return (argile_syntax_is_terminal(syntax_2));
}

