// generated by: arc -xuNP -A ./../argrt -M -o std_vardef.c -H std_vardef.h -m std_vardef.argl.tmp std_vardef.arg 
#include "std_vardef.h"

static unsigned char _get_type(argile_shovel_t *, int, argile_type_t *, argile_type_t);
/** :_get_type <shovel sh> <int id> <(argile type) & type> <argile type deftype>: -> bool **/
static unsigned char _get_init(argile_shovel_t *, int, argile_type_t *, argile_match_t * *);
/** :_get_init <shovel sh> <int id> <(argile type) & type> <(match) & init>: -> bool **/
static int _single_reject(argile_shovel_t *, int, argile_call_t *, argile_type_t);
/** :_single_reject <shovel sh> <int id> <call> <argile type rtype>: -> int **/
static unsigned char is_a_block(argile_match_t *);
/** :<match m> is a block: -> bool **/

int argmod_vardef_defmaker = 1;
char( argmod_vardef_doc[]) = "Define a variable, giving a name (word) or syntax, an optional type, and\nan optional initial value. Some of these parameters can also be in a list\nto define several variables in a single call. It is possible to add a\nsecond set of parameters (when the first one is in a list).\nIf the binding option `return' is set, the last variable is returned.\nIf the binding option `private' is set, the variables are made private to\nthe file (static in C).\nSyntax requirements:\n  :{<word>|<syntax>} (<type>) (<any>):\n  :<type> <any> [ {<word>|<syntax>} ... 1, ]:\n  :<type> [ {<word>|<syntax>} (<any>) ... 1, ]:\n  :[ (<type>) {<word>|<syntax>} (<any>) ... 1, ]:\n  :[ (<type>) {<word>|<syntax>} (<any>) ... 1, ] {<word>|<syntax>} (<any>):\n";

static unsigned char _get_type(argile_shovel_t * sh, int id, argile_type_t * type, argile_type_t deftype)
/** :_get_type <shovel sh> <int id> <(argile type) & type> <argile type deftype>: -> bool **/
{
  argile_match_t * m = ((argile_match_t *)0);

  if (((m = argile_shovel_digmatch(sh, id, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0)))) {
    if ((&*type)) {
      *type = argile_match_eval_type(m);
    } //;
    return 1;
  } //;
  if (((deftype != ARGILE_TYPE_NOTHING) && (deftype != ARGILE_TYPE_ANYTHING))) {
    if ((&*type)) {
      *type = deftype;
    } //;
    return 1;
  } //;
  return 0;
}

static unsigned char _get_init(argile_shovel_t * sh_2, int id_2, argile_type_t * type_2, argile_match_t * * init)
/** :_get_init <shovel sh> <int id> <(argile type) & type> <(match) & init>: -> bool **/
{
  argile_match_t * m = ((argile_match_t *)0);

  if (((m = argile_shovel_digmatch(sh_2, id_2, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0)))) {
    if ((&*init)) {
      *init = m;
    } //;
    if (((m)->type == ARGILE_MATCH_CONS)) {
      if ((&*type_2)) {
        *type_2 = (((m)->value).cons)->type;
      } //;
      return 1;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      if ((&*type_2)) {
        *type_2 = argile_call_get_type(((m)->value).call);
      } //;
      return 1;
    } //;
  } //;
  else if ((&*init)) {
    *init = ((argile_match_t *)0);
  } //;
  return 0;
}

argile_type_t argmod_vardef_gettype(argile_call_t * p_argile_call)
/** :argmod_vardef_gettype <call>: -> argile type **/
{
  argile_type_t type_3;
  argile_shovel_t * sh_3 = ((argile_shovel_t *)0);

  if (!((argile_def_has_option((p_argile_call)->def, "return")))) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  sh_3 = argile_shovel_new(p_argile_call);
  if ((!(_get_type(sh_3, 1, &type_3, (p_argile_call)->context)) && !(_get_init(sh_3, 1, &type_3, ((argile_match_t * *)0))))) {
    type_3 = (argile_type_t)ARGILE_TYPE_ANYTHING;
  } //;
  argile_shovel_del(sh_3);
  if ((((type_3 != ARGILE_TYPE_NOTHING) && (type_3 != ARGILE_TYPE_TYPE)) && !((((((int)type_3) >> 30) & 1))))) {
    return (((int)(((int)type_3) & ((1 << 30) - 1))) | (1 << 31));
  } //;
  return type_3;
}

void argmod_vardef_compile(argile_call_t * p_argile_call_2)
/** :argmod_vardef_compile <call>: -> nothing **/
{
  argile_list_t * vars = ((argile_list_t *)0);
  unsigned char private;
  argile_type_t rtype;
  argile_shovel_t * sh_3 = ((argile_shovel_t *)0);
  int ID = 1;

  private = (argile_def_has_option((p_argile_call_2)->def, "private"));
  if ((argile_def_has_option((p_argile_call_2)->def, "return"))) {
    rtype = (((int)(p_argile_call_2)->context) & ~((1 << 31)));
  } //;
  else {
    rtype = (argile_type_t)ARGILE_TYPE_NOTHING;
  };
  sh_3 = argile_shovel_new(p_argile_call_2);
  do {
    argile_type_t type_3;
    unsigned char got_type;
    argile_type_t vtype;
    argile_match_t * init_2 = ((argile_match_t *)0);
    unsigned char got_vtype;
    argile_type_t dtype;
    argile_match_t * m = ((argile_match_t *)0);
    argile_def_t * def = ((argile_def_t *)0);

    got_type = _get_type(sh_3, 1, &type_3, rtype);
    got_vtype = _get_init(sh_3, ID, &vtype, &init_2);
    if (!(got_type)) {
      if (got_vtype) {
        type_3 = vtype;
      } //;
      else {
        type_3 = (argile_type_t)ARGILE_TYPE_ANYTHING;
      };
    } //;
    type_3 = (((int)type_3) & ~((1 << 31)));
    if ((((p_argile_call_2)->type == ARGILE_CALL_IMPLICIT) && ((init_2) && !((argile_match_type(init_2, type_3)))))) {
      argile_buff_t b = ((argile_buff_t){0});

      argile_typename(type_3, &b, (p_argile_call_2)->scope);
      argile_buff_putc(&b, '\0');
      argile_die_at(p_argile_call_2, "std/vardef: ""initializer type did not match type \"%s\"", (b).ptr);
      argile_dbg_free((b).ptr);
      argile_shovel_del(sh_3);
      return;
    } //;
    if ((init_2)) {
      argile_code_t * code = ((argile_code_t *)0);

      code = argile_match_eval_code(init_2);
      if ((code)) {
        if (!((((((int)type_3) >> 30) & 1)))) {
          argile_code_anon(code);
        } //;
      } //;
    } //;
    dtype = (((((((int)type_3) >> 30) & 1))) ? (type_3) : ((((int)(((int)type_3) & ((1 << 30) - 1))) | (1 << 31))));
    if ((m = argile_shovel_digmatch(sh_3, ID, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) {
      if ((type_3 == ARGILE_TYPE_TYPE)) {
        argile_type_t t;

        if ((init_2)) {
          t = argile_match_eval_type(init_2);
        } //;
        else {
          t = (argile_type_t)ARGILE_TYPE_ANYTHING;
        };
        def = argile_def_new(argile_match_eval_syntax(m), 0, type_3, p_argile_call_2, ARGILE_DEF_TYPE, ((void *)((long)t)));
      } //;
      else {
        def = argile_def_new(argile_match_eval_syntax(m), 0, dtype, p_argile_call_2, ARGILE_DEF_VAR, argile_var_new(type_3, init_2));
      };
      (def)->private = private;
      argile_code_def((p_argile_call_2)->scope, def, 1);
      argile_list_append(&vars, argile_list_new(def, ((argile_deleter_t)0)));
    } //;
    else if (((m = argile_shovel_digmatch(sh_3, ID, (argile_type_t)ARGILE_TYPE_WORD, (char *)0)) && ((m)->type == ARGILE_MATCH_WORD))) {
      char * word = "";
      argile_list_t * syn;

      word = argile_dbg_strdup(((m)->value).word);
      syn = argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, word), (void *)&argile_syntax_del);
      if ((type_3 == ARGILE_TYPE_TYPE)) {
        argile_type_t t;

        if ((init_2)) {
          t = argile_match_eval_type(init_2);
        } //;
        else {
          t = (argile_type_t)ARGILE_TYPE_ANYTHING;
        };
        def = argile_def_new(syn, 1, type_3, p_argile_call_2, ARGILE_DEF_TYPE, ((void *)((long)t)));
      } //;
      else {
        def = argile_def_new(syn, 1, dtype, p_argile_call_2, ARGILE_DEF_VAR, argile_var_new(type_3, init_2));
      };
      (def)->private = private;
      argile_code_def((p_argile_call_2)->scope, def, 1);
      argile_list_append(&vars, argile_list_new(def, ((argile_deleter_t)0)));
    } //;
    argile_shovel_shiftlist(sh_3, 1, 1);
    if ((ID == 1)) {
      if ((argile_shovel_diglist(sh_3, 1) == 0)) {
        ID = 2;
      } //;
    } //;
    else {
      break;
    };
  } while (1);
  argile_shovel_del(sh_3);
  (p_argile_call_2)->data = argile_list_start(vars);
  (p_argile_call_2)->del = (void *)&argile_list_del;
}

static int _single_reject(argile_shovel_t * sh_3, int id_3, argile_call_t * p_argile_call_3, argile_type_t rtype)
/** :_single_reject <shovel sh> <int id> <call> <argile type rtype>: -> int **/
{
  argile_type_t type_3;
  unsigned char got_type;
  argile_match_t * init_2 = ((argile_match_t *)0);
  unsigned char got_init;

  got_type = _get_type(sh_3, 1, &type_3, rtype);
  got_init = _get_init(sh_3, id_3, ((argile_type_t *)0), &init_2);
  if ((!(got_type) && !(got_init))) {
    return 0;
  } //;
  if (got_type) {
    if ((type_3 == ARGILE_TYPE_NOTHING)) {
      return argile_call_add_reject(p_argile_call_3, "std/vardef: ""cannot define a variable with type nothing");
    } //;
    if ((((((int)type_3) >> 31) & 1))) {
      return argile_call_add_reject(p_argile_call_3, "std/vardef: ""variable type cannot be a reference");
    } //;
    if (got_init) {
      if (((((((int)type_3) >> 30) & 1)) && is_a_block(init_2))) {
        return 0;
      } //;
      if ((argile_match_or_reject(p_argile_call_3, init_2, type_3, "std/vardef: ""initializer: "))) {
        return 1;
      } //;
    } //;
    return 0;
  } //;
  if (!(got_init)) {
    return argile_call_add_reject(p_argile_call_3, "std/vardef: ""no initializer (probably an internal bug)");
  } //;
  if (((init_2)->type == ARGILE_MATCH_CONS)) {
    if (((((init_2)->value).cons)->type != ARGILE_TYPE_NOTHING)) {
      return 0;
    } //;
    return argile_call_add_reject(p_argile_call_3, "std/vardef: ""initializer constant literal has type nothing (bug)");
  } //;
  if (((init_2)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * sub = ((argile_call_t *)0);
    argile_type_t ctype;

    sub = ((init_2)->value).call;
    ctype = argile_call_get_type(sub);
    if ((((((int)ctype) >> 30) & 1))) {
      (sub)->context = ctype;
    } //;
    if ((ctype != ARGILE_TYPE_NOTHING)) {
      return 0;
    } //;
    return argile_call_add_reject(p_argile_call_3, "std/vardef: ""initializer returns nothing");
  } //;
  return argile_call_add_reject(p_argile_call_3, "std/vardef: ""bad initializer");
}

int argmod_vardef_reject(argile_call_t * p_argile_call_4)
/** :argmod_vardef_reject <call>: -> int **/
{
  argile_type_t rtype_2;
  int reject = 0;
  argile_shovel_t * sh_4 = ((argile_shovel_t *)0);

  rtype_2 = (argile_type_t)ARGILE_TYPE_NOTHING;
  if ((argile_def_has_option((p_argile_call_4)->def, "return"))) {
    rtype_2 = (((int)(p_argile_call_4)->context) & ~((1 << 31)));
  } //;
  sh_4 = argile_shovel_new(p_argile_call_4);
  do {
    reject = _single_reject(sh_4, 1, p_argile_call_4, rtype_2);
    argile_shovel_shiftlist(sh_4, 1, 1);
  } while (((reject == 0) && (argile_shovel_diglist(sh_4, 1) != 0)));
  if ((reject == 0)) {
    reject = _single_reject(sh_4, 2, p_argile_call_4, rtype_2);
  } //;
  argile_shovel_del(sh_4);
  return reject;
}

void argmod_vardef_gencode(argile_call_t * p_argile_call_5)
/** :argmod_vardef_gencode <call>: -> nothing **/
{
  unsigned char need_sep;
  unsigned char ret;
  argile_list_t * ld;

  need_sep = 0;
  ret = (argile_def_has_option((p_argile_call_5)->def, "return"));
  for (ld = ((argile_list_t *)(p_argile_call_5)->data); (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);
    argile_match_t * m = ((argile_match_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if (((d)->dtype != ARGILE_DEF_VAR)) {
      continue;
    } //;
    m = (((d)->dval).var)->init;
    if (((NULL == m) || (argile_match_is_const(m)))) {
      if (!(ret)) {
        continue;
      } //;
      m = ((argile_match_t *)0);
    } //;
    if (need_sep) {
      argile_puts(";\n");
      argile_indent();
    } //;
    if (ret) {
      int ris = 0;
      int rin = 0;

      if ((((((int)(p_argile_call_5)->context) >> 31) & 1))) {
        (rin)--;
      } //;
      if ((((((int)(p_argile_call_5)->context) >> 30) & 1))) {
        (rin)++;
      } //;
      if ((((((int)(d)->type) >> 30) & 1))) {
        (ris)++;
      } //;
      argile_ref((rin - ris));
      if ((m != NULL)) {
        argile_puts("(");
      } //;
    } //;
    argile_puts(argile_def_gen_id(d));
    if ((m)) {
      argile_puts(" = ");
      argile_match_gencode(m);
      if (ret) {
        argile_puts(")");
      } //;
    } //;
    need_sep = 1;
  };
}

static unsigned char is_a_block(argile_match_t * m)
/** :<match m> is a block: -> bool **/
{
  argile_cons_t * cons = ((argile_cons_t *)0);

  if (((m)->type != ARGILE_MATCH_CONS)) {
    return 0;
  } //;
  cons = ((m)->value).cons;
  if (((cons)->ctype != ARGILE_CONS_CODE)) {
    return 0;
  } //;
  return 1;
}

