// generated by: arc -xuNP -A ./../argrt -M -o std_stresc.c -H std_stresc.h -m std_stresc.argl.tmp std_stresc.arg 
#include "std_stresc.h"

static int argile_buff_text_int(argile_buff_t *, char *, int);
/** :<buff out> <text buf> <int len>: -> int **/
static char _hex(int);
/** :_hex <int n>: -> byte **/

char( argmod_stresc_doc[]) = "Generate an escaped text string suitable for inclusion within a double\nquoted C string. Moreover, if the parameter evaluates to a word, it\nchanges non-ascii characters into hexadecimal sequence.\nSyntax requirements:\n  :<any>:\n";

void argmod_stresc_gencode(argile_call_t * p_argile_call)
/** :argmod_stresc_gencode <call>: -> nothing **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);
  argile_buff_t b = ((argile_buff_t){0});
  char * word = "";

  sh = argile_shovel_new(p_argile_call);
  m = argile_shovel_diganymatch(sh, 1, (char *)0);
  argile_shovel_del(sh);
  if ((m == NULL)) {
    return;
  } //;
  if (((argile).hexa_str && ((word = argile_match_eval_word(m))))) {
    unsigned char after_hex;
    char( hex[5]);
    int i = 0;
    char c;

    after_hex = 0;
    *&(hex)[0] = '\\';
    *&(hex)[1] = 'x';
    *&(hex)[4] = '\0';
    for (i = 0; (c = *&(word)[i]); (i)++) {
      if ((((c < ' ') || (c > '~')) || (after_hex && ((((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f'))) || ((c >= 'A') && (c <= 'F')))))) {
        *&(hex)[2] = _hex((c >> 4));
        *&(hex)[3] = _hex((c >> 0));
        argile_buff_puts(&b, ((char *)hex));
        after_hex = 1;
      } //;
      else {
        argile_buff_putc(&b, c);
        after_hex = 0;
      };
    };
    if (((b).ptr)) {
      argile_output((b).ptr, ((int)(b).len));
      argile_dbg_free((b).ptr);
    } //;
    return;
  } //;
  argile_push_output((void *)&argile_buff_text_int, &b);
  argile_match_gencode(m);
  argile_pop_output();
  if (((b).ptr)) {
    argile_output((b).ptr, ((int)(b).len));
    argile_dbg_free((b).ptr);
  } //;
}

static int argile_buff_text_int(argile_buff_t * out, char * buf, int len)
/** :<buff out> <text buf> <int len>: -> int **/
{
  int i = 0;

  while ((i < len)) {
    char c;

    switch ((c = *&(buf)[i])) {
      case '\n': {
        argile_buff_puts(out, "\\n");
      } break;
      case '\t': {
        argile_buff_puts(out, "\\t");
      } break;
      default: {
        if (((c == '\\') || (c == *&("\"")[0]))) {
          argile_buff_putc(out, '\\');
        } //;
        argile_buff_putc(out, c);
      } break;
    };
    (i)++;
  };
  return len;
}

static char _hex(int n)
/** :_hex <int n>: -> byte **/
{
  n &= 0xf;
  if ((n < 10)) {
    return (n + '0');
  } //;
  return (n + ('a' - 10));
}

