// generated by: arc -xuNP -A ./../argrt -M -o std_funcdef.c -H std_funcdef.h -m std_funcdef.argl.tmp std_funcdef.arg 
#include "std_funcdef.h"

static unsigned char has_var_type(argile_match_t *);
/** :<match m> has var type: -> bool **/
static void make_syntax(argile_list_t * *, argile_list_t *);
/** :make syntax <(list of (argile syntax)) & syntax> <list of (match) match>: -> nothing **/
static argile_list_t * make_params(argile_list_t *);
/** :make params <list of (argile syntax) syn>: -> list of (syn param) **/

char( argmod_funcdef_doc[]) = "Define a function, a macro or an anonymous function.\nNeeds a syntax, or a word (parameter-less function or macro).\nWhen the binding option `macro' is specified, it defines a macro instead\nof a function. When no word or syntax parameter is specified, an anonymous\nfunction is returned. If the binding option `private' is set, the definition\nis private to the module (not exported; equivalent to `static' in C).\nMay also return the function body code, when it's not a macro.\nSyntax requirements:\n  :( {<syntax>|<word>} ) (<type>) <code>:\n";
int argmod_funcdef_isconst = 1;
int argmod_funcdef_defmaker = 1;

argile_type_t argmod_funcdef_gettype(argile_call_t * p_argile_call)
/** :argmod_funcdef_gettype <call>: -> argile type **/
{
  argile_type_t t;
  argile_shovel_t * sh = ((argile_shovel_t *)0);

  t = (argile_type_t)ARGILE_TYPE_NOTHING;
  sh = argile_shovel_new(p_argile_call);
  if ((!((argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) && !((argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))))) {
    t = (argile_type_t)ARGILE_TYPE_CODE;
  } //;
  argile_shovel_del(sh);
  if ((((p_argile_call)->context != ARGILE_TYPE_NOTHING) && (((p_argile_call)->owner) && !((argile_def_has_option((p_argile_call)->def, "macro")))))) {
    if (((p_argile_call)->context == ARGILE_TYPE_CODE)) {
      return (argile_type_t)ARGILE_TYPE_CODE;
    } //;
    return (((int)(p_argile_call)->context) & ((1 << 30) - 1));
  } //;
  return t;
}

void argmod_funcdef_compile(argile_call_t * p_argile_call_2)
/** :argmod_funcdef_compile <call>: -> nothing **/
{
  argile_type_t type;
  unsigned char del_syn;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_list_t * syntax = ((argile_list_t *)0);
  argile_code_t * code = ((argile_code_t *)0);
  unsigned char got_type;
  unsigned char var_type;
  argile_match_t * m = ((argile_match_t *)0);
  unsigned char got_syn;

  del_syn = 0;
  sh = argile_shovel_new(p_argile_call_2);
  got_type = 0;
  var_type = 0;
  m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_TYPE, (char *)0);
  if ((m)) {
    type = argile_match_eval_type(m);
    got_type = 1;
    var_type = has_var_type(m);
  } //;
  else {
    type = (argile_type_t)ARGILE_TYPE_NOTHING;
  };
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0))) {
    code = argile_match_eval_code(m);
  } //;
  got_syn = 0;
  if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_SYNTAX, (char *)0))) {
    syntax = argile_match_eval_syntax(m);
    got_syn = 1;
  } //;
  else if ((m = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0))) {
    char * word = "";

    word = argile_match_eval_word(m);
    if ((word)) {
      word = argile_dbg_strdup(word);
      syntax = argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, word), (void *)&argile_syntax_del);
      del_syn = 1;
      got_syn = 1;
    } //;
  } //;
  if ((got_syn && (code))) {
    argile_def_t * d = ((argile_def_t *)0);
    argile_list_t * params;
    argile_list_t * lp;

    (p_argile_call_2)->data = code;
    (code)->type = type;
    if ((argile_def_has_option((p_argile_call_2)->def, "macro"))) {
      (code)->macro = 1;
    } //;
    d = argile_def_new(syntax, ((int)del_syn), type, p_argile_call_2, ARGILE_DEF_FUNC, code);
    (code)->func = d;
    (d)->vartype = var_type;
    (d)->private = (argile_def_has_option((p_argile_call_2)->def, "private"));
    if ((((p_argile_call_2)->context != ARGILE_TYPE_NOTHING) && (((p_argile_call_2)->owner) && !((code)->macro)))) {
      (d)->locall = 1;
    } //;
    argile_code_def((p_argile_call_2)->scope, d, 1);
    params = make_params(syntax);
    lp = params;
    for (; (lp); lp = ((argile_list_t *)lp)->next) {
      argile_syn_param_t * p = ((argile_syn_param_t *)0);

      p = *((argile_syn_param_t * *)&((argile_list_t *)lp)->data);
      syntax = ((argile_list_t *)0);
      if (((p)->name)) {
        char * word = "";

        word = argile_dbg_strdup((p)->name);
        syntax = argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, word), (void *)&argile_syntax_del);
      } //;
      else {
        make_syntax(&syntax, (p)->match);
        syntax = argile_list_start(syntax);
      };
      if ((syntax != NULL)) {
        argile_def_t * def = ((argile_def_t *)0);

        def = argile_def_new(syntax, 1, (((((((int)(p)->type) >> 30) & 1))) ? ((p)->type) : ((((int)(((int)(p)->type) & ((1 << 30) - 1))) | (1 << 31)))), ((argile_call_t *)0), ARGILE_DEF_VAR, argile_var_new((p)->type, ((argile_match_t *)0)));
        (def)->param = p;
        if ((((p)->def) && ((p)->def)->locall)) {
          argile_def_reuse_var((p)->def, ((def)->dval).var);
        } //;
        (p)->def = def;
        argile_code_def(code, def, 1);
      } //;
    };
    argile_list_del(params);
  } //;
  else if ((code)) {
    if (((code)->anon == NULL)) {
      argile_code_anon(code);
    } //;
    if (got_type) {
      (code)->type = type;
    } //;
    (p_argile_call_2)->data = code;
  } //;
  else if (((syntax) && del_syn)) {
    argile_list_del(syntax);
  } //;
  argile_shovel_del(sh);
}

static unsigned char has_var_type(argile_match_t * m)
/** :<match m> has var type: -> bool **/
{
  if ((m == NULL)) {
    return 0;
  } //;
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * sub = ((argile_call_t *)0);
    argile_list_t * lm;

    sub = ((m)->value).call;
    if ((((sub)->def) && (((sub)->def)->locall || ((sub)->def)->vartype))) {
      return 1;
    } //;
    for (lm = (sub)->match; (lm); lm = ((argile_list_t *)lm)->next) {
      if (has_var_type(((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything)))) {
        return 1;
      } //;
    };
  } //;
  return 0;
}

static void make_syntax(argile_list_t * * syntax, argile_list_t * match)
/** :make syntax <(list of (argile syntax)) & syntax> <list of (match) match>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m_2 == NULL)) {
      continue;
    } //;
    switch ((m_2)->type) {
      case ARGILE_MATCH_WORD: {
        char * str = "";
        argile_syntax_t * syn = ((argile_syntax_t *)0);

        str = argile_dbg_strdup(((m_2)->value).word);
        syn = argile_syntax_new(ARGILE_SYN_WORD, str);
        argile_list_append(syntax, argile_list_new(syn, (void *)&argile_syntax_del));
      } break;
      case ARGILE_MATCH_OP: {
        char * str = "";
        argile_syntax_t * syn = ((argile_syntax_t *)0);

        str = argile_dbg_strdup(((m_2)->value).op);
        syn = argile_syntax_new(ARGILE_SYN_OP, str);
        argile_list_append(syntax, argile_list_new(syn, (void *)&argile_syntax_del));
      } break;
      case ARGILE_MATCH_SUBCALL: {
        make_syntax(syntax, (((m_2)->value).call)->match);
      } break;
      default: {} break;
    };
  };
}

static argile_list_t * make_params(argile_list_t * syn)
/** :make params <list of (argile syntax) syn>: -> list of (syn param) **/
{
  argile_list_t * params = ((argile_list_t *)0);

  for (; (syn); syn = ((argile_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syn)->data);
    switch ((s)->type) {
      case ARGILE_SYN_PARAM: {
        argile_list_append(&params, argile_list_new(((s)->value).syn_param, ((argile_deleter_t)0)));
      } break;
      case ARGILE_SYN_OPTION: {
        argile_list_append(&params, make_params(((s)->value).syn_option));
        params = argile_list_end(params);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * enm;

        enm = ((s)->value).syn_enum;
        for (; (enm); enm = ((argile_list_t *)enm)->next) {
          argile_list_append(&params, make_params(*((argile_list_t * *)&((argile_list_t *)enm)->data)));
          params = argile_list_end(params);
        };
      } break;
      case ARGILE_SYN_LIST: {
        argile_list_append(&params, make_params((((s)->value).syn_list)->sub));
        params = argile_list_end(params);
      } break;
      default: {} break;
    };
  };
  return argile_list_start(params);
}

int argmod_funcdef_reject(argile_call_t * p_argile_call_3)
/** :argmod_funcdef_reject <call>: -> int **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * mword = ((argile_match_t *)0);
  argile_match_t * mcode = ((argile_match_t *)0);

  sh = argile_shovel_new(p_argile_call_3);
  mword = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  mcode = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_CODE, (char *)0);
  argile_shovel_del(sh);
  if (((mword) && !((argile_match_eval_word(mword))))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""word parameter is not constant");
  } //;
  if (!((mcode))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""no body code parameter");
  } //;
  if (!((argile_match_eval_code(mcode)))) {
    return argile_call_add_reject(p_argile_call_3, "std/funcdef: ""body code parameter is not constant");
  } //;
  return 0;
}

void argmod_funcdef_gencode(argile_call_t * p_argile_call_4)
/** :argmod_funcdef_gencode <call>: -> nothing **/
{
  argile_code_t * code = ((argile_code_t *)0);

  code = ((argile_code_t *)(p_argile_call_4)->data);
  if (((p_argile_call_4)->owner == NULL)) {
    return;
  } //;
  if ((code)) {
    if (((code)->anon)) {
      argile_puts("&");
      argile_puts((code)->anon);
    } //;
    else if ((((p_argile_call_4)->context != ARGILE_TYPE_NOTHING) && !((code)->macro))) {
      argile_def_t * def = ((argile_def_t *)0);

      def = argile_util_getfuncdef(code);
      if (((p_argile_call_4)->context == ARGILE_TYPE_CODE)) {
        argile_puts("(void *(*)(void *, ...))");
      } //;
      else {
        argile_puts("(void *)");
      };
      argile_puts("&");
      argile_puts((((def)) ? (argile_def_gen_id(def)) : ("0")));
    } //;
  } //;
}

