// generated by: arc -xuNP -A ./../argrt -M -o std_field.c -H std_field.h -m std_field.argl.tmp std_field.arg 
#include "std_field.h"

static argile_field_t * get_field(argile_type_t, char *, field_error_t *, argile_type_t *);
/** :get field <argile type in_type> <text name> <(field_error) & error> <(argile type) & type>: -> (argile) field **/

char( argmod_field_doc[]) = {"Call a field of a class or union. It needs a word parameter (field name)\nand a parameter of type `anything' (the union or class instance).\nSyntax requirements:\n  :<any> <word>:\n"};

static argile_field_t * get_field(argile_type_t in_type, char * name, field_error_t * error, argile_type_t * type)
/** :get field <argile type in_type> <text name> <(field_error) & error> <(argile type) & type>: -> (argile) field **/
{
  argile_type_info_t * i = ((argile_type_info_t *)0);

  in_type = (((int)in_type) & ~((1 << 31)));
  i = argile_type_get_info(in_type);
  *error = NOT_CLASS;
  *type = (argile_type_t)ARGILE_TYPE_NOTHING;
  if (((i) && !((i)->rec))) {
    argile_list_t * lf = ((argile_list_t *)0);
    argile_list_t * lc;

    if (((i)->ttype == ARGILE_TYPE_KIND_CLASS)) {
      lf = (((i)->tval).t_class).fields;
    } //;
    else if (((i)->ttype == ARGILE_TYPE_KIND_UNION)) {
      lf = (((i)->tval).t_union).variants;
    } //;
    if ((lf)) {
      for (; (lf); lf = ((argile_list_t *)lf)->next) {
        argile_field_t * f = ((argile_field_t *)0);

        f = *((argile_field_t * *)&((argile_list_t *)lf)->data);
        if (((f)->name == NULL)) {
          *error = INCOMPLETE;
          return ((argile_field_t *)0);
        } //;
        if ((strcmp((f)->name, name) == 0)) {
          *error = NONE;
          *type = in_type;
          return f;
        } //;
      };
      *error = NOT_FOUND;
    } //;
    lc = (i)->casters;
    for (; (lc); lc = ((argile_list_t *)lc)->next) {
      argile_field_t * f = ((argile_field_t *)0);

      (i)->rec = 1;
      f = get_field((*((argile_type_caster_t * *)&((argile_list_t *)lc)->data))->to, name, error, type);
      (i)->rec = 0;
      if (((*error == NONE) || (*error == INCOMPLETE))) {
        return f;
      } //;
    };
  } //;
  return ((argile_field_t *)0);
}

void argmod_field_compile(argile_call_t * p_argile_call)
/** :argmod_field_compile <call>: -> nothing **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
  char * word = "";

  sh = argile_shovel_new(p_argile_call);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if (((((a) && (w)) && ((a)->type == ARGILE_MATCH_SUBCALL)) && ((word = argile_match_eval_word(w))))) {
    argile_call_t * sub = ((argile_call_t *)0);
    field_error_t err;
    argile_type_t type_2;

    sub = ((a)->value).call;
    (p_argile_call)->data = get_field(argile_call_get_type(sub), word, &err, &type_2);
    if (((p_argile_call)->data == NULL)) {
      argile_die_at(p_argile_call, "std/field: ""%s: no such field", word);
    } //;
  } //;
  else {
    argile_die_at(p_argile_call, "std/field: ""missing subcall or word");
  };
}

argile_type_t argmod_field_gettype(argile_call_t * p_argile_call_2)
/** :argmod_field_gettype <call>: -> argile type **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
  char * word = "";

  sh = argile_shovel_new(p_argile_call_2);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if (((((a) && (w)) && ((a)->type == ARGILE_MATCH_SUBCALL)) && ((word = argile_match_eval_word(w))))) {
    field_error_t err;
    argile_type_t type_2;
    argile_field_t * f = ((argile_field_t *)0);

    f = get_field(argile_call_get_type(((a)->value).call), word, &err, &type_2);
    if ((f)) {
      if (((((((int)(p_argile_call_2)->context) >> 31) & 1)) && !((((((int)(f)->type) >> 30) & 1))))) {
        return (((int)(((int)(f)->type) & ((1 << 30) - 1))) | (1 << 31));
      } //;
      return (f)->type;
    } //;
  } //;
  return ARGILE_TYPE_NOTHING;
}

int argmod_field_reject(argile_call_t * p_argile_call_3)
/** :argmod_field_reject <call>: -> int **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_match_t * w = ((argile_match_t *)0);
  field_error_t error_2;
  argile_type_t type_2;
  argile_field_t * f = ((argile_field_t *)0);

  sh = argile_shovel_new(p_argile_call_3);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  w = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_WORD, (char *)0);
  argile_shovel_del(sh);
  if ((a == NULL)) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""missing class or union parameter");
  } //;
  if (((a)->type != ARGILE_MATCH_SUBCALL)) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""class or union parameter is not a subcall");
  } //;
  if ((w == NULL)) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""missing word parameter");
  } //;
  if ((argile_match_eval_word(w) == NULL)) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""word parameter is not a word");
  } //;
  f = get_field(argile_call_get_type(((a)->value).call), ((w)->value).word, &error_2, &type_2);
  if ((f == NULL)) {
    switch (error_2) {
      case INCOMPLETE: {
        return argile_call_add_reject(p_argile_call_3, "std/field: ""incomplete class or union at this moment");
      } break;
      case NOT_CLASS: {
        return argile_call_add_reject(p_argile_call_3, "std/field: ""not a class or union");
      } break;
      case NOT_FOUND: ;
      default: {
        return argile_call_add_reject(p_argile_call_3, "std/field: ""cannot find this field in this class or union");
      } break;
    };
  } //;
  if (((((((int)(f)->type) >> 30) & 1)) && (((((int)(p_argile_call_3)->context) >> 31) & 1)))) {
    return argile_call_add_reject(p_argile_call_3, "std/field: ""field by value in a reference context");
  } //;
  return 0;
}

void argmod_field_gencode(argile_call_t * p_argile_call_4)
/** :argmod_field_gencode <call>: -> nothing **/
{
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * a = ((argile_match_t *)0);
  argile_field_t * f = ((argile_field_t *)0);
  argile_type_info_t * i = ((argile_type_info_t *)0);

  sh = argile_shovel_new(p_argile_call_4);
  a = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  argile_shovel_del(sh);
  if (((p_argile_call_4)->data == NULL)) {
    argmod_field_compile(p_argile_call_4);
  } //;
  f = ((argile_field_t *)(p_argile_call_4)->data);
  if ((f == NULL)) {
    return;
  } //;
  if (((a)->type != ARGILE_MATCH_SUBCALL)) {
    return;
  } //;
  argile_gen_ref((p_argile_call_4)->context, (f)->type);
  (((a)->value).call)->context = (f)->in_type;
  i = argile_type_get_info((f)->in_type);
  if (((i) && ((i)->ttype == ARGILE_TYPE_KIND_UNION))) {
    argile_puts("(");
    argile_match_gencode(a);
    argile_puts(").");
  } //;
  else {
    argile_type_t t;
    unsigned char raw;

    t = argile_match_get_type(a);
    raw = (((((int)t) >> 30) & 1));
    argile_puts("(");
    if (raw) {
      argile_ref(1);
    } //;
    argile_match_gencode(a);
    if (raw) {
      argile_puts(").");
    } //;
    else {
      argile_puts(")->");
    };
  };
  argile_puts(argile_field_gen_id(f, "u_", p_argile_call_4));
}

