// generated by: arc -xuNP -A ./../argrt -M -o std_dig.c -H std_dig.h -m std_dig.argl.tmp std_dig.arg 
#include "std_dig.h"

static argile_list_t * get_param_matches(argile_call_t *);
/** :get param matches <call>: -> list of (match) **/
static void put_syn_id(argile_list_t *, argile_syn_type_t, int *, unsigned char);
/** :put syn id <list of (argile syntax) ls> <syn type st> <(int) & id> <bool in_list>: -> nothing **/
static void unquote(argile_match_t *);
/** :unquote <match m>: -> nothing **/

char( argmod_dig_doc[]) = {"Dig call path informations according to the syntax of the function or macro\ninside which this must be called (eg. Is third option set ? Which case of\nsecond enumeration is used ? ...); exactly one bind option must be specified\namongst `option', `enum' and `list'. It takes a natural(> 0) parameter and\noptionally, inside macros, other parameters depending on which bind option\nis set:\nWith `option', if a parameter of type anything is present, its code is\ngenerated when the call option is set, otherwise the code of the second\nparameter of type anything (if present) is generated; without these\nadditional parameters, a 0 or 1 (int) is returned.\nWith `enum', the number (int) of the case is returned, except when a list of\nparameters of type anything is present, in which case the code of the\nparameter corresponding to the case is generated.\nWith `list', the length of list is returned, except when a list of\nparameters of type anything are used, in which case for each occurence in\ncall path, generate code of each parameters specified, eventually separating\nthem with a `sep' parameter.\nSyntax requirements:\n  :<nat>:\t\t\t  with option, enum or list\n  :<nat> <any> (<any>):\t\t  with option\n  :<nat> [<any>...2,]:\t\t  with enum\n  :<nat> [<any>...1,](<any sep>): with list\n"};

argile_type_t argmod_dig_gettype(argile_call_t * p_argile_call)
/** :argmod_dig_gettype <call>: -> argile type **/
{
  if ((get_param_matches(p_argile_call))) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
  return ARGILE_TYPE_INTEGER;
}

int argmod_dig_reject(argile_call_t * p_argile_call_2)
/** :argmod_dig_reject <call>: -> int **/
{
  argile_code_t * b = ((argile_code_t *)0);

  if (((b = argile_util_getfuncbody((p_argile_call_2)->scope)) == NULL)) {
    return argile_call_add_reject(p_argile_call_2, "std/dig: ""not called within a function");
  } //;
  if (((b)->anon)) {
    if ((b)->caster) {
      return argile_call_add_reject(p_argile_call_2, "std/dig: ""autocast functions cannot have syntax");
    } //;
    else {
      return argile_call_add_reject(p_argile_call_2, "std/dig: ""anonymous functions cannot have syntax");
    };
  } //;
  return 0;
}

void argmod_dig_compile(argile_call_t * p_argile_call_3)
/** :argmod_dig_compile <call>: -> nothing **/
{
  argile_code_t * body = ((argile_code_t *)0);
  int nopt = 0;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  int er = 0;
  int id = 0;
  argile_def_t * def = ((argile_def_t *)0);

  body = argile_util_getfuncbody((p_argile_call_3)->scope);
  if ((argile_def_has_option((p_argile_call_3)->def, "option"))) {
    (nopt)++;
  } //;
  if ((argile_def_has_option((p_argile_call_3)->def, "enum"))) {
    (nopt)++;
  } //;
  if ((argile_def_has_option((p_argile_call_3)->def, "list"))) {
    (nopt)++;
  } //;
  if ((nopt != 1)) {
    argile_call_t * maker = ((argile_call_t *)0);

    maker = ((p_argile_call_3)->def)->maker;
    if ((maker == NULL)) {
      maker = p_argile_call_3;
    } //;
    argile_die_at(maker, "std/dig: ""need exactly one bind option (option,enum,list)");
    return;
  } //;
  if ((body)) {
    (body)->variadic = 1;
    if ((body)->cvariadic) {
      argile_die_at(p_argile_call_3, "std/dig: ""inside a C-variadic function");
      return;
    } //;
  } //;
  sh = argile_shovel_new(p_argile_call_3);
  id = ((int)argile_match_eval_long(argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_NATURAL, (char *)0), &er));
  argile_shovel_del(sh);
  if ((er != 0)) {
    argile_die_at(p_argile_call_3, "std/dig: ""not a constant natural");
    return;
  } //;
  def = argile_util_getfuncdef(body);
  if ((argile_def_has_option((p_argile_call_3)->def, "option"))) {
    std_count_syntax((def)->syntax, ((int *)0), &er, ((int *)0), ((int *)0));
  } //;
  else if ((argile_def_has_option((p_argile_call_3)->def, "enum"))) {
    std_count_syntax((def)->syntax, ((int *)0), ((int *)0), &er, ((int *)0));
  } //;
  else if ((argile_def_has_option((p_argile_call_3)->def, "list"))) {
    std_count_syntax((def)->syntax, ((int *)0), ((int *)0), ((int *)0), &er);
  } //;
  if (((id < 0) || (id > er))) {
    argile_die_at(p_argile_call_3, "std/dig: ""%d is invalid, must be in range 1-%d", id, er);
    return;
  } //;
  (p_argile_call_3)->data = def;
}

void argmod_dig_gencode(argile_call_t * p_argile_call_4)
/** :argmod_dig_gencode <call>: -> nothing **/
{
  argile_code_t * body = ((argile_code_t *)0);
  unsigned char dig_option;
  unsigned char dig_enum;
  unsigned char dig_list;
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * mid = ((argile_match_t *)0);
  argile_match_t * msep = ((argile_match_t *)0);
  argile_match_t * mprm = ((argile_match_t *)0);
  argile_match_t * melse = ((argile_match_t *)0);
  argile_list_t * matches;

  body = argile_util_getfuncbody((p_argile_call_4)->scope);
  if (((body == NULL) || ((body)->anon))) {
    return;
  } //;
  dig_option = (argile_def_has_option((p_argile_call_4)->def, "option"));
  dig_enum = (argile_def_has_option((p_argile_call_4)->def, "enum"));
  dig_list = (argile_def_has_option((p_argile_call_4)->def, "list"));
  sh = argile_shovel_new(p_argile_call_4);
  mid = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_NATURAL, (char *)0);
  if (dig_option) {
    melse = argile_shovel_digmatch(sh, 2, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  } //;
  if ((dig_option || dig_enum)) {
    mprm = argile_shovel_digmatch(sh, 1, (argile_type_t)ARGILE_TYPE_ANYTHING, (char *)0);
  } //;
  if (dig_list) {
    msep = argile_shovel_diganymatch(sh, 1, "sep");
  } //;
  argile_shovel_del(sh);
  matches = get_param_matches(p_argile_call_4);
  if (((body)->macro)) {
    int id = 0;
    int val = 0;

    if (((body)->macro_calls)) {
      int error = 0;

      id = ((int)argile_match_eval_long(mid, &error));
      if ((error == 0)) {
        sh = *((argile_shovel_t * *)&((argile_list_t *)(body)->macro_shovels)->data);
        if (dig_option) {
          val = argile_shovel_digoption(sh, id);
        } //;
        else if (dig_enum) {
          val = argile_shovel_digenum(sh, id);
        } //;
        else if (dig_list) {
          val = argile_shovel_diglist(sh, id);
        } //;
        if ((matches == NULL)) {
          argile_putn(val);
        } //;
        else if (dig_option) {
          if (((val != 0) && (mprm))) {
            argile_match_gencode(mprm);
          } //;
          if (((val == 0) && (melse))) {
            argile_match_gencode(melse);
          } //;
        } //;
        else if (dig_enum) {
          argile_list_t * lm;

          lm = matches;
          while (((lm) && (val != 0))) {
            if (((val == 1) && (*((argile_match_t * *)&((argile_list_t *)lm)->data)))) {
              argile_match_gencode(*((argile_match_t * *)&((argile_list_t *)lm)->data));
            } //;
            (val)--;
            lm = ((argile_list_t *)lm)->next;
          };
        } //;
        else if (dig_list) {
          unsigned char need_sep;

          need_sep = 0;
          while ((argile_shovel_diglist(sh, id) > 0)) {
            argile_list_t * lm;

            lm = matches;
            for (; (lm); lm = ((argile_list_t *)lm)->next) {
              if (need_sep) {
                if (!((msep == NULL))) {
                  unquote(msep);
                } //;
              } //;
              if ((*((argile_match_t * *)&((argile_list_t *)lm)->data))) {
                argile_match_gencode(*((argile_match_t * *)&((argile_list_t *)lm)->data));
              } //;
              need_sep = 1;
            };
            argile_shovel_shiftlist(sh, id, 1);
          };
          *((argile_shovel_t * *)&((argile_list_t *)(body)->macro_shovels)->data) = argile_shovel_new(*((argile_call_t * *)&((argile_list_t *)(body)->macro_calls)->data));
          argile_shovel_del(sh);
        } //;
      } //;
    } //;
  } //;
  else if ((matches == NULL)) {
    int id = 0;
    argile_def_t * def = ((argile_def_t *)0);

    def = ((argile_def_t *)(p_argile_call_4)->data);
    if ((def == NULL)) {
      def = argile_util_getfuncdef(body);
    } //;
    id = ((int)argile_match_eval_long(mid, ((int *)0)));
    if ((id < 1)) {
      id = 1;
    } //;
    if (dig_option) {
      put_syn_id((def)->syntax, ARGILE_SYN_OPTION, &id, 0);
    } //;
    if (dig_enum) {
      put_syn_id((def)->syntax, ARGILE_SYN_ENUM, &id, 0);
    } //;
    if (dig_list) {
      put_syn_id((def)->syntax, ARGILE_SYN_LIST, &id, 0);
    } //;
  } //;
}

static argile_list_t * get_param_matches(argile_call_t * p_argile_call_5)
/** :get param matches <call>: -> list of (match) **/
{
  unsigned char dig_list;
  argile_list_t * lm;

  dig_list = (argile_def_has_option((p_argile_call_5)->def, "list"));
  lm = (p_argile_call_5)->params;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_call_param_t * cp = ((argile_call_param_t *)0);

    cp = *((argile_call_param_t * *)&((argile_list_t *)lm)->data);
    if (((((int)((cp)->syn_param)->type) & ~((1 << 31))) == ARGILE_TYPE_ANYTHING)) {
      if (((!(dig_list) || (((cp)->syn_param)->name == NULL)) || (strcmp(((cp)->syn_param)->name, "sep") != 0))) {
        return (cp)->matches;
      } //;
    } //;
  };
  return ((argile_list_t *)0);
}

static void put_syn_id(argile_list_t * ls, argile_syn_type_t st, int * id, unsigned char in_list)
/** :put syn id <list of (argile syntax) ls> <syn type st> <(int) & id> <bool in_list>: -> nothing **/
{
  for (; (ls); ls = ((argile_list_t *)ls)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)ls)->data);
    if ((((s)->type == st) && (--(*id) == 0))) {
      if (((s)->genid)) {
        if (in_list) {
          argile_ref(1);
        } //;
        argile_puts((s)->genid);
      } //;
      return;
    } //;
    switch ((s)->type) {
      case ARGILE_SYN_OPTION: {
        put_syn_id(((s)->value).syn_option, st, id, in_list);
      } break;
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

        le = ((s)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          put_syn_id(*((argile_list_t * *)&((argile_list_t *)le)->data), st, id, in_list);
        };
      } break;
      case ARGILE_SYN_LIST: {
        put_syn_id((((s)->value).syn_list)->sub, st, id, 1);
      } break;
      default: {} break;
    };
  };
}

static void unquote(argile_match_t * m)
/** :unquote <match m>: -> nothing **/
{
  argile_text_t * t = ((argile_text_t *)0);

  t = argile_match_eval_text(m);
  if ((t)) {
    argile_output((t)->str, (t)->len);
  } //;
  else {
    argile_match_gencode(m);
  };
}

