// generated by: arc -xuNP -A ./../argrt -M -o code.c -H code.h -m code.argl.tmp code.arg 
#include "code.h"

static char * gen_param_id_of_from(argile_def_t *, argile_call_t *);
/** :gen param id of <def> from <call>: -> text **/
static int gen_protofuncs(argile_code_t *, unsigned char, unsigned char);
/** :gen protofuncs <argile code code> <bool statics> <bool bodies>: -> int **/
static int gen_protofuncs_2(argile_call_t *, unsigned char, unsigned char);
/** :gen protofuncs <argile call call> <bool statics> <bool bodies>: -> int **/
static unsigned char has_data_block(argile_var_t *);
/** :<var> has data block: -> bool **/
static int _cumulated_numcomp(argile_call_t *);
/** :_cumulated_numcomp <call>: -> int **/
static int _f_all(argile_def_t *);
/** :_f_all <def>: -> int **/
static int _f_defmakers(argile_def_t *);
/** :_f_defmakers <def>: -> int **/
static void _percent(int * last, int, int);
/** :_percent <int n> <int max>: -> nothing **/
static void pregen_includes_rec(argile_code_t *);
/** :pregen includes rec <argile code up>: -> nothing **/
static void pregen(argile_code_t *, unsigned char);
/** :pregen <argile code code> <bool in_macro>: -> nothing **/
static void pregen_2(argile_call_t *, unsigned char);
/** :pregen <call> <bool in_macro>: -> nothing **/
static int gen_typedefs(argile_code_t *, unsigned char, unsigned char);
/** :gen typedefs <argile code code> <bool privates> <bool global>: -> int **/
static int gen_typedefs_2(argile_call_t *);
/** :gen typedefs <argile call call>: -> int **/
static void gen_enums(argile_code_t *, unsigned char, unsigned char);
/** :gen enums <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_enums_2(argile_call_t *);
/** :gen enums <call>: -> nothing **/
static void gen_structs_and_unions(argile_code_t *, unsigned char, unsigned char);
/** :gen structs and unions <argile code code> <bool privates> <bool global>: -> nothing **/
static void gen_structs_and_unions_2(argile_call_t *);
/** :gen structs and unions <call>: -> nothing **/
static void gen_structs_and_unions_3(argile_code_t *, argile_def_t *, argile_type_info_t *);
/** :gen structs and unions <argile code code> <def d> <type info ti>: -> nothing **/
static unsigned char has_pseudo_param(argile_list_t *);
/** :<list of (argile syntax) syn> has pseudo param: -> bool **/
static unsigned char has_optenulis(argile_list_t *);
/** :<list of (argile syntax) syn> has optenulis: -> bool **/
static void gen_syntax_comment(argile_def_t *, argile_call_t *);
/** :gen syntax comment <def d> <call c>: -> nothing **/
static void private_vars(argile_call_t *);
/** :private vars <call>: -> nothing **/

static argile_filter_t( _filters[]) = {(void *)&_f_defmakers, (void *)&_f_all, NULL};
static char *( _filters_desc[]) = {"definitions making new definitions only", "all definitions", NULL};

argile_code_t * argile_code_new(argile_code_t * upper, argile_list_t * calls)
/** :argile_code_new <argile code upper> <list of (call) calls>: -> argile code **/
{
  argile_code_t * code = ((argile_code_t *)0);

  code = ((argile_code_t *)memset(argile_dbg_malloc(sizeof(argile_code_t)), 0, sizeof(argile_code_t)));
  (code)->calls = calls;
  (code)->upper = upper;
  (code)->type = (argile_type_t)ARGILE_TYPE_NOTHING;
  if (((argile).input_name)) {
    (code)->input = argile_dbg_strdup((argile).input_name);
  } //;
  for (; (calls); calls = ((argile_list_t *)calls)->next) {
    argile_call_setup(*((argile_call_t * *)&((argile_list_t *)calls)->data), code, ((argile_call_t *)0));
  };
  (code)->maxmatch = ((short)-1);
  return code;
}

void argile_code_del(argile_code_t * code)
/** :argile_code_del <argile code code>: -> nothing **/
{
  argile_code_t * up = ((argile_code_t *)0);

  if (((code)->input)) {
    argile_dbg_free((code)->input);
  } //;
  if (((code)->anon)) {
    argile_dbg_free((code)->anon);
  } //;
  argile_list_del((code)->special_ids);
  argile_list_del((code)->autoparams);
  argile_list_del((code)->gtypes);
  argile_list_del((code)->macro_shovels);
  argile_list_del((code)->macro_calls);
  argile_list_del((code)->calls);
  argile_list_del((code)->defs);
  up = (code)->upper;
  while (!(((up == NULL) || ((up)->ghost == NULL)))) {
    argile_code_t * upper_2 = ((argile_code_t *)0);

    upper_2 = (up)->upper;
    if (((up)->input)) {
      argile_dbg_free((up)->input);
    } //;
    argile_dbg_free(up);
    up = upper_2;
  };
  argile_dbg_free(code);
}

void argile_code_append(argile_code_t * * code_2, argile_call_t * owner, argile_list_t * calls_2)
/** :argile_code_append <(argile code) & code> <call owner> <list of (call) calls>: -> nothing **/
{
  if ((*code_2)) {
    if (((*code_2)->calls)) {
      argile_list_link(argile_list_end((*code_2)->calls), calls_2);
    } else {
      (*code_2)->calls = calls_2;
    };
    for (; (calls_2); calls_2 = ((argile_list_t *)calls_2)->next) {
      argile_call_setup(*((argile_call_t * *)&((argile_list_t *)calls_2)->data), *code_2, ((argile_call_t *)0));
    };
    if ((((*code_2)->input == NULL) && ((argile).input_name != NULL))) {
      (*code_2)->input = argile_dbg_strdup((argile).input_name);
    } //;
  } else {
    *code_2 = argile_code_new((((owner)) ? ((owner)->scope) : (NULL)), calls_2);
    (*code_2)->owner = owner;
  };
}

void argile_code_string(argile_code_t * code_3, int indent, argile_buff_t * buf)
/** :argile_code_string <argile code code> <int indent> <buff buf>: -> nothing **/
{
  argile_list_t * lcall;

  lcall = (code_3)->calls;
  for (; (lcall); lcall = ((argile_list_t *)lcall)->next) {
    argile_call_t * call = ((argile_call_t *)0);
    int i = 0;

    call = *((argile_call_t * *)&((argile_list_t *)lcall)->data);
    for (i = 0; (i < indent); (i)++) {
      argile_buff_puts(buf, "  ");
    };
    if (((call)->comment)) {
      argile_buff_puts(buf, "(:");
      argile_buff_puts(buf, (call)->comment);
      argile_buff_puts(buf, ":)\n");
      for (i = 0; (i < indent); (i)++) {
        argile_buff_puts(buf, "  ");
      };
    } //;
    argile_call_string(call, indent, buf);
    if ((argile).stats) {
      argile_buff_puts(buf, " (: rec=");
      argile_buff_putn(buf, _cumulated_numcomp(call));
      argile_buff_puts(buf, " line=");
      argile_buff_putn(buf, (((call)->loc).start).row);
      argile_buff_puts(buf, " :)");
    } //;
    argile_buff_puts(buf, (((argile).dump_indent) ? ("\n") : (";\n")));
  };
}

int argile_code_compile(argile_code_t * code_4, argile_type_t type)
/** :argile_code_compile <argile code code> <argile type type>: -> int **/
{
  int old_numcomp = 0;
  argile_filter_t old_filter;
  int total = 0;
  int not_compiled = 0;
  argile_list_t * lcall;
  int last = 0;
  argile_call_t * first = ((argile_call_t *)0);
  int fid = 0;

  if ((code_4)->compiled) {
    return 0;
  } //;
  old_numcomp = (argile).numcomp;
  old_filter = (argile).nextdef_filter;
  (code_4)->type = type;
  argile_code_check_dupes(code_4);
  lcall = (code_4)->calls;
  for (; (lcall); lcall = ((argile_list_t *)lcall)->next) {
    if ((*((argile_call_t * *)&((argile_list_t *)lcall)->data))->compiled) {
      (total)++;
    } else {
      (not_compiled)++;
    };
  };
  for (fid = 0; (not_compiled != 0); (fid)++) {
    int compiled = 0;

    (argile).nextdef_filter = (_filters)[fid];
    if (((argile).nextdef_filter == NULL)) {
      break;
    } //;
    if ((argile).debugcomp) {
      printf("%s %s\n", "FILTERING:", (_filters_desc)[fid]);
    } //;
    do {
      compiled = 0;
      for (lcall = (code_4)->calls; (lcall); lcall = ((argile_list_t *)lcall)->next) {
        argile_call_t * call = ((argile_call_t *)0);

        call = *((argile_call_t * *)&((argile_list_t *)lcall)->data);
        if ((call)->compiled) {
          continue;
        } //;
        if (((first == NULL) || (first)->compiled)) {
          first = call;
        } //;
        (argile).numcomp = 0;
        if ((argile_call_compile_syntaxes(call) != 0)) {
          if ((argile_call_compile_as(call, (argile_type_t)(((((argile_list_t *)lcall)->next)) ? (ARGILE_TYPE_ANYTHING) : (type))))) {
            argile_forget_rejects(call);
            argile_list_del((call)->pot_defs);
            (call)->pot_defs = ((argile_list_t *)0);
            argile_call_find_all_path(call);
            argile_call_compile_binds(call);
            (compiled)++;
            (not_compiled)--;
            _percent(&last, ++((argile).curcall), (argile).numcalls);
          } else if ((((argile).maxcomp > 0) && ((argile).numcomp >= (argile).maxcomp))) {
            if (((_filters)[(fid + 1)] == NULL)) {
              argile_die_at(call, "max compilation recursion (%d) reached.\nPlease, add some parenthesis.", (argile).maxcomp);
            } //;
          } //;
        } else {
          argile_call_add_reject(call, "some syntax parameter could not compile");
        };
        if (((argile).error)) {
          if ((argile).deps_only) {
            argile_resurrect();
            continue;
          } //;
          (argile).numcomp = old_numcomp;
          (argile).nextdef_filter = old_filter;
          argile_code_reset_dupes(code_4);
          return -1;
        } //;
      };
      total += compiled;
    } while (((compiled != 0) && (not_compiled != 0)));
  };
  (argile).numcomp = old_numcomp;
  (argile).nextdef_filter = old_filter;
  argile_code_reset_dupes(code_4);
  if (((not_compiled != 0) && !((argile).deps_only))) {
    if ((first)) {
      argile_die_at(first, "first unmatched call");
    } else {
      argile_die("could not compile some call");
    };
    return -1;
  } //;
  if (!((argile).main_only)) {
    for (lcall = (code_4)->calls; (lcall); lcall = ((argile_list_t *)lcall)->next) {
      if ((argile_call_compile_subcodes(*((argile_call_t * *)&((argile_list_t *)lcall)->data)) != 0)) {
        if (!((argile).deps_only)) {
          return -1;
        } //;
      } //;
    };
  } //;
  (code_4)->compiled = 1;
  return 0;
}

void argile_code_include(argile_code_t * code_5, argile_code_t * included, int deep)
/** :argile_code_include <argile code code> <argile code included> <int deep>: -> nothing **/
{
  argile_code_t * old = ((argile_code_t *)0);

  old = code_5;
  while (((included) && (included != code_5))) {
    argile_code_t * mid = ((argile_code_t *)0);

    if ((((included)->ghost) && ((included)->ghost == code_5))) {
      break;
    } //;
    mid = argile_code_new((code_5)->upper, ((argile_list_t *)0));
    (mid)->owner = (code_5)->owner;
    (code_5)->upper = mid;
    if (((included)->ghost)) {
      (mid)->ghost = (included)->ghost;
    } else {
      (mid)->ghost = included;
    };
    (mid)->inc = (deep != 0);
    (mid)->calls = (included)->calls;
    (mid)->type = (included)->type;
    (mid)->defs = (included)->defs;
    (mid)->defs_tail = (included)->defs_tail;
    (mid)->has_weak_defs = (included)->has_weak_defs;
    code_5 = mid;
    do {
      included = (included)->upper;
    } while (((included) && !((included)->inc)));
  };
  argile_code_check_dupes(old);
}

argile_list_t * argile_code_nextdef(argile_code_t * * pcode, argile_list_t * * pprev, argile_list_t * * pnext)
/** :argile_code_nextdef <(argile code) & pcode> <(list of (def)) & pprev> <(list of (def)) & pnext>: -> list of (def) **/
{
  argile_call_t * owner_2 = ((argile_call_t *)0);
  argile_list_t * cur;

  while ((*pcode)) {
    while ((*pprev)) {
      cur = *pprev;
      *pprev = ((argile_list_t *)*pprev)->prev;
      if ((((argile).nextdef_filter == NULL) || ((*(argile).nextdef_filter)(*((argile_def_t * *)&((argile_list_t *)cur)->data))))) {
        return cur;
      } //;
    };
    while ((*pnext)) {
      cur = *pnext;
      *pnext = ((argile_list_t *)*pnext)->next;
      if ((((argile).nextdef_filter == NULL) || ((*(argile).nextdef_filter)(*((argile_def_t * *)&((argile_list_t *)cur)->data))))) {
        return cur;
      } //;
    };
    owner_2 = (*pcode)->owner;
    do {
      *pcode = (*pcode)->upper;
    } while (((*pcode) && (*pcode)->dupe));
    if ((*pcode)) {
      argile_code_getdef(*pcode, owner_2, pprev, pnext);
    } //;
  };
  return ((argile_list_t *)0);
}

void argile_code_getdef(argile_code_t * code_6, argile_call_t * p_argile_call, argile_list_t * * pprev_2, argile_list_t * * pnext_2)
/** :argile_code_getdef <argile code code> <call> <(list of (def)) & pprev> <(list of (def)) & pnext>: -> nothing **/
{
  argile_list_t * ldef;
  argile_list_t * lcall;

  ldef = (code_6)->defs;
  lcall = (code_6)->calls;
  if ((p_argile_call)) {
    while (((p_argile_call)->owner)) {
      p_argile_call = (p_argile_call)->owner;
    };
    while (((ldef) && (lcall))) {
      argile_def_t * def = ((argile_def_t *)0);

      def = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
      if (((def)->maker)) {
        argile_call_t * maker = ((argile_call_t *)0);

        maker = (def)->maker;
        while (((maker)->owner)) {
          maker = (maker)->owner;
        };
        while ((*((argile_call_t * *)&((argile_list_t *)lcall)->data) != maker)) {
          if ((*((argile_call_t * *)&((argile_list_t *)lcall)->data) == p_argile_call)) {
            *pprev_2 = ((argile_list_t *)ldef)->prev;
            *pnext_2 = ldef;
            return;
          } //;
          lcall = ((argile_list_t *)lcall)->next;
        };
      } //;
      ldef = ((argile_list_t *)ldef)->next;
    };
  } //;
  *pprev_2 = (code_6)->defs_tail;
  *pnext_2 = ((argile_list_t *)0);
}

void argile_code_def(argile_code_t * code_7, argile_def_t * p_argile_def, int del)
/** :argile_code_def <argile code code> <def> <int del>: -> nothing **/
{
  argile_list_t * curr;
  argile_list_t * prev;
  argile_list_t * next;

  (p_argile_def)->scope = code_7;
  curr = argile_list_new(p_argile_def, (((del != 0)) ? ((void *)&argile_def_del) : (NULL)));
  argile_code_getdef(code_7, (p_argile_def)->maker, &prev, &next);
  if ((prev == NULL)) {
    argile_list_prepend(&(code_7)->defs, curr);
    if (((code_7)->defs_tail == NULL)) {
      (code_7)->defs_tail = (code_7)->defs;
    } //;
  } else if ((next == NULL)) {
    argile_list_append(&(code_7)->defs_tail, curr);
    if (((code_7)->defs == NULL)) {
      (code_7)->defs = (code_7)->defs_tail;
    } //;
  } else {
    argile_list_link(prev, curr);
    argile_list_link(curr, next);
  };
  if ((((p_argile_def)->maxmatch < 0) || (((code_7)->maxmatch >= 0) && ((p_argile_def)->maxmatch > (code_7)->maxmatch)))) {
    (code_7)->maxmatch = (p_argile_def)->maxmatch;
  } //;
  if (((p_argile_def)->minmatch < (code_7)->minmatch)) {
    (code_7)->minmatch = (p_argile_def)->minmatch;
  } //;
  if (((p_argile_def)->minparam < (code_7)->minparam)) {
    (code_7)->minparam = (p_argile_def)->minparam;
  } //;
  if (((p_argile_def)->minchar < (code_7)->minchar)) {
    (code_7)->minchar = (p_argile_def)->minchar;
  } //;
  if (((p_argile_def)->minchsum < (code_7)->minchsum)) {
    (code_7)->minchsum = (p_argile_def)->minchsum;
  } //;
  if (((p_argile_def)->minword < (code_7)->minword)) {
    (code_7)->minword = (p_argile_def)->minword;
  } //;
  if (((p_argile_def)->minop < (code_7)->minop)) {
    (code_7)->minop = (p_argile_def)->minop;
  } //;
  if ((!((code_7)->has_weak_defs) && (p_argile_def)->weak)) {
    (code_7)->has_weak_defs = 1;
  } //;
  if ((argile).stats) {
    switch ((p_argile_def)->dtype) {
      case ARGILE_DEF_BIND: {
        (((argile).stat).binds)++;
      } break;
      case ARGILE_DEF_FUNC: {
        if ((argile_def_is_macro(p_argile_def))) {
          (((argile).stat).macros)++;
        } else {
          (((argile).stat).funcs)++;
        };
      } break;
      case ARGILE_DEF_VAR: {
        if (((p_argile_def)->param)) {
          (((argile).stat).params)++;
        } else {
          (((argile).stat).vars)++;
        };
      } break;
      default: {} break;
    };
  } //;
}

void argile_code_check_dupes(argile_code_t * code_8)
/** :argile_code_check_dupes <argile code code>: -> nothing **/
{
  for (code_8 = (code_8)->upper; (code_8); code_8 = (code_8)->upper) {
    if ((((code_8)->ghost) && !((code_8)->dupe))) {
      argile_code_t * up = ((argile_code_t *)0);

      for (up = (code_8)->upper; (up); up = (up)->upper) {
        if (((up)->ghost == (code_8)->ghost)) {
          (up)->dupe = 1;
        } //;
      };
    } //;
  };
}

void argile_code_reset_dupes(argile_code_t * code_9)
/** :argile_code_reset_dupes <argile code code>: -> nothing **/
{
  for (code_9 = (code_9)->upper; (code_9); code_9 = (code_9)->upper) {
    if ((code_9)->dupe) {
      (code_9)->dupe = 0;
    } //;
  };
}

void argile_code_anon(argile_code_t * code_10)
/** :argile_code_anon <argile code code>: -> nothing **/
{
  argile_buff_t b = ((argile_buff_t){0});

  if (((code_10)->anon)) {
    return;
  } //;
  argile_buff_puts(&b, "anonymous");
  if (((code_10)->owner)) {
    argile_buff_putc(&b, '_');
    argile_buff_putn(&b, ((((code_10)->owner)->loc).start).row);
    argile_buff_putc(&b, '_');
    argile_buff_putn(&b, ((((code_10)->owner)->loc).end).row);
    argile_buff_putc(&b, '_');
  } //;
  argile_buff_putc(&b, '\0');
  argile_check_local_collisions(&b, (argile).main);
  argile_check_collisions(&b);
  (code_10)->anon = (b).ptr;
  (code_10)->type = (argile_type_t)ARGILE_TYPE_ANYTHING;
}

void argile_code_caster(argile_code_t * code_11, argile_type_t from, argile_type_t to)
/** :argile_code_caster <argile code code> <argile type from> <argile type to>: -> nothing **/
{
  argile_buff_t b = ((argile_buff_t){0});

  if (((code_11)->anon)) {
    return;
  } //;
  argile_buff_puts(&b, "cast_");
  argile_type_gen_id_part(from, (code_11)->owner, &b);
  argile_buff_puts(&b, "_to_");
  argile_type_gen_id_part(to, (code_11)->owner, &b);
  argile_buff_putc(&b, '\0');
  argile_check_local_collisions(&b, (argile).main);
  argile_check_collisions(&b);
  (code_11)->caster = 1;
  (code_11)->type = to;
  (code_11)->anon = (b).ptr;
}

argile_def_t * argile_code_find_first_param(argile_code_t * code_12)
/** :argile_code_find_first_param <argile code code>: -> (argile) def **/
{
  argile_list_t * ld;

  for (ld = (code_12)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if (((d)->param)) {
      return d;
    } //;
  };
  return ((argile_def_t *)0);
}

void argile_code_gencode(argile_code_t * code_13)
/** :argile_code_gencode <argile code code>: -> nothing **/
{
  unsigned char variadic;
  argile_list_t * lc;

  if (((code_13)->calls == NULL)) {
    if (((code_13)->type != ARGILE_TYPE_NOTHING)) {
      argile_code_gen_line(code_13);
      argile_indent();
      if (!((code_13)->macro)) {
        argile_puts("return ");
      } //;
      argile_type_gen_zero((code_13)->type);
      argile_puts(";\n");
    } //;
    return;
  } //;
  variadic = 0;
  if ((((code_13)->anon) && !((code_13)->caster))) {
    argile_indent();
    argile_printf("va_list %s;\n", "anon_va");
    argile_indent();
    argile_printf("va_start(%s, %s);\n\n", "anon_va", "anon_arg");
    variadic = 1;
  } //;
  for (lc = (code_13)->calls; ((lc) && !(((argile).error))); lc = ((argile_list_t *)lc)->next) {
    argile_call_t * c = ((argile_call_t *)0);

    c = ((argile_call_t *)*((argile_call_t * *)&((argile_list_t *)lc)->data));
    if ((((((argile_list_t *)lc)->next == NULL) && !((code_13)->macro)) && ((code_13)->type != ARGILE_TYPE_NOTHING))) {
      argile_type_t t;

      t = argile_call_get_type(c);
      if (((argile_type_match((code_13)->type, t)) && !((((code_13)->type == ARGILE_TYPE_ANYTHING) && (t == ARGILE_TYPE_NOTHING))))) {
        argile_call_gen_line(c);
        argile_indent();
        if (variadic) {
          argile_printf("%s = ", "anon_arg");
        } else {
          argile_puts("return ");
        };
        if ((((code_13)->type == ARGILE_TYPE_ANYTHING) && (t != ARGILE_TYPE_ANYTHING))) {
          argile_puts("(");
          argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
          argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
          argile_puts(")");
        } //;
        argile_call_gencode(c, 1);
        argile_puts(";\n");
        if (variadic) {
          argile_indent();
          argile_printf("va_end(%s);\n", "anon_va");
          argile_indent();
          argile_printf("return %s;\n", "anon_arg");
        } //;
      } else {
        argile_call_gen_line(c);
        argile_call_gencode(c, 0);
        if (variadic) {
          argile_indent();
          argile_printf("va_end(%s);\n", "anon_va");
        } //;
        argile_indent();
        argile_puts("return ");
        argile_type_gen_zero((code_13)->type);
        argile_puts(";\n");
      };
    } else {
      argile_call_gen_line(c);
      argile_call_gencode(c, 0);
    };
  };
}

void argile_code_gendata(argile_code_t * code_14)
/** :argile_code_gendata <argile code code>: -> nothing **/
{
  argile_list_t * lc;

  argile_puts("{");
  for (lc = (code_14)->calls; ((lc) && !(((argile).error))); lc = ((argile_list_t *)lc)->next) {
    argile_call_t * c = ((argile_call_t *)0);

    c = ((argile_call_t *)*((argile_call_t * *)&((argile_list_t *)lc)->data));
    if ((((argile_list_t *)lc)->next)) {
      argile_call_gencode(c, 2);
      argile_puts(", ");
    } else {
      argile_type_t old;

      old = (c)->context;
      (c)->context = (argile_type_t)ARGILE_TYPE_ANYTHING;
      argile_call_gencode(c, 2);
      (c)->context = old;
    };
  };
  argile_puts("}");
}

void argile_code_gen_includes(argile_code_t * code_15)
/** :argile_code_gen_includes <argile code code>: -> nothing **/
{
  unsigned char some;
  argile_list_t * li;

  some = 0;
  for (li = argile_list_end((argile).sysincludes); (li); li = ((argile_list_t *)li)->prev) {
    argile_printf("#include <%s>\n", *((char * *)&((argile_list_t *)li)->data));
    if (!(some)) {
      some = 1;
    } //;
  };
  if (some) {
    argile_puts("\n");
    some = 0;
  } //;
  for (li = argile_list_end((argile).includes); (li); li = ((argile_list_t *)li)->prev) {
    argile_printf("#include \"%s\"\n", *((char * *)&((argile_list_t *)li)->data));
    if (!(some)) {
      some = 1;
    } //;
  };
  if (some) {
    argile_puts("\n");
  } //;
}

void argile_code_gen_defines(argile_code_t * code_16)
/** :argile_code_gen_defines <argile code code>: -> nothing **/
{
}

void argile_code_pregen_ids(argile_code_t * code_17)
/** :argile_code_pregen_ids <argile code code>: -> nothing **/
{
  pregen_includes_rec((code_17)->upper);
  pregen(code_17, 0);
}

void argile_code_gen_typedefs(argile_code_t * code_18, int privates)
/** :argile_code_gen_typedefs <argile code code> <int privates>: -> nothing **/
{
  if ((gen_typedefs(code_18, (privates != 0), 1) != 0)) {
    argile_puts("\n");
  } //;
}

void argile_code_gen_enums(argile_code_t * code_19, int privates_2)
/** :argile_code_gen_enums <argile code code> <int privates>: -> nothing **/
{
  gen_enums(code_19, (privates_2 != 0), 1);
}

void argile_code_gen_structs_and_unions(argile_code_t * code_20, int privates_3)
/** :argile_code_gen_structs_and_unions <argile code code> <int privates>: -> nothing **/
{
  gen_structs_and_unions(code_20, (privates_3 != 0), 1);
}

void argile_code_gen_protos(argile_code_t * code_21, int statics)
/** :argile_code_gen_protos <argile code code> <int statics>: -> nothing **/
{
  if ((gen_protofuncs(code_21, (statics != 0), 0) != 0)) {
    argile_puts("\n");
  } //;
}

void argile_code_gen_funcs(argile_code_t * code_22)
/** :argile_code_gen_funcs <argile code code>: -> nothing **/
{
  gen_protofuncs(code_22, 1, 1);
}

static char * gen_param_id_of_from(argile_def_t * p_argile_def_2, argile_call_t * p_argile_call_2)
/** :gen param id of <def> from <call>: -> text **/
{
  argile_syn_param_t * p = ((argile_syn_param_t *)0);

  p = (p_argile_def_2)->param;
  if ((((p != NULL) && ((p)->genid == NULL)) && ((p)->name == NULL))) {
    argile_buff_t b = ((argile_buff_t){0});

    argile_buff_puts(&b, "p_");
    argile_type_gen_id_part((p)->type, p_argile_call_2, &b);
    argile_buff_putc(&b, '\0');
    argile_check_local_collisions(&b, (p_argile_def_2)->scope);
    argile_check_collisions(&b);
    (p)->genid = (b).ptr;
    return (p)->genid;
  } //;
  return argile_def_gen_id(p_argile_def_2);
}

static int gen_protofuncs(argile_code_t * code_23, unsigned char statics_2, unsigned char bodies)
/** :gen protofuncs <argile code code> <bool statics> <bool bodies>: -> int **/
{
  int count = 0;
  argile_list_t * cur;

  if (((code_23)->anon)) {
    unsigned char skip;

    skip = 0;
    argile_code_gen_line(code_23);
    if (((code_23)->caster)) {
      if ((bodies || !(statics_2))) {
        argile_def_t * from_2 = ((argile_def_t *)0);

        from_2 = argile_code_find_first_param(code_23);
        if ((from_2)) {
          argile_type_t t;

          t = (((int)(from_2)->type) & ~((1 << 31)));
          argile_type_gen_prefix((code_23)->type);
          argile_printf(" %s(", (code_23)->anon);
          argile_type_gen_prefix(t);
          argile_puts(" ");
          argile_puts(gen_param_id_of_from(from_2, (code_23)->owner));
          argile_type_gen_suffix(t);
          argile_puts(")");
          argile_type_gen_suffix((code_23)->type);
        } else {
          argile_die_at((code_23)->owner, "no parameter found in caster (bug)");
        };
      } else {
        skip = 1;
      };
    } else if ((bodies || statics_2)) {
      argile_puts("static ");
      argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_printf(" %s(", (code_23)->anon);
      argile_type_gen_prefix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_puts("anon_arg");
      argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
      argile_puts(", ...)");
      argile_type_gen_suffix((argile_type_t)ARGILE_TYPE_ANYTHING);
    } else {
      skip = 1;
    };
    if (!(skip)) {
      if (bodies) {
        argile_puts("\n{\n");
        ((argile).indent)++;
        argile_code_gen_vars(code_23, 0);
        argile_code_gencode(code_23);
        ((argile).indent)--;
        argile_puts("}\n\n");
      } else {
        argile_puts(";\n");
      };
    } //;
    (count)++;
  } //;
  for (cur = (code_23)->defs; (cur); cur = ((argile_list_t *)cur)->next) {
    int nparam = 0;
    argile_def_t * d = ((argile_def_t *)0);
    argile_code_t * body = ((argile_code_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)cur)->data.u_anything));
    if ((((d)->dtype != ARGILE_DEF_FUNC) || (d)->nodecl)) {
      continue;
    } //;
    body = ((d)->dval).code;
    if (((bodies && (body == NULL)) || ((body) && (body)->macro))) {
      continue;
    } //;
    if ((!(bodies) && ((!(statics_2) && ((d)->private || (code_23 != (argile).main))) || ((statics_2 && !((d)->private)) && (code_23 == (argile).main))))) {
      continue;
    } //;
    argile_def_gen_line(d, code_23);
    if (((code_23 != (argile).main) || (d)->private)) {
      argile_puts("static ");
    } //;
    argile_type_gen_prefix((d)->type);
    argile_printf(" %s(", argile_def_gen_id(d));
    if ((body)) {
      argile_list_t * la;

      for (la = (body)->autoparams; (la); la = ((argile_list_t *)la)->next) {
        argile_def_t * a = ((argile_def_t *)0);

        a = ((argile_def_t *)*((void * *)&((argile_list_t *)la)->data.u_anything));
        if (((nparam)++ != 0)) {
          argile_puts(", ");
        } //;
        argile_type_gen_prefix((a)->type);
        argile_puts(" ");
        if ((((((int)(a)->type) >> 30) & 1))) {
          argile_ref(1);
        } //;
        argile_puts(argile_def_gen_id(a));
        argile_type_gen_suffix((a)->type);
      };
    } //;
    argile_syntax_gen_params((d)->syntax, ((int)bodies), &nparam);
    if ((((body) && (body)->variadic) || ((body == NULL) && !((d)->ext)))) {
      argile_syntax_gen_options((d)->syntax, body, &nparam);
      argile_syntax_gen_enums((d)->syntax, body, &nparam);
      argile_syntax_gen_lists((d)->syntax, body, &nparam);
    } //;
    if ((has_pseudo_param((d)->syntax) || (((body) && !((body)->variadic)) && has_optenulis((d)->syntax)))) {
      if ((nparam != 0)) {
        argile_puts(", ");
        argile_puts("...");
      } //;
    } //;
    argile_puts(")");
    argile_type_gen_suffix((d)->type);
    if (bodies) {
      argile_puts("\n");
      gen_syntax_comment(d, ((((code_23)->calls)) ? (*((argile_call_t * *)&((argile_list_t *)(code_23)->calls)->data)) : (NULL)));
      argile_puts("{\n");
      ((argile).indent)++;
      argile_code_gen_vars(body, 0);
      argile_code_gencode(body);
      ((argile).indent)--;
      argile_puts("}\n\n");
    } else {
      argile_puts(";\n");
      gen_syntax_comment(d, ((((code_23)->calls)) ? (*((argile_call_t * *)&((argile_list_t *)(code_23)->calls)->data)) : (NULL)));
    };
    (count)++;
  };
  for (cur = (code_23)->calls; (cur); cur = ((argile_list_t *)cur)->next) {
    count += gen_protofuncs_2(((argile_call_t *)*((void * *)&((argile_list_t *)cur)->data.u_anything)), statics_2, bodies);
  };
  return count;
}

static int gen_protofuncs_2(argile_call_t * call, unsigned char statics_3, unsigned char bodies_2)
/** :gen protofuncs <argile call call> <bool statics> <bool bodies>: -> int **/
{
  int count = 0;
  argile_list_t * lm;

  for (lm = (call)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      count += gen_protofuncs_2(((m)->value).call, statics_3, bodies_2);
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * c = ((argile_cons_t *)0);

      c = ((m)->value).cons;
      if (((c)->ctype == ARGILE_CONS_CODE)) {
        count += gen_protofuncs(((c)->cvalue).code, statics_3, bodies_2);
      } //;
    } //;
  };
  return count;
}

void argile_code_gen_vars(argile_code_t * code_24, int externs)
/** :argile_code_gen_vars <argile code code> <int externs>: -> nothing **/
{
  unsigned char some;
  argile_list_t * ld;

  some = 0;
  for (ld = (code_24)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if ((((d)->dtype != ARGILE_DEF_VAR) || (((((d)->param) || (d)->nodecl) || (d)->locall) || (d)->private))) {
      continue;
    } //;
    if (((code_24 == (argile).main) && ((d)->ext && (externs == 0)))) {
      continue;
    } //;
    if ((!((d)->ext) && (externs == 1))) {
      continue;
    } //;
    argile_def_gen_line(d, code_24);
    argile_indent();
    if (((externs != 0) || (d)->ext)) {
      argile_puts("extern ");
    } //;
    argile_type_gen_prefix((((d)->dval).var)->type);
    argile_puts(" ");
    argile_puts(argile_def_gen_id(d));
    argile_type_gen_suffix((((d)->dval).var)->type);
    if (((externs == 0) && !((d)->ext))) {
      argile_match_t * init = ((argile_match_t *)0);

      init = (((d)->dval).var)->init;
      if ((argile_match_is_const(init))) {
        argile_puts(" = ");
        if (has_data_block(((d)->dval).var)) {
          argile_code_gendata(((((init)->value).cons)->cvalue).code);
        } //;
        else {
          argile_match_gencode(init);
        };
      } else {
        argile_type_t t;
        argile_type_info_t * i = ((argile_type_info_t *)0);

        t = (((int)(d)->type) & ~((1 << 31)));
        i = argile_type_get_info(t);
        if ((((i == NULL) || ((i)->ttype == ARGILE_TYPE_KIND_BIND)) || ((i)->ttype == ARGILE_TYPE_KIND_CLASS))) {
          argile_puts(" = ");
          argile_type_gen_zero(t);
        } //;
      };
    } //;
    argile_puts(";\n");
    if (!(some)) {
      some = 1;
    } //;
  };
  if (some) {
    argile_puts("\n");
  } //;
}

static unsigned char has_data_block(argile_var_t * p_argile_var)
/** :<var> has data block: -> bool **/
{
  if ((((((int)(p_argile_var)->type) >> 30) & 1))) {
    if (((p_argile_var)->init)) {
      if ((((p_argile_var)->init)->type == ARGILE_MATCH_CONS)) {
        argile_cons_t * cons = ((argile_cons_t *)0);

        cons = (((p_argile_var)->init)->value).cons;
        if (((cons)->ctype == ARGILE_CONS_CODE)) {
          if ((((cons)->cvalue).code)) {
            return 1;
          } //;
        } //;
      } //;
    } //;
  } //;
  return 0;
}

void argile_code_gen_private_vars(argile_code_t * code_25)
/** :argile_code_gen_private_vars <argile code code>: -> nothing **/
{
  unsigned char some;
  argile_list_t * ld;
  argile_list_t * lc;

  some = 0;
  for (ld = (code_25)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);
    argile_match_t * init = ((argile_match_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if ((((d)->dtype != ARGILE_DEF_VAR) || ((((!((d)->private) || ((d)->param)) || (d)->nodecl) || (d)->locall) || (d)->ext))) {
      continue;
    } //;
    argile_def_gen_line(d, code_25);
    argile_indent();
    argile_puts("static ");
    argile_type_gen_prefix((((d)->dval).var)->type);
    argile_puts(" ");
    argile_puts(argile_def_gen_id(d));
    argile_type_gen_suffix((((d)->dval).var)->type);
    init = (((d)->dval).var)->init;
    if ((argile_match_is_const(init))) {
      argile_puts(" = ");
      if (has_data_block(((d)->dval).var)) {
        argile_code_gendata(((((init)->value).cons)->cvalue).code);
      } //;
      else {
        argile_match_gencode(init);
      };
    } else {
      argile_type_t t;
      argile_type_info_t * i = ((argile_type_info_t *)0);

      t = (((int)(d)->type) & ~((1 << 31)));
      i = argile_type_get_info(t);
      if (((!((i)) || ((i)->ttype == ARGILE_TYPE_KIND_BIND)) || ((i)->ttype == ARGILE_TYPE_KIND_CLASS))) {
        argile_puts(" = ");
        argile_type_gen_zero(t);
      } //;
    };
    argile_puts(";\n");
    if (!(some)) {
      some = 1;
    } //;
  };
  if (some) {
    argile_puts("\n");
  } //;
  for (lc = (code_25)->calls; (lc); lc = ((argile_list_t *)lc)->next) {
    private_vars(((argile_call_t *)*((void * *)&((argile_list_t *)lc)->data.u_anything)));
  };
}

void argile_code_gen_main(argile_code_t * code_26)
/** :argile_code_gen_main <argile code code>: -> nothing **/
{
  argile_list_t * lc;

  (code_26)->type = (argile_type_t)ARGILE_TYPE_INTEGER;
  lc = argile_list_end((code_26)->calls);
  if (((lc) && (*((argile_call_t * *)&((argile_list_t *)lc)->data)))) {
    (*((argile_call_t * *)&((argile_list_t *)lc)->data))->context = (argile_type_t)ARGILE_TYPE_INTEGER;
  } //;
  argile_puts("int main(int argc, char **argv)\n{\n");
  ((argile).indent)++;
  if ((argile).cat_main) {
    argile_list_t * lf;

    lf = (argile).used;
    for (; (lf); lf = ((argile_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);

      f = *((argile_file_t * *)&((argile_list_t *)lf)->data);
      if (((f)->code == code_26)) {
        continue;
      } //;
      argile_indent();
      argile_printf("/* %s */ {\n", (f)->path);
      ((argile).indent)++;
      ((f)->code)->type = (argile_type_t)ARGILE_TYPE_NOTHING;
      argile_code_gencode((f)->code);
      ((argile).indent)--;
      argile_indent();
      argile_puts("}\n");
    };
  } //;
  argile_code_gencode(code_26);
  ((argile).indent)--;
  argile_puts("}\n");
}

void argile_code_gen_line(argile_code_t * code_27)
/** :argile_code_gen_line <argile code code>: -> nothing **/
{
  if (((argile).gen_lines == 0)) {
    return;
  } //;
  if ((code_27)->macro) {
    return;
  } //;
  if (((code_27)->owner == NULL)) {
    return;
  } //;
  argile_call_gen_line((code_27)->owner);
}

unsigned char argile_code_find_autoparams(argile_code_t * code_28)
/** :argile_code_find_autoparams <argile code code>: -> bool **/
{
  unsigned char found;
  argile_list_t * lc;

  found = 0;
  lc = (code_28)->calls;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    if (argile_call_find_autoparams(*((argile_call_t * *)&((argile_list_t *)lc)->data))) {
      found = 1;
    } //;
  };
  return found;
}

static int _cumulated_numcomp(argile_call_t * p_argile_call_3)
/** :_cumulated_numcomp <call>: -> int **/
{
  unsigned int n = 0;
  argile_list_t * lm;

  n = (p_argile_call_3)->numcomp;
  lm = (p_argile_call_3)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if (((m) && ((m)->type == ARGILE_MATCH_SUBCALL))) {
      argile_call_t * sub = ((argile_call_t *)0);
      int c = 0;

      sub = ((m)->value).call;
      c = _cumulated_numcomp(sub);
      if (((sub)->type == ARGILE_CALL_EXPLICIT)) {
        n += c;
      } //;
    } //;
  };
  return ((int)n);
}

static int _f_all(argile_def_t * p_argile_def_3)
/** :_f_all <def>: -> int **/
{
  return 1;
}

static int _f_defmakers(argile_def_t * p_argile_def_4)
/** :_f_defmakers <def>: -> int **/
{
  if ((((p_argile_def_4)->dtype == ARGILE_DEF_BIND) && (((p_argile_def_4)->dval).bind)->defmaker)) {
    return 1;
  } //;
  if (((p_argile_def_4)->type == ARGILE_TYPE_TYPE)) {
    if (((p_argile_def_4)->dtype == ARGILE_DEF_TYPE)) {
      return 1;
    } //;
    if ((argile_def_is_macro(p_argile_def_4))) {
      return 1;
    } //;
  } //;
  return 0;
}

static void _percent(int * last, int n, int max)
/** :_percent <int n> <int max>: -> nothing **/
{
  int p = 0;

  if (!((argile).progress)) {
    return;
  } //;
  p = ((n * 1000) / max);
  if ((p != *last)) {
    *last = p;
    fprintf(stderr, "\r% 3d.%d%%%s", (p / 10), (p % 10), (((p >= 1000)) ? ("\n") : ("")));
  } //;
}

static void pregen_includes_rec(argile_code_t * up)
/** :pregen includes rec <argile code up>: -> nothing **/
{
  argile_list_t * ld;

  if (((up == NULL) || ((up)->ghost == NULL))) {
    return;
  } //;
  pregen_includes_rec((up)->upper);
  for (ld = (up)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if (!(((((((d)->locall || (d)->private) || ((d)->param != NULL)) || ((d)->dtype == ARGILE_DEF_BIND)) || ((d)->dtype == ARGILE_DEF_TYPE)) || (argile_def_is_macro(d))))) {
      argile_def_gen_id(d);
    } //;
  };
}

static void pregen(argile_code_t * code_29, unsigned char in_macro)
/** :pregen <argile code code> <bool in_macro>: -> nothing **/
{
  argile_list_t * ld;

  if ((!(in_macro) && (code_29)->macro)) {
    in_macro = 1;
  } //;
  for (ld = (code_29)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
    if (((d)->dtype == ARGILE_DEF_TYPE)) {
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      ti = argile_type_get_info(((d)->dval).type);
      if ((ti != NULL)) {
        if (((ti)->name == NULL)) {
          (ti)->name = argile_def_gen_id(d);
        } //;
        if (((ti)->ttype == ARGILE_TYPE_KIND_CLASS)) {
          argile_list_t * f;

          for (f = (((ti)->tval).t_class).fields; (f); f = ((argile_list_t *)f)->next) {
            argile_field_gen_id(*((argile_field_t * *)&((argile_list_t *)f)->data), (char *)0, ((argile_call_t *)0));
          };
        } //;
        else if (((ti)->ttype == ARGILE_TYPE_KIND_UNION)) {
          argile_list_t * f;

          for (f = (((ti)->tval).t_union).variants; (f); f = ((argile_list_t *)f)->next) {
            argile_field_gen_id(*((argile_field_t * *)&((argile_list_t *)f)->data), "u_", (d)->maker);
          };
        } //;
      } //;
    } else if (((in_macro && ((d)->dtype == ARGILE_DEF_VAR)) && ((d)->param == NULL))) {
      argile_def_pregen_global_id(d);
    } //;
  };
  for (ld = (code_29)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
    pregen_2(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), in_macro);
  };
}

static void pregen_2(argile_call_t * p_argile_call_4, unsigned char in_macro_2)
/** :pregen <call> <bool in_macro>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = (p_argile_call_4)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      pregen_2(((m)->value).call, in_macro_2);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      argile_code_t * code_30 = ((argile_code_t *)0);

      code_30 = ((((m)->value).cons)->cvalue).code;
      if (((((!(((code_30)->anon)) && ((code_30)->owner)) && (((code_30)->owner)->def)) && ((((code_30)->owner)->def)->dtype == ARGILE_DEF_FUNC)) && !((argile_def_is_macro(((code_30)->owner)->def))))) {
        argile_code_anon(code_30);
      } //;
      pregen(code_30, in_macro_2);
    } //;
  };
}

static int gen_typedefs(argile_code_t * code_30, unsigned char privates_4, unsigned char global)
/** :gen typedefs <argile code code> <bool privates> <bool global>: -> int **/
{
  int done = 0;
  argile_list_t * ld;

  if (((global && !(privates_4)) || (privates_4 && !(global)))) {
    for (ld = (code_30)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      } //;
      ti = argile_type_get_info(((d)->dval).type);
      if ((ti == NULL)) {
        continue;
      } //;
      switch ((ti)->ttype) {
        case ARGILE_TYPE_KIND_ENUM: {
          argile_def_gen_line(d, code_30);
          argile_indent();
          argile_printf("typedef enum   %s_e %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_UNION: {
          argile_def_gen_line(d, code_30);
          argile_indent();
          argile_printf("typedef union  %s_u %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_CLASS: {
          if ((ti)->_struct) {
            break;
          } //;
          argile_def_gen_line(d, code_30);
          argile_indent();
          argile_printf("typedef struct %s_s %s;\n", (ti)->name, (ti)->name);
          (done)++;
        } break;
        case ARGILE_TYPE_KIND_CTYPE: {
          if ((((ti)->tval).t_ctype).use_typedef) {
            char * p = "";
            char * s = "";

            p = (((ti)->tval).t_ctype).prefix;
            s = (((ti)->tval).t_ctype).suffix;
            argile_printf("typedef %s %s%s;\n", (((p)) ? (p) : ("")), (ti)->name, (((s)) ? (s) : ("")));
            (done)++;
          } //;
        } break;
        default: {} break;
      };
    };
  } //;
  if (privates_4) {
    for (ld = (code_30)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
      done += gen_typedefs_2(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)));
    };
  } //;
  return done;
}

static int gen_typedefs_2(argile_call_t * call_2)
/** :gen typedefs <argile call call>: -> int **/
{
  int count = 0;
  argile_list_t * lm;

  for (lm = (call_2)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      count += gen_typedefs_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      count += gen_typedefs(((((m)->value).cons)->cvalue).code, 1, 0);
    } //;
  };
  return count;
}

static void gen_enums(argile_code_t * code_31, unsigned char privates_5, unsigned char global_2)
/** :gen enums <argile code code> <bool privates> <bool global>: -> nothing **/
{
  argile_list_t * ld;

  if (((global_2 && !(privates_5)) || (privates_5 && !(global_2)))) {
    for (ld = (code_31)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      if (!(((d)->dtype == ARGILE_DEF_TYPE))) {
        continue;
      } //;
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && ((ti)->ttype == ARGILE_TYPE_KIND_ENUM))) {
        argile_list_t * lm;
        argile_list_t * lv;

        lm = (((ti)->tval).t_enum).members;
        lv = (((ti)->tval).t_enum).values;
        argile_printf("enum   %s_e {\n", argile_def_gen_id(d));
        while (((lm) && (lv))) {
          argile_puts("  ");
          argile_puts(*((char * *)&((argile_list_t *)lm)->data));
          if ((*((int* *)&((argile_list_t *)lv)->data))) {
            argile_printf(" = %i", **((int* *)&((argile_list_t *)lv)->data));
          } //;
          if ((((argile_list_t *)lm)->next)) {
            argile_puts(",");
          } //;
          argile_puts("\n");
          lm = ((argile_list_t *)lm)->next;
          lv = ((argile_list_t *)lv)->next;
        };
        argile_puts("};\n\n");
      } //;
    };
  } //;
  if (privates_5) {
    for (ld = (code_31)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
      gen_enums_2(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)));
    };
  } //;
}

static void gen_enums_2(argile_call_t * p_argile_call_5)
/** :gen enums <call>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = (p_argile_call_5)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m == NULL)) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      gen_enums_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      gen_enums(((((m)->value).cons)->cvalue).code, 1, 0);
    } //;
  };
}

static void gen_structs_and_unions(argile_code_t * code_32, unsigned char privates_6, unsigned char global_3)
/** :gen structs and unions <argile code code> <bool privates> <bool global>: -> nothing **/
{
  argile_list_t * lx;

  if (((global_3 && !(privates_6)) || (privates_6 && !(global_3)))) {
    for (lx = (code_32)->defs; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)lx)->data.u_anything));
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      } //;
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && (((ti)->ttype == ARGILE_TYPE_KIND_CLASS) || ((ti)->ttype == ARGILE_TYPE_KIND_UNION)))) {
        (ti)->rec = 1;
      } //;
    };
    for (lx = (code_32)->defs; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      argile_type_info_t * ti = ((argile_type_info_t *)0);

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)lx)->data.u_anything));
      if ((((d)->dtype != ARGILE_DEF_TYPE) || (d)->ext)) {
        continue;
      } //;
      ti = argile_type_get_info(((d)->dval).type);
      if (((ti) && (ti)->rec)) {
        gen_structs_and_unions_3(code_32, d, ti);
      } //;
    };
  } //;
  if (privates_6) {
    for (lx = (code_32)->calls; (lx); lx = ((argile_list_t *)lx)->next) {
      gen_structs_and_unions_2(((argile_call_t *)*((void * *)&((argile_list_t *)lx)->data.u_anything)));
    };
  } //;
}

static void gen_structs_and_unions_2(argile_call_t * p_argile_call_6)
/** :gen structs and unions <call>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = (p_argile_call_6)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if (!((m))) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      gen_structs_and_unions_2(((m)->value).call);
    } else if ((((m)->type == ARGILE_MATCH_CONS) && ((((m)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      gen_structs_and_unions(((((m)->value).cons)->cvalue).code, 1, 0);
    } //;
  };
}

static void gen_structs_and_unions_3(argile_code_t * code_33, argile_def_t * d, argile_type_info_t * ti)
/** :gen structs and unions <argile code code> <def d> <type info ti>: -> nothing **/
{
  argile_list_t * fields;
  char * format = "";
  argile_list_t * lf;

  if (!((ti)->rec)) {
    return;
  } //;
  (ti)->rec = 0;
  if (((ti)->ttype == ARGILE_TYPE_KIND_CLASS)) {
    fields = (((ti)->tval).t_class).fields;
    if ((ti)->_struct) {
      format = "struct %s {\n";
    } //;
    else {
      format = "struct %s_s {\n";
    };
  } else if (((ti)->ttype == ARGILE_TYPE_KIND_UNION)) {
    fields = (((ti)->tval).t_union).variants;
    format = "union  %s_u {\n";
  } else {
    return;
  };
  if ((d == NULL)) {
    argile_list_t * ld;

    ld = (code_33)->defs;
    for (; (ld); ld = ((argile_list_t *)ld)->next) {
      d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_TYPE) && (((d)->dval).type == (ti)->type))) {
        break;
      } //;
    };
    if ((ld == NULL)) {
      return;
    } //;
  } //;
  lf = fields;
  for (; (lf); lf = ((argile_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = *((argile_field_t * *)&((argile_list_t *)lf)->data);
    if ((((ti = argile_type_get_info((f)->type)) && (ti)->rec) && ((((((int)(f)->type) >> 30) & 1)) || ((ti)->ttype == ARGILE_TYPE_KIND_UNION)))) {
      gen_structs_and_unions_3(code_33, ((argile_def_t *)0), ti);
    } //;
  };
  argile_def_gen_line(d, code_33);
  argile_indent();
  argile_printf(format, argile_def_gen_id(d));
  ((argile).indent)++;
  for (lf = fields; (lf); lf = ((argile_list_t *)lf)->next) {
    argile_field_t * f = ((argile_field_t *)0);

    f = *((argile_field_t * *)&((argile_list_t *)lf)->data);
    argile_indent();
    argile_type_gen_prefix((f)->type);
    argile_puts(" ");
    argile_puts(argile_field_gen_id(f, "u_", (d)->maker));
    argile_type_gen_suffix((f)->type);
    if (((f)->bits != 0)) {
      argile_printf(" : %u", (f)->bits);
    } //;
    argile_puts(";\n");
  };
  ((argile).indent)--;
  argile_indent();
  argile_puts("};\n\n");
}

static unsigned char has_pseudo_param(argile_list_t * syn)
/** :<list of (argile syntax) syn> has pseudo param: -> bool **/
{
  for (; (syn); syn = ((argile_list_t *)syn)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syn)->data);
    if ((((s)->type == ARGILE_SYN_LIST) && (((s)->value).syn_list)->pseudoempty)) {
      return 1;
    } //;
  };
  return 0;
}

static unsigned char has_optenulis(argile_list_t * syn_2)
/** :<list of (argile syntax) syn> has optenulis: -> bool **/
{
  for (; (syn_2); syn_2 = ((argile_list_t *)syn_2)->next) {
    argile_syntax_t * s = ((argile_syntax_t *)0);

    s = *((argile_syntax_t * *)&((argile_list_t *)syn_2)->data);
    switch ((s)->type) {
      case ARGILE_SYN_OPTION: ;
      case ARGILE_SYN_ENUM: ;
      case ARGILE_SYN_LIST: {
        return 1;
      } break;
      default: {} break;
    };
  };
  return 0;
}

static void gen_syntax_comment(argile_def_t * d_2, argile_call_t * c)
/** :gen syntax comment <def d> <call c>: -> nothing **/
{
  unsigned char old;
  argile_buff_t b = ((argile_buff_t){0});

  if (!((argile).proto_syntax)) {
    return;
  } //;
  old = (argile).use_colors;
  (argile).use_colors = 0;
  argile_syntax_string((d_2)->syntax, &b);
  if (((b).ptr)) {
    argile_puts("/** :");
    argile_output((b).ptr, ((int)(b).len));
    argile_puts(": -> ");
    argile_buff_flush(&b);
    argile_typename((d_2)->type, &b, ((((d_2)->scope)) ? ((d_2)->scope) : ((c)->scope)));
    argile_output((b).ptr, ((int)(b).len));
    argile_puts(" **/\n");
    argile_dbg_free((b).ptr);
  } //;
  (argile).use_colors = old;
}

static void private_vars(argile_call_t * p_argile_call_7)
/** :private vars <call>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = (p_argile_call_7)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m = ((argile_match_t *)0);

    m = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if (!((m))) {
      continue;
    } //;
    if (((m)->type == ARGILE_MATCH_SUBCALL)) {
      private_vars(((m)->value).call);
    } else if (((m)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * c_2 = ((argile_cons_t *)0);

      c_2 = ((m)->value).cons;
      if (((c_2)->ctype == ARGILE_CONS_CODE)) {
        argile_code_gen_private_vars(((c_2)->cvalue).code);
      } //;
    } //;
  };
}

