// generated by: arc -uNMLP -o regex.c -H regex.h -m regex.argl.tmp regex.arg 
#include "regex.h"

#line 55 "regex.arg"
static void init_regex();
/** :init regex: -> nothing **/
#line 76 "regex.arg"
static void update_reggroups();
/** :update reggroups: -> nothing **/
#line 213 "regex.arg"
static char * expand_by(char *, char *);
/** :expand <text t> by <text by>: -> text **/
#line 264 "regex.arg"
static regex_t* compile(char *, char *);
/** :compile <text re> <text opts>: -> (regex) * **/
#line 58 "regex.arg"
static void pointer(regex_t*);
/** :<(regex) * re>: -> nothing **/
#line 185 "regex.arg"
static void * anything_nat(void *, unsigned int);
/** :<any p> <nat n>: -> anything **/

#line 46 "regex.arg"
regmatch_t( argrt_regex_matches[10]);
#line 53 "regex.arg"
char * argrt_regex_last = "";

#line 45 "regex.arg"
static char *( groups[10]);
#line 49 "regex.arg"
static unsigned char regex_inited = 0;
static argrt_hash_t * regexps;

#line 109 "regex.arg"
static char( buf[512]);

#line 55 "regex.arg"
static void init_regex()
/** :init regex: -> nothing **/
{
#line 56 "regex.arg"
  if (regex_inited) {
#line 476 "./std.argl"
    return;
  } //;
#line 57 "regex.arg"
  regexps = ((argrt_hash_t *)argrt_hash_new(512));
  ((argrt_hash_t *)regexps)->del = (void *)&pointer;
  memset(groups, 0, sizeof(groups));
  regex_inited = 1;
}

void argrt_regex_uninit()
/** :argrt_regex_uninit: -> nothing **/
{
#line 67 "regex.arg"
  int i = 0;

#line 64 "regex.arg"
  if (!(regex_inited)) {
#line 476 "./std.argl"
    return;
  } //;
#line 65 "regex.arg"
  argrt_hash_del(regexps);
  regexps = ((argrt_hash_t *)0);
  while ((i < 10)) {
#line 67 "regex.arg"
    if (!(((groups)[i] == NULL))) {
#line 476 "./std.argl"
      dbg_free((groups)[i]);
    } //;
#line 67 "regex.arg"
    (i)++;
  };
#line 68 "regex.arg"
  regex_inited = 0;
}

char * argrt_regex_group(unsigned int n)
/** :argrt_regex_group <nat n>: -> text **/
{
#line 72 "regex.arg"
  if (!(regex_inited)) {
#line 476 "./std.argl"
    init_regex();
  } //;
#line 73 "regex.arg"
  if (((n >= 10) || ((groups)[n] == NULL))) {
#line 476 "./std.argl"
    return "";
  } //;
#line 74 "regex.arg"
  return (groups)[n];
}

#line 76 "regex.arg"
static void update_reggroups()
/** :update reggroups: -> nothing **/
{
#line 77 "regex.arg"
  unsigned int n_2 = 0;

#line 77 "regex.arg"
  for (n_2 = 0; ((n_2 <= (10 - 1))); (n_2)++) {
    int so = 0;
    int eo = 0;
    char * g = "";
    int len = 0;

#line 78 "regex.arg"
    so = (argrt_regex_matches)[n_2].rm_so;
    eo = (argrt_regex_matches)[n_2].rm_eo;
    g = (groups)[n_2];
    len = strlen(argrt_regex_last);
    if (((((so == -1) || (eo == -1)) || (so == eo)) || (so >= len))) {
      g = ((char *)dbg_realloc(g, 1));
      *&(g)[0] = '\0';
      *&(groups)[n_2] = g;
      continue;
    } //;
#line 87 "regex.arg"
    if ((eo > len)) {
#line 476 "./std.argl"
      eo = len;
    } //;
#line 88 "regex.arg"
    len = (eo - so);
    g = ((char *)dbg_realloc((groups)[n_2], (len + 1)));
    memcpy(g, ((argrt_regex_last) + so), len);
    *&(g)[len] = '\0';
    *&(groups)[n_2] = g;
  };
}

#line 106 "regex.arg"
unsigned char argrt_regex_match(char * t, char * re, char * opts, unsigned char again)
/** :argrt_regex_match <text t> <text re> <text opts> <bool again>: -> bool **/
{
#line 111 "regex.arg"
  regex_t* cre;
#line 120 "regex.arg"
  int eflags = 0;
#line 124 "regex.arg"
  unsigned char r;

#line 107 "regex.arg"
  if (!(regex_inited)) {
#line 476 "./std.argl"
    init_regex();
  } //;
#line 108 "regex.arg"
  argrt_regex_last = t;
#line 110 "regex.arg"
  snprintf(((char *)buf), sizeof(buf), "%s/%s", opts, re);
  cre = ((regex_t*)argrt_hash_get((argrt_hash_t *)regexps, ((char *)buf)));
  if (((cre != NULL) && (strchr(opts, 'r') != NULL))) {
    (*((argrt_hash_t *)regexps)->del)(cre);
    cre = ((regex_t*)0);
  } //;
#line 115 "regex.arg"
  if ((cre == NULL)) {
    cre = compile(re, opts);
    if ((cre == NULL)) {
      return 0;
    } //;
#line 119 "regex.arg"
    *((regex_t* *)argrt_hash_get_set((argrt_hash_t *)regexps, ((char *)buf))) = cre;
  } //;
#line 121 "regex.arg"
  if (again) {
    eflags = (REG_NOTBOL | REG_NOTEOL);
  } //;
  r = (regexec(cre, t, 10, argrt_regex_matches, eflags) == 0);
  if (r) {
    update_reggroups();
  } //;
#line 127 "regex.arg"
  return r;
}

#line 183 "regex.arg"
int argrt_regex_replace(char * * t_2, int start, int end, char * by, void *(* realloc)(void *, ...))
/** :argrt_regex_replace <(text) & t> <int start> <int end> <text by> <code realloc>: -> int **/
{
  int remove = 0;
  int len = 0;
  char * expanded = "";
#line 191 "regex.arg"
  int bylen = 0;

#line 184 "regex.arg"
  if ((realloc == NULL)) {
    realloc = (void *(*)(void *, ...))&anything_nat;
  } //;
#line 186 "regex.arg"
  remove = (end - start);
  len = strlen(*t_2);
  expanded = expand_by(((*t_2) + (start - (argrt_regex_matches)[0].rm_so)), by);
  if ((expanded != NULL)) {
    by = expanded;
  } //;
#line 191 "regex.arg"
  bylen = strlen(by);
  if ((bylen > remove)) {
    int add = 0;
#line 197 "regex.arg"
    int i = 0;

#line 193 "regex.arg"
    add = (bylen - remove);
#line 195 "regex.arg"
    *t_2 = ((char *)(*realloc)(*t_2, (len + (1 + add))));
#line 198 "regex.arg"
    for (i = len; (i >= end); (i)--) {
      *&(*t_2)[(i + add)] = *&(*t_2)[i];
    };
  } //;
#line 200 "regex.arg"
  else {
    int sub = 0;

#line 201 "regex.arg"
    sub = (remove - bylen);
    if ((sub > 0)) {
#line 204 "regex.arg"
      int i = 0;

#line 205 "regex.arg"
      for (i = end; (i <= len); (i)++) {
        *&(*t_2)[(i - sub)] = *&(*t_2)[i];
      };
      *t_2 = ((char *)(*realloc)(*t_2, (len + (1 - sub))));
    } //;
  };
#line 209 "regex.arg"
  memcpy(((*t_2) + start), by, bylen);
  if (!((expanded == NULL))) {
#line 476 "./std.argl"
    dbg_free(expanded);
  } //;
#line 211 "regex.arg"
  return bylen;
}

#line 213 "regex.arg"
static char * expand_by(char * t_3, char * by_2)
/** :expand <text t> by <text by>: -> text **/
{
#line 215 "regex.arg"
  int i = 0;
#line 215 "regex.arg"
  int len = 0;
#line 215 "regex.arg"
  int refs = 0;
#line 215 "regex.arg"
  int escs = 0;
  unsigned char esc;
#line 239 "regex.arg"
  char * tmp = "";

#line 216 "regex.arg"
  esc = 0;
  while ((*&(by_2)[i] != 0)) {
    if (esc) {
      esc = 0;
      (escs)++;
      (len)++;
#line 221 "regex.arg"
      (i)++;
#line 221 "regex.arg"
      continue;
    } //;
#line 222 "regex.arg"
    if ((*&(by_2)[i] == '$')) {
      int n_2 = 0;

#line 223 "regex.arg"
      n_2 = (*&(by_2)[(i + 1)] - '0');
      if (((n_2 >= 0) && (n_2 < 10))) {
        int add = 0;

#line 225 "regex.arg"
        add = ((argrt_regex_matches)[n_2].rm_eo - (argrt_regex_matches)[n_2].rm_so);
        if ((add > 0)) {
#line 476 "./std.argl"
          len += add;
        } //;
#line 227 "regex.arg"
        (refs)++;
        (i)++;
      } //;
#line 229 "regex.arg"
      else {
        esc = 1;
      };
    } //;
#line 231 "regex.arg"
    else {
      (len)++;
    };
#line 233 "regex.arg"
    (i)++;
  };
#line 234 "regex.arg"
  if (esc) {
    (len)++;
  } //;
#line 236 "regex.arg"
  if (((refs == 0) && (escs == 0))) {
#line 476 "./std.argl"
    return (char *)0;
  } //;
#line 239 "regex.arg"
  tmp = ((char *)dbg_malloc((len + 1)));
  len = 0;
  esc = 0;
  for (i = 0; (*&(by_2)[i] != 0); (i)++) {
    if (esc) {
      esc = 0;
      *&(tmp)[(len)++] = *&(by_2)[i];
      continue;
    } //;
#line 247 "regex.arg"
    if ((*&(by_2)[i] == '$')) {
      int n_2 = 0;

#line 248 "regex.arg"
      n_2 = (*&(by_2)[(i + 1)] - '0');
      if (((n_2 >= 0) && (n_2 < 10))) {
        int add = 0;

#line 250 "regex.arg"
        add = ((argrt_regex_matches)[n_2].rm_eo - (argrt_regex_matches)[n_2].rm_so);
        if ((add > 0)) {
          memcpy(((tmp) + len), ((t_3) + (argrt_regex_matches)[n_2].rm_so), add);
          len += add;
        } //;
#line 254 "regex.arg"
        (i)++;
      } else {
        esc = 1;
      };
    } else {
#line 258 "regex.arg"
      *&(tmp)[(len)++] = *&(by_2)[i];
    };
  };
#line 259 "regex.arg"
  if (esc) {
    *&(tmp)[(len)++] = '$';
  } //;
#line 261 "regex.arg"
  *&(tmp)[len] = '\0';
  return tmp;
}

#line 264 "regex.arg"
static regex_t* compile(char * re_2, char * opts_2)
/** :compile <text re> <text opts>: -> (regex) * **/
{
#line 265 "regex.arg"
  regex_t* r;
#line 267 "regex.arg"
  int cflags = 0;
#line 274 "regex.arg"
  int er = 0;

#line 265 "regex.arg"
  r = ((regex_t*)dbg_malloc(sizeof(regex_t)));
  memset(r, 0, sizeof(*r));
#line 268 "regex.arg"
  if (!((strchr(opts_2, 'b') != NULL))) {
    cflags |= REG_EXTENDED;
  } //;
#line 270 "regex.arg"
  if ((strchr(opts_2, 'i') != NULL)) {
    cflags |= REG_ICASE;
  } //;
#line 272 "regex.arg"
  if ((strchr(opts_2, 'n') != NULL)) {
    cflags |= REG_NEWLINE;
  } //;
#line 274 "regex.arg"
  er = regcomp(r, re_2, cflags);
  if ((er != 0)) {
    char( buf_2[256]);

#line 277 "regex.arg"
    regerror(er, r, buf_2, sizeof(buf_2));
    fprintf(stderr, "regular expression : %s : %s\n", re_2, buf_2);
    regfree(r);
    dbg_free(r);
    return ((regex_t*)0);
  } //;
#line 282 "regex.arg"
  return r;
}

#line 58 "regex.arg"
static void pointer(regex_t* re_3)
/** :<(regex) * re>: -> nothing **/
{
#line 58 "regex.arg"
  regfree(re_3);
#line 58 "regex.arg"
  dbg_free(re_3);
}

#line 185 "regex.arg"
static void * anything_nat(void * p, unsigned int n_2)
/** :<any p> <nat n>: -> anything **/
{
#line 185 "regex.arg"
  return dbg_realloc(p, n_2);
}

