// generated by: arc -uRNMLP -A ../../libargile -A ../../argrt -o std_stresc.c -H std_stresc.h -m std_stresc.argl std_stresc.arg 
#include "std_stresc.h"

#line 74 "std_stresc.arg"
static int argile_buff_text_int(argile_buff_t *, char *, int);
/** :<buff out> <text buf> <int len>: -> int **/
#line 58 "std_stresc.arg"
static char _hex(int);
/** :_hex <int n>: -> byte **/

#line 25 "std_stresc.arg"
char( argmod_stresc_doc[]) = "Generate an escaped text string suitable for inclusion within a double\nquoted C string. Moreover, if the parameter evaluates to a word, it\nchanges non-ascii characters into hexadecimal sequence.\nSyntax requirements:\n  :<any>:\n";

#line 33 "std_stresc.arg"
void argmod_stresc_gencode(argile_call_t * p_argile_call)
/** :argmod_stresc_gencode <call>: -> nothing **/
{
#line 34 "std_stresc.arg"
  argile_shovel_t * sh = ((argile_shovel_t *)0);
  argile_match_t * m = ((argile_match_t *)0);
#line 39 "std_stresc.arg"
  argile_buff_t b = ((argile_buff_t){0});
#line 41 "std_stresc.arg"
  char * word = "";

#line 34 "std_stresc.arg"
  sh = argile_shovel_new(p_argile_call);
  m = argile_shovel_diganymatch(sh, 1, (char *)0);
  argile_shovel_del(sh);
#line 38 "std_stresc.arg"
  if ((m == NULL)) {
#line 470 "../../argrt/std.argl"
    return;
  } //;
#line 41 "std_stresc.arg"
  if (((argile).hexa_str && ((word = argile_match_eval_word(m))))) {
    unsigned char after_hex;
    char( hex[5]);
#line 45 "std_stresc.arg"
    int i = 0;
    char c;

#line 42 "std_stresc.arg"
    after_hex = 0;
#line 44 "std_stresc.arg"
    *&(hex)[0] = '\\';
#line 44 "std_stresc.arg"
    *&(hex)[1] = 'x';
#line 44 "std_stresc.arg"
    *&(hex)[4] = '\0';
#line 47 "std_stresc.arg"
    for (i = 0; (c = *&(word)[i]); (i)++) {
      if ((((c < ' ') || (c > '~')) || (after_hex && ((((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f'))) || ((c >= 'A') && (c <= 'F')))))) {
#line 56 "std_stresc.arg"
        *&(hex)[2] = _hex((c >> 4));
        *&(hex)[3] = _hex((c >> 0));
#line 64 "std_stresc.arg"
        argile_buff_puts(&b, ((char *)hex));
        after_hex = 1;
      } //;
#line 66 "std_stresc.arg"
      else {
        argile_buff_putc(&b, c);
        after_hex = 0;
      };
    };
#line 69 "std_stresc.arg"
    if (((b).ptr)) {
      argile_output((b).ptr, ((int)(b).len));
      argile_dbg_free((b).ptr);
    } //;
#line 72 "std_stresc.arg"
    return;
  } //;
  argile_push_output((void *)&argile_buff_text_int, &b);
#line 87 "std_stresc.arg"
  argile_match_gencode(m);
  argile_pop_output();
  if (((b).ptr)) {
    argile_output((b).ptr, ((int)(b).len));
    argile_dbg_free((b).ptr);
  } //;
}

#line 74 "std_stresc.arg"
static int argile_buff_text_int(argile_buff_t * out, char * buf, int len)
/** :<buff out> <text buf> <int len>: -> int **/
{
#line 75 "std_stresc.arg"
  int i = 0;

#line 76 "std_stresc.arg"
  while ((i < len)) {
    char c;

#line 77 "std_stresc.arg"
    switch ((c = *&(buf)[i])) {
      case '\n': {
#line 78 "std_stresc.arg"
        argile_buff_puts(out, "\\n");
      } break;
#line 79 "std_stresc.arg"
      case '\t': {
#line 79 "std_stresc.arg"
        argile_buff_puts(out, "\\t");
      } break;
#line 80 "std_stresc.arg"
      default: {
        if (((c == '\\') || (c == *&("\"")[0]))) {
          argile_buff_putc(out, '\\');
        } //;
#line 83 "std_stresc.arg"
        argile_buff_putc(out, c);
      } break;
    };
#line 84 "std_stresc.arg"
    (i)++;
  };
#line 85 "std_stresc.arg"
  return len;
}

#line 58 "std_stresc.arg"
static char _hex(int n)
/** :_hex <int n>: -> byte **/
{
#line 59 "std_stresc.arg"
  n &= 0xf;
  if ((n < 10)) {
    return (n + '0');
  } //;
#line 62 "std_stresc.arg"
  return (n + ('a' - 10));
}

