// generated by: arc -uRNMLP -A ./argrt -o syntax.c -H syntax.h -m syntax.argl syntax.arg 
#include "syntax.h"

#line 116 "syntax.arg"
static void syntax_string(argile_list_t *, argile_buff_t *, unsigned char, unsigned char);
/** :syntax string <list of (argile syntax) s> <buff> <bool in_enum> <bool in_list>: -> nothing **/
#line 273 "syntax.arg"
static void decode(argile_buff_t *, char *);
/** :decode <buff b> <text s>: -> nothing **/
#line 356 "syntax.arg"
static char * sub_gen_id(argile_syntax_t *, argile_code_t *, char *, int);
/** :sub gen id <argile syntax s> <argile code c> <text p> <int i>: -> text **/
#line 124 "syntax.arg"
static void escape(argile_buff_t *, char *, unsigned char, unsigned char);
/** :escape <buff b> <text s> <bool in_enum> <bool in_list>: -> nothing **/
#line 182 "syntax.arg"
static void get_words(argile_list_t *, argile_list_t * *);
/** :get words <list of (argile syntax) lsyn> <(list of (text)) & tail>: -> nothing **/
#line 209 "syntax.arg"
static void gen_no_word(argile_list_t *, argile_call_t *, argile_buff_t *);
/** :gen no word <list of (argile syntax) ls> <call maker> <buff b>: -> nothing **/
#line 332 "syntax.arg"
static void gen_options(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen options <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
#line 382 "syntax.arg"
static void gen_enums(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen enums <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
#line 418 "syntax.arg"
static void gen_lists(argile_list_t *, argile_code_t *, int *, unsigned char, unsigned char);
/** :gen lists <list of (argile syntax) syn> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
#line 589 "syntax.arg"
static void escape_2(argile_buff_t *, char *);
/** :escape <buff b> <text s>: -> nothing **/
#line 696 "syntax.arg"
static int compile_params(argile_list_t *, argile_code_t *, argile_call_t *, unsigned char);
/** :compile params <list of (argile syntax) lsyn> <argile code scope> <call> <bool in_list>: -> int **/
#line 737 "syntax.arg"
static unsigned char compile_init(argile_match_t *, argile_type_t, argile_code_t *, argile_call_t *);
/** :compile init <match> <argile type t> <argile code c> <call>: -> bool **/
#line 794 "syntax.arg"
static argile_list_t * syn_match(argile_list_t *, argile_list_t *);
/** :syn match <list of (argile syntax) ls> <list of (argile syntax) lp>: -> list of (argile syntax) **/
#line 841 "syntax.arg"
static void module_call(argile_list_t *, argile_buff_t *, char *, argile_list_t *, argile_buff_t *);
/** :module call <list of (argile syntax) ls> <buff bt> <text w> <list of (argile syntax) ls2> <buff out>: -> nothing **/
#line 879 "syntax.arg"
static unsigned char missing_param(argile_list_t *, char *, argile_list_t *);
/** :missing param <list of (argile syntax) ls> <text w> <list of (argile syntax) ls2>: -> bool **/

#line 243 "syntax.arg"
static char *( _opnames[94]) = {"exclam", "doublequote", "sharp", "dollar", "percent", "ampersand", "quote", "", "", "star", "plus", "comma", "dash", "dot", "slash", "", "", "", "", "", "", "", "", "", "", "colon", "semicolon", "inferior", "equal", "superior", "question", "at", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "opensquare", "backslash", "closesquare", "carret", "underscore", "backquote", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "openbrace", "pipe", "closebrace", "tilde"};
#line 257 "syntax.arg"
static char *( _opshorts[94]) = {"ex", "dq", "sh", "do", "pe", "am", "sq", "", "", "st", "pl", "cm", "da", "dt", "sl", "", "", "", "", "", "", "", "", "", "", "cl", "se", "in", "eq", "su", "qu", "at", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "os", "bs", "cs", "ca", "un", "bq", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "ob", "pi", "cb", "ti"};

#line 274 "syntax.arg"
static char * chex = "0123456789abcdef";

#line 78 "syntax.arg"
argile_syntax_t * argile_syntax_new(argile_syn_type_t t, void * data)
/** :argile_syntax_new <syn type t> <any data>: -> argile syntax **/
{
#line 79 "syntax.arg"
  argile_syntax_t * syn = ((argile_syntax_t *)0);

#line 79 "syntax.arg"
  syn = ((argile_syntax_t *)memset(argile_dbg_malloc(sizeof(argile_syntax_t)), 0, sizeof(argile_syntax_t)));
  (syn)->type = t;
  ((syn)->value).data = data;
  return syn;
}

#line 89 "syntax.arg"
void argile_syntax_del(argile_syntax_t * s)
/** :argile_syntax_del <argile syntax s>: -> nothing **/
{
#line 90 "syntax.arg"
  switch ((s)->type) {
    case ARGILE_SYN_WORD: ;
    case ARGILE_SYN_OP: {
      argile_dbg_free(((s)->value).data);
    } break;
#line 94 "syntax.arg"
    case ARGILE_SYN_PARAM: {
      argile_syn_param_del(((s)->value).syn_param);
    } break;
#line 96 "syntax.arg"
    case ARGILE_SYN_OPTION: {
      argile_list_del(((s)->value).syn_option);
    } break;
#line 98 "syntax.arg"
    case ARGILE_SYN_ENUM: {
      argile_list_del(((s)->value).syn_enum);
    } break;
#line 100 "syntax.arg"
    case ARGILE_SYN_LIST: {
      argile_syn_list_del(((s)->value).syn_list);
    } break;
#line 102 "syntax.arg"
    default: {} break;
  };
#line 103 "syntax.arg"
  if (((s)->genid)) {
    argile_dbg_free((s)->genid);
  } //;
#line 105 "syntax.arg"
  argile_dbg_free(s);
}

#line 113 "syntax.arg"
void argile_syntax_string(argile_list_t * s_2, argile_buff_t * buf)
/** :argile_syntax_string <list of (argile syntax) s> <buff buf>: -> nothing **/
{
#line 114 "syntax.arg"
  syntax_string(s_2, buf, 0, 0);
}

#line 116 "syntax.arg"
static void syntax_string(argile_list_t * s_3, argile_buff_t * p_argile_buff, unsigned char in_enum, unsigned char in_list)
/** :syntax string <list of (argile syntax) s> <buff> <bool in_enum> <bool in_list>: -> nothing **/
{
#line 117 "syntax.arg"
  for (; (s_3); s_3 = ((argile_list_t *)s_3)->next) {
    argile_syntax_t * syn = ((argile_syntax_t *)0);

#line 118 "syntax.arg"
    syn = *((argile_syntax_t * *)&((argile_list_t *)s_3)->data);
    switch ((syn)->type) {
      case ARGILE_SYN_WORD: {
        argile_buff_puts(p_argile_buff, ((syn)->value).syn_word);
      } break;
#line 122 "syntax.arg"
      case ARGILE_SYN_OP: {
        escape(p_argile_buff, ((syn)->value).syn_op, in_enum, in_list);
      } break;
#line 139 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        argile_syn_param_string(((syn)->value).syn_param, p_argile_buff);
      } break;
#line 141 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        argile_buff_putc(p_argile_buff, *&("(")[0]);
        syntax_string(((syn)->value).syn_option, p_argile_buff, 0, 0);
        argile_buff_putc(p_argile_buff, *&(")")[0]);
      } break;
#line 145 "syntax.arg"
      case ARGILE_SYN_ENUM: {
#line 147 "syntax.arg"
        argile_list_t * cur;

#line 146 "syntax.arg"
        argile_buff_putc(p_argile_buff, *&("{")[0]);
        cur = ((syn)->value).syn_enum;
        for (; (cur); cur = ((argile_list_t *)cur)->next) {
          syntax_string(*((argile_list_t * *)&((argile_list_t *)cur)->data), p_argile_buff, 1, 0);
          if ((((argile_list_t *)cur)->next)) {
            argile_buff_puts(p_argile_buff, " | ");
          } //;
        };
#line 152 "syntax.arg"
        argile_buff_putc(p_argile_buff, *&("}")[0]);
      } break;
#line 153 "syntax.arg"
      case ARGILE_SYN_LIST: {
        argile_syn_list_string(((syn)->value).syn_list, p_argile_buff);
      } break;
#line 155 "syntax.arg"
      default: {
        argile_buff_puts(p_argile_buff, "(: bad syntax type ");
        argile_buff_putn(p_argile_buff, ((int)(syn)->type));
        argile_buff_puts(p_argile_buff, " :)");
      } break;
    };
#line 159 "syntax.arg"
    if ((((argile_list_t *)s_3)->next)) {
#line 159 "syntax.arg"
      argile_buff_putc(p_argile_buff, ' ');
    } //;
  };
}

#line 170 "syntax.arg"
void argile_syntax_gen_id(argile_list_t * s_4, argile_call_t * maker, argile_buff_t * buf_2)
/** :argile_syntax_gen_id <list of (argile syntax) s> <call maker> <buff buf>: -> nothing **/
{
#line 180 "syntax.arg"
  argile_list_t * words = ((argile_list_t *)0);

#line 171 "syntax.arg"
  if ((s_4 == NULL)) {
    argile_buff_puts(buf_2, "anonymous");
    if ((maker)) {
      argile_buff_putc(buf_2, '_');
      argile_buff_putn(buf_2, (((maker)->loc).start).row);
      argile_buff_putc(buf_2, '_');
      argile_buff_putn(buf_2, (((maker)->loc).end).row);
      argile_buff_putc(buf_2, '_');
    } //;
#line 179 "syntax.arg"
    return;
  } //;
#line 181 "syntax.arg"
  get_words(s_4, &words);
#line 198 "syntax.arg"
  if ((words)) {
    for (words = argile_list_start(words); (((argile_list_t *)words)->next); words = ((argile_list_t *)words)->next) {
      decode(buf_2, *((char * *)&((argile_list_t *)words)->data));
      argile_buff_putc(buf_2, '_');
    };
#line 202 "syntax.arg"
    decode(buf_2, *((char * *)&((argile_list_t *)words)->data));
    argile_list_del(words);
  } //;
#line 204 "syntax.arg"
  else {
#line 206 "syntax.arg"
    unsigned int i = 0;

#line 205 "syntax.arg"
    gen_no_word(s_4, maker, buf_2);
    i = (buf_2)->len;
    while (((i != 0) && (*&((buf_2)->ptr)[(i - 1)] == '_'))) {
#line 207 "syntax.arg"
      (i)--;
    };
#line 208 "syntax.arg"
    (buf_2)->len = i;
  };
}

#line 273 "syntax.arg"
static void decode(argile_buff_t * b, char * s_5)
/** :decode <buff b> <text s>: -> nothing **/
{
#line 276 "syntax.arg"
  while ((*&(s_5)[0] != 0)) {
    if (((*&(s_5)[0] & 128) != 0)) {
      argile_buff_puts(b, "_x");
      while (((*&(s_5)[0] & 128) != 0)) {
        argile_buff_putc(b, *&(chex)[((*&(s_5)[0] >> 4) & 0xf)]);
        argile_buff_putc(b, *&(chex)[(*&(s_5)[0] & 0xf)]);
        (s_5)++;
      };
#line 283 "syntax.arg"
      argile_buff_putc(b, '_');
    } //;
#line 284 "syntax.arg"
    else {
      argile_buff_putc(b, *&((s_5)++)[0]);
    };
  };
}

#line 294 "syntax.arg"
void argile_syntax_gen_params(argile_list_t * syn, int names, int * param)
/** :argile_syntax_gen_params <list of (argile syntax) syn> <int names> <(int) & param>: -> nothing **/
{
#line 295 "syntax.arg"
  int* pparam;
#line 295 "syntax.arg"
  int dummy = 0;

#line 295 "syntax.arg"
  pparam = &*param;
  if ((pparam == NULL)) {
#line 296 "syntax.arg"
    pparam = &dummy;
  } //;
#line 297 "syntax.arg"
  for (; (syn); syn = ((argile_list_t *)syn)->next) {
    argile_syntax_t * s_2 = ((argile_syntax_t *)0);

#line 298 "syntax.arg"
    s_2 = *((argile_syntax_t * *)&((argile_list_t *)syn)->data);
    switch ((s_2)->type) {
#line 301 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        argile_type_t t_2;

#line 302 "syntax.arg"
        t_2 = (((s_2)->value).syn_param)->type;
        if (((*pparam)++ != 0)) {
#line 470 "./argrt/std.argl"
          argile_puts(", ");
        } //;
#line 304 "syntax.arg"
        argile_type_gen_prefix(t_2);
        if ((names != 0)) {
#line 470 "./argrt/std.argl"
          argile_puts(" ");
        } //;
#line 306 "syntax.arg"
        if ((((s_2)->value).syn_param)->in_list) {
#line 470 "./argrt/std.argl"
          argile_ref(1);
        } //;
#line 307 "syntax.arg"
        if ((names != 0)) {
#line 470 "./argrt/std.argl"
          argile_puts(argile_syn_param_gen_id(((s_2)->value).syn_param));
        } //;
#line 308 "syntax.arg"
        argile_type_gen_suffix(t_2);
      } break;
#line 309 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        argile_syntax_gen_params(((s_2)->value).syn_option, ((int)(names != 0)), pparam);
      } break;
#line 311 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

#line 312 "syntax.arg"
        e = ((s_2)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          argile_syntax_gen_params(*((argile_list_t * *)&((argile_list_t *)e)->data), ((int)(names != 0)), pparam);
        };
      } break;
#line 315 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if ((((s_2)->value).syn_list)->pseudoempty) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 317 "syntax.arg"
        argile_syntax_gen_params((((s_2)->value).syn_list)->sub, ((int)(names != 0)), pparam);
      } break;
#line 318 "syntax.arg"
      default: {} break;
    };
  };
}

#line 327 "syntax.arg"
void argile_syntax_gen_options(argile_list_t * s_6, argile_code_t * body, int * param_2)
/** :argile_syntax_gen_options <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
#line 329 "syntax.arg"
  int num = 0;

#line 330 "syntax.arg"
  gen_options(s_6, body, &num, ((&*param_2) && (*param_2)), 0);
  *param_2 += num;
}

#line 356 "syntax.arg"
static char * sub_gen_id(argile_syntax_t * s_7, argile_code_t * c, char * p, int i)
/** :sub gen id <argile syntax s> <argile code c> <text p> <int i>: -> text **/
{
#line 357 "syntax.arg"
  if (((s_7)->genid == NULL)) {
    argile_buff_t b_2 = ((argile_buff_t){0});

#line 359 "syntax.arg"
    argile_buff_puts(&b_2, p);
    argile_buff_putn(&b_2, i);
    argile_buff_putc(&b_2, '\0');
    if ((c)) {
#line 364 "syntax.arg"
      argile_check_local_collisions(&b_2, c);
      argile_list_prepend(&(c)->special_ids, argile_list_new((b_2).ptr, ((argile_deleter_t)0)));
    } //;
#line 366 "syntax.arg"
    (s_7)->genid = (b_2).ptr;
  } //;
#line 367 "syntax.arg"
  return (s_7)->genid;
}

#line 377 "syntax.arg"
void argile_syntax_gen_enums(argile_list_t * s_8, argile_code_t * body_2, int * param_3)
/** :argile_syntax_gen_enums <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
#line 379 "syntax.arg"
  int num = 0;

#line 380 "syntax.arg"
  gen_enums(s_8, body_2, &num, ((&*param_3) && (*param_3)), 0);
  *param_3 += num;
}

#line 413 "syntax.arg"
void argile_syntax_gen_lists(argile_list_t * s_9, argile_code_t * body_3, int * param_4)
/** :argile_syntax_gen_lists <list of (argile syntax) s> <argile code body> <(int) & param>: -> nothing **/
{
#line 415 "syntax.arg"
  int num = 0;

#line 416 "syntax.arg"
  gen_lists(s_9, body_3, &num, ((&*param_4) && (*param_4)), 0);
  *param_4 += num;
}

#line 448 "syntax.arg"
void argile_syntax_gen_call(argile_list_t * s_10, argile_buff_t * buf_3)
/** :argile_syntax_gen_call <list of (argile syntax) s> <buff buf>: -> nothing **/
{
#line 449 "syntax.arg"
  for (; (s_10); s_10 = ((argile_list_t *)s_10)->next) {
    argile_syntax_t * s_9 = ((argile_syntax_t *)0);

#line 450 "syntax.arg"
    s_9 = *((argile_syntax_t * *)&((argile_list_t *)s_10)->data);
    switch ((s_9)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        argile_buff_puts(buf_3, ((s_9)->value).syn_word);
        argile_buff_putc(buf_3, ' ');
      } break;
#line 456 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        if (((((s_9)->value).syn_param)->type == ARGILE_TYPE_WORD)) {
          argile_buff_puts(buf_3, "_word_ ");
        } //;
#line 459 "syntax.arg"
        else {
          argile_buff_puts(buf_3, "(nil) ");
        };
      } break;
#line 461 "syntax.arg"
      case ARGILE_SYN_OPTION: {
#line 463 "syntax.arg"
        argile_syntax_gen_call(((s_9)->value).syn_option, buf_3);
      } break;
#line 464 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_syntax_gen_call(*((argile_list_t * *)&((argile_list_t *)((s_9)->value).syn_enum)->data), buf_3);
      } break;
#line 466 "syntax.arg"
      case ARGILE_SYN_LIST: {
        argile_syn_list_t * sl = ((argile_syn_list_t *)0);
#line 467 "syntax.arg"
        int i_2 = 0;

#line 467 "syntax.arg"
        sl = ((s_9)->value).syn_list;
        for (i_2 = 0; (i_2 < (sl)->min); (i_2)++) {
          argile_syntax_gen_call((sl)->sub, buf_3);
        };
      } break;
#line 470 "syntax.arg"
      default: {} break;
    };
  };
}

#line 478 "syntax.arg"
int argile_syntax_check_format(char * str)
/** :argile_syntax_check_format <text str>: -> int **/
{
#line 480 "syntax.arg"
  if ((*&(str)[0] != *&(":")[0])) {
    return 0;
  } //;
#line 484 "syntax.arg"
  (str)++;
  while (((*&(str)[0] != 0) && (*&(str)[0] != *&(":")[0]))) {
    (str)++;
  };
#line 489 "syntax.arg"
  if ((*&(str)[0] == 0)) {
    return 0;
  } //;
#line 491 "syntax.arg"
  (str)++;
  if ((*&(str)[0] != 0)) {
    return 0;
  } //;
  return 1;
}

#line 502 "syntax.arg"
argile_list_t * argile_syntax_parse(char * str_2)
/** :argile_syntax_parse <text str>: -> list of (argile syntax) **/
{
#line 511 "syntax.arg"
  argile_code_t * oldmain = ((argile_code_t *)0);
  argile_inout_t oldinput;
  char * oldname = "";
  unsigned char oldcmt;
  int oldnumcalls = 0;
#line 523 "syntax.arg"
  char * ptr = "";
  argile_list_t * syn_2 = ((argile_list_t *)0);

#line 506 "syntax.arg"
  if (!((argile_syntax_check_format(str_2)))) {
    argile_die("\"%s\" is invalid syntax string", str_2);
    return ((argile_list_t *)0);
  } //;
#line 511 "syntax.arg"
  oldmain = (argile).main;
  oldinput = (argile).input;
  oldname = (argile).input_name;
  oldcmt = (argile).get_comments;
  oldnumcalls = (argile).numcalls;
#line 519 "syntax.arg"
  (argile).input = (void *)&argile_input_string;
  (argile).input_name = "syntax string";
  (argile).get_comments = 0;
  (argile).main = argile_code_new(oldmain, ((argile_list_t *)0));
  ptr = str_2;
#line 528 "syntax.arg"
  if ((((!((argile_parse(&ptr) != 0)) && ((argile).main)) && (((argile).main)->calls)) && !((((argile_list_t *)((argile).main)->calls)->next)))) {
    argile_call_t * call = ((argile_call_t *)0);

#line 529 "syntax.arg"
    call = *((argile_call_t * *)&((argile_list_t *)((argile).main)->calls)->data);
    if ((((call)->match) && !((((argile_list_t *)(call)->match)->next)))) {
      argile_match_t * match = ((argile_match_t *)0);

#line 531 "syntax.arg"
      match = *((argile_match_t * *)&((argile_list_t *)(call)->match)->data);
      if (((match)->type == ARGILE_MATCH_CONS)) {
#line 534 "syntax.arg"
        argile_cons_t * cons = ((argile_cons_t *)0);

#line 534 "syntax.arg"
        cons = (match)->value.cons;
        if (((cons)->ctype == ARGILE_CONS_SYNTAX)) {
          syn_2 = ((cons)->cvalue).syntax;
          ((cons)->cvalue).syntax = ((argile_list_t *)0);
        } //;
      } //;
    } //;
  } //;
#line 540 "syntax.arg"
  argile_code_del((argile).main);
  (argile).main = oldmain;
  (argile).input = oldinput;
  (argile).input_name = oldname;
  (argile).get_comments = oldcmt;
  (argile).numcalls = oldnumcalls;
#line 547 "syntax.arg"
  if ((syn_2 == NULL)) {
    argile_die("\"%s\": not correctly parsed", str_2);
  } //;
#line 549 "syntax.arg"
  return syn_2;
}

#line 557 "syntax.arg"
argile_syn_param_t * argile_syn_param_new(argile_list_t * call, argile_match_t * init)
/** :argile_syn_param_new <list of (match) call> <match init>: -> (argile) syn param **/
{
#line 558 "syntax.arg"
  argile_syn_param_t * p_2 = ((argile_syn_param_t *)0);

#line 558 "syntax.arg"
  p_2 = ((argile_syn_param_t *)memset(argile_dbg_malloc(sizeof(argile_syn_param_t)), 0, sizeof(argile_syn_param_t)));
  (p_2)->match = call;
  (p_2)->init = init;
  return p_2;
}

#line 568 "syntax.arg"
void argile_syn_param_del(argile_syn_param_t * s_11)
/** :argile_syn_param_del <syn param s>: -> nothing **/
{
#line 569 "syntax.arg"
  if (!(((s_11)->name == NULL))) {
#line 470 "./argrt/std.argl"
    argile_dbg_free((s_11)->name);
  } //;
#line 570 "syntax.arg"
  if (!(((s_11)->genid == NULL))) {
#line 470 "./argrt/std.argl"
    argile_dbg_free((s_11)->genid);
  } //;
#line 571 "syntax.arg"
  argile_list_del((s_11)->match);
  if (!(((s_11)->init == NULL))) {
#line 470 "./argrt/std.argl"
    argile_match_del((s_11)->init);
  } //;
#line 573 "syntax.arg"
  argile_dbg_free(s_11);
}

#line 580 "syntax.arg"
void argile_syn_param_string(argile_syn_param_t * s_12, argile_buff_t * buf_4)
/** :argile_syn_param_string <syn param s> <buff buf>: -> nothing **/
{
#line 582 "syntax.arg"
  unsigned char old;
#line 585 "syntax.arg"
  argile_list_t * lm;

#line 582 "syntax.arg"
  old = (argile).skip_codes;
  (argile).skip_codes = 1;
  argile_buff_putc(buf_4, '<');
  for (lm = (s_12)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    if ((*((argile_match_t * *)&((argile_list_t *)lm)->data) == NULL)) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 587 "syntax.arg"
    if (((*((argile_match_t * *)&((argile_list_t *)lm)->data))->type == ARGILE_MATCH_OP)) {
      escape_2(buf_4, ((*((argile_match_t * *)&((argile_list_t *)lm)->data))->value).op);
    } //;
#line 600 "syntax.arg"
    else {
      argile_match_string(*((argile_match_t * *)&((argile_list_t *)lm)->data), 0, buf_4, 0);
    };
#line 602 "syntax.arg"
    if ((((argile_list_t *)lm)->next != NULL)) {
#line 470 "./argrt/std.argl"
      argile_buff_putc(buf_4, ' ');
    } //;
  };
#line 603 "syntax.arg"
  if (((s_12)->name)) {
    argile_buff_putc(buf_4, ' ');
    argile_buff_puts(buf_4, (s_12)->name);
  } //;
#line 606 "syntax.arg"
  if (((s_12)->init)) {
    argile_buff_puts(buf_4, " = ");
    argile_match_string((s_12)->init, 0, buf_4, 0);
  } //;
#line 609 "syntax.arg"
  argile_buff_putc(buf_4, '>');
  (argile).skip_codes = old;
}

#line 617 "syntax.arg"
char * argile_syn_param_gen_id(argile_syn_param_t * s_13)
/** :argile_syn_param_gen_id <syn param s>: -> text **/
{
#line 618 "syntax.arg"
  if (((s_13)->genid == NULL)) {
    argile_buff_t b_2 = ((argile_buff_t){0});

#line 620 "syntax.arg"
    if (((s_13)->name)) {
      decode(&b_2, (s_13)->name);
    } //;
#line 622 "syntax.arg"
    else {
      argile_buff_puts(&b_2, "p_");
      argile_type_gen_id_part((s_13)->type, ((argile_call_t *)0), &b_2);
    };
#line 625 "syntax.arg"
    argile_buff_putc(&b_2, '\0');
#line 627 "syntax.arg"
    if (((s_13)->def)) {
      argile_check_local_collisions(&b_2, ((s_13)->def)->scope);
      argile_check_collisions(&b_2);
    } //;
#line 630 "syntax.arg"
    else {
      argile_check_collisions(&b_2);
    };
#line 632 "syntax.arg"
    (s_13)->genid = (b_2).ptr;
  } //;
#line 633 "syntax.arg"
  return (s_13)->genid;
}

#line 645 "syntax.arg"
argile_syn_list_t * argile_syn_list_new(argile_list_t * sub, int min, int max)
/** :argile_syn_list_new <list of (argile syntax) sub> <int min> <int max>: -> (argile) syn list **/
{
#line 646 "syntax.arg"
  argile_syn_list_t * s_2 = ((argile_syn_list_t *)0);

#line 646 "syntax.arg"
  s_2 = ((argile_syn_list_t *)memset(argile_dbg_malloc(sizeof(argile_syn_list_t)), 0, sizeof(argile_syn_list_t)));
  (s_2)->sub = sub;
  (s_2)->min = min;
  (s_2)->max = max;
  return s_2;
}

#line 657 "syntax.arg"
void argile_syn_list_del(argile_syn_list_t * s_14)
/** :argile_syn_list_del <syn list s>: -> nothing **/
{
#line 658 "syntax.arg"
  argile_list_del((s_14)->sub);
  argile_dbg_free(s_14);
}

#line 666 "syntax.arg"
void argile_syn_list_string(argile_syn_list_t * s_15, argile_buff_t * buf_5)
/** :argile_syn_list_string <syn list s> <buff buf>: -> nothing **/
{
#line 667 "syntax.arg"
  argile_buff_putc(buf_5, '[');
  if (!((s_15)->pseudoempty)) {
    syntax_string((s_15)->sub, buf_5, 0, 1);
    argile_buff_putc(buf_5, ' ');
  } //;
#line 671 "syntax.arg"
  argile_buff_puts(buf_5, "...");
  if ((((s_15)->min != 0) || ((s_15)->max != 0))) {
    argile_buff_putc(buf_5, ' ');
    if (((s_15)->min != 0)) {
      argile_buff_putn(buf_5, (s_15)->min);
      if (((s_15)->max != (s_15)->min)) {
        argile_buff_putc(buf_5, ',');
        if (((s_15)->max != 0)) {
          argile_buff_putn(buf_5, (s_15)->max);
        } //;
      } //;
    } //;
#line 680 "syntax.arg"
    else {
      argile_buff_puts(buf_5, "0,");
      argile_buff_putn(buf_5, (s_15)->max);
    };
  } //;
#line 683 "syntax.arg"
  argile_buff_putc(buf_5, ']');
}

#line 694 "syntax.arg"
int argile_syntax_compile_params(argile_list_t * syntax, argile_code_t * scope, argile_call_t * p_argile_call)
/** :argile_syntax_compile_params <list of (argile syntax) syntax> <argile code scope> <call>: -> int **/
{
#line 769 "syntax.arg"
  return compile_params(syntax, scope, p_argile_call, 0);
}

#line 776 "syntax.arg"
int argile_syntax_is_terminal(argile_list_t * syn_2)
/** :argile_syntax_is_terminal <list of (argile syntax) syn>: -> int **/
{
#line 777 "syntax.arg"
  for (; (syn_2); syn_2 = ((argile_list_t *)syn_2)->next) {
    argile_syntax_t * s_2 = ((argile_syntax_t *)0);

#line 778 "syntax.arg"
    s_2 = *((argile_syntax_t * *)&((argile_list_t *)syn_2)->data);
    if (((s_2)->type == ARGILE_SYN_OPTION)) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 780 "syntax.arg"
    if ((((s_2)->type == ARGILE_SYN_LIST) && ((((s_2)->value).syn_list)->min == 0))) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 781 "syntax.arg"
    return 0;
  };
#line 782 "syntax.arg"
  return 1;
}

#line 792 "syntax.arg"
int argile_syntax_match(argile_list_t * syntax_2, argile_list_t * syn_pattern)
/** :argile_syntax_match <list of (argile syntax) syntax> <list of (argile syntax) syn_pattern>: -> int **/
{
#line 818 "syntax.arg"
  if ((syn_match(syntax_2, syn_pattern) == NULL)) {
    return 1;
  } //;
#line 820 "syntax.arg"
  return 0;
}

#line 836 "syntax.arg"
void argile_syntax_module_call(argile_list_t * syntax_3, argile_buff_t * type_bp, char * word_p, argile_list_t * syntax_p, argile_buff_t * out)
/** :argile_syntax_module_call <list of (argile syntax) syntax> <buff type_bp> <text word_p> <list of (argile syntax) syntax_p> <buff out>: -> nothing **/
{
#line 838 "syntax.arg"
  module_call(syntax_3, type_bp, word_p, syntax_p, out);
  if ((((out)->len > 0) && (*&((out)->ptr)[((out)->len - 1)] == ' '))) {
    ((out)->len)--;
  } //;
#line 841 "syntax.arg"
}

#line 921 "syntax.arg"
unsigned char argile_syntax_find_autoparams(argile_list_t * syn_3)
/** :argile_syntax_find_autoparams <list of (argile syntax) syn>: -> bool **/
{
#line 922 "syntax.arg"
  unsigned char found;

#line 922 "syntax.arg"
  found = 0;
  for (; (syn_3); syn_3 = ((argile_list_t *)syn_3)->next) {
    argile_syntax_t * s_2 = ((argile_syntax_t *)0);

#line 924 "syntax.arg"
    s_2 = *((argile_syntax_t * *)&((argile_list_t *)syn_3)->data);
    switch ((s_2)->type) {
      case ARGILE_SYN_PARAM: {
        argile_match_t * init_2 = ((argile_match_t *)0);

#line 927 "syntax.arg"
        init_2 = (((s_2)->value).syn_param)->init;
        if ((init_2 != NULL)) {
          if (argile_match_find_autoparams(init_2)) {
            found = 1;
          } //;
        } //;
      } break;
#line 931 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        if (argile_syntax_find_autoparams(((s_2)->value).syn_option)) {
          found = 1;
        } //;
      } break;
#line 934 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

#line 935 "syntax.arg"
        le = ((s_2)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          if (argile_syntax_find_autoparams(*((argile_list_t * *)&((argile_list_t *)le)->data))) {
            found = 1;
          } //;
        };
      } break;
#line 939 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if (argile_syntax_find_autoparams((((s_2)->value).syn_list)->sub)) {
          found = 1;
        } //;
      } break;
#line 942 "syntax.arg"
      default: {} break;
    };
  };
#line 943 "syntax.arg"
  return found;
}

#line 124 "syntax.arg"
static void escape(argile_buff_t * b_2, char * s_16, unsigned char in_enum_2, unsigned char in_list_2)
/** :escape <buff b> <text s> <bool in_enum> <bool in_list>: -> nothing **/
{
#line 125 "syntax.arg"
  while ((*&(s_16)[0])) {
    switch (*&(s_16)[0]) {
      case '\\': ;
      case '<': ;
      case '[': {
        argile_buff_putc(b_2, '\\');
      } break;
#line 131 "syntax.arg"
      case ']': {
        if (in_list_2) {
#line 470 "./argrt/std.argl"
          argile_buff_putc(b_2, '\\');
        } //;
      } break;
#line 133 "syntax.arg"
      case '|': {
        if (in_enum_2) {
#line 470 "./argrt/std.argl"
          argile_buff_putc(b_2, '\\');
        } //;
      } break;
#line 135 "syntax.arg"
      default: {} break;
    };
#line 136 "syntax.arg"
    argile_buff_putc(b_2, *&(s_16)[0]);
    (s_16)++;
  };
}

#line 182 "syntax.arg"
static void get_words(argile_list_t * lsyn, argile_list_t * * tail)
/** :get words <list of (argile syntax) lsyn> <(list of (text)) & tail>: -> nothing **/
{
#line 183 "syntax.arg"
  for (; (lsyn); lsyn = ((argile_list_t *)lsyn)->next) {
    argile_syntax_t * s_3 = ((argile_syntax_t *)0);

#line 184 "syntax.arg"
    s_3 = *((argile_syntax_t * *)&((argile_list_t *)lsyn)->data);
    switch ((s_3)->type) {
      case ARGILE_SYN_WORD: {
        argile_list_append(tail, argile_list_new(((s_3)->value).syn_word, ((argile_deleter_t)0)));
      } break;
#line 188 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        get_words(((s_3)->value).syn_option, tail);
      } break;
#line 190 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

#line 191 "syntax.arg"
        e = ((s_3)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          get_words(*((argile_list_t * *)&((argile_list_t *)e)->data), tail);
        };
      } break;
#line 194 "syntax.arg"
      case ARGILE_SYN_LIST: {
        get_words((((s_3)->value).syn_list)->sub, tail);
      } break;
#line 196 "syntax.arg"
      default: {} break;
    };
  };
}

#line 209 "syntax.arg"
static void gen_no_word(argile_list_t * ls, argile_call_t * maker_2, argile_buff_t * b_3)
/** :gen no word <list of (argile syntax) ls> <call maker> <buff b>: -> nothing **/
{
#line 210 "syntax.arg"
  for (; (ls); ls = ((argile_list_t *)ls)->next) {
    argile_syntax_t * s_3 = ((argile_syntax_t *)0);

#line 211 "syntax.arg"
    s_3 = *((argile_syntax_t * *)&((argile_list_t *)ls)->data);
    switch ((s_3)->type) {
      case ARGILE_SYN_OP: {
        unsigned char ok;
        char * str_2 = "";

#line 214 "syntax.arg"
        ok = 0;
        str_2 = ((s_3)->value).syn_op;
        while ((*&(str_2)[0])) {
          if (((*&(str_2)[0] >= '!') && (*&(str_2)[0] <= '~'))) {
            if (0) {
              argile_buff_puts(b_3, (_opnames)[(*&(str_2)[0] - '!')]);
            } //;
#line 220 "syntax.arg"
            else {
              argile_buff_puts(b_3, (_opshorts)[(*&(str_2)[0] - '!')]);
            };
#line 222 "syntax.arg"
            ok = 1;
          } //;
#line 223 "syntax.arg"
          (str_2)++;
        };
#line 224 "syntax.arg"
        if (!(ok)) {
          decode(b_3, ((s_3)->value).syn_op);
          ok = 1;
        } //;
#line 227 "syntax.arg"
        if (ok) {
#line 470 "./argrt/std.argl"
          argile_buff_putc(b_3, '_');
        } //;
      } break;
#line 228 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        argile_type_gen_id_part((((s_3)->value).syn_param)->type, maker_2, b_3);
        argile_buff_putc(b_3, '_');
      } break;
#line 231 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        gen_no_word(((s_3)->value).syn_option, maker_2, b_3);
      } break;
#line 233 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

#line 234 "syntax.arg"
        le = ((s_3)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          gen_no_word(*((argile_list_t * *)&((argile_list_t *)le)->data), maker_2, b_3);
        };
      } break;
#line 237 "syntax.arg"
      case ARGILE_SYN_LIST: {
        gen_no_word((((s_3)->value).syn_list)->sub, maker_2, b_3);
      } break;
#line 239 "syntax.arg"
      default: {} break;
    };
  };
}

#line 332 "syntax.arg"
static void gen_options(argile_list_t * syntax_4, argile_code_t * body_4, int * num_2, unsigned char comma, unsigned char in_list_3)
/** :gen options <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
#line 334 "syntax.arg"
  for (; (syntax_4); syntax_4 = ((argile_list_t *)syntax_4)->next) {
    argile_syntax_t * s_5 = ((argile_syntax_t *)0);

#line 335 "syntax.arg"
    s_5 = *((argile_syntax_t * *)&((argile_list_t *)syntax_4)->data);
    switch ((s_5)->type) {
#line 338 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        if ((comma || (*num_2 != 0))) {
          argile_puts(", ");
        } //;
#line 341 "syntax.arg"
        argile_puts("char ");
        if (in_list_3) {
#line 470 "./argrt/std.argl"
          argile_ref(1);
        } //;
#line 343 "syntax.arg"
        argile_puts(sub_gen_id(s_5, body_4, "opt", ++(*num_2)));
        comma = 1;
        gen_options(((s_5)->value).syn_option, body_4, num_2, comma, in_list_3);
      } break;
#line 346 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

#line 347 "syntax.arg"
        e = ((s_5)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_options(*((argile_list_t * *)&((argile_list_t *)e)->data), body_4, num_2, comma, in_list_3);
        };
      } break;
#line 350 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if ((((s_5)->value).syn_list)->pseudoempty) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 352 "syntax.arg"
        gen_options((((s_5)->value).syn_list)->sub, body_4, num_2, comma, 1);
      } break;
#line 353 "syntax.arg"
      default: {} break;
    };
  };
}

#line 382 "syntax.arg"
static void gen_enums(argile_list_t * syntax_5, argile_code_t * body_5, int * num_3, unsigned char comma_2, unsigned char in_list_4)
/** :gen enums <list of (argile syntax) syntax> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
#line 384 "syntax.arg"
  for (; (syntax_5); syntax_5 = ((argile_list_t *)syntax_5)->next) {
    argile_syntax_t * s_7 = ((argile_syntax_t *)0);

#line 385 "syntax.arg"
    s_7 = *((argile_syntax_t * *)&((argile_list_t *)syntax_5)->data);
    switch ((s_7)->type) {
#line 388 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        gen_enums(((s_7)->value).syn_option, body_5, num_3, comma_2, in_list_4);
      } break;
#line 390 "syntax.arg"
      case ARGILE_SYN_ENUM: {
#line 397 "syntax.arg"
        argile_list_t * e;

#line 391 "syntax.arg"
        if ((comma_2 || (*num_3 != 0))) {
          argile_puts(", ");
        } //;
#line 393 "syntax.arg"
        argile_puts("int ");
        if (in_list_4) {
#line 470 "./argrt/std.argl"
          argile_ref(1);
        } //;
#line 395 "syntax.arg"
        argile_puts(sub_gen_id(s_7, body_5, "enm", ++(*num_3)));
        comma_2 = 1;
        e = ((s_7)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_enums(*((argile_list_t * *)&((argile_list_t *)e)->data), body_5, num_3, comma_2, in_list_4);
        };
      } break;
#line 400 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if ((((s_7)->value).syn_list)->pseudoempty) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 402 "syntax.arg"
        gen_enums((((s_7)->value).syn_list)->sub, body_5, num_3, comma_2, 1);
      } break;
#line 403 "syntax.arg"
      default: {} break;
    };
  };
}

#line 418 "syntax.arg"
static void gen_lists(argile_list_t * syn_4, argile_code_t * body_6, int * num_4, unsigned char comma_3, unsigned char in_list_5)
/** :gen lists <list of (argile syntax) syn> <argile code body> <(int) & num> <bool comma> <bool in_list>: -> nothing **/
{
#line 420 "syntax.arg"
  for (; (syn_4); syn_4 = ((argile_list_t *)syn_4)->next) {
    argile_syntax_t * s_8 = ((argile_syntax_t *)0);

#line 421 "syntax.arg"
    s_8 = *((argile_syntax_t * *)&((argile_list_t *)syn_4)->data);
    switch ((s_8)->type) {
#line 424 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        gen_lists(((s_8)->value).syn_option, body_6, num_4, comma_3, in_list_5);
      } break;
#line 426 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * e;

#line 427 "syntax.arg"
        e = ((s_8)->value).syn_enum;
        for (; (e); e = ((argile_list_t *)e)->next) {
          gen_lists(*((argile_list_t * *)&((argile_list_t *)e)->data), body_6, num_4, comma_3, in_list_5);
        };
      } break;
#line 430 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if ((((s_8)->value).syn_list)->pseudoempty) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 432 "syntax.arg"
        if ((comma_3 || (*num_4 != 0))) {
          argile_puts(", ");
        } //;
#line 434 "syntax.arg"
        argile_puts("int ");
        if (in_list_5) {
#line 470 "./argrt/std.argl"
          argile_ref(1);
        } //;
#line 436 "syntax.arg"
        argile_puts(sub_gen_id(s_8, body_6, "lst", ++(*num_4)));
        comma_3 = 1;
        gen_lists((((s_8)->value).syn_list)->sub, body_6, num_4, comma_3, 1);
      } break;
#line 439 "syntax.arg"
      default: {} break;
    };
  };
}

#line 589 "syntax.arg"
static void escape_2(argile_buff_t * b_4, char * s_17)
/** :escape <buff b> <text s>: -> nothing **/
{
#line 590 "syntax.arg"
  while ((*&(s_17)[0])) {
    switch (*&(s_17)[0]) {
      case '\\': ;
      case '<': ;
      case '>': ;
      case '=': {
#line 595 "syntax.arg"
        argile_buff_putc(b_4, '\\');
      } break;
#line 596 "syntax.arg"
      default: {} break;
    };
#line 597 "syntax.arg"
    argile_buff_putc(b_4, *&(s_17)[0]);
    (s_17)++;
  };
}

#line 696 "syntax.arg"
static int compile_params(argile_list_t * lsyn_2, argile_code_t * scope_2, argile_call_t * p_argile_call_2, unsigned char in_list_6)
/** :compile params <list of (argile syntax) lsyn> <argile code scope> <call> <bool in_list>: -> int **/
{
#line 698 "syntax.arg"
  for (; (lsyn_2); lsyn_2 = ((argile_list_t *)lsyn_2)->next) {
    argile_syntax_t * syn_2 = ((argile_syntax_t *)0);

#line 699 "syntax.arg"
    syn_2 = *((argile_syntax_t * *)&((argile_list_t *)lsyn_2)->data);
    switch ((syn_2)->type) {
      case ARGILE_SYN_PARAM: {
        argile_syn_param_t * param_2 = ((argile_syn_param_t *)0);
#line 705 "syntax.arg"
        argile_list_t * pcall;

#line 702 "syntax.arg"
        param_2 = ((syn_2)->value).syn_param;
        if ((param_2)->comp) {
#line 470 "./argrt/std.argl"
          continue;
        } //;
#line 704 "syntax.arg"
        (param_2)->in_list = in_list_6;
        pcall = (param_2)->match;
        if ((pcall == NULL)) {
#line 470 "./argrt/std.argl"
          return 0;
        } //;
#line 707 "syntax.arg"
        if ((((argile_list_t *)pcall)->next)) {
          argile_list_t * end;
          argile_match_t * m = ((argile_match_t *)0);

#line 708 "syntax.arg"
          end = argile_list_end(pcall);
          m = *((argile_match_t * *)&((argile_list_t *)end)->data);
          if ((((m) && (((argile_list_t *)end)->prev)) && ((m)->type == ARGILE_MATCH_WORD))) {
            argile_list_t * prev;

#line 711 "syntax.arg"
            prev = ((argile_list_t *)end)->prev;
            argile_list_unlink(prev, end);
            if ((argile_type_compile(&(param_2)->type, pcall, scope_2, p_argile_call_2, ((argile_def_t * *)0), &pcall))) {
#line 715 "syntax.arg"
              if (compile_init((param_2)->init, (param_2)->type, scope_2, p_argile_call_2)) {
                if ((((param_2)->init == NULL) || (argile_match_type((param_2)->init, (param_2)->type)))) {
                  if (!((pcall == NULL))) {
#line 470 "./argrt/std.argl"
                    (param_2)->match = pcall;
                  } //;
#line 718 "syntax.arg"
                  (param_2)->name = argile_dbg_strdup(((m)->value).word);
                  (param_2)->comp = 1;
                  argile_list_del(end);
                  continue;
                } //;
              } //;
            } //;
#line 722 "syntax.arg"
            if ((pcall)) {
              (param_2)->match = pcall;
            } //;
#line 724 "syntax.arg"
            else {
              pcall = (param_2)->match;
            };
#line 726 "syntax.arg"
            argile_list_link(prev, end);
          } //;
        } //;
#line 727 "syntax.arg"
        if (((!((argile_type_compile(&(param_2)->type, pcall, scope_2, p_argile_call_2, ((argile_def_t * *)0), &pcall))) || !(compile_init((param_2)->init, (param_2)->type, scope_2, p_argile_call_2))) || (((param_2)->init) && !((argile_match_type((param_2)->init, (param_2)->type)))))) {
#line 730 "syntax.arg"
          if ((pcall)) {
            (param_2)->match = pcall;
          } //;
#line 732 "syntax.arg"
          return 0;
        } //;
#line 733 "syntax.arg"
        if ((pcall)) {
          (param_2)->match = pcall;
        } //;
#line 735 "syntax.arg"
        (param_2)->name = (char *)0;
        (param_2)->comp = 1;
      } break;
#line 755 "syntax.arg"
      case ARGILE_SYN_OPTION: {
        if ((compile_params(((syn_2)->value).syn_option, scope_2, p_argile_call_2, in_list_6) == 0)) {
          return 0;
        } //;
      } break;
#line 758 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * sub_2;

#line 759 "syntax.arg"
        sub_2 = ((syn_2)->value).syn_enum;
        for (; (sub_2); sub_2 = ((argile_list_t *)sub_2)->next) {
          if ((compile_params(*((argile_list_t * *)&((argile_list_t *)sub_2)->data), scope_2, p_argile_call_2, in_list_6) == 0)) {
            return 0;
          } //;
        };
      } break;
#line 763 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if ((compile_params((((syn_2)->value).syn_list)->sub, scope_2, p_argile_call_2, 1) == 0)) {
          return 0;
        } //;
      } break;
#line 766 "syntax.arg"
      default: {} break;
    };
  };
#line 767 "syntax.arg"
  return 1;
}

#line 737 "syntax.arg"
static unsigned char compile_init(argile_match_t * p_argile_match, argile_type_t t_2, argile_code_t * c_2, argile_call_t * p_argile_call_3)
/** :compile init <match> <argile type t> <argile code c> <call>: -> bool **/
{
  argile_call_t * sub_2 = ((argile_call_t *)0);
#line 743 "syntax.arg"
  argile_filter_t old;

#line 738 "syntax.arg"
  if (((p_argile_match == NULL) || ((p_argile_match)->type != ARGILE_MATCH_SUBCALL))) {
    return 1;
  } //;
#line 740 "syntax.arg"
  sub_2 = ((p_argile_match)->value).call;
  argile_call_uncompile_subcalls(sub_2, 1);
#line 743 "syntax.arg"
  old = (argile).nextdef_filter;
  (argile).nextdef_filter = ((argile_filter_t)0);
  argile_call_setup(sub_2, c_2, p_argile_call_3);
  if (((argile_call_compile_syntaxes(sub_2) != 0) && (argile_call_compile_as(sub_2, t_2)))) {
    (argile).nextdef_filter = old;
    argile_call_find_all_path(sub_2);
    argile_call_compile_binds(sub_2);
    return 1;
  } //;
#line 751 "syntax.arg"
  argile_call_take_rejects(p_argile_call_3, sub_2);
  (argile).nextdef_filter = old;
  return 0;
}

#line 794 "syntax.arg"
static argile_list_t * syn_match(argile_list_t * ls_2, argile_list_t * lp)
/** :syn match <list of (argile syntax) ls> <list of (argile syntax) lp>: -> list of (argile syntax) **/
{
#line 796 "syntax.arg"
  while (((ls_2) && (lp))) {
    argile_syntax_t * s_2 = ((argile_syntax_t *)0);
#line 797 "syntax.arg"
    argile_syntax_t * p_2 = ((argile_syntax_t *)0);

#line 797 "syntax.arg"
    s_2 = *((argile_syntax_t * *)&((argile_list_t *)ls_2)->data);
    p_2 = *((argile_syntax_t * *)&((argile_list_t *)lp)->data);
#line 798 "syntax.arg"
    switch ((s_2)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        if ((((p_2)->type == (s_2)->type) && (strcmp(((p_2)->value).syn_word, ((s_2)->value).syn_word) == 0))) {
          lp = ((argile_list_t *)lp)->next;
        } //;
      } break;
#line 803 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        if (((s_2)->type == (p_2)->type)) {} //;
      } break;
      case ARGILE_SYN_OPTION: {
        lp = syn_match(((s_2)->value).syn_option, lp);
      } break;
#line 808 "syntax.arg"
      case ARGILE_SYN_ENUM: {
        argile_list_t * le;

#line 809 "syntax.arg"
        le = ((s_2)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          lp = syn_match(*((argile_list_t * *)&((argile_list_t *)le)->data), lp);
        };
      } break;
#line 812 "syntax.arg"
      case ARGILE_SYN_LIST: {
        lp = syn_match((((s_2)->value).syn_list)->sub, lp);
      } break;
#line 814 "syntax.arg"
      default: {} break;
    };
#line 815 "syntax.arg"
    ls_2 = ((argile_list_t *)ls_2)->next;
  };
#line 816 "syntax.arg"
  return lp;
}

#line 841 "syntax.arg"
static void module_call(argile_list_t * ls_3, argile_buff_t * bt, char * w, argile_list_t * ls2, argile_buff_t * out_2)
/** :module call <list of (argile syntax) ls> <buff bt> <text w> <list of (argile syntax) ls2> <buff out>: -> nothing **/
{
#line 843 "syntax.arg"
  for (; (ls_3); ls_3 = ((argile_list_t *)ls_3)->next) {
    argile_syntax_t * s_2 = ((argile_syntax_t *)0);

#line 844 "syntax.arg"
    s_2 = *((argile_syntax_t * *)&((argile_list_t *)ls_3)->data);
    switch ((s_2)->type) {
      case ARGILE_SYN_WORD: ;
      case ARGILE_SYN_OP: {
        argile_buff_puts(out_2, ((s_2)->value).syn_word);
        argile_buff_putc(out_2, ' ');
      } break;
#line 850 "syntax.arg"
      case ARGILE_SYN_PARAM: {
        switch ((((s_2)->value).syn_param)->type) {
          case ARGILE_TYPE_TYPE: {
            argile_buff_putc(out_2, *&("(")[0]);
            argile_buff_cat(out_2, bt);
            argile_buff_putc(out_2, *&(")")[0]);
            argile_buff_putc(out_2, ' ');
          } break;
#line 857 "syntax.arg"
          case ARGILE_TYPE_WORD: {
            if (((w) && (*&(w)[0]))) {
              argile_buff_puts(out_2, w);
              argile_buff_putc(out_2, ' ');
            } //;
          } break;
#line 861 "syntax.arg"
          case ARGILE_TYPE_SYNTAX: {
            argile_buff_putc(out_2, *&(":")[0]);
            argile_syntax_string(ls2, out_2);
            argile_buff_putc(out_2, *&(":")[0]);
            argile_buff_putc(out_2, ' ');
          } break;
#line 866 "syntax.arg"
          default: {
            argile_buff_puts(out_2, "(nil) ");
          } break;
        };
      } break;
#line 868 "syntax.arg"
      case ARGILE_SYN_OPTION: {
#line 870 "syntax.arg"
        module_call(((s_2)->value).syn_option, bt, w, ls2, out_2);
      } break;
#line 871 "syntax.arg"
      case ARGILE_SYN_ENUM: {
#line 874 "syntax.arg"
        argile_list_t * le;

#line 874 "syntax.arg"
        le = ((s_2)->value).syn_enum;
        for (; (le); le = ((argile_list_t *)le)->next) {
          if (!(missing_param(*((argile_list_t * *)&((argile_list_t *)le)->data), w, ls2))) {
            module_call(*((argile_list_t * *)&((argile_list_t *)le)->data), bt, w, ls2, out_2);
            break;
          } //;
#line 879 "syntax.arg"
        };
#line 903 "syntax.arg"
        if (((le == NULL) && (((s_2)->value).syn_enum))) {
          module_call(*((argile_list_t * *)&((argile_list_t *)((s_2)->value).syn_enum)->data), bt, w, ls2, out_2);
        } //;
      } break;
#line 905 "syntax.arg"
      case ARGILE_SYN_LIST: {
#line 907 "syntax.arg"
        int i_2 = 0;
#line 907 "syntax.arg"
        int min_2 = 1;

#line 908 "syntax.arg"
        if (((((s_2)->value).syn_list)->min > 1)) {
          min_2 = (((s_2)->value).syn_list)->min;
        } //;
#line 910 "syntax.arg"
        for (i_2 = 0; (i_2 < min_2); (i_2)++) {
          module_call((((s_2)->value).syn_list)->sub, bt, w, ls2, out_2);
        };
      } break;
#line 912 "syntax.arg"
      default: {} break;
    };
  };
}

#line 879 "syntax.arg"
static unsigned char missing_param(argile_list_t * ls_4, char * w_2, argile_list_t * ls2_2)
/** :missing param <list of (argile syntax) ls> <text w> <list of (argile syntax) ls2>: -> bool **/
{
#line 881 "syntax.arg"
  for (; (ls_4); ls_4 = ((argile_list_t *)ls_4)->next) {
    argile_syntax_t * s_3 = ((argile_syntax_t *)0);

#line 882 "syntax.arg"
    s_3 = *((argile_syntax_t * *)&((argile_list_t *)ls_4)->data);
    switch ((s_3)->type) {
      case ARGILE_SYN_PARAM: {
        argile_type_t t_2;

#line 885 "syntax.arg"
        t_2 = (((s_3)->value).syn_param)->type;
        if ((t_2 == ARGILE_TYPE_WORD)) {
          if (((w_2 == NULL) || (*&(w_2)[0] == 0))) {
#line 470 "./argrt/std.argl"
            return 1;
          } //;
        } //;
#line 888 "syntax.arg"
        else if ((t_2 == ARGILE_TYPE_SYNTAX)) {
          if ((ls2_2 == NULL)) {
#line 470 "./argrt/std.argl"
            return 1;
          } //;
        } //;
      } break;
#line 890 "syntax.arg"
      case ARGILE_SYN_ENUM: {
#line 892 "syntax.arg"
        argile_list_t * le_2;

#line 892 "syntax.arg"
        le_2 = ((s_3)->value).syn_enum;
        for (; (le_2); le_2 = ((argile_list_t *)le_2)->next) {
          if (!(missing_param(*((argile_list_t * *)&((argile_list_t *)le_2)->data), w_2, ls2_2))) {
#line 470 "./argrt/std.argl"
            break;
          } //;
        };
#line 895 "syntax.arg"
        if ((le_2 == NULL)) {
#line 470 "./argrt/std.argl"
          return 1;
        } //;
      } break;
#line 896 "syntax.arg"
      case ARGILE_SYN_LIST: {
        if (((((s_3)->value).syn_list)->min > 0)) {
          if (missing_param((((s_3)->value).syn_list)->sub, w_2, ls2_2)) {
            return 1;
          } //;
        } //;
      } break;
#line 900 "syntax.arg"
      default: {} break;
    };
  };
#line 901 "syntax.arg"
  return 0;
}

