// generated by: arc -uRNMLP -A ./argrt -o match.c -H match.h -m match.argl match.arg 
#include "match.h"

#line 545 "match.arg"
static argile_cons_t * get_cons(argile_match_t *);
/** :get cons <match>: -> (argile) cons **/
#line 169 "match.arg"
static int _check_recurse_eq(argile_match_t *, argile_match_t *);
/** :_check_recurse_eq <match ma> <match mb>: -> int **/
#line 309 "match.arg"
static unsigned char _match_try_rec(argile_list_t *, argile_list_t *, int, int *, unsigned char);
/** :_match_try_rec <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <bool in_list>: -> bool **/

#line 54 "match.arg"
argile_match_t * argile_match_new(argile_match_type_t type, void * data)
/** :argile_match_new <match type type> <any data>: -> (argile) match **/
{
#line 55 "match.arg"
  argile_match_t * match = ((argile_match_t *)0);

#line 55 "match.arg"
  match = ((argile_match_t *)memset(argile_dbg_malloc(sizeof(argile_match_t)), 0, sizeof(argile_match_t)));
  (match)->type = type;
  ((match)->value).data = data;
  return match;
}

#line 62 "match.arg"
void argile_match_del(argile_match_t * p_argile_match)
/** :argile_match_del <match>: -> nothing **/
{
#line 63 "match.arg"
  switch ((p_argile_match)->type) {
    case ARGILE_MATCH_WORD: ;
    case ARGILE_MATCH_OP: {
      argile_dbg_free(((p_argile_match)->value).word);
    } break;
#line 67 "match.arg"
    case ARGILE_MATCH_CONS: {
      argile_cons_del(((p_argile_match)->value).cons);
    } break;
#line 69 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
      argile_call_del(((p_argile_match)->value).call);
    } break;
#line 71 "match.arg"
    default: {} break;
  };
#line 72 "match.arg"
  argile_dbg_free(p_argile_match);
}

#line 79 "match.arg"
int argile_match_eq(argile_match_t * ma, argile_match_t * mb)
/** :argile_match_eq <match ma> <match mb>: -> int **/
{
#line 87 "match.arg"
  unsigned char ha;
#line 92 "match.arg"
  unsigned char hb;
#line 102 "match.arg"
  argile_type_t ta;
  argile_type_t tb;

#line 82 "match.arg"
  if ((argile).stats) {
    (((argile).stat).num_match_eq)++;
  } //;
  if ((ma == mb)) {
#line 85 "match.arg"
    return 1;
  } //;
#line 86 "match.arg"
  if (((ma == NULL) || (mb == NULL))) {
#line 86 "match.arg"
    return 0;
  } //;
#line 87 "match.arg"
  ha = (ma)->hollow;
  if ((!(ha) && ((ma)->type == ARGILE_MATCH_SUBCALL))) {
    argile_def_t * d = ((argile_def_t *)0);

#line 89 "match.arg"
    d = (((ma)->value).call)->def;
    if ((((d) && ((d)->param)) && !(((((d)->dval).var)->macro_params)))) {
      ha = 1;
    } //;
  } //;
#line 92 "match.arg"
  hb = (mb)->hollow;
  if ((!(hb) && ((mb)->type == ARGILE_MATCH_SUBCALL))) {
    argile_def_t * d = ((argile_def_t *)0);

#line 94 "match.arg"
    d = (((mb)->value).call)->def;
    if ((((d) && ((d)->param)) && !(((((d)->dval).var)->macro_params)))) {
      hb = 1;
    } //;
  } //;
  if ((ha && hb)) {
#line 99 "match.arg"
    return ((((ma)->matched == (mb)->matched)) ? (1) : (0));
  } //;
#line 100 "match.arg"
  if ((ha || hb)) {
#line 100 "match.arg"
    return 0;
  } //;
  ta = (((int)argile_match_get_type(ma)) & ~((1 << 31)));
  tb = (((int)argile_match_get_type(mb)) & ~((1 << 31)));
  if ((ta != tb)) {
#line 104 "match.arg"
    return 0;
  } //;
  switch (ta) {
    case ARGILE_TYPE_TYPE: {
      return (((argile_match_eval_type(ma) == argile_match_eval_type(mb))) ? (1) : (0));
    } break;
#line 109 "match.arg"
    case ARGILE_TYPE_WORD: {
      char * wa = "";
      char * wb = "";

#line 110 "match.arg"
      wa = argile_match_eval_word(ma);
      wb = argile_match_eval_word(mb);
      if (((wa == NULL) && (wb == NULL))) {
#line 112 "match.arg"
        return 1;
      } //;
#line 113 "match.arg"
      if (((wa == NULL) || (wb == NULL))) {
#line 113 "match.arg"
        return 0;
      } //;
#line 114 "match.arg"
      return (((strcmp(wa, wb) == 0)) ? (1) : (0));
    } break;
#line 115 "match.arg"
    case ARGILE_TYPE_INTEGER: {
      int ea = 0;
#line 116 "match.arg"
      int eb = 0;
#line 119 "match.arg"
      int ia = 0;
      int ib = 0;

#line 117 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ia = argile_match_eval_int(ma, &ea);
      ib = argile_match_eval_int(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
#line 121 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 122 "match.arg"
      if (((ea != 0) || (eb != 0))) {
#line 122 "match.arg"
        return 0;
      } //;
#line 123 "match.arg"
      return (((ia == ib)) ? (1) : (0));
    } break;
#line 124 "match.arg"
    case ARGILE_TYPE_NATURAL: {
      int ea = 0;
#line 125 "match.arg"
      int eb = 0;
#line 128 "match.arg"
      unsigned int na = 0;
      unsigned int nb = 0;

#line 126 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      na = argile_match_eval_nat(ma, &ea);
      nb = argile_match_eval_nat(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
#line 130 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 131 "match.arg"
      if (((ea != 0) || (eb != 0))) {
#line 131 "match.arg"
        return 0;
      } //;
#line 132 "match.arg"
      return (((na == nb)) ? (1) : (0));
    } break;
#line 133 "match.arg"
    case ARGILE_TYPE_REAL: {
      int ea = 0;
#line 134 "match.arg"
      int eb = 0;
#line 137 "match.arg"
      double ra = 0.0;
      double rb = 0.0;

#line 135 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ra = argile_match_eval_real(ma, &ea);
      rb = argile_match_eval_real(mb, &eb);
      if (((ea != 0) && (eb != 0))) {
#line 139 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 140 "match.arg"
      if (((ea != 0) || (eb != 0))) {
#line 140 "match.arg"
        return 0;
      } //;
#line 141 "match.arg"
      return (((ra == rb)) ? (1) : (0));
    } break;
#line 142 "match.arg"
    case ARGILE_TYPE_TEXT: {
#line 145 "match.arg"
      argile_text_t * xa = ((argile_text_t *)0);
      argile_text_t * xb = ((argile_text_t *)0);

#line 143 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      xa = argile_match_eval_text(ma);
      xb = argile_match_eval_text(mb);
      if (((xa == NULL) && (xb == NULL))) {
#line 147 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 148 "match.arg"
      if (((xa == NULL) || (xb == NULL))) {
#line 148 "match.arg"
        return 0;
      } //;
#line 149 "match.arg"
      return (((strcmp((xa)->str, (xb)->str) == 0)) ? (1) : (0));
    } break;
#line 150 "match.arg"
    case ARGILE_TYPE_SYNTAX: {
#line 153 "match.arg"
      argile_list_t * sa;
      argile_list_t * sb;

#line 151 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      sa = argile_match_eval_syntax(ma);
      sb = argile_match_eval_syntax(mb);
      if (((sa == NULL) && (sb == NULL))) {
#line 155 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 156 "match.arg"
      if (((sa == NULL) || (sb == NULL))) {
#line 156 "match.arg"
        return 0;
      } //;
    } break;
#line 158 "match.arg"
    case ARGILE_TYPE_CODE: {
#line 161 "match.arg"
      argile_code_t * ca = ((argile_code_t *)0);
      argile_code_t * cb = ((argile_code_t *)0);

#line 159 "match.arg"
      ma = argile_match_terminal(ma);
      mb = argile_match_terminal(mb);
      ca = argile_match_eval_code(ma);
      cb = argile_match_eval_code(mb);
      if (((ca == NULL) && (cb == NULL))) {
#line 163 "match.arg"
        return _check_recurse_eq(ma, mb);
      } //;
#line 164 "match.arg"
      if (((ca == NULL) || (cb == NULL))) {
#line 164 "match.arg"
        return 0;
      } //;
#line 165 "match.arg"
      if ((((ca)->calls == NULL) && ((cb)->calls == NULL))) {
#line 165 "match.arg"
        return 1;
      } //;
#line 166 "match.arg"
      if ((((ca)->calls == NULL) || ((cb)->calls == NULL))) {
#line 166 "match.arg"
        return 0;
      } //;
    } break;
#line 168 "match.arg"
    default: {} break;
  };
#line 175 "match.arg"
  return 0;
}

#line 181 "match.arg"
argile_match_t * argile_match_shadow(argile_match_t * p_argile_match_2)
/** :argile_match_shadow <match>: -> (argile) match **/
{
#line 182 "match.arg"
  argile_match_t * shadow = ((argile_match_t *)0);

#line 182 "match.arg"
  shadow = argile_match_new((p_argile_match_2)->type, ((p_argile_match_2)->value).data);
  (shadow)->matched = (p_argile_match_2)->matched;
  (shadow)->processed = (p_argile_match_2)->processed;
  (shadow)->hollow = (p_argile_match_2)->hollow;
  (shadow)->evaled = (p_argile_match_2)->evaled;
  (shadow)->etype = (p_argile_match_2)->etype;
  return shadow;
}

#line 198 "match.arg"
void argile_match_string(argile_match_t * p_argile_match_3, int indent, argile_buff_t * buf, int cons_types)
/** :argile_match_string <match> <int indent> <buff buf> <int cons_types>: -> nothing **/
{
  char * clr = (char *)0;

#line 202 "match.arg"
  if (((p_argile_match_3)->matched)) {
    if (((((p_argile_match_3)->matched)->type == ARGILE_SYN_PARAM) && (((((p_argile_match_3)->matched)->value).syn_param)->type == ARGILE_TYPE_WORD))) {
#line 205 "match.arg"
      clr = "[00;32m";
    } //;
#line 206 "match.arg"
    else if ((cons_types != 0)) {
      clr = "[01;32m";
    } //;
  } //;
#line 208 "match.arg"
  else if ((cons_types != 0)) {
    clr = (((p_argile_match_3)->processed) ? ("[01;31m") : ("[01;37m"));
  } //;
#line 210 "match.arg"
  if ((clr)) {
    argile_push_color(buf, clr);
  } //;
#line 212 "match.arg"
  switch ((p_argile_match_3)->type) {
    case ARGILE_MATCH_WORD: ;
    case ARGILE_MATCH_OP: {
      argile_buff_puts(buf, ((p_argile_match_3)->value).word);
    } break;
#line 216 "match.arg"
    case ARGILE_MATCH_CONS: {
      if ((cons_types != 0)) {
        argile_buff_putc(buf, '<');
        argile_typename((((p_argile_match_3)->value).cons)->type, buf, (argile).main);
        argile_buff_putc(buf, '>');
      } //;
#line 221 "match.arg"
      else {
        argile_cons_string(((p_argile_match_3)->value).cons, indent, buf);
      };
    } break;
#line 223 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
      argile_call_t * call = ((argile_call_t *)0);

#line 224 "match.arg"
      call = ((p_argile_match_3)->value).call;
      if ((call)->stealth) {
        argile_buff_puts(buf, "(:[:) ");
        argile_call_string(call, indent, buf);
        argile_buff_puts(buf, " (:]:)");
      } //;
#line 229 "match.arg"
      else {
        argile_buff_putc(buf, *&("(")[0]);
        argile_call_string(call, indent, buf);
        argile_buff_putc(buf, *&(")")[0]);
      };
    } break;
#line 233 "match.arg"
    default: {
      argile_buff_puts(buf, "(: bad match type ");
      argile_buff_putn(buf, ((int)(p_argile_match_3)->type));
      argile_buff_puts(buf, " :)");
    } break;
  };
#line 237 "match.arg"
  if ((clr)) {
    argile_pop_color(buf);
  } //;
}

#line 245 "match.arg"
void argile_match_setup(argile_match_t * p_argile_match_4, argile_call_t * owner)
/** :argile_match_setup <match> <call owner>: -> nothing **/
{
#line 246 "match.arg"
  if (((p_argile_match_4)->type == ARGILE_MATCH_CONS)) {
    argile_cons_setup(((p_argile_match_4)->value).cons, owner);
  } //;
#line 248 "match.arg"
  else if (((p_argile_match_4)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_setup(((p_argile_match_4)->value).call, (owner)->scope, owner);
  } //;
}

#line 256 "match.arg"
int argile_match_type(argile_match_t * p_argile_match_5, argile_type_t type_2)
/** :argile_match_type <match> <argile type type>: -> int **/
{
#line 257 "match.arg"
  if ((type_2 == ARGILE_TYPE_WORD)) {
    if (((p_argile_match_5)->type == ARGILE_MATCH_WORD)) {
      return 1;
    } //;
#line 260 "match.arg"
    if ((argile_match_eval_word(p_argile_match_5))) {
      return 1;
    } //;
#line 262 "match.arg"
    return 0;
  } //;
#line 263 "match.arg"
  switch ((p_argile_match_5)->type) {
    case ARGILE_MATCH_WORD: {
#line 266 "match.arg"
      return (((type_2 == ARGILE_TYPE_WORD)) ? (1) : (0));
    } break;
#line 267 "match.arg"
    case ARGILE_MATCH_CONS: {
      return (((argile_cons_match_type(((p_argile_match_5)->value).cons, type_2))) ? (1) : (0));
    } break;
#line 269 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
      argile_call_t * sub = ((argile_call_t *)0);
      argile_type_t old;

#line 270 "match.arg"
      sub = ((p_argile_match_5)->value).call;
      old = (sub)->context;
      if (!((sub)->compiled)) {
        return 1;
      } //;
#line 274 "match.arg"
      (sub)->context = type_2;
      if ((argile_type_match(type_2, argile_call_get_type(sub)))) {
        return 1;
      } //;
#line 277 "match.arg"
      (sub)->context = old;
      return 0;
    } break;
#line 279 "match.arg"
    default: {} break;
  };
#line 280 "match.arg"
  return 0;
}

#line 294 "match.arg"
int argile_match_try(argile_list_t * syntax, argile_list_t * match, int size, int * size_ret, int in_list)
/** :argile_match_try <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <int in_list>: -> int **/
{
#line 299 "match.arg"
  int oldmatch = 0;
#line 301 "match.arg"
  unsigned char try;

#line 297 "match.arg"
  if ((argile).stats) {
    (((argile).stat).num_match_try)++;
  } //;
#line 299 "match.arg"
  oldmatch = (argile).nummatch;
  (argile).nummatch = 0;
  try = _match_try_rec(syntax, match, size, size_ret, (in_list));
  if ((((argile).maxmatch > 0) && ((argile).maxmatch <= (argile).nummatch))) {
    argile_buff_t b = ((argile_buff_t){0});

#line 304 "match.arg"
    argile_syntax_string(syntax, &b);
    argile_buff_putc(&b, '\0');
    argile_die("max. syntax match (%d) reached\n  :%s:", (argile).maxmatch, (b).ptr);
    argile_dbg_free((b).ptr);
  } //;
#line 308 "match.arg"
  (argile).nummatch = oldmatch;
#line 390 "match.arg"
  return ((int)try);
}

#line 396 "match.arg"
argile_type_t argile_match_get_type(argile_match_t * p_argile_match_6)
/** :argile_match_get_type <match>: -> argile type **/
{
#line 397 "match.arg"
  if ((p_argile_match_6 == NULL)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
#line 399 "match.arg"
  switch ((p_argile_match_6)->type) {
    case ARGILE_MATCH_WORD: {
      return (argile_type_t)ARGILE_TYPE_WORD;
    } break;
#line 402 "match.arg"
    case ARGILE_MATCH_CONS: {
      return (((p_argile_match_6)->value).cons)->type;
    } break;
#line 404 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
      return argile_call_get_type(((p_argile_match_6)->value).call);
    } break;
#line 406 "match.arg"
    default: {} break;
  };
#line 407 "match.arg"
  return ARGILE_TYPE_NOTHING;
}

#line 413 "match.arg"
void argile_match_gencode(argile_match_t * p_argile_match_7)
/** :argile_match_gencode <match>: -> nothing **/
{
#line 415 "match.arg"
  argile_type_t type_2;
#line 423 "match.arg"
  argile_type_t t;
  unsigned char need_ref;
  argile_list_t * chain = ((argile_list_t *)0);
#line 429 "match.arg"
  int paren = 0;
  argile_list_t * lc;

#line 414 "match.arg"
  if ((p_argile_match_7 == NULL)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 416 "match.arg"
  switch ((p_argile_match_7)->type) {
    case ARGILE_MATCH_WORD: {
      argile_puts(((p_argile_match_7)->value).word);
      return;
    } break;
#line 420 "match.arg"
    case ARGILE_MATCH_CONS: {
#line 420 "match.arg"
      type_2 = (((p_argile_match_7)->value).cons)->rtype;
    } break;
#line 421 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
#line 421 "match.arg"
      type_2 = (((p_argile_match_7)->value).call)->context;
    } break;
#line 422 "match.arg"
    default: {
#line 422 "match.arg"
      type_2 = (argile_type_t)ARGILE_TYPE_NOTHING;
    } break;
  };
#line 423 "match.arg"
  t = argile_match_get_type(p_argile_match_7);
  need_ref = 0;
#line 427 "match.arg"
  if (!((argile).noautocast)) {
    (argile_type_cast_chain((((int)type_2) & ~((1 << 31))), (((int)t) & ~((1 << 31))), ((int)(((((int)type_2) >> 31) & 1))), ((argile_type_info_t *)0), &chain));
  } //;
#line 430 "match.arg"
  lc = chain;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    argile_type_caster_t * c = ((argile_type_caster_t *)0);

#line 432 "match.arg"
    c = *((argile_type_caster_t * *)&((argile_list_t *)lc)->data);
    if (((c)->code)) {
      argile_printf("%s(", ((c)->code)->anon);
      (paren)++;
    } //;
#line 436 "match.arg"
    else {
      if (((((((int)(c)->to) >> 31) & 1)) && !((((((int)type_2) >> 31) & 1))))) {
        argile_ref(1);
      } //;
#line 439 "match.arg"
      if (((((((int)type_2) >> 31) & 1)) && !((((((int)(c)->to) >> 31) & 1))))) {
        need_ref = 1;
      } //;
#line 441 "match.arg"
      argile_puts("(");
      argile_type_gen_prefix((c)->to);
      if (need_ref) {
#line 470 "./argrt/std.argl"
        argile_ref(1);
      } //;
#line 444 "match.arg"
      argile_type_gen_suffix((c)->to);
      argile_puts(")");
    };
#line 446 "match.arg"
    type_2 = (c)->to;
  };
#line 447 "match.arg"
  argile_list_del(chain);
  switch ((p_argile_match_7)->type) {
    case ARGILE_MATCH_CONS: {
      if (need_ref) {
#line 470 "./argrt/std.argl"
        argile_ref(-1);
      } //;
#line 451 "match.arg"
      argile_cons_gencode(((p_argile_match_7)->value).cons);
    } break;
#line 452 "match.arg"
    case ARGILE_MATCH_SUBCALL: {
      if ((need_ref && !((((((int)(((p_argile_match_7)->value).call)->context) >> 31) & 1))))) {
        argile_ref(-1);
      } //;
#line 455 "match.arg"
      argile_call_gencode(((p_argile_match_7)->value).call, 0);
    } break;
#line 456 "match.arg"
    default: {} break;
  };
#line 457 "match.arg"
  while (((paren)-- > 0)) {
#line 487 "./argrt/std.argl"
    argile_puts(")");
  };
}

#line 464 "match.arg"
argile_match_t * argile_match_terminal(argile_match_t * p_argile_match_8)
/** :argile_match_terminal <match>: -> (argile) match **/
{
#line 465 "match.arg"
  if ((p_argile_match_8 == NULL)) {
#line 470 "./argrt/std.argl"
    return ((argile_match_t *)0);
  } //;
#line 466 "match.arg"
  if (((p_argile_match_8)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * sub = ((argile_call_t *)0);
    argile_def_t * def = ((argile_def_t *)0);

#line 467 "match.arg"
    sub = ((p_argile_match_8)->value).call;
    def = (sub)->def;
    if ((def)) {
      argile_code_t * scope = ((argile_code_t *)0);

#line 470 "match.arg"
      scope = (def)->scope;
#line 472 "match.arg"
      if (((((def)->locall && ((def)->param)) && (((def)->param)->def)) && (((def)->param)->def != def))) {
#line 474 "match.arg"
        def = ((def)->param)->def;
        scope = (def)->scope;
      } //;
      if (((((def)->param) && ((def)->dtype == ARGILE_DEF_VAR)) && ((((def)->dval).var)->macro_params))) {
#line 479 "match.arg"
        argile_code_t * body = ((argile_code_t *)0);

#line 480 "match.arg"
        for (body = scope; (body); body = (body)->upper) {
          if ((((body)->macro_shovels) && ((def)->scope == body))) {
            argile_shovel_t * sh = ((argile_shovel_t *)0);
#line 484 "match.arg"
            argile_match_t * m = ((argile_match_t *)0);

#line 482 "match.arg"
            sh = *((argile_shovel_t * *)&((argile_list_t *)(body)->macro_shovels)->data);
#line 484 "match.arg"
            m = argile_shovel_digparamatch(sh, (def)->param);
            if ((m == p_argile_match_8)) {
#line 470 "./argrt/std.argl"
              return ((argile_match_t *)0);
            } //;
#line 486 "match.arg"
            return argile_match_terminal(m);
          } //;
        };
      } //;
#line 487 "match.arg"
      else if (((def)->dtype == ARGILE_DEF_TYPE)) {
        return p_argile_match_8;
      } //;
#line 489 "match.arg"
      else if (((def)->dtype == ARGILE_DEF_BIND)) {
        return p_argile_match_8;
      } //;
    } //;
#line 491 "match.arg"
    else if ((((sub)->type == ARGILE_CALL_EXPLICIT) && ((sub)->match != NULL))) {
      argile_match_t * m = ((argile_match_t *)0);

#line 492 "match.arg"
      m = *((argile_match_t * *)&((argile_list_t *)(sub)->match)->data);
      if (((m) && ((m)->type == ARGILE_MATCH_CONS))) {
        return m;
      } //;
    } //;
  } //;
#line 495 "match.arg"
  return p_argile_match_8;
}

#line 503 "match.arg"
argile_type_t argile_match_eval_type(argile_match_t * p_argile_match_9)
/** :argile_match_eval_type <match>: -> argile type **/
{
#line 504 "match.arg"
  if ((p_argile_match_9)->evaled) {
    return (p_argile_match_9)->etype;
  } //;
#line 506 "match.arg"
  if (((p_argile_match_9)->type != ARGILE_MATCH_SUBCALL)) {
    return (argile_type_t)ARGILE_TYPE_NOTHING;
  } //;
#line 508 "match.arg"
  return argile_call_eval_type(((p_argile_match_9)->value).call);
}

#line 514 "match.arg"
char * argile_match_eval_word(argile_match_t * p_argile_match_10)
/** :argile_match_eval_word <match>: -> text **/
{
#line 515 "match.arg"
  p_argile_match_10 = argile_match_terminal(p_argile_match_10);
  if (((p_argile_match_10) && ((p_argile_match_10)->type == ARGILE_MATCH_WORD))) {
    return ((p_argile_match_10)->value).word;
  } //;
#line 518 "match.arg"
  return (char *)0;
}

#line 525 "match.arg"
int argile_match_eval_int(argile_match_t * p_argile_match_11, int * error)
/** :argile_match_eval_int <match> <(int) & error>: -> int **/
{
#line 526 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 526 "match.arg"
  c = get_cons(p_argile_match_11);
  if (!((&*error == NULL))) {
#line 470 "./argrt/std.argl"
    *error = 1;
  } //;
#line 528 "match.arg"
  if ((c == NULL)) {
#line 470 "./argrt/std.argl"
    return 0;
  } //;
#line 529 "match.arg"
  if (!((&*error == NULL))) {
#line 470 "./argrt/std.argl"
    *error = 0;
  } //;
#line 530 "match.arg"
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      return ((int)strtol(((c)->cvalue).hex, NULL, 16));
    } break;
#line 533 "match.arg"
    case ARGILE_CONS_DEC: {
      return ((int)strtol(((c)->cvalue).dec, NULL, 10));
    } break;
#line 535 "match.arg"
    case ARGILE_CONS_OCT: {
      return ((int)strtol(((c)->cvalue).oct, NULL, 8));
    } break;
#line 537 "match.arg"
    case ARGILE_CONS_BIN: {
      if ((*&(((c)->cvalue).bin)[0] == '-')) {
        return (-((int)strtol(((((c)->cvalue).bin) + 3), NULL, 2)));
      } //;
#line 540 "match.arg"
      return ((int)strtol(((((c)->cvalue).bin) + 2), NULL, 2));
    } break;
#line 541 "match.arg"
    default: {} break;
  };
#line 542 "match.arg"
  if (!((&*error == NULL))) {
#line 470 "./argrt/std.argl"
    *error = 1;
  } //;
#line 543 "match.arg"
  return 0;
}

#line 545 "match.arg"
static argile_cons_t * get_cons(argile_match_t * p_argile_match_12)
/** :get cons <match>: -> (argile) cons **/
{
#line 546 "match.arg"
  p_argile_match_12 = argile_match_terminal(p_argile_match_12);
  if (((p_argile_match_12) && ((p_argile_match_12)->type == ARGILE_MATCH_CONS))) {
    return ((p_argile_match_12)->value).cons;
  } //;
#line 549 "match.arg"
  return ((argile_cons_t *)0);
}

#line 556 "match.arg"
unsigned int argile_match_eval_nat(argile_match_t * p_argile_match_13, int * error_2)
/** :argile_match_eval_nat <match> <(int) & error>: -> nat **/
{
#line 557 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 557 "match.arg"
  c = get_cons(p_argile_match_13);
  if (!((&*error_2 == NULL))) {
#line 470 "./argrt/std.argl"
    *error_2 = 1;
  } //;
#line 559 "match.arg"
  if ((c == NULL)) {
#line 470 "./argrt/std.argl"
    return 0;
  } //;
#line 560 "match.arg"
  if (!((&*error_2 == NULL))) {
#line 470 "./argrt/std.argl"
    *error_2 = 0;
  } //;
#line 561 "match.arg"
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      return ((unsigned int)strtoul(((c)->cvalue).hex, NULL, 16));
    } break;
#line 564 "match.arg"
    case ARGILE_CONS_DEC: {
      return ((unsigned int)strtoul(((c)->cvalue).dec, NULL, 10));
    } break;
#line 566 "match.arg"
    case ARGILE_CONS_OCT: {
      return ((unsigned int)strtoul(((c)->cvalue).oct, NULL, 8));
    } break;
#line 568 "match.arg"
    case ARGILE_CONS_BIN: {
      if ((*&(((c)->cvalue).bin)[0] == '-')) {
        return ((unsigned int)strtoul(((((c)->cvalue).bin) + 3), NULL, 2));
      } //;
#line 571 "match.arg"
      return ((unsigned int)strtoul(((((c)->cvalue).bin) + 2), NULL, 2));
    } break;
#line 572 "match.arg"
    default: {} break;
  };
#line 573 "match.arg"
  if (!((&*error_2 == NULL))) {
#line 470 "./argrt/std.argl"
    *error_2 = 1;
  } //;
#line 574 "match.arg"
  return 0;
}

#line 581 "match.arg"
double argile_match_eval_real(argile_match_t * p_argile_match_14, int * error_3)
/** :argile_match_eval_real <match> <(int) & error>: -> real **/
{
#line 582 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 582 "match.arg"
  c = get_cons(p_argile_match_14);
  if (!((&*error_3 == NULL))) {
#line 470 "./argrt/std.argl"
    *error_3 = 1;
  } //;
#line 584 "match.arg"
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_REAL))) {
    return 0.0;
  } //;
#line 586 "match.arg"
  if (!((&*error_3 == NULL))) {
#line 470 "./argrt/std.argl"
    *error_3 = 0;
  } //;
#line 587 "match.arg"
  return ((double)strtod(((c)->cvalue).real, NULL));
}

#line 594 "match.arg"
argile_text_t * argile_match_eval_text(argile_match_t * p_argile_match_15)
/** :argile_match_eval_text <match>: -> argile text **/
{
#line 595 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 595 "match.arg"
  c = get_cons(p_argile_match_15);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_TEXT))) {
    return ((argile_text_t *)0);
  } //;
#line 598 "match.arg"
  return ((c)->cvalue).text;
}

#line 605 "match.arg"
argile_list_t * argile_match_eval_syntax(argile_match_t * p_argile_match_16)
/** :argile_match_eval_syntax <match>: -> list of (argile syntax) **/
{
#line 606 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 606 "match.arg"
  c = get_cons(p_argile_match_16);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_SYNTAX))) {
    return ((argile_list_t *)0);
  } //;
#line 609 "match.arg"
  return ((c)->cvalue).syntax;
}

#line 616 "match.arg"
argile_code_t * argile_match_eval_code(argile_match_t * p_argile_match_17)
/** :argile_match_eval_code <match>: -> argile code **/
{
#line 617 "match.arg"
  argile_cons_t * c = ((argile_cons_t *)0);

#line 617 "match.arg"
  c = get_cons(p_argile_match_17);
  if (((c == NULL) || ((c)->ctype != ARGILE_CONS_CODE))) {
    return ((argile_code_t *)0);
  } //;
#line 620 "match.arg"
  return ((c)->cvalue).code;
}

#line 630 "match.arg"
int argile_match_is_const(argile_match_t * p_argile_match_18)
/** :argile_match_is_const <match>: -> int **/
{
  argile_def_t * d = ((argile_def_t *)0);

#line 631 "match.arg"
  if ((p_argile_match_18 == NULL)) {
#line 631 "match.arg"
    return 0;
  } //;
#line 632 "match.arg"
  if (((p_argile_match_18)->type != ARGILE_MATCH_SUBCALL)) {
#line 632 "match.arg"
    return 1;
  } //;
#line 633 "match.arg"
  d = (((p_argile_match_18)->value).call)->def;
  if ((d == NULL)) {
#line 634 "match.arg"
    return 1;
  } //;
#line 635 "match.arg"
  if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind)->is_const)) {
    return 1;
  } //;
#line 637 "match.arg"
  return 0;
}

#line 645 "match.arg"
unsigned char argile_match_find_autoparams(argile_match_t * p_argile_match_19)
/** :argile_match_find_autoparams <match>: -> bool **/
{
#line 646 "match.arg"
  unsigned char found;

#line 646 "match.arg"
  found = 0;
  switch ((p_argile_match_19)->type) {
    case ARGILE_MATCH_SUBCALL: {
      if (argile_call_find_autoparams(((p_argile_match_19)->value).call)) {
        found = 1;
      } //;
    } break;
#line 651 "match.arg"
    case ARGILE_MATCH_CONS: {
      if (argile_cons_find_autoparams(((p_argile_match_19)->value).cons)) {
        found = 1;
      } //;
    } break;
#line 654 "match.arg"
    default: {} break;
  };
#line 655 "match.arg"
  return found;
}

#line 169 "match.arg"
static int _check_recurse_eq(argile_match_t * ma_2, argile_match_t * mb_2)
/** :_check_recurse_eq <match ma> <match mb>: -> int **/
{
#line 170 "match.arg"
  if (((ma_2 == NULL) || (mb_2 == NULL))) {
#line 170 "match.arg"
    return 1;
  } //;
#line 171 "match.arg"
  if (((ma_2)->type != (mb_2)->type)) {
#line 171 "match.arg"
    return 1;
  } //;
#line 172 "match.arg"
  if (((ma_2)->type != ARGILE_MATCH_SUBCALL)) {
#line 172 "match.arg"
    return 1;
  } //;
#line 173 "match.arg"
  return argile_call_eq(((ma_2)->value).call, ((mb_2)->value).call);
}

#line 309 "match.arg"
static unsigned char _match_try_rec(argile_list_t * syntax_2, argile_list_t * match_2, int size_2, int * size_ret_2, unsigned char in_list_2)
/** :_match_try_rec <list of (argile syntax) syntax> <list of (match) match> <int size> <(int) & size_ret> <bool in_list>: -> bool **/
{
#line 314 "match.arg"
  int count = 0;

#line 311 "match.arg"
  if ((((argile).maxmatch > 0) && ((argile).maxmatch <= (argile).nummatch))) {
    return 0;
  } //;
#line 313 "match.arg"
  ((argile).nummatch)++;
#line 315 "match.arg"
  if (!((&*size_ret_2 == NULL))) {
#line 470 "./argrt/std.argl"
    *size_ret_2 = 0;
  } //;
#line 316 "match.arg"
  while ((((match_2) && (syntax_2)) && (size_2 > 0))) {
    argile_match_t * m = ((argile_match_t *)0);
    argile_syntax_t * s = ((argile_syntax_t *)0);

#line 317 "match.arg"
    m = *((argile_match_t * *)&((argile_list_t *)match_2)->data);
    s = *((argile_syntax_t * *)&((argile_list_t *)syntax_2)->data);
    if ((m)) {
      switch ((s)->type) {
        case ARGILE_SYN_WORD: {
          if ((((m)->type != ARGILE_MATCH_WORD) || (strcmp(((m)->value).word, ((s)->value).syn_word) != 0))) {
#line 324 "match.arg"
            return 0;
          } //;
#line 325 "match.arg"
          (m)->matched = s;
          (size_2)--;
#line 326 "match.arg"
          (count)++;
        } break;
#line 327 "match.arg"
        case ARGILE_SYN_OP: {
          if ((((m)->type != ARGILE_MATCH_OP) || (strcmp(((m)->value).op, ((s)->value).syn_op) != 0))) {
#line 330 "match.arg"
            return 0;
          } //;
#line 331 "match.arg"
          (m)->matched = s;
          (size_2)--;
#line 332 "match.arg"
          (count)++;
        } break;
#line 333 "match.arg"
        case ARGILE_SYN_PARAM: {
          if (!((argile_match_type(m, (((s)->value).syn_param)->type)))) {
            return 0;
          } //;
#line 336 "match.arg"
          (m)->matched = s;
          (size_2)--;
#line 337 "match.arg"
          (count)++;
        } break;
#line 338 "match.arg"
        case ARGILE_SYN_OPTION: {
#line 340 "match.arg"
          argile_list_t * end;
#line 342 "match.arg"
          int eaten = 0;
          unsigned char try_2;

#line 340 "match.arg"
          end = argile_list_end(((s)->value).syn_option);
          argile_list_link(end, ((argile_list_t *)syntax_2)->next);
#line 343 "match.arg"
          try_2 = _match_try_rec(((s)->value).syn_option, match_2, size_2, &eaten, in_list_2);
#line 345 "match.arg"
          argile_list_unlink(end, ((argile_list_t *)syntax_2)->next);
          argile_list_link(syntax_2, ((argile_list_t *)syntax_2)->next);
#line 348 "match.arg"
          if (!(try_2)) {
            try_2 = _match_try_rec(((argile_list_t *)syntax_2)->next, match_2, size_2, &eaten, in_list_2);
          } //;
          if (!((&*size_ret_2 == NULL))) {
#line 470 "./argrt/std.argl"
            *size_ret_2 = (count + eaten);
          } //;
#line 352 "match.arg"
          return try_2;
        } break;
#line 353 "match.arg"
        case ARGILE_SYN_ENUM: {
          unsigned char try_2;
          argile_list_t * cur;
          int eaten = 0;

#line 354 "match.arg"
          try_2 = 0;
          cur = ((s)->value).syn_enum;
#line 357 "match.arg"
          for (; (cur); cur = ((argile_list_t *)cur)->next) {
            argile_list_t * inner;
            argile_list_t * end;

#line 358 "match.arg"
            inner = *((argile_list_t * *)&((argile_list_t *)cur)->data);
            end = argile_list_end(inner);
            argile_list_link(end, ((argile_list_t *)syntax_2)->next);
            try_2 = _match_try_rec(inner, match_2, size_2, &eaten, in_list_2);
            argile_list_unlink(end, ((argile_list_t *)syntax_2)->next);
            if (try_2) {
              break;
            } //;
          };
#line 365 "match.arg"
          argile_list_link(syntax_2, ((argile_list_t *)syntax_2)->next);
          if (!((&*size_ret_2 == NULL))) {
#line 470 "./argrt/std.argl"
            *size_ret_2 = (count + eaten);
          } //;
#line 367 "match.arg"
          return try_2;
        } break;
#line 368 "match.arg"
        case ARGILE_SYN_LIST: {
          int num = 0;
#line 369 "match.arg"
          int eaten = 0;
          int min = 0;
#line 370 "match.arg"
          int max = 0;
          unsigned char try_2;

#line 370 "match.arg"
          min = (((s)->value).syn_list)->min;
          max = (((s)->value).syn_list)->max;
#line 371 "match.arg"
          try_2 = 0;
          for (num = 0; ((max == 0) || (num < max)); (num)++) {
            try_2 = _match_try_rec((((s)->value).syn_list)->sub, match_2, size_2, &eaten, 1);
#line 375 "match.arg"
            if (((eaten == 0) || !(try_2))) {
#line 470 "./argrt/std.argl"
              break;
            } //;
#line 376 "match.arg"
            match_2 = argile_list_seek(match_2, eaten);
            size_2 -= eaten;
#line 377 "match.arg"
            count += eaten;
          };
#line 378 "match.arg"
          if ((num < min)) {
            return 0;
          } //;
#line 380 "match.arg"
          try_2 = _match_try_rec(((argile_list_t *)syntax_2)->next, match_2, size_2, &eaten, in_list_2);
          if (!((&*size_ret_2 == NULL))) {
#line 470 "./argrt/std.argl"
            *size_ret_2 = (count + eaten);
          } //;
#line 382 "match.arg"
          return try_2;
        } break;
#line 383 "match.arg"
        default: {} break;
      };
    } //;
#line 384 "match.arg"
    match_2 = ((argile_list_t *)match_2)->next;
#line 384 "match.arg"
    syntax_2 = ((argile_list_t *)syntax_2)->next;
  };
#line 385 "match.arg"
  if (((size_2 != 0) && !(in_list_2))) {
    return 0;
  } //;
#line 387 "match.arg"
  if (!((&*size_ret_2 == NULL))) {
#line 470 "./argrt/std.argl"
    *size_ret_2 = count;
  } //;
#line 388 "match.arg"
  return (argile_syntax_is_terminal(syntax_2));
}

