// generated by: arc -uRNMLP -A ./argrt -o argilectx.c -H argilectx.h -m argilectx.argl argilectx.arg 
#line 29 "argilectx.arg"
#include "argile.h" //;
#include <libargile/parser.h> //;

#include "argilectx.h"

#line 363 "argilectx.arg"
static void attribute_comments_to_calls();
/** :attribute comments to calls: -> nothing **/
#line 745 "argilectx.arg"
static void print_line(char *, int);
/** :print line <text dst> <int len>: -> nothing **/
#line 1111 "argilectx.arg"
static int ends_by(char *, int, char *);
/** :<text str> ends by <int n> <text end>: -> int **/
#line 1189 "argilectx.arg"
static argile_file_t * try_new_file(char *);
/** :try new file <text path>: -> (argile) file **/
#line 1356 "argilectx.arg"
static char * convert_to_daltonism(char *);
/** :convert <text colour> to daltonism: -> text **/
#line 283 "argilectx.arg"
static unsigned char is_not_included(argile_code_t *);
/** :<argile code c> is not included: -> bool **/
#line 383 "argilectx.arg"
static unsigned char argile_pos_su_argile_pos(argile_pos_t *, argile_pos_t *);
/** :<pos a> > <pos b>: -> bool **/
#line 421 "argilectx.arg"
static void comment(comment_t *);
/** :<comment c>: -> nothing **/
#line 547 "argilectx.arg"
static void print_define(argile_file_t * * file, int * size, char * * name);
/** :print define: -> nothing **/
#line 518 "argilectx.arg"
static int get_word_size_of(char *);
/** :get word size of <text t>: -> int **/
#line 1006 "argilectx.arg"
static void write_ref_or_raw_in_with(argile_buff_t *, argile_buff_t *, argile_def_t *, char *);
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
#line 1161 "argilectx.arg"
static void add_include(char *);
/** :add include <text p>: -> nothing **/
#line 1226 "argilectx.arg"
static argile_file_t * try_in_dir(char *, int, char *, int);
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
#line 1272 "argilectx.arg"
static void strip_useless_slashes_in(char *);
/** :strip useless slashes in <text s>: -> nothing **/
#line 1291 "argilectx.arg"
static unsigned char doesn_t_end_by_ext(char *);
/** :<text str> doesn ' t end by ext: -> bool **/
#line 1286 "argilectx.arg"
static void reduce(char *, char *);
/** :reduce <text d> <text s>: -> nothing **/
#line 1740 "argilectx.arg"
static int id_end_num(char *, unsigned int, int *);
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
#line 1782 "argilectx.arg"
static void check_id_num(argile_buff_t *, char *, unsigned char *, int *, int *);
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
#line 1793 "argilectx.arg"
static void check_call_id_num(argile_call_t *, argile_buff_t *, unsigned char *, int *, int *);
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
#line 1873 "argilectx.arg"
static void search_in_with(argile_list_t *, argile_code_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
#line 1885 "argilectx.arg"
static void search_in_with_2(argile_list_t *, argile_call_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
#line 1957 "argilectx.arg"
static void split_op(char *, int, int);
/** :split op <text str> <int len> <int optoken>: -> nothing **/
#line 2033 "argilectx.arg"
static argile_list_t * new_range(unsigned int, unsigned int);
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/

#line 198 "argilectx.arg"
argile_t argile = ((argile_t){0});

#line 204 "argilectx.arg"
char * argile_get_version()
/** :argile_get_version: -> text **/
{
#line 206 "argilectx.arg"
  return "libargile"" (Argile compiler library) version "VERSION;
}

#line 215 "argilectx.arg"
int argile_init()
/** :argile_init: -> int **/
{
#line 216 "argilectx.arg"
  memset(&argile, 0, sizeof(*&argile));
  (argile).colpertab = 8;
  (argile).maxmatch = 500;
  (argile).maxcomp = 1000;
  (argile).maxgen = 500;
  (argile).maxreject = 5;
  (argile).next_type = ((int)ARGILE_NEXT_TYPE);
  ((argile).enc_utf8).charsize = (void *)&argile_utf8_charsize;
  ((argile).enc_utf8).charat = (void *)&argile_utf8_charat;
  (argile).output = (void *)&argile_output_file;
  (argile).output_data = stdout;
  (argile).output_name = "standard output";
  (argile).output_line = 1;
  (argile).last_input_line = 1;
  (argile).next_input_buff = argile_buff_new(512);
  (argile).get_comments = 1;
#line 233 "argilectx.arg"
  argile_add_keyword("auto");
  argile_add_keyword("break");
  argile_add_keyword("case");
  argile_add_keyword("char");
  argile_add_keyword("const");
  argile_add_keyword("continue");
  argile_add_keyword("default");
  argile_add_keyword("do");
  argile_add_keyword("double");
  argile_add_keyword("else");
  argile_add_keyword("enum");
  argile_add_keyword("extern");
  argile_add_keyword("float");
  argile_add_keyword("for");
  argile_add_keyword("goto");
  argile_add_keyword("if");
  argile_add_keyword("int");
  argile_add_keyword("long");
  argile_add_keyword("register");
  argile_add_keyword("return");
  argile_add_keyword("short");
  argile_add_keyword("signed");
  argile_add_keyword("sizeof");
  argile_add_keyword("static");
  argile_add_keyword("struct");
  argile_add_keyword("switch");
  argile_add_keyword("typedef");
  argile_add_keyword("union");
  argile_add_keyword("unsigned");
  argile_add_keyword("void");
  argile_add_keyword("volatile");
  argile_add_keyword("while");
  argile_add_reserved("anon_arg");
  argile_add_reserved("anon_va");
  return 0;
}

#line 273 "argilectx.arg"
void argile_uninit()
/** :argile_uninit: -> nothing **/
{
#line 277 "argilectx.arg"
  int i_2 = 0;

#line 274 "argilectx.arg"
  argile_choke_leaks();
  if (((argile).error != NULL)) {
    argile_dbg_free((argile).error);
  } //;
#line 278 "argilectx.arg"
  for (i_2 = 0; (i_2 < 512); (i_2)++) {
    argile_list_del(((argile).types)[i_2]);
  };
  if ((((argile).main != NULL) && is_not_included((argile).main))) {
    argile_code_del((argile).main);
  } //;
#line 287 "argilectx.arg"
  for (i_2 = 0; (i_2 < 1024); (i_2)++) {
    argile_list_del(((argile).ids)[i_2]);
  };
#line 289 "argilectx.arg"
  for (i_2 = 0; (i_2 < 4096); (i_2)++) {
    argile_list_del(((argile).defs)[i_2]);
  };
#line 291 "argilectx.arg"
  argile_list_del((argile).used);
  argile_list_del((argile).mods);
  argile_list_del((argile).file_path);
  argile_list_del((argile).som_path);
  argile_list_del((argile).globally);
  argile_list_del((argile).includes);
  argile_list_del((argile).sysincludes);
  argile_list_del((argile).op_ranges);
  argile_list_del((argile).options);
  argile_list_del((argile).keywords);
  argile_list_del((argile).reserved);
  argile_list_del((argile).warns);
  argile_list_del((argile).comments);
  argile_buff_del((argile).next_input_buff);
  memset(&argile, 0, sizeof(*&argile));
}

#line 314 "argilectx.arg"
char * argile_get_option(char * opt)
/** :argile_get_option <text opt>: -> text **/
{
#line 315 "argilectx.arg"
  argile_list_t * lo;

#line 315 "argilectx.arg"
  lo = (argile).options;
  while (!(((lo == NULL) || (((argile_list_t *)lo)->next == NULL)))) {
    if ((strcmp(*((char * *)&((argile_list_t *)lo)->data), opt) == 0)) {
#line 470 "./argrt/std.argl"
      return *((char * *)&((argile_list_t *)((argile_list_t *)lo)->next)->data);
    } //;
#line 318 "argilectx.arg"
    lo = ((argile_list_t *)lo)->next;
  };
#line 319 "argilectx.arg"
  return (char *)0;
}

#line 328 "argilectx.arg"
int argile_parse(void * data)
/** :argile_parse <any data>: -> int **/
{
#line 345 "argilectx.arg"
  int ret = 0;

#line 330 "argilectx.arg"
  (argile).input_data = data;
  (argile).input_ended = 0;
  (argile).separator = 0;
  (argile).new_line = 1;
  (argile).indents = ((argile_list_t *)0);
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
  (((argile).loc).start).row = 1;
  (((argile).loc).start).col = 0;
  (((argile).loc).end).row = 1;
  (((argile).loc).end).col = 0;
  (argile).linebuff = argile_buff_new(0);
  argile_resurrect();
#line 345 "argilectx.arg"
  ret = argile_yyparse();
#line 348 "argilectx.arg"
  ((((argile).loc).end).row)--;
  argile_buff_del((argile).linebuff);
#line 349 "argilectx.arg"
  (argile).linebuff = ((argile_buff_t *)0);
  argile_list_del((argile).indents);
#line 350 "argilectx.arg"
  (argile).indents = ((argile_list_t *)0);
  argile_list_del((argile).tokens);
#line 351 "argilectx.arg"
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
#line 354 "argilectx.arg"
  if (((argile).error)) {
    argile_choke_leaks();
    if ((((argile).main) && (((argile).main)->calls))) {
      ((argile).main)->calls = ((argile_list_t *)0);
    } //;
#line 358 "argilectx.arg"
    return -1;
  } //;
#line 359 "argilectx.arg"
  argile_forget_leaks();
  attribute_comments_to_calls();
  return ret;
}

#line 363 "argilectx.arg"
static void attribute_comments_to_calls()
/** :attribute comments to calls: -> nothing **/
{
  argile_list_t * lcall;
  argile_list_t * lcomm;

#line 364 "argilectx.arg"
  if (!((argile).get_comments)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 365 "argilectx.arg"
  if (((argile).main == NULL)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 366 "argilectx.arg"
  lcall = ((argile).main)->calls;
  lcomm = argile_list_start((argile).comments);
  while (!(((lcall == NULL) || (lcomm == NULL)))) {
    comment_t * comm = ((comment_t *)0);
    argile_pos_t * pcomm = ((argile_pos_t *)0);

#line 369 "argilectx.arg"
    comm = *((comment_t * *)&((argile_list_t *)lcomm)->data);
    pcomm = &(comm)->pos;
#line 373 "argilectx.arg"
    while (!(((lcall == NULL) || argile_pos_su_argile_pos(&((*((argile_call_t * *)&((argile_list_t *)lcall)->data))->loc).start, pcomm)))) {
#line 487 "./argrt/std.argl"
      lcall = ((argile_list_t *)lcall)->next;
    };
#line 374 "argilectx.arg"
    if (!((lcall == NULL))) {
      argile_call_t * call = ((argile_call_t *)0);

#line 375 "argilectx.arg"
      call = *((argile_call_t * *)&((argile_list_t *)lcall)->data);
      if (((call)->comment)) {
        argile_dbg_free((call)->comment);
      } //;
#line 378 "argilectx.arg"
      (call)->comment = (comm)->txt;
      (comm)->txt = (char *)0;
    } //;
    lcomm = ((argile_list_t *)lcomm)->next;
  };
}

#line 393 "argilectx.arg"
int argile_compile()
/** :argile_compile: -> int **/
{
#line 394 "argilectx.arg"
  int r = 0;

#line 394 "argilectx.arg"
  r = argile_compile_as((argile_type_t)ARGILE_TYPE_ANYTHING);
  argile_add_gstats();
  return r;
}

#line 404 "argilectx.arg"
int argile_compile_as(argile_type_t t)
/** :argile_compile_as <argile type t>: -> int **/
{
#line 405 "argilectx.arg"
  if (!(((argile).main))) {
#line 470 "./argrt/std.argl"
    return 0;
  } //;
#line 406 "argilectx.arg"
  return argile_code_compile((argile).main, t);
}

#line 413 "argilectx.arg"
void argile_add_comment(char * txt, int line, int col)
/** :argile_add_comment <text txt> <int line> <int col>: -> nothing **/
{
#line 417 "argilectx.arg"
  comment_t * cmt = ((comment_t *)0);

#line 414 "argilectx.arg"
  if ((*&(txt)[0] != *&(":")[0])) {
    argile_dbg_free(txt);
    return;
  } //;
#line 417 "argilectx.arg"
  cmt = ((comment_t *)memset(argile_dbg_malloc(sizeof(comment_t)), 0, sizeof(comment_t)));
  (cmt)->txt = txt;
  ((cmt)->pos).row = line;
  ((cmt)->pos).col = col;
  argile_list_append(&(argile).comments, argile_list_new(cmt, (void *)&comment));
}

#line 431 "argilectx.arg"
void argile_add_keyword(char * word)
/** :argile_add_keyword <text word>: -> nothing **/
{
#line 432 "argilectx.arg"
  unsigned int hash = 0;

#line 432 "argilectx.arg"
  hash = (argile_hash(word) % 1024);
  argile_list_prepend(&((argile).ids)[hash], argile_list_new(word, ((argile_deleter_t)0)));
  argile_list_prepend(&(argile).keywords, argile_list_new(word, ((argile_deleter_t)0)));
}

#line 441 "argilectx.arg"
void argile_add_reserved(char * word_2)
/** :argile_add_reserved <text word>: -> nothing **/
{
#line 442 "argilectx.arg"
  unsigned int hash = 0;

#line 442 "argilectx.arg"
  hash = (argile_hash(word_2) % 1024);
  argile_list_prepend(&((argile).ids)[hash], argile_list_new(word_2, ((argile_deleter_t)0)));
  argile_list_prepend(&(argile).reserved, argile_list_new(word_2, ((argile_deleter_t)0)));
}

#line 453 "argilectx.arg"
void argile_gencode(char * header)
/** :argile_gencode <text header>: -> nothing **/
{
#line 454 "argilectx.arg"
  argile_list_t * lc;

#line 455 "argilectx.arg"
  if (((argile).globally != NULL)) {
#line 457 "argilectx.arg"
    for (lc = argile_list_end((argile).globally); (lc); lc = ((argile_list_t *)lc)->prev) {
      argile_code_t * code = ((argile_code_t *)0);

#line 458 "argilectx.arg"
      code = *((argile_code_t * *)&((argile_list_t *)lc)->data);
      if (!((code)->compiled)) {
        unsigned char old;

#line 460 "argilectx.arg"
        old = (argile).main_only;
        (argile).main_only = 0;
        argile_code_compile(code, (code)->type);
        (argile).main_only = old;
      } //;
#line 464 "argilectx.arg"
      argile_code_gencode(code);
    };
#line 465 "argilectx.arg"
    argile_puts("\n");
  } //;
  argile_code_pregen_ids((argile).main);
  argile_find_all_autoparams();
#line 470 "argilectx.arg"
  if ((header)) {
    argile_printf("#include \"%s\"\n\n", header);
  } //;
#line 472 "argilectx.arg"
  else {
    argile_gen_header((char *)0);
  };
#line 476 "argilectx.arg"
  argile_code_gen_typedefs((argile).main, 1);
#line 479 "argilectx.arg"
  argile_code_gen_enums((argile).main, 1);
#line 482 "argilectx.arg"
  argile_code_gen_structs_and_unions((argile).main, 1);
#line 485 "argilectx.arg"
  argile_code_gen_protos((argile).main, 1);
#line 488 "argilectx.arg"
  argile_code_gen_vars((argile).main, 0);
  for (lc = (argile).globally; (lc); lc = ((argile_list_t *)lc)->next) {
    argile_code_gen_vars(*((argile_code_t * *)&((argile_list_t *)lc)->data), 0);
  };
#line 493 "argilectx.arg"
  argile_code_gen_private_vars((argile).main);
#line 496 "argilectx.arg"
  argile_code_gen_funcs((argile).main);
#line 498 "argilectx.arg"
  if ((argile).do_main) {
#line 500 "argilectx.arg"
    argile_code_gen_main((argile).main);
  } //;
  argile_flush_refs();
}

#line 510 "argilectx.arg"
void argile_gen_header(char * name)
/** :argile_gen_header <text name>: -> nothing **/
{
#line 511 "argilectx.arg"
  int size = 0;
  argile_file_t * file = ((argile_file_t *)0);

#line 514 "argilectx.arg"
  if ((name)) {
    char * s = "";
#line 526 "argilectx.arg"
    int match = 0;
    argile_list_t * lf;

#line 515 "argilectx.arg"
    s = strrchr(name, '/');
    if ((s)) {
#line 470 "./argrt/std.argl"
      name = ((s) + 1);
    } //;
#line 517 "argilectx.arg"
    size = get_word_size_of(name);
#line 527 "argilectx.arg"
    lf = (argile).used;
    for (; (lf); lf = ((argile_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);
#line 535 "argilectx.arg"
      int sz = 0;

#line 529 "argilectx.arg"
      f = *((argile_file_t * *)&((argile_list_t *)lf)->data);
      s = strrchr((f)->path, '/');
      if ((s)) {
        (s)++;
      } //;
#line 533 "argilectx.arg"
      else {
        s = (f)->path;
      };
#line 535 "argilectx.arg"
      sz = get_word_size_of(s);
      if (((sz == size) && (strncmp(s, name, sz) == 0))) {
        (match)++;
        file = f;
      } //;
    };
#line 539 "argilectx.arg"
    if ((match != 1)) {
#line 539 "argilectx.arg"
      file = ((argile_file_t *)0);
    } //;
    argile_puts("#ifndef ");
    print_define(&file, &size, &name);
    argile_puts("\n#define ");
    print_define(&file, &size, &name);
    argile_puts("\n\n");
  } //;
#line 556 "argilectx.arg"
  argile_code_gen_defines((argile).main);
#line 559 "argilectx.arg"
  argile_code_gen_typedefs((argile).main, 0);
#line 562 "argilectx.arg"
  argile_code_gen_includes((argile).main);
#line 565 "argilectx.arg"
  argile_code_gen_enums((argile).main, 0);
#line 568 "argilectx.arg"
  argile_code_gen_structs_and_unions((argile).main, 0);
#line 571 "argilectx.arg"
  if ((name)) {
    argile_code_gen_vars((argile).main, 2);
  } //;
#line 573 "argilectx.arg"
  else {
    argile_code_gen_vars((argile).main, 1);
  };
#line 577 "argilectx.arg"
  argile_code_gen_protos((argile).main, 0);
#line 579 "argilectx.arg"
  if ((name)) {
    argile_puts("#endif /* ");
    print_define(&file, &size, &name);
    argile_puts(" */\n");
  } //;
}

#line 590 "argilectx.arg"
void argile_gen_module(FILE * f)
/** :argile_gen_module <FILE f>: -> nothing **/
{
#line 591 "argilectx.arg"
  argile_buff_t s = ((argile_buff_t){0});
#line 591 "argilectx.arg"
  argile_buff_t t_2 = ((argile_buff_t){0});
  argile_call_t * c = ((argile_call_t *)0);
  char * new_line = "";
#line 595 "argilectx.arg"
  unsigned char old;
#line 597 "argilectx.arg"
  argile_module_t * mod = ((argile_module_t *)0);
#line 629 "argilectx.arg"
  argile_def_t * duse = ((argile_def_t *)0);
  argile_def_t * dinc = ((argile_def_t *)0);
  argile_def_t * dvar = ((argile_def_t *)0);
  argile_def_t * dfunc = ((argile_def_t *)0);
  argile_def_t * dext = ((argile_def_t *)0);
  argile_def_t * dnodecl = ((argile_def_t *)0);
  argile_def_t * dtref = ((argile_def_t *)0);
  argile_def_t * dtraw = ((argile_def_t *)0);

#line 593 "argilectx.arg"
  new_line = (((argile).dump_indent) ? ("\n") : (";\n"));
#line 595 "argilectx.arg"
  old = (argile).use_colors;
  (argile).use_colors = 0;
  mod = argile_getmod("std");
  if ((mod)) {
    argile_list_t * lx;

#line 599 "argilectx.arg"
    lx = ((argile).main)->calls;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
#line 602 "argilectx.arg"
      argile_def_t * d = ((argile_def_t *)0);

#line 601 "argilectx.arg"
      c = *((argile_call_t * *)&((argile_list_t *)lx)->data);
      d = (c)->def;
      if ((((d) && ((d)->dtype == ARGILE_DEF_BIND)) && (((d)->dval).bind)->modulable)) {
        argile_buff_flush(&s);
        argile_call_string(c, 0, &s);
        if (((s).ptr)) {
          if (((c)->comment)) {
            fprintf(f, "(:%s:)\n", (c)->comment);
          } //;
#line 609 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 610 "argilectx.arg"
        fputs(new_line, f);
      } //;
    };
  } //;
#line 611 "argilectx.arg"
  else {
    argile_list_t * p = ((argile_list_t *)0);
    argile_list_t * lx;
#line 621 "argilectx.arg"
    argile_list_t * lp;

#line 613 "argilectx.arg"
    lx = (argile).used;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_file_t * fp = ((argile_file_t *)0);
      argile_code_t * u = ((argile_code_t *)0);

#line 615 "argilectx.arg"
      fp = *((argile_file_t * *)&((argile_list_t *)lx)->data);
#line 617 "argilectx.arg"
      for (u = ((argile).main)->upper; (u); u = (u)->upper) {
        if (((u)->ghost == (fp)->code)) {
          argile_list_prepend(&p, argile_list_new((fp)->path, ((argile_deleter_t)0)));
          break;
        } //;
      };
    };
#line 621 "argilectx.arg"
    lp = p;
    for (; (lp); lp = ((argile_list_t *)lp)->next) {
      fprintf(f, "use \"%s\"%s", *((char * *)&((argile_list_t *)lp)->data), new_line);
    };
#line 624 "argilectx.arg"
    argile_list_del(p);
  };
#line 625 "argilectx.arg"
  if ((((argile).main)->calls)) {
    c = *((argile_call_t * *)&((argile_list_t *)((argile).main)->calls)->data);
  } //;
#line 627 "argilectx.arg"
  else {
    c = ((argile_call_t *)0);
  };
#line 629 "argilectx.arg"
  duse = argile_find_def("std", "use", "", 1);
  dinc = argile_find_def("std", "use", "include", 1);
  dvar = argile_find_def("std", "extdef", "", 1);
  dfunc = argile_find_def("std", "extdef", "func", 1);
  dext = argile_find_def("std", "extern", "", 1);
  dnodecl = argile_find_def("std", "extern", "nodecl", 1);
  dtref = argile_find_def("std", "typeref", "", 1);
  dtraw = argile_find_def("std", "typeraw", "", 1);
  if (((((((((duse) && (dinc)) && (dvar)) && (dfunc)) && (dext)) && (dnodecl)) && (dtref)) && (dtraw))) {
#line 639 "argilectx.arg"
    argile_list_t * lx;

#line 639 "argilectx.arg"
    lx = ((argile).main)->defs;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

#line 641 "argilectx.arg"
      d = *((argile_def_t * *)&((argile_list_t *)lx)->data);
      if (((d)->locall || (d)->private)) {
#line 470 "./argrt/std.argl"
        continue;
      } //;
#line 643 "argilectx.arg"
      if (((d)->dtype == ARGILE_DEF_VAR)) {
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 651 "argilectx.arg"
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, argile_def_gen_id(d), ((argile_list_t *)0), &s);
        } //;
        else {
          argile_syntax_module_call((dvar)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
#line 657 "argilectx.arg"
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 660 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 661 "argilectx.arg"
        fputs(new_line, f);
      } //;
#line 662 "argilectx.arg"
      else if ((((d)->dtype == ARGILE_DEF_FUNC) && ((((d)->dval).code == NULL) || !((((d)->dval).code)->macro)))) {
#line 664 "argilectx.arg"
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 31) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtref)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 671 "argilectx.arg"
        else if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
#line 676 "argilectx.arg"
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, (char *)0, (d)->syntax, &s);
        } //;
        else {
          argile_syntax_module_call((dfunc)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
#line 682 "argilectx.arg"
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 685 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 686 "argilectx.arg"
        fputs(new_line, f);
      } //;
#line 687 "argilectx.arg"
      else if (((d)->maker)) {
        argile_buff_flush(&s);
        argile_call_string((d)->maker, 0, &s);
        if (((s).ptr)) {
          if ((((d)->maker)->comment)) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
#line 693 "argilectx.arg"
          fwrite((s).ptr, (s).len, 1, f);
        } //;
#line 694 "argilectx.arg"
        fputs(new_line, f);
      } //;
    };
  } //;
#line 695 "argilectx.arg"
  if (((s).ptr)) {
    argile_dbg_free((s).ptr);
  } //;
#line 697 "argilectx.arg"
  if (((t_2).ptr)) {
    argile_dbg_free((t_2).ptr);
  } //;
#line 699 "argilectx.arg"
  (argile).use_colors = old;
}

#line 706 "argilectx.arg"
void argile_printf(char * fmt, ...)
/** :argile_printf <text fmt> [...]: -> nothing **/
{
#line 707 "argilectx.arg"
  va_list args;
#line 709 "argilectx.arg"
  int max = 0;

#line 708 "argilectx.arg"
  va_start(args, fmt);
  max = vsnprintf((char *)0, 0, fmt, args);
  va_end(args);
  if (((max)++ > 0)) {
    char * string = "";
#line 714 "argilectx.arg"
    int len = 0;

#line 712 "argilectx.arg"
    string = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt);
    len = vsnprintf(string, max, fmt, args);
    va_end(args);
    if ((len < max)) {
      argile_output(string, len);
    } //;
#line 718 "argilectx.arg"
    else {
      argile_output(string, max);
    };
#line 720 "argilectx.arg"
    argile_dbg_free(string);
  } //;
}

#line 729 "argilectx.arg"
void argile_die(char * fmt_2, ...)
/** :argile_die <text fmt> [...]: -> nothing **/
{
#line 731 "argilectx.arg"
  va_list args;
#line 733 "argilectx.arg"
  int max = 0;

#line 730 "argilectx.arg"
  if (((argile).error)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 732 "argilectx.arg"
  va_start(args, fmt_2);
  max = vsnprintf((char *)0, 0, fmt_2, args);
  va_end(args);
  if (((max)++ > 0)) {
#line 740 "argilectx.arg"
    int len = 0;

#line 736 "argilectx.arg"
    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 64);
    } //;
#line 738 "argilectx.arg"
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_2);
    len = vsnprintf((argile).error, max, fmt_2, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len), (max - len));
    } //;
  } //;
}

#line 745 "argilectx.arg"
static void print_line(char * dst, int len)
/** :print line <text dst> <int len>: -> nothing **/
{
  int ofs = 0;
#line 750 "argilectx.arg"
  int i_2 = 0;

#line 746 "argilectx.arg"
  if (((argile).linebuff == NULL)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 747 "argilectx.arg"
  argile_buff_putc((argile).linebuff, '\0');
  ofs = snprintf(dst, len, "\n%s\n", ((argile).linebuff)->ptr);
  argile_buff_seek((argile).linebuff, (-1));
#line 751 "argilectx.arg"
  if (((((argile).loc).start).row == (((argile).loc).end).row)) {
    while ((i_2 < (((argile).loc).start).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "-");
      (i_2)++;
    };
  } //;
#line 755 "argilectx.arg"
  if ((i_2 < (((argile).loc).end).col)) {
    while ((i_2 < (((argile).loc).end).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "^");
      (i_2)++;
    };
  } //;
#line 759 "argilectx.arg"
  else {
    ofs += snprintf(((dst) + ofs), (len - ofs), "^");
  };
#line 761 "argilectx.arg"
  snprintf(((dst) + ofs), (len - ofs), "-> at \"%s\", line %d", ((((argile).input_name)) ? ((argile).input_name) : ("anonymous input")), (((argile).loc).end).row);
}

#line 771 "argilectx.arg"
void argile_die_again(char * fmt_3, ...)
/** :argile_die_again <text fmt> [...]: -> nothing **/
{
#line 772 "argilectx.arg"
  char * old_death = "";
  va_list args;
#line 775 "argilectx.arg"
  int max = 0;

#line 772 "argilectx.arg"
  old_death = (argile).error;
#line 774 "argilectx.arg"
  va_start(args, fmt_3);
  max = vsnprintf((char *)0, 0, fmt_3, args);
  va_end(args);
  if (((max)++ > 0)) {
#line 782 "argilectx.arg"
    int len_2 = 0;

#line 778 "argilectx.arg"
    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 32);
    } //;
#line 780 "argilectx.arg"
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_3);
    len_2 = vsnprintf((argile).error, max, fmt_3, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len_2), (max - len_2));
    } //;
  } //;
#line 786 "argilectx.arg"
  if (!((old_death == NULL))) {
#line 470 "./argrt/std.argl"
    argile_dbg_free(old_death);
  } //;
}

#line 795 "argilectx.arg"
void argile_die_hard(char * fmt_4, ...)
/** :argile_die_hard <text fmt> [...]: -> nothing **/
{
#line 797 "argilectx.arg"
  va_list args;

#line 796 "argilectx.arg"
  fprintf(stderr, "\n");
#line 798 "argilectx.arg"
  va_start(args, fmt_4);
  vfprintf(stderr, fmt_4, args);
  va_end(args);
  if ((((argile).linebuff) && (((argile).linebuff)->len != 0))) {
    int len_2 = 0;
    char * tmp = "";

#line 802 "argilectx.arg"
    len_2 = ((((argile).linebuff)->len * 2) + 32);
    tmp = ((char *)argile_dbg_malloc(len_2));
    print_line(tmp, len_2);
    fprintf(stderr, "%s\n", tmp);
    argile_dbg_free(tmp);
  } //;
#line 807 "argilectx.arg"
  {
#line 601 "./argrt/std.argl"
    fprintf(stderr, "\n");
    exit(1);
  };
}

#line 816 "argilectx.arg"
void argile_die_at(argile_call_t * at, char * fmt_5, ...)
/** :argile_die_at <call at> <text fmt> [...]: -> nothing **/
{
#line 818 "argilectx.arg"
  va_list args;
#line 820 "argilectx.arg"
  int max = 0;
#line 822 "argilectx.arg"
  argile_buff_t buf = ((argile_buff_t){0});

#line 817 "argilectx.arg"
  if (((argile).error)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 819 "argilectx.arg"
  va_start(args, fmt_5);
  max = vsnprintf((char *)0, 0, fmt_5, args);
  va_end(args);
#line 823 "argilectx.arg"
  if (((max)++ > 0)) {
#line 852 "argilectx.arg"
    int len_2 = 0;

#line 824 "argilectx.arg"
    argile_buff_puts(&buf, "\n  ");
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&("(")[0]);
    } //;
#line 827 "argilectx.arg"
    argile_call_string(at, 1, &buf);
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&(")")[0]);
    } //;
#line 830 "argilectx.arg"
    if ((((at)->context != ARGILE_TYPE_NOTHING) && ((at)->context != ARGILE_TYPE_ANYTHING))) {
#line 832 "argilectx.arg"
      argile_buff_puts(&buf, "\n(expected return type: ");
      argile_typename((at)->context, &buf, (at)->scope);
      argile_buff_puts(&buf, ")");
    } //;
#line 835 "argilectx.arg"
    argile_buff_puts(&buf, "\n=> at \"");
    if ((((at)->scope)->input)) {
      argile_buff_puts(&buf, ((at)->scope)->input);
    } //;
#line 838 "argilectx.arg"
    else {
      argile_buff_puts(&buf, "anonymous input");
    };
#line 840 "argilectx.arg"
    argile_buff_puts(&buf, "\", from line ");
    argile_buff_putn(&buf, (((at)->loc).start).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).start).col);
    argile_buff_puts(&buf, ", to line ");
    argile_buff_putn(&buf, (((at)->loc).end).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).end).col);
    argile_buff_putc(&buf, '\0');
    max += (buf).len;
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_5);
    len_2 = vsnprintf((argile).error, max, fmt_5, args);
    snprintf((((argile).error) + len_2), (max - len_2), "%s", (buf).ptr);
    va_end(args);
    argile_dbg_free((buf).ptr);
    (argile).killer = at;
  } //;
}

#line 862 "argilectx.arg"
void argile_resurrect()
/** :argile_resurrect: -> nothing **/
{
#line 863 "argilectx.arg"
  if (((argile).error)) {
    argile_dbg_free((argile).error);
    (argile).error = (char *)0;
  } //;
}

#line 878 "argilectx.arg"
void argile_def(argile_list_t * syntax, int del_syntax, argile_type_t type, argile_def_type_t dtype, void * dval)
/** :argile_def <list of (argile syntax) syntax> <int del_syntax> <argile type type> <def type dtype> <any dval>: -> nothing **/
{
#line 880 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 882 "argilectx.arg"
  argile_code_def((argile).main, argile_def_new(syntax, del_syntax, type, ((argile_call_t *)0), dtype, dval), 1);
}

#line 893 "argilectx.arg"
void argile_bind(char * synstr, char * modname, char * name_2)
/** :argile_bind <text synstr> <text modname> <text name>: -> nothing **/
{
#line 897 "argilectx.arg"
  argile_list_t * syn;
  unsigned char comp;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_bind_t * bind = ((argile_bind_t *)0);

#line 894 "argilectx.arg"
  if (((argile).error)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 895 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 901 "argilectx.arg"
  if (((((syn = argile_syntax_parse(synstr)) && (comp = (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) && (mod = argile_getmod(modname))) && (bind = argile_module_getbind(mod, name_2)))) {
#line 905 "argilectx.arg"
    argile_type_t type_2;

#line 905 "argilectx.arg"
    type_2 = ((((bind)->type)) ? (*(bind)->type) : (ARGILE_TYPE_NOTHING));
    if ((bind)->deftype) {
      if (((bind)->gettype)) {
        type_2 = (*(bind)->gettype)(NULL);
      } //;
#line 909 "argilectx.arg"
      argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)type_2)));
    } //;
    else {
      argile_def(syn, 1, type_2, ARGILE_DEF_BIND, bind);
    };
  } //;
#line 913 "argilectx.arg"
  else if ((syn)) {
    if (!(comp)) {
      argile_die("binding: %s some parameter type could not compile", synstr);
    } //;
#line 916 "argilectx.arg"
    else if ((mod == NULL)) {
      argile_die("binding: %s: no such module", modname);
    } //;
#line 918 "argilectx.arg"
    else if ((bind == NULL)) {
      argile_die("binding: %s: no such binding in module %s", name_2, modname);
    } //;
#line 920 "argilectx.arg"
    argile_list_del(syn);
  } //;
}

#line 930 "argilectx.arg"
void argile_deftype(char * synstr_2, argile_type_t t_2)
/** :argile_deftype <text synstr> <argile type t>: -> nothing **/
{
  argile_list_t * syn;

#line 931 "argilectx.arg"
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
#line 933 "argilectx.arg"
  syn = argile_syntax_parse(synstr_2);
  if (((syn) && (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) {
#line 936 "argilectx.arg"
    argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)t_2)));
  } //;
  else if ((syn)) {
    argile_die("type definition: %s some parameter type did not compile", synstr_2);
    argile_list_del(syn);
  } //;
}

#line 948 "argilectx.arg"
void argile_implicitize()
/** :argile_implicitize: -> nothing **/
{
#line 950 "argilectx.arg"
  argile_list_t * ldef;

#line 949 "argilectx.arg"
  if (((argile).main == NULL)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 950 "argilectx.arg"
  for (ldef = ((argile).main)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    (*((argile_def_t * *)&((argile_list_t *)ldef)->data))->implicit = 1;
  };
#line 952 "argilectx.arg"
  ((argile).main)->has_weak_defs = 1;
  ((argile).stat).binds = 0;
  ((argile).stat).num_match_try = 0;
}

#line 964 "argilectx.arg"
int argile_typename(argile_type_t type_2, argile_buff_t * buf, argile_code_t * scope)
/** :argile_typename <argile type type> <buff buf> <argile code scope>: -> int **/
{
#line 965 "argilectx.arg"
  argile_buff_t tmp = ((argile_buff_t){0});
  argile_def_t * dtyperef = ((argile_def_t *)0);
  argile_def_t * dtyperaw = ((argile_def_t *)0);
  argile_type_info_t * info = ((argile_type_info_t *)0);
#line 985 "argilectx.arg"
  argile_list_t * cur;
#line 985 "argilectx.arg"
  argile_list_t * prev;
#line 985 "argilectx.arg"
  argile_list_t * next;

#line 966 "argilectx.arg"
  dtyperef = argile_find_def("std", "typeref", "", 0);
  dtyperaw = argile_find_def("std", "typeraw", "", 0);
  info = argile_type_get_info(type_2);
  if (((info) && ((info)->ttype == ARGILE_TYPE_KIND_CTYPE))) {
    if (((((info)->tval).t_ctype).generator)) {
      unsigned char old;

#line 971 "argilectx.arg"
      old = (argile).skip_codes;
      (argile).skip_codes = 1;
      argile_buff_flush(&tmp);
      argile_call_string((((info)->tval).t_ctype).generator, 0, &tmp);
      (argile).skip_codes = old;
      if ((((((int)type_2) >> 31) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
#line 978 "argilectx.arg"
      else if ((((((int)type_2) >> 30) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
#line 980 "argilectx.arg"
      else {
        argile_buff_cat(buf, &tmp);
      };
#line 982 "argilectx.arg"
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
#line 984 "argilectx.arg"
      return 1;
    } //;
  } //;
#line 986 "argilectx.arg"
  argile_code_getdef(scope, ((argile_call_t *)0), &prev, &next);
  while ((cur = argile_code_nextdef(&scope, &prev, &next))) {
    argile_def_t * d = ((argile_def_t *)0);

#line 988 "argilectx.arg"
    d = *((argile_def_t * *)&((argile_list_t *)cur)->data);
    if ((((d)->dtype != ARGILE_DEF_TYPE) || ((d)->type != ARGILE_TYPE_TYPE))) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 991 "argilectx.arg"
    if ((((d)->dval).type == (((int)type_2) & ((1 << 30) - 1)))) {
      if ((((((int)type_2) >> 31) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
#line 996 "argilectx.arg"
      else if ((((((int)type_2) >> 30) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
#line 1000 "argilectx.arg"
      else {
        argile_syntax_string((d)->syntax, buf);
      };
#line 1002 "argilectx.arg"
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
#line 1004 "argilectx.arg"
      return 1;
    } //;
  };
#line 1005 "argilectx.arg"
  argile_buff_putn(buf, ((int)type_2));
#line 1014 "argilectx.arg"
  return 0;
}

#line 1022 "argilectx.arg"
argile_module_t * argile_getmod(char * name_3)
/** :argile_getmod <text name>: -> (argile) module **/
{
#line 1023 "argilectx.arg"
  argile_list_t * lmod;

#line 1023 "argilectx.arg"
  for (lmod = (argile).mods; (lmod); lmod = ((argile_list_t *)lmod)->next) {
    argile_module_t * mod = ((argile_module_t *)0);

#line 1024 "argilectx.arg"
    mod = *((argile_module_t * *)&((argile_list_t *)lmod)->data);
    if ((strcmp(name_3, (mod)->name) == 0)) {
#line 470 "./argrt/std.argl"
      return mod;
    } //;
  };
#line 1026 "argilectx.arg"
  return ((argile_module_t *)0);
}

#line 1034 "argilectx.arg"
void argile_addmod(argile_module_t * mod)
/** :argile_addmod <module mod>: -> nothing **/
{
#line 1035 "argilectx.arg"
  argile_list_prepend(&(argile).mods, argile_list_new(mod, (void *)&argile_module_del));
}

#line 1045 "argilectx.arg"
argile_module_t * argile_loadmod(char * name_4)
/** :argile_loadmod <text name>: -> (argile) module **/
{
#line 1046 "argilectx.arg"
  char * orig = "";
#line 1052 "argilectx.arg"
  char( file[256]);
#line 1055 "argilectx.arg"
  char * base = "";
#line 1064 "argilectx.arg"
  int len_2 = 0;
  int end = 0;
  char( tmp[128]);
#line 1078 "argilectx.arg"
  argile_module_t * mod_2 = ((argile_module_t *)0);
#line 1103 "argilectx.arg"
  argile_list_t * cur;

#line 1046 "argilectx.arg"
  orig = name_4;
#line 1048 "argilectx.arg"
  if ((argile).verbose) {
    fprintf(stderr, "   loading module %s\n", name_4);
  } //;
#line 1053 "argilectx.arg"
  snprintf(((char *)file), sizeof(file), "%s", name_4);
#line 1055 "argilectx.arg"
  base = strrchr(name_4, '/');
  if ((base == NULL)) {
    base = name_4;
  } //;
#line 1058 "argilectx.arg"
  else {
    (base)++;
    if ((*&(base)[0] == 0)) {
      argile_die("load module: cannot load directory ('%s')", name_4);
      return ((argile_module_t *)0);
    } //;
  };
#line 1064 "argilectx.arg"
  len_2 = strlen(base);
  end = ends_by(base, len_2, ".so");
#line 1067 "argilectx.arg"
  if ((end != 0)) {
    len_2 -= end;
    if ((len_2 >= sizeof(tmp))) {
      len_2 = (sizeof(tmp) - 1);
    } //;
#line 1071 "argilectx.arg"
    memcpy(tmp, base, len_2);
    *&(tmp)[len_2] = '\0';
    name_4 = ((char *)tmp);
  } //;
#line 1074 "argilectx.arg"
  else {
    snprintf(((char *)file), sizeof(file), "%s%s", name_4, ".so");
    name_4 = base;
  };
  mod_2 = argile_getmod(name_4);
  if (!((mod_2 == NULL))) {
#line 470 "./argrt/std.argl"
    return mod_2;
  } //;
#line 1081 "argilectx.arg"
  if ((((((argile).som_path) && ((file)[0] != '/')) && (strncmp(((char *)file), "./", 2))) && (strncmp(((char *)file), "../", 3)))) {
#line 1083 "argilectx.arg"
    argile_list_t * cur_2;

#line 1083 "argilectx.arg"
    for (cur_2 = (argile).som_path; (cur_2); cur_2 = ((argile_list_t *)cur_2)->next) {
#line 1085 "argilectx.arg"
      char * try = "";
#line 1087 "argilectx.arg"
      struct stat st;

#line 1084 "argilectx.arg"
      len_2 = (((strlen(*((char * *)&((argile_list_t *)cur_2)->data)) + 1) + strlen(((char *)file))) + 1);
      try = ((char *)argile_dbg_malloc(len_2));
      snprintf(try, len_2, "%s/%s", *((char * *)&((argile_list_t *)cur_2)->data), file);
#line 1088 "argilectx.arg"
      if (!((stat(try, &st)))) {
        snprintf(((char *)file), sizeof(file), "%s", try);
        argile_dbg_free(try);
        break;
      } //;
#line 1092 "argilectx.arg"
      argile_dbg_free(try);
    };
#line 1093 "argilectx.arg"
    if ((cur_2 == NULL)) {
      argile_die("cannot find module '%s'", orig);
      return ((argile_module_t *)0);
    } //;
  } //;
#line 1097 "argilectx.arg"
  mod_2 = argile_module_new(name_4, ((char *)file));
  if (((argile).error)) {
    argile_module_del(mod_2);
    return ((argile_module_t *)0);
  } //;
#line 1101 "argilectx.arg"
  if ((argile).verbose) {
    fprintf(stderr, "   loaded  module(%s) %s\n", name_4, file);
  } //;
#line 1103 "argilectx.arg"
  for (cur = (mod_2)->binds; (cur); cur = ((argile_list_t *)cur)->next) {
    argile_module_loadbind(mod_2, *((argile_bind_t * *)&((argile_list_t *)cur)->data));
    if (((argile).error)) {
      argile_module_del(mod_2);
      return ((argile_module_t *)0);
    } //;
  };
#line 1108 "argilectx.arg"
  argile_addmod(mod_2);
  return mod_2;
}

#line 1111 "argilectx.arg"
static int ends_by(char * str, int n, char * end)
/** :<text str> ends by <int n> <text end>: -> int **/
{
#line 1112 "argilectx.arg"
  int e = 0;

#line 1112 "argilectx.arg"
  e = strlen(end);
  if (((n > e) && (strcmp(((str) + (n - e)), end) == 0))) {
#line 1113 "argilectx.arg"
    return e;
  } //;
#line 1114 "argilectx.arg"
  return 0;
}

#line 1122 "argilectx.arg"
argile_file_t * argile_getfile(argile_file_t * p_argile_file)
/** :argile_getfile <file>: -> (argile) file **/
{
#line 1123 "argilectx.arg"
  argile_list_t * lf;

#line 1123 "argilectx.arg"
  lf = argile_list_search((argile).used, p_argile_file, (void *)&argile_file_eq);
  if ((lf == NULL)) {
#line 470 "./argrt/std.argl"
    return ((argile_file_t *)0);
  } //;
#line 1125 "argilectx.arg"
  return *((argile_file_t * *)&((argile_list_t *)lf)->data);
}

#line 1132 "argilectx.arg"
void argile_addfile(argile_file_t * p_argile_file_2)
/** :argile_addfile <file>: -> nothing **/
{
#line 1133 "argilectx.arg"
  argile_list_prepend(&(argile).used, argile_list_new(p_argile_file_2, (void *)&argile_file_del));
}

#line 1142 "argilectx.arg"
argile_file_t * argile_loadfile(char * path)
/** :argile_loadfile <text path>: -> (argile) file **/
{
#line 1148 "argilectx.arg"
  argile_file_t * file = ((argile_file_t *)0);
#line 1156 "argilectx.arg"
  argile_file_t * old = ((argile_file_t *)0);

#line 1143 "argilectx.arg"
  if ((argile).verbose) {
    {
#line 1147 "argilectx.arg"
      int i = 0;

#line 1147 "argilectx.arg"
      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
#line 1147 "argilectx.arg"
        fprintf(stderr, " ");
      };
    };
#line 1145 "argilectx.arg"
    fprintf(stderr, "   loading file %s\n", path);
  } //;
#line 1148 "argilectx.arg"
  file = try_new_file(path);
  if ((file == NULL)) {
    argile_die("include file: %s: could not find file", path);
    return ((argile_file_t *)0);
  } //;
#line 1152 "argilectx.arg"
  if (((file)->error != 0)) {
    argile_die("%s: %s", path, strerror((file)->error));
    argile_file_del(file);
    return ((argile_file_t *)0);
  } //;
#line 1156 "argilectx.arg"
  old = argile_getfile(file);
  if ((old)) {
    argile_file_del(file);
    add_include((old)->path);
    return old;
  } //;
#line 1175 "argilectx.arg"
  argile_addfile(file);
  argile_file_load(file);
  if (((argile).error)) {
    argile_list_t * lf;

#line 1178 "argilectx.arg"
    lf = (argile).used;
    argile_list_rm(&(argile).used, lf);
    ((argile_list_t *)lf)->next = ((argile_list_t *)0);
    argile_list_del(lf);
    return ((argile_file_t *)0);
  } //;
#line 1183 "argilectx.arg"
  add_include((file)->path);
  if ((argile).verbose) {
    {
#line 1147 "argilectx.arg"
      int i = 0;

#line 1147 "argilectx.arg"
      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
#line 1147 "argilectx.arg"
        fprintf(stderr, " ");
      };
    };
#line 1186 "argilectx.arg"
    fprintf(stderr, "   loaded  file %s\n", (file)->path);
  } //;
#line 1187 "argilectx.arg"
  return file;
}

#line 1189 "argilectx.arg"
static argile_file_t * try_new_file(char * path_2)
/** :try new file <text path>: -> (argile) file **/
{
#line 1193 "argilectx.arg"
  char * base = (char *)0;
  int baselen = 0;
#line 1196 "argilectx.arg"
  argile_list_t * lf;
#line 1208 "argilectx.arg"
  int extlen = 0;
  int libextlen = 0;
#line 1212 "argilectx.arg"
  int pathlen = 0;
#line 1215 "argilectx.arg"
  argile_file_t * file = ((argile_file_t *)0);
#line 1219 "argilectx.arg"
  argile_list_t * lp;

#line 1190 "argilectx.arg"
  if ((*&(path_2)[0] == '/')) {
    return argile_file_new(path_2, ((struct stat*)0));
  } //;
#line 1196 "argilectx.arg"
  lf = (argile).used;
  for (; (lf); lf = ((argile_list_t *)lf)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)lf)->data))->code == (argile).main)) {
      base = (*((argile_file_t * *)&((argile_list_t *)lf)->data))->path;
    } //;
  };
#line 1201 "argilectx.arg"
  if ((base)) {
    char * b = "";

#line 1202 "argilectx.arg"
    b = strrchr(base, '/');
    if ((b)) {
      baselen = ((b) - base);
    } //;
#line 1205 "argilectx.arg"
    else {
      base = ".";
#line 1206 "argilectx.arg"
      baselen = 1;
    };
  } //;
#line 1208 "argilectx.arg"
  extlen = strlen(".arg");
  libextlen = strlen(".argl");
  if ((libextlen > extlen)) {
    extlen = libextlen;
  } //;
#line 1212 "argilectx.arg"
  pathlen = (((1 + strlen(path_2)) + extlen) + 1);
#line 1216 "argilectx.arg"
  if (((base) && (file = try_in_dir(path_2, pathlen, base, baselen)))) {
    return file;
  } //;
  lp = (argile).file_path;
  for (; (lp); lp = ((argile_list_t *)lp)->next) {
    char * dirpath = "";
    int dirlen = 0;

#line 1221 "argilectx.arg"
    dirpath = *((char * *)&((argile_list_t *)lp)->data);
    dirlen = strlen(dirpath);
    file = try_in_dir(path_2, pathlen, dirpath, dirlen);
    if ((file != NULL)) {
#line 470 "./argrt/std.argl"
      return file;
    } //;
  };
#line 1302 "argilectx.arg"
  return ((argile_file_t *)0);
}

#line 1312 "argilectx.arg"
void argile_push_output(argile_inout_t output, void * output_data)
/** :argile_push_output <inout output> <any output_data>: -> nothing **/
{
#line 1313 "argilectx.arg"
  void *(* ptrs);

#line 1313 "argilectx.arg"
  ptrs = ((void *(*))argile_dbg_malloc((5 * sizeof(void *))));
  *&(ptrs)[0] = (argile).output;
  *&(ptrs)[1] = (argile).output_data;
  *&(ptrs)[2] = (argile).output_name;
  *&(ptrs)[3] = ((void *)((long)(argile).output_line));
  *&(ptrs)[4] = ((void *)((long)(argile).refcount));
  argile_list_prepend(&(argile).outctx, argile_list_new(ptrs, (void *)&argile_dbg_free));
  (argile).output = output;
  (argile).output_data = output_data;
  (argile).output_line = 1;
  (argile).refcount = 0;
}

#line 1330 "argilectx.arg"
void argile_pop_output()
/** :argile_pop_output: -> nothing **/
{
  argile_list_t * h;
  void *(* p);

#line 1331 "argilectx.arg"
  if (((argile).refcount != 0)) {
    argile_flush_refs();
  } //;
#line 1333 "argilectx.arg"
  h = argile_list_pop(&(argile).outctx);
  p = ((void *(*))*((void * *)&((argile_list_t *)h)->data.u_anything));
  (argile).output = ((argile_inout_t)(p)[0]);
  (argile).output_data = (p)[1];
  (argile).output_name = ((char *)(p)[2]);
  (argile).output_line = ((int)((long)(p)[3]));
  (argile).refcount = ((int)((long)(p)[4]));
  argile_list_del(h);
}

#line 1348 "argilectx.arg"
void argile_push_color(argile_buff_t * out, char * color)
/** :argile_push_color <buff out> <text color>: -> nothing **/
{
#line 1349 "argilectx.arg"
  if ((((argile).colors == NULL) || (strcmp(color, *((char * *)&((argile_list_t *)(argile).colors)->data)) != 0))) {
    if ((argile).use_colors) {
      argile_buff_puts(out, color);
    } //;
#line 1352 "argilectx.arg"
    if ((argile).daltonism) {
      argile_buff_puts(out, convert_to_daltonism(color));
    } //;
  } //;
#line 1354 "argilectx.arg"
  argile_list_prepend(&(argile).colors, argile_list_new(color, ((argile_deleter_t)0)));
}

#line 1356 "argilectx.arg"
static char * convert_to_daltonism(char * colour)
/** :convert <text colour> to daltonism: -> text **/
{
#line 1357 "argilectx.arg"
  if ((strcmp(colour, "[01;32m") == 0)) {
#line 470 "./argrt/std.argl"
    return "(:O:)";
  } //;
#line 1358 "argilectx.arg"
  if ((strcmp(colour, "[01;31m") == 0)) {
#line 470 "./argrt/std.argl"
    return "(:E:)";
  } //;
#line 1359 "argilectx.arg"
  if ((strcmp(colour, "[01;33m") == 0)) {
#line 470 "./argrt/std.argl"
    return "(:R:)";
  } //;
#line 1360 "argilectx.arg"
  if ((strcmp(colour, "[00;32m") == 0)) {
#line 470 "./argrt/std.argl"
    return "(:W:)";
  } //;
#line 1361 "argilectx.arg"
  if ((strcmp(colour, "[01;37m") == 0)) {
#line 470 "./argrt/std.argl"
    return "(:U:)";
  } //;
#line 1362 "argilectx.arg"
  return "";
}

#line 1371 "argilectx.arg"
void argile_pop_color(argile_buff_t * out_2)
/** :argile_pop_color <buff out>: -> nothing **/
{
#line 1372 "argilectx.arg"
  argile_list_t * head;

#line 1372 "argilectx.arg"
  head = argile_list_pop(&(argile).colors);
  if (((argile).colors)) {
    char * cur = "";

#line 1374 "argilectx.arg"
    cur = *((char * *)&((argile_list_t *)(argile).colors)->data);
    if (((strcmp(cur, *((char * *)&((argile_list_t *)head)->data)) != 0) && (argile).use_colors)) {
      argile_buff_puts(out_2, cur);
    } //;
#line 1377 "argilectx.arg"
    if ((argile).daltonism) {
      argile_buff_puts(out_2, convert_to_daltonism(cur));
    } //;
  } //;
#line 1379 "argilectx.arg"
  else if ((argile).use_colors) {
    argile_buff_puts(out_2, "[0m");
  } //;
#line 1381 "argilectx.arg"
  argile_list_del(head);
}

#line 1389 "argilectx.arg"
void argile_push_token(int tok)
/** :argile_push_token <int tok>: -> nothing **/
{
#line 1390 "argilectx.arg"
  argile_list_append(&(argile).last_token, argile_list_new(((void *)((long)tok)), ((argile_deleter_t)0)));
  if (((argile).tokens == NULL)) {
    (argile).tokens = (argile).last_token;
  } //;
}

#line 1399 "argilectx.arg"
int argile_pop_token()
/** :argile_pop_token: -> int **/
{
  argile_list_t * lt;
#line 1405 "argilectx.arg"
  int t_2 = 0;

#line 1400 "argilectx.arg"
  if (((argile).tokens == NULL)) {
    return 0;
  } //;
#line 1402 "argilectx.arg"
  lt = argile_list_pop(&(argile).tokens);
  if (((argile).tokens == NULL)) {
    (argile).last_token = ((argile_list_t *)0);
  } //;
#line 1405 "argilectx.arg"
  t_2 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_2;
}

#line 1416 "argilectx.arg"
void argile_push_optoken(int token)
/** :argile_push_optoken <int token>: -> nothing **/
{
#line 1417 "argilectx.arg"
  argile_list_append(&(argile).last_optoken, argile_list_new(((void *)((long)token)), ((argile_deleter_t)0)));
  if (((argile).ops_tokens == NULL)) {
    (argile).ops_tokens = (argile).last_optoken;
  } //;
}

#line 1427 "argilectx.arg"
int argile_pop_optoken()
/** :argile_pop_optoken: -> int **/
{
  argile_list_t * lt;
#line 1433 "argilectx.arg"
  int t_2 = 0;

#line 1428 "argilectx.arg"
  if (((argile).ops_tokens == NULL)) {
    return 0;
  } //;
#line 1430 "argilectx.arg"
  lt = argile_list_pop(&(argile).ops_tokens);
  if (((argile).ops_tokens == NULL)) {
    (argile).last_optoken = ((argile_list_t *)0);
  } //;
#line 1433 "argilectx.arg"
  t_2 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_2;
}

#line 1443 "argilectx.arg"
void argile_push_op(char * op)
/** :argile_push_op <text op>: -> nothing **/
{
#line 1444 "argilectx.arg"
  argile_list_append(&(argile).last_op, argile_list_new(op, ((argile_deleter_t)0)));
  if (((argile).ops == NULL)) {
    (argile).ops = (argile).last_op;
  } //;
}

#line 1454 "argilectx.arg"
char * argile_pop_op()
/** :argile_pop_op: -> text **/
{
  argile_list_t * lv;
#line 1460 "argilectx.arg"
  char * val = "";

#line 1455 "argilectx.arg"
  if (((argile).ops == NULL)) {
    return (char *)0;
  } //;
#line 1457 "argilectx.arg"
  lv = argile_list_pop(&(argile).ops);
  if (((argile).ops == NULL)) {
    (argile).last_op = ((argile_list_t *)0);
  } //;
#line 1460 "argilectx.arg"
  val = *((char * *)&((argile_list_t *)lv)->data);
  argile_list_del(lv);
  return val;
}

#line 1470 "argilectx.arg"
void argile_push_indent(int indent)
/** :argile_push_indent <int indent>: -> nothing **/
{
#line 1471 "argilectx.arg"
  if (((indent > -1) && (indent == argile_top_indent()))) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 1472 "argilectx.arg"
  argile_list_prepend(&(argile).indents, argile_list_new(((void *)((long)indent)), ((argile_deleter_t)0)));
}

#line 1480 "argilectx.arg"
int argile_top_indent()
/** :argile_top_indent: -> int **/
{
#line 1481 "argilectx.arg"
  if (((argile).indents == NULL)) {
#line 470 "./argrt/std.argl"
    return -2;
  } //;
#line 1482 "argilectx.arg"
  return *((int *)&((argile_list_t *)(argile).indents)->data.u_int);
}

#line 1490 "argilectx.arg"
int argile_pop_indent()
/** :argile_pop_indent: -> int **/
{
  argile_list_t * ltop;
  int top = 0;

#line 1491 "argilectx.arg"
  if (((argile).indents == NULL)) {
    return -2;
  } //;
#line 1493 "argilectx.arg"
  ltop = argile_list_pop(&(argile).indents);
  top = *((int *)&((argile_list_t *)ltop)->data.u_int);
  argile_list_del(ltop);
  return top;
}

#line 1506 "argilectx.arg"
int argile_yyinput(char * buf_2, int len_2)
/** :argile_yyinput <text buf> <int len>: -> int **/
{
#line 1507 "argilectx.arg"
  if (((argile).input_ended || ((argile).input == NULL))) {
    return 0;
  } //;
#line 1509 "argilectx.arg"
  return (*(argile).input)((argile).input_data, buf_2, len_2);
}

#line 1524 "argilectx.arg"
int argile_yylex_wrapper()
/** :argile_yylex_wrapper: -> int **/
{
#line 1525 "argilectx.arg"
  if (((argile).error)) {
    return 0;
  } //;
#line 1527 "argilectx.arg"
  if (((argile).tokens)) {
    return argile_pop_token();
  } //;
#line 1529 "argilectx.arg"
  if (((argile).ops_tokens)) {
#line 1531 "argilectx.arg"
    *&argile_yylval.string = argile_pop_op();
    return argile_pop_optoken();
  } //;
#line 1533 "argilectx.arg"
  if ((argile).input_ended) {
    return 0;
  } //;
#line 1535 "argilectx.arg"
  return argile_yylex();
}

#line 1558 "argilectx.arg"
void argile_add_leak(void * data_2)
/** :argile_add_leak <any data>: -> nothing **/
{
#line 1559 "argilectx.arg"
  argile_list_prepend(&(argile).leaks, argile_list_new(data_2, (void *)&argile_dbg_free));
}

#line 1567 "argilectx.arg"
void argile_rm_leak(void * data_3)
/** :argile_rm_leak <any data>: -> nothing **/
{
#line 1568 "argilectx.arg"
  argile_list_t * found;

#line 1568 "argilectx.arg"
  found = argile_list_search((argile).leaks, data_3, ((argile_comparer_t)0));
  if ((found)) {
    argile_list_rm(&(argile).leaks, found);
    ((argile_list_t *)found)->del = NULL;
    argile_list_del(found);
  } //;
}

#line 1580 "argilectx.arg"
void argile_choke_leaks()
/** :argile_choke_leaks: -> nothing **/
{
#line 1581 "argilectx.arg"
  argile_list_del((argile).leaks);
  (argile).leaks = ((argile_list_t *)0);
}

#line 1590 "argilectx.arg"
void argile_forget_leaks()
/** :argile_forget_leaks: -> nothing **/
{
#line 1591 "argilectx.arg"
  argile_list_t * ll;
#line 1591 "argilectx.arg"
  argile_list_t * nx;

#line 1592 "argilectx.arg"
  for (ll = (argile).leaks; (ll); ll = nx) {
    nx = ((argile_list_t *)ll)->next;
    argile_dbg_free(ll);
  };
#line 1595 "argilectx.arg"
  (argile).leaks = ((argile_list_t *)0);
}

#line 1602 "argilectx.arg"
void argile_gen_ref(argile_type_t context, argile_type_t type_3)
/** :argile_gen_ref <argile type context> <argile type type>: -> nothing **/
{
#line 1603 "argilectx.arg"
  unsigned char is_ref;
  unsigned char is_raw;
#line 1606 "argilectx.arg"
  unsigned char in_ref;
  unsigned char in_raw;

#line 1603 "argilectx.arg"
  is_ref = (((((int)type_3) >> 31) & 1));
  is_raw = (((((int)type_3) >> 30) & 1));
#line 1606 "argilectx.arg"
  in_ref = (((((int)context) >> 31) & 1));
  in_raw = (((((int)context) >> 30) & 1));
#line 1609 "argilectx.arg"
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  } //;
#line 1611 "argilectx.arg"
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  } //;
#line 1613 "argilectx.arg"
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  } //;
#line 1615 "argilectx.arg"
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  } //;
}

#line 1624 "argilectx.arg"
void argile_ref(int count)
/** :argile_ref <int count>: -> nothing **/
{
#line 1625 "argilectx.arg"
  (argile).refcount += count;
}

#line 1633 "argilectx.arg"
void argile_flush_refs()
/** :argile_flush_refs: -> nothing **/
{
#line 1634 "argilectx.arg"
  if (((argile).refcount < 0)) {
    while ((((argile).refcount)++ != 0)) {
      (*(argile).output)((argile).output_data, "&", 1);
    };
  } //;
#line 1637 "argilectx.arg"
  else if (((argile).refcount > 0)) {
    while ((((argile).refcount)-- != 0)) {
      (*(argile).output)((argile).output_data, "*", 1);
    };
  } //;
#line 1640 "argilectx.arg"
  (argile).refcount = 0;
}

#line 1648 "argilectx.arg"
void argile_output(char * buf_3, int len_3)
/** :argile_output <text buf> <int len>: -> nothing **/
{
#line 1649 "argilectx.arg"
  if (((((argile).gen_lines != 0) && ((argile).outctx == NULL)) && (((argile).next_input_buff)->len > 0))) {
#line 1651 "argilectx.arg"
    unsigned int n_2 = 0;

#line 1651 "argilectx.arg"
    n_2 = ((argile).next_input_buff)->len;
    ((argile).next_input_buff)->len = 0;
    argile_output(((argile).next_input_buff)->ptr, ((int)n_2));
    ((argile).last_input_line)--;
  } //;
#line 1655 "argilectx.arg"
  if ((len_3 > 0)) {
#line 1657 "argilectx.arg"
    int i_2 = 0;

#line 1656 "argilectx.arg"
    argile_flush_refs();
    for (i_2 = 0; ((i_2 <= (len_3 - 1))); (i_2)++) {
      if ((*&(buf_3)[i_2] == '\n')) {
        ((argile).output_line)++;
        ((argile).last_input_line)++;
      } //;
    };
#line 1661 "argilectx.arg"
    (*(argile).output)((argile).output_data, buf_3, len_3);
  } //;
}

#line 1668 "argilectx.arg"
void argile_puts(char * s)
/** :argile_puts <text s>: -> nothing **/
{
#line 1669 "argilectx.arg"
  if ((*&(s)[0] != 0)) {
#line 1669 "argilectx.arg"
    argile_output(s, strlen(s));
  } //;
}

#line 1676 "argilectx.arg"
void argile_putn(int n_2)
/** :argile_putn <int n>: -> nothing **/
{
#line 1677 "argilectx.arg"
  char( s_2[16]);

#line 1678 "argilectx.arg"
  n_2 = snprintf(((char *)s_2), sizeof(s_2), "%d", n_2);
  if (((n_2 > 0) && (n_2 < sizeof(s_2)))) {
    argile_output(((char *)s_2), n_2);
  } //;
}

#line 1687 "argilectx.arg"
void argile_indent()
/** :argile_indent: -> nothing **/
{
#line 1688 "argilectx.arg"
  int i_2 = 0;

#line 1689 "argilectx.arg"
  for (i_2 = 0; (i_2 < (argile).indent); (i_2)++) {
    argile_puts("  ");
  };
}

#line 1697 "argilectx.arg"
unsigned int argile_hash(char * t_3)
/** :argile_hash <text t>: -> nat **/
{
#line 1698 "argilectx.arg"
  unsigned int h = 0;

#line 1699 "argilectx.arg"
  while ((*&(t_3)[0] != 0)) {
    h += ((unsigned int)*&((t_3)++)[0]);
    h += (h << 10);
    h ^= (h >> 6);
  };
#line 1703 "argilectx.arg"
  h += (h << 3);
  h ^= (h >> 11);
  h += (h << 15);
  return h;
}

#line 1716 "argilectx.arg"
int argile_streq(void * a, void * b)
/** :argile_streq <any a> <any b>: -> int **/
{
#line 1717 "argilectx.arg"
  return ((int)(strcmp(((char *)a), ((char *)b)) == 0));
}

#line 1727 "argilectx.arg"
void argile_check_collisions(argile_buff_t * ident_buff)
/** :argile_check_collisions <buff ident_buff>: -> nothing **/
{
#line 1728 "argilectx.arg"
  int num = 2;
  int end_2 = 0;
  unsigned int id = 0;

#line 1729 "argilectx.arg"
  end_2 = id_end_num((ident_buff)->ptr, (ident_buff)->len, &num);
  id = (argile_hash((ident_buff)->ptr) % 1024);
  while ((argile_list_search(((argile).ids)[id], (ident_buff)->ptr, (void *)&argile_streq))) {
#line 1734 "argilectx.arg"
    (ident_buff)->len = ((unsigned int)end_2);
    argile_buff_putc(ident_buff, '_');
    argile_buff_putn(ident_buff, (num)++);
    argile_buff_putc(ident_buff, '\0');
    id = (argile_hash((ident_buff)->ptr) % 1024);
  };
#line 1739 "argilectx.arg"
  argile_list_prepend(&((argile).ids)[id], argile_list_new(argile_dbg_strdup((ident_buff)->ptr), (void *)&argile_dbg_free));
}

#line 1765 "argilectx.arg"
void argile_check_local_collisions(argile_buff_t * ident_buff_2, argile_code_t * code)
/** :argile_check_local_collisions <buff ident_buff> <argile code code>: -> nothing **/
{
#line 1766 "argilectx.arg"
  int min = -1;
#line 1766 "argilectx.arg"
  int max = 1;
  unsigned char found;

#line 1767 "argilectx.arg"
  found = 0;
  while ((code)) {
    argile_list_t * ld;

#line 1770 "argilectx.arg"
    for (ld = (code)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
#line 1773 "argilectx.arg"
      char * id = "";

#line 1771 "argilectx.arg"
      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      if ((d)->locall) {
#line 470 "./argrt/std.argl"
        continue;
      } //;
#line 1773 "argilectx.arg"
      id = (d)->genid;
      if (((id == NULL) && ((d)->param != NULL))) {
        id = ((d)->param)->genid;
      } //;
#line 1776 "argilectx.arg"
      check_id_num(ident_buff_2, id, &found, &min, &max);
    };
#line 1777 "argilectx.arg"
    for (ld = (code)->special_ids; (ld); ld = ((argile_list_t *)ld)->next) {
      check_id_num(ident_buff_2, ((char *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), &found, &min, &max);
    };
#line 1779 "argilectx.arg"
    for (ld = (code)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
      check_call_id_num(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), ident_buff_2, &found, &min, &max);
    };
#line 1781 "argilectx.arg"
    code = (code)->upper;
#line 1793 "argilectx.arg"
  };
#line 1803 "argilectx.arg"
  if (!(found)) {
    unsigned int h = 0;

#line 1804 "argilectx.arg"
    h = (argile_hash((ident_buff_2)->ptr) % 1024);
    if ((argile_list_search(((argile).ids)[h], (ident_buff_2)->ptr, (void *)&argile_streq))) {
      found = 1;
    } //;
  } //;
#line 1807 "argilectx.arg"
  if (found) {
    ((ident_buff_2)->len)--;
    argile_buff_putc(ident_buff_2, '_');
    if ((min > 2)) {
      argile_buff_putn(ident_buff_2, (min - 1));
    } //;
#line 1812 "argilectx.arg"
    else {
      argile_buff_putn(ident_buff_2, (max + 1));
    };
#line 1814 "argilectx.arg"
    argile_buff_putc(ident_buff_2, '\0');
  } //;
}

#line 1821 "argilectx.arg"
void argile_globally(argile_code_t * code_2)
/** :argile_globally <argile code code>: -> nothing **/
{
#line 1822 "argilectx.arg"
  argile_list_prepend(&(argile).globally, argile_list_new(code_2, ((argile_deleter_t)0)));
}

#line 1833 "argilectx.arg"
void argile_search_defs(char * pattern, void (* callback)(argile_def_t *))
/** :argile_search_defs <text pattern> <function (def) callback>: -> nothing **/
{
#line 1834 "argilectx.arg"
  char( is_op[32]);
#line 1846 "argilectx.arg"
  argile_list_t * syntax_2 = ((argile_list_t *)0);
#line 1848 "argilectx.arg"
  char * s_2 = "";

#line 1835 "argilectx.arg"
  memset(&is_op, 0, sizeof(*&is_op));
#line 1837 "argilectx.arg"
  *&(((char *)&is_op))[('!' >> 3)] |= (1 << ('!' & 7));
#line 1837 "argilectx.arg"
  *&(((char *)&is_op))[('#' >> 3)] |= (1 << ('#' & 7));
#line 1837 "argilectx.arg"
  *&(((char *)&is_op))[('$' >> 3)] |= (1 << ('$' & 7));
  *&(((char *)&is_op))[('%' >> 3)] |= (1 << ('%' & 7));
#line 1838 "argilectx.arg"
  *&(((char *)&is_op))[('&' >> 3)] |= (1 << ('&' & 7));
#line 1838 "argilectx.arg"
  *&(((char *)&is_op))[('\'' >> 3)] |= (1 << ('\'' & 7));
  *&(((char *)&is_op))[('*' >> 3)] |= (1 << ('*' & 7));
#line 1839 "argilectx.arg"
  *&(((char *)&is_op))[('+' >> 3)] |= (1 << ('+' & 7));
#line 1839 "argilectx.arg"
  *&(((char *)&is_op))[(',' >> 3)] |= (1 << (',' & 7));
  *&(((char *)&is_op))[('-' >> 3)] |= (1 << ('-' & 7));
#line 1840 "argilectx.arg"
  *&(((char *)&is_op))[('.' >> 3)] |= (1 << ('.' & 7));
#line 1840 "argilectx.arg"
  *&(((char *)&is_op))[('/' >> 3)] |= (1 << ('/' & 7));
  *&(((char *)&is_op))[('<' >> 3)] |= (1 << ('<' & 7));
#line 1841 "argilectx.arg"
  *&(((char *)&is_op))[('=' >> 3)] |= (1 << ('=' & 7));
#line 1841 "argilectx.arg"
  *&(((char *)&is_op))[('>' >> 3)] |= (1 << ('>' & 7));
  *&(((char *)&is_op))[('?' >> 3)] |= (1 << ('?' & 7));
#line 1842 "argilectx.arg"
  *&(((char *)&is_op))[('@' >> 3)] |= (1 << ('@' & 7));
#line 1842 "argilectx.arg"
  *&(((char *)&is_op))[('[' >> 3)] |= (1 << ('[' & 7));
  *&(((char *)&is_op))[('\\' >> 3)] |= (1 << ('\\' & 7));
#line 1843 "argilectx.arg"
  *&(((char *)&is_op))[(']' >> 3)] |= (1 << (']' & 7));
#line 1843 "argilectx.arg"
  *&(((char *)&is_op))[('^' >> 3)] |= (1 << ('^' & 7));
  *&(((char *)&is_op))[('`' >> 3)] |= (1 << ('`' & 7));
#line 1844 "argilectx.arg"
  *&(((char *)&is_op))[('|' >> 3)] |= (1 << ('|' & 7));
#line 1844 "argilectx.arg"
  *&(((char *)&is_op))[('~' >> 3)] |= (1 << ('~' & 7));
#line 1848 "argilectx.arg"
  s_2 = pattern;
  while ((*&(s_2)[0] != 0)) {
#line 1861 "argilectx.arg"
    char * start = "";

#line 1851 "argilectx.arg"
    while ((*&(s_2)[0] == ' ')) {
#line 487 "./argrt/std.argl"
      (s_2)++;
    };
#line 1854 "argilectx.arg"
    while (((*&(s_2)[0] != 0) && (((*&(((char *)&is_op))[(((unsigned char)*&(s_2)[0]) >> 3)] >> (((unsigned char)*&(s_2)[0]) & 7)) & 1) != 0))) {
      char * cpy = "";

#line 1855 "argilectx.arg"
      cpy = ((char *)argile_dbg_malloc(2));
      *&(cpy)[0] = *&(s_2)[0];
#line 1856 "argilectx.arg"
      *&(cpy)[1] = ((char)0);
      argile_list_append(&syntax_2, argile_list_new(argile_syntax_new(ARGILE_SYN_OP, cpy), (void *)&argile_syntax_del));
      (s_2)++;
    };
#line 1861 "argilectx.arg"
    start = s_2;
    while ((((*&(s_2)[0] != 0) && (*&(s_2)[0] != ' ')) && (((*&(((char *)&is_op))[(((unsigned char)*&(s_2)[0]) >> 3)] >> (((unsigned char)*&(s_2)[0]) & 7)) & 1) == 0))) {
#line 487 "./argrt/std.argl"
      (s_2)++;
    };
#line 1863 "argilectx.arg"
    if (s_2>start) {
      char * cpy = "";

#line 1864 "argilectx.arg"
      cpy = ((char *)argile_dbg_malloc((1 + ((s_2) - start))));
      memcpy(cpy, start, ((s_2) - start));
      *&(cpy)[((s_2) - start)] = '\0';
      argile_list_append(&syntax_2, argile_list_new(argile_syntax_new(ARGILE_SYN_WORD, cpy), (void *)&argile_syntax_del));
    } //;
  };
#line 1869 "argilectx.arg"
  syntax_2 = argile_list_start(syntax_2);
  search_in_with(syntax_2, (argile).main, callback);
  argile_list_del(syntax_2);
#line 1885 "argilectx.arg"
}

#line 1908 "argilectx.arg"
int argile_match_or_reject(argile_call_t * c, argile_match_t * m, argile_type_t t_4, char * error)
/** :argile_match_or_reject <call c> <match m> <argile type t> <text error>: -> int **/
{
  argile_type_t mt;

#line 1909 "argilectx.arg"
  if ((argile_match_type(m, t_4))) {
    return 0;
  } //;
#line 1911 "argilectx.arg"
  mt = argile_match_get_type(m);
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * s_2 = ((argile_call_t *)0);

#line 1913 "argilectx.arg"
    s_2 = ((m)->value).call;
    if (((s_2)->type == ARGILE_CALL_EXPLICIT)) {
      argile_call_uncompile_subcalls(s_2, 1);
      (s_2)->def = ((argile_def_t *)0);
      (s_2)->compiled = 0;
      if ((argile_call_compile_as(s_2, t_4))) {
        return 0;
      } //;
    } //;
  } //;
#line 1920 "argilectx.arg"
  argile_call_mismatch(c, t_4, mt, error);
  return 1;
}

#line 1931 "argilectx.arg"
int argile_split_ops(int ops_type, char * str_2, int len_4, char * * lval)
/** :argile_split_ops <int ops_type> <text str> <int len> <(text) & lval>: -> int **/
{
#line 1937 "argilectx.arg"
  unsigned char o;
#line 1937 "argilectx.arg"
  unsigned char w;
  unsigned int c_2 = 0;
#line 1938 "argilectx.arg"
  unsigned int n_2 = 1;
  int i_2 = 0;
#line 1939 "argilectx.arg"
  int li = 0;

#line 1933 "argilectx.arg"
  if (((argile).op_ranges == NULL)) {
    *lval = argile_dbg_strdup(str_2);
    argile_push_token(T_WORD);
    return argile_pop_token();
  } //;
#line 1937 "argilectx.arg"
  w = 0;
#line 1940 "argilectx.arg"
  for (i_2 = 0; ((i_2 < len_4) && (n_2 > 0)); i_2 += n_2) {
    if (((argile).encoding == NULL)) {
      c_2 = ((unsigned int)((unsigned char)*&(str_2)[i_2]));
    } //;
#line 1943 "argilectx.arg"
    else {
      c_2 = (*((argile).encoding)->charat)(((str_2) + i_2), (len_4 - i_2));
      n_2 = (*((argile).encoding)->charsize)(((str_2) + i_2), (len_4 - i_2));
    };
#line 1946 "argilectx.arg"
    o = (argile_is_operator(c_2));
    if (o) {
      if (w) {
        split_op(((str_2) + li), (i_2 - li), T_WORD);
      } //;
#line 1950 "argilectx.arg"
      split_op(((str_2) + i_2), ((int)n_2), ops_type);
      li = i_2;
    } //;
#line 1952 "argilectx.arg"
    else if (!(w)) {
      li = i_2;
    } //;
#line 1954 "argilectx.arg"
    w = !(o);
  };
#line 1955 "argilectx.arg"
  if (w) {
    split_op(((str_2) + li), (i_2 - li), T_WORD);
  } //;
#line 1965 "argilectx.arg"
  *lval = argile_pop_op();
  argile_push_token(argile_pop_optoken());
  return argile_pop_token();
}

#line 1976 "argilectx.arg"
int argile_is_operator(unsigned int ch)
/** :argile_is_operator <nat ch>: -> int **/
{
#line 1977 "argilectx.arg"
  argile_list_t * lr;

#line 1977 "argilectx.arg"
  lr = (argile).op_ranges;
  for (; (lr); lr = ((argile_list_t *)lr)->next) {
    unsigned int(* r);

#line 1979 "argilectx.arg"
    r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
    if ((ch < (r)[0])) {
      return 0;
    } //;
#line 1982 "argilectx.arg"
    if ((ch <= (r)[1])) {
      return 1;
    } //;
  };
#line 1984 "argilectx.arg"
  return 0;
}

#line 1995 "argilectx.arg"
void argile_add_operators(unsigned int a_2, unsigned int b_2)
/** :argile_add_operators <nat a> <nat b>: -> nothing **/
{
#line 1996 "argilectx.arg"
  if ((b_2 == 0)) {
#line 470 "./argrt/std.argl"
    b_2 = a_2;
  } //;
#line 1997 "argilectx.arg"
  if ((b_2 < a_2)) {
    unsigned int c_2 = 0;

#line 1998 "argilectx.arg"
    c_2 = a_2;
    a_2 = b_2;
    b_2 = c_2;
  } //;
#line 2001 "argilectx.arg"
  if (((argile).op_ranges)) {
    unsigned int(* r);
    argile_list_t * lr;
#line 2003 "argilectx.arg"
    argile_list_t * nr;

#line 2004 "argilectx.arg"
    for (lr = (argile).op_ranges; (lr); lr = nr) {
      r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
      nr = ((argile_list_t *)lr)->next;
      if ((a_2 < (r)[0])) {
        if ((((r)[0] != 0) && (b_2 < ((r)[0] - 1)))) {
          argile_list_t * lnu;

#line 2009 "argilectx.arg"
          lnu = new_range(a_2, b_2);
          if ((((argile_list_t *)lr)->prev)) {
            argile_list_link(((argile_list_t *)lr)->prev, lnu);
          } //;
#line 2012 "argilectx.arg"
          else {
            (argile).op_ranges = lnu;
          };
#line 2014 "argilectx.arg"
          argile_list_link(lnu, lr);
          break;
        } //;
#line 2016 "argilectx.arg"
        *&(r)[0] = a_2;
        if ((b_2 <= (r)[1])) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 2018 "argilectx.arg"
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 2020 "argilectx.arg"
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
#line 2022 "argilectx.arg"
      else if ((a_2 <= ((r)[1] + 1))) {
        if ((b_2 <= (r)[1])) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 2024 "argilectx.arg"
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
#line 470 "./argrt/std.argl"
          break;
        } //;
#line 2026 "argilectx.arg"
        a_2 = (r)[0];
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
    };
#line 2029 "argilectx.arg"
    if (((lr == NULL) && (a_2 > (r)[1]))) {
      argile_list_link(argile_list_end((argile).op_ranges), new_range(a_2, b_2));
    } //;
  } //;
#line 2031 "argilectx.arg"
  else {
    (argile).op_ranges = new_range(a_2, b_2);
  };
#line 2033 "argilectx.arg"
}

#line 2049 "argilectx.arg"
argile_def_t * argile_find_def(char * mod_2, char * bnd, char * opt_2, int err)
/** :argile_find_def <text mod> <text bnd> <text opt> <int err>: -> (argile) def **/
{
#line 2050 "argilectx.arg"
  argile_module_t * m_2 = ((argile_module_t *)0);
#line 2055 "argilectx.arg"
  argile_bind_t * b_2 = ((argile_bind_t *)0);
#line 2060 "argilectx.arg"
  unsigned char o;
  argile_code_t * c_2 = ((argile_code_t *)0);

#line 2050 "argilectx.arg"
  m_2 = argile_getmod(mod_2);
  if ((m_2 == NULL)) {
    if ((err != 0)) {
      argile_die("module '%s' not found", mod_2);
    } //;
#line 2054 "argilectx.arg"
    return ((argile_def_t *)0);
  } //;
#line 2055 "argilectx.arg"
  b_2 = argile_module_getbind(m_2, bnd);
  if ((b_2 == NULL)) {
    if ((err)) {
      argile_die("binding '%s' not found in module '%s'", bnd, mod_2);
    } //;
#line 2059 "argilectx.arg"
    return ((argile_def_t *)0);
  } //;
#line 2060 "argilectx.arg"
  o = 0;
#line 2062 "argilectx.arg"
  for (c_2 = (argile).main; (c_2); c_2 = (c_2)->upper) {
    argile_list_t * ld;

#line 2063 "argilectx.arg"
    ld = (c_2)->defs;
    for (; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);

#line 2065 "argilectx.arg"
      d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind == b_2))) {
        if ((((opt_2 == NULL) || (*&(opt_2)[0] == 0)) || (argile_def_has_option(d, opt_2)))) {
          return d;
        } //;
#line 2069 "argilectx.arg"
        o = 1;
      } //;
    };
  };
#line 2070 "argilectx.arg"
  if ((err)) {
    if (o) {
      argile_die("binding '%s' in module '%s' not defined with option '%s'\n  (did you forget to use std ?)", bnd, mod_2, opt_2);
    } //;
#line 2075 "argilectx.arg"
    else {
      argile_die("binding '%s' in module '%s' found, but not defined", bnd, mod_2);
    };
  } //;
#line 2077 "argilectx.arg"
  return ((argile_def_t *)0);
}

#line 2083 "argilectx.arg"
void argile_find_all_autoparams()
/** :argile_find_all_autoparams: -> nothing **/
{
#line 2085 "argilectx.arg"
  argile_list_t * ldef;

#line 2084 "argilectx.arg"
  if (((argile).main == NULL)) {
#line 470 "./argrt/std.argl"
    return;
  } //;
#line 2085 "argilectx.arg"
  ldef = ((argile).main)->defs;
  for (; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

#line 2087 "argilectx.arg"
    d = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
    if ((((d)->dtype == ARGILE_DEF_FUNC) && (((d)->dval).code))) {
      unsigned char loop;

#line 2089 "argilectx.arg"
      loop = 1;
      while (loop) {
        loop = argile_code_find_autoparams(((d)->dval).code);
      };
    } //;
  };
}

void argile_add_gstats()
/** :argile_add_gstats: -> nothing **/
{
#line 2098 "argilectx.arg"
  ((argile).gstat).rejsize += ((argile).stat).rejsize;
  ((argile).gstat).rejmaxsize += ((argile).stat).rejmaxsize;
  ((argile).gstat).hitsize += ((argile).stat).hitsize;
  ((argile).gstat).num_match_eq += ((argile).stat).num_match_eq;
  ((argile).gstat).num_match_try += ((argile).stat).num_match_try;
  ((argile).gstat).num_call_compile_as += ((argile).stat).num_call_compile_as;
  ((argile).gstat).vars += ((argile).stat).vars;
  ((argile).gstat).params += ((argile).stat).params;
  ((argile).gstat).funcs += ((argile).stat).funcs;
  ((argile).gstat).macros += ((argile).stat).macros;
  ((argile).gstat).binds += ((argile).stat).binds;
}

#line 283 "argilectx.arg"
static unsigned char is_not_included(argile_code_t * c_2)
/** :<argile code c> is not included: -> bool **/
{
#line 284 "argilectx.arg"
  argile_list_t * cur;

#line 284 "argilectx.arg"
  for (cur = (argile).used; (cur); cur = ((argile_list_t *)cur)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)cur)->data))->code == c_2)) {
#line 470 "./argrt/std.argl"
      return 0;
    } //;
  };
#line 286 "argilectx.arg"
  return 1;
}

#line 383 "argilectx.arg"
static unsigned char argile_pos_su_argile_pos(argile_pos_t * a_3, argile_pos_t * b_3)
/** :<pos a> > <pos b>: -> bool **/
{
#line 384 "argilectx.arg"
  if (((a_3)->row == (b_3)->row)) {
    return ((a_3)->col > (b_3)->col);
  } //;
#line 386 "argilectx.arg"
  return ((a_3)->row > (b_3)->row);
}

#line 421 "argilectx.arg"
static void comment(comment_t * c_3)
/** :<comment c>: -> nothing **/
{
#line 422 "argilectx.arg"
  if (((c_3)->txt)) {
#line 470 "./argrt/std.argl"
    argile_dbg_free((c_3)->txt);
  } //;
#line 423 "argilectx.arg"
  argile_dbg_free(c_3);
}

#line 547 "argilectx.arg"
static void print_define(argile_file_t * * file, int * size, char * * name)
/** :print define: -> nothing **/
{
#line 548 "argilectx.arg"
  argile_output("_", 1);
  argile_output(*name, *size);
  argile_puts("_HEADER_");
  if ((*file)) {
    argile_printf("_device_%ld_inode_%li_", ((long)(*file)->device), ((long)(*file)->inode));
  } //;
}

#line 518 "argilectx.arg"
static int get_word_size_of(char * t_5)
/** :get word size of <text t>: -> int **/
{
#line 519 "argilectx.arg"
  int size_2 = 0;

#line 520 "argilectx.arg"
  while ((((((*&(t_5)[0] >= 'a') && (*&(t_5)[0] <= 'z')) || ((*&(t_5)[0] >= 'A') && (*&(t_5)[0] <= 'Z'))) || ((*&(t_5)[0] >= '0') && (*&(t_5)[0] <= '9'))) || (*&(t_5)[0] == '_'))) {
#line 524 "argilectx.arg"
    (size_2)++;
#line 524 "argilectx.arg"
    (t_5)++;
  };
#line 525 "argilectx.arg"
  return size_2;
}

#line 1006 "argilectx.arg"
static void write_ref_or_raw_in_with(argile_buff_t * tb, argile_buff_t * out_3, argile_def_t * d, char * name_5)
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
{
#line 1007 "argilectx.arg"
  if ((d)) {
    argile_syntax_module_call((d)->syntax, tb, (char *)0, ((argile_list_t *)0), out_3);
  } //;
#line 1009 "argilectx.arg"
  else {
    argile_buff_puts(out_3, name_5);
    argile_buff_puts(out_3, " to (");
    argile_buff_cat(out_3, tb);
    argile_buff_putc(out_3, *&(")")[0]);
  };
}

#line 1161 "argilectx.arg"
static void add_include(char * p)
/** :add include <text p>: -> nothing **/
{
#line 1162 "argilectx.arg"
  int n_2 = 0;
  char * h = "";
#line 1165 "argilectx.arg"
  int e = 0;

#line 1162 "argilectx.arg"
  n_2 = strlen(p);
  h = ((char *)argile_dbg_malloc((n_2 + 3)));
  memcpy(h, p, n_2);
#line 1166 "argilectx.arg"
  if (((e = ends_by(p, n_2, ".arg")) || (e = ends_by(p, n_2, ".argl")))) {
#line 1168 "argilectx.arg"
    memcpy(((((h) + n_2)) - e), ".h", 3);
  } //;
#line 1169 "argilectx.arg"
  else {
    memcpy(((h) + n_2), ".h", 3);
  };
#line 1171 "argilectx.arg"
  if ((argile_list_search((argile).includes, h, (void *)&argile_streq))) {
    argile_dbg_free(h);
  } //;
#line 1173 "argilectx.arg"
  else {
    argile_list_prepend(&(argile).includes, argile_list_new(h, (void *)&argile_dbg_free));
  };
}

#line 1226 "argilectx.arg"
static argile_file_t * try_in_dir(char * path_3, int plen, char * dir, int dlen)
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
{
#line 1227 "argilectx.arg"
  int trysize = 0;
  char * trypath = "";
#line 1232 "argilectx.arg"
  int end_2 = 0;
  struct stat st;

#line 1227 "argilectx.arg"
  trysize = ((dlen + 1) + plen);
  trypath = ((char *)argile_dbg_malloc(trysize));
  memcpy(trypath, dir, dlen);
  snprintf(((trypath) + dlen), (trysize - dlen), "/%s", path_3);
  strip_useless_slashes_in(trypath);
  end_2 = strlen(trypath);
#line 1234 "argilectx.arg"
  if (doesn_t_end_by_ext(path_3)) {
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".argl");
    if (!((stat(trypath, &st)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);
#line 1239 "argilectx.arg"
      time_t time = st.st_mtime;

#line 1237 "argilectx.arg"
      file_2 = argile_file_new(trypath, &st);
#line 1240 "argilectx.arg"
      snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
      if (!((stat(trypath, &st)))) {
        argile_file_t * srcfile = ((argile_file_t *)0);

#line 1242 "argilectx.arg"
        srcfile = argile_file_new(trypath, &st);
        if (time<st.st_mtime) {
          if (!((argile_list_search((argile).warns, (file_2)->path, (void *)&argile_streq)))) {
            argile_list_prepend(&(argile).warns, argile_list_new(argile_dbg_strdup((file_2)->path), (void *)&argile_dbg_free));
            fprintf(stderr, "%s: warning: %s is ignored (older than %s)\n", "arc", (file_2)->path, trypath);
          } //;
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
#line 1251 "argilectx.arg"
        if ((argile_file_eq(srcfile, (argile).main_file))) {
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
        argile_file_del(srcfile);
        (file_2)->derived = 1;
      } //;
#line 1258 "argilectx.arg"
      argile_dbg_free(trypath);
      return file_2;
    } //;
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
    if (!((stat(trypath, &st)))) {
      argile_file_t * file_2 = ((argile_file_t *)0);

#line 1263 "argilectx.arg"
      file_2 = argile_file_new(trypath, &st);
      argile_dbg_free(trypath);
      return file_2;
    } //;
  } //;
#line 1266 "argilectx.arg"
  *&(trypath)[end_2] = '\0';
  if (!((stat(trypath, &st)))) {
    argile_file_t * file_2 = ((argile_file_t *)0);

#line 1268 "argilectx.arg"
    file_2 = argile_file_new(trypath, &st);
    argile_dbg_free(trypath);
    return file_2;
  } //;
#line 1271 "argilectx.arg"
  argile_dbg_free(trypath);
#line 1300 "argilectx.arg"
  return ((argile_file_t *)0);
}

#line 1272 "argilectx.arg"
static void strip_useless_slashes_in(char * s_2)
/** :strip useless slashes in <text s>: -> nothing **/
{
#line 1273 "argilectx.arg"
  while ((*&(s_2)[0] != 0)) {
    if ((*&(s_2)[0] == '/')) {
      int x = 0;

#line 1276 "argilectx.arg"
      if (!((strncmp(((s_2) + 1), "./", 2)))) {
        x = 3;
        while (!((strncmp(((s_2) + x), "./", 2)))) {
          x += 2;
        };
#line 1280 "argilectx.arg"
        reduce(((s_2) + 1), ((s_2) + x));
      } //;
#line 1281 "argilectx.arg"
      else {
        x = 1;
        while ((*&(s_2)[x] == '/')) {
          (x)++;
        };
#line 1285 "argilectx.arg"
        reduce(((s_2) + 1), ((s_2) + x));
      };
#line 1286 "argilectx.arg"
    } //;
#line 1290 "argilectx.arg"
    (s_2)++;
  };
}

#line 1291 "argilectx.arg"
static unsigned char doesn_t_end_by_ext(char * str_3)
/** :<text str> doesn ' t end by ext: -> bool **/
{
#line 1292 "argilectx.arg"
  int elen = 0;
  int llen = 0;
  int slen = 0;

#line 1292 "argilectx.arg"
  elen = strlen(".arg");
  llen = strlen(".argl");
  slen = strlen(str_3);
  if (((slen > elen) && (strcmp(".arg", ((str_3) + (slen - elen))) == 0))) {
    return 0;
  } //;
#line 1297 "argilectx.arg"
  if (((slen > llen) && (strcmp(".argl", ((str_3) + (slen - llen))) == 0))) {
    return 0;
  } //;
#line 1299 "argilectx.arg"
  return 1;
}

#line 1286 "argilectx.arg"
static void reduce(char * d_2, char * s_3)
/** :reduce <text d> <text s>: -> nothing **/
{
#line 1287 "argilectx.arg"
  while ((*&(s_3)[0] != 0)) {
    *&((d_2)++)[0] = *&((s_3)++)[0];
  };
#line 1289 "argilectx.arg"
  *&(d_2)[0] = *&(s_3)[0];
}

#line 1740 "argilectx.arg"
static int id_end_num(char * s_4, unsigned int n_3, int * num_2)
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
{
#line 1742 "argilectx.arg"
  int i_2 = 0;
#line 1742 "argilectx.arg"
  int u = -1;
  char c_2;

#line 1744 "argilectx.arg"
  for (i_2 = 0; (i_2 < n_3); (i_2)++) {
    if ((*&(s_4)[i_2] == '_')) {
      u = i_2;
    } //;
  };
#line 1747 "argilectx.arg"
  if (((u <= 0) || (*&(s_4)[(u + 1)] == 0))) {
    return (n_3 - 1);
  } //;
#line 1749 "argilectx.arg"
  for (i_2 = (u + 1); (c_2 = *&(s_4)[i_2]); (i_2)++) {
    if (((c_2 < '0') || (c_2 > '9'))) {
      return (n_3 - 1);
    } //;
  };
#line 1752 "argilectx.arg"
  *num_2 = atoi(((s_4) + (u + 1)));
  return u;
}

#line 1782 "argilectx.arg"
static void check_id_num(argile_buff_t * b_4, char * id, unsigned char * found_2, int * min_2, int * max_2)
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
#line 1783 "argilectx.arg"
  int i_2 = 0;

#line 1783 "argilectx.arg"
  i_2 = ((b_4)->len - 1);
  if (((id) && !((strncmp(id, (b_4)->ptr, i_2))))) {
    if ((*&(id)[i_2] == 0)) {
      *found_2 = 1;
    } //;
#line 1787 "argilectx.arg"
    else if ((*&(id)[i_2] == '_')) {
      do {
#line 1788 "argilectx.arg"
        (i_2)++;
      } while (((*&(id)[i_2] >= '0') && (*&(id)[i_2] <= '9')));
#line 1789 "argilectx.arg"
      if ((*&(id)[i_2] == 0)) {
        i_2 = atoi(((id) + (b_4)->len));
        if ((i_2 > *max_2)) {
#line 1791 "argilectx.arg"
          *max_2 = i_2;
        } //;
#line 1792 "argilectx.arg"
        if (((*min_2 < 0) || (i_2 < *min_2))) {
#line 1792 "argilectx.arg"
          *min_2 = i_2;
        } //;
      } //;
    } //;
  } //;
}

#line 1793 "argilectx.arg"
static void check_call_id_num(argile_call_t * p_argile_call, argile_buff_t * b_5, unsigned char * found_3, int * min_3, int * max_3)
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
#line 1794 "argilectx.arg"
  argile_list_t * lm;

#line 1794 "argilectx.arg"
  for (lm = (p_argile_call)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

#line 1795 "argilectx.arg"
    m_2 = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m_2 == NULL)) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 1797 "argilectx.arg"
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      check_call_id_num(((m_2)->value).call, b_5, found_3, min_3, max_3);
    } //;
#line 1799 "argilectx.arg"
    else if (((m_2)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * cons = ((argile_cons_t *)0);

#line 1800 "argilectx.arg"
      cons = ((m_2)->value).cons;
      if (((cons)->ctype == ARGILE_CONS_CODE)) {
        check_id_num(b_5, (((cons)->cvalue).code)->anon, found_3, min_3, max_3);
      } //;
    } //;
  };
}

#line 1873 "argilectx.arg"
static void search_in_with(argile_list_t * syn, argile_code_t * code_3, void (* callback_2)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
{
  argile_list_t * ld;
#line 1882 "argilectx.arg"
  argile_list_t * lc;

#line 1876 "argilectx.arg"
  ld = (code_3)->defs;
  for (; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d_2 = ((argile_def_t *)0);

#line 1878 "argilectx.arg"
    d_2 = *((argile_def_t * *)&((argile_list_t *)ld)->data);
    if (((d_2)->maker == NULL)) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 1880 "argilectx.arg"
    if ((argile_syntax_match((d_2)->syntax, syn))) {
      (*callback_2)(d_2);
    } //;
  };
#line 1882 "argilectx.arg"
  lc = (code_3)->calls;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    search_in_with_2(syn, *((argile_call_t * *)&((argile_list_t *)lc)->data), callback_2);
  };
}

#line 1885 "argilectx.arg"
static void search_in_with_2(argile_list_t * syn_2, argile_call_t * p_argile_call_2, void (* callback_3)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
{
  argile_list_t * lm;

#line 1888 "argilectx.arg"
  lm = (p_argile_call_2)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

#line 1890 "argilectx.arg"
    m_2 = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m_2 == NULL)) {
#line 470 "./argrt/std.argl"
      continue;
    } //;
#line 1892 "argilectx.arg"
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      search_in_with_2(syn_2, ((m_2)->value).call, callback_3);
    } //;
#line 1894 "argilectx.arg"
    else if ((((m_2)->type == ARGILE_MATCH_CONS) && ((((m_2)->value).cons)->ctype == ARGILE_CONS_CODE))) {
#line 1896 "argilectx.arg"
      search_in_with(syn_2, ((((m_2)->value).cons)->cvalue).code, callback_3);
    } //;
  };
}

#line 1957 "argilectx.arg"
static void split_op(char * str_4, int len_5, int optoken)
/** :split op <text str> <int len> <int optoken>: -> nothing **/
{
#line 1958 "argilectx.arg"
  char * cpy = "";

#line 1958 "argilectx.arg"
  cpy = ((char *)argile_dbg_malloc((len_5 + 1)));
  argile_add_leak(cpy);
  memcpy(cpy, str_4, len_5);
  *&(cpy)[len_5] = '\0';
  argile_push_op(cpy);
  argile_push_optoken(optoken);
}

#line 2033 "argilectx.arg"
static argile_list_t * new_range(unsigned int a_4, unsigned int b_6)
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/
{
#line 2034 "argilectx.arg"
  unsigned int(* r);

#line 2034 "argilectx.arg"
  r = ((unsigned int(*))argile_dbg_malloc((2 * sizeof(unsigned int))));
  *&(r)[0] = a_4;
  *&(r)[1] = b_6;
  return argile_list_new(r, (void *)&argile_dbg_free);
}

