#!/bin/sh
##############################################################################
# fix-cvs-timestamps.sh -- fix some file timestamps when downloaded from CVS
#
#   Copyright (C) 2009,2010 the Argile authors
#
#   This software is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This software is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this software.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
#
# This script is used to update timestamps of files generated by Argile
# compiler (e.g. C sources from Argile sources).
#
# When downloading sources from CVS repository, the original timestamps
# of thoses files are changed and compilation will try to regenerate some
# files by calling the command `arc' which is the Argile compiler.
# So it will not be possible to compile the Argile compiler if it is not
# already installed on the host system, unless this script is executed.
#

for dir in argrt libargile modules/std.d compiler; do
    for arg in "$dir"/*.arg; do
	mod=$(echo "$arg"|sed -e "s/\\.arg\$//")
	for ext in c h p argl; do
	    if [ -e "$mod.$ext" ]; then
		echo "touch $mod.$ext"
		touch "$mod.$ext"
	    fi
	done
    done
done
