// generated by: arc -uRNMLP -A ./argrt -o buff.c -H buff.h -m buff.argl buff.arg 
#include "buff.h"

#line 50 "buff.arg"
argile_buff_t * argile_buff_new(unsigned int size)
/** :argile_buff_new <nat size>: -> (argile) buff **/
{
#line 51 "buff.arg"
  argile_buff_t * buff = ((argile_buff_t *)0);

#line 51 "buff.arg"
  buff = ((argile_buff_t *)memset(argile_dbg_malloc(sizeof(argile_buff_t)), 0, sizeof(argile_buff_t)));
  if ((size < 32)) {
#line 464 "./argrt/std.argl"
    size = 32;
  } //;
#line 53 "buff.arg"
  (buff)->ptr = ((char *)argile_dbg_malloc(size));
  (buff)->len = 0;
  (buff)->max = size;
  return buff;
}

#line 63 "buff.arg"
void argile_buff_del(argile_buff_t * self)
/** :argile_buff_del <buff self>: -> nothing **/
{
#line 64 "buff.arg"
  if (!(((self)->ptr == NULL))) {
#line 464 "./argrt/std.argl"
    argile_dbg_free((self)->ptr);
  } //;
#line 65 "buff.arg"
  (self)->ptr = (char *)0;
  argile_dbg_free(self);
}

#line 72 "buff.arg"
void argile_buff_set(argile_buff_t * self_2, char * ptr, unsigned int len, unsigned int max)
/** :argile_buff_set <buff self> <text ptr> <nat len> <nat max>: -> nothing **/
{
#line 73 "buff.arg"
  (self_2)->ptr = ptr;
  (self_2)->len = len;
  if ((len > max)) {
    (self_2)->max = len;
  } else {
    (self_2)->max = max;
  };
}

#line 84 "buff.arg"
void argile_buff_cat(argile_buff_t * self_3, argile_buff_t * append)
/** :argile_buff_cat <buff self> <buff append>: -> nothing **/
{
#line 85 "buff.arg"
  argile_buff_add(self_3, (append)->ptr, (append)->len);
}

#line 93 "buff.arg"
void argile_buff_add(argile_buff_t * self_4, char * ptr_2, unsigned int len_2)
/** :argile_buff_add <buff self> <text ptr> <nat len>: -> nothing **/
{
#line 94 "buff.arg"
  int inc = 0;

#line 94 "buff.arg"
  inc = (len_2 - ((self_4)->max - (self_4)->len));
  if ((inc > 0)) {
#line 464 "./argrt/std.argl"
    argile_buff_grow(self_4, inc);
  } //;
#line 96 "buff.arg"
  memcpy((((self_4)->ptr) + (self_4)->len), ptr_2, len_2);
  (self_4)->len += len_2;
}

#line 103 "buff.arg"
void argile_buff_putc(argile_buff_t * self_5, char ch)
/** :argile_buff_putc <buff self> <byte ch>: -> nothing **/
{
#line 104 "buff.arg"
  if (((self_5)->len >= (self_5)->max)) {
    argile_buff_grow(self_5, ((int)32));
  } //;
#line 106 "buff.arg"
  *&((self_5)->ptr)[(self_5)->len] = ch;
  argile_buff_seek(self_5, 1);
}

#line 113 "buff.arg"
void argile_buff_puts(argile_buff_t * self_6, char * s)
/** :argile_buff_puts <buff self> <text s>: -> nothing **/
{
#line 114 "buff.arg"
  while (((*&(s)[0] != 0) && ((self_6)->len < (self_6)->max))) {
    *&((self_6)->ptr)[(self_6)->len] = *&((s)++)[0];
    argile_buff_seek(self_6, 1);
  };
#line 117 "buff.arg"
  argile_buff_add(self_6, s, ((unsigned int)strlen(s)));
}

#line 123 "buff.arg"
void argile_buff_putn(argile_buff_t * self_7, int num)
/** :argile_buff_putn <buff self> <int num>: -> nothing **/
{
#line 124 "buff.arg"
  char( str[32]);

#line 125 "buff.arg"
  snprintf(((char *)str), sizeof(str), "%i", num);
  argile_buff_puts(self_7, ((char *)str));
}

#line 132 "buff.arg"
void argile_buff_grow(argile_buff_t * self_8, int grow)
/** :argile_buff_grow <buff self> <int grow>: -> nothing **/
{
#line 133 "buff.arg"
  unsigned int newsize = 0;
#line 136 "buff.arg"
  unsigned int mod = 0;

#line 133 "buff.arg"
  newsize = ((self_8)->max + grow);
  if ((newsize < 32)) {
    newsize = 32;
  } //;
#line 136 "buff.arg"
  mod = (grow % 32);
  if ((mod != 0)) {
    newsize += (32 - mod);
  } //;
#line 139 "buff.arg"
  (self_8)->ptr = ((char *)argile_dbg_realloc((self_8)->ptr, newsize));
  (self_8)->max = newsize;
}

#line 148 "buff.arg"
void argile_buff_seek(argile_buff_t * self_9, int offset)
/** :argile_buff_seek <buff self> <int offset>: -> nothing **/
{
#line 149 "buff.arg"
  int newlen = 0;

#line 149 "buff.arg"
  newlen = ((self_9)->len + offset);
  if ((newlen < 0)) {
#line 464 "./argrt/std.argl"
    newlen = 0;
  } //;
#line 151 "buff.arg"
  if ((newlen > (self_9)->max)) {
    (self_9)->len = (self_9)->max;
  } else {
    (self_9)->len = ((unsigned int)newlen);
  };
}

#line 161 "buff.arg"
int argile_buff_find(argile_buff_t * self_10, char p_byte)
/** :argile_buff_find <buff self> <byte>: -> int **/
{
#line 162 "buff.arg"
  int pos = 0;

#line 163 "buff.arg"
  for (pos = 0; (pos < (self_10)->len); (pos)++) {
    if ((*&((self_10)->ptr)[pos] == p_byte)) {
      return pos;
    } //;
  };
#line 166 "buff.arg"
  return -1;
}

#line 172 "buff.arg"
int argile_buff_count(argile_buff_t * self_11, char ch_2)
/** :argile_buff_count <buff self> <byte ch>: -> int **/
{
#line 173 "buff.arg"
  int pos = 0;
#line 173 "buff.arg"
  int count = 0;

#line 174 "buff.arg"
  while ((pos < (self_11)->len)) {
    if ((*&((self_11)->ptr)[(pos)++] == ch_2)) {
      (count)++;
    } //;
  };
#line 177 "buff.arg"
  return count;
}

#line 185 "buff.arg"
void argile_buff_shift(argile_buff_t * self_12, int from, int to, int len_3)
/** :argile_buff_shift <buff self> <int from> <int to> <int len>: -> nothing **/
{
#line 200 "buff.arg"
  int i = 0;

#line 186 "buff.arg"
  if ((len_3 < 0)) {
    from += len_3;
    to += len_3;
    len_3 = (-len_3);
  } //;
#line 190 "buff.arg"
  if ((from < 0)) {
#line 464 "./argrt/std.argl"
    from = 0;
  } //;
#line 191 "buff.arg"
  if ((to < 0)) {
#line 464 "./argrt/std.argl"
    to = 0;
  } //;
#line 192 "buff.arg"
  if ((from >= (self_12)->len)) {
    from = ((self_12)->len - 1);
  } //;
#line 194 "buff.arg"
  if ((to >= (self_12)->len)) {
    to = ((self_12)->len - 1);
  } //;
#line 196 "buff.arg"
  if (((from + len_3) > (self_12)->len)) {
    len_3 = ((self_12)->len - from);
  } //;
#line 198 "buff.arg"
  if (((to + len_3) > (self_12)->len)) {
    len_3 = ((self_12)->len - to);
  } //;
#line 201 "buff.arg"
  while ((((i < len_3) && (from < (self_12)->max)) && (to < (self_12)->max))) {
    *&((self_12)->ptr)[to] = *&((self_12)->ptr)[from];
    (to)++;
#line 203 "buff.arg"
    (from)++;
#line 203 "buff.arg"
    (i)++;
  };
}

#line 209 "buff.arg"
void argile_buff_flush(argile_buff_t * self_13)
/** :argile_buff_flush <buff self>: -> nothing **/
{
#line 209 "buff.arg"
  (self_13)->len = 0;
}

#line 223 "buff.arg"
int argile_buff_cmp(argile_buff_t * a, argile_buff_t * b)
/** :argile_buff_cmp <buff a> <buff b>: -> int **/
{
#line 224 "buff.arg"
  int p = 0;

#line 225 "buff.arg"
  while (((p < (a)->len) && (p < (b)->len))) {
    int diff = 0;

#line 226 "buff.arg"
    diff = ((*&((a)->ptr)[p] & 0xff) - (*&((b)->ptr)[p] & 0xff));
    if ((diff != 0)) {
#line 464 "./argrt/std.argl"
      return diff;
    } //;
#line 228 "buff.arg"
    (p)++;
  };
#line 229 "buff.arg"
  return ((*&((a)->ptr)[p] & 0xff) - (*&((b)->ptr)[p] & 0xff));
}

#line 240 "buff.arg"
void argile_buff_escape(argile_buff_t * self_14, char * toescape, char esc)
/** :argile_buff_escape <buff self> <text toescape> <byte esc>: -> nothing **/
{
#line 241 "buff.arg"
  char( toesc[32]);
#line 243 "buff.arg"
  int i = 0;
  char ch_2;
#line 249 "buff.arg"
  int count = 0;
#line 256 "buff.arg"
  int inc = 0;

#line 242 "buff.arg"
  memset(toesc, 0, sizeof(toesc));
#line 244 "buff.arg"
  for (i = 0; ((ch_2 = *&(toescape)[i])); (i)++) {
    ch_2 &= 0xff;
    *&(((char *)toesc))[(ch_2 >> 3)] |= (1 << (ch_2 & 7));
  };
#line 250 "buff.arg"
  for (i = 0; (i < (self_14)->len); (i)++) {
    ch_2 = (*&((self_14)->ptr)[i] & 0xff);
    if ((((*&(((char *)toesc))[(ch_2 >> 3)] >> (ch_2 & 7)) & 1) != 0)) {
      (count)++;
    } //;
  };
  inc = (count - ((self_14)->max - (self_14)->len));
  if ((inc > 0)) {
    argile_buff_grow(self_14, inc);
  } //;
#line 261 "buff.arg"
  for (i = 0; (i < (self_14)->len); (i)++) {
    ch_2 = (*&((self_14)->ptr)[i] & 0xff);
    if ((((*&(((char *)toesc))[(ch_2 >> 3)] >> (ch_2 & 7)) & 1) != 0)) {
#line 265 "buff.arg"
      int j = 0;

#line 266 "buff.arg"
      for (j = ((self_14)->len - 1); (j >= i); (j)--) {
        *&((self_14)->ptr)[(j + 1)] = *&((self_14)->ptr)[j];
      };
#line 268 "buff.arg"
      ((self_14)->len)++;
      *&((self_14)->ptr)[(i)++] = esc;
    } //;
  };
}

